# Resources

Different sources often offer contradictory arguments, showing the complexity of the problem that we are tackling here. Going through several articles and fine-tuning a few models yourself should help you form your own opinion.


### Getting start

There are so many tutorials for this first step, in both text and video formats, that you can easily find one by just searching on google, civitai, reddit, youtube, or whatever. We just randomly list some of them here.

- [LoRA Training Guide](https://rentry.org/lora_train)
- [Make your own Loras, easy and free](https://civitai.com/models/22530)
- [RFKTR's in-depth guide to Training high quality models](https://civitai.com/articles/397/rfktrs-in-depth-guide-to-training-high-quality-models)
- [How to create near-perfect character and style LoRa's for SDXL 1.0](https://civitai.com/articles/1771/how-to-create-near-perfect-character-and-style-loras-for-sdxl-10-latest-update-07092023)

### Diving deeper

Resources with detailed explanation on the effects of training parameters are much scarce. Suggestions for this block are welcome.

- [bmaltais/LoRA training parameters](https://github.com/bmaltais/kohya_ss/wiki/LoRA-training-parameters): Simple explanation of what each argument in kohya/sd-scripts does
- [THE OTHER LoRA TRAINING RENTRY](https://rentry.org/59xed3): A deep dive into different aspects of training
- [LyCORIS-experiments](https://rentry.org/LyCORIS-experiments): Investigation on transfer between base models and impacts of various training decisions
- [lora training logs & notes - crude science](https://rentry.org/lora-training-science): On U-Net and TextEncoder learning rate
- [A simple guide for VEHICLE LORA](https://civitai.com/articles/822/a-simple-guide-for-vehicle-lora): Captioning for vehicle LoRA
- [followfox blog](https://followfoxai.substack.com/archive?sort=new): This blog contains many interesting experiments on Stable Diffusion fine-tuning


### Paper resources
- [PRIV-Creation/Awesome-Diffusion-Personalization](https://github.com/PRIV-Creation/Awesome-Diffusion-Personalization)
- [Yutong-Zhou-cv/Awesome-Text-to-Image](https://github.com/Yutong-Zhou-cv/Awesome-Text-to-Image)
- [diff-usion/Awesome-Diffusion-Models](https://github.com/diff-usion/Awesome-Diffusion-Models)
