import ctypes

if __name__ == "__main__":
    # 加载Dll
    dll = ctypes.cdll.LoadLibrary('JapaneseCleaner.dll')

    # 由于Ctypes的默认地址位数为32位，而dll为64位环境编译，所以需要先将函数位数设置为64位
    dll.CreateOjt.restype = ctypes.c_uint64 
    dll.extractFullContext.restype = ctypes.c_uint64 

    # 模型路径ctype字符串指针（wchar_t*）
    floder = ctypes.create_unicode_buffer("S:\VSGIT\MoeSS - Release\cleaners")

    # 创建Ojt实例
    dll.CreateOjt(floder)

    # 输入文本ctype字符串指针（wchar_t*）
    chr = ctypes.create_unicode_buffer("授業中に出したら、学生生活終わるなり")

    # 将函数返回值（wchar_t*）转为Python的字符串
    result = ctypes.wstring_at(dll.extractFullContext(chr))

    # 输出结果
    print(result)

