# LoRA train script by @Akegarasu

$config_file = "./config/default.toml"		 # config file | ʹ toml ļָѵ
$sample_prompts = "./config/sample_prompts.txt"		 # prompt file for sample |  prompts ļ, ò

$sdxl = 0        # train sdxl LoRA | ѵ SDXL LoRA
$multi_gpu = 0		 # multi gpu | Կѵ òԿ >= 2 ʹ

# ============= DO NOT MODIFY CONTENTS BELOW | ޸· =====================

# Activate python venv
.\venv\Scripts\activate

$Env:HF_HOME = "huggingface"
$Env:PYTHONUTF8 = 1

$ext_args = [System.Collections.ArrayList]::new()
$launch_args = [System.Collections.ArrayList]::new()

if ($multi_gpu) {
  [void]$launch_args.Add("--multi_gpu")
  [void]$launch_args.Add("--num_processes=2")
}

# run train
$script_name = if ($sdxl) { "sdxl_train_network.py" } else { "train_network.py" }
python -m accelerate.commands.launch $launch_args --num_cpu_threads_per_process=8 "./sd-scripts/$script_name" `
  --config_file=$config_file `
  --sample_prompts=$sample_prompts `
  $ext_args

Write-Output "Train finished"
Read-Host | Out-Null
