# Soil Ph Map – Murcia – 2010

**Description:**  
This dataset contains satellite-derived estimates of soil ph levels in Murcia for the year 2010. It was produced by Siora using an advanced ML model that combines multispectral satellite imagery, topographic, climate, geological, and weather data.

Auxiliary datasets are used to denoise the spectral signal and isolate signatures associated with each nutrient. Based on the strength of the signature, the model estimates the quantity of ph available in the soil.

Siora uses a calibrated spectral model enhanced with supervised machine learning to estimate soil ph content at ~30 m resolution. This approach enables large-scale, repeatable nutrient mapping without the need for physical sampling or lab work.

The dataset is part of a broader time-series release covering five soil parameters (Nitrogen, Phosphorus, Potassium, Organic Carbon, and pH) for Murcia and Ukraine, spanning the years 2000, 2010, and 2020.

Note: This version is shared at 30 m resolution for public research and demonstration purposes. Siora’s standard soil analysis service delivers results at 10 m resolution across full agricultural fields, including field-level nutrient heatmaps and downloadable reports.

**Format:**  
- Format: single-band GeoTIFF (.tif)  
- Resolution: 30 meters  
- Units: unknown  
- Projection: WGS 84 (EPSG:4326)

**Files Included:**  
- `murcia_2010_ph.tif` – Single-band nutrient map  
- `murcia_2010_ph_heatmap.png` – Styled preview  
- `murcia_2010_ph_thumbnail.png` – For web previews  
- `LICENSE.txt` – CC-BY 4.0 license  
- `murcia_2010_ph_1pager.pdf` – Overview and use cases

**Suggested Uses:**  
- Research on nutrient trends and soil health  
- Precision agriculture benchmarking  
- Model training or validation (remote sensing, ML)

**Attribution:**  
This dataset was created by [Siora](https://siora.ai), a provider of instant soil analysis using satellite imagery. If you use this dataset, please cite or link back to our site.

**License:**  
Creative Commons Attribution 4.0 (CC-BY 4.0)  
https://creativecommons.org/licenses/by/4.0/

**More Datasets:**  
You can find related soil nutrient maps for other years and nutrients at:  
[https://siora.ai/open-soil-datasets](https://siora.ai/open-soil-datasets)
