import{s as Sa,n as Ra,o as Ba}from"../chunks/scheduler.f6b352c8.js";import{S as Ea,i as Va,g as p,s as a,r as y,m as I,H as nt,A as ka,h as M,f as s,c as n,j as Ut,u as T,x as i,n as b,E as pt,k as ye,y as c,a as t,v as U,d as r,t as m,w as o}from"../chunks/index.7f38e934.js";import{C as h}from"../chunks/CodeBlock.2a338b68.js";import{H as Te}from"../chunks/Heading.333929c4.js";function va(rt){let j,Ue,Me,re,f,me,C,mt=`在本节中，我们将介绍如何使用 <code>pipeline()</code> 来使用预训练的语音识别模型。
在<a href="../chapter2/asr_pipeline">第 2 单元</a>中，我们介绍了 <code>pipeline()</code> 这种执行语音识别任务的简便方法，
所有的预处理和后处理都在幕后进行，而且它还可以灵活地快速实验 Hugging Face Hub 上的任何预训练检查点。
在本单元中，我们将更深入地探索语音识别模型的不同属性，以及利用它们来处理不同的任务的方法。`,oe,S,ot="如第 3 单元详细介绍的那样，语音识别模型大致分为两类：",he,R,ht="<li>连接时序分类（Connectionist Temporal Classification, CTC）：仅编码器（encoder-only）的模型，顶部带有线性分类（CTC）头</li> <li>序列到序列（Sequence-to-sequence, Seq2Seq）：编码器-解码器（encoder-decoder）模型，编码器和解码器之间带有交叉注意力机制</li>",we,B,wt=`在 2022 年之前，CTC 是这两种架构中更受欢迎的一种，以 encoder-only 模型为主，例如 Wav2Vec2、HuBERT 和 XLSR 在语音的预训练/微调范式中取得了突破。
大公司如 Meta 和 Microsoft 在大量无标签音频数据上对编码器进行了多天甚至数周的预训练。
用户采用一个预训练的检查点，并在少至 <strong>10 分钟</strong> 的有标注的语音数据上进行微调，就可以在下游语音识别任务中取得强大的性能。`,Je,E,Jt="然而，CTC 模型也有其缺点。在编码器上附加一个简单的线性层可以得到一个小巧、快速的完整模型，但可能容易出现语音拼写错误。我们将用 Wav2Vec2 模型演示这一点。",ce,V,je,k,ct='让我们加载 <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> 数据集的一小部分，以展示 Wav2Vec2 的语音转写能力：',de,v,ue,G,jt="<strong>输出：</strong>",Ie,x,be,F,dt="我们可以选择 73 个音频样本中的一个，检查音频样本及其转写：",fe,$,Ce,g,ut="<strong>输出：</strong>",Se,H,Re,W,It=`好的！圣诞节和烤牛肉，听起来很棒！🎄 选择了一个数据样本后，我们现在将一个微调过的检查点加载到 <code>pipeline()</code> 中。
为此，我们将使用官方在 100 小时 LibriSpeech 数据上微调的 <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a> 检查点：`,Be,N,Ee,Z,bt=`接下来，我们将从数据集中取一个示例，并将其数据传递给 pipeline。由于 <code>pipeline</code> 会 <em>消耗</em> 我们传入的字典（意味着它无法被多次读取），
我们将传递数据的副本。这样，我们可以安全地在以下示例中重复使用同一个音频样本：`,Ve,Y,ke,Q,ft="<strong>输出：</strong>",ve,_,Ge,L,Ct="我们可以看到 Wav2Vec2 模型在转写这个样本方面做得相当好——乍一看似乎是正确的。我们将目标和预测放在一起，突出两者的区别：",xe,z,Fe,A,St="将目标文本与预测出的转写进行比较，我们可以看到所有单词 <em>听起来</em> 都是正确的，但有些拼写不准确。例如：",$e,X,Rt="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",ge,q,Bt="这突显出了 CTC 模型的缺点。CTC 模型本质上是一个“仅声学”的模型：它由一个编码器组成，该编码器通过输入的音频计算出隐藏状态，并且由一个线性层将隐藏状态映射到字符：",He,O,Et=`这意味着该系统几乎完全基于它的声学输入（音频中的语音部分）进行预测，因此倾向于以表音的方式进行转写（例如 <em>CHRISTMAUS</em>）。
它对上下文的语言建模重视程度较低，因此容易出现语音拼写错误。一个更智能的模型应该发现 <em>CHRISTMAUS</em> 不是英语中的有效单词，并在进行预测时将其纠正为 <em>CHRISTMAS</em>。
我们的预测还缺少两个重要特征——大小写和标点符号。这限制了该模型的转写的现实应用。`,We,P,Ne,D,Vt=`Seq2Seq 模型来了！正如第 3 单元所概述的，Seq2Seq 模型由编码器和解码器通过交叉注意力机制相连构成。
编码器的作用与以前相同，负责计算音频输入的隐藏状态表示，而解码器的作用则是 <strong>语言模型</strong>。
解码器处理编码器计算出的整个隐藏状态表示序列，并生成相应的文本转写。它会通过语言建模，在推理时通过输入音频的全局上下文实时纠正拼写错误，避免语音预测的问题。`,Ze,K,kt="Seq2Seq 模型有两个缺点：",Ye,ll,vt="<li>解码较慢，因为解码过程是逐步进行的，而不是一次性完成的</li> <li>需要更多的训练数据才能收敛</li>",Qe,el,Gt=`实际上，大量的训练数据一直是语音领域 Seq2Seq 架构进步的瓶颈。带标注的语音数据很难找到，目前最大的带标注的数据集仅有 10,000 小时。
这一切都在 2022 年 <strong>Whisper</strong> 发布时发生了改变。Whisper 是由 OpenAI 的 Alec Radford 等作者在 <a href="https://openai.com/blog/whisper/" rel="nofollow">2022 年 9 月</a> 发布的用于语音识别的预训练模型。
与之前完全在 <strong>无标注</strong> 音频数据上预训练的 CTC 前辈不同，Whisper 是在大量 <strong>有标注</strong> 的音频-转写数据上预训练的，整整有 680,000 小时。`,_e,sl,xt=`这是比用于训练 Wav2Vec 2.0 的无标签音频数据（60,000 小时）多一个数量级的数据。更重要的是，这些预训练数据中有 117,000 小时是多语言（或“非英语”）数据。
这导致了预训练出的检查点可以应用于 96 种以上语言，其中包括许多 <em>低资源</em> 的语言，即这些语言缺乏适合训练的大型数据集。`,Le,tl,Ft=`当扩展到 680,000 小时有标注的预训练数据时，Whisper 模型显示出强大的泛化能力，适用于许多数据集和领域。
预训练检查点取得了能与最先进的语音识别系统相媲美的结果，在 LibriSpeech 的 test-clean 子集上实现了接近 3% 的词错误率（WER），
并在 TED-LIUM 上创造了新的最佳记录，WER 为 4.7%（参考 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper 论文</a> 中的表 8）。`,ze,al,$t="最重要的是 Whisper 能处理长音频样本、对输入噪声有鲁棒性，且能预测带大小写和标点符号的转写。这使其成为实际应用中可选的语音识别系统之一。",Ae,nl,gt=`本节的剩余部分将向您展示如何使用 🤗 Transformers 中的预训练 Whisper 模型进行语音识别。
在许多情况下，预训练的 Whisper 检查点表现出色，我们建议在解决任何语音识别问题时第一步先考虑用它。
通过微调，预训练检查点可以针对特定数据集和语言进行调整，以进一步优化效果，我们将在接下来的 <a href="fine-tuning">微调</a> 小节中演示如何做到这一点。`,Xe,pl,Ht=`Whisper 检查点有五种配置，每种配置的模型大小不同。最小的四个分别在仅英语和多语言数据集上训练，而最大的检查点仅有多语言。
一共九个预训练检查点都可以在 <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a> 上找到。
以下表格总结了这些检查点，并附有 Hub 上模型的链接。“VRAM”表示以最小批次大小（batch size）为 1 时运行模型所需的 GPU 内存。
“Rel Speed”是与最大型号相比的相对速度。根据这些信息，您可以选择最适合您硬件的检查点。`,qe,Ml,Wt='<thead><tr><th>大小</th> <th>参数量</th> <th>VRAM / GB</th> <th>相对速度</th> <th>仅英语</th> <th>多语言</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>mdeium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Oe,il,Nt=`让我们加载 <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> 检查点，它的大小与我们之前使用的 Wav2Vec2 检查点相当。
考虑到我们接下来会做多语言语音识别，我们将加载基础检查点的多语言变体。我们还将模型加载到 GPU（如果有）或 CPU 上，如有必要的话 <code>pipeline()</code> 随后会负责将所有输入/输出从 CPU 移动到 GPU：`,Pe,yl,De,Tl,Zt="好！现在让我们像之前一样转写音频。我们唯一改变的是传递一个额外的参数 <code>max_new_tokens</code>，它告诉模型在进行预测时生成的最大词元数：",Ke,Ul,ls,rl,Yt="<strong>输出：</strong>",es,ml,ss,ol,Qt="轻松搞定！您首先注意到的是大小写和标点符号，这显然比 Wav2Vec2 不区分大小写也不含标点的转写更易读。让我们对比一下转写与目标输出：",ts,hl,as,wl,_t=`Whisper 很好地纠正了我们在 Wav2Vec2 那里看到的语音错误—— <em>Christmas</em> 和 <em>roast</em> 都拼写正确。我们看到模型在转写 <em>SIMILES</em> 时出了错，
误写为 <em>similarly</em>，但这次预测是英语中的有效单词。使用更大的 Whisper 检查点可以帮助进一步减少转写错误，但代价是需要更多的计算和更长的转写时间。`,ns,Jl,Lt=`该模型应当有能力处理 96 种语言，所以现在让我们暂时离开英语语音识别，走向全球 🌎！
<a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a> (MLS) 数据集是 LibriSpeech 数据集的多语言版本，
包含六种语言的带标注音频数据。我们将从 MLS 数据集的西班牙语子集中加载一个样本，使用 <em>流式</em>（streaming）模式，这样我们就不必下载整个数据集：`,ps,cl,Ms,jl,zt="我们再次检查文本转写并试听音频片段：",is,dl,ys,ul,At="<strong>输出：</strong>",Ts,Il,Us,bl,Xt=`这是我们希望通过 Whisper 转写出的目标文本，虽然我们现在知道我们预测的结果可能会比这更好，因为我们的模型还会预测标点和大小写，而参考中没有这些。
让我们将音频样本输入 pipeline 以获得文本预测。需要注意的是，pipeline 会 <em>消耗</em> 我们输入的音频输入字典，即字典不能被重复读取。
为了解决这个问题，我们将传递一个音频样本的 <em>副本</em>，这样我们就可以在后续代码示例中重复使用同一个音频样本：`,rs,fl,ms,Cl,qt="<strong>输出：</strong>",os,Sl,hs,Rl,Ot=`太好了——这看起来与我们的参考文本非常相似（可以说更好，因为它有标点和大小写！）。您会注意到，我们以 <em>生成关键字参数</em>（generate kwarg）的形式传递了 <code>&quot;task&quot;</code>。
将 <code>&quot;task&quot;</code> 设置为 <code>&quot;transcribe&quot;</code> 会迫使 Whisper 执行 <em>语音识别</em> 任务，即转写的语言就是音频中使用的语音。
Whisper 还能够执行与之密切相关的 <em>语音翻译</em> 任务，西班牙语音频可以被翻译成英语文本。要实现这一点，我们将 <code>&quot;task&quot;</code> 设置为 <code>&quot;translate&quot;</code>：`,ws,Bl,Js,El,Pt="<strong>输出：</strong>",cs,Vl,js,kl,Dt=`现在我们知道可以在语音识别和语音翻译之间切换，我们可以根据需要选择任务。
要么我们从 X 语言的音频识别到同一语言 X 的文本（例如，西班牙语音频到西班牙语文本），要么我们从任何语言 X 的音频翻译到英文文本（例如，西班牙语音频到英文文本）。`,ds,vl,Kt='要了解更多关于如何使用 <code>&quot;task&quot;</code> 参数来控制生成文本的属性，请参阅 Whisper base 的 <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">模型卡片</a>。',us,Gl,Is,xl,la="到目前为止，我们一直专注于转写不到 30 秒的短音频样本。但我们也提到过 Whisper 的一个优势是可以处理长音频样本，我们将在这里处理这个任务！",bs,Fl,ea=`让我们通过拼接 MLS 数据集中连续几条样本来创建一个长音频文件。因为 MLS 数据集是通过将长有声读物录音分割成较短片段来整理的，
所以拼接样本是重构较长有声读物段落的一种方法，拼接出的音频在各个样本间应该是连贯的。`,fs,$l,sa="我们将目标音频长度设为 5 分钟，并在达到这个值时停止拼接样本：",Cs,gl,Ss,Hl,ta="<strong>输出：</strong>",Rs,Wl,Bs,Nl,aa="好的！有 5 分钟 17 秒的音频要转写。直接将这个长音频样本输入给模型有两个问题：",Es,Zl,na="<li>Whisper 被设计用于处理 30 秒的样本：少于 30 秒的任何内容都会用静音填充至 30 秒，超过 30 秒的任何内容都会通过切掉多余音频缩短至 30 秒，所以如果我们直接输入我们的音频，我们只会得到前 30 秒的转写</li> <li>Transformer 网络中的内存随序列长度平方增长：输入长度加倍会使内存需求增加四倍，所以传递超长音频文件会导致内存不足（out-of-memory, OOM）错误</li>",Vs,Yl,pa=`在 🤗 Transformers 中进行长篇转写的方式是将输入音频 <em>分块</em>（chunking）为更小、更易管理的段落，每个段落与前一个段落有少量重叠。
这样，我们可以在段落边界处准确地将段落拼接在一起，因为我们可以找到段落之间的重叠并相应地合并转写：`,ks,d,Ma='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers 分块算法。来源：https://huggingface.co/blog/asr-chunking。"/>',vs,w,Mt,Gs,Ia='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',xs,Fs,ba='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',$s,ne,ia="无状态的",it,gs,fa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Hs,Ws,Ca='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ns,pe,ya="批量",yt,u,Ta="博客",Tt,Zs,Ql,Ua="要使用长篇转写，我们在调用 pipeline 时需要添加一个额外参数。这个参数，<code>chunk_length_s</code>，控制分块段落的长度（以秒为单位）。对于 Whisper，30 秒的块是最佳的，因为这符合 Whisper 期望的输入长度。",Ys,_l,ra="要使用批处理，我们需要将 <code>batch_size</code> 参数传递给 pipeline。将所有这些放在一起，我们可以像下面这样转写长音频样本，并进行分块和批处理：",Qs,Ll,_s,zl,ma="<strong>输出：</strong>",Ls,Al,zs,Xl,oa="由于输出相当长（总共 312 个词），我们在这里不会打印整个输出！在 16GB V100 GPU 上，预计上面的代码要运行 3.45 秒，对于 317 秒的音频样本来说相当不错。在 CPU 上，预期大约要跑 30 秒。",As,ql,ha=`Whisper 还能够预测音频数据的片段级 <em>时间戳</em>。这些时间戳指示音频的短片段的开始和结束时间，对于将转写与输入音频对齐特别有用。
比方说我们想为视频提供字幕（closed caption）——我们需要这些时间戳来知道转写的哪一部分对应于视频的某个段落，以便在那个时间显示正确的转写。`,Xs,Ol,wa="启用时间戳预测很简单，我们只需设置参数 <code>return_timestamps=True</code>。时间戳与我们之前使用的分块和批处理方法兼容，所以我们可以直接将时间戳参数附加到我们之前的代码上：",qs,Pl,Os,Dl,Ja="<strong>输出：</strong>",Ps,Kl,Ds,le,ca="瞧！我们有了预测的文本以及相应的时间戳。",Ks,ee,lt,se,ja=`Whisper 是一个强大的用于语音识别和翻译的预训练模型。与 Wav2Vec2 相比，它具有更高的转写准确性，输出包含标点和大小写。
它可用于转写英语和其他 96 种语言的语音，既能处理短音频片段又能通过 <em>分块</em> 处理的较长片段。这些属性使其可以直接用于许多语音识别和翻译任务，无需微调。
<code>pipeline()</code> 方法提供了一种使用一行 API 调用轻松运行推理的方法，还能对生成的预测进行控制。`,et,te,da=`尽管 Whisper 模型在许多高资源语言上表现极佳，但它对于低资源语言，即那些缺乏容易获得的训练数据的语言，转写和翻译准确性较低。
在某些语言的不同口音和方言，包括不同性别、种族、年龄或其他人口统计标准的发言者身上的表现也存在差异（参见 <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper 论文</a>）。`,st,ae,ua=`为了提高在低资源语言、口音或方言上的性能，我们可以将预训练的 Whisper 模型在一小部分适当选择的数据上继续训练，这个过程称为 <em>微调</em>。
我们将展示如何仅使用十小时的额外数据，就能将 Whisper 模型在低资源语言上的性能提高 100% 以上。在下一节中，我们将介绍选择微调数据集的过程。`,tt,ie,at;return f=new Te({props:{title:"语音识别的预训练模型",local:"语音识别的预训练模型",headingTag:"h1"}}),V=new Te({props:{title:"探索 CTC 模型",local:"探索-ctc-模型",headingTag:"h2"}}),v=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),x=new h({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),$=new h({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),H=new h({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),Y=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),_=new h({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),z=new h({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),P=new Te({props:{title:"过渡到 Seq2Seq",local:"过渡到-seq2seq",headingTag:"h2"}}),yl=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),Ul=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),ml=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),hl=new h({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),cl=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),dl=new h({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Il=new h({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),fl=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),Sl=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Bl=new h({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Vl=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),Gl=new Te({props:{title:"长篇转写和时间戳",local:"长篇转写和时间戳",headingTag:"h2"}}),gl=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2xlbmd0aF9pbl9tJTIwJTNEJTIwNSUwQSUwQSUyMyUyMCVFNSVCMCU4NiVFNSU4OCU4NiVFOSU5MiU5RiVFNiU5NSVCMCVFOCVCRCVBQyVFNCVCOCVCQSVFNyVBNyU5MiVFNiU5NSVCMCVFRiVCQyU4OColMjA2MCVFRiVCQyU4OSVFRiVCQyU4QyVFNSU4NiU4RCVFOCVCRCVBQyVFNCVCOCVCQSVFOSU4NyU4NyVFNyU5NCVBOCVFNyU4MiVCOSVFNiU5NSVCMCVFRiVCQyU4OColMjBzYW1wbGluZyUyMHJhdGUlRUYlQkMlODklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcGlwZS5mZWF0dXJlX2V4dHJhY3Rvci5zYW1wbGluZ19yYXRlJTBBdGFyZ2V0X2xlbmd0aF9pbl9zYW1wbGVzJTIwJTNEJTIwdGFyZ2V0X2xlbmd0aF9pbl9tJTIwKiUyMDYwJTIwKiUyMHNhbXBsaW5nX3JhdGUlMEElMEElMjMlMjAlRTklODElOEQlRTUlOEUlODYlRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRUYlQkMlOEMlRTYlOEIlQkMlRTYlOEUlQTUlRTYlQTAlQjclRTYlOUMlQUMlRTclOUIlQjQlRTUlODglQjAlRTklOTUlQkYlRTUlQkElQTYlRTglQkUlQkUlRTUlODglQjAlRTclOUIlQUUlRTYlQTAlODclMEFsb25nX2F1ZGlvJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwc2FtcGxlJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwbG9uZ19hdWRpby5leHRlbmQoc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCklMEElMjAlMjAlMjAlMjBpZiUyMGxlbihsb25nX2F1ZGlvKSUyMCUzRSUyMHRhcmdldF9sZW5ndGhfaW5fc2FtcGxlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBbG9uZ19hdWRpbyUyMCUzRCUyMG5wLmFzYXJyYXkobG9uZ19hdWRpbyklMEElMEElMjMlMjAlRTclQkIlOTMlRTYlOUUlOUMlRTUlQTYlODIlRTQlQkQlOTUlRUYlQkMlOUYlMEFzZWNvbmRzJTIwJTNEJTIwbGVuKGxvbmdfYXVkaW8pJTIwJTJGJTIwMTYwMDAlMEFtaW51dGVzJTJDJTIwc2Vjb25kcyUyMCUzRCUyMGRpdm1vZChzZWNvbmRzJTJDJTIwNjApJTBBcHJpbnQoZiUyMkxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpcyUyMCU3Qm1pbnV0ZXMlN0QlMjBtaW51dGVzJTIwJTdCc2Vjb25kcyUzQS4yZiU3RCUyMHNlY29uZHMlMjIp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># 将分钟数转为秒数（* 60），再转为采用点数（* sampling rate）</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># 遍历数据集，拼接样本直到长度达到目标</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># 结果如何？</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Wl=new h({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Ll=new h({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),Al=new h({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Pl=new h({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Kl=new h({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),ee=new Te({props:{title:"总结",local:"总结",headingTag:"h2"}}),{c(){j=p("meta"),Ue=a(),Me=p("p"),re=a(),y(f.$$.fragment),me=a(),C=p("p"),C.innerHTML=mt,oe=a(),S=p("p"),S.textContent=ot,he=a(),R=p("ol"),R.innerHTML=ht,we=a(),B=p("p"),B.innerHTML=wt,Je=a(),E=p("p"),E.textContent=Jt,ce=a(),y(V.$$.fragment),je=a(),k=p("p"),k.innerHTML=ct,de=a(),y(v.$$.fragment),ue=a(),G=p("p"),G.innerHTML=jt,Ie=a(),y(x.$$.fragment),be=a(),F=p("p"),F.textContent=dt,fe=a(),y($.$$.fragment),Ce=a(),g=p("p"),g.innerHTML=ut,Se=a(),y(H.$$.fragment),Re=a(),W=p("p"),W.innerHTML=It,Be=a(),y(N.$$.fragment),Ee=a(),Z=p("p"),Z.innerHTML=bt,Ve=a(),y(Y.$$.fragment),ke=a(),Q=p("p"),Q.innerHTML=ft,ve=a(),y(_.$$.fragment),Ge=a(),L=p("p"),L.textContent=Ct,xe=a(),y(z.$$.fragment),Fe=a(),A=p("p"),A.innerHTML=St,$e=a(),X=p("ul"),X.innerHTML=Rt,ge=a(),q=p("p"),q.textContent=Bt,He=a(),O=p("p"),O.innerHTML=Et,We=a(),y(P.$$.fragment),Ne=a(),D=p("p"),D.innerHTML=Vt,Ze=a(),K=p("p"),K.textContent=kt,Ye=a(),ll=p("ol"),ll.innerHTML=vt,Qe=a(),el=p("p"),el.innerHTML=Gt,_e=a(),sl=p("p"),sl.innerHTML=xt,Le=a(),tl=p("p"),tl.innerHTML=Ft,ze=a(),al=p("p"),al.textContent=$t,Ae=a(),nl=p("p"),nl.innerHTML=gt,Xe=a(),pl=p("p"),pl.innerHTML=Ht,qe=a(),Ml=p("table"),Ml.innerHTML=Wt,Oe=a(),il=p("p"),il.innerHTML=Nt,Pe=a(),y(yl.$$.fragment),De=a(),Tl=p("p"),Tl.innerHTML=Zt,Ke=a(),y(Ul.$$.fragment),ls=a(),rl=p("p"),rl.innerHTML=Yt,es=a(),y(ml.$$.fragment),ss=a(),ol=p("p"),ol.textContent=Qt,ts=a(),y(hl.$$.fragment),as=a(),wl=p("p"),wl.innerHTML=_t,ns=a(),Jl=p("p"),Jl.innerHTML=Lt,ps=a(),y(cl.$$.fragment),Ms=a(),jl=p("p"),jl.textContent=zt,is=a(),y(dl.$$.fragment),ys=a(),ul=p("p"),ul.innerHTML=At,Ts=a(),y(Il.$$.fragment),Us=a(),bl=p("p"),bl.innerHTML=Xt,rs=a(),y(fl.$$.fragment),ms=a(),Cl=p("p"),Cl.innerHTML=qt,os=a(),y(Sl.$$.fragment),hs=a(),Rl=p("p"),Rl.innerHTML=Ot,ws=a(),y(Bl.$$.fragment),Js=a(),El=p("p"),El.innerHTML=Pt,cs=a(),y(Vl.$$.fragment),js=a(),kl=p("p"),kl.textContent=Dt,ds=a(),vl=p("p"),vl.innerHTML=Kt,us=a(),y(Gl.$$.fragment),Is=a(),xl=p("p"),xl.textContent=la,bs=a(),Fl=p("p"),Fl.textContent=ea,fs=a(),$l=p("p"),$l.textContent=sa,Cs=a(),y(gl.$$.fragment),Ss=a(),Hl=p("p"),Hl.innerHTML=ta,Rs=a(),y(Wl.$$.fragment),Bs=a(),Nl=p("p"),Nl.textContent=aa,Es=a(),Zl=p("ol"),Zl.innerHTML=na,Vs=a(),Yl=p("p"),Yl.innerHTML=pa,ks=a(),d=p("div"),d.innerHTML=Ma,vs=a(),w=p("p"),Mt=I("给样本分块的优势在于，转写后续的块"),Gs=new nt(!1),xs=I(" 不需要使用之前的块"),Fs=new nt(!1),$s=I(` 的结果。拼接是在我们已经转写了所有块之后在块边界处进行的，所以转写的顺序并不重要。
该算法完全是 `),ne=p("strong"),ne.textContent=ia,it=I("，所以我们甚至可以同时转写块"),gs=new nt(!1),Hs=I(" 和块"),Ws=new nt(!1),Ns=I("！这允许我们 "),pe=p("em"),pe.textContent=ya,yt=I(` 处理块，并通过并行运行模型，与顺序转写相比大大提升计算速度。
要了解更多关于 🤗 Transformers 中分块的知识，请参阅这篇 `),u=p("a"),u.textContent=Ta,Tt=I("。"),Zs=a(),Ql=p("p"),Ql.innerHTML=Ua,Ys=a(),_l=p("p"),_l.innerHTML=ra,Qs=a(),y(Ll.$$.fragment),_s=a(),zl=p("p"),zl.innerHTML=ma,Ls=a(),y(Al.$$.fragment),zs=a(),Xl=p("p"),Xl.textContent=oa,As=a(),ql=p("p"),ql.innerHTML=ha,Xs=a(),Ol=p("p"),Ol.innerHTML=wa,qs=a(),y(Pl.$$.fragment),Os=a(),Dl=p("p"),Dl.innerHTML=Ja,Ps=a(),y(Kl.$$.fragment),Ds=a(),le=p("p"),le.textContent=ca,Ks=a(),y(ee.$$.fragment),lt=a(),se=p("p"),se.innerHTML=ja,et=a(),te=p("p"),te.innerHTML=da,st=a(),ae=p("p"),ae.innerHTML=ua,tt=a(),ie=p("p"),this.h()},l(l){const e=ka("svelte-u9bgzb",document.head);j=M(e,"META",{name:!0,content:!0}),e.forEach(s),Ue=n(l),Me=M(l,"P",{}),Ut(Me).forEach(s),re=n(l),T(f.$$.fragment,l),me=n(l),C=M(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-l77zkn"&&(C.innerHTML=mt),oe=n(l),S=M(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-18w3ej0"&&(S.textContent=ot),he=n(l),R=M(l,"OL",{"data-svelte-h":!0}),i(R)!=="svelte-1cd6na7"&&(R.innerHTML=ht),we=n(l),B=M(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1vgescg"&&(B.innerHTML=wt),Je=n(l),E=M(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-oc5eoz"&&(E.textContent=Jt),ce=n(l),T(V.$$.fragment,l),je=n(l),k=M(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1kyz6ci"&&(k.innerHTML=ct),de=n(l),T(v.$$.fragment,l),ue=n(l),G=M(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1yevus4"&&(G.innerHTML=jt),Ie=n(l),T(x.$$.fragment,l),be=n(l),F=M(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1l57vam"&&(F.textContent=dt),fe=n(l),T($.$$.fragment,l),Ce=n(l),g=M(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1yevus4"&&(g.innerHTML=ut),Se=n(l),T(H.$$.fragment,l),Re=n(l),W=M(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1sop84d"&&(W.innerHTML=It),Be=n(l),T(N.$$.fragment,l),Ee=n(l),Z=M(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1wr4yvi"&&(Z.innerHTML=bt),Ve=n(l),T(Y.$$.fragment,l),ke=n(l),Q=M(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1yevus4"&&(Q.innerHTML=ft),ve=n(l),T(_.$$.fragment,l),Ge=n(l),L=M(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-10241y8"&&(L.textContent=Ct),xe=n(l),T(z.$$.fragment,l),Fe=n(l),A=M(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-dq07i6"&&(A.innerHTML=St),$e=n(l),X=M(l,"UL",{"data-svelte-h":!0}),i(X)!=="svelte-11mc7qy"&&(X.innerHTML=Rt),ge=n(l),q=M(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-zbwrzy"&&(q.textContent=Bt),He=n(l),O=M(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-14bdpsl"&&(O.innerHTML=Et),We=n(l),T(P.$$.fragment,l),Ne=n(l),D=M(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-178f4vl"&&(D.innerHTML=Vt),Ze=n(l),K=M(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-iy3o08"&&(K.textContent=kt),Ye=n(l),ll=M(l,"OL",{"data-svelte-h":!0}),i(ll)!=="svelte-mdyuiu"&&(ll.innerHTML=vt),Qe=n(l),el=M(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1a3hcqd"&&(el.innerHTML=Gt),_e=n(l),sl=M(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-g70k6a"&&(sl.innerHTML=xt),Le=n(l),tl=M(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-3w08dm"&&(tl.innerHTML=Ft),ze=n(l),al=M(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1tjwm2o"&&(al.textContent=$t),Ae=n(l),nl=M(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-dislf8"&&(nl.innerHTML=gt),Xe=n(l),pl=M(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-s80prs"&&(pl.innerHTML=Ht),qe=n(l),Ml=M(l,"TABLE",{"data-svelte-h":!0}),i(Ml)!=="svelte-rlvhoh"&&(Ml.innerHTML=Wt),Oe=n(l),il=M(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-15yyvgv"&&(il.innerHTML=Nt),Pe=n(l),T(yl.$$.fragment,l),De=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1igj5eb"&&(Tl.innerHTML=Zt),Ke=n(l),T(Ul.$$.fragment,l),ls=n(l),rl=M(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1yevus4"&&(rl.innerHTML=Yt),es=n(l),T(ml.$$.fragment,l),ss=n(l),ol=M(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-12godbg"&&(ol.textContent=Qt),ts=n(l),T(hl.$$.fragment,l),as=n(l),wl=M(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-p732zr"&&(wl.innerHTML=_t),ns=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-rmvkbx"&&(Jl.innerHTML=Lt),ps=n(l),T(cl.$$.fragment,l),Ms=n(l),jl=M(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-1ntu5d"&&(jl.textContent=zt),is=n(l),T(dl.$$.fragment,l),ys=n(l),ul=M(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1yevus4"&&(ul.innerHTML=At),Ts=n(l),T(Il.$$.fragment,l),Us=n(l),bl=M(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-wcnmmn"&&(bl.innerHTML=Xt),rs=n(l),T(fl.$$.fragment,l),ms=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-1yevus4"&&(Cl.innerHTML=qt),os=n(l),T(Sl.$$.fragment,l),hs=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-v4nmdy"&&(Rl.innerHTML=Ot),ws=n(l),T(Bl.$$.fragment,l),Js=n(l),El=M(l,"P",{"data-svelte-h":!0}),i(El)!=="svelte-1yevus4"&&(El.innerHTML=Pt),cs=n(l),T(Vl.$$.fragment,l),js=n(l),kl=M(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-1arj9ah"&&(kl.textContent=Dt),ds=n(l),vl=M(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-15ggwxb"&&(vl.innerHTML=Kt),us=n(l),T(Gl.$$.fragment,l),Is=n(l),xl=M(l,"P",{"data-svelte-h":!0}),i(xl)!=="svelte-nsxua5"&&(xl.textContent=la),bs=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-13w71ar"&&(Fl.textContent=ea),fs=n(l),$l=M(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-a53lns"&&($l.textContent=sa),Cs=n(l),T(gl.$$.fragment,l),Ss=n(l),Hl=M(l,"P",{"data-svelte-h":!0}),i(Hl)!=="svelte-1yevus4"&&(Hl.innerHTML=ta),Rs=n(l),T(Wl.$$.fragment,l),Bs=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-tu44bd"&&(Nl.textContent=aa),Es=n(l),Zl=M(l,"OL",{"data-svelte-h":!0}),i(Zl)!=="svelte-1ce01pg"&&(Zl.innerHTML=na),Vs=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-1qotn65"&&(Yl.innerHTML=pa),ks=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),i(d)!=="svelte-ra5fet"&&(d.innerHTML=Ma),vs=n(l),w=M(l,"P",{});var J=Ut(w);Mt=b(J,"给样本分块的优势在于，转写后续的块"),Gs=pt(J,!1),xs=b(J," 不需要使用之前的块"),Fs=pt(J,!1),$s=b(J,` 的结果。拼接是在我们已经转写了所有块之后在块边界处进行的，所以转写的顺序并不重要。
该算法完全是 `),ne=M(J,"STRONG",{"data-svelte-h":!0}),i(ne)!=="svelte-1o0wrcf"&&(ne.textContent=ia),it=b(J,"，所以我们甚至可以同时转写块"),gs=pt(J,!1),Hs=b(J," 和块"),Ws=pt(J,!1),Ns=b(J,"！这允许我们 "),pe=M(J,"EM",{"data-svelte-h":!0}),i(pe)!=="svelte-5now7i"&&(pe.textContent=ya),yt=b(J,` 处理块，并通过并行运行模型，与顺序转写相比大大提升计算速度。
要了解更多关于 🤗 Transformers 中分块的知识，请参阅这篇 `),u=M(J,"A",{href:!0,rel:!0,"data-svelte-h":!0}),i(u)!=="svelte-zt77qd"&&(u.textContent=Ta),Tt=b(J,"。"),J.forEach(s),Zs=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-kbaar0"&&(Ql.innerHTML=Ua),Ys=n(l),_l=M(l,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-1arg4g2"&&(_l.innerHTML=ra),Qs=n(l),T(Ll.$$.fragment,l),_s=n(l),zl=M(l,"P",{"data-svelte-h":!0}),i(zl)!=="svelte-1yevus4"&&(zl.innerHTML=ma),Ls=n(l),T(Al.$$.fragment,l),zs=n(l),Xl=M(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-7vinxh"&&(Xl.textContent=oa),As=n(l),ql=M(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-r4z4lk"&&(ql.innerHTML=ha),Xs=n(l),Ol=M(l,"P",{"data-svelte-h":!0}),i(Ol)!=="svelte-16ol9aw"&&(Ol.innerHTML=wa),qs=n(l),T(Pl.$$.fragment,l),Os=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-1yevus4"&&(Dl.innerHTML=Ja),Ps=n(l),T(Kl.$$.fragment,l),Ds=n(l),le=M(l,"P",{"data-svelte-h":!0}),i(le)!=="svelte-evj3k0"&&(le.textContent=ca),Ks=n(l),T(ee.$$.fragment,l),lt=n(l),se=M(l,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1n65jng"&&(se.innerHTML=ja),et=n(l),te=M(l,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1x9tk48"&&(te.innerHTML=da),st=n(l),ae=M(l,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-f54qd1"&&(ae.innerHTML=ua),tt=n(l),ie=M(l,"P",{}),Ut(ie).forEach(s),this.h()},h(){ye(j,"name","hf:doc:metadata"),ye(j,"content",Ga),ye(d,"class","flex justify-center"),Gs.a=xs,Fs.a=$s,gs.a=Hs,Ws.a=Ns,ye(u,"href","https://huggingface.co/blog/asr-chunking"),ye(u,"rel","nofollow")},m(l,e){c(document.head,j),t(l,Ue,e),t(l,Me,e),t(l,re,e),U(f,l,e),t(l,me,e),t(l,C,e),t(l,oe,e),t(l,S,e),t(l,he,e),t(l,R,e),t(l,we,e),t(l,B,e),t(l,Je,e),t(l,E,e),t(l,ce,e),U(V,l,e),t(l,je,e),t(l,k,e),t(l,de,e),U(v,l,e),t(l,ue,e),t(l,G,e),t(l,Ie,e),U(x,l,e),t(l,be,e),t(l,F,e),t(l,fe,e),U($,l,e),t(l,Ce,e),t(l,g,e),t(l,Se,e),U(H,l,e),t(l,Re,e),t(l,W,e),t(l,Be,e),U(N,l,e),t(l,Ee,e),t(l,Z,e),t(l,Ve,e),U(Y,l,e),t(l,ke,e),t(l,Q,e),t(l,ve,e),U(_,l,e),t(l,Ge,e),t(l,L,e),t(l,xe,e),U(z,l,e),t(l,Fe,e),t(l,A,e),t(l,$e,e),t(l,X,e),t(l,ge,e),t(l,q,e),t(l,He,e),t(l,O,e),t(l,We,e),U(P,l,e),t(l,Ne,e),t(l,D,e),t(l,Ze,e),t(l,K,e),t(l,Ye,e),t(l,ll,e),t(l,Qe,e),t(l,el,e),t(l,_e,e),t(l,sl,e),t(l,Le,e),t(l,tl,e),t(l,ze,e),t(l,al,e),t(l,Ae,e),t(l,nl,e),t(l,Xe,e),t(l,pl,e),t(l,qe,e),t(l,Ml,e),t(l,Oe,e),t(l,il,e),t(l,Pe,e),U(yl,l,e),t(l,De,e),t(l,Tl,e),t(l,Ke,e),U(Ul,l,e),t(l,ls,e),t(l,rl,e),t(l,es,e),U(ml,l,e),t(l,ss,e),t(l,ol,e),t(l,ts,e),U(hl,l,e),t(l,as,e),t(l,wl,e),t(l,ns,e),t(l,Jl,e),t(l,ps,e),U(cl,l,e),t(l,Ms,e),t(l,jl,e),t(l,is,e),U(dl,l,e),t(l,ys,e),t(l,ul,e),t(l,Ts,e),U(Il,l,e),t(l,Us,e),t(l,bl,e),t(l,rs,e),U(fl,l,e),t(l,ms,e),t(l,Cl,e),t(l,os,e),U(Sl,l,e),t(l,hs,e),t(l,Rl,e),t(l,ws,e),U(Bl,l,e),t(l,Js,e),t(l,El,e),t(l,cs,e),U(Vl,l,e),t(l,js,e),t(l,kl,e),t(l,ds,e),t(l,vl,e),t(l,us,e),U(Gl,l,e),t(l,Is,e),t(l,xl,e),t(l,bs,e),t(l,Fl,e),t(l,fs,e),t(l,$l,e),t(l,Cs,e),U(gl,l,e),t(l,Ss,e),t(l,Hl,e),t(l,Rs,e),U(Wl,l,e),t(l,Bs,e),t(l,Nl,e),t(l,Es,e),t(l,Zl,e),t(l,Vs,e),t(l,Yl,e),t(l,ks,e),t(l,d,e),t(l,vs,e),t(l,w,e),c(w,Mt),Gs.m(Ia,w),c(w,xs),Fs.m(ba,w),c(w,$s),c(w,ne),c(w,it),gs.m(fa,w),c(w,Hs),Ws.m(Ca,w),c(w,Ns),c(w,pe),c(w,yt),c(w,u),c(w,Tt),t(l,Zs,e),t(l,Ql,e),t(l,Ys,e),t(l,_l,e),t(l,Qs,e),U(Ll,l,e),t(l,_s,e),t(l,zl,e),t(l,Ls,e),U(Al,l,e),t(l,zs,e),t(l,Xl,e),t(l,As,e),t(l,ql,e),t(l,Xs,e),t(l,Ol,e),t(l,qs,e),U(Pl,l,e),t(l,Os,e),t(l,Dl,e),t(l,Ps,e),U(Kl,l,e),t(l,Ds,e),t(l,le,e),t(l,Ks,e),U(ee,l,e),t(l,lt,e),t(l,se,e),t(l,et,e),t(l,te,e),t(l,st,e),t(l,ae,e),t(l,tt,e),t(l,ie,e),at=!0},p:Ra,i(l){at||(r(f.$$.fragment,l),r(V.$$.fragment,l),r(v.$$.fragment,l),r(x.$$.fragment,l),r($.$$.fragment,l),r(H.$$.fragment,l),r(N.$$.fragment,l),r(Y.$$.fragment,l),r(_.$$.fragment,l),r(z.$$.fragment,l),r(P.$$.fragment,l),r(yl.$$.fragment,l),r(Ul.$$.fragment,l),r(ml.$$.fragment,l),r(hl.$$.fragment,l),r(cl.$$.fragment,l),r(dl.$$.fragment,l),r(Il.$$.fragment,l),r(fl.$$.fragment,l),r(Sl.$$.fragment,l),r(Bl.$$.fragment,l),r(Vl.$$.fragment,l),r(Gl.$$.fragment,l),r(gl.$$.fragment,l),r(Wl.$$.fragment,l),r(Ll.$$.fragment,l),r(Al.$$.fragment,l),r(Pl.$$.fragment,l),r(Kl.$$.fragment,l),r(ee.$$.fragment,l),at=!0)},o(l){m(f.$$.fragment,l),m(V.$$.fragment,l),m(v.$$.fragment,l),m(x.$$.fragment,l),m($.$$.fragment,l),m(H.$$.fragment,l),m(N.$$.fragment,l),m(Y.$$.fragment,l),m(_.$$.fragment,l),m(z.$$.fragment,l),m(P.$$.fragment,l),m(yl.$$.fragment,l),m(Ul.$$.fragment,l),m(ml.$$.fragment,l),m(hl.$$.fragment,l),m(cl.$$.fragment,l),m(dl.$$.fragment,l),m(Il.$$.fragment,l),m(fl.$$.fragment,l),m(Sl.$$.fragment,l),m(Bl.$$.fragment,l),m(Vl.$$.fragment,l),m(Gl.$$.fragment,l),m(gl.$$.fragment,l),m(Wl.$$.fragment,l),m(Ll.$$.fragment,l),m(Al.$$.fragment,l),m(Pl.$$.fragment,l),m(Kl.$$.fragment,l),m(ee.$$.fragment,l),at=!1},d(l){l&&(s(Ue),s(Me),s(re),s(me),s(C),s(oe),s(S),s(he),s(R),s(we),s(B),s(Je),s(E),s(ce),s(je),s(k),s(de),s(ue),s(G),s(Ie),s(be),s(F),s(fe),s(Ce),s(g),s(Se),s(Re),s(W),s(Be),s(Ee),s(Z),s(Ve),s(ke),s(Q),s(ve),s(Ge),s(L),s(xe),s(Fe),s(A),s($e),s(X),s(ge),s(q),s(He),s(O),s(We),s(Ne),s(D),s(Ze),s(K),s(Ye),s(ll),s(Qe),s(el),s(_e),s(sl),s(Le),s(tl),s(ze),s(al),s(Ae),s(nl),s(Xe),s(pl),s(qe),s(Ml),s(Oe),s(il),s(Pe),s(De),s(Tl),s(Ke),s(ls),s(rl),s(es),s(ss),s(ol),s(ts),s(as),s(wl),s(ns),s(Jl),s(ps),s(Ms),s(jl),s(is),s(ys),s(ul),s(Ts),s(Us),s(bl),s(rs),s(ms),s(Cl),s(os),s(hs),s(Rl),s(ws),s(Js),s(El),s(cs),s(js),s(kl),s(ds),s(vl),s(us),s(Is),s(xl),s(bs),s(Fl),s(fs),s($l),s(Cs),s(Ss),s(Hl),s(Rs),s(Bs),s(Nl),s(Es),s(Zl),s(Vs),s(Yl),s(ks),s(d),s(vs),s(w),s(Zs),s(Ql),s(Ys),s(_l),s(Qs),s(_s),s(zl),s(Ls),s(zs),s(Xl),s(As),s(ql),s(Xs),s(Ol),s(qs),s(Os),s(Dl),s(Ps),s(Ds),s(le),s(Ks),s(lt),s(se),s(et),s(te),s(st),s(ae),s(tt),s(ie)),s(j),o(f,l),o(V,l),o(v,l),o(x,l),o($,l),o(H,l),o(N,l),o(Y,l),o(_,l),o(z,l),o(P,l),o(yl,l),o(Ul,l),o(ml,l),o(hl,l),o(cl,l),o(dl,l),o(Il,l),o(fl,l),o(Sl,l),o(Bl,l),o(Vl,l),o(Gl,l),o(gl,l),o(Wl,l),o(Ll,l),o(Al,l),o(Pl,l),o(Kl,l),o(ee,l)}}}const Ga='{"title":"语音识别的预训练模型","local":"语音识别的预训练模型","sections":[{"title":"探索 CTC 模型","local":"探索-ctc-模型","sections":[],"depth":2},{"title":"过渡到 Seq2Seq","local":"过渡到-seq2seq","sections":[],"depth":2},{"title":"长篇转写和时间戳","local":"长篇转写和时间戳","sections":[],"depth":2},{"title":"总结","local":"总结","sections":[],"depth":2}],"depth":1}';function xa(rt){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends Ea{constructor(j){super(),Va(this,j,xa,va,Sa,{})}}export{Wa as component};
