import{s as ae,n as ne,o as ie}from"../chunks/scheduler.c59d9fbb.js";import{S as le,i as oe,g as o,s as i,r as K,A as re,h as r,f as a,c as l,j as N,u as Q,x as m,k as V,y as se,a as n,v as X,d as Y,t as Z,w as ee}from"../chunks/index.a47918e3.js";import{H as te}from"../chunks/Heading.604bc707.js";function me(j){let s,I,A,T,d,x,f,q=`This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2205.05638" rel="nofollow">IA3</a>, a parameter-efficient fine tuning technique that is
intended to improve over <a href="./lora">LoRA</a>.`,C,u,S=`To make fine-tuning more efficient, IA3 (Infused Adapter by Inhibiting and Amplifying Inner Activations)
rescales inner activations with learned vectors. These learned vectors are injected in the attention and feedforward modules
in a typical transformer-based architecture. These learned vectors are the only trainable parameters during fine-tuning, and thus the original
weights remain frozen. Dealing with learned vectors (as opposed to learned low-rank updates to a weight matrix like LoRA)
keeps the number of trainable parameters much smaller.`,L,p,U="Being similar to LoRA, IA3 carries many of the same advantages:",P,c,W="<li>IA3 makes fine-tuning more efficient by drastically reducing the number of trainable parameters. (For T0, an IA3 model only has about 0.01% trainable parameters, while even LoRA has &gt; 0.1%)</li> <li>The original pre-trained weights are kept frozen, which means you can have multiple lightweight and portable IA3 models for various downstream tasks built on top of them.</li> <li>Performance of models fine-tuned using IA3 is comparable to the performance of fully fine-tuned models.</li> <li>IA3 does not add any inference latency because adapter weights can be merged with the base model.</li>",$,h,B=`In principle, IA3 can be applied to any subset of weight matrices in a neural network to reduce the number of trainable
parameters. Following the authors’ implementation, IA3 weights are added to the key, value and feedforward layers
of a Transformer model. Given the target layers for injecting IA3 parameters, the number of trainable parameters
can be determined based on the size of the weight matrices.`,k,v,M,b,D="As with other methods supported by PEFT, to fine-tune a model using IA3, you need to:",H,w,G="<li>Instantiate a base model.</li> <li>Create a configuration (<code>IA3Config</code>) where you define IA3-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",E,g,O="<code>IA3Config</code> allows you to control how IA3 is applied to the base model through the following parameters:",z,y,J=`<li><code>target_modules</code>: The modules (for example, attention blocks) to apply the IA3 vectors.</li> <li><code>feedforward_modules</code>: The list of modules to be treated as feedforward layers in <code>target_modules</code>. While learned vectors are multiplied with
the output activation for attention blocks, the vectors are multiplied with the input for classic feedforward layers.</li> <li><code>modules_to_save</code>: List of modules apart from IA3 layers to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,F,_,R;return d=new te({props:{title:"IA3",local:"ia3",headingTag:"h1"}}),v=new te({props:{title:"Common IA3 parameters in PEFT",local:"common-ia3-parameters-in-peft",headingTag:"h2"}}),{c(){s=o("meta"),I=i(),A=o("p"),T=i(),K(d.$$.fragment),x=i(),f=o("p"),f.innerHTML=q,C=i(),u=o("p"),u.textContent=S,L=i(),p=o("p"),p.textContent=U,P=i(),c=o("ul"),c.innerHTML=W,$=i(),h=o("p"),h.textContent=B,k=i(),K(v.$$.fragment),M=i(),b=o("p"),b.textContent=D,H=i(),w=o("ol"),w.innerHTML=G,E=i(),g=o("p"),g.innerHTML=O,z=i(),y=o("ul"),y.innerHTML=J,F=i(),_=o("p"),this.h()},l(e){const t=re("svelte-u9bgzb",document.head);s=r(t,"META",{name:!0,content:!0}),t.forEach(a),I=l(e),A=r(e,"P",{}),N(A).forEach(a),T=l(e),Q(d.$$.fragment,e),x=l(e),f=r(e,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1f08nkr"&&(f.innerHTML=q),C=l(e),u=r(e,"P",{"data-svelte-h":!0}),m(u)!=="svelte-iyuejo"&&(u.textContent=S),L=l(e),p=r(e,"P",{"data-svelte-h":!0}),m(p)!=="svelte-mvs6w2"&&(p.textContent=U),P=l(e),c=r(e,"UL",{"data-svelte-h":!0}),m(c)!=="svelte-1d130bu"&&(c.innerHTML=W),$=l(e),h=r(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-4d6y4h"&&(h.textContent=B),k=l(e),Q(v.$$.fragment,e),M=l(e),b=r(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-16q36ht"&&(b.textContent=D),H=l(e),w=r(e,"OL",{"data-svelte-h":!0}),m(w)!=="svelte-1sklxcv"&&(w.innerHTML=G),E=l(e),g=r(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1ufth76"&&(g.innerHTML=O),z=l(e),y=r(e,"UL",{"data-svelte-h":!0}),m(y)!=="svelte-14h3vsi"&&(y.innerHTML=J),F=l(e),_=r(e,"P",{}),N(_).forEach(a),this.h()},h(){V(s,"name","hf:doc:metadata"),V(s,"content",de)},m(e,t){se(document.head,s),n(e,I,t),n(e,A,t),n(e,T,t),X(d,e,t),n(e,x,t),n(e,f,t),n(e,C,t),n(e,u,t),n(e,L,t),n(e,p,t),n(e,P,t),n(e,c,t),n(e,$,t),n(e,h,t),n(e,k,t),X(v,e,t),n(e,M,t),n(e,b,t),n(e,H,t),n(e,w,t),n(e,E,t),n(e,g,t),n(e,z,t),n(e,y,t),n(e,F,t),n(e,_,t),R=!0},p:ne,i(e){R||(Y(d.$$.fragment,e),Y(v.$$.fragment,e),R=!0)},o(e){Z(d.$$.fragment,e),Z(v.$$.fragment,e),R=!1},d(e){e&&(a(I),a(A),a(T),a(x),a(f),a(C),a(u),a(L),a(p),a(P),a(c),a($),a(h),a(k),a(M),a(b),a(H),a(w),a(E),a(g),a(z),a(y),a(F),a(_)),a(s),ee(d,e),ee(v,e)}}}const de='{"title":"IA3","local":"ia3","sections":[{"title":"Common IA3 parameters in PEFT","local":"common-ia3-parameters-in-peft","sections":[],"depth":2}],"depth":1}';function fe(j){return ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class he extends le{constructor(s){super(),oe(this,s,fe,me,ae,{})}}export{he as component};
