import{s as tr,o as lr,n as sr}from"../chunks/scheduler.9bc65507.js";import{S as ir,i as nr,g as a,s as i,r,A as ar,h as o,f as l,c as n,j as Kp,u as h,x as p,k as er,y as or,a as s,v as u,d as m,t as d,w as f}from"../chunks/index.707bf1b6.js";import{T as pr}from"../chunks/Tip.c2ecdbf4.js";import{C as Il}from"../chunks/CodeBlock.54a9f38d.js";import{H as v}from"../chunks/Heading.342b1fa6.js";function rr(Sl){let c,P='Note: Most of the strategies introduced in the <a href="perf_train_gpu_one">single GPU section</a> (such as mixed precision training or gradient accumulation) are generic and apply to training models in general so make sure to have a look at it before diving into the following sections such as multi-GPU or CPU training.';return{c(){c=a("p"),c.innerHTML=P},l(w){c=o(w,"P",{"data-svelte-h":!0}),p(c)!=="svelte-ltsvmw"&&(c.innerHTML=P)},m(w,kl){s(w,c,kl)},p:sr,d(w){w&&l(c)}}}function hr(Sl){let c,P,w,kl,M,Nl,x,ta="When training on a single GPU is too slow or the model weights don’t fit in a single GPUs memory we use a multi-GPU setup. Switching from a single GPU to multiple requires some form of parallelism as the work needs to be distributed. There are several techniques to achieve parallism such as data, tensor, or pipeline parallism. However, there is no one solution to fit them all and which settings works best depends on the hardware you are running on. While the main concepts most likely will apply to any other framework, this article is focused on PyTorch-based implementations.",El,g,zl,y,la="We will first discuss in depth various 1D parallelism techniques and their pros and cons and then look at how they can be combined into 2D and 3D parallelism to enable an even faster training and to support even bigger models. Various other powerful alternative approaches will be presented.",Al,T,Bl,b,sa="The following is the brief description of the main concepts that will be described later in depth in this document.",Ql,C,ia="<li><strong>DataParallel (DP)</strong> - the same setup is replicated multiple times, and each being fed a slice of the data. The processing is done in parallel and all setups are synchronized at the end of each training step.</li> <li><strong>TensorParallel (TP)</strong> - each tensor is split up into multiple chunks, so instead of having the whole tensor reside on a single gpu, each shard of the tensor resides on its designated gpu. During processing each shard gets processed separately and in parallel on different GPUs and the results are synced at the end of the step. This is what one may call horizontal parallelism, as the splitting happens on horizontal level.</li> <li><strong>PipelineParallel (PP)</strong> - the model is split up vertically (layer-level) across multiple GPUs, so that only one or several layers of the model are places on a single gpu. Each gpu processes in parallel different stages of the pipeline and working on a small chunk of the batch.</li> <li><strong>Zero Redundancy Optimizer (ZeRO)</strong> - Also performs sharding of the tensors somewhat similar to TP, except the whole tensor gets reconstructed in time for a forward or backward computation, therefore the model doesn’t need to be modified. It also supports various offloading techniques to compensate for limited GPU memory.</li> <li><strong>Sharded DDP</strong> - is another name for the foundational ZeRO concept as used by various other implementations of ZeRO.</li>",Zl,j,na="Before diving deeper into the specifics of each concept we first have a look at the rough decision process when training large models on a large infrastructure.",Rl,L,Vl,_,aa="<strong>⇨ Single Node / Multi-GPU</strong>",Wl,U,oa="<li><p>Model fits onto a single GPU:</p> <ol><li>DDP - Distributed DP</li> <li>ZeRO - may or may not be faster depending on the situation and configuration used</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>With very fast intra-node connectivity of NVLINK or NVSwitch all three should be mostly on par, without these PP will be faster than TP or ZeRO. The degree of TP may also make a difference. Best to experiment to find the winner on your particular setup.</p> <p>TP is almost always used within a single node. That is TP size &lt;= gpus per node.</p></li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p> <ol><li>If not using ZeRO - must use TP, as PP alone won’t be able to fit.</li> <li>With ZeRO see the same entry for “Single GPU” above</li></ol></li>",Xl,D,pa="<strong>⇨ Multi-Node / Multi-GPU</strong>",Fl,J,ra="<li><p>When you have fast inter-node connectivity:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>PP+TP+DP - less communications, but requires massive changes to the model</li></ol></li> <li><p>when you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Ol,H,ql,G,ha='Most users with just 2 GPUs already enjoy the increased training speed up thanks to <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP) that are almost trivial to use. This is a built-in feature of Pytorch. Note that in general it is advised to use DDP as it is better maintained and works for all models while DP might fail for some models. <a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> itself recommends the use of DDP.',Yl,k,Kl,$,ua="<code>DistributedDataParallel</code> (DDP) is typically faster than <code>DataParallel</code> (DP), but it is not always the case:",es,I,ma="<li>while DP is python threads-based, DDP is multiprocess-based - and as such it has no python threads limitations, such as GIL</li> <li>on the other hand a slow inter-connectivity between the GPU cards could lead to an actual slower outcome with DDP</li>",ts,S,da="Here are the main differences in the inter-GPU communication overhead between the two modes:",ls,N,fa='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',ss,E,ca="<li>At the start time the main process replicates the model once from gpu 0 to the rest of gpus</li> <li>Then for each batch:<ol><li>each gpu consumes each own mini-batch of data directly</li> <li>during <code>backward</code>, once the local gradients are ready, they are then averaged across all processes</li></ol></li>",is,z,va='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',ns,A,wa="For each batch:",as,B,ga="<li>gpu 0 reads the batch of data and then sends a mini-batch to each gpu</li> <li>replicates the up-to-date model from gpu 0 to each gpu</li> <li>runs <code>forward</code> and sends output from each gpu to gpu 0, computes loss</li> <li>scatters loss from gpu 0 to all gpus, runs <code>backward</code></li> <li>sends gradients from each gpu to gpu 0 and averages those</li>",os,Q,Pa="The only communication DDP performs per batch is sending gradients, whereas DP does 5 different data exchanges per batch.",ps,Z,Ma='DP copies data within the process via python threads, whereas DDP copies data via <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>.',rs,R,xa="Under DP gpu 0 performs a lot more work than the rest of the gpus, thus resulting in under-utilization of gpus.",hs,V,ya="You can use DDP across multiple machines, but this is not the case with DP.",us,W,Ta="There are other differences between DP and DDP but they aren’t relevant to this discussion.",ms,X,ba='If you want to go really deep into understanding these 2 modes, this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a> is highly recommended, as it has great diagrams, includes multiple benchmarks and profiler outputs on various hardware, explains all the nuances that you may need to know.',ds,F,Ca="Let’s look at an actual benchmark:",fs,O,ja='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',cs,q,La="Analysis:",vs,Y,_a="Here DP is ~10% slower than DDP w/ NVlink, but ~15% faster than DDP w/o NVlink",ws,K,Ua="The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync, the more a slow link will slow down the total runtime.",gs,ee,Da="Here is the full benchmark code and outputs:",Ps,te,Ja="<code>NCCL_P2P_DISABLE=1</code> was used to disable the NVLink feature on the corresponding benchmark.",Ms,le,xs,se,Ha=`Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>)
Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>`,ys,ie,Ts,ne,Ga='ZeRO-powered data parallelism (ZeRO-DP) is described on the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',bs,ae,ka="It can be difficult to wrap one’s head around it, but in reality the concept is quite simple. This is just the usual <code>DataParallel</code> (DP), except, instead of replicating the full model params, gradients and optimizer states, each GPU stores only a slice of it.  And then at run-time when the full layer params are needed just for the given layer, all GPUs synchronize to give each other parts that they miss - this is it.",Cs,oe,$a="Consider this simple model with 3 layers, where each layer has 3 params:",js,pe,Ls,re,Ia="Layer La has weights a0, a1 and a2.",_s,he,Sa="If we have 3 GPUs, the Sharded DDP (= Zero-DP) splits the model onto 3 GPUs like so:",Us,ue,Ds,me,Na="In a way this is the same horizontal slicing, as tensor parallelism, if you imagine the typical DNN diagram. Vertical slicing is where one puts whole layer-groups on different GPUs. But it’s just the starting point.",Js,de,Ea="Now each of these GPUs will get the usual mini-batch as it works in DP:",Hs,fe,Gs,ce,za="The inputs are unmodified - they think they are going to be processed by the normal model.",ks,ve,Aa="First, the inputs hit the layer La.",$s,we,Ba="Let’s focus just on GPU0: x0 needs a0, a1, a2 params to do its forward path, but GPU0 has only a0 - it gets sent a1 from GPU1 and a2 from GPU2, bringing all pieces of the model together.",Is,ge,Qa="In parallel, GPU1 gets mini-batch x1 and it only has a1, but needs a0 and a2 params, so it gets those from GPU0 and GPU2.",Ss,Pe,Za="Same happens to GPU2 that gets input x2. It gets a0 and a1 from GPU0 and GPU1, and with its a2 it reconstructs the full tensor.",Ns,Me,Ra="All 3 GPUs get the full tensors reconstructed and a forward happens.",Es,xe,Va="As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation. The reconstruction is done efficiently via a pre-fetch.",zs,ye,Wa="And the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",As,Te,Xa="To me this sounds like an efficient group backpacking weight distribution strategy:",Bs,be,Fa="<li>person A carries the tent</li> <li>person B carries the stove</li> <li>person C carries the axe</li>",Qs,Ce,Oa="Now each night they all share what they have with others and get from others what they don’t have, and in the morning they pack up their allocated type of gear and continue on their way. This is Sharded DDP / Zero DP.",Zs,je,qa="Compare this strategy to the simple one where each person has to carry their own tent, stove and axe, which would be far more inefficient. This is DataParallel (DP and DDP) in Pytorch.",Rs,Le,Ya="While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.",Vs,_e,Ka="If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism which is discussed next.",Ws,Ue,eo="Implementations:",Xs,De,to='<li><a href="https://www.deepspeed.ai/features/#the-zero-redundancy-optimizer" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',Fs,Je,Os,He,lo="Naive Model Parallelism (MP) is where one spreads groups of model layers across multiple GPUs. The mechanism is relatively simple - switch the desired layers <code>.to()</code> the desired devices and now whenever the data goes in and out those layers switch the data to the same device as the layer and leave the rest unmodified.",qs,Ge,so="We refer to it as Vertical MP, because if you remember how most models are drawn, we slice the layers vertically. For example, if the following diagram shows an 8-layer model:",Ys,ke,Ks,$e,io="we just sliced it in 2 vertically, placing layers 0-3 onto GPU0 and 4-7 to GPU1.",ei,Ie,no="Now while data travels from layer 0 to 1, 1 to 2 and 2 to 3 this is just the normal model. But when data needs to pass from layer 3 to layer 4 it needs to travel from GPU0 to GPU1 which introduces a communication overhead. If the participating GPUs are on the same compute node (e.g. same physical machine) this copying is pretty fast, but if the GPUs are located on different compute nodes (e.g. multiple machines) the communication overhead could be significantly larger.",ti,Se,ao="Then layers 4 to 5 to 6 to 7 are as a normal model would have and when the 7th layer completes we often need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be computed and the optimizer can do its work.",li,Ne,oo="Problems:",si,Ee,po="<li>the main deficiency and why this one is called “naive” MP, is that all but one GPU is idle at any given moment. So if 4 GPUs are used, it’s almost identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware. Plus there is the overhead of copying the data between devices. So 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, except the latter will complete the training faster, since it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li>shared embeddings may need to get copied back and forth between GPUs.</li>",ii,ze,ro="Pipeline Parallelism (PP) is almost identical to a naive MP, but it solves the GPU idling problem, by chunking the incoming batch into micro-batches and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.",ni,Ae,ho='The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a> shows the naive MP on the top, and PP on the bottom:',ai,Be,uo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="mp-pp"/>',oi,Qe,mo="It’s easy to see from the bottom diagram how PP has less dead zones, where GPUs are idle. The idle parts are referred to as the “bubble”.",pi,Ze,fo="Both parts of the diagram show a parallelism that is of degree 4. That is 4 GPUs are participating in the pipeline. So there is the forward path of 4 pipe stages F0, F1, F2 and F3 and then the return reverse order backward path of B3, B2, B1 and B0.",ri,Re,co="PP introduces a new hyper-parameter to tune and it’s <code>chunks</code> which defines how many chunks of data are sent in a sequence through the same pipe stage. For example, in the bottom diagram you can see that <code>chunks=4</code>. GPU0 performs the same forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do their work and only when their work is starting to be complete, GPU0 starts to work again doing the backward path for chunks 3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).",hi,Ve,vo="Note that conceptually this is the same concept as gradient accumulation steps (GAS). Pytorch uses <code>chunks</code>, whereas DeepSpeed refers to the same hyper-parameter as GAS.",ui,We,wo="Because of the chunks, PP introduces the concept of micro-batches (MBS). DP splits the global data batch size into mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of 256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each Pipeline stage works with a single micro-batch at a time.",mi,Xe,go="To calculate the global batch size of the DP + PP setup we then do: <code>mbs*chunks*dp_degree</code> (<code>8*32*4=1024</code>).",di,Fe,Po="Let’s go back to the diagram.",fi,Oe,Mo="With <code>chunks=1</code> you end up with the naive MP, which is very inefficient. With a very large <code>chunks</code> value you end up with tiny micro-batch sizes which could be not every efficient either. So one has to experiment to find the value that leads to the highest efficient utilization of the gpus.",ci,qe,xo="While the diagram shows that there is a bubble of “dead” time that can’t be parallelized because the last <code>forward</code> stage has to wait for <code>backward</code> to complete the pipeline, the purpose of finding the best value for <code>chunks</code> is to enable a high concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.",vi,Ye,yo="There are 2 groups of solutions - the traditional Pipeline API and the more modern solutions that make things much easier for the end user.",wi,Ke,To="Traditional Pipeline API solutions:",gi,et,bo="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",Pi,tt,Co="Modern solutions:",Mi,lt,jo="<li>Varuna</li> <li>Sagemaker</li>",xi,st,Lo="Problems with traditional Pipeline API solutions:",yi,it,_o='<li>have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>currently the Pipeline API is very restricted. If you had a bunch of python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>have to arrange each layer so that the output of one model becomes an input to the other model.</li>',Ti,nt,Uo="We are yet to experiment with Varuna and SageMaker but their papers report that they have overcome the list of problems mentioned above and that they require much smaller changes to the user’s model.",bi,at,Do="Implementations:",Ci,ot,Jo='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">Pytorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',ji,pt,Ho="🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support. The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.",Li,rt,Go="Other approaches:",_i,ht,ko='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="interleaved-pipeline-execution"/>',Ui,ut,$o="Here the bubble (idle time) is further minimized by prioritizing backward passes.",Di,mt,Io="Varuna further tries to improve the schedule by using simulations to discover the most efficient scheduling.",Ji,dt,So="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> converting.",Hi,ft,Gi,ct,No="In Tensor Parallelism each GPU processes only a slice of a tensor and only aggregates the full tensor for operations that require the whole thing.",ki,vt,Eo='In this section we use concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.',$i,wt,zo="The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.",Ii,gt,Ao="Following the Megatron’s paper notation, we can write the dot-product part of it as <code>Y = GeLU(XA)</code>, where <code>X</code> and <code>Y</code> are the input and output vectors, and <code>A</code> is the weight matrix.",Si,Pt,Bo=`If we look at the computation in matrix form, it’s easy to see how the matrix multiplication can be split between multiple GPUs:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>`,Ni,Mt,Qo=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel, then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="independent GeLU"/>`,Ei,xt,Zo=`Using this principle, we can update an MLP of arbitrary depth, without the need for any synchronization between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors provide a helpful illustration for that:
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="parallel shard processing"/>`,zi,yt,Ro=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having multiple independent heads!
<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="parallel self-attention"/>`,Ai,Tt,Vo="Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node. Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use nodes that have at least 8 GPUs.",Bi,bt,Wo=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,Qi,Ct,Xo="SageMaker combines TP with DP for a more efficient processing.",Zi,jt,Fo="Alternative names:",Ri,Lt,Oo='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/features/#model-parallelism" rel="nofollow">tensor slicing</a></li>',Vi,_t,qo="Implementations:",Wi,Ut,Yo='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',Xi,Dt,Ko="🤗 Transformers status:",Fi,Jt,ep='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',Oi,Ht,qi,Gt,tp='The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates how one combines DP with PP.',Yi,kt,lp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="dp-pp-2d"/>',Ki,$t,sp="Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0 and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP. And GPU1 does the same by enlisting GPU3 to its aid.",en,It,ip="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",tn,St,np="Implementations:",ln,Nt,ap='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',sn,Et,op="🤗 Transformers status: not yet implemented",nn,zt,an,At,pp="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",on,Bt,rp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',pn,Qt,hp='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',rn,Zt,up="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",hn,Rt,mp="Implementations:",un,Vt,dp='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',mn,Wt,fp="🤗 Transformers status: not yet implemented, since we have no PP and TP.",dn,Xt,fn,Ft,cp='One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP. But it can be combined with PP and TP.',cn,Ot,vp="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",vn,qt,wp="While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have bad performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism, small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to hurt.",wn,Yt,gp="In addition, There are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.",gn,Kt,Pp="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",Pn,el,Mp="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",Mn,tl,xp="Implementations:",xn,ll,yp='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',yn,sl,Tp="Important papers:",Tn,il,bp='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',bn,nl,Cp="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Cn,al,jn,ol,jp='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',Ln,pl,Lp='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',_n,rl,_p="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Un,hl,Up="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Dn,ul,Dp="Examples:",Jn,ml,Jp="<li>Sample</li>",Hn,dl,Hp="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Gn,fl,Gp="<li>Operator</li>",kn,cl,kp="If we perform layer normalization, we compute std first and mean second, and then we can normalize data. Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2 devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.",$n,vl,$p="<li>Attribute</li>",In,wl,Ip="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Sn,gl,Sp="<li>Parameter</li>",Nn,Pl,Np="It is similar with tensor model parallelism or naive layer-wise model parallelism.",En,Ml,Ep='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',zn,xl,zp="The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3) fast-intra-connect/slow-inter-connect and it automatically optimizes all these  algorithmically deciding which parallelisation to use where.",An,yl,Ap="One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.",Bn,Tl,Bp="So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan for that. And then you can train. A different setup will have its own custom optimization.",Qn,bl,Qp='🤗 Transformers status: not yet integrated. We already have our models FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>, which is a prerequisite for FlexFlow, so someone needs to figure out what needs to be done to make FlexFlow work with our models.',Zn,Cl,Rn,jl,Zp="Here is a very rough outline at which parallelism strategy to use when. The first on each list is typically faster.",Vn,Ll,Rp="<strong>⇨ Single GPU</strong>",Wn,_l,Vp="<li><p>Model fits onto a single GPU:</p> <ol><li>Normal use</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li>ZeRO + Offload CPU and optionally NVMe</li> <li>as above plus Memory Centric Tiling (see below for details) if the largest layer can’t fit into a single GPU</li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p></li>",Xn,Ul,Wp='<li>ZeRO - Enable <a href="https://deepspeed.readthedocs.io/en/latest/zero3.html#memory-centric-tiling" rel="nofollow">Memory Centric Tiling</a> (MCT). It allows you to run arbitrarily large layers by automatically splitting them and executing them sequentially. MCT reduces the number of parameters that are live on a GPU, but it does not affect the activation memory. As this need is very rare as of this writing a manual override of <code>torch.nn.Linear</code> needs to be done by the user.</li>',Fn,Dl,Xp="<strong>⇨ Single Node / Multi-GPU</strong>",On,Jl,Fp="<li><p>Model fits onto a single GPU:</p> <ol><li>DDP - Distributed DP</li> <li>ZeRO - may or may not be faster depending on the situation and configuration used</li></ol></li> <li><p>Model doesn’t fit onto a single GPU:</p> <ol><li><p>PP</p></li> <li><p>ZeRO</p></li> <li><p>TP</p> <p>With very fast intra-node connectivity of NVLINK or NVSwitch all three should be mostly on par, without these PP will be faster than TP or ZeRO. The degree of TP may also make a difference. Best to experiment to find the winner on your particular setup.</p> <p>TP is almost always used within a single node. That is TP size &lt;= gpus per node.</p></li></ol></li> <li><p>Largest Layer not fitting into a single GPU:</p> <ol><li>If not using ZeRO - must use TP, as PP alone won’t be able to fit.</li> <li>With ZeRO see the same entry for “Single GPU” above</li></ol></li>",qn,Hl,Op="<strong>⇨ Multi-Node / Multi-GPU</strong>",Yn,Gl,qp="<li><p>When you have fast inter-node connectivity:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>PP+TP+DP - less communications, but requires massive changes to the model</li></ol></li> <li><p>when you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>DP+PP+TP+ZeRO-1</li></ol></li>",Kn,$l,ea;return M=new v({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),g=new pr({props:{$$slots:{default:[rr]},$$scope:{ctx:Sl}}}),T=new v({props:{title:"Concepts",local:"concepts",headingTag:"h2"}}),L=new v({props:{title:"Scalability Strategy",local:"scalability-strategy",headingTag:"h2"}}),H=new v({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),k=new v({props:{title:"DP vs DDP",local:"dp-vs-ddp",headingTag:"h3"}}),le=new Il({props:{code:"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",highlighted:`
<span class="hljs-comment"># DP</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/ NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}

<span class="hljs-comment"># DDP w/o NVlink</span>
<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),ie=new v({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),pe=new Il({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ue=new Il({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),fe=new Il({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),Je=new v({props:{title:"Naive Model Parallelism (Vertical) and Pipeline Parallelism",local:"naive-model-parallelism-vertical-and-pipeline-parallelism",headingTag:"h2"}}),ke=new Il({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBncHUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3B1MQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        gpu0                 gpu1`,wrap:!1}}),ft=new v({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Ht=new v({props:{title:"DP+PP",local:"dppp",headingTag:"h2"}}),zt=new v({props:{title:"DP+PP+TP",local:"dppptp",headingTag:"h2"}}),Xt=new v({props:{title:"ZeRO DP+PP+TP",local:"zero-dppptp",headingTag:"h2"}}),al=new v({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),Cl=new v({props:{title:"Which Strategy To Use When",local:"which-strategy-to-use-when",headingTag:"h2"}}),{c(){c=a("meta"),P=i(),w=a("p"),kl=i(),r(M.$$.fragment),Nl=i(),x=a("p"),x.textContent=ta,El=i(),r(g.$$.fragment),zl=i(),y=a("p"),y.textContent=la,Al=i(),r(T.$$.fragment),Bl=i(),b=a("p"),b.textContent=sa,Ql=i(),C=a("ol"),C.innerHTML=ia,Zl=i(),j=a("p"),j.textContent=na,Rl=i(),r(L.$$.fragment),Vl=i(),_=a("p"),_.innerHTML=aa,Wl=i(),U=a("ul"),U.innerHTML=oa,Xl=i(),D=a("p"),D.innerHTML=pa,Fl=i(),J=a("ul"),J.innerHTML=ra,Ol=i(),r(H.$$.fragment),ql=i(),G=a("p"),G.innerHTML=ha,Yl=i(),r(k.$$.fragment),Kl=i(),$=a("p"),$.innerHTML=ua,es=i(),I=a("ul"),I.innerHTML=ma,ts=i(),S=a("p"),S.textContent=da,ls=i(),N=a("p"),N.innerHTML=fa,ss=i(),E=a("ul"),E.innerHTML=ca,is=i(),z=a("p"),z.innerHTML=va,ns=i(),A=a("p"),A.textContent=wa,as=i(),B=a("ol"),B.innerHTML=ga,os=i(),Q=a("p"),Q.textContent=Pa,ps=i(),Z=a("p"),Z.innerHTML=Ma,rs=i(),R=a("p"),R.textContent=xa,hs=i(),V=a("p"),V.textContent=ya,us=i(),W=a("p"),W.textContent=Ta,ms=i(),X=a("p"),X.innerHTML=ba,ds=i(),F=a("p"),F.textContent=Ca,fs=i(),O=a("table"),O.innerHTML=ja,cs=i(),q=a("p"),q.textContent=La,vs=i(),Y=a("p"),Y.textContent=_a,ws=i(),K=a("p"),K.textContent=Ua,gs=i(),ee=a("p"),ee.textContent=Da,Ps=i(),te=a("p"),te.innerHTML=Ja,Ms=i(),r(le.$$.fragment),xs=i(),se=a("p"),se.innerHTML=Ha,ys=i(),r(ie.$$.fragment),Ts=i(),ne=a("p"),ne.innerHTML=Ga,bs=i(),ae=a("p"),ae.innerHTML=ka,Cs=i(),oe=a("p"),oe.textContent=$a,js=i(),r(pe.$$.fragment),Ls=i(),re=a("p"),re.textContent=Ia,_s=i(),he=a("p"),he.textContent=Sa,Us=i(),r(ue.$$.fragment),Ds=i(),me=a("p"),me.textContent=Na,Js=i(),de=a("p"),de.textContent=Ea,Hs=i(),r(fe.$$.fragment),Gs=i(),ce=a("p"),ce.textContent=za,ks=i(),ve=a("p"),ve.textContent=Aa,$s=i(),we=a("p"),we.textContent=Ba,Is=i(),ge=a("p"),ge.textContent=Qa,Ss=i(),Pe=a("p"),Pe.textContent=Za,Ns=i(),Me=a("p"),Me.textContent=Ra,Es=i(),xe=a("p"),xe.textContent=Va,zs=i(),ye=a("p"),ye.textContent=Wa,As=i(),Te=a("p"),Te.textContent=Xa,Bs=i(),be=a("ol"),be.innerHTML=Fa,Qs=i(),Ce=a("p"),Ce.textContent=Oa,Zs=i(),je=a("p"),je.textContent=qa,Rs=i(),Le=a("p"),Le.textContent=Ya,Vs=i(),_e=a("p"),_e.textContent=Ka,Ws=i(),Ue=a("p"),Ue.textContent=eo,Xs=i(),De=a("ul"),De.innerHTML=to,Fs=i(),r(Je.$$.fragment),Os=i(),He=a("p"),He.innerHTML=lo,qs=i(),Ge=a("p"),Ge.textContent=so,Ys=i(),r(ke.$$.fragment),Ks=i(),$e=a("p"),$e.textContent=io,ei=i(),Ie=a("p"),Ie.textContent=no,ti=i(),Se=a("p"),Se.textContent=ao,li=i(),Ne=a("p"),Ne.textContent=oo,si=i(),Ee=a("ul"),Ee.innerHTML=po,ii=i(),ze=a("p"),ze.textContent=ro,ni=i(),Ae=a("p"),Ae.innerHTML=ho,ai=i(),Be=a("p"),Be.innerHTML=uo,oi=i(),Qe=a("p"),Qe.textContent=mo,pi=i(),Ze=a("p"),Ze.textContent=fo,ri=i(),Re=a("p"),Re.innerHTML=co,hi=i(),Ve=a("p"),Ve.innerHTML=vo,ui=i(),We=a("p"),We.innerHTML=wo,mi=i(),Xe=a("p"),Xe.innerHTML=go,di=i(),Fe=a("p"),Fe.textContent=Po,fi=i(),Oe=a("p"),Oe.innerHTML=Mo,ci=i(),qe=a("p"),qe.innerHTML=xo,vi=i(),Ye=a("p"),Ye.textContent=yo,wi=i(),Ke=a("p"),Ke.textContent=To,gi=i(),et=a("ul"),et.innerHTML=bo,Pi=i(),tt=a("p"),tt.textContent=Co,Mi=i(),lt=a("ul"),lt.innerHTML=jo,xi=i(),st=a("p"),st.textContent=Lo,yi=i(),it=a("ul"),it.innerHTML=_o,Ti=i(),nt=a("p"),nt.textContent=Uo,bi=i(),at=a("p"),at.textContent=Do,Ci=i(),ot=a("ul"),ot.innerHTML=Jo,ji=i(),pt=a("p"),pt.innerHTML=Ho,Li=i(),rt=a("p"),rt.textContent=Go,_i=i(),ht=a("p"),ht.innerHTML=ko,Ui=i(),ut=a("p"),ut.textContent=$o,Di=i(),mt=a("p"),mt.textContent=Io,Ji=i(),dt=a("p"),dt.innerHTML=So,Hi=i(),r(ft.$$.fragment),Gi=i(),ct=a("p"),ct.textContent=No,ki=i(),vt=a("p"),vt.innerHTML=Eo,$i=i(),wt=a("p"),wt.innerHTML=zo,Ii=i(),gt=a("p"),gt.innerHTML=Ao,Si=i(),Pt=a("p"),Pt.innerHTML=Bo,Ni=i(),Mt=a("p"),Mt.innerHTML=Qo,Ei=i(),xt=a("p"),xt.innerHTML=Zo,zi=i(),yt=a("p"),yt.innerHTML=Ro,Ai=i(),Tt=a("p"),Tt.textContent=Vo,Bi=i(),bt=a("p"),bt.innerHTML=Wo,Qi=i(),Ct=a("p"),Ct.textContent=Xo,Zi=i(),jt=a("p"),jt.textContent=Fo,Ri=i(),Lt=a("ul"),Lt.innerHTML=Oo,Vi=i(),_t=a("p"),_t.textContent=qo,Wi=i(),Ut=a("ul"),Ut.innerHTML=Yo,Xi=i(),Dt=a("p"),Dt.textContent=Ko,Fi=i(),Jt=a("ul"),Jt.innerHTML=ep,Oi=i(),r(Ht.$$.fragment),qi=i(),Gt=a("p"),Gt.innerHTML=tp,Yi=i(),kt=a("p"),kt.innerHTML=lp,Ki=i(),$t=a("p"),$t.textContent=sp,en=i(),It=a("p"),It.textContent=ip,tn=i(),St=a("p"),St.textContent=np,ln=i(),Nt=a("ul"),Nt.innerHTML=ap,sn=i(),Et=a("p"),Et.textContent=op,nn=i(),r(zt.$$.fragment),an=i(),At=a("p"),At.textContent=pp,on=i(),Bt=a("p"),Bt.innerHTML=rp,pn=i(),Qt=a("p"),Qt.innerHTML=hp,rn=i(),Zt=a("p"),Zt.textContent=up,hn=i(),Rt=a("p"),Rt.textContent=mp,un=i(),Vt=a("ul"),Vt.innerHTML=dp,mn=i(),Wt=a("p"),Wt.textContent=fp,dn=i(),r(Xt.$$.fragment),fn=i(),Ft=a("p"),Ft.innerHTML=cp,cn=i(),Ot=a("p"),Ot.textContent=vp,vn=i(),qt=a("p"),qt.textContent=wp,wn=i(),Yt=a("p"),Yt.innerHTML=gp,gn=i(),Kt=a("p"),Kt.textContent=Pp,Pn=i(),el=a("p"),el.textContent=Mp,Mn=i(),tl=a("p"),tl.textContent=xp,xn=i(),ll=a("ul"),ll.innerHTML=yp,yn=i(),sl=a("p"),sl.textContent=Tp,Tn=i(),il=a("ul"),il.innerHTML=bp,bn=i(),nl=a("p"),nl.textContent=Cp,Cn=i(),r(al.$$.fragment),jn=i(),ol=a("p"),ol.innerHTML=jp,Ln=i(),pl=a("p"),pl.innerHTML=Lp,_n=i(),rl=a("p"),rl.textContent=_p,Un=i(),hl=a("ol"),hl.innerHTML=Up,Dn=i(),ul=a("p"),ul.textContent=Dp,Jn=i(),ml=a("ul"),ml.innerHTML=Jp,Hn=i(),dl=a("p"),dl.textContent=Hp,Gn=i(),fl=a("ul"),fl.innerHTML=Gp,kn=i(),cl=a("p"),cl.textContent=kp,$n=i(),vl=a("ul"),vl.innerHTML=$p,In=i(),wl=a("p"),wl.textContent=Ip,Sn=i(),gl=a("ul"),gl.innerHTML=Sp,Nn=i(),Pl=a("p"),Pl.textContent=Np,En=i(),Ml=a("p"),Ml.innerHTML=Ep,zn=i(),xl=a("p"),xl.textContent=zp,An=i(),yl=a("p"),yl.textContent=Ap,Bn=i(),Tl=a("p"),Tl.textContent=Bp,Qn=i(),bl=a("p"),bl.innerHTML=Qp,Zn=i(),r(Cl.$$.fragment),Rn=i(),jl=a("p"),jl.textContent=Zp,Vn=i(),Ll=a("p"),Ll.innerHTML=Rp,Wn=i(),_l=a("ul"),_l.innerHTML=Vp,Xn=i(),Ul=a("ol"),Ul.innerHTML=Wp,Fn=i(),Dl=a("p"),Dl.innerHTML=Xp,On=i(),Jl=a("ul"),Jl.innerHTML=Fp,qn=i(),Hl=a("p"),Hl.innerHTML=Op,Yn=i(),Gl=a("ul"),Gl.innerHTML=qp,Kn=i(),$l=a("p"),this.h()},l(e){const t=ar("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),P=n(e),w=o(e,"P",{}),Kp(w).forEach(l),kl=n(e),h(M.$$.fragment,e),Nl=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1rziuzo"&&(x.textContent=ta),El=n(e),h(g.$$.fragment,e),zl=n(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-h5m4s0"&&(y.textContent=la),Al=n(e),h(T.$$.fragment,e),Bl=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-pynyh2"&&(b.textContent=sa),Ql=n(e),C=o(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-xyghb4"&&(C.innerHTML=ia),Zl=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-bxn59e"&&(j.textContent=na),Rl=n(e),h(L.$$.fragment,e),Vl=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-f88duy"&&(_.innerHTML=aa),Wl=n(e),U=o(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-1yree73"&&(U.innerHTML=oa),Xl=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-kdfi74"&&(D.innerHTML=pa),Fl=n(e),J=o(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-mgpo8"&&(J.innerHTML=ra),Ol=n(e),h(H.$$.fragment,e),ql=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1fxgfhi"&&(G.innerHTML=ha),Yl=n(e),h(k.$$.fragment,e),Kl=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1dfmjsp"&&($.innerHTML=ua),es=n(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-123r2xc"&&(I.innerHTML=ma),ts=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ssfu1g"&&(S.textContent=da),ls=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1v8b0bi"&&(N.innerHTML=fa),ss=n(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-11u6e1m"&&(E.innerHTML=ca),is=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-2za96j"&&(z.innerHTML=va),ns=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1e3g0sm"&&(A.textContent=wa),as=n(e),B=o(e,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-2irogx"&&(B.innerHTML=ga),os=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1lupox0"&&(Q.textContent=Pa),ps=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-11l39rn"&&(Z.innerHTML=Ma),rs=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1mr4sva"&&(R.textContent=xa),hs=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1pi6jp8"&&(V.textContent=ya),us=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1ivvdh1"&&(W.textContent=Ta),ms=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1rep9ix"&&(X.innerHTML=ba),ds=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-yxf37j"&&(F.textContent=Ca),fs=n(e),O=o(e,"TABLE",{"data-svelte-h":!0}),p(O)!=="svelte-1glyygb"&&(O.innerHTML=ja),cs=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-gug91c"&&(q.textContent=La),vs=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-lz5d0e"&&(Y.textContent=_a),ws=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-kfwgwv"&&(K.textContent=Ua),gs=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-16jny0z"&&(ee.textContent=Da),Ps=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-hs453n"&&(te.innerHTML=Ja),Ms=n(e),h(le.$$.fragment,e),xs=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-pittpg"&&(se.innerHTML=Ha),ys=n(e),h(ie.$$.fragment,e),Ts=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-srae2u"&&(ne.innerHTML=Ga),bs=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-8nwpg0"&&(ae.innerHTML=ka),Cs=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-13leqhj"&&(oe.textContent=$a),js=n(e),h(pe.$$.fragment,e),Ls=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-19zx7iu"&&(re.textContent=Ia),_s=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-vbsuek"&&(he.textContent=Sa),Us=n(e),h(ue.$$.fragment,e),Ds=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-z5lhr7"&&(me.textContent=Na),Js=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-k74por"&&(de.textContent=Ea),Hs=n(e),h(fe.$$.fragment,e),Gs=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1bnbo9h"&&(ce.textContent=za),ks=n(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-2160r6"&&(ve.textContent=Aa),$s=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-137i420"&&(we.textContent=Ba),Is=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-fuckbw"&&(ge.textContent=Qa),Ss=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-8k7f2v"&&(Pe.textContent=Za),Ns=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-ka27ai"&&(Me.textContent=Ra),Es=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-sr3f0f"&&(xe.textContent=Va),zs=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-13q1vu5"&&(ye.textContent=Wa),As=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-j8ab4e"&&(Te.textContent=Xa),Bs=n(e),be=o(e,"OL",{"data-svelte-h":!0}),p(be)!=="svelte-6pzgco"&&(be.innerHTML=Fa),Qs=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1dtp0my"&&(Ce.textContent=Oa),Zs=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-of8cks"&&(je.textContent=qa),Rs=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1qo8w9o"&&(Le.textContent=Ya),Vs=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1r4i3oj"&&(_e.textContent=Ka),Ws=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1b2mzqh"&&(Ue.textContent=eo),Xs=n(e),De=o(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-1duka0r"&&(De.innerHTML=to),Fs=n(e),h(Je.$$.fragment,e),Os=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1pxnuea"&&(He.innerHTML=lo),qs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-wezc9q"&&(Ge.textContent=so),Ys=n(e),h(ke.$$.fragment,e),Ks=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-qijq4u"&&($e.textContent=io),ei=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-4g6pcw"&&(Ie.textContent=no),ti=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1xu2x6q"&&(Se.textContent=ao),li=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1n10xu2"&&(Ne.textContent=oo),si=n(e),Ee=o(e,"UL",{"data-svelte-h":!0}),p(Ee)!=="svelte-988mfp"&&(Ee.innerHTML=po),ii=n(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1fevjqr"&&(ze.textContent=ro),ni=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-b4pgks"&&(Ae.innerHTML=ho),ai=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1q7hzge"&&(Be.innerHTML=uo),oi=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1g83j3f"&&(Qe.textContent=mo),pi=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1vo2jyy"&&(Ze.textContent=fo),ri=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1hgi2en"&&(Re.innerHTML=co),hi=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1736ap5"&&(Ve.innerHTML=vo),ui=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1adhphn"&&(We.innerHTML=wo),mi=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-muana1"&&(Xe.innerHTML=go),di=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-m941ob"&&(Fe.textContent=Po),fi=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-4yeq43"&&(Oe.innerHTML=Mo),ci=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1u0vuag"&&(qe.innerHTML=xo),vi=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-14w2s8c"&&(Ye.textContent=yo),wi=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-j65mcd"&&(Ke.textContent=To),gi=n(e),et=o(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-1m54oo0"&&(et.innerHTML=bo),Pi=n(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-oykhtz"&&(tt.textContent=Co),Mi=n(e),lt=o(e,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-n2xihd"&&(lt.innerHTML=jo),xi=n(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1wdbk4x"&&(st.textContent=Lo),yi=n(e),it=o(e,"UL",{"data-svelte-h":!0}),p(it)!=="svelte-q8rblb"&&(it.innerHTML=_o),Ti=n(e),nt=o(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-w4skeu"&&(nt.textContent=Uo),bi=n(e),at=o(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1b2mzqh"&&(at.textContent=Do),Ci=n(e),ot=o(e,"UL",{"data-svelte-h":!0}),p(ot)!=="svelte-yzvtut"&&(ot.innerHTML=Jo),ji=n(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-wo41ed"&&(pt.innerHTML=Ho),Li=n(e),rt=o(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1djad0c"&&(rt.textContent=Go),_i=n(e),ht=o(e,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1rlh20n"&&(ht.innerHTML=ko),Ui=n(e),ut=o(e,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-eeo3o2"&&(ut.textContent=$o),Di=n(e),mt=o(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-tt8ebp"&&(mt.textContent=Io),Ji=n(e),dt=o(e,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-1ddaj59"&&(dt.innerHTML=So),Hi=n(e),h(ft.$$.fragment,e),Gi=n(e),ct=o(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-rq0mtj"&&(ct.textContent=No),ki=n(e),vt=o(e,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-kmqtuy"&&(vt.innerHTML=Eo),$i=n(e),wt=o(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-kx5fsx"&&(wt.innerHTML=zo),Ii=n(e),gt=o(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-inc4wa"&&(gt.innerHTML=Ao),Si=n(e),Pt=o(e,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-hnmqxg"&&(Pt.innerHTML=Bo),Ni=n(e),Mt=o(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-121l99q"&&(Mt.innerHTML=Qo),Ei=n(e),xt=o(e,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-wx20wp"&&(xt.innerHTML=Zo),zi=n(e),yt=o(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-p22xej"&&(yt.innerHTML=Ro),Ai=n(e),Tt=o(e,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-16v636l"&&(Tt.textContent=Vo),Bi=n(e),bt=o(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-hmoxa9"&&(bt.innerHTML=Wo),Qi=n(e),Ct=o(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-xqarbt"&&(Ct.textContent=Xo),Zi=n(e),jt=o(e,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1ma7lah"&&(jt.textContent=Fo),Ri=n(e),Lt=o(e,"UL",{"data-svelte-h":!0}),p(Lt)!=="svelte-1udq7jy"&&(Lt.innerHTML=Oo),Vi=n(e),_t=o(e,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1b2mzqh"&&(_t.textContent=qo),Wi=n(e),Ut=o(e,"UL",{"data-svelte-h":!0}),p(Ut)!=="svelte-sudg8s"&&(Ut.innerHTML=Yo),Xi=n(e),Dt=o(e,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-1g6ovc1"&&(Dt.textContent=Ko),Fi=n(e),Jt=o(e,"UL",{"data-svelte-h":!0}),p(Jt)!=="svelte-13k8bts"&&(Jt.innerHTML=ep),Oi=n(e),h(Ht.$$.fragment,e),qi=n(e),Gt=o(e,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-iiww3g"&&(Gt.innerHTML=tp),Yi=n(e),kt=o(e,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-qmcl9c"&&(kt.innerHTML=lp),Ki=n(e),$t=o(e,"P",{"data-svelte-h":!0}),p($t)!=="svelte-oj250q"&&($t.textContent=sp),en=n(e),It=o(e,"P",{"data-svelte-h":!0}),p(It)!=="svelte-4rkar7"&&(It.textContent=ip),tn=n(e),St=o(e,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1b2mzqh"&&(St.textContent=np),ln=n(e),Nt=o(e,"UL",{"data-svelte-h":!0}),p(Nt)!=="svelte-1ry6c7"&&(Nt.innerHTML=ap),sn=n(e),Et=o(e,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-9dc2gy"&&(Et.textContent=op),nn=n(e),h(zt.$$.fragment,e),an=n(e),At=o(e,"P",{"data-svelte-h":!0}),p(At)!=="svelte-fz9fyw"&&(At.textContent=pp),on=n(e),Bt=o(e,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-18rdwc7"&&(Bt.innerHTML=rp),pn=n(e),Qt=o(e,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-18bvwlv"&&(Qt.innerHTML=hp),rn=n(e),Zt=o(e,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1hp29wn"&&(Zt.textContent=up),hn=n(e),Rt=o(e,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1b2mzqh"&&(Rt.textContent=mp),un=n(e),Vt=o(e,"UL",{"data-svelte-h":!0}),p(Vt)!=="svelte-3ic0jq"&&(Vt.innerHTML=dp),mn=n(e),Wt=o(e,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-r6xwz8"&&(Wt.textContent=fp),dn=n(e),h(Xt.$$.fragment,e),fn=n(e),Ft=o(e,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-ohkord"&&(Ft.innerHTML=cp),cn=n(e),Ot=o(e,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-172u2n6"&&(Ot.textContent=vp),vn=n(e),qt=o(e,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-16eyfr0"&&(qt.textContent=wp),wn=n(e),Yt=o(e,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-rdhflp"&&(Yt.innerHTML=gp),gn=n(e),Kt=o(e,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-q3kikv"&&(Kt.textContent=Pp),Pn=n(e),el=o(e,"P",{"data-svelte-h":!0}),p(el)!=="svelte-s2rtor"&&(el.textContent=Mp),Mn=n(e),tl=o(e,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1b2mzqh"&&(tl.textContent=xp),xn=n(e),ll=o(e,"UL",{"data-svelte-h":!0}),p(ll)!=="svelte-o5zp0z"&&(ll.innerHTML=yp),yn=n(e),sl=o(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1grbiex"&&(sl.textContent=Tp),Tn=n(e),il=o(e,"UL",{"data-svelte-h":!0}),p(il)!=="svelte-1oyel1u"&&(il.innerHTML=bp),bn=n(e),nl=o(e,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-r6xwz8"&&(nl.textContent=Cp),Cn=n(e),h(al.$$.fragment,e),jn=n(e),ol=o(e,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-121cfuq"&&(ol.innerHTML=jp),Ln=n(e),pl=o(e,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-dou7hg"&&(pl.innerHTML=Lp),_n=n(e),rl=o(e,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-oa098n"&&(rl.textContent=_p),Un=n(e),hl=o(e,"OL",{"data-svelte-h":!0}),p(hl)!=="svelte-6cxs64"&&(hl.innerHTML=Up),Dn=n(e),ul=o(e,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-kvfsh7"&&(ul.textContent=Dp),Jn=n(e),ml=o(e,"UL",{"data-svelte-h":!0}),p(ml)!=="svelte-1734ihx"&&(ml.innerHTML=Jp),Hn=n(e),dl=o(e,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-jsce61"&&(dl.textContent=Hp),Gn=n(e),fl=o(e,"UL",{"data-svelte-h":!0}),p(fl)!=="svelte-ilmkvr"&&(fl.innerHTML=Gp),kn=n(e),cl=o(e,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-1mjyx54"&&(cl.textContent=kp),$n=n(e),vl=o(e,"UL",{"data-svelte-h":!0}),p(vl)!=="svelte-dyjda9"&&(vl.innerHTML=$p),In=n(e),wl=o(e,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1qwl5bi"&&(wl.textContent=Ip),Sn=n(e),gl=o(e,"UL",{"data-svelte-h":!0}),p(gl)!=="svelte-bzftse"&&(gl.innerHTML=Sp),Nn=n(e),Pl=o(e,"P",{"data-svelte-h":!0}),p(Pl)!=="svelte-pn1yl1"&&(Pl.textContent=Np),En=n(e),Ml=o(e,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-k8js9g"&&(Ml.innerHTML=Ep),zn=n(e),xl=o(e,"P",{"data-svelte-h":!0}),p(xl)!=="svelte-6pmm5n"&&(xl.textContent=zp),An=n(e),yl=o(e,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-pg911u"&&(yl.textContent=Ap),Bn=n(e),Tl=o(e,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1kiqb4z"&&(Tl.textContent=Bp),Qn=n(e),bl=o(e,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-1dy3y3g"&&(bl.innerHTML=Qp),Zn=n(e),h(Cl.$$.fragment,e),Rn=n(e),jl=o(e,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1ysb6gs"&&(jl.textContent=Zp),Vn=n(e),Ll=o(e,"P",{"data-svelte-h":!0}),p(Ll)!=="svelte-1ll70nj"&&(Ll.innerHTML=Rp),Wn=n(e),_l=o(e,"UL",{"data-svelte-h":!0}),p(_l)!=="svelte-1tk5izf"&&(_l.innerHTML=Vp),Xn=n(e),Ul=o(e,"OL",{"data-svelte-h":!0}),p(Ul)!=="svelte-im98lt"&&(Ul.innerHTML=Wp),Fn=n(e),Dl=o(e,"P",{"data-svelte-h":!0}),p(Dl)!=="svelte-f88duy"&&(Dl.innerHTML=Xp),On=n(e),Jl=o(e,"UL",{"data-svelte-h":!0}),p(Jl)!=="svelte-1yree73"&&(Jl.innerHTML=Fp),qn=n(e),Hl=o(e,"P",{"data-svelte-h":!0}),p(Hl)!=="svelte-kdfi74"&&(Hl.innerHTML=Op),Yn=n(e),Gl=o(e,"UL",{"data-svelte-h":!0}),p(Gl)!=="svelte-mgpo8"&&(Gl.innerHTML=qp),Kn=n(e),$l=o(e,"P",{}),Kp($l).forEach(l),this.h()},h(){er(c,"name","hf:doc:metadata"),er(c,"content",ur)},m(e,t){or(document.head,c),s(e,P,t),s(e,w,t),s(e,kl,t),u(M,e,t),s(e,Nl,t),s(e,x,t),s(e,El,t),u(g,e,t),s(e,zl,t),s(e,y,t),s(e,Al,t),u(T,e,t),s(e,Bl,t),s(e,b,t),s(e,Ql,t),s(e,C,t),s(e,Zl,t),s(e,j,t),s(e,Rl,t),u(L,e,t),s(e,Vl,t),s(e,_,t),s(e,Wl,t),s(e,U,t),s(e,Xl,t),s(e,D,t),s(e,Fl,t),s(e,J,t),s(e,Ol,t),u(H,e,t),s(e,ql,t),s(e,G,t),s(e,Yl,t),u(k,e,t),s(e,Kl,t),s(e,$,t),s(e,es,t),s(e,I,t),s(e,ts,t),s(e,S,t),s(e,ls,t),s(e,N,t),s(e,ss,t),s(e,E,t),s(e,is,t),s(e,z,t),s(e,ns,t),s(e,A,t),s(e,as,t),s(e,B,t),s(e,os,t),s(e,Q,t),s(e,ps,t),s(e,Z,t),s(e,rs,t),s(e,R,t),s(e,hs,t),s(e,V,t),s(e,us,t),s(e,W,t),s(e,ms,t),s(e,X,t),s(e,ds,t),s(e,F,t),s(e,fs,t),s(e,O,t),s(e,cs,t),s(e,q,t),s(e,vs,t),s(e,Y,t),s(e,ws,t),s(e,K,t),s(e,gs,t),s(e,ee,t),s(e,Ps,t),s(e,te,t),s(e,Ms,t),u(le,e,t),s(e,xs,t),s(e,se,t),s(e,ys,t),u(ie,e,t),s(e,Ts,t),s(e,ne,t),s(e,bs,t),s(e,ae,t),s(e,Cs,t),s(e,oe,t),s(e,js,t),u(pe,e,t),s(e,Ls,t),s(e,re,t),s(e,_s,t),s(e,he,t),s(e,Us,t),u(ue,e,t),s(e,Ds,t),s(e,me,t),s(e,Js,t),s(e,de,t),s(e,Hs,t),u(fe,e,t),s(e,Gs,t),s(e,ce,t),s(e,ks,t),s(e,ve,t),s(e,$s,t),s(e,we,t),s(e,Is,t),s(e,ge,t),s(e,Ss,t),s(e,Pe,t),s(e,Ns,t),s(e,Me,t),s(e,Es,t),s(e,xe,t),s(e,zs,t),s(e,ye,t),s(e,As,t),s(e,Te,t),s(e,Bs,t),s(e,be,t),s(e,Qs,t),s(e,Ce,t),s(e,Zs,t),s(e,je,t),s(e,Rs,t),s(e,Le,t),s(e,Vs,t),s(e,_e,t),s(e,Ws,t),s(e,Ue,t),s(e,Xs,t),s(e,De,t),s(e,Fs,t),u(Je,e,t),s(e,Os,t),s(e,He,t),s(e,qs,t),s(e,Ge,t),s(e,Ys,t),u(ke,e,t),s(e,Ks,t),s(e,$e,t),s(e,ei,t),s(e,Ie,t),s(e,ti,t),s(e,Se,t),s(e,li,t),s(e,Ne,t),s(e,si,t),s(e,Ee,t),s(e,ii,t),s(e,ze,t),s(e,ni,t),s(e,Ae,t),s(e,ai,t),s(e,Be,t),s(e,oi,t),s(e,Qe,t),s(e,pi,t),s(e,Ze,t),s(e,ri,t),s(e,Re,t),s(e,hi,t),s(e,Ve,t),s(e,ui,t),s(e,We,t),s(e,mi,t),s(e,Xe,t),s(e,di,t),s(e,Fe,t),s(e,fi,t),s(e,Oe,t),s(e,ci,t),s(e,qe,t),s(e,vi,t),s(e,Ye,t),s(e,wi,t),s(e,Ke,t),s(e,gi,t),s(e,et,t),s(e,Pi,t),s(e,tt,t),s(e,Mi,t),s(e,lt,t),s(e,xi,t),s(e,st,t),s(e,yi,t),s(e,it,t),s(e,Ti,t),s(e,nt,t),s(e,bi,t),s(e,at,t),s(e,Ci,t),s(e,ot,t),s(e,ji,t),s(e,pt,t),s(e,Li,t),s(e,rt,t),s(e,_i,t),s(e,ht,t),s(e,Ui,t),s(e,ut,t),s(e,Di,t),s(e,mt,t),s(e,Ji,t),s(e,dt,t),s(e,Hi,t),u(ft,e,t),s(e,Gi,t),s(e,ct,t),s(e,ki,t),s(e,vt,t),s(e,$i,t),s(e,wt,t),s(e,Ii,t),s(e,gt,t),s(e,Si,t),s(e,Pt,t),s(e,Ni,t),s(e,Mt,t),s(e,Ei,t),s(e,xt,t),s(e,zi,t),s(e,yt,t),s(e,Ai,t),s(e,Tt,t),s(e,Bi,t),s(e,bt,t),s(e,Qi,t),s(e,Ct,t),s(e,Zi,t),s(e,jt,t),s(e,Ri,t),s(e,Lt,t),s(e,Vi,t),s(e,_t,t),s(e,Wi,t),s(e,Ut,t),s(e,Xi,t),s(e,Dt,t),s(e,Fi,t),s(e,Jt,t),s(e,Oi,t),u(Ht,e,t),s(e,qi,t),s(e,Gt,t),s(e,Yi,t),s(e,kt,t),s(e,Ki,t),s(e,$t,t),s(e,en,t),s(e,It,t),s(e,tn,t),s(e,St,t),s(e,ln,t),s(e,Nt,t),s(e,sn,t),s(e,Et,t),s(e,nn,t),u(zt,e,t),s(e,an,t),s(e,At,t),s(e,on,t),s(e,Bt,t),s(e,pn,t),s(e,Qt,t),s(e,rn,t),s(e,Zt,t),s(e,hn,t),s(e,Rt,t),s(e,un,t),s(e,Vt,t),s(e,mn,t),s(e,Wt,t),s(e,dn,t),u(Xt,e,t),s(e,fn,t),s(e,Ft,t),s(e,cn,t),s(e,Ot,t),s(e,vn,t),s(e,qt,t),s(e,wn,t),s(e,Yt,t),s(e,gn,t),s(e,Kt,t),s(e,Pn,t),s(e,el,t),s(e,Mn,t),s(e,tl,t),s(e,xn,t),s(e,ll,t),s(e,yn,t),s(e,sl,t),s(e,Tn,t),s(e,il,t),s(e,bn,t),s(e,nl,t),s(e,Cn,t),u(al,e,t),s(e,jn,t),s(e,ol,t),s(e,Ln,t),s(e,pl,t),s(e,_n,t),s(e,rl,t),s(e,Un,t),s(e,hl,t),s(e,Dn,t),s(e,ul,t),s(e,Jn,t),s(e,ml,t),s(e,Hn,t),s(e,dl,t),s(e,Gn,t),s(e,fl,t),s(e,kn,t),s(e,cl,t),s(e,$n,t),s(e,vl,t),s(e,In,t),s(e,wl,t),s(e,Sn,t),s(e,gl,t),s(e,Nn,t),s(e,Pl,t),s(e,En,t),s(e,Ml,t),s(e,zn,t),s(e,xl,t),s(e,An,t),s(e,yl,t),s(e,Bn,t),s(e,Tl,t),s(e,Qn,t),s(e,bl,t),s(e,Zn,t),u(Cl,e,t),s(e,Rn,t),s(e,jl,t),s(e,Vn,t),s(e,Ll,t),s(e,Wn,t),s(e,_l,t),s(e,Xn,t),s(e,Ul,t),s(e,Fn,t),s(e,Dl,t),s(e,On,t),s(e,Jl,t),s(e,qn,t),s(e,Hl,t),s(e,Yn,t),s(e,Gl,t),s(e,Kn,t),s(e,$l,t),ea=!0},p(e,[t]){const Yp={};t&2&&(Yp.$$scope={dirty:t,ctx:e}),g.$set(Yp)},i(e){ea||(m(M.$$.fragment,e),m(g.$$.fragment,e),m(T.$$.fragment,e),m(L.$$.fragment,e),m(H.$$.fragment,e),m(k.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(ke.$$.fragment,e),m(ft.$$.fragment,e),m(Ht.$$.fragment,e),m(zt.$$.fragment,e),m(Xt.$$.fragment,e),m(al.$$.fragment,e),m(Cl.$$.fragment,e),ea=!0)},o(e){d(M.$$.fragment,e),d(g.$$.fragment,e),d(T.$$.fragment,e),d(L.$$.fragment,e),d(H.$$.fragment,e),d(k.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(Je.$$.fragment,e),d(ke.$$.fragment,e),d(ft.$$.fragment,e),d(Ht.$$.fragment,e),d(zt.$$.fragment,e),d(Xt.$$.fragment,e),d(al.$$.fragment,e),d(Cl.$$.fragment,e),ea=!1},d(e){e&&(l(P),l(w),l(kl),l(Nl),l(x),l(El),l(zl),l(y),l(Al),l(Bl),l(b),l(Ql),l(C),l(Zl),l(j),l(Rl),l(Vl),l(_),l(Wl),l(U),l(Xl),l(D),l(Fl),l(J),l(Ol),l(ql),l(G),l(Yl),l(Kl),l($),l(es),l(I),l(ts),l(S),l(ls),l(N),l(ss),l(E),l(is),l(z),l(ns),l(A),l(as),l(B),l(os),l(Q),l(ps),l(Z),l(rs),l(R),l(hs),l(V),l(us),l(W),l(ms),l(X),l(ds),l(F),l(fs),l(O),l(cs),l(q),l(vs),l(Y),l(ws),l(K),l(gs),l(ee),l(Ps),l(te),l(Ms),l(xs),l(se),l(ys),l(Ts),l(ne),l(bs),l(ae),l(Cs),l(oe),l(js),l(Ls),l(re),l(_s),l(he),l(Us),l(Ds),l(me),l(Js),l(de),l(Hs),l(Gs),l(ce),l(ks),l(ve),l($s),l(we),l(Is),l(ge),l(Ss),l(Pe),l(Ns),l(Me),l(Es),l(xe),l(zs),l(ye),l(As),l(Te),l(Bs),l(be),l(Qs),l(Ce),l(Zs),l(je),l(Rs),l(Le),l(Vs),l(_e),l(Ws),l(Ue),l(Xs),l(De),l(Fs),l(Os),l(He),l(qs),l(Ge),l(Ys),l(Ks),l($e),l(ei),l(Ie),l(ti),l(Se),l(li),l(Ne),l(si),l(Ee),l(ii),l(ze),l(ni),l(Ae),l(ai),l(Be),l(oi),l(Qe),l(pi),l(Ze),l(ri),l(Re),l(hi),l(Ve),l(ui),l(We),l(mi),l(Xe),l(di),l(Fe),l(fi),l(Oe),l(ci),l(qe),l(vi),l(Ye),l(wi),l(Ke),l(gi),l(et),l(Pi),l(tt),l(Mi),l(lt),l(xi),l(st),l(yi),l(it),l(Ti),l(nt),l(bi),l(at),l(Ci),l(ot),l(ji),l(pt),l(Li),l(rt),l(_i),l(ht),l(Ui),l(ut),l(Di),l(mt),l(Ji),l(dt),l(Hi),l(Gi),l(ct),l(ki),l(vt),l($i),l(wt),l(Ii),l(gt),l(Si),l(Pt),l(Ni),l(Mt),l(Ei),l(xt),l(zi),l(yt),l(Ai),l(Tt),l(Bi),l(bt),l(Qi),l(Ct),l(Zi),l(jt),l(Ri),l(Lt),l(Vi),l(_t),l(Wi),l(Ut),l(Xi),l(Dt),l(Fi),l(Jt),l(Oi),l(qi),l(Gt),l(Yi),l(kt),l(Ki),l($t),l(en),l(It),l(tn),l(St),l(ln),l(Nt),l(sn),l(Et),l(nn),l(an),l(At),l(on),l(Bt),l(pn),l(Qt),l(rn),l(Zt),l(hn),l(Rt),l(un),l(Vt),l(mn),l(Wt),l(dn),l(fn),l(Ft),l(cn),l(Ot),l(vn),l(qt),l(wn),l(Yt),l(gn),l(Kt),l(Pn),l(el),l(Mn),l(tl),l(xn),l(ll),l(yn),l(sl),l(Tn),l(il),l(bn),l(nl),l(Cn),l(jn),l(ol),l(Ln),l(pl),l(_n),l(rl),l(Un),l(hl),l(Dn),l(ul),l(Jn),l(ml),l(Hn),l(dl),l(Gn),l(fl),l(kn),l(cl),l($n),l(vl),l(In),l(wl),l(Sn),l(gl),l(Nn),l(Pl),l(En),l(Ml),l(zn),l(xl),l(An),l(yl),l(Bn),l(Tl),l(Qn),l(bl),l(Zn),l(Rn),l(jl),l(Vn),l(Ll),l(Wn),l(_l),l(Xn),l(Ul),l(Fn),l(Dl),l(On),l(Jl),l(qn),l(Hl),l(Yn),l(Gl),l(Kn),l($l)),l(c),f(M,e),f(g,e),f(T,e),f(L,e),f(H,e),f(k,e),f(le,e),f(ie,e),f(pe,e),f(ue,e),f(fe,e),f(Je,e),f(ke,e),f(ft,e),f(Ht,e),f(zt,e),f(Xt,e),f(al,e),f(Cl,e)}}}const ur='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Concepts","local":"concepts","sections":[],"depth":2},{"title":"Scalability Strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DP vs DDP","local":"dp-vs-ddp","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"Naive Model Parallelism (Vertical) and Pipeline Parallelism","local":"naive-model-parallelism-vertical-and-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"DP+PP","local":"dppp","sections":[],"depth":2},{"title":"DP+PP+TP","local":"dppptp","sections":[],"depth":2},{"title":"ZeRO DP+PP+TP","local":"zero-dppptp","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"Which Strategy To Use When","local":"which-strategy-to-use-when","sections":[],"depth":2}],"depth":1}';function mr(Sl){return lr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gr extends ir{constructor(c){super(),nr(this,c,mr,hr,tr,{})}}export{gr as component};
