import{s as ft,o as bt,n as jt}from"../chunks/scheduler.22bf70d2.js";import{S as Gt,i as gt,g as s,s as n,r as y,A as It,h as i,f as l,c as o,j as Jt,u as M,x as c,k as Ct,y as vt,a,v as p,d as w,t as m,w as h}from"../chunks/index.59178e06.js";import{T as At}from"../chunks/Tip.75d940ba.js";import{C as ne}from"../chunks/CodeBlock.f7047b13.js";import{H as oe}from"../chunks/Heading.f8746c79.js";function _t(se){let r,T="Disabling <code>no_sync</code> means there <em>will be slowdown</em> due the extra data syncs, as explained by the earlier sections of this guide.";return{c(){r=s("p"),r.innerHTML=T},l(d){r=i(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-15yoesw"&&(r.innerHTML=T)},m(d,le){a(d,r,le)},p:jt,d(d){d&&l(r)}}}function Bt(se){let r,T,d,le,U,ie,J,Fe=`PyTorch’s distributed module operates by communicating back and forth between all of the GPUs in your system.
This communication takes time, and ensuring all processes know the states of each other happens at particular triggerpoints
when using the <code>ddp</code> module.`,ce,C,Qe=`These triggerpoints are added to the PyTorch model, specifically their <code>forward()</code> and <code>backward()</code> methods.
This happens when the model is wrapped with <code>DistributedDataParallel</code>:`,re,f,de,b,Ee='In 🤗 Accelerate this conversion happens automatically when calling <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> and passing in your model.',ye,j,Me,G,pe,g,Ne=`You now understand that PyTorch adds hooks to the <code>forward</code> and <code>backward</code> method of your PyTorch model when
training in a distributed setup. But how does this risk slowing down your code?`,we,I,De=`In DDP (distributed data parallel), the specific order in which processes are performed and ran are expected
at specific points and these must also occur at roughly the same time before moving on.`,me,v,Ke=`The most direct example is when you update model parameters through
<code>optimizer.step()</code>.
Without gradient accumulation, all instances of the model need to have updated
their gradients computed, collated, and updated before moving on to the next
batch of data.
When performing gradient accumulation, you accumulate <code>n</code> loss gradients and
skip <code>optimizer.step()</code> until <code>n</code> batches have been reached. As all training
processes only need to synchronize by the time <code>optimizer.step()</code> is called,
without any modification to your training step, this needless inter-process
communication can cause a significant slowdown.`,he,A,qe="How can you avoid this overhead?",ue,_,Te,B,Oe=`Since you are skipping model parameter updates when training on these batches, their gradients do not need to be synchronized until the point where <code>optimizer.step()</code> is actually called.
PyTorch cannot automagically tell when you need to do this, but they do provide a tool to help through the <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html#torch.nn.parallel.DistributedDataParallel.no_sync" rel="nofollow"><code>no_sync</code></a> context manager
that is added to your model after converting it to DDP.`,Ue,k,et=`Under this context manager, PyTorch will skip synchronizing the gradients when
<code>.backward()</code> is called, and the first call to <code>.backward()</code> outside this
context manager will trigger the synchronization. See an example below:`,Je,$,Ce,x,tt=`In 🤗 Accelerate to make this an API that can be called no matter the training device (though it may not do anything if you are not in a distributed system!),
<code>ddp_model.no_sync</code> gets replaced with <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.no_sync">no_sync()</a> and operates the same way:`,fe,Z,be,H,lt=`As you may expect, the <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function wraps around this conditional check by keeping track of the current batch number, leaving you with the final
gradient accumulation API:`,je,z,Ge,W,at="As a result, you should either use <em><code>accelerator.accumulate</code> or <code>accelerator.no_sync</code></em> when it comes to API choice.",ge,V,Ie,R,nt="To set up a realistic example, consider the following setup:",ve,S,ot='<li>Two single-GPU T4 nodes and one node with two GPUs</li> <li>Each GPU is a T4, and are hosted on GCP</li> <li>The script used is a modification of the <a href="https://github.com/muellerzr/timing_experiments/blob/main/baseline.py" rel="nofollow">NLP Example</a> script</li> <li>Batch size per GPU is 16, and gradients are accumulated every 4 steps</li>',Ae,X,st='All scripts are available in <a href="https://github.com/muellerzr/timing_experiments" rel="nofollow">this repository</a>.',_e,P,it=`If not careful about gradient synchronization and GPU communication, a <em>large</em> amount of time can be wasted
from when these GPUs communicate to each other during unnecessary periods.`,Be,L,ct="By how much?",ke,Y,rt="Reference:",$e,F,dt='<li>Baseline: uses no synchronization practices discussed here</li> <li><code>no_sync</code> improperly: <code>no_sync</code> only around the <code>backward</code> call, not the <code>forward</code></li> <li><code>no_sync</code>: using the <code>no_sync</code> pattern properly</li> <li><code>accumulate</code>: using <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> properly</li>',xe,Q,yt="Below are the average seconds per batch iterating over 29 batches of data for each setup on both a single node and on the dual-node setup:",Ze,E,Mt='<thead><tr><th align="center"></th> <th align="center">Baseline</th> <th align="center"><code>no_sync</code> improperly</th> <th align="center"><code>no_sync</code></th> <th align="center"><code>accumulate</code></th></tr></thead> <tbody><tr><td align="center">Multi-Node</td> <td align="center">2±0.01s</td> <td align="center">2.13±0.08s</td> <td align="center"><strong>0.91±0.11s</strong></td> <td align="center"><strong>0.91±0.11s</strong></td></tr> <tr><td align="center">Single Node</td> <td align="center">0.50±0.01s</td> <td align="center">0.50±0.01s</td> <td align="center"><strong>0.41±0.015s</strong></td> <td align="center"><strong>0.41±0.015s</strong></td></tr></tbody>',He,N,pt="As you can see, if you are not careful about how you set up your gradient synchronization, you can get upwards of more than a 2x slowdown during training!",ze,D,wt=`If you are worried about making sure everything is done properly, we highly recommend utilizing the <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> function and passing in
<code>gradient_accumulation_steps</code> or <code>gradient_accumulation_plugin</code> to the <a href="/docs/accelerate/v0.29.3/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object so Accelerate can handle this for you.`,We,K,Ve,q,mt='Be aware that not syncing gradients can have adverse effects while performing FSDP training. As it has been warned in <code>torch</code>, the <a href="https://pytorch.org/docs/stable/fsdp.html#torch.distributed.fsdp.FullyShardedDataParallel.no_sync" rel="nofollow"><code>no_sync</code> context manager for FSDP</a> will require additional memory.',Re,O,ht='Therefore in memory intensive situations while using FSDP, we recommend to set <code>sync_each_batch</code> to <code>True</code> in the <a href="/docs/accelerate/v0.29.3/en/package_reference/utilities#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> to disable <code>no_sync</code>.',Se,ee,ut="See the example below where we fine-tune Mixtral (47B parameters) on 8 A100-80GB GPUs. We see that even for a modest <code>gradient_accumulation_steps=2</code> we quickly go out-of-memory (OOM) if <code>no_sync</code> is enabled. Again, this is due to additional memory overheads due to FSDP’s <code>no_sync</code>. However, if <code>no_sync</code> is disabled via <code>sync_each_batch=True</code>, then the memory consumption for <code>gradient_accumulation_steps=16</code> reverts to that of <code>gradient_accumulation_steps=1</code>.",Xe,te,Tt='<thead><tr><th align="center">Model</th> <th align="center"><code>no_sync</code> (accum=1)</th> <th align="center"><code>no_sync</code> (accum=2)</th> <th align="center"><code>no_sync</code> disabled (accum=16)</th></tr></thead> <tbody><tr><td align="center">mixtral 8x7B</td> <td align="center">69G</td> <td align="center">OOM</td> <td align="center">69G</td></tr></tbody>',Pe,u,Le,ae,Ye;return U=new oe({props:{title:"Gradient Synchronization",local:"gradient-synchronization",headingTag:"h1"}}),f=new ne({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBZnJvbSUyMHRvcmNoLm5uLnBhcmFsbGVsJTIwaW1wb3J0JTIwRGlzdHJpYnV0ZWREYXRhUGFyYWxsZWwlMEElMEFtb2RlbCUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQWRkcF9tb2RlbCUyMCUzRCUyMERpc3RyaWJ1dGVkRGF0YVBhcmFsbGVsKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn.parallel <span class="hljs-keyword">import</span> DistributedDataParallel

model = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
ddp_model = DistributedDataParallel(model)`,wrap:!1}}),j=new ne({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMGltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQS0lMjBmcm9tJTIwdG9yY2gubm4ucGFyYWxsZWwlMjBpbXBvcnQlMjBEaXN0cmlidXRlZERhdGFQYXJhbGxlbCUwQSUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwbm4uTGluZWFyKDEwJTJDMTApJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>
  import torch.nn as nn
<span class="hljs-deletion">- from torch.nn.parallel import DistributedDataParallel</span>

  model = nn.Linear(10,10)
<span class="hljs-addition">+ model = accelerator.prepare(model)</span>`,wrap:!1}}),G=new oe({props:{title:"The slowdown in gradient accumulation",local:"the-slowdown-in-gradient-accumulation",headingTag:"h2"}}),_=new oe({props:{title:"Solving the slowdown problem",local:"solving-the-slowdown-problem",headingTag:"h2"}}),$=new ne({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGRkcF9tb2RlbC5ub19zeW5jKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBvbmx5JTIwYWNjdW11bGF0ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHcmFkaWVudHMlMjBmaW5hbGx5JTIwc3luYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBkZHBfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    inputs, targets = batch
    <span class="hljs-comment"># Trigger gradient synchronization on the last batch</span>
    <span class="hljs-keyword">if</span> index != (<span class="hljs-built_in">len</span>(dataloader) - <span class="hljs-number">1</span>):
        <span class="hljs-keyword">with</span> ddp_model.no_sync():
            <span class="hljs-comment"># Gradients only accumulate</span>
            outputs = ddp_model(inputs)
            loss = loss_func(outputs)
            accelerator.backward(loss)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Gradients finally sync</span>
        outputs = ddp_model(inputs)
        loss = loss_func(outputs)
        accelerator.backward(loss)
        optimizer.step()`,wrap:!1}}),Z=new ne({props:{code:"JTIwJTIwZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBncmFkaWVudCUyMHN5bmNocm9uaXphdGlvbiUyMG9uJTIwdGhlJTIwbGFzdCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpbmRleCUyMCElM0QlMjAobGVuKGRhdGFsb2FkZXIpLTEpJTNBJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBkZHBfbW9kZWwubm9fc3luYygpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLm5vX3N5bmMobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR3JhZGllbnRzJTIwb25seSUyMGFjY3VtdWxhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwZGRwX21vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEdyYWRpZW50cyUyMGZpbmFsbHklMjBzeW5jJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGRkcF9tb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuYyhvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`  ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

  for index, batch in enumerate(dataloader):
      inputs, targets = batch
      # Trigger gradient synchronization on the last batch
      if index != (len(dataloader)-1):
<span class="hljs-deletion">-         with ddp_model.no_sync():</span>
<span class="hljs-addition">+         with accelerator.no_sync(model):</span>
              # Gradients only accumulate
              outputs = ddp_model(inputs)
              loss = loss_func(outputs, targets)
              accelerator.backward(loss)
      else:
          # Gradients finally sync
          outputs = ddp_model(inputs)
          loss = loss_func(outputs)
          accelerator.backward(loss)
          optimizer.step()
          optimizer.zero_grad()`,wrap:!1}}),z=new ne({props:{code:"ZGRwX21vZGVsJTJDJTIwZGF0YWxvYWRlciUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBkYXRhbG9hZGVyJTJDJTIwb3B0aW1pemVyKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`ddp_model, dataloader, optimizer = accelerator.prepare(model, dataloader, optimizer)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        optimizer.zero_grad()
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        optimizer.zero_grad()`,wrap:!1}}),V=new oe({props:{title:"Just how much of a slowdown is there, and easy mistakes you can make",local:"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make",headingTag:"h2"}}),K=new oe({props:{title:"no_sync requires additional GPU memory when using FSDP",local:"nosync-requires-additional-gpu-memory-when-using-fsdp",headingTag:"h3"}}),u=new At({props:{warning:!0,$$slots:{default:[_t]},$$scope:{ctx:se}}}),{c(){r=s("meta"),T=n(),d=s("p"),le=n(),y(U.$$.fragment),ie=n(),J=s("p"),J.innerHTML=Fe,ce=n(),C=s("p"),C.innerHTML=Qe,re=n(),y(f.$$.fragment),de=n(),b=s("p"),b.innerHTML=Ee,ye=n(),y(j.$$.fragment),Me=n(),y(G.$$.fragment),pe=n(),g=s("p"),g.innerHTML=Ne,we=n(),I=s("p"),I.textContent=De,me=n(),v=s("p"),v.innerHTML=Ke,he=n(),A=s("p"),A.textContent=qe,ue=n(),y(_.$$.fragment),Te=n(),B=s("p"),B.innerHTML=Oe,Ue=n(),k=s("p"),k.innerHTML=et,Je=n(),y($.$$.fragment),Ce=n(),x=s("p"),x.innerHTML=tt,fe=n(),y(Z.$$.fragment),be=n(),H=s("p"),H.innerHTML=lt,je=n(),y(z.$$.fragment),Ge=n(),W=s("p"),W.innerHTML=at,ge=n(),y(V.$$.fragment),Ie=n(),R=s("p"),R.textContent=nt,ve=n(),S=s("ul"),S.innerHTML=ot,Ae=n(),X=s("p"),X.innerHTML=st,_e=n(),P=s("p"),P.innerHTML=it,Be=n(),L=s("p"),L.textContent=ct,ke=n(),Y=s("p"),Y.textContent=rt,$e=n(),F=s("ul"),F.innerHTML=dt,xe=n(),Q=s("p"),Q.textContent=yt,Ze=n(),E=s("table"),E.innerHTML=Mt,He=n(),N=s("p"),N.textContent=pt,ze=n(),D=s("p"),D.innerHTML=wt,We=n(),y(K.$$.fragment),Ve=n(),q=s("p"),q.innerHTML=mt,Re=n(),O=s("p"),O.innerHTML=ht,Se=n(),ee=s("p"),ee.innerHTML=ut,Xe=n(),te=s("table"),te.innerHTML=Tt,Pe=n(),y(u.$$.fragment),Le=n(),ae=s("p"),this.h()},l(e){const t=It("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(l),T=o(e),d=i(e,"P",{}),Jt(d).forEach(l),le=o(e),M(U.$$.fragment,e),ie=o(e),J=i(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1bq702f"&&(J.innerHTML=Fe),ce=o(e),C=i(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-fqoolu"&&(C.innerHTML=Qe),re=o(e),M(f.$$.fragment,e),de=o(e),b=i(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-ae0hp9"&&(b.innerHTML=Ee),ye=o(e),M(j.$$.fragment,e),Me=o(e),M(G.$$.fragment,e),pe=o(e),g=i(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-byuygg"&&(g.innerHTML=Ne),we=o(e),I=i(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-w9p09z"&&(I.textContent=De),me=o(e),v=i(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1qb001k"&&(v.innerHTML=Ke),he=o(e),A=i(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-14tkwrb"&&(A.textContent=qe),ue=o(e),M(_.$$.fragment,e),Te=o(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-olrkxe"&&(B.innerHTML=Oe),Ue=o(e),k=i(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-cn8x56"&&(k.innerHTML=et),Je=o(e),M($.$$.fragment,e),Ce=o(e),x=i(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-18f8svj"&&(x.innerHTML=tt),fe=o(e),M(Z.$$.fragment,e),be=o(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-3ulfah"&&(H.innerHTML=lt),je=o(e),M(z.$$.fragment,e),Ge=o(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1b3vx79"&&(W.innerHTML=at),ge=o(e),M(V.$$.fragment,e),Ie=o(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1hdyapv"&&(R.textContent=nt),ve=o(e),S=i(e,"UL",{"data-svelte-h":!0}),c(S)!=="svelte-1d218dd"&&(S.innerHTML=ot),Ae=o(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-5qwyq6"&&(X.innerHTML=st),_e=o(e),P=i(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1yxh0lm"&&(P.innerHTML=it),Be=o(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1n0bzbn"&&(L.textContent=ct),ke=o(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1i6grvn"&&(Y.textContent=rt),$e=o(e),F=i(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-4pf5f1"&&(F.innerHTML=dt),xe=o(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-vdaq6p"&&(Q.textContent=yt),Ze=o(e),E=i(e,"TABLE",{"data-svelte-h":!0}),c(E)!=="svelte-sjfg3j"&&(E.innerHTML=Mt),He=o(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-yk2mxh"&&(N.textContent=pt),ze=o(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1ar0gwa"&&(D.innerHTML=wt),We=o(e),M(K.$$.fragment,e),Ve=o(e),q=i(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-rzu0c8"&&(q.innerHTML=mt),Re=o(e),O=i(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-vvl7g2"&&(O.innerHTML=ht),Se=o(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1s75xk0"&&(ee.innerHTML=ut),Xe=o(e),te=i(e,"TABLE",{"data-svelte-h":!0}),c(te)!=="svelte-iqaw47"&&(te.innerHTML=Tt),Pe=o(e),M(u.$$.fragment,e),Le=o(e),ae=i(e,"P",{}),Jt(ae).forEach(l),this.h()},h(){Ct(r,"name","hf:doc:metadata"),Ct(r,"content",kt)},m(e,t){vt(document.head,r),a(e,T,t),a(e,d,t),a(e,le,t),p(U,e,t),a(e,ie,t),a(e,J,t),a(e,ce,t),a(e,C,t),a(e,re,t),p(f,e,t),a(e,de,t),a(e,b,t),a(e,ye,t),p(j,e,t),a(e,Me,t),p(G,e,t),a(e,pe,t),a(e,g,t),a(e,we,t),a(e,I,t),a(e,me,t),a(e,v,t),a(e,he,t),a(e,A,t),a(e,ue,t),p(_,e,t),a(e,Te,t),a(e,B,t),a(e,Ue,t),a(e,k,t),a(e,Je,t),p($,e,t),a(e,Ce,t),a(e,x,t),a(e,fe,t),p(Z,e,t),a(e,be,t),a(e,H,t),a(e,je,t),p(z,e,t),a(e,Ge,t),a(e,W,t),a(e,ge,t),p(V,e,t),a(e,Ie,t),a(e,R,t),a(e,ve,t),a(e,S,t),a(e,Ae,t),a(e,X,t),a(e,_e,t),a(e,P,t),a(e,Be,t),a(e,L,t),a(e,ke,t),a(e,Y,t),a(e,$e,t),a(e,F,t),a(e,xe,t),a(e,Q,t),a(e,Ze,t),a(e,E,t),a(e,He,t),a(e,N,t),a(e,ze,t),a(e,D,t),a(e,We,t),p(K,e,t),a(e,Ve,t),a(e,q,t),a(e,Re,t),a(e,O,t),a(e,Se,t),a(e,ee,t),a(e,Xe,t),a(e,te,t),a(e,Pe,t),p(u,e,t),a(e,Le,t),a(e,ae,t),Ye=!0},p(e,[t]){const Ut={};t&2&&(Ut.$$scope={dirty:t,ctx:e}),u.$set(Ut)},i(e){Ye||(w(U.$$.fragment,e),w(f.$$.fragment,e),w(j.$$.fragment,e),w(G.$$.fragment,e),w(_.$$.fragment,e),w($.$$.fragment,e),w(Z.$$.fragment,e),w(z.$$.fragment,e),w(V.$$.fragment,e),w(K.$$.fragment,e),w(u.$$.fragment,e),Ye=!0)},o(e){m(U.$$.fragment,e),m(f.$$.fragment,e),m(j.$$.fragment,e),m(G.$$.fragment,e),m(_.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(z.$$.fragment,e),m(V.$$.fragment,e),m(K.$$.fragment,e),m(u.$$.fragment,e),Ye=!1},d(e){e&&(l(T),l(d),l(le),l(ie),l(J),l(ce),l(C),l(re),l(de),l(b),l(ye),l(Me),l(pe),l(g),l(we),l(I),l(me),l(v),l(he),l(A),l(ue),l(Te),l(B),l(Ue),l(k),l(Je),l(Ce),l(x),l(fe),l(be),l(H),l(je),l(Ge),l(W),l(ge),l(Ie),l(R),l(ve),l(S),l(Ae),l(X),l(_e),l(P),l(Be),l(L),l(ke),l(Y),l($e),l(F),l(xe),l(Q),l(Ze),l(E),l(He),l(N),l(ze),l(D),l(We),l(Ve),l(q),l(Re),l(O),l(Se),l(ee),l(Xe),l(te),l(Pe),l(Le),l(ae)),l(r),h(U,e),h(f,e),h(j,e),h(G,e),h(_,e),h($,e),h(Z,e),h(z,e),h(V,e),h(K,e),h(u,e)}}}const kt='{"title":"Gradient Synchronization","local":"gradient-synchronization","sections":[{"title":"The slowdown in gradient accumulation","local":"the-slowdown-in-gradient-accumulation","sections":[],"depth":2},{"title":"Solving the slowdown problem","local":"solving-the-slowdown-problem","sections":[],"depth":2},{"title":"Just how much of a slowdown is there, and easy mistakes you can make","local":"just-how-much-of-a-slowdown-is-there-and-easy-mistakes-you-can-make","sections":[{"title":"no_sync requires additional GPU memory when using FSDP","local":"nosync-requires-additional-gpu-memory-when-using-fsdp","sections":[],"depth":3}],"depth":2}],"depth":1}';function $t(se){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Gt{constructor(r){super(),gt(this,r,$t,Bt,ft,{})}}export{Vt as component};
