import{s as _t,n as kt,o as bt}from"../chunks/scheduler.9bc65507.js";import{S as vt,i as Tt,g as o,s as r,u as g,A as yt,h as s,f as t,c as a,j as p,v as u,y as m,k as c,o as n,a as l,w as _,d as k,t as b,x as v}from"../chunks/index.78c82d43.js";import{D as re}from"../chunks/Docstring.f3d04bd2.js";import{C as wt}from"../chunks/CodeBlock.48618ec2.js";import{I as Ze}from"../chunks/IconCopyLink.bedaa44d.js";function xt(He){let T,pe,ae,he,y,$,ie,z,Ue,Z,We="PhoBERT",me,w,J,le,E,ze,H,Xe="Overview",fe,V,Ye='The PhoBERT model was proposed in <a href="https://www.aclweb.org/anthology/2020.findings-emnlp.92.pdf" rel="nofollow">PhoBERT: Pre-trained language models for Vietnamese</a> by Dat Quoc Nguyen, Anh Tuan Nguyen.',ge,I,Oe="The abstract from the paper is the following:",ue,L,Ke=`<em>We present PhoBERT with two versions, PhoBERT-base and PhoBERT-large, the first public large-scale monolingual
language models pre-trained for Vietnamese. Experimental results show that PhoBERT consistently outperforms the recent
best pre-trained multilingual model XLM-R (Conneau et al., 2020) and improves the state-of-the-art in multiple
Vietnamese-specific NLP tasks including Part-of-speech tagging, Dependency parsing, Named-entity recognition and
Natural language inference.</em>`,_e,B,et="Example of use:",ke,R,be,j,tt='This model was contributed by <a href="https://huggingface.co/dqnguyen" rel="nofollow">dqnguyen</a>. The original code can be found <a href="https://github.com/VinAIResearch/PhoBERT" rel="nofollow">here</a>.',ve,x,C,de,D,Ee,W,nt="PhobertTokenizer",Te,d,N,Ve,X,ot="Construct a PhoBERT tokenizer. Based on Byte-Pair-Encoding.",Ie,Y,st=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Le,P,S,Be,O,rt="Loads a pre-existing dictionary from a text file and adds its symbols to this instance.",Re,f,G,je,K,at=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A PhoBERT sequence has the following format:`,De,ee,it="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",Ne,M,A,Se,te,lt="Converts a sequence of tokens (string) in a single string.",Ge,q,F,Ae,ne,dt=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. PhoBERT does not
make use of token type ids, therefore a list of zeros is returned.`,Fe,U,Q,Qe,oe,ct=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,ye,ce,we;return z=new Ze({}),E=new Ze({}),R=new wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXBob2JlcnQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGcGhvYmVydC1iYXNlJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGcGhvYmVydC1iYXNlJTIyKSUwQSUwQSUyMyUyMElOUFVUJTIwVEVYVCUyME1VU1QlMjBCRSUyMEFMUkVBRFklMjBXT1JELVNFR01FTlRFRCElMEFsaW5lJTIwJTNEJTIwJTIyVCVDMyVCNGklMjBsJUMzJUEwJTIwc2luaF92aSVDMyVBQW4lMjB0ciVDNiVCMCVFMSVCQiU5RG5nJTIwJUM0JTkxJUUxJUJBJUExaV9oJUUxJUJCJThEYyUyMEMlQzMlQjRuZ19uZ2glRTElQkIlODclMjAuJTIyJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUobGluZSklNUQpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGZlYXR1cmVzJTIwJTNEJTIwcGhvYmVydChpbnB1dF9pZHMpJTIwJTIwJTIzJTIwTW9kZWxzJTIwb3V0cHV0cyUyMGFyZSUyMG5vdyUyMHR1cGxlcyUwQSUwQSUyMyUyMFdpdGglMjBUZW5zb3JGbG93JTIwMi4wJTJCJTNBJTBBJTIzJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsJTBBJTIzJTIwcGhvYmVydCUyMCUzRCUyMFRGQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRnBob2JlcnQtYmFzZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>phobert = AutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/phobert-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vinai/phobert-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># INPUT TEXT MUST BE ALREADY WORD-SEGMENTED!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>line = <span class="hljs-string">&quot;Tôi là sinh_viên trường đại_học Công_nghệ .&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(line)])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    features = phobert(input_ids)  <span class="hljs-comment"># Models outputs are now tuples</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With TensorFlow 2.0+:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># from transformers import TFAutoModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># phobert = TFAutoModel.from_pretrained(&quot;vinai/phobert-base&quot;)</span>`}}),D=new Ze({}),N=new re({props:{name:"class transformers.PhobertTokenizer",anchor:"transformers.PhobertTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhobertTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.PhobertTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.PhobertTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>st</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.PhobertTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PhobertTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.PhobertTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.PhobertTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.PhobertTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PhobertTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L68"}}),S=new re({props:{name:"add_from_file",anchor:"transformers.PhobertTokenizer.add_from_file",parameters:[{name:"f",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L345"}}),G=new re({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.PhobertTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.PhobertTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.PhobertTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L164",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),A=new re({props:{name:"convert_tokens_to_string",anchor:"transformers.PhobertTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L311"}}),F=new re({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.PhobertTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.PhobertTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.PhobertTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L218",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Q=new re({props:{name:"get_special_tokens_mask",anchor:"transformers.PhobertTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.PhobertTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.PhobertTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.PhobertTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/phobert/tokenization_phobert.py#L190",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),{c(){T=o("meta"),pe=r(),ae=o("p"),he=r(),y=o("h1"),$=o("a"),ie=o("span"),g(z.$$.fragment),Ue=r(),Z=o("span"),Z.textContent=We,me=r(),w=o("h2"),J=o("a"),le=o("span"),g(E.$$.fragment),ze=r(),H=o("span"),H.textContent=Xe,fe=r(),V=o("p"),V.innerHTML=Ye,ge=r(),I=o("p"),I.textContent=Oe,ue=r(),L=o("p"),L.innerHTML=Ke,_e=r(),B=o("p"),B.textContent=et,ke=r(),g(R.$$.fragment),be=r(),j=o("p"),j.innerHTML=tt,ve=r(),x=o("h2"),C=o("a"),de=o("span"),g(D.$$.fragment),Ee=r(),W=o("span"),W.textContent=nt,Te=r(),d=o("div"),g(N.$$.fragment),Ve=r(),X=o("p"),X.textContent=ot,Ie=r(),Y=o("p"),Y.innerHTML=st,Le=r(),P=o("div"),g(S.$$.fragment),Be=r(),O=o("p"),O.textContent=rt,Re=r(),f=o("div"),g(G.$$.fragment),je=r(),K=o("p"),K.textContent=at,De=r(),ee=o("ul"),ee.innerHTML=it,Ne=r(),M=o("div"),g(A.$$.fragment),Se=r(),te=o("p"),te.textContent=lt,Ge=r(),q=o("div"),g(F.$$.fragment),Ae=r(),ne=o("p"),ne.textContent=dt,Fe=r(),U=o("div"),g(Q.$$.fragment),Qe=r(),oe=o("p"),oe.innerHTML=ct,ye=r(),ce=o("p"),this.h()},l(e){const i=yt("svelte-1phssyn",document.head);T=s(i,"META",{name:!0,content:!0}),i.forEach(t),pe=a(e),ae=s(e,"P",{}),p(ae).forEach(t),he=a(e),y=s(e,"H1",{class:!0});var xe=p(y);$=s(xe,"A",{id:!0,class:!0,href:!0});var pt=p($);ie=s(pt,"SPAN",{});var ht=p(ie);u(z.$$.fragment,ht),ht.forEach(t),pt.forEach(t),Ue=a(xe),Z=s(xe,"SPAN",{"data-svelte-h":!0}),m(Z)!=="svelte-1nok3ut"&&(Z.textContent=We),xe.forEach(t),me=a(e),w=s(e,"H2",{class:!0});var $e=p(w);J=s($e,"A",{id:!0,class:!0,href:!0});var mt=p(J);le=s(mt,"SPAN",{});var ft=p(le);u(E.$$.fragment,ft),ft.forEach(t),mt.forEach(t),ze=a($e),H=s($e,"SPAN",{"data-svelte-h":!0}),m(H)!=="svelte-1jsw1pg"&&(H.textContent=Xe),$e.forEach(t),fe=a(e),V=s(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ao5fqi"&&(V.innerHTML=Ye),ge=a(e),I=s(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-vfdo9a"&&(I.textContent=Oe),ue=a(e),L=s(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-pnlemp"&&(L.innerHTML=Ke),_e=a(e),B=s(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1euxn0a"&&(B.textContent=et),ke=a(e),u(R.$$.fragment,e),be=a(e),j=s(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-cbf0gj"&&(j.innerHTML=tt),ve=a(e),x=s(e,"H2",{class:!0});var Je=p(x);C=s(Je,"A",{id:!0,class:!0,href:!0});var gt=p(C);de=s(gt,"SPAN",{});var ut=p(de);u(D.$$.fragment,ut),ut.forEach(t),gt.forEach(t),Ee=a(Je),W=s(Je,"SPAN",{"data-svelte-h":!0}),m(W)!=="svelte-imj9y4"&&(W.textContent=nt),Je.forEach(t),Te=a(e),d=s(e,"DIV",{class:!0});var h=p(d);u(N.$$.fragment,h),Ve=a(h),X=s(h,"P",{"data-svelte-h":!0}),m(X)!=="svelte-f1kmpq"&&(X.textContent=ot),Ie=a(h),Y=s(h,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-14xlfoy"&&(Y.innerHTML=st),Le=a(h),P=s(h,"DIV",{class:!0});var Ce=p(P);u(S.$$.fragment,Ce),Be=a(Ce),O=s(Ce,"P",{"data-svelte-h":!0}),m(O)!=="svelte-ooaeix"&&(O.textContent=rt),Ce.forEach(t),Re=a(h),f=s(h,"DIV",{class:!0});var se=p(f);u(G.$$.fragment,se),je=a(se),K=s(se,"P",{"data-svelte-h":!0}),m(K)!=="svelte-dhtv7"&&(K.textContent=at),De=a(se),ee=s(se,"UL",{"data-svelte-h":!0}),m(ee)!=="svelte-rq8uot"&&(ee.innerHTML=it),se.forEach(t),Ne=a(h),M=s(h,"DIV",{class:!0});var Pe=p(M);u(A.$$.fragment,Pe),Se=a(Pe),te=s(Pe,"P",{"data-svelte-h":!0}),m(te)!=="svelte-b3k2yi"&&(te.textContent=lt),Pe.forEach(t),Ge=a(h),q=s(h,"DIV",{class:!0});var Me=p(q);u(F.$$.fragment,Me),Ae=a(Me),ne=s(Me,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-qg6q9n"&&(ne.textContent=dt),Me.forEach(t),Fe=a(h),U=s(h,"DIV",{class:!0});var qe=p(U);u(Q.$$.fragment,qe),Qe=a(qe),oe=s(qe,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1f4f5kp"&&(oe.innerHTML=ct),qe.forEach(t),h.forEach(t),ye=a(e),ce=s(e,"P",{}),p(ce).forEach(t),this.h()},h(){c(T,"name","hf:doc:metadata"),c(T,"content",JSON.stringify($t)),c($,"id","phobert"),c($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c($,"href","#phobert"),c(y,"class","relative group"),c(J,"id","overview"),c(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(J,"href","#overview"),c(w,"class","relative group"),c(C,"id","transformers.PhobertTokenizer"),c(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(C,"href","#transformers.PhobertTokenizer"),c(x,"class","relative group"),c(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){n(document.head,T),l(e,pe,i),l(e,ae,i),l(e,he,i),l(e,y,i),n(y,$),n($,ie),_(z,ie,null),n(y,Ue),n(y,Z),l(e,me,i),l(e,w,i),n(w,J),n(J,le),_(E,le,null),n(w,ze),n(w,H),l(e,fe,i),l(e,V,i),l(e,ge,i),l(e,I,i),l(e,ue,i),l(e,L,i),l(e,_e,i),l(e,B,i),l(e,ke,i),_(R,e,i),l(e,be,i),l(e,j,i),l(e,ve,i),l(e,x,i),n(x,C),n(C,de),_(D,de,null),n(x,Ee),n(x,W),l(e,Te,i),l(e,d,i),_(N,d,null),n(d,Ve),n(d,X),n(d,Ie),n(d,Y),n(d,Le),n(d,P),_(S,P,null),n(P,Be),n(P,O),n(d,Re),n(d,f),_(G,f,null),n(f,je),n(f,K),n(f,De),n(f,ee),n(d,Ne),n(d,M),_(A,M,null),n(M,Se),n(M,te),n(d,Ge),n(d,q),_(F,q,null),n(q,Ae),n(q,ne),n(d,Fe),n(d,U),_(Q,U,null),n(U,Qe),n(U,oe),l(e,ye,i),l(e,ce,i),we=!0},p:kt,i(e){we||(k(z.$$.fragment,e),k(E.$$.fragment,e),k(R.$$.fragment,e),k(D.$$.fragment,e),k(N.$$.fragment,e),k(S.$$.fragment,e),k(G.$$.fragment,e),k(A.$$.fragment,e),k(F.$$.fragment,e),k(Q.$$.fragment,e),we=!0)},o(e){b(z.$$.fragment,e),b(E.$$.fragment,e),b(R.$$.fragment,e),b(D.$$.fragment,e),b(N.$$.fragment,e),b(S.$$.fragment,e),b(G.$$.fragment,e),b(A.$$.fragment,e),b(F.$$.fragment,e),b(Q.$$.fragment,e),we=!1},d(e){e&&(t(pe),t(ae),t(he),t(y),t(me),t(w),t(fe),t(V),t(ge),t(I),t(ue),t(L),t(_e),t(B),t(ke),t(be),t(j),t(ve),t(x),t(Te),t(d),t(ye),t(ce)),t(T),v(z),v(E),v(R,e),v(D),v(N),v(S),v(G),v(A),v(F),v(Q)}}}const $t={local:"phobert",sections:[{local:"overview",title:"Overview"},{local:"transformers.PhobertTokenizer",title:"PhobertTokenizer"}],title:"PhoBERT"};function Jt(He){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends vt{constructor(T){super(),Tt(this,T,Jt,xt,_t,{})}}export{zt as component};
