import{s as tn,o as pn,n as on}from"../chunks/scheduler.9bc65507.js";import{S as cn,i as rn,g as p,s as n,u as c,m as ya,A as hn,h as i,f as l,c as t,j as J,v as r,y as o,n as da,k as u,o as y,a as e,w as h,d as m,t as j,x as M}from"../chunks/index.78c82d43.js";import{T as mn}from"../chunks/Tip.87d55b76.js";import{I as oa}from"../chunks/IconCopyLink.bedaa44d.js";import{C as d}from"../chunks/CodeBlock.48618ec2.js";import{D as jn}from"../chunks/DocNotebookDropdown.40f7599b.js";function Mn(Ja){let b,U,Z='<a href="../model_doc/conditional_detr">Conditional DETR</a>, <a href="../model_doc/deformable_detr">Deformable DETR</a>, <a href="../model_doc/deta">DETA</a>, <a href="../model_doc/detr">DETR</a>, <a href="../model_doc/table-transformer">Table Transformer</a>, <a href="../model_doc/yolos">YOLOS</a>';return{c(){b=ya(`The task illustrated in this tutorial is supported by the following model architectures:

`),U=p("p"),U.innerHTML=Z},l(T){b=da(T,`The task illustrated in this tutorial is supported by the following model architectures:

`),U=i(T,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1cb65l9"&&(U.innerHTML=Z)},m(T,w){e(T,b,w),e(T,U,w)},p:on,d(T){T&&(l(b),l(U))}}}function un(Ja){let b,U,Z,T,w,A,ca,V,Hl,la,Pl="Object detection",ba,X,Ua,N,Kl=`Object detection is the computer vision task of detecting instances (such as humans, buildings, or cars) in an image. Object detection models receive an image as input and output
coordinates of the bounding boxes and associated labels of the detected objects. An image can contain multiple objects,
each with its own bounding box and a label (e.g. it can have a car and a building), and each object can
be present in different parts of an image (e.g. the image can have several cars).
This task is commonly used in autonomous driving for detecting things like pedestrians, road signs, and traffic lights.
Other applications include counting objects in images, image search, and more.`,Ta,Y,Ol="In this guide, you will learn how to:",wa,q,se=`<li>Finetune <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>, a model that combines a convolutional
backbone with an encoder-decoder Transformer, on the <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a>
dataset.</li> <li>Use your finetuned model for inference.</li>`,ga,_,Ia,F,ae="Before you begin, make sure you have all the necessary libraries installed:",fa,H,Ca,z,le=`You’ll use 🤗 Datasets to load a dataset from the Hugging Face Hub, 🤗 Transformers to train your model,
and <code>albumentations</code> to augment the data. <code>timm</code> is currently required to load a convolutional backbone for the DETR model.`,va,$,ee=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the Hub.
When prompted, enter your token to log in:`,Za,S,Aa,g,B,ra,D,zl,ea,ne="Load the CPPE-5 dataset",_a,L,te=`The <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5 dataset</a> contains images with
annotations identifying medical personal protective equipment (PPE) in the context of the COVID-19 pandemic.`,Ba,P,pe="Start by loading the dataset:",xa,K,Wa,O,ie="You’ll see that this dataset already comes with a training set containing 1000 images and a test set with 29 images.",Ga,ss,oe="To get familiar with the data, explore what the examples look like.",ka,as,Qa,ls,ce="The examples in the dataset have the following fields:",Ra,es,re='<li><code>image_id</code>: the example image id</li> <li><code>image</code>: a <code>PIL.Image.Image</code> object containing the image</li> <li><code>width</code>: width of the image</li> <li><code>height</code>: height of the image</li> <li><code>objects</code>: a dictionary containing bounding box metadata for the objects in the image:<ul><li><code>id</code>: the annotation id</li> <li><code>area</code>: the area of the bounding box</li> <li><code>bbox</code>: the object’s bounding box (in the <a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">COCO format</a> )</li> <li><code>category</code>: the object’s category, with possible values including <code>Coverall (0)</code>, <code>Face_Shield (1)</code>, <code>Gloves (2)</code>, <code>Goggles (3)</code> and <code>Mask (4)</code></li></ul></li>',Ea,ns,he=`You may notice that the <code>bbox</code> field follows the COCO format, which is the format that the DETR model expects.
However, the grouping of the fields inside <code>objects</code> differs from the annotation format DETR requires. You will
need to apply some preprocessing transformations before using this data for training.`,Va,ts,me="To get an even better understanding of the data, visualize an example in the dataset.",Xa,ps,Na,x,je='<img src="https://i.imgur.com/TdaqPJO.png" alt="CPPE-5 Image Example"/>',Ya,is,Me=`To visualize the bounding boxes with associated labels, you can get the labels from the dataset’s metadata, specifically
the <code>category</code> field.
You’ll also want to create dictionaries that map a label id to a label class (<code>id2label</code>) and the other way around (<code>label2id</code>).
You can use them later when setting up the model. Including these maps will make your model reusable by others if you share
it on the Hugging Face Hub.`,qa,os,ue=`As a final step of getting familiar with the data, explore it for potential issues. One common problem with datasets for
object detection is bounding boxes that “stretch” beyond the edge of the image. Such “runaway” bounding boxes can raise
errors during training and should be addressed at this stage. There are a few examples with this issue in this dataset.
To keep things simple in this guide, we remove these images from the data.`,Fa,cs,Ha,I,W,ha,rs,$l,na,ye="Preprocess the data",za,hs,de=`To finetune a model, you must preprocess the data you plan to use to match precisely the approach used for the pre-trained model.
<a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> takes care of processing image data to create <code>pixel_values</code>, <code>pixel_mask</code>, and
<code>labels</code> that a DETR model can train with. The image processor has some attributes that you won’t have to worry about:`,$a,ms,Je="<li><code>image_mean = [0.485, 0.456, 0.406 ]</code></li> <li><code>image_std = [0.229, 0.224, 0.225]</code></li>",Sa,js,be=`These are the mean and standard deviation used to normalize images during the model pre-training. These values are crucial
to replicate when doing inference or finetuning a pre-trained image model.`,Da,Ms,Ue="Instantiate the image processor from the same checkpoint as the model you want to finetune.",La,us,Pa,ys,Te="Before passing the images to the <code>image_processor</code>, apply two preprocessing transformations to the dataset:",Ka,ds,we="<li>Augmenting images</li> <li>Reformatting annotations to meet DETR expectations</li>",Oa,Js,ge=`First, to make sure the model does not overfit on the training data, you can apply image augmentation with any data augmentation library. Here we use <a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a> …
This library ensures that transformations affect the image and update the bounding boxes accordingly.
The 🤗 Datasets library documentation has a detailed <a href="https://huggingface.co/docs/datasets/object_detection" rel="nofollow">guide on how to augment images for object detection</a>,
and it uses the exact same dataset as an example. Apply the same approach here, resize each image to (480, 480),
flip it horizontally, and brighten it:`,sl,bs,al,Us,Ie=`The <code>image_processor</code> expects the annotations to be in the following format: <code>{&#39;image_id&#39;: int, &#39;annotations&#39;: List[Dict]}</code>,
where each dictionary is a COCO object annotation. Let’s add a function to reformat annotations for a single example:`,ll,Ts,el,ws,fe="Now you can combine the image and annotation transformations to use on a batch of examples:",nl,gs,tl,Is,Ce=`Apply this preprocessing function to the entire dataset using 🤗 Datasets <a href="https://huggingface.co/docs/datasets/v2.14.5/en/package_reference/main_classes#datasets.Dataset.with_transform" rel="nofollow">with_transform</a> method. This method applies
transformations on the fly when you load an element of the dataset.`,pl,fs,ve=`At this point, you can check what an example from the dataset looks like after the transformations. You should see a tensor
with <code>pixel_values</code>, a tensor with <code>pixel_mask</code>, and <code>labels</code>.`,il,Cs,ol,vs,Ze=`You have successfully augmented the individual images and prepared their annotations. However, preprocessing isn’t
complete yet. In the final step, create a custom <code>collate_fn</code> to batch images together.
Pad images (which are now <code>pixel_values</code>) to the largest image in a batch, and create a corresponding <code>pixel_mask</code>
to indicate which pixels are real (1) and which are padding (0).`,cl,Zs,rl,f,G,ma,As,Sl,ta,Ae="Training the DETR model",hl,_s,_e="Training involves the following steps:",ml,Bs,Be='<li>Load the model with <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoModelForObjectDetection">AutoModelForObjectDetection</a> using the same checkpoint as in the preprocessing.</li> <li>Define your training hyperparameters in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.</li> <li>Pass the training arguments to <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, image processor, and data collator.</li> <li>Call <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',jl,xs,xe=`When loading the model from the same checkpoint that you used for the preprocessing, remember to pass the <code>label2id</code>
and <code>id2label</code> maps that you created earlier from the dataset’s metadata. Additionally, we specify <code>ignore_mismatched_sizes=True</code> to replace the existing classification head with a new one.`,Ml,Ws,ul,Gs,We=`In the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> use <code>output_dir</code> to specify where to save your model, then configure hyperparameters as you see fit.
It is important you do not remove unused columns because this will drop the image column. Without the image column, you
can’t create <code>pixel_values</code>. For this reason, set <code>remove_unused_columns</code> to <code>False</code>.
If you wish to share your model by pushing to the Hub, set <code>push_to_hub</code> to <code>True</code> (you must be signed in to Hugging
Face to upload your model).`,yl,ks,dl,Qs,Ge='Finally, bring everything together, and call <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer.train">train()</a>:',Jl,Rs,bl,Es,ke=`If you have set <code>push_to_hub</code> to <code>True</code> in the <code>training_args</code>, the training checkpoints are pushed to the
Hugging Face Hub. Upon training completion, push the final model to the Hub as well by calling the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method.`,Ul,Vs,Tl,C,k,ja,Xs,Dl,pa,Qe="Evaluate",wl,Q,Re="COCO-style metrics",gl,Ns,Ee=`To use the <code>torchvision</code> evaluator, you’ll need to prepare a ground truth COCO dataset. The API to build a COCO dataset
requires the data to be stored in a certain format, so you’ll need to save images and annotations to disk first. Just like
when you prepared your data for training, the annotations from the <code>cppe5[&quot;test&quot;]</code> need to be formatted. However, images
should stay as they are.`,Il,Ys,Ve=`The evaluation step requires a bit of work, but it can be split in three major steps.
First, prepare the <code>cppe5[&quot;test&quot;]</code> set: format the annotations and save the data to disk.`,fl,qs,Cl,Fs,Xe="Next, prepare an instance of a <code>CocoDetection</code> class that can be used with <code>cocoevaluator</code>.",vl,Hs,Zl,zs,Ne="Finally, load the metrics and run the evaluation.",Al,$s,_l,Ss,Ye='These results can be further improved by adjusting the hyperparameters in <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>. Give it a go!',Bl,v,R,Ma,Ds,Ll,ia,qe="Inference",xl,Ls,Wl,Ps,Fe="You can also manually replicate the results of the pipeline if you’d like:",Gl,Ks,kl,Os,He="Let’s plot the result:",Ql,sa,Rl,E,ze='<img src="https://i.imgur.com/4QZnf9A.png" alt="Object detection result on a new image"/>',El,ua,Vl;return V=new oa({}),X=new jn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/object_detection.ipynb"}]}}),_=new mn({props:{$$slots:{default:[Mn]},$$scope:{ctx:Ja}}}),H=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBldmFsdWF0ZSUyMHRpbW0lMjBhbGJ1bWVudGF0aW9ucw==",highlighted:"pip install -q datasets transformers evaluate timm albumentations"}}),S=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),D=new oa({}),K=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY3BwZTUlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWNwcGU1",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5 = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">29</span>
    })
})`}}),as=new d({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7F9EC9E77C10</span>&gt;,
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>,
 <span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>],
  <span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]}}`}}),ps=new d({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMkMlMjBJbWFnZURyYXclMEElMEFpbWFnZSUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQlMEFhbm5vdGF0aW9ucyUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyb2JqZWN0cyUyMiU1RCUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFjYXRlZ29yaWVzJTIwJTNEJTIwY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMm9iamVjdHMlMjIlNUQuZmVhdHVyZSU1QiUyMmNhdGVnb3J5JTIyJTVELm5hbWVzJTBBJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpbmRleCUzQSUyMHglMjBmb3IlMjBpbmRleCUyQyUyMHglMjBpbiUyMGVudW1lcmF0ZShjYXRlZ29yaWVzJTJDJTIwc3RhcnQlM0QwKSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihhbm5vdGF0aW9ucyU1QiUyMmlkJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmJib3glMjIlNUQlNUJpJTIwLSUyMDElNUQlMEElMjAlMjAlMjAlMjBjbGFzc19pZHglMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmNhdGVnb3J5JTIyJTVEJTVCaSUyMC0lMjAxJTVEJTBBJTIwJTIwJTIwJTIweCUyQyUyMHklMkMlMjB3JTJDJTIwaCUyMCUzRCUyMHR1cGxlKGJveCklMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeCUyQyUyMHklMkMlMjB4JTIwJTJCJTIwdyUyQyUyMHklMjAlMkIlMjBoKSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4JTJDJTIweSklMkMlMjBpZDJsYWJlbCU1QmNsYXNzX2lkeCU1RCUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>image = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>annotations = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = cppe5[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;objects&quot;</span>].feature[<span class="hljs-string">&quot;category&quot;</span>].names

<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {index: x <span class="hljs-keyword">for</span> index, x <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(categories, start=<span class="hljs-number">0</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>    box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i - <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    class_idx = annotations[<span class="hljs-string">&quot;category&quot;</span>][i - <span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    x, y, w, h = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x + w, y + h), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), id2label[class_idx], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),cs=new d({props:{code:"cmVtb3ZlX2lkeCUyMCUzRCUyMCU1QjU5MCUyQyUyMDgyMSUyQyUyMDgyMiUyQyUyMDg3NSUyQyUyMDg3NiUyQyUyMDg3OCUyQyUyMDg3OSU1RCUwQWtlZXAlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNwcGU1JTVCJTIydHJhaW4lMjIlNUQpKSUyMGlmJTIwaSUyMG5vdCUyMGluJTIwcmVtb3ZlX2lkeCU1RCUwQWNwcGU1JTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjcHBlNSU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChrZWVwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>remove_idx = [<span class="hljs-number">590</span>, <span class="hljs-number">821</span>, <span class="hljs-number">822</span>, <span class="hljs-number">875</span>, <span class="hljs-number">876</span>, <span class="hljs-number">878</span>, <span class="hljs-number">879</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>keep = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(cppe5[<span class="hljs-string">&quot;train&quot;</span>])) <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> remove_idx]
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].select(keep)`}}),rs=new oa({}),us=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIyJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)`}}),bs=new d({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRyYW5zZm9ybSUyMCUzRCUyMGFsYnVtZW50YXRpb25zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmVzaXplKDQ4MCUyQyUyMDQ4MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5Ib3Jpem9udGFsRmxpcChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEYWxidW1lbnRhdGlvbnMuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJjb2NvJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>        albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;coco&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
<span class="hljs-meta">... </span>)`}}),Ts=new d({props:{code:"ZGVmJTIwZm9ybWF0dGVkX2FubnMoaW1hZ2VfaWQlMkMlMjBjYXRlZ29yeSUyQyUyMGFyZWElMkMlMjBiYm94KSUzQSUwQSUyMCUyMCUyMCUyMGFubm90YXRpb25zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihjYXRlZ29yeSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X2FubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX2lkJTIyJTNBJTIwaW1hZ2VfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeV9pZCUyMiUzQSUyMGNhdGVnb3J5JTVCaSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzQ3Jvd2QlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJlYSUyMiUzQSUyMGFyZWElNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmJveCUyMiUzQSUyMGxpc3QoYmJveCU1QmklNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMuYXBwZW5kKG5ld19hbm4pJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5ub3RhdGlvbnM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: area[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations`}}),gs=new d({props:{code:"JTIzJTIwdHJhbnNmb3JtaW5nJTIwYSUyMGJhdGNoJTBBZGVmJTIwdHJhbnNmb3JtX2F1Z19hbm4oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaWRzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJpbWFnZV9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyQyUyMGJib3hlcyUyQyUyMGFyZWElMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyb2JqZWN0cyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklNUIlM0ElMkMlMjAlM0ElMkMlMjAlM0ElM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwYmJveGVzJTNEb2JqZWN0cyU1QiUyMmJib3glMjIlNUQlMkMlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUIlMjJjYXRlZ29yeSUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmVhLmFwcGVuZChvYmplY3RzJTVCJTIyYXJlYSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKG91dCU1QiUyMmltYWdlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcy5hcHBlbmQob3V0JTVCJTIyYmJveGVzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QiUyMmNhdGVnb3J5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJpbWFnZV9pZCUyMiUzQSUyMGlkXyUyQyUyMCUyMmFubm90YXRpb25zJTIyJTNBJTIwZm9ybWF0dGVkX2FubnMoaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8pJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8lMjBpbiUyMHppcChpbWFnZV9pZHMlMkMlMjBjYXRlZ29yaWVzJTJDJTIwYXJlYSUyQyUyMGJib3hlcyklMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwYW5ub3RhdGlvbnMlM0R0YXJnZXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transforming a batch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
<span class="hljs-meta">... </span>    images, bboxes, area, categories = [], [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
<span class="hljs-meta">... </span>        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        bboxes.append(out[<span class="hljs-string">&quot;bboxes&quot;</span>])
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>    targets = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`}}),Cs=new d({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQud2l0aF90cmFuc2Zvcm0odHJhbnNmb3JtX2F1Z19hbm4pJTBBY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjE1JTVEJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].with_transform(transform_aug_ann)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">15</span>]
{<span class="hljs-string">&#x27;pixel_values&#x27;</span>: tensor([[[ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>],
          ...,
          [-<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>]],

         [[ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>],
          ...,
          [-<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>]],

         [[ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>],
          ...,
          [-<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>]]]),
 <span class="hljs-string">&#x27;pixel_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         ...,
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: {<span class="hljs-string">&#x27;size&#x27;</span>: tensor([<span class="hljs-number">800</span>, <span class="hljs-number">800</span>]), <span class="hljs-string">&#x27;image_id&#x27;</span>: tensor([<span class="hljs-number">756</span>]), <span class="hljs-string">&#x27;class_labels&#x27;</span>: tensor([<span class="hljs-number">4</span>]), <span class="hljs-string">&#x27;boxes&#x27;</span>: tensor([[<span class="hljs-number">0.7340</span>, <span class="hljs-number">0.6986</span>, <span class="hljs-number">0.3414</span>, <span class="hljs-number">0.5944</span>]]), <span class="hljs-string">&#x27;area&#x27;</span>: tensor([<span class="hljs-number">519544.4375</span>]), <span class="hljs-string">&#x27;iscrowd&#x27;</span>: tensor([<span class="hljs-number">0</span>]), <span class="hljs-string">&#x27;orig_size&#x27;</span>: tensor([<span class="hljs-number">480</span>, <span class="hljs-number">480</span>])}}`}}),Zs=new d({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    batch = {}
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`}}),As=new oa({}),Ws=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`}}),ks=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJkZXRyLXJlc25ldC01MF9maW5ldHVuZWRfY3BwZTUlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QxZS00JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDIlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;detr-resnet-50_finetuned_cppe5&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">1e-4</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`}}),Rs=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RjcHBlNSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>    train_dataset=cppe5[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`}}),Vs=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()'}}),Xs=new oa({}),qs=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># format annotations the same as for training, no need for data augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_formatted_anns</span>(<span class="hljs-params">image_id, objects</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(objects[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;id&quot;</span>: objects[<span class="hljs-string">&quot;id&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: objects[<span class="hljs-string">&quot;category&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;iscrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: objects[<span class="hljs-string">&quot;area&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: objects[<span class="hljs-string">&quot;bbox&quot;</span>][i],
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save images and annotations into the files torchvision.datasets.CocoDetection expects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_cppe5_annotation_file_images</span>(<span class="hljs-params">cppe5</span>):
<span class="hljs-meta">... </span>    output_json = {}
<span class="hljs-meta">... </span>    path_output_cppe5 = <span class="hljs-string">f&quot;<span class="hljs-subst">{os.getcwd()}</span>/cppe5/&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(path_output_cppe5):
<span class="hljs-meta">... </span>        os.makedirs(path_output_cppe5)

<span class="hljs-meta">... </span>    path_anno = os.path.join(path_output_cppe5, <span class="hljs-string">&quot;cppe5_ann.json&quot;</span>)
<span class="hljs-meta">... </span>    categories_json = [{<span class="hljs-string">&quot;supercategory&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>, <span class="hljs-string">&quot;name&quot;</span>: id2label[<span class="hljs-built_in">id</span>]} <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> id2label]
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;images&quot;</span>] = []
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;annotations&quot;</span>] = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> cppe5:
<span class="hljs-meta">... </span>        ann = val_formatted_anns(example[<span class="hljs-string">&quot;image_id&quot;</span>], example[<span class="hljs-string">&quot;objects&quot;</span>])
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;images&quot;</span>].append(
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;id&quot;</span>: example[<span class="hljs-string">&quot;image_id&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;width&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].width,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;height&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].height,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;file_name&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span>.png&quot;</span>,
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;annotations&quot;</span>].extend(ann)
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;categories&quot;</span>] = categories_json

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(path_anno, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>        json.dump(output_json, file, ensure_ascii=<span class="hljs-literal">False</span>, indent=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> im, img_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(cppe5[<span class="hljs-string">&quot;image&quot;</span>], cppe5[<span class="hljs-string">&quot;image_id&quot;</span>]):
<span class="hljs-meta">... </span>        path_img = os.path.join(path_output_cppe5, <span class="hljs-string">f&quot;<span class="hljs-subst">{img_id}</span>.png&quot;</span>)
<span class="hljs-meta">... </span>        im.save(path_img)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> path_output_cppe5, path_anno`}}),Hs=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">CocoDetection</span>(torchvision.datasets.CocoDetection):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, img_folder, image_processor, ann_file</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__(img_folder, ann_file)
<span class="hljs-meta">... </span>        self.image_processor = image_processor

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># read in PIL image and target in COCO format</span>
<span class="hljs-meta">... </span>        img, target = <span class="hljs-built_in">super</span>(CocoDetection, self).__getitem__(idx)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># preprocess image and target: converting target to DETR format,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># resizing + normalization of both image and target)</span>
<span class="hljs-meta">... </span>        image_id = self.ids[idx]
<span class="hljs-meta">... </span>        target = {<span class="hljs-string">&quot;image_id&quot;</span>: image_id, <span class="hljs-string">&quot;annotations&quot;</span>: target}
<span class="hljs-meta">... </span>        encoding = self.image_processor(images=img, annotations=target, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>        pixel_values = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>].squeeze()  <span class="hljs-comment"># remove batch dimension</span>
<span class="hljs-meta">... </span>        target = encoding[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]  <span class="hljs-comment"># remove batch dimension</span>

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: target}


<span class="hljs-meta">&gt;&gt;&gt; </span>im_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>path_output_cppe5, path_anno = save_cppe5_annotation_file_images(cppe5[<span class="hljs-string">&quot;test&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds_coco_format = CocoDetection(path_output_cppe5, im_processor, path_anno)`}}),$s=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>module = evaluate.load(<span class="hljs-string">&quot;ybelkada/cocoevaluate&quot;</span>, coco=test_ds_coco_format.coco)
<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataloader = torch.utils.data.DataLoader(
<span class="hljs-meta">... </span>    test_ds_coco_format, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">False</span>, num_workers=<span class="hljs-number">4</span>, collate_fn=collate_fn
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(val_dataloader)):
<span class="hljs-meta">... </span>        pixel_values = batch[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>        pixel_mask = batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>]

<span class="hljs-meta">... </span>        labels = [
<span class="hljs-meta">... </span>            {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> t.items()} <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        ]  <span class="hljs-comment"># these are in DETR format, resized + normalized</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>        outputs = model(pixel_values=pixel_values, pixel_mask=pixel_mask)

<span class="hljs-meta">... </span>        orig_target_sizes = torch.stack([target[<span class="hljs-string">&quot;orig_size&quot;</span>] <span class="hljs-keyword">for</span> target <span class="hljs-keyword">in</span> labels], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        results = im_processor.post_process(outputs, orig_target_sizes)  <span class="hljs-comment"># convert outputs of model to COCO api</span>

<span class="hljs-meta">... </span>        module.add(prediction=results, reference=labels)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>results = module.compute()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
Accumulating evaluation results...
DONE (t=<span class="hljs-number">0.08</span>s).
IoU metric: bbox
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.352</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.681</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.75</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.292</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.168</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.208</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.429</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=  <span class="hljs-number">1</span> ] = <span class="hljs-number">0.274</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets= <span class="hljs-number">10</span> ] = <span class="hljs-number">0.484</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.501</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.191</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.323</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.590</span>`}}),Ds=new oa({}),Ls=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmkuaW1ndXIuY29tJTJGMmxuV29seS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFvYmpfZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW9ial9kZXRlY3RvcihpbWFnZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://i.imgur.com/2lnWoly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector(image)`}}),Ks=new d({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIwJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected Coverall <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.566</span> at location [<span class="hljs-number">1215.32</span>, <span class="hljs-number">147.38</span>, <span class="hljs-number">4401.81</span>, <span class="hljs-number">3227.08</span>]
Detected Mask <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.584</span> at location [<span class="hljs-number">2449.06</span>, <span class="hljs-number">823.19</span>, <span class="hljs-number">3256.43</span>, <span class="hljs-number">1413.9</span>]`}}),sa=new d({props:{code:"ZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHglMkMlMjB5JTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeCUyQyUyMHkpJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    x, y, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), model.config.id2label[label.item()], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`}}),{c(){b=p("meta"),U=n(),Z=p("p"),T=n(),w=p("h1"),A=p("a"),ca=p("span"),c(V.$$.fragment),Hl=n(),la=p("span"),la.textContent=Pl,ba=n(),c(X.$$.fragment),Ua=n(),N=p("p"),N.textContent=Kl,Ta=n(),Y=p("p"),Y.textContent=Ol,wa=n(),q=p("ol"),q.innerHTML=se,ga=n(),c(_.$$.fragment),Ia=n(),F=p("p"),F.textContent=ae,fa=n(),c(H.$$.fragment),Ca=n(),z=p("p"),z.innerHTML=le,va=n(),$=p("p"),$.textContent=ee,Za=n(),c(S.$$.fragment),Aa=n(),g=p("h2"),B=p("a"),ra=p("span"),c(D.$$.fragment),zl=n(),ea=p("span"),ea.textContent=ne,_a=n(),L=p("p"),L.innerHTML=te,Ba=n(),P=p("p"),P.textContent=pe,xa=n(),c(K.$$.fragment),Wa=n(),O=p("p"),O.textContent=ie,Ga=n(),ss=p("p"),ss.textContent=oe,ka=n(),c(as.$$.fragment),Qa=n(),ls=p("p"),ls.textContent=ce,Ra=n(),es=p("ul"),es.innerHTML=re,Ea=n(),ns=p("p"),ns.innerHTML=he,Va=n(),ts=p("p"),ts.textContent=me,Xa=n(),c(ps.$$.fragment),Na=n(),x=p("div"),x.innerHTML=je,Ya=n(),is=p("p"),is.innerHTML=Me,qa=n(),os=p("p"),os.textContent=ue,Fa=n(),c(cs.$$.fragment),Ha=n(),I=p("h2"),W=p("a"),ha=p("span"),c(rs.$$.fragment),$l=n(),na=p("span"),na.textContent=ye,za=n(),hs=p("p"),hs.innerHTML=de,$a=n(),ms=p("ul"),ms.innerHTML=Je,Sa=n(),js=p("p"),js.textContent=be,Da=n(),Ms=p("p"),Ms.textContent=Ue,La=n(),c(us.$$.fragment),Pa=n(),ys=p("p"),ys.innerHTML=Te,Ka=n(),ds=p("ul"),ds.innerHTML=we,Oa=n(),Js=p("p"),Js.innerHTML=ge,sl=n(),c(bs.$$.fragment),al=n(),Us=p("p"),Us.innerHTML=Ie,ll=n(),c(Ts.$$.fragment),el=n(),ws=p("p"),ws.textContent=fe,nl=n(),c(gs.$$.fragment),tl=n(),Is=p("p"),Is.innerHTML=Ce,pl=n(),fs=p("p"),fs.innerHTML=ve,il=n(),c(Cs.$$.fragment),ol=n(),vs=p("p"),vs.innerHTML=Ze,cl=n(),c(Zs.$$.fragment),rl=n(),f=p("h2"),G=p("a"),ma=p("span"),c(As.$$.fragment),Sl=n(),ta=p("span"),ta.textContent=Ae,hl=ya(`

You have done most of the heavy lifting in the previous sections, so now you are ready to train your model!
The images in this dataset are still quite large, even after resizing. This means that finetuning this model will
require at least one GPU.
`),_s=p("p"),_s.textContent=_e,ml=n(),Bs=p("ol"),Bs.innerHTML=Be,jl=n(),xs=p("p"),xs.innerHTML=xe,Ml=n(),c(Ws.$$.fragment),ul=n(),Gs=p("p"),Gs.innerHTML=We,yl=n(),c(ks.$$.fragment),dl=n(),Qs=p("p"),Qs.innerHTML=Ge,Jl=n(),c(Rs.$$.fragment),bl=n(),Es=p("p"),Es.innerHTML=ke,Ul=n(),c(Vs.$$.fragment),Tl=n(),C=p("h2"),k=p("a"),ja=p("span"),c(Xs.$$.fragment),Dl=n(),pa=p("span"),pa.textContent=Qe,wl=ya(`

Object detection models are commonly evaluated with a set of `),Q=p("a"),Q.textContent=Re,gl=ya(`.
You can use one of the existing metrics implementations, but here you'll use the one from \`torchvision\` to evaluate the final
model that you pushed to the Hub.
`),Ns=p("p"),Ns.innerHTML=Ee,Il=n(),Ys=p("p"),Ys.innerHTML=Ve,fl=n(),c(qs.$$.fragment),Cl=n(),Fs=p("p"),Fs.innerHTML=Xe,vl=n(),c(Hs.$$.fragment),Zl=n(),zs=p("p"),zs.textContent=Ne,Al=n(),c($s.$$.fragment),_l=n(),Ss=p("p"),Ss.innerHTML=Ye,Bl=n(),v=p("h2"),R=p("a"),Ma=p("span"),c(Ds.$$.fragment),Ll=n(),ia=p("span"),ia.textContent=qe,xl=ya(`

Now that you have finetuned a DETR model, evaluated it, and uploaded it to the Hugging Face Hub, you can use it for inference.
The simplest way to try out your finetuned model for inference is to use it in a [Pipeline](/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.Pipeline). Instantiate a pipeline
for object detection with your model, and pass an image to it:

	`),c(Ls.$$.fragment),Wl=n(),Ps=p("p"),Ps.textContent=Fe,Gl=n(),c(Ks.$$.fragment),kl=n(),Os=p("p"),Os.textContent=He,Ql=n(),c(sa.$$.fragment),Rl=n(),E=p("div"),E.innerHTML=ze,El=n(),ua=p("p"),this.h()},l(s){const a=hn("svelte-1phssyn",document.head);b=i(a,"META",{name:!0,content:!0}),a.forEach(l),U=t(s),Z=i(s,"P",{}),J(Z).forEach(l),T=t(s),w=i(s,"H1",{class:!0});var aa=J(w);A=i(aa,"A",{id:!0,class:!0,href:!0});var $e=J(A);ca=i($e,"SPAN",{});var Se=J(ca);r(V.$$.fragment,Se),Se.forEach(l),$e.forEach(l),Hl=t(aa),la=i(aa,"SPAN",{"data-svelte-h":!0}),o(la)!=="svelte-sdfyw1"&&(la.textContent=Pl),aa.forEach(l),ba=t(s),r(X.$$.fragment,s),Ua=t(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-18pt6j0"&&(N.textContent=Kl),Ta=t(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1xy9go1"&&(Y.textContent=Ol),wa=t(s),q=i(s,"OL",{"data-svelte-h":!0}),o(q)!=="svelte-6qcuz8"&&(q.innerHTML=se),ga=t(s),r(_.$$.fragment,s),Ia=t(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1c9nexd"&&(F.textContent=ae),fa=t(s),r(H.$$.fragment,s),Ca=t(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-8eui7r"&&(z.innerHTML=le),va=t(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1oee7b1"&&($.textContent=ee),Za=t(s),r(S.$$.fragment,s),Aa=t(s),g=i(s,"H2",{class:!0});var Xl=J(g);B=i(Xl,"A",{id:!0,class:!0,href:!0});var De=J(B);ra=i(De,"SPAN",{});var Le=J(ra);r(D.$$.fragment,Le),Le.forEach(l),De.forEach(l),zl=t(Xl),ea=i(Xl,"SPAN",{"data-svelte-h":!0}),o(ea)!=="svelte-mdnhj4"&&(ea.textContent=ne),Xl.forEach(l),_a=t(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-9es7uf"&&(L.innerHTML=te),Ba=t(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-kvqzlo"&&(P.textContent=pe),xa=t(s),r(K.$$.fragment,s),Wa=t(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1f9ettc"&&(O.textContent=ie),Ga=t(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-4bevpw"&&(ss.textContent=oe),ka=t(s),r(as.$$.fragment,s),Qa=t(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-m0t76z"&&(ls.textContent=ce),Ra=t(s),es=i(s,"UL",{"data-svelte-h":!0}),o(es)!=="svelte-1tn0avh"&&(es.innerHTML=re),Ea=t(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-edp0uk"&&(ns.innerHTML=he),Va=t(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-1o4zzv7"&&(ts.textContent=me),Xa=t(s),r(ps.$$.fragment,s),Na=t(s),x=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-1mkaz8h"&&(x.innerHTML=je),Ya=t(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-8e05io"&&(is.innerHTML=Me),qa=t(s),os=i(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-34dvp0"&&(os.textContent=ue),Fa=t(s),r(cs.$$.fragment,s),Ha=t(s),I=i(s,"H2",{class:!0});var Nl=J(I);W=i(Nl,"A",{id:!0,class:!0,href:!0});var Pe=J(W);ha=i(Pe,"SPAN",{});var Ke=J(ha);r(rs.$$.fragment,Ke),Ke.forEach(l),Pe.forEach(l),$l=t(Nl),na=i(Nl,"SPAN",{"data-svelte-h":!0}),o(na)!=="svelte-171xy48"&&(na.textContent=ye),Nl.forEach(l),za=t(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-lxe2b3"&&(hs.innerHTML=de),$a=t(s),ms=i(s,"UL",{"data-svelte-h":!0}),o(ms)!=="svelte-9xz2l6"&&(ms.innerHTML=Je),Sa=t(s),js=i(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1uiy3io"&&(js.textContent=be),Da=t(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1ipxopl"&&(Ms.textContent=Ue),La=t(s),r(us.$$.fragment,s),Pa=t(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-16qnm9y"&&(ys.innerHTML=Te),Ka=t(s),ds=i(s,"UL",{"data-svelte-h":!0}),o(ds)!=="svelte-pqfhzt"&&(ds.innerHTML=we),Oa=t(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1p8vci"&&(Js.innerHTML=ge),sl=t(s),r(bs.$$.fragment,s),al=t(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-bsjzql"&&(Us.innerHTML=Ie),ll=t(s),r(Ts.$$.fragment,s),el=t(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-16yruro"&&(ws.textContent=fe),nl=t(s),r(gs.$$.fragment,s),tl=t(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-gc4auf"&&(Is.innerHTML=Ce),pl=t(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1o4lbgk"&&(fs.innerHTML=ve),il=t(s),r(Cs.$$.fragment,s),ol=t(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1ghsv74"&&(vs.innerHTML=Ze),cl=t(s),r(Zs.$$.fragment,s),rl=t(s),f=i(s,"H2",{class:!0});var Yl=J(f);G=i(Yl,"A",{id:!0,class:!0,href:!0});var Oe=J(G);ma=i(Oe,"SPAN",{});var sn=J(ma);r(As.$$.fragment,sn),sn.forEach(l),Oe.forEach(l),Sl=t(Yl),ta=i(Yl,"SPAN",{"data-svelte-h":!0}),o(ta)!=="svelte-pihf6o"&&(ta.textContent=Ae),Yl.forEach(l),hl=da(s,`

You have done most of the heavy lifting in the previous sections, so now you are ready to train your model!
The images in this dataset are still quite large, even after resizing. This means that finetuning this model will
require at least one GPU.
`),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-qp7n2l"&&(_s.textContent=_e),ml=t(s),Bs=i(s,"OL",{"data-svelte-h":!0}),o(Bs)!=="svelte-1w1jtub"&&(Bs.innerHTML=Be),jl=t(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-3tgt16"&&(xs.innerHTML=xe),Ml=t(s),r(Ws.$$.fragment,s),ul=t(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1aohpbe"&&(Gs.innerHTML=We),yl=t(s),r(ks.$$.fragment,s),dl=t(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-14n8grx"&&(Qs.innerHTML=Ge),Jl=t(s),r(Rs.$$.fragment,s),bl=t(s),Es=i(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-g4odd2"&&(Es.innerHTML=ke),Ul=t(s),r(Vs.$$.fragment,s),Tl=t(s),C=i(s,"H2",{class:!0});var ql=J(C);k=i(ql,"A",{id:!0,class:!0,href:!0});var an=J(k);ja=i(an,"SPAN",{});var ln=J(ja);r(Xs.$$.fragment,ln),ln.forEach(l),an.forEach(l),Dl=t(ql),pa=i(ql,"SPAN",{"data-svelte-h":!0}),o(pa)!=="svelte-sh8s6s"&&(pa.textContent=Qe),ql.forEach(l),wl=da(s,`

Object detection models are commonly evaluated with a set of `),Q=i(s,"A",{href:!0,"data-svelte-h":!0}),o(Q)!=="svelte-6plsj8"&&(Q.textContent=Re),gl=da(s,`.
You can use one of the existing metrics implementations, but here you'll use the one from \`torchvision\` to evaluate the final
model that you pushed to the Hub.
`),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1gyi24o"&&(Ns.innerHTML=Ee),Il=t(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1egi90u"&&(Ys.innerHTML=Ve),fl=t(s),r(qs.$$.fragment,s),Cl=t(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-4e01dv"&&(Fs.innerHTML=Xe),vl=t(s),r(Hs.$$.fragment,s),Zl=t(s),zs=i(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-xiphfy"&&(zs.textContent=Ne),Al=t(s),r($s.$$.fragment,s),_l=t(s),Ss=i(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1hz7dtq"&&(Ss.innerHTML=Ye),Bl=t(s),v=i(s,"H2",{class:!0});var Fl=J(v);R=i(Fl,"A",{id:!0,class:!0,href:!0});var en=J(R);Ma=i(en,"SPAN",{});var nn=J(Ma);r(Ds.$$.fragment,nn),nn.forEach(l),en.forEach(l),Ll=t(Fl),ia=i(Fl,"SPAN",{"data-svelte-h":!0}),o(ia)!=="svelte-199uz7g"&&(ia.textContent=qe),Fl.forEach(l),xl=da(s,`

Now that you have finetuned a DETR model, evaluated it, and uploaded it to the Hugging Face Hub, you can use it for inference.
The simplest way to try out your finetuned model for inference is to use it in a [Pipeline](/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.Pipeline). Instantiate a pipeline
for object detection with your model, and pass an image to it:

	`),r(Ls.$$.fragment,s),Wl=t(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-o6117l"&&(Ps.textContent=Fe),Gl=t(s),r(Ks.$$.fragment,s),kl=t(s),Os=i(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-7zeucu"&&(Os.textContent=He),Ql=t(s),r(sa.$$.fragment,s),Rl=t(s),E=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(E)!=="svelte-16oi5q2"&&(E.innerHTML=ze),El=t(s),ua=i(s,"P",{}),J(ua).forEach(l),this.h()},h(){u(b,"name","hf:doc:metadata"),u(b,"content",JSON.stringify(yn)),u(A,"id","object-detection"),u(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(A,"href","#object-detection"),u(w,"class","relative group"),u(B,"id","load-the-cppe5-dataset"),u(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(B,"href","#load-the-cppe5-dataset"),u(g,"class","relative group"),u(x,"class","flex justify-center"),u(W,"id","preprocess-the-data"),u(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(W,"href","#preprocess-the-data"),u(I,"class","relative group"),u(G,"id","training-the-detr-model"),u(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(G,"href","#training-the-detr-model"),u(f,"class","relative group"),u(k,"id","evaluate"),u(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(k,"href","#evaluate"),u(C,"class","relative group"),u(Q,"href","https://cocodataset.org/#detection-eval"),u(R,"id","inference"),u(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(R,"href","#inference"),u(v,"class","relative group"),u(E,"class","flex justify-center")},m(s,a){y(document.head,b),e(s,U,a),e(s,Z,a),e(s,T,a),e(s,w,a),y(w,A),y(A,ca),h(V,ca,null),y(w,Hl),y(w,la),e(s,ba,a),h(X,s,a),e(s,Ua,a),e(s,N,a),e(s,Ta,a),e(s,Y,a),e(s,wa,a),e(s,q,a),e(s,ga,a),h(_,s,a),e(s,Ia,a),e(s,F,a),e(s,fa,a),h(H,s,a),e(s,Ca,a),e(s,z,a),e(s,va,a),e(s,$,a),e(s,Za,a),h(S,s,a),e(s,Aa,a),e(s,g,a),y(g,B),y(B,ra),h(D,ra,null),y(g,zl),y(g,ea),e(s,_a,a),e(s,L,a),e(s,Ba,a),e(s,P,a),e(s,xa,a),h(K,s,a),e(s,Wa,a),e(s,O,a),e(s,Ga,a),e(s,ss,a),e(s,ka,a),h(as,s,a),e(s,Qa,a),e(s,ls,a),e(s,Ra,a),e(s,es,a),e(s,Ea,a),e(s,ns,a),e(s,Va,a),e(s,ts,a),e(s,Xa,a),h(ps,s,a),e(s,Na,a),e(s,x,a),e(s,Ya,a),e(s,is,a),e(s,qa,a),e(s,os,a),e(s,Fa,a),h(cs,s,a),e(s,Ha,a),e(s,I,a),y(I,W),y(W,ha),h(rs,ha,null),y(I,$l),y(I,na),e(s,za,a),e(s,hs,a),e(s,$a,a),e(s,ms,a),e(s,Sa,a),e(s,js,a),e(s,Da,a),e(s,Ms,a),e(s,La,a),h(us,s,a),e(s,Pa,a),e(s,ys,a),e(s,Ka,a),e(s,ds,a),e(s,Oa,a),e(s,Js,a),e(s,sl,a),h(bs,s,a),e(s,al,a),e(s,Us,a),e(s,ll,a),h(Ts,s,a),e(s,el,a),e(s,ws,a),e(s,nl,a),h(gs,s,a),e(s,tl,a),e(s,Is,a),e(s,pl,a),e(s,fs,a),e(s,il,a),h(Cs,s,a),e(s,ol,a),e(s,vs,a),e(s,cl,a),h(Zs,s,a),e(s,rl,a),e(s,f,a),y(f,G),y(G,ma),h(As,ma,null),y(f,Sl),y(f,ta),e(s,hl,a),e(s,_s,a),e(s,ml,a),e(s,Bs,a),e(s,jl,a),e(s,xs,a),e(s,Ml,a),h(Ws,s,a),e(s,ul,a),e(s,Gs,a),e(s,yl,a),h(ks,s,a),e(s,dl,a),e(s,Qs,a),e(s,Jl,a),h(Rs,s,a),e(s,bl,a),e(s,Es,a),e(s,Ul,a),h(Vs,s,a),e(s,Tl,a),e(s,C,a),y(C,k),y(k,ja),h(Xs,ja,null),y(C,Dl),y(C,pa),e(s,wl,a),e(s,Q,a),e(s,gl,a),e(s,Ns,a),e(s,Il,a),e(s,Ys,a),e(s,fl,a),h(qs,s,a),e(s,Cl,a),e(s,Fs,a),e(s,vl,a),h(Hs,s,a),e(s,Zl,a),e(s,zs,a),e(s,Al,a),h($s,s,a),e(s,_l,a),e(s,Ss,a),e(s,Bl,a),e(s,v,a),y(v,R),y(R,Ma),h(Ds,Ma,null),y(v,Ll),y(v,ia),e(s,xl,a),h(Ls,s,a),e(s,Wl,a),e(s,Ps,a),e(s,Gl,a),h(Ks,s,a),e(s,kl,a),e(s,Os,a),e(s,Ql,a),h(sa,s,a),e(s,Rl,a),e(s,E,a),e(s,El,a),e(s,ua,a),Vl=!0},p(s,[a]){const aa={};a&2&&(aa.$$scope={dirty:a,ctx:s}),_.$set(aa)},i(s){Vl||(m(V.$$.fragment,s),m(X.$$.fragment,s),m(_.$$.fragment,s),m(H.$$.fragment,s),m(S.$$.fragment,s),m(D.$$.fragment,s),m(K.$$.fragment,s),m(as.$$.fragment,s),m(ps.$$.fragment,s),m(cs.$$.fragment,s),m(rs.$$.fragment,s),m(us.$$.fragment,s),m(bs.$$.fragment,s),m(Ts.$$.fragment,s),m(gs.$$.fragment,s),m(Cs.$$.fragment,s),m(Zs.$$.fragment,s),m(As.$$.fragment,s),m(Ws.$$.fragment,s),m(ks.$$.fragment,s),m(Rs.$$.fragment,s),m(Vs.$$.fragment,s),m(Xs.$$.fragment,s),m(qs.$$.fragment,s),m(Hs.$$.fragment,s),m($s.$$.fragment,s),m(Ds.$$.fragment,s),m(Ls.$$.fragment,s),m(Ks.$$.fragment,s),m(sa.$$.fragment,s),Vl=!0)},o(s){j(V.$$.fragment,s),j(X.$$.fragment,s),j(_.$$.fragment,s),j(H.$$.fragment,s),j(S.$$.fragment,s),j(D.$$.fragment,s),j(K.$$.fragment,s),j(as.$$.fragment,s),j(ps.$$.fragment,s),j(cs.$$.fragment,s),j(rs.$$.fragment,s),j(us.$$.fragment,s),j(bs.$$.fragment,s),j(Ts.$$.fragment,s),j(gs.$$.fragment,s),j(Cs.$$.fragment,s),j(Zs.$$.fragment,s),j(As.$$.fragment,s),j(Ws.$$.fragment,s),j(ks.$$.fragment,s),j(Rs.$$.fragment,s),j(Vs.$$.fragment,s),j(Xs.$$.fragment,s),j(qs.$$.fragment,s),j(Hs.$$.fragment,s),j($s.$$.fragment,s),j(Ds.$$.fragment,s),j(Ls.$$.fragment,s),j(Ks.$$.fragment,s),j(sa.$$.fragment,s),Vl=!1},d(s){s&&(l(U),l(Z),l(T),l(w),l(ba),l(Ua),l(N),l(Ta),l(Y),l(wa),l(q),l(ga),l(Ia),l(F),l(fa),l(Ca),l(z),l(va),l($),l(Za),l(Aa),l(g),l(_a),l(L),l(Ba),l(P),l(xa),l(Wa),l(O),l(Ga),l(ss),l(ka),l(Qa),l(ls),l(Ra),l(es),l(Ea),l(ns),l(Va),l(ts),l(Xa),l(Na),l(x),l(Ya),l(is),l(qa),l(os),l(Fa),l(Ha),l(I),l(za),l(hs),l($a),l(ms),l(Sa),l(js),l(Da),l(Ms),l(La),l(Pa),l(ys),l(Ka),l(ds),l(Oa),l(Js),l(sl),l(al),l(Us),l(ll),l(el),l(ws),l(nl),l(tl),l(Is),l(pl),l(fs),l(il),l(ol),l(vs),l(cl),l(rl),l(f),l(hl),l(_s),l(ml),l(Bs),l(jl),l(xs),l(Ml),l(ul),l(Gs),l(yl),l(dl),l(Qs),l(Jl),l(bl),l(Es),l(Ul),l(Tl),l(C),l(wl),l(Q),l(gl),l(Ns),l(Il),l(Ys),l(fl),l(Cl),l(Fs),l(vl),l(Zl),l(zs),l(Al),l(_l),l(Ss),l(Bl),l(v),l(xl),l(Wl),l(Ps),l(Gl),l(kl),l(Os),l(Ql),l(Rl),l(E),l(El),l(ua)),l(b),M(V),M(X,s),M(_,s),M(H,s),M(S,s),M(D),M(K,s),M(as,s),M(ps,s),M(cs,s),M(rs),M(us,s),M(bs,s),M(Ts,s),M(gs,s),M(Cs,s),M(Zs,s),M(As),M(Ws,s),M(ks,s),M(Rs,s),M(Vs,s),M(Xs),M(qs,s),M(Hs,s),M($s,s),M(Ds),M(Ls,s),M(Ks,s),M(sa,s)}}}const yn={local:"object-detection",sections:[{local:"load-the-cppe5-dataset",title:"Load the CPPE-5 dataset"},{local:"preprocess-the-data",title:"Preprocess the data"},{local:"training-the-detr-model",title:"Training the DETR model"},{local:"evaluate",title:"Evaluate"},{local:"inference",title:"Inference"}],title:"Object detection"};function dn(Ja){return pn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class In extends cn{constructor(b){super(),rn(this,b,dn,un,tn,{})}}export{In as component};
