import{s as _n,o as En,n as kn}from"../chunks/scheduler.889ebb13.js";import{S as $n,i as jn,g as s,s as a,u as d,A as Sn,h as r,f as t,c as o,j as c,v as U,y as p,k as i,o as h,a as n,w as m,d as J,t as u,x as f}from"../chunks/index.8980e686.js";import{T as xn}from"../chunks/Tip.7191df11.js";import{I as y}from"../chunks/IconCopyLink.357761cd.js";import{C as Le}from"../chunks/CodeBlock.25fc3430.js";function In(ot){let T,P=`TorchScript를 활용한 실험은 아직 초기 단계로, 가변적인 입력 크기 모델들을 통해 그 기능성을 계속 탐구하고 있습니다.
이 기능은 저희가 관심을 두고 있는 분야 중 하나이며,
앞으로 출시될 버전에서 더 많은 코드 예제, 더 유연한 구현, 그리고 Python 기반 코드와 컴파일된 TorchScript를 비교하는 벤치마크를 등을 통해 분석을 심화할 예정입니다.`;return{c(){T=s("p"),T.textContent=P},l(M){T=r(M,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1mebeqz"&&(T.textContent=P)},m(M,Re){n(M,T,Re)},p:kn,d(M){M&&t(T)}}}function Rn(ot){let T,P,M,Re,C,j,Xe,z,pl,Be,Cl="TorchScript로 내보내기",it,S,ht,O,vl='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript 문서</a>에서는 이렇게 말합니다.',pt,D,wl="<p>TorchScript는 PyTorch 코드에서 직렬화 및 최적화 가능한 모델을 생성하는 방법입니다.</p>",ct,L,Vl='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT과 TRACE</a>는 개발자가 모델을 내보내서 효율 지향적인 C++ 프로그램과 같은 다른 프로그램에서 재사용할 수 있도록 하는 PyTorch 모듈입니다.',dt,X,gl=`PyTorch 기반 Python 프로그램과 다른 환경에서 모델을 재사용할 수 있도록, 🤗 Transformers 모델을 TorchScript로 내보낼 수 있는 인터페이스를 제공합니다.
이 문서에서는 TorchScript를 사용하여 모델을 내보내고 사용하는 방법을 설명합니다.`,Ut,G,bl="모델을 내보내려면 두 가지가 필요합니다:",mt,Y,Ql="<li><code>torchscript</code> 플래그로 모델 인스턴스화</li> <li>더미 입력을 사용한 순전파(forward pass)</li>",Jt,K,_l="이 필수 조건들은 아래에 자세히 설명된 것처럼 개발자들이 주의해야 할 여러 사항들을 의미합니다.",ut,v,x,Ge,q,cl,Ne,El="TorchScript 플래그와 묶인 가중치(tied weights)",ft,ee,kl=`<code>torchscript</code> 플래그가 필요한 이유는 대부분의 🤗 Transformers 언어 모델에서 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어 간의 묶인 가중치(tied weights)가 존재하기 때문입니다.
TorchScript는 묶인 가중치를 가진 모델을 내보낼 수 없으므로, 미리 가중치를 풀고 복제해야 합니다.`,Tt,te,$l=`<code>torchscript</code> 플래그로 인스턴스화된 모델은 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어가 분리되어 있으므로 이후에 훈련해서는 안 됩니다.
훈련을 하게 되면 두 레이어 간 동기화가 해제되어 예상치 못한 결과가 발생할 수 있습니다.`,Mt,le,jl=`언어 모델 헤드를 갖지 않은 모델은 가중치가 묶여 있지 않아서 이 문제가 발생하지 않습니다.
이러한 모델들은 <code>torchscript</code> 플래그 없이 안전하게 내보낼 수 있습니다.`,yt,w,I,Ye,ne,dl,Ae,Sl="더미 입력과 표준 길이",Ct,se,xl=`더미 입력(dummy inputs)은 모델의 순전파(forward pass)에 사용됩니다.
입력 값이 레이어를 통해 전파되는 동안, PyTorch는 각 텐서에서 실행된 다른 연산을 추적합니다.
이러한 기록된 연산은 모델의 <em>추적(trace)</em>을 생성하는 데 사용됩니다.`,vt,re,Il=`추적은 입력의 차원을 기준으로 생성됩니다.
따라서 더미 입력의 차원에 제한되어, 다른 시퀀스 길이나 배치 크기에서는 작동하지 않습니다.
다른 크기로 시도할 경우 다음과 같은 오류가 발생합니다:`,wt,ae,Vt,oe,Rl=`추론 중 모델에 공급될 가장 큰 입력만큼 큰 더미 입력 크기로 모델을 추적하는 것이 좋습니다.
패딩은 누락된 값을 채우는 데 도움이 될 수 있습니다.
그러나 모델이 더 큰 입력 크기로 추적되기 때문에, 행렬의 차원이 커지고 계산량이 많아집니다.`,gt,ie,Bl="다양한 시퀀스 길이 모델을 내보낼 때는 각 입력에 대해 수행되는 총 연산 횟수에 주의하고 성능을 주의 깊게 확인하세요.",bt,V,R,Ke,he,Ul,Ze,Nl="Python에서 TorchScript 사용하기",Qt,pe,Al="이 섹션에서는 모델을 저장하고 가져오는 방법, 추적을 사용하여 추론하는 방법을 보여줍니다.",_t,g,B,qe,ce,ml,We,Zl="모델 저장하기",Et,de,Wl="<code>BertModel</code>을 TorchScript로 내보내려면 <code>BertConfig</code> 클래스에서 <code>BertModel</code>을 인스턴스화한 다음, <code>traced_bert.pt</code>라는 파일명으로 디스크에 저장하면 됩니다.",kt,Ue,$t,b,N,et,me,Jl,Fe,Fl="모델 가져오기",jt,Je,Hl="이제 이전에 저장한 <code>BertModel</code>, 즉 <code>traced_bert.pt</code>를 디스크에서 가져오고, 이전에 초기화한 <code>dummy_input</code>에서 사용할 수 있습니다.",St,ue,xt,Q,A,tt,fe,ul,He,Pl="추적된 모델을 사용하여 추론하기",It,Te,zl="<code>__call__</code> 이중 언더스코어(dunder) 메소드를 사용하여 추론에 추적된 모델을 사용하세요:",Rt,Me,Bt,_,Z,lt,ye,fl,Pe,Ol="Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기",Nt,Ce,Dl=`AWS가 클라우드에서 저비용, 고성능 머신 러닝 추론을 위한 <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a> 인스턴스 제품군을 출시했습니다.
Inf1 인스턴스는 딥러닝 추론 워크로드에 특화된 맞춤 하드웨어 가속기인 AWS Inferentia 칩으로 구동됩니다.
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS Neuron</a>은 Inferentia를 위한 SDK로, Inf1에 배포하기 위한 transformers 모델 추적 및 최적화를 지원합니다.
Neuron SDK는 다음과 같은 기능을 제공합니다:`,At,ve,Ll='<li>코드 한 줄만 변경하면 클라우드 추론를 위해 TorchScript 모델을 추적하고 최적화할 수 있는 쉬운 API</li> <li>즉시 사용 가능한 성능 최적화로 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">비용 효율 향상</a></li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a> 또는 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>로 구축된 Hugging Face transformers 모델 지원</li>',Zt,E,W,nt,we,Tl,ze,Xl="시사점",Wt,Ve,Gl=`<a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from Transformers)</a> 아키텍처 또는 그 변형인 <a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> 및 <a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a>를 기반으로 한 Transformers 모델은 추출 기반 질의응답, 시퀀스 분류 및 토큰 분류와 같은 비생성 작업 시 Inf1에서 최상의 성능을 보입니다.
그러나 텍스트 생성 작업도 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT 튜토리얼</a>을 따라 Inf1에서 실행되도록 조정할 수 있습니다.`,Ft,ge,Yl='Inferentia에서 바로 변환할 수 있는 모델에 대한 자세한 정보는 Neuron 문서의 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture Fit</a> 섹션에서 확인할 수 있습니다.',Ht,k,F,st,be,Ml,Oe,Kl="종속성",Pt,Qe,ql=`AWS Neuron을 사용하여 모델을 변환하려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK 환경</a>이 필요합니다.
이는 <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning AMI</a>에 미리 구성되어 있습니다.`,zt,$,H,rt,_e,yl,De,en="AWS Neuron으로 모델 변환하기",Ot,Ee,tn=`<code>BertModel</code>을 추적하려면, <a href="torchscript#using-torchscript-in-python">Python에서 TorchScript 사용하기</a>에서와 동일한 코드를 사용해서 AWS NEURON용 모델을 변환합니다.
<code>torch.neuron</code> 프레임워크 익스텐션을 가져와 Python API를 통해 Neuron SDK의 구성 요소에 접근합니다:`,Dt,ke,Lt,$e,ln="다음 줄만 수정하면 됩니다:",Xt,je,Gt,Se,nn="이로써 Neuron SDK가 모델을 추적하고 Inf1 인스턴스에 최적화할 수 있게 됩니다.",Yt,xe,sn='AWS Neuron SDK의 기능, 도구, 예제 튜토리얼 및 최신 업데이트에 대해 자세히 알아보려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK 문서</a>를 참조하세요.',Kt,at,qt;return z=new y({}),S=new xn({props:{$$slots:{default:[In]},$$scope:{ctx:ot}}}),q=new y({}),ne=new y({}),ae=new Le({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`'}}),he=new y({}),ce=new y({}),Ue=new Le({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># 입력 텍스트 토큰화하기</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># 입력 토큰 중 하나를 마스킹하기</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># 더미 입력 만들기</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># torchscript 플래그로 모델 초기화하기</span>
<span class="hljs-comment"># 이 모델은 LM 헤드가 없으므로 필요하지 않지만, 플래그를 True로 설정합니다.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># 모델을 인스턴트화하기</span>
model = BertModel(config)

<span class="hljs-comment"># 모델을 평가 모드로 두어야 합니다.</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># 만약 *from_pretrained*를 사용하여 모델을 인스턴스화하는 경우, TorchScript 플래그를 쉽게 설정할 수 있습니다</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 추적 생성하기</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`}}),me=new y({}),ue=new Le({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`}}),fe=new y({}),Me=new Le({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)"}}),ye=new y({}),we=new y({}),be=new y({}),_e=new y({}),ke=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`}}),je=new Le({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`}}),{c(){T=s("meta"),P=a(),M=s("p"),Re=a(),C=s("h1"),j=s("a"),Xe=s("span"),d(z.$$.fragment),pl=a(),Be=s("span"),Be.textContent=Cl,it=a(),d(S.$$.fragment),ht=a(),O=s("p"),O.innerHTML=vl,pt=a(),D=s("blockquote"),D.innerHTML=wl,ct=a(),L=s("p"),L.innerHTML=Vl,dt=a(),X=s("p"),X.textContent=gl,Ut=a(),G=s("p"),G.textContent=bl,mt=a(),Y=s("ul"),Y.innerHTML=Ql,Jt=a(),K=s("p"),K.textContent=_l,ut=a(),v=s("h2"),x=s("a"),Ge=s("span"),d(q.$$.fragment),cl=a(),Ne=s("span"),Ne.textContent=El,ft=a(),ee=s("p"),ee.innerHTML=kl,Tt=a(),te=s("p"),te.innerHTML=$l,Mt=a(),le=s("p"),le.innerHTML=jl,yt=a(),w=s("h2"),I=s("a"),Ye=s("span"),d(ne.$$.fragment),dl=a(),Ae=s("span"),Ae.textContent=Sl,Ct=a(),se=s("p"),se.innerHTML=xl,vt=a(),re=s("p"),re.textContent=Il,wt=a(),d(ae.$$.fragment),Vt=a(),oe=s("p"),oe.textContent=Rl,gt=a(),ie=s("p"),ie.textContent=Bl,bt=a(),V=s("h2"),R=s("a"),Ke=s("span"),d(he.$$.fragment),Ul=a(),Ze=s("span"),Ze.textContent=Nl,Qt=a(),pe=s("p"),pe.textContent=Al,_t=a(),g=s("h3"),B=s("a"),qe=s("span"),d(ce.$$.fragment),ml=a(),We=s("span"),We.textContent=Zl,Et=a(),de=s("p"),de.innerHTML=Wl,kt=a(),d(Ue.$$.fragment),$t=a(),b=s("h3"),N=s("a"),et=s("span"),d(me.$$.fragment),Jl=a(),Fe=s("span"),Fe.textContent=Fl,jt=a(),Je=s("p"),Je.innerHTML=Hl,St=a(),d(ue.$$.fragment),xt=a(),Q=s("h3"),A=s("a"),tt=s("span"),d(fe.$$.fragment),ul=a(),He=s("span"),He.textContent=Pl,It=a(),Te=s("p"),Te.innerHTML=zl,Rt=a(),d(Me.$$.fragment),Bt=a(),_=s("h2"),Z=s("a"),lt=s("span"),d(ye.$$.fragment),fl=a(),Pe=s("span"),Pe.textContent=Ol,Nt=a(),Ce=s("p"),Ce.innerHTML=Dl,At=a(),ve=s("ol"),ve.innerHTML=Ll,Zt=a(),E=s("h3"),W=s("a"),nt=s("span"),d(we.$$.fragment),Tl=a(),ze=s("span"),ze.textContent=Xl,Wt=a(),Ve=s("p"),Ve.innerHTML=Gl,Ft=a(),ge=s("p"),ge.innerHTML=Yl,Ht=a(),k=s("h3"),F=s("a"),st=s("span"),d(be.$$.fragment),Ml=a(),Oe=s("span"),Oe.textContent=Kl,Pt=a(),Qe=s("p"),Qe.innerHTML=ql,zt=a(),$=s("h3"),H=s("a"),rt=s("span"),d(_e.$$.fragment),yl=a(),De=s("span"),De.textContent=en,Ot=a(),Ee=s("p"),Ee.innerHTML=tn,Dt=a(),d(ke.$$.fragment),Lt=a(),$e=s("p"),$e.textContent=ln,Xt=a(),d(je.$$.fragment),Gt=a(),Se=s("p"),Se.textContent=nn,Yt=a(),xe=s("p"),xe.innerHTML=sn,Kt=a(),at=s("p"),this.h()},l(e){const l=Sn("svelte-1phssyn",document.head);T=r(l,"META",{name:!0,content:!0}),l.forEach(t),P=o(e),M=r(e,"P",{}),c(M).forEach(t),Re=o(e),C=r(e,"H1",{class:!0});var Ie=c(C);j=r(Ie,"A",{id:!0,class:!0,href:!0});var rn=c(j);Xe=r(rn,"SPAN",{});var an=c(Xe);U(z.$$.fragment,an),an.forEach(t),rn.forEach(t),pl=o(Ie),Be=r(Ie,"SPAN",{"data-svelte-h":!0}),p(Be)!=="svelte-1tcijsm"&&(Be.textContent=Cl),Ie.forEach(t),it=o(e),U(S.$$.fragment,e),ht=o(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-isybml"&&(O.innerHTML=vl),pt=o(e),D=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(D)!=="svelte-1nfg3b0"&&(D.innerHTML=wl),ct=o(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-sp9oye"&&(L.innerHTML=Vl),dt=o(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-do9l6t"&&(X.textContent=gl),Ut=o(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1w91skt"&&(G.textContent=bl),mt=o(e),Y=r(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-k6rkk6"&&(Y.innerHTML=Ql),Jt=o(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-14fy25m"&&(K.textContent=_l),ut=o(e),v=r(e,"H2",{class:!0});var el=c(v);x=r(el,"A",{id:!0,class:!0,href:!0});var on=c(x);Ge=r(on,"SPAN",{});var hn=c(Ge);U(q.$$.fragment,hn),hn.forEach(t),on.forEach(t),cl=o(el),Ne=r(el,"SPAN",{"data-svelte-h":!0}),p(Ne)!=="svelte-ucu277"&&(Ne.textContent=El),el.forEach(t),ft=o(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-12irp1s"&&(ee.innerHTML=kl),Tt=o(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-50p7lq"&&(te.innerHTML=$l),Mt=o(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1xgnj70"&&(le.innerHTML=jl),yt=o(e),w=r(e,"H2",{class:!0});var tl=c(w);I=r(tl,"A",{id:!0,class:!0,href:!0});var pn=c(I);Ye=r(pn,"SPAN",{});var cn=c(Ye);U(ne.$$.fragment,cn),cn.forEach(t),pn.forEach(t),dl=o(tl),Ae=r(tl,"SPAN",{"data-svelte-h":!0}),p(Ae)!=="svelte-rna8h7"&&(Ae.textContent=Sl),tl.forEach(t),Ct=o(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1q7p5d"&&(se.innerHTML=xl),vt=o(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-9y2g95"&&(re.textContent=Il),wt=o(e),U(ae.$$.fragment,e),Vt=o(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1ujz4pz"&&(oe.textContent=Rl),gt=o(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-2wkzde"&&(ie.textContent=Bl),bt=o(e),V=r(e,"H2",{class:!0});var ll=c(V);R=r(ll,"A",{id:!0,class:!0,href:!0});var dn=c(R);Ke=r(dn,"SPAN",{});var Un=c(Ke);U(he.$$.fragment,Un),Un.forEach(t),dn.forEach(t),Ul=o(ll),Ze=r(ll,"SPAN",{"data-svelte-h":!0}),p(Ze)!=="svelte-1und6ap"&&(Ze.textContent=Nl),ll.forEach(t),Qt=o(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-kletgn"&&(pe.textContent=Al),_t=o(e),g=r(e,"H3",{class:!0});var nl=c(g);B=r(nl,"A",{id:!0,class:!0,href:!0});var mn=c(B);qe=r(mn,"SPAN",{});var Jn=c(qe);U(ce.$$.fragment,Jn),Jn.forEach(t),mn.forEach(t),ml=o(nl),We=r(nl,"SPAN",{"data-svelte-h":!0}),p(We)!=="svelte-y1yck4"&&(We.textContent=Zl),nl.forEach(t),Et=o(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-sf77rs"&&(de.innerHTML=Wl),kt=o(e),U(Ue.$$.fragment,e),$t=o(e),b=r(e,"H3",{class:!0});var sl=c(b);N=r(sl,"A",{id:!0,class:!0,href:!0});var un=c(N);et=r(un,"SPAN",{});var fn=c(et);U(me.$$.fragment,fn),fn.forEach(t),un.forEach(t),Jl=o(sl),Fe=r(sl,"SPAN",{"data-svelte-h":!0}),p(Fe)!=="svelte-17pkgnj"&&(Fe.textContent=Fl),sl.forEach(t),jt=o(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1r4og2d"&&(Je.innerHTML=Hl),St=o(e),U(ue.$$.fragment,e),xt=o(e),Q=r(e,"H3",{class:!0});var rl=c(Q);A=r(rl,"A",{id:!0,class:!0,href:!0});var Tn=c(A);tt=r(Tn,"SPAN",{});var Mn=c(tt);U(fe.$$.fragment,Mn),Mn.forEach(t),Tn.forEach(t),ul=o(rl),He=r(rl,"SPAN",{"data-svelte-h":!0}),p(He)!=="svelte-3t0agj"&&(He.textContent=Pl),rl.forEach(t),It=o(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1fmm5c"&&(Te.innerHTML=zl),Rt=o(e),U(Me.$$.fragment,e),Bt=o(e),_=r(e,"H2",{class:!0});var al=c(_);Z=r(al,"A",{id:!0,class:!0,href:!0});var yn=c(Z);lt=r(yn,"SPAN",{});var Cn=c(lt);U(ye.$$.fragment,Cn),Cn.forEach(t),yn.forEach(t),fl=o(al),Pe=r(al,"SPAN",{"data-svelte-h":!0}),p(Pe)!=="svelte-1hsup24"&&(Pe.textContent=Ol),al.forEach(t),Nt=o(e),Ce=r(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-grcwrb"&&(Ce.innerHTML=Dl),At=o(e),ve=r(e,"OL",{"data-svelte-h":!0}),p(ve)!=="svelte-ro97hi"&&(ve.innerHTML=Ll),Zt=o(e),E=r(e,"H3",{class:!0});var ol=c(E);W=r(ol,"A",{id:!0,class:!0,href:!0});var vn=c(W);nt=r(vn,"SPAN",{});var wn=c(nt);U(we.$$.fragment,wn),wn.forEach(t),vn.forEach(t),Tl=o(ol),ze=r(ol,"SPAN",{"data-svelte-h":!0}),p(ze)!=="svelte-1rgc7y3"&&(ze.textContent=Xl),ol.forEach(t),Wt=o(e),Ve=r(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1dwgzck"&&(Ve.innerHTML=Gl),Ft=o(e),ge=r(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-it8cst"&&(ge.innerHTML=Yl),Ht=o(e),k=r(e,"H3",{class:!0});var il=c(k);F=r(il,"A",{id:!0,class:!0,href:!0});var Vn=c(F);st=r(Vn,"SPAN",{});var gn=c(st);U(be.$$.fragment,gn),gn.forEach(t),Vn.forEach(t),Ml=o(il),Oe=r(il,"SPAN",{"data-svelte-h":!0}),p(Oe)!=="svelte-16wdt2q"&&(Oe.textContent=Kl),il.forEach(t),Pt=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-3tyyhn"&&(Qe.innerHTML=ql),zt=o(e),$=r(e,"H3",{class:!0});var hl=c($);H=r(hl,"A",{id:!0,class:!0,href:!0});var bn=c(H);rt=r(bn,"SPAN",{});var Qn=c(rt);U(_e.$$.fragment,Qn),Qn.forEach(t),bn.forEach(t),yl=o(hl),De=r(hl,"SPAN",{"data-svelte-h":!0}),p(De)!=="svelte-xftw05"&&(De.textContent=en),hl.forEach(t),Ot=o(e),Ee=r(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-13235e8"&&(Ee.innerHTML=tn),Dt=o(e),U(ke.$$.fragment,e),Lt=o(e),$e=r(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-r93qfm"&&($e.textContent=ln),Xt=o(e),U(je.$$.fragment,e),Gt=o(e),Se=r(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-12g7lo2"&&(Se.textContent=nn),Yt=o(e),xe=r(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1akz01w"&&(xe.innerHTML=sn),Kt=o(e),at=r(e,"P",{}),c(at).forEach(t),this.h()},h(){i(T,"name","hf:doc:metadata"),i(T,"content",JSON.stringify(Bn)),i(j,"id","export-to-torchscript"),i(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(j,"href","#export-to-torchscript"),i(C,"class","relative group"),i(x,"id","torchscript-flag-and-tied-weights"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#torchscript-flag-and-tied-weights"),i(v,"class","relative group"),i(I,"id","dummy-inputs-and-standard-lengths"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#dummy-inputs-and-standard-lengths"),i(w,"class","relative group"),i(R,"id","using-torchscript-in-python"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#using-torchscript-in-python"),i(V,"class","relative group"),i(B,"id","saving-a-model"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#saving-a-model"),i(g,"class","relative group"),i(N,"id","loading-a-model"),i(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(N,"href","#loading-a-model"),i(b,"class","relative group"),i(A,"id","using-a-traced-model-for-inference"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#using-a-traced-model-for-inference"),i(Q,"class","relative group"),i(Z,"id","deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk"),i(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Z,"href","#deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk"),i(_,"class","relative group"),i(W,"id","implications"),i(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(W,"href","#implications"),i(E,"class","relative group"),i(F,"id","dependencies"),i(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(F,"href","#dependencies"),i(k,"class","relative group"),i(H,"id","converting-a-model-for-aws-neuron"),i(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(H,"href","#converting-a-model-for-aws-neuron"),i($,"class","relative group")},m(e,l){h(document.head,T),n(e,P,l),n(e,M,l),n(e,Re,l),n(e,C,l),h(C,j),h(j,Xe),m(z,Xe,null),h(C,pl),h(C,Be),n(e,it,l),m(S,e,l),n(e,ht,l),n(e,O,l),n(e,pt,l),n(e,D,l),n(e,ct,l),n(e,L,l),n(e,dt,l),n(e,X,l),n(e,Ut,l),n(e,G,l),n(e,mt,l),n(e,Y,l),n(e,Jt,l),n(e,K,l),n(e,ut,l),n(e,v,l),h(v,x),h(x,Ge),m(q,Ge,null),h(v,cl),h(v,Ne),n(e,ft,l),n(e,ee,l),n(e,Tt,l),n(e,te,l),n(e,Mt,l),n(e,le,l),n(e,yt,l),n(e,w,l),h(w,I),h(I,Ye),m(ne,Ye,null),h(w,dl),h(w,Ae),n(e,Ct,l),n(e,se,l),n(e,vt,l),n(e,re,l),n(e,wt,l),m(ae,e,l),n(e,Vt,l),n(e,oe,l),n(e,gt,l),n(e,ie,l),n(e,bt,l),n(e,V,l),h(V,R),h(R,Ke),m(he,Ke,null),h(V,Ul),h(V,Ze),n(e,Qt,l),n(e,pe,l),n(e,_t,l),n(e,g,l),h(g,B),h(B,qe),m(ce,qe,null),h(g,ml),h(g,We),n(e,Et,l),n(e,de,l),n(e,kt,l),m(Ue,e,l),n(e,$t,l),n(e,b,l),h(b,N),h(N,et),m(me,et,null),h(b,Jl),h(b,Fe),n(e,jt,l),n(e,Je,l),n(e,St,l),m(ue,e,l),n(e,xt,l),n(e,Q,l),h(Q,A),h(A,tt),m(fe,tt,null),h(Q,ul),h(Q,He),n(e,It,l),n(e,Te,l),n(e,Rt,l),m(Me,e,l),n(e,Bt,l),n(e,_,l),h(_,Z),h(Z,lt),m(ye,lt,null),h(_,fl),h(_,Pe),n(e,Nt,l),n(e,Ce,l),n(e,At,l),n(e,ve,l),n(e,Zt,l),n(e,E,l),h(E,W),h(W,nt),m(we,nt,null),h(E,Tl),h(E,ze),n(e,Wt,l),n(e,Ve,l),n(e,Ft,l),n(e,ge,l),n(e,Ht,l),n(e,k,l),h(k,F),h(F,st),m(be,st,null),h(k,Ml),h(k,Oe),n(e,Pt,l),n(e,Qe,l),n(e,zt,l),n(e,$,l),h($,H),h(H,rt),m(_e,rt,null),h($,yl),h($,De),n(e,Ot,l),n(e,Ee,l),n(e,Dt,l),m(ke,e,l),n(e,Lt,l),n(e,$e,l),n(e,Xt,l),m(je,e,l),n(e,Gt,l),n(e,Se,l),n(e,Yt,l),n(e,xe,l),n(e,Kt,l),n(e,at,l),qt=!0},p(e,[l]){const Ie={};l&2&&(Ie.$$scope={dirty:l,ctx:e}),S.$set(Ie)},i(e){qt||(J(z.$$.fragment,e),J(S.$$.fragment,e),J(q.$$.fragment,e),J(ne.$$.fragment,e),J(ae.$$.fragment,e),J(he.$$.fragment,e),J(ce.$$.fragment,e),J(Ue.$$.fragment,e),J(me.$$.fragment,e),J(ue.$$.fragment,e),J(fe.$$.fragment,e),J(Me.$$.fragment,e),J(ye.$$.fragment,e),J(we.$$.fragment,e),J(be.$$.fragment,e),J(_e.$$.fragment,e),J(ke.$$.fragment,e),J(je.$$.fragment,e),qt=!0)},o(e){u(z.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(he.$$.fragment,e),u(ce.$$.fragment,e),u(Ue.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(ke.$$.fragment,e),u(je.$$.fragment,e),qt=!1},d(e){e&&(t(P),t(M),t(Re),t(C),t(it),t(ht),t(O),t(pt),t(D),t(ct),t(L),t(dt),t(X),t(Ut),t(G),t(mt),t(Y),t(Jt),t(K),t(ut),t(v),t(ft),t(ee),t(Tt),t(te),t(Mt),t(le),t(yt),t(w),t(Ct),t(se),t(vt),t(re),t(wt),t(Vt),t(oe),t(gt),t(ie),t(bt),t(V),t(Qt),t(pe),t(_t),t(g),t(Et),t(de),t(kt),t($t),t(b),t(jt),t(Je),t(St),t(xt),t(Q),t(It),t(Te),t(Rt),t(Bt),t(_),t(Nt),t(Ce),t(At),t(ve),t(Zt),t(E),t(Wt),t(Ve),t(Ft),t(ge),t(Ht),t(k),t(Pt),t(Qe),t(zt),t($),t(Ot),t(Ee),t(Dt),t(Lt),t($e),t(Xt),t(Gt),t(Se),t(Yt),t(xe),t(Kt),t(at)),t(T),f(z),f(S,e),f(q),f(ne),f(ae,e),f(he),f(ce),f(Ue,e),f(me),f(ue,e),f(fe),f(Me,e),f(ye),f(we),f(be),f(_e),f(ke,e),f(je,e)}}}const Bn={local:"export-to-torchscript",sections:[{local:"torchscript-flag-and-tied-weights",title:"TorchScript 플래그와 묶인 가중치(tied weights)"},{local:"dummy-inputs-and-standard-lengths",title:"더미 입력과 표준 길이"},{local:"using-torchscript-in-python",sections:[{local:"saving-a-model",title:"모델 저장하기"},{local:"loading-a-model",title:"모델 가져오기"},{local:"using-a-traced-model-for-inference",title:"추적된 모델을 사용하여 추론하기"}],title:"Python에서 TorchScript 사용하기"},{local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",sections:[{local:"implications",title:"시사점"},{local:"dependencies",title:"종속성"},{local:"converting-a-model-for-aws-neuron",title:"AWS Neuron으로 모델 변환하기"}],title:"Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기"}],title:"TorchScript로 내보내기"};function Nn(ot){return En(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends $n{constructor(T){super(),jn(this,T,Nn,Rn,_n,{})}}export{Pn as component};
