import{s as Yl,f as Kl,n as en,o as tn}from"../chunks/scheduler.85c25b89.js";import{S as an,i as on,g as r,s as l,r as p,A as ln,h as s,f as a,c as n,j as T,u as c,x as i,k as M,l as nn,y as d,a as o,v as m,d as h,t as f,w as u}from"../chunks/index.c142fe32.js";import{D as y}from"../chunks/Docstring.d3e0bcd1.js";import{C as $t}from"../chunks/CodeBlock.a5e95a57.js";import{H as v,E as rn}from"../chunks/EditOnGithub.a592e7aa.js";function sn(Eo){let C,At,Dt,Nt,B,qt,F,Ro='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Bt,E,Zo="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Ft,R,Et,Z,Wo="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",Rt,W,Lo="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Zt,L,Ho='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>. You can also explore the <a href="https://huggingface.co/collections/librarian-bots/direct-preference-optimization-datasets-66964b12835f46289b6ef2fc" rel="nofollow">librarian-bots/direct-preference-optimization-datasets</a> Collection to identify datasets that are likely to support DPO training.',Wt,H,zo='This process is illustrated in the sketch below (from <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">figure 1 of the original paper</a>):',Lt,I,Qo,Ht,z,Go='Read more about DPO algorithm in the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">original paper</a>.',zt,Q,Qt,G,So='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Gt,x,Xo='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',St,S,Vo="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Xt,X,Yo="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Vt,V,Ko="for example:",Yt,Y,Kt,K,el="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",ea,ee,tl='<a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> can be used to fine-tune visual language models (VLMs). In this case, the dataset must also contain the key <code>images</code>, and the trainer’s <code>tokenizer</code> is the VLM’s <code>processor</code>. For example, for Idefics2, the processor expects the dataset to have the following format:',ta,te,al="Note: Currently, VLM support is exclusive to Idefics2 and does not extend to other VLMs.",aa,ae,oa,oe,la,le,ol="The DPO trainer expects a model of <code>AutoModelForCausalLM</code> or <code>AutoModelForVision2Seq</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",na,ne,ra,re,ll='For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).',sa,se,ia,ie,nl="After this one can then call:",da,de,pa,pe,rl="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",ca,ce,ma,me,sl='Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression. To use this loss, set the <code>loss_type=&quot;sigmoid&quot;</code> (default) in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ha,he,il='The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. To use this loss, set the <code>loss_type=&quot;hinge&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the margin.',fa,fe,dl='The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. To use the loss set the <code>loss_type=&quot;ipo&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',ua,ue,pl='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0).',ga,ge,cl='The <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. To use the loss set the <code>loss_type=&quot;exo_pair&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. Setting non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.',_a,_e,ml='The <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood. To use the loss set the <code>loss_type=&quot;nca_pair&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ma,Me,hl='The <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, it assumes that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0) and set the <code>loss_type=&quot;robust&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ta,Te,fl='The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. To use this loss, set the <code>loss_type=&quot;bco_pair&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',ya,ye,ul='The <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model=True</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',va,ve,gl='The <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://huggingface.co/papers/2405.16436" rel="nofollow">paper</a> that essentially consists of a weighted SFT loss on the chosen preferences together with the DPO loss. To use this loss, set the <code>rpo_alpha</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> to an appropriate value. The paper suggests setting this weight to 1.0.',ba,be,_l='The <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser. To use this loss, set the <code>loss_type=&quot;sppo_hard&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',wa,we,Ml='The <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',Ja,Je,Tl='The <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> method introduces an “anchored” version of the alignment objective. There are two variants: <code>apo_zero</code> and <code>apo_down</code>. The <code>apo_zero</code> loss increases the likelihood of winning outputs while decreasing the likelihood of losing outputs, making it suitable when the model is less performant than the winning outputs. On the other hand, <code>apo_down</code> decreases the likelihood of both winning and losing outputs, but with a stronger emphasis on reducing the likelihood of losing outputs. This variant is more effective when the model is better than the winning outputs. To use these losses, set <code>loss_type=&quot;apo_zero&quot;</code> or <code>loss_type=&quot;apo_down&quot;</code> in the <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Ua,Ue,Ca,Ce,yl=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,ja,je,vl=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,Ia,Ie,xa,xe,bl="While training and evaluating we record the following reward metrics:",Oa,Oe,wl="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Pa,Pe,$a,$e,Jl='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',Da,De,Ul="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",ka,ke,Cl='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Aa,Ae,Na,Ne,jl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',qa,qe,Ba,Be,Il="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Fa,Fe,xl="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>ref_model</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Ea,Ee,Ra,Re,Ol='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Za,Ze,Pl="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",Wa,We,La,Le,$l='To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in <a href="/docs/trl/v0.10.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',Ha,He,Dl="For example:",za,ze,Qa,Qe,Ga,g,Ge,po,pt,kl="Initialize DPOTrainer.",co,O,Se,mo,ct,Al="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",ho,b,Xe,fo,mt,Nl="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",uo,ht,ql="We do this to avoid doing two forward passes, because it’s faster for FSDP.",go,P,Ve,_o,ft,Bl="Concatenate the chosen and rejected inputs into a single tensor.",Mo,$,Ye,To,ut,Fl="Compute the DPO loss for a batch of policy and reference model log probabilities.",yo,w,Ke,vo,gt,El=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,bo,_t,Rl="Works both with or without labels.",wo,D,et,Jo,Mt,Zl="Compute the log probabilities of the given labels under the given logits.",Uo,k,tt,Co,Tt,Wl="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",jo,A,at,Io,yt,Ll="Generate samples from the model and reference model for the given batch of inputs.",xo,J,ot,Oo,vt,Hl="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Po,bt,zl="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",$o,U,lt,Do,wt,Ql="Returns the training <code>~torch.utils.data.DataLoader</code>.",ko,Jt,Gl="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Ao,N,nt,No,Ut,Sl="Log <code>logs</code> on the various objects watching training, including stored metrics.",qo,q,rt,Bo,Ct,Xl="Context manager for handling null reference model (that is, peft adapter manipulation).",Sa,st,Xa,j,it,Fo,jt,Vl="Initialize DPOConfig.",Va,dt,Ya,kt,Ka;return B=new v({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),R=new v({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),Q=new v({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),Y=new $t({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),ae=new $t({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdpbWFnZXMnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCSW1hZ2Uub3BlbignYmVhY2guanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJJbWFnZS5vcGVuKCdzdHJlZXQuanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncHJvbXB0JyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdUaGUlMjBpbWFnZSUyMCUzQ2ltYWdlJTNFJTIwc2hvd3MnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJyUzQ2ltYWdlJTNFJTIwVGhlJTIwaW1hZ2UlMjBkZXBpY3RzJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCdjaG9zZW4nJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzdW5ueSUyMGJlYWNoJTIwd2l0aCUyMHBhbG0lMjB0cmVlcy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBidXN5JTIwc3RyZWV0JTIwd2l0aCUyMHNldmVyYWwlMjBjYXJzJTIwYW5kJTIwYnVpbGRpbmdzLiclMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncmVqZWN0ZWQnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzbm93eSUyMG1vdW50YWluJTIwd2l0aCUyMHNraWVycy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBjYWxtJTIwY291bnRyeXNpZGUlMjB3aXRoJTIwZ3JlZW4lMjBmaWVsZHMuJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RA==",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&#x27;images&#x27;</span>: [
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;beach.jpg&#x27;</span>)],
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;street.jpg&#x27;</span>)],
    ],
    <span class="hljs-string">&#x27;prompt&#x27;</span>: [
        <span class="hljs-string">&#x27;The image &lt;image&gt; shows&#x27;</span>,
        <span class="hljs-string">&#x27;&lt;image&gt; The image depicts&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;chosen&#x27;</span>: [
        <span class="hljs-string">&#x27;a sunny beach with palm trees.&#x27;</span>,
        <span class="hljs-string">&#x27;a busy street with several cars and buildings.&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;rejected&#x27;</span>: [
        <span class="hljs-string">&#x27;a snowy mountain with skiers.&#x27;</span>,
        <span class="hljs-string">&#x27;a calm countryside with green fields.&#x27;</span>,
    ],
}`,wrap:!1}}),oe=new v({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),ne=new v({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),se=new $t({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHJlZl9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjAlMjAlMjMlMjBmb3IlMjB2aXN1YWwlMjBsYW5ndWFnZSUyMG1vZGVscyUyQyUyMHVzZSUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyMGluc3RlYWQlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    ref_model,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,  <span class="hljs-comment"># for visual language models, use tokenizer=processor instead</span>
)`,wrap:!1}}),de=new $t({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ce=new v({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Ue=new v({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),Ie=new v({props:{title:"Logging",local:"logging",headingTag:"h2"}}),Pe=new v({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Ae=new $t({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),qe=new v({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ee=new v({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),We=new v({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),ze=new $t({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Qe=new v({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Ge=new y({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L352"}}),Se=new y({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1030"}}),Xe=new y({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1346"}}),Ve=new y({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"is_vision_model",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1056",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Ye=new y({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ke=new y({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1621"}}),et=new y({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1311",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),tt=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1429"}}),at=new y({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1531"}}),ot=new y({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v2.21.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L966"}}),lt=new y({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L919"}}),nt=new y({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1671"}}),rt=new y({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_trainer.py#L1018"}}),st=new v({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),it=new y({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": FDivergenceType = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": float = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;exo_pair&quot;</code>: pairwise EXO loss from the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> paper.</li>
<li><code>&quot;nca_pair&quot;</code>: pairwise NCA loss from the <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> paper.</li>
<li><code>&quot;robust&quot;</code>: unbiased estimate of the DPO loss that is robust to preference noise from the <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper.</li>
<li><code>&quot;bco_pair&quot;</code>: pairwise BCO loss from the <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.</li>
<li><code>&quot;sppo_hard&quot;</code>: SPPO loss with hard label from the <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> paper.</li>
<li><code>&quot;aot&quot;</code>: AOT loss for paired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;aot_pair&quot;</code>: AOT loss for unpaired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;apo_zero&quot;</code>: APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
<li><code>&quot;apo_down&quot;</code>: APO-down loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder(Optional[int],",description:`<strong>is_encoder_decoder(<code>Optional[int]</code>,</strong> <em>optional</em>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder(Optional[int],"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>FDivergenceType</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
The type of f-divergence regularization function to compute divergence between policy and reference model. This argument is optional, defaults to <code>FDivergenceType.REVERSE_KL</code>.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha coef in alpha-divergence(u^-alpha) regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The flag for syncing reference model during training from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (&#x2018;int&#x2019;, <em>optional</em>, defaults to <code>2</code>) &#x2014;
The tau parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The alpha parameter from the <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper V3. If None, no weighting is applied and the loss is the same as the DPO loss. The paper recommends <code>rpo_alpha=1.0</code>.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/v0.10.1/trl/trainer/dpo_config.py#L32"}}),dt=new rn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){C=r("meta"),At=l(),Dt=r("p"),Nt=l(),p(B.$$.fragment),qt=l(),F=r("p"),F.innerHTML=Ro,Bt=l(),E=r("p"),E.textContent=Zo,Ft=l(),p(R.$$.fragment),Et=l(),Z=r("p"),Z.textContent=Wo,Rt=l(),W=r("ol"),W.innerHTML=Lo,Zt=l(),L=r("p"),L.innerHTML=Ho,Wt=l(),H=r("p"),H.innerHTML=zo,Lt=l(),I=r("img"),Ht=l(),z=r("p"),z.innerHTML=Go,zt=l(),p(Q.$$.fragment),Qt=l(),G=r("p"),G.innerHTML=So,Gt=l(),x=r("div"),x.innerHTML=Xo,St=l(),S=r("p"),S.innerHTML=Vo,Xt=l(),X=r("ul"),X.innerHTML=Yo,Vt=l(),V=r("p"),V.textContent=Ko,Yt=l(),p(Y.$$.fragment),Kt=l(),K=r("p"),K.innerHTML=el,ea=l(),ee=r("p"),ee.innerHTML=tl,ta=l(),te=r("p"),te.textContent=al,aa=l(),p(ae.$$.fragment),oa=l(),p(oe.$$.fragment),la=l(),le=r("p"),le.innerHTML=ol,na=l(),p(ne.$$.fragment),ra=l(),re=r("p"),re.innerHTML=ll,sa=l(),p(se.$$.fragment),ia=l(),ie=r("p"),ie.textContent=nl,da=l(),p(de.$$.fragment),pa=l(),pe=r("p"),pe.innerHTML=rl,ca=l(),p(ce.$$.fragment),ma=l(),me=r("p"),me.innerHTML=sl,ha=l(),he=r("p"),he.innerHTML=il,fa=l(),fe=r("p"),fe.innerHTML=dl,ua=l(),ue=r("p"),ue.innerHTML=pl,ga=l(),ge=r("p"),ge.innerHTML=cl,_a=l(),_e=r("p"),_e.innerHTML=ml,Ma=l(),Me=r("p"),Me.innerHTML=hl,Ta=l(),Te=r("p"),Te.innerHTML=fl,ya=l(),ye=r("p"),ye.innerHTML=ul,va=l(),ve=r("p"),ve.innerHTML=gl,ba=l(),be=r("p"),be.innerHTML=_l,wa=l(),we=r("p"),we.innerHTML=Ml,Ja=l(),Je=r("p"),Je.innerHTML=Tl,Ua=l(),p(Ue.$$.fragment),Ca=l(),Ce=r("p"),Ce.innerHTML=yl,ja=l(),je=r("p"),je.innerHTML=vl,Ia=l(),p(Ie.$$.fragment),xa=l(),xe=r("p"),xe.textContent=bl,Oa=l(),Oe=r("ul"),Oe.innerHTML=wl,Pa=l(),p(Pe.$$.fragment),$a=l(),$e=r("p"),$e.innerHTML=Jl,Da=l(),De=r("table"),De.innerHTML=Ul,ka=l(),ke=r("p"),ke.innerHTML=Cl,Aa=l(),p(Ae.$$.fragment),Na=l(),Ne=r("p"),Ne.innerHTML=jl,qa=l(),p(qe.$$.fragment),Ba=l(),Be=r("p"),Be.textContent=Il,Fa=l(),Fe=r("ol"),Fe.innerHTML=xl,Ea=l(),p(Ee.$$.fragment),Ra=l(),Re=r("p"),Re.innerHTML=Ol,Za=l(),Ze=r("p"),Ze.textContent=Pl,Wa=l(),p(We.$$.fragment),La=l(),Le=r("p"),Le.innerHTML=$l,Ha=l(),He=r("p"),He.textContent=Dl,za=l(),p(ze.$$.fragment),Qa=l(),p(Qe.$$.fragment),Ga=l(),g=r("div"),p(Ge.$$.fragment),po=l(),pt=r("p"),pt.textContent=kl,co=l(),O=r("div"),p(Se.$$.fragment),mo=l(),ct=r("p"),ct.textContent=Al,ho=l(),b=r("div"),p(Xe.$$.fragment),fo=l(),mt=r("p"),mt.textContent=Nl,uo=l(),ht=r("p"),ht.textContent=ql,go=l(),P=r("div"),p(Ve.$$.fragment),_o=l(),ft=r("p"),ft.textContent=Bl,Mo=l(),$=r("div"),p(Ye.$$.fragment),To=l(),ut=r("p"),ut.textContent=Fl,yo=l(),w=r("div"),p(Ke.$$.fragment),vo=l(),gt=r("p"),gt.innerHTML=El,bo=l(),_t=r("p"),_t.textContent=Rl,wo=l(),D=r("div"),p(et.$$.fragment),Jo=l(),Mt=r("p"),Mt.textContent=Zl,Uo=l(),k=r("div"),p(tt.$$.fragment),Co=l(),Tt=r("p"),Tt.textContent=Wl,jo=l(),A=r("div"),p(at.$$.fragment),Io=l(),yt=r("p"),yt.textContent=Ll,xo=l(),J=r("div"),p(ot.$$.fragment),Oo=l(),vt=r("p"),vt.innerHTML=Hl,Po=l(),bt=r("p"),bt.innerHTML=zl,$o=l(),U=r("div"),p(lt.$$.fragment),Do=l(),wt=r("p"),wt.innerHTML=Ql,ko=l(),Jt=r("p"),Jt.innerHTML=Gl,Ao=l(),N=r("div"),p(nt.$$.fragment),No=l(),Ut=r("p"),Ut.innerHTML=Sl,qo=l(),q=r("div"),p(rt.$$.fragment),Bo=l(),Ct=r("p"),Ct.textContent=Xl,Sa=l(),p(st.$$.fragment),Xa=l(),j=r("div"),p(it.$$.fragment),Fo=l(),jt=r("p"),jt.textContent=Vl,Va=l(),p(dt.$$.fragment),Ya=l(),kt=r("p"),this.h()},l(e){const t=ln("svelte-u9bgzb",document.head);C=s(t,"META",{name:!0,content:!0}),t.forEach(a),At=n(e),Dt=s(e,"P",{}),T(Dt).forEach(a),Nt=n(e),c(B.$$.fragment,e),qt=n(e),F=s(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1lm7578"&&(F.innerHTML=Ro),Bt=n(e),E=s(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-xh4sh7"&&(E.textContent=Zo),Ft=n(e),c(R.$$.fragment,e),Et=n(e),Z=s(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-e9zjgv"&&(Z.textContent=Wo),Rt=n(e),W=s(e,"OL",{"data-svelte-h":!0}),i(W)!=="svelte-1fzn07o"&&(W.innerHTML=Lo),Zt=n(e),L=s(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1smzh1j"&&(L.innerHTML=Ho),Wt=n(e),H=s(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1j7o61v"&&(H.innerHTML=zo),Lt=n(e),I=s(e,"IMG",{width:!0,alt:!0,src:!0}),Ht=n(e),z=s(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-16acsjo"&&(z.innerHTML=Go),zt=n(e),c(Q.$$.fragment,e),Qt=n(e),G=s(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-dcawbe"&&(G.innerHTML=So),Gt=n(e),x=s(e,"DIV",{style:!0,"data-svelte-h":!0}),i(x)!=="svelte-z15c7z"&&(x.innerHTML=Xo),St=n(e),S=s(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-cb9b0v"&&(S.innerHTML=Vo),Xt=n(e),X=s(e,"UL",{"data-svelte-h":!0}),i(X)!=="svelte-17vxuta"&&(X.innerHTML=Yo),Vt=n(e),V=s(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1gl9mvz"&&(V.textContent=Ko),Yt=n(e),c(Y.$$.fragment,e),Kt=n(e),K=s(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1a8oxjk"&&(K.innerHTML=el),ea=n(e),ee=s(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-18sesz1"&&(ee.innerHTML=tl),ta=n(e),te=s(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1vo7l4i"&&(te.textContent=al),aa=n(e),c(ae.$$.fragment,e),oa=n(e),c(oe.$$.fragment,e),la=n(e),le=s(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1fbhxim"&&(le.innerHTML=ol),na=n(e),c(ne.$$.fragment,e),ra=n(e),re=s(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1g6k52q"&&(re.innerHTML=ll),sa=n(e),c(se.$$.fragment,e),ia=n(e),ie=s(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1lg6q1l"&&(ie.textContent=nl),da=n(e),c(de.$$.fragment,e),pa=n(e),pe=s(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1ac5mum"&&(pe.innerHTML=rl),ca=n(e),c(ce.$$.fragment,e),ma=n(e),me=s(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-brvw70"&&(me.innerHTML=sl),ha=n(e),he=s(e,"P",{"data-svelte-h":!0}),i(he)!=="svelte-zgdwg0"&&(he.innerHTML=il),fa=n(e),fe=s(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-1h5i4g3"&&(fe.innerHTML=dl),ua=n(e),ue=s(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-8t0y3r"&&(ue.innerHTML=pl),ga=n(e),ge=s(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-12szbx3"&&(ge.innerHTML=cl),_a=n(e),_e=s(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-13a5pob"&&(_e.innerHTML=ml),Ma=n(e),Me=s(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-kjxzzp"&&(Me.innerHTML=hl),Ta=n(e),Te=s(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-ur4hvq"&&(Te.innerHTML=fl),ya=n(e),ye=s(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-17mpiz9"&&(ye.innerHTML=ul),va=n(e),ve=s(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-1gd397e"&&(ve.innerHTML=gl),ba=n(e),be=s(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-2807lr"&&(be.innerHTML=_l),wa=n(e),we=s(e,"P",{"data-svelte-h":!0}),i(we)!=="svelte-1ka1sjq"&&(we.innerHTML=Ml),Ja=n(e),Je=s(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-1dbs4t9"&&(Je.innerHTML=Tl),Ua=n(e),c(Ue.$$.fragment,e),Ca=n(e),Ce=s(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-14px1ga"&&(Ce.innerHTML=yl),ja=n(e),je=s(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1c01yo3"&&(je.innerHTML=vl),Ia=n(e),c(Ie.$$.fragment,e),xa=n(e),xe=s(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-132s7j9"&&(xe.textContent=bl),Oa=n(e),Oe=s(e,"UL",{"data-svelte-h":!0}),i(Oe)!=="svelte-1oji3mm"&&(Oe.innerHTML=wl),Pa=n(e),c(Pe.$$.fragment,e),$a=n(e),$e=s(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-2145zu"&&($e.innerHTML=Jl),Da=n(e),De=s(e,"TABLE",{"data-svelte-h":!0}),i(De)!=="svelte-435mua"&&(De.innerHTML=Ul),ka=n(e),ke=s(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1p74c9x"&&(ke.innerHTML=Cl),Aa=n(e),c(Ae.$$.fragment,e),Na=n(e),Ne=s(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-1o18rwj"&&(Ne.innerHTML=jl),qa=n(e),c(qe.$$.fragment,e),Ba=n(e),Be=s(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-4infz6"&&(Be.textContent=Il),Fa=n(e),Fe=s(e,"OL",{"data-svelte-h":!0}),i(Fe)!=="svelte-4ytutj"&&(Fe.innerHTML=xl),Ea=n(e),c(Ee.$$.fragment,e),Ra=n(e),Re=s(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-rqj7uy"&&(Re.innerHTML=Ol),Za=n(e),Ze=s(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-1xhv3st"&&(Ze.textContent=Pl),Wa=n(e),c(We.$$.fragment,e),La=n(e),Le=s(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-lynfy4"&&(Le.innerHTML=$l),Ha=n(e),He=s(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1gkqha7"&&(He.textContent=Dl),za=n(e),c(ze.$$.fragment,e),Qa=n(e),c(Qe.$$.fragment,e),Ga=n(e),g=s(e,"DIV",{class:!0});var _=T(g);c(Ge.$$.fragment,_),po=n(_),pt=s(_,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-n6cc8y"&&(pt.textContent=kl),co=n(_),O=s(_,"DIV",{class:!0});var eo=T(O);c(Se.$$.fragment,eo),mo=n(eo),ct=s(eo,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-10t1062"&&(ct.textContent=Al),eo.forEach(a),ho=n(_),b=s(_,"DIV",{class:!0});var It=T(b);c(Xe.$$.fragment,It),fo=n(It),mt=s(It,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-16i1nac"&&(mt.textContent=Nl),uo=n(It),ht=s(It,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-tgti68"&&(ht.textContent=ql),It.forEach(a),go=n(_),P=s(_,"DIV",{class:!0});var to=T(P);c(Ve.$$.fragment,to),_o=n(to),ft=s(to,"P",{"data-svelte-h":!0}),i(ft)!=="svelte-1cvsgkk"&&(ft.textContent=Bl),to.forEach(a),Mo=n(_),$=s(_,"DIV",{class:!0});var ao=T($);c(Ye.$$.fragment,ao),To=n(ao),ut=s(ao,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-ymgxq7"&&(ut.textContent=Fl),ao.forEach(a),yo=n(_),w=s(_,"DIV",{class:!0});var xt=T(w);c(Ke.$$.fragment,xt),vo=n(xt),gt=s(xt,"P",{"data-svelte-h":!0}),i(gt)!=="svelte-8qlty5"&&(gt.innerHTML=El),bo=n(xt),_t=s(xt,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-1tyo99t"&&(_t.textContent=Rl),xt.forEach(a),wo=n(_),D=s(_,"DIV",{class:!0});var oo=T(D);c(et.$$.fragment,oo),Jo=n(oo),Mt=s(oo,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-4nmimv"&&(Mt.textContent=Zl),oo.forEach(a),Uo=n(_),k=s(_,"DIV",{class:!0});var lo=T(k);c(tt.$$.fragment,lo),Co=n(lo),Tt=s(lo,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-11q8u7l"&&(Tt.textContent=Wl),lo.forEach(a),jo=n(_),A=s(_,"DIV",{class:!0});var no=T(A);c(at.$$.fragment,no),Io=n(no),yt=s(no,"P",{"data-svelte-h":!0}),i(yt)!=="svelte-18uwvbi"&&(yt.textContent=Ll),no.forEach(a),xo=n(_),J=s(_,"DIV",{class:!0});var Ot=T(J);c(ot.$$.fragment,Ot),Oo=n(Ot),vt=s(Ot,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-xesobz"&&(vt.innerHTML=Hl),Po=n(Ot),bt=s(Ot,"P",{"data-svelte-h":!0}),i(bt)!=="svelte-qg43tm"&&(bt.innerHTML=zl),Ot.forEach(a),$o=n(_),U=s(_,"DIV",{class:!0});var Pt=T(U);c(lt.$$.fragment,Pt),Do=n(Pt),wt=s(Pt,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-dkae9b"&&(wt.innerHTML=Ql),ko=n(Pt),Jt=s(Pt,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-hmd5cw"&&(Jt.innerHTML=Gl),Pt.forEach(a),Ao=n(_),N=s(_,"DIV",{class:!0});var ro=T(N);c(nt.$$.fragment,ro),No=n(ro),Ut=s(ro,"P",{"data-svelte-h":!0}),i(Ut)!=="svelte-nqksfz"&&(Ut.innerHTML=Sl),ro.forEach(a),qo=n(_),q=s(_,"DIV",{class:!0});var so=T(q);c(rt.$$.fragment,so),Bo=n(so),Ct=s(so,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-17kjsy4"&&(Ct.textContent=Xl),so.forEach(a),_.forEach(a),Sa=n(e),c(st.$$.fragment,e),Xa=n(e),j=s(e,"DIV",{class:!0});var io=T(j);c(it.$$.fragment,io),Fo=n(io),jt=s(io,"P",{"data-svelte-h":!0}),i(jt)!=="svelte-1va94c9"&&(jt.textContent=Vl),io.forEach(a),Va=n(e),c(dt.$$.fragment,e),Ya=n(e),kt=s(e,"P",{}),T(kt).forEach(a),this.h()},h(){M(C,"name","hf:doc:metadata"),M(C,"content",dn),M(I,"width","835"),M(I,"alt","Screenshot 2024-03-19 at 12 39 41"),Kl(I.src,Qo="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(I,"src",Qo),nn(x,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,C),o(e,At,t),o(e,Dt,t),o(e,Nt,t),m(B,e,t),o(e,qt,t),o(e,F,t),o(e,Bt,t),o(e,E,t),o(e,Ft,t),m(R,e,t),o(e,Et,t),o(e,Z,t),o(e,Rt,t),o(e,W,t),o(e,Zt,t),o(e,L,t),o(e,Wt,t),o(e,H,t),o(e,Lt,t),o(e,I,t),o(e,Ht,t),o(e,z,t),o(e,zt,t),m(Q,e,t),o(e,Qt,t),o(e,G,t),o(e,Gt,t),o(e,x,t),o(e,St,t),o(e,S,t),o(e,Xt,t),o(e,X,t),o(e,Vt,t),o(e,V,t),o(e,Yt,t),m(Y,e,t),o(e,Kt,t),o(e,K,t),o(e,ea,t),o(e,ee,t),o(e,ta,t),o(e,te,t),o(e,aa,t),m(ae,e,t),o(e,oa,t),m(oe,e,t),o(e,la,t),o(e,le,t),o(e,na,t),m(ne,e,t),o(e,ra,t),o(e,re,t),o(e,sa,t),m(se,e,t),o(e,ia,t),o(e,ie,t),o(e,da,t),m(de,e,t),o(e,pa,t),o(e,pe,t),o(e,ca,t),m(ce,e,t),o(e,ma,t),o(e,me,t),o(e,ha,t),o(e,he,t),o(e,fa,t),o(e,fe,t),o(e,ua,t),o(e,ue,t),o(e,ga,t),o(e,ge,t),o(e,_a,t),o(e,_e,t),o(e,Ma,t),o(e,Me,t),o(e,Ta,t),o(e,Te,t),o(e,ya,t),o(e,ye,t),o(e,va,t),o(e,ve,t),o(e,ba,t),o(e,be,t),o(e,wa,t),o(e,we,t),o(e,Ja,t),o(e,Je,t),o(e,Ua,t),m(Ue,e,t),o(e,Ca,t),o(e,Ce,t),o(e,ja,t),o(e,je,t),o(e,Ia,t),m(Ie,e,t),o(e,xa,t),o(e,xe,t),o(e,Oa,t),o(e,Oe,t),o(e,Pa,t),m(Pe,e,t),o(e,$a,t),o(e,$e,t),o(e,Da,t),o(e,De,t),o(e,ka,t),o(e,ke,t),o(e,Aa,t),m(Ae,e,t),o(e,Na,t),o(e,Ne,t),o(e,qa,t),m(qe,e,t),o(e,Ba,t),o(e,Be,t),o(e,Fa,t),o(e,Fe,t),o(e,Ea,t),m(Ee,e,t),o(e,Ra,t),o(e,Re,t),o(e,Za,t),o(e,Ze,t),o(e,Wa,t),m(We,e,t),o(e,La,t),o(e,Le,t),o(e,Ha,t),o(e,He,t),o(e,za,t),m(ze,e,t),o(e,Qa,t),m(Qe,e,t),o(e,Ga,t),o(e,g,t),m(Ge,g,null),d(g,po),d(g,pt),d(g,co),d(g,O),m(Se,O,null),d(O,mo),d(O,ct),d(g,ho),d(g,b),m(Xe,b,null),d(b,fo),d(b,mt),d(b,uo),d(b,ht),d(g,go),d(g,P),m(Ve,P,null),d(P,_o),d(P,ft),d(g,Mo),d(g,$),m(Ye,$,null),d($,To),d($,ut),d(g,yo),d(g,w),m(Ke,w,null),d(w,vo),d(w,gt),d(w,bo),d(w,_t),d(g,wo),d(g,D),m(et,D,null),d(D,Jo),d(D,Mt),d(g,Uo),d(g,k),m(tt,k,null),d(k,Co),d(k,Tt),d(g,jo),d(g,A),m(at,A,null),d(A,Io),d(A,yt),d(g,xo),d(g,J),m(ot,J,null),d(J,Oo),d(J,vt),d(J,Po),d(J,bt),d(g,$o),d(g,U),m(lt,U,null),d(U,Do),d(U,wt),d(U,ko),d(U,Jt),d(g,Ao),d(g,N),m(nt,N,null),d(N,No),d(N,Ut),d(g,qo),d(g,q),m(rt,q,null),d(q,Bo),d(q,Ct),o(e,Sa,t),m(st,e,t),o(e,Xa,t),o(e,j,t),m(it,j,null),d(j,Fo),d(j,jt),o(e,Va,t),m(dt,e,t),o(e,Ya,t),o(e,kt,t),Ka=!0},p:en,i(e){Ka||(h(B.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(Pe.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(We.$$.fragment,e),h(ze.$$.fragment,e),h(Qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Se.$$.fragment,e),h(Xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(ot.$$.fragment,e),h(lt.$$.fragment,e),h(nt.$$.fragment,e),h(rt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),Ka=!0)},o(e){f(B.$$.fragment,e),f(R.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(Ue.$$.fragment,e),f(Ie.$$.fragment,e),f(Pe.$$.fragment,e),f(Ae.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(We.$$.fragment,e),f(ze.$$.fragment,e),f(Qe.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(ot.$$.fragment,e),f(lt.$$.fragment,e),f(nt.$$.fragment,e),f(rt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),Ka=!1},d(e){e&&(a(At),a(Dt),a(Nt),a(qt),a(F),a(Bt),a(E),a(Ft),a(Et),a(Z),a(Rt),a(W),a(Zt),a(L),a(Wt),a(H),a(Lt),a(I),a(Ht),a(z),a(zt),a(Qt),a(G),a(Gt),a(x),a(St),a(S),a(Xt),a(X),a(Vt),a(V),a(Yt),a(Kt),a(K),a(ea),a(ee),a(ta),a(te),a(aa),a(oa),a(la),a(le),a(na),a(ra),a(re),a(sa),a(ia),a(ie),a(da),a(pa),a(pe),a(ca),a(ma),a(me),a(ha),a(he),a(fa),a(fe),a(ua),a(ue),a(ga),a(ge),a(_a),a(_e),a(Ma),a(Me),a(Ta),a(Te),a(ya),a(ye),a(va),a(ve),a(ba),a(be),a(wa),a(we),a(Ja),a(Je),a(Ua),a(Ca),a(Ce),a(ja),a(je),a(Ia),a(xa),a(xe),a(Oa),a(Oe),a(Pa),a($a),a($e),a(Da),a(De),a(ka),a(ke),a(Aa),a(Na),a(Ne),a(qa),a(Ba),a(Be),a(Fa),a(Fe),a(Ea),a(Ra),a(Re),a(Za),a(Ze),a(Wa),a(La),a(Le),a(Ha),a(He),a(za),a(Qa),a(Ga),a(g),a(Sa),a(Xa),a(j),a(Va),a(Ya),a(kt)),a(C),u(B,e),u(R,e),u(Q,e),u(Y,e),u(ae,e),u(oe,e),u(ne,e),u(se,e),u(de,e),u(ce,e),u(Ue,e),u(Ie,e),u(Pe,e),u(Ae,e),u(qe,e),u(Ee,e),u(We,e),u(ze,e),u(Qe,e),u(Ge),u(Se),u(Xe),u(Ve),u(Ye),u(Ke),u(et),u(tt),u(at),u(ot),u(lt),u(nt),u(rt),u(st,e),u(it),u(dt,e)}}}const dn='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function pn(Eo){return tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends an{constructor(C){super(),on(this,C,pn,sn,Yl,{})}}export{gn as component};
