import{s as jt,n as Ut,o as Gt}from"../chunks/scheduler.22bf70d2.js";import{S as Zt,i as Ct,g as s,s as a,r as d,A as Xt,h as o,f as l,c as i,j as Jt,u as m,x as p,k as vt,y as kt,a as n,v as r,d as u,t as f,w as c}from"../chunks/index.59178e06.js";import{C as b}from"../chunks/CodeBlock.f7047b13.js";import{H as g}from"../chunks/Heading.f8746c79.js";function zt(Oe){let h,pe,se,de,w,me,M,re,y,et="🤗 Accelerate brings <code>bitsandbytes</code> quantization to your model. You can now load any pytorch model in 8-bit or 4-bit with a few lines of code.",ue,T,tt='If you want to use 🤗 Transformers models with <code>bitsandbytes</code>, you should follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',fe,_,lt='To learn more about how the <code>bitsandbytes</code> quantization works, check out the blog posts on <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">8-bit quantization</a> and <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">4-bit quantization</a>.',ce,$,be,J,nt="You will need to install the following requirements:",he,v,at="<li>Install <code>bitsandbytes</code> library</li>",ge,j,we,U,it="<li>Install latest <code>accelerate</code> from source</li>",Me,G,ye,Z,st="<li>Install <code>minGPT</code> and <code>huggingface_hub</code> to run examples</li>",Te,C,_e,X,$e,k,ot='First, we need to initialize our model. To save memory, we can initialize an empty model using the context manager <a href="/docs/accelerate/v0.29.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a>.',Je,z,pt="Let’s take the GPT2 model from minGPT library.",ve,x,je,R,dt="Then, we need to get the path to the weights of your model. The path can be the state_dict file (e.g. “pytorch_model.bin”) or a folder containing the sharded checkpoints.",Ue,W,Ge,q,mt='Finally, you need to set your quantization configuration with <a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig">BnbQuantizationConfig</a>.',Ze,B,rt="Here’s an example for 8-bit quantization:",Ce,H,Xe,Y,ut="Here’s an example for 4-bit quantization:",ke,F,ze,I,ft='To quantize your empty model with the selected configuration, you need to use <a href="/docs/accelerate/v0.29.0/en/package_reference/utilities#accelerate.utils.load_and_quantize_model">load_and_quantize_model()</a>.',xe,P,Re,V,We,L,ct='You can save your 8-bit model with accelerate using <a href="/docs/accelerate/v0.29.0/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>.',qe,Q,Be,N,bt="Note that 4-bit model serialization is currently not supported.",He,A,Ye,E,ht=`You can offload some modules to cpu/disk if you don’t have enough space on the GPU to store the entire model on your GPUs.
This uses big model inference under the hood. Check this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling" rel="nofollow">documentation</a> for more details.`,Fe,S,gt="For 8-bit quantization, the selected modules will be converted to 8-bit precision.",Ie,D,wt="For 4-bit quantization, the selected modules will be kept in <code>torch_dtype</code> that the user passed in <code>BnbQuantizationConfig</code>.  We will add support to convert these offloaded modules in 4-bit when 4-bit serialization will be possible.",Pe,K,Mt="You just need to pass a custom <code>device_map</code> in order to offload modules on cpu/disk. The offload modules will be dispatched on the GPU when needed. Here’s an example :",Ve,O,Le,ee,Qe,te,yt='It is not possible to perform pure 8bit or 4bit training on these models. However, you can train these models by leveraging parameter efficient fine tuning methods (PEFT) and train for example adapters on top of them. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow">peft</a> library for more details.',Ne,le,Tt='Currently, you can’t add adapters on top of any quantized model. However, with the official support of adapters with 🤗 Transformers models, you can fine-tune quantized models. If you want to finetune a 🤗 Transformers model , follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a> instead. Check out this <a href="https://colab.research.google.com/drive/1VoYNfYDKcKRQRor98Zbf2-9VQTtGJ24k?usp=sharing" rel="nofollow">demo</a> on how to fine-tune a 4-bit 🤗 Transformers model.',Ae,ne,_t="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. Please note that <code>device_map=auto</code> should be used for inference only.",Ee,ae,Se,ie,$t='Check out the Google Colab <a href="https://colab.research.google.com/drive/1T1pOgewAWVpR9gKpaEWw4orOrzPFb3yM?usp=sharing" rel="nofollow">demo</a> for running quantized models on a GTP2 model. The GPT2-1.5B model checkpoint is in FP32 which uses 6GB of memory. After quantization, it uses 1.6GB with 8-bit modules and 1.2GB with 4-bit modules.',De,oe,Ke;return w=new g({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),M=new g({props:{title:"bitsandbytes Integration",local:"bitsandbytes-integration",headingTag:"h2"}}),$=new g({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h3"}}),j=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),G=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGYWNjZWxlcmF0ZS5naXQ=",highlighted:"pip install git+https://github.com/huggingface/accelerate.git",wrap:!1}}),C=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJGJTBBcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/
pip install huggingface_hub`,wrap:!1}}),X=new g({props:{title:"How it works",local:"how-it-works",headingTag:"h3"}}),x=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwZW1wdHlfbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)`,wrap:!1}}),W=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJtYXJjc3VuMTMlMkZncHQyLXhsLWxpbmVhci1zaGFyZGVkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
weights_location = snapshot_download(repo_id=<span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>)`,wrap:!1}}),H=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwbGxtX2ludDhfdGhyZXNob2xkJTIwJTNEJTIwNik=",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold = <span class="hljs-number">6</span>)`,wrap:!1}}),F=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>)`,wrap:!1}}),P=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2FuZF9xdWFudGl6ZV9tb2RlbCUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> load_and_quantize_model
quantized_model = load_and_quantize_model(empty_model, weights_location=weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),V=new g({props:{title:"Saving and loading 8-bit model",local:"saving-and-loading-8-bit-model",headingTag:"h3"}}),Q=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdGUlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBbmV3X3dlaWdodHNfbG9jYXRpb24lMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZzYXZlX2RpcmVjdG9yeSUyMiUwQWFjY2VsZXJhdGUuc2F2ZV9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBuZXdfd2VpZ2h0c19sb2NhdGlvbiklMEElMEFxdWFudGl6ZWRfbW9kZWxfZnJvbV9zYXZlZCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRG5ld193ZWlnaHRzX2xvY2F0aW9uJTJDJTIwYm5iX3F1YW50aXphdGlvbl9jb25maWclM0RibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlMjAlM0QlMjAlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerate = Accelerator()
new_weights_location = <span class="hljs-string">&quot;path/to/save_directory&quot;</span>
accelerate.save_model(quantized_model, new_weights_location)

quantized_model_from_saved = load_and_quantize_model(empty_model, weights_location=new_weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),A=new g({props:{title:"Offload modules to cpu and disk",local:"offload-modules-to-cpu-and-disk",headingTag:"h3"}}),O=new b({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53cGUlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuZHJvcCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIubG5fZiUyMiUzQSUyMCUyMmRpc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJsbV9oZWFkJTIyJTNBJTIwJTIyZGlzayUyMiUyQyUwQSU3RA==",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
}`,wrap:!1}}),ee=new g({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h3"}}),ae=new g({props:{title:"Example demo - running GPT2 1.5b on a Google Colab",local:"example-demo---running-gpt2-15b-on-a-google-colab",headingTag:"h3"}}),{c(){h=s("meta"),pe=a(),se=s("p"),de=a(),d(w.$$.fragment),me=a(),d(M.$$.fragment),re=a(),y=s("p"),y.innerHTML=et,ue=a(),T=s("p"),T.innerHTML=tt,fe=a(),_=s("p"),_.innerHTML=lt,ce=a(),d($.$$.fragment),be=a(),J=s("p"),J.textContent=nt,he=a(),v=s("ul"),v.innerHTML=at,ge=a(),d(j.$$.fragment),we=a(),U=s("ul"),U.innerHTML=it,Me=a(),d(G.$$.fragment),ye=a(),Z=s("ul"),Z.innerHTML=st,Te=a(),d(C.$$.fragment),_e=a(),d(X.$$.fragment),$e=a(),k=s("p"),k.innerHTML=ot,Je=a(),z=s("p"),z.textContent=pt,ve=a(),d(x.$$.fragment),je=a(),R=s("p"),R.textContent=dt,Ue=a(),d(W.$$.fragment),Ge=a(),q=s("p"),q.innerHTML=mt,Ze=a(),B=s("p"),B.textContent=rt,Ce=a(),d(H.$$.fragment),Xe=a(),Y=s("p"),Y.textContent=ut,ke=a(),d(F.$$.fragment),ze=a(),I=s("p"),I.innerHTML=ft,xe=a(),d(P.$$.fragment),Re=a(),d(V.$$.fragment),We=a(),L=s("p"),L.innerHTML=ct,qe=a(),d(Q.$$.fragment),Be=a(),N=s("p"),N.textContent=bt,He=a(),d(A.$$.fragment),Ye=a(),E=s("p"),E.innerHTML=ht,Fe=a(),S=s("p"),S.textContent=gt,Ie=a(),D=s("p"),D.innerHTML=wt,Pe=a(),K=s("p"),K.innerHTML=Mt,Ve=a(),d(O.$$.fragment),Le=a(),d(ee.$$.fragment),Qe=a(),te=s("p"),te.innerHTML=yt,Ne=a(),le=s("p"),le.innerHTML=Tt,Ae=a(),ne=s("p"),ne.innerHTML=_t,Ee=a(),d(ae.$$.fragment),Se=a(),ie=s("p"),ie.innerHTML=$t,De=a(),oe=s("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),pe=i(e),se=o(e,"P",{}),Jt(se).forEach(l),de=i(e),m(w.$$.fragment,e),me=i(e),m(M.$$.fragment,e),re=i(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-hqr34f"&&(y.innerHTML=et),ue=i(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1w8g9o5"&&(T.innerHTML=tt),fe=i(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-hrid2v"&&(_.innerHTML=lt),ce=i(e),m($.$$.fragment,e),be=i(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-50fa4n"&&(J.textContent=nt),he=i(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-t2geh8"&&(v.innerHTML=at),ge=i(e),m(j.$$.fragment,e),we=i(e),U=o(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-l0cm28"&&(U.innerHTML=it),Me=i(e),m(G.$$.fragment,e),ye=i(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-1c2t6dx"&&(Z.innerHTML=st),Te=i(e),m(C.$$.fragment,e),_e=i(e),m(X.$$.fragment,e),$e=i(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1deadjv"&&(k.innerHTML=ot),Je=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1fwkss5"&&(z.textContent=pt),ve=i(e),m(x.$$.fragment,e),je=i(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-bbyjp5"&&(R.textContent=dt),Ue=i(e),m(W.$$.fragment,e),Ge=i(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-6dno0j"&&(q.innerHTML=mt),Ze=i(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-4hyyr7"&&(B.textContent=rt),Ce=i(e),m(H.$$.fragment,e),Xe=i(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1qtcdkv"&&(Y.textContent=ut),ke=i(e),m(F.$$.fragment,e),ze=i(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-11iys91"&&(I.innerHTML=ft),xe=i(e),m(P.$$.fragment,e),Re=i(e),m(V.$$.fragment,e),We=i(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-18a4uht"&&(L.innerHTML=ct),qe=i(e),m(Q.$$.fragment,e),Be=i(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1x0s82b"&&(N.textContent=bt),He=i(e),m(A.$$.fragment,e),Ye=i(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1vy35js"&&(E.innerHTML=ht),Fe=i(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-11qxtld"&&(S.textContent=gt),Ie=i(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-qaw7ck"&&(D.innerHTML=wt),Pe=i(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-gyjts5"&&(K.innerHTML=Mt),Ve=i(e),m(O.$$.fragment,e),Le=i(e),m(ee.$$.fragment,e),Qe=i(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-rtwtrf"&&(te.innerHTML=yt),Ne=i(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1xs1cs9"&&(le.innerHTML=Tt),Ae=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1n8dj9v"&&(ne.innerHTML=_t),Ee=i(e),m(ae.$$.fragment,e),Se=i(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-10ut0yg"&&(ie.innerHTML=$t),De=i(e),oe=o(e,"P",{}),Jt(oe).forEach(l),this.h()},h(){vt(h,"name","hf:doc:metadata"),vt(h,"content",xt)},m(e,t){kt(document.head,h),n(e,pe,t),n(e,se,t),n(e,de,t),r(w,e,t),n(e,me,t),r(M,e,t),n(e,re,t),n(e,y,t),n(e,ue,t),n(e,T,t),n(e,fe,t),n(e,_,t),n(e,ce,t),r($,e,t),n(e,be,t),n(e,J,t),n(e,he,t),n(e,v,t),n(e,ge,t),r(j,e,t),n(e,we,t),n(e,U,t),n(e,Me,t),r(G,e,t),n(e,ye,t),n(e,Z,t),n(e,Te,t),r(C,e,t),n(e,_e,t),r(X,e,t),n(e,$e,t),n(e,k,t),n(e,Je,t),n(e,z,t),n(e,ve,t),r(x,e,t),n(e,je,t),n(e,R,t),n(e,Ue,t),r(W,e,t),n(e,Ge,t),n(e,q,t),n(e,Ze,t),n(e,B,t),n(e,Ce,t),r(H,e,t),n(e,Xe,t),n(e,Y,t),n(e,ke,t),r(F,e,t),n(e,ze,t),n(e,I,t),n(e,xe,t),r(P,e,t),n(e,Re,t),r(V,e,t),n(e,We,t),n(e,L,t),n(e,qe,t),r(Q,e,t),n(e,Be,t),n(e,N,t),n(e,He,t),r(A,e,t),n(e,Ye,t),n(e,E,t),n(e,Fe,t),n(e,S,t),n(e,Ie,t),n(e,D,t),n(e,Pe,t),n(e,K,t),n(e,Ve,t),r(O,e,t),n(e,Le,t),r(ee,e,t),n(e,Qe,t),n(e,te,t),n(e,Ne,t),n(e,le,t),n(e,Ae,t),n(e,ne,t),n(e,Ee,t),r(ae,e,t),n(e,Se,t),n(e,ie,t),n(e,De,t),n(e,oe,t),Ke=!0},p:Ut,i(e){Ke||(u(w.$$.fragment,e),u(M.$$.fragment,e),u($.$$.fragment,e),u(j.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(X.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),Ke=!0)},o(e){f(w.$$.fragment,e),f(M.$$.fragment,e),f($.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(C.$$.fragment,e),f(X.$$.fragment,e),f(x.$$.fragment,e),f(W.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(P.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),Ke=!1},d(e){e&&(l(pe),l(se),l(de),l(me),l(re),l(y),l(ue),l(T),l(fe),l(_),l(ce),l(be),l(J),l(he),l(v),l(ge),l(we),l(U),l(Me),l(ye),l(Z),l(Te),l(_e),l($e),l(k),l(Je),l(z),l(ve),l(je),l(R),l(Ue),l(Ge),l(q),l(Ze),l(B),l(Ce),l(Xe),l(Y),l(ke),l(ze),l(I),l(xe),l(Re),l(We),l(L),l(qe),l(Be),l(N),l(He),l(Ye),l(E),l(Fe),l(S),l(Ie),l(D),l(Pe),l(K),l(Ve),l(Le),l(Qe),l(te),l(Ne),l(le),l(Ae),l(ne),l(Ee),l(Se),l(ie),l(De),l(oe)),l(h),c(w,e),c(M,e),c($,e),c(j,e),c(G,e),c(C,e),c(X,e),c(x,e),c(W,e),c(H,e),c(F,e),c(P,e),c(V,e),c(Q,e),c(A,e),c(O,e),c(ee,e),c(ae,e)}}}const xt='{"title":"Quantization","local":"quantization","sections":[{"title":"bitsandbytes Integration","local":"bitsandbytes-integration","sections":[{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":3},{"title":"How it works","local":"how-it-works","sections":[],"depth":3},{"title":"Saving and loading 8-bit model","local":"saving-and-loading-8-bit-model","sections":[],"depth":3},{"title":"Offload modules to cpu and disk","local":"offload-modules-to-cpu-and-disk","sections":[],"depth":3},{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":3},{"title":"Example demo - running GPT2 1.5b on a Google Colab","local":"example-demo---running-gpt2-15b-on-a-google-colab","sections":[],"depth":3}],"depth":2}],"depth":1}';function Rt(Oe){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Zt{constructor(h){super(),Ct(this,h,Rt,zt,jt,{})}}export{Yt as component};
