import{s as Fs,a as Gl,n as Ds,o as Ks}from"../chunks/scheduler.505acc25.js";import{S as Os,i as tn,e as a,s as n,c as p,h as en,a as o,d as l,b as i,f as $l,g as r,j as M,k as c,l as kl,m as s,n as u,t as y,o as w,p as T}from"../chunks/index.fbb49fb4.js";import{C as ln}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as J}from"../chunks/CodeBlock.7f0851b7.js";import{H as Nt}from"../chunks/Heading.511e0027.js";import{E as sn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function nn(El){let m,Kt,Ft,Ot,h,te,U,ee,d,Wl,le,I,Sl="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",se,C,Zl="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",ne,f,Rl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",ie,b,ae,A,Ql="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",oe,v,Yl="Here are some commonly used tools in AI agents:",Me,g,Vl="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",pe,x,zl="Those are only examples, as you can in fact create a tool for any use case!",re,B,ql="A good tool should be something that <strong>complements the power of an LLM</strong>.",ue,_,Xl="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",ye,H,Nl="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",we,G,Pl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",Te,L,Fl,ce,$,Dl="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",me,k,Je,E,Kl="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. When we talk about providing tools to an Agent, we mean teaching the LLM about the existence of these tools and instructing it to generate text-based invocations when needed.",je,W,Ol="For example, if we provide a tool to check the weather at a location from the internet and then ask the LLM about the weather in Paris, the LLM will recognize that this is an opportunity to use the “weather” tool. Instead of retrieving the weather data itself, the LLM will generate text that represents a tool call, such as call weather_tool(‘Paris’).",he,S,ts="The <strong>Agent</strong> then reads this response, identifies that a tool call is required, executes the tool on the LLM’s behalf, and retrieves the actual weather data.",Ue,Z,es="The Tool-calling steps are typically not shown to the user: the Agent appends them as a new message before passing the updated conversation to the LLM again. The LLM then processes this additional context and generates a natural-sounding response for the user. From the user’s perspective, it appears as if the LLM directly interacted with the tool, but in reality, it was the Agent that handled the entire execution process in the background.",de,R,ls="We’ll talk a lot more about this process in future sessions.",Ie,Q,Ce,Y,ss="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",fe,V,ns,be,z,is="For this to work, we have to be very precise and accurate about:",Ae,q,as="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",ve,X,os="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",ge,N,Ms="If this seems too theoretical, let’s understand it through a concrete example.",xe,P,ps="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",Be,F,_e,D,rs="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",He,K,us="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",Ge,O,ys="The output of the tool is another integer number that we can describe like this:",Le,tt,ws="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",$e,et,Ts="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",ke,lt,Ee,st,cs="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",We,nt,ms="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",Se,it,Js="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",Ze,at,js="Is there a better way?",Re,ot,Qe,Mt,hs="Our tool was written in Python, and the implementation already provides everything we need:",Ye,pt,Us="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",Ve,rt,ds="There’s a reason people use programming languages: they are expressive, concise, and precise.",ze,ut,Is="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",qe,yt,Cs="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",Xe,wt,fs="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",Ne,Tt,Pe,ct,bs="Note the <code>@tool</code> decorator before the function definition.",Fe,mt,As="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code via the <code>to_string()</code> function provided by the decorator:",De,Jt,Ke,jt,vs="As you can see, it’s the same thing we wrote manually before!",Oe,ht,tl,Ut,gs="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",el,dt,xs="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",ll,It,sl,Ct,Bs="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",nl,ft,_s="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",il,bt,Hs="We could create a Tool with this class using code like the following:",al,At,ol,vt,Gs="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",Ml,gt,Ls="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",pl,j,Pt,$s="decorator code",Ll,xt,rl,Bt,ks="Just to reiterate, with this decorator in place we can implement our tool like this:",ul,_t,yl,Ht,Es="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",wl,Gt,Tl,Lt,Ws="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",cl,$t,Ss,ml,kt,Zs='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',Jl,Et,jl,Wt,Rs=`Model Context Protocol (MCP) is an <strong>open protocol</strong> that standardizes how applications <strong>provide tools to LLMs</strong>.
MCP provides:`,hl,St,Qs="<li>A growing list of pre-built integrations that your LLM can directly plug into</li> <li>The flexibility to switch between LLM providers and vendors</li> <li>Best practices for securing your data within your infrastructure</li>",Ul,Zt,Ys="This means that <strong>any framework implementing MCP can leverage tools defined within the protocol</strong>, eliminating the need to reimplement the same tool interface for each framework.",dl,Rt,Vs='If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Il,Cl,fl,Qt,zs="Tools play a crucial role in enhancing the capabilities of AI agents.",bl,Yt,qs="To summarize, we learned:",Al,Vt,Xs="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",vl,zt,Ns='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',gl,qt,Ps="But first, it’s time for another short quiz!",xl,Xt,Bl,Dt,_l;return h=new ln({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new Nt({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),b=new Nt({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),k=new Nt({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),Q=new Nt({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),F=new J({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),lt=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),ot=new Nt({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),Tt=new J({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Jt=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),ht=new Nt({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),It=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).

    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of arguments.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self,
                 name: <span class="hljs-built_in">str</span>,
                 description: <span class="hljs-built_in">str</span>,
                 func: <span class="hljs-type">Callable</span>,
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool,
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])

        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),At=new J({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),xt=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inspect

<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)

    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))

    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )

    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>

    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__

    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name,
        description=description,
        func=func,
        arguments=arguments,
        outputs=outputs
    )`,wrap:!1}}),_t=new J({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Gt=new J({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),Et=new Nt({props:{title:"Model Context Protocol (MCP): a unified tool interface",local:"model-context-protocol-mcp-a-unified-tool-interface",headingTag:"h3"}}),Xt=new sn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){m=a("meta"),Kt=n(),Ft=a("p"),Ot=n(),p(h.$$.fragment),te=n(),p(U.$$.fragment),ee=n(),d=a("img"),le=n(),I=a("p"),I.innerHTML=Sl,se=n(),C=a("p"),C.textContent=Zl,ne=n(),f=a("p"),f.textContent=Rl,ie=n(),p(b.$$.fragment),ae=n(),A=a("p"),A.innerHTML=Ql,oe=n(),v=a("p"),v.textContent=Yl,Me=n(),g=a("table"),g.innerHTML=Vl,pe=n(),x=a("p"),x.textContent=zl,re=n(),B=a("p"),B.innerHTML=ql,ue=n(),_=a("p"),_.innerHTML=Xl,ye=n(),H=a("p"),H.innerHTML=Nl,we=n(),G=a("p"),G.textContent=Pl,Te=n(),L=a("img"),ce=n(),$=a("ul"),$.innerHTML=Dl,me=n(),p(k.$$.fragment),Je=n(),E=a("p"),E.textContent=Kl,je=n(),W=a("p"),W.textContent=Ol,he=n(),S=a("p"),S.innerHTML=ts,Ue=n(),Z=a("p"),Z.textContent=es,de=n(),R=a("p"),R.textContent=ls,Ie=n(),p(Q.$$.fragment),Ce=n(),Y=a("p"),Y.textContent=ss,fe=n(),V=a("img"),be=n(),z=a("p"),z.textContent=is,Ae=n(),q=a("ol"),q.innerHTML=as,ve=n(),X=a("p"),X.innerHTML=os,ge=n(),N=a("p"),N.textContent=Ms,xe=n(),P=a("p"),P.innerHTML=ps,Be=n(),p(F.$$.fragment),_e=n(),D=a("p"),D.innerHTML=rs,He=n(),K=a("ul"),K.innerHTML=us,Ge=n(),O=a("p"),O.textContent=ys,Le=n(),tt=a("ul"),tt.innerHTML=ws,$e=n(),et=a("p"),et.textContent=Ts,ke=n(),p(lt.$$.fragment),Ee=n(),st=a("blockquote"),st.innerHTML=cs,We=n(),nt=a("p"),nt.textContent=ms,Se=n(),it=a("p"),it.textContent=Js,Ze=n(),at=a("p"),at.textContent=js,Re=n(),p(ot.$$.fragment),Qe=n(),Mt=a("p"),Mt.textContent=hs,Ye=n(),pt=a("ul"),pt.innerHTML=Us,Ve=n(),rt=a("p"),rt.textContent=ds,ze=n(),ut=a("p"),ut.innerHTML=Is,qe=n(),yt=a("p"),yt.textContent=Cs,Xe=n(),wt=a("p"),wt.innerHTML=fs,Ne=n(),p(Tt.$$.fragment),Pe=n(),ct=a("p"),ct.innerHTML=bs,Fe=n(),mt=a("p"),mt.innerHTML=As,De=n(),p(Jt.$$.fragment),Ke=n(),jt=a("p"),jt.textContent=vs,Oe=n(),p(ht.$$.fragment),tl=n(),Ut=a("p"),Ut.innerHTML=gs,el=n(),dt=a("blockquote"),dt.innerHTML=xs,ll=n(),p(It.$$.fragment),sl=n(),Ct=a("p"),Ct.innerHTML=Bs,nl=n(),ft=a("ul"),ft.innerHTML=_s,il=n(),bt=a("p"),bt.textContent=Hs,al=n(),p(At.$$.fragment),ol=n(),vt=a("p"),vt.innerHTML=Gs,Ml=n(),gt=a("blockquote"),gt.innerHTML=Ls,pl=n(),j=a("details"),Pt=a("summary"),Pt.textContent=$s,Ll=n(),p(xt.$$.fragment),rl=n(),Bt=a("p"),Bt.textContent=ks,ul=n(),p(_t.$$.fragment),yl=n(),Ht=a("p"),Ht.innerHTML=Es,wl=n(),p(Gt.$$.fragment),Tl=n(),Lt=a("p"),Lt.innerHTML=Ws,cl=n(),$t=a("img"),ml=n(),kt=a("p"),kt.innerHTML=Zs,Jl=n(),p(Et.$$.fragment),jl=n(),Wt=a("p"),Wt.innerHTML=Rs,hl=n(),St=a("ul"),St.innerHTML=Qs,Ul=n(),Zt=a("p"),Zt.innerHTML=Ys,dl=n(),Rt=a("p"),Rt.innerHTML=Vs,Il=n(),Cl=a("hr"),fl=n(),Qt=a("p"),Qt.textContent=zs,bl=n(),Yt=a("p"),Yt.textContent=qs,Al=n(),Vt=a("ul"),Vt.innerHTML=Xs,vl=n(),zt=a("p"),zt.innerHTML=Ns,gl=n(),qt=a("p"),qt.textContent=Ps,xl=n(),p(Xt.$$.fragment),Bl=n(),Dt=a("p"),this.h()},l(t){const e=en("svelte-u9bgzb",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(l),Kt=i(t),Ft=o(t,"P",{}),$l(Ft).forEach(l),Ot=i(t),r(h.$$.fragment,t),te=i(t),r(U.$$.fragment,t),ee=i(t),d=o(t,"IMG",{src:!0,alt:!0}),le=i(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-12q0l6c"&&(I.innerHTML=Sl),se=i(t),C=o(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-vccz0n"&&(C.textContent=Zl),ne=i(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=Rl),ie=i(t),r(b.$$.fragment,t),ae=i(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-d0memu"&&(A.innerHTML=Ql),oe=i(t),v=o(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1bnicmb"&&(v.textContent=Yl),Me=i(t),g=o(t,"TABLE",{"data-svelte-h":!0}),M(g)!=="svelte-1r7ovsn"&&(g.innerHTML=Vl),pe=i(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1fuccdy"&&(x.textContent=zl),re=i(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-178hc7g"&&(B.innerHTML=ql),ue=i(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1redoxr"&&(_.innerHTML=Xl),ye=i(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1v1ck09"&&(H.innerHTML=Nl),we=i(t),G=o(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-mz2far"&&(G.textContent=Pl),Te=i(t),L=o(t,"IMG",{src:!0,alt:!0}),ce=i(t),$=o(t,"UL",{"data-svelte-h":!0}),M($)!=="svelte-gj3em1"&&($.innerHTML=Dl),me=i(t),r(k.$$.fragment,t),Je=i(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-12sfw6d"&&(E.textContent=Kl),je=i(t),W=o(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-17ojdf7"&&(W.textContent=Ol),he=i(t),S=o(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1ym7xfc"&&(S.innerHTML=ts),Ue=i(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-16cdakx"&&(Z.textContent=es),de=i(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1gym7on"&&(R.textContent=ls),Ie=i(t),r(Q.$$.fragment,t),Ce=i(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1m76tol"&&(Y.textContent=ss),fe=i(t),V=o(t,"IMG",{src:!0,alt:!0}),be=i(t),z=o(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-e466s4"&&(z.textContent=is),Ae=i(t),q=o(t,"OL",{"data-svelte-h":!0}),M(q)!=="svelte-12vrnnv"&&(q.innerHTML=as),ve=i(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1lxlzbg"&&(X.innerHTML=os),ge=i(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1p033lp"&&(N.textContent=Ms),xe=i(t),P=o(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1if40sb"&&(P.innerHTML=ps),Be=i(t),r(F.$$.fragment,t),_e=i(t),D=o(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-somofk"&&(D.innerHTML=rs),He=i(t),K=o(t,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-1qi2vj"&&(K.innerHTML=us),Ge=i(t),O=o(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-z90coj"&&(O.textContent=ys),Le=i(t),tt=o(t,"UL",{"data-svelte-h":!0}),M(tt)!=="svelte-1rd1o27"&&(tt.innerHTML=ws),$e=i(t),et=o(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1gl47rm"&&(et.textContent=Ts),ke=i(t),r(lt.$$.fragment,t),Ee=i(t),st=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(st)!=="svelte-jn5onw"&&(st.innerHTML=cs),We=i(t),nt=o(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-dd2uu2"&&(nt.textContent=ms),Se=i(t),it=o(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1ec16zo"&&(it.textContent=Js),Ze=i(t),at=o(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-xhigt1"&&(at.textContent=js),Re=i(t),r(ot.$$.fragment,t),Qe=i(t),Mt=o(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-xwh6nk"&&(Mt.textContent=hs),Ye=i(t),pt=o(t,"UL",{"data-svelte-h":!0}),M(pt)!=="svelte-1mufwba"&&(pt.innerHTML=Us),Ve=i(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-6ogn9l"&&(rt.textContent=ds),ze=i(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-2908e6"&&(ut.innerHTML=Is),qe=i(t),yt=o(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1nshzlk"&&(yt.textContent=Cs),Xe=i(t),wt=o(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1iag2er"&&(wt.innerHTML=fs),Ne=i(t),r(Tt.$$.fragment,t),Pe=i(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1xfdhk0"&&(ct.innerHTML=bs),Fe=i(t),mt=o(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-hj3bkt"&&(mt.innerHTML=As),De=i(t),r(Jt.$$.fragment,t),Ke=i(t),jt=o(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-ah55dy"&&(jt.textContent=vs),Oe=i(t),r(ht.$$.fragment,t),tl=i(t),Ut=o(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1g4lbet"&&(Ut.innerHTML=gs),el=i(t),dt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(dt)!=="svelte-17jlnyo"&&(dt.innerHTML=xs),ll=i(t),r(It.$$.fragment,t),sl=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-1m24zfs"&&(Ct.innerHTML=Bs),nl=i(t),ft=o(t,"UL",{"data-svelte-h":!0}),M(ft)!=="svelte-1aoag7f"&&(ft.innerHTML=_s),il=i(t),bt=o(t,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-9jg0w0"&&(bt.textContent=Hs),al=i(t),r(At.$$.fragment,t),ol=i(t),vt=o(t,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-imjo5d"&&(vt.innerHTML=Gs),Ml=i(t),gt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(gt)!=="svelte-5gslq7"&&(gt.innerHTML=Ls),pl=i(t),j=o(t,"DETAILS",{});var Hl=$l(j);Pt=o(Hl,"SUMMARY",{"data-svelte-h":!0}),M(Pt)!=="svelte-14wmf42"&&(Pt.textContent=$s),Ll=i(Hl),r(xt.$$.fragment,Hl),Hl.forEach(l),rl=i(t),Bt=o(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1pxgdsn"&&(Bt.textContent=ks),ul=i(t),r(_t.$$.fragment,t),yl=i(t),Ht=o(t,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-oh725x"&&(Ht.innerHTML=Es),wl=i(t),r(Gt.$$.fragment,t),Tl=i(t),Lt=o(t,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-1gsasw4"&&(Lt.innerHTML=Ws),cl=i(t),$t=o(t,"IMG",{src:!0,alt:!0}),ml=i(t),kt=o(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-14h2jbz"&&(kt.innerHTML=Zs),Jl=i(t),r(Et.$$.fragment,t),jl=i(t),Wt=o(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-123mz07"&&(Wt.innerHTML=Rs),hl=i(t),St=o(t,"UL",{"data-svelte-h":!0}),M(St)!=="svelte-jdb0o1"&&(St.innerHTML=Qs),Ul=i(t),Zt=o(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-v0j64b"&&(Zt.innerHTML=Ys),dl=i(t),Rt=o(t,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-ki6njs"&&(Rt.innerHTML=Vs),Il=i(t),Cl=o(t,"HR",{}),fl=i(t),Qt=o(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-yaz9vn"&&(Qt.textContent=zs),bl=i(t),Yt=o(t,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-1mncb1b"&&(Yt.textContent=qs),Al=i(t),Vt=o(t,"UL",{"data-svelte-h":!0}),M(Vt)!=="svelte-1lbaznq"&&(Vt.innerHTML=Xs),vl=i(t),zt=o(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-16mxhlc"&&(zt.innerHTML=Ns),gl=i(t),qt=o(t,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-1w2njod"&&(qt.textContent=Ps),xl=i(t),r(Xt.$$.fragment,t),Bl=i(t),Dt=o(t,"P",{}),$l(Dt).forEach(l),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",an),Gl(d.src,Wl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||c(d,"src",Wl),c(d,"alt","Unit 1 planning"),Gl(L.src,Fl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||c(L,"src",Fl),c(L,"alt","Weather"),Gl(V.src,ns="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||c(V,"src",ns),c(V,"alt","System prompt for tools"),Gl($t.src,Ss="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||c($t,"src",Ss),c($t,"alt","System prompt for tools")},m(t,e){kl(document.head,m),s(t,Kt,e),s(t,Ft,e),s(t,Ot,e),u(h,t,e),s(t,te,e),u(U,t,e),s(t,ee,e),s(t,d,e),s(t,le,e),s(t,I,e),s(t,se,e),s(t,C,e),s(t,ne,e),s(t,f,e),s(t,ie,e),u(b,t,e),s(t,ae,e),s(t,A,e),s(t,oe,e),s(t,v,e),s(t,Me,e),s(t,g,e),s(t,pe,e),s(t,x,e),s(t,re,e),s(t,B,e),s(t,ue,e),s(t,_,e),s(t,ye,e),s(t,H,e),s(t,we,e),s(t,G,e),s(t,Te,e),s(t,L,e),s(t,ce,e),s(t,$,e),s(t,me,e),u(k,t,e),s(t,Je,e),s(t,E,e),s(t,je,e),s(t,W,e),s(t,he,e),s(t,S,e),s(t,Ue,e),s(t,Z,e),s(t,de,e),s(t,R,e),s(t,Ie,e),u(Q,t,e),s(t,Ce,e),s(t,Y,e),s(t,fe,e),s(t,V,e),s(t,be,e),s(t,z,e),s(t,Ae,e),s(t,q,e),s(t,ve,e),s(t,X,e),s(t,ge,e),s(t,N,e),s(t,xe,e),s(t,P,e),s(t,Be,e),u(F,t,e),s(t,_e,e),s(t,D,e),s(t,He,e),s(t,K,e),s(t,Ge,e),s(t,O,e),s(t,Le,e),s(t,tt,e),s(t,$e,e),s(t,et,e),s(t,ke,e),u(lt,t,e),s(t,Ee,e),s(t,st,e),s(t,We,e),s(t,nt,e),s(t,Se,e),s(t,it,e),s(t,Ze,e),s(t,at,e),s(t,Re,e),u(ot,t,e),s(t,Qe,e),s(t,Mt,e),s(t,Ye,e),s(t,pt,e),s(t,Ve,e),s(t,rt,e),s(t,ze,e),s(t,ut,e),s(t,qe,e),s(t,yt,e),s(t,Xe,e),s(t,wt,e),s(t,Ne,e),u(Tt,t,e),s(t,Pe,e),s(t,ct,e),s(t,Fe,e),s(t,mt,e),s(t,De,e),u(Jt,t,e),s(t,Ke,e),s(t,jt,e),s(t,Oe,e),u(ht,t,e),s(t,tl,e),s(t,Ut,e),s(t,el,e),s(t,dt,e),s(t,ll,e),u(It,t,e),s(t,sl,e),s(t,Ct,e),s(t,nl,e),s(t,ft,e),s(t,il,e),s(t,bt,e),s(t,al,e),u(At,t,e),s(t,ol,e),s(t,vt,e),s(t,Ml,e),s(t,gt,e),s(t,pl,e),s(t,j,e),kl(j,Pt),kl(j,Ll),u(xt,j,null),s(t,rl,e),s(t,Bt,e),s(t,ul,e),u(_t,t,e),s(t,yl,e),s(t,Ht,e),s(t,wl,e),u(Gt,t,e),s(t,Tl,e),s(t,Lt,e),s(t,cl,e),s(t,$t,e),s(t,ml,e),s(t,kt,e),s(t,Jl,e),u(Et,t,e),s(t,jl,e),s(t,Wt,e),s(t,hl,e),s(t,St,e),s(t,Ul,e),s(t,Zt,e),s(t,dl,e),s(t,Rt,e),s(t,Il,e),s(t,Cl,e),s(t,fl,e),s(t,Qt,e),s(t,bl,e),s(t,Yt,e),s(t,Al,e),s(t,Vt,e),s(t,vl,e),s(t,zt,e),s(t,gl,e),s(t,qt,e),s(t,xl,e),u(Xt,t,e),s(t,Bl,e),s(t,Dt,e),_l=!0},p:Ds,i(t){_l||(y(h.$$.fragment,t),y(U.$$.fragment,t),y(b.$$.fragment,t),y(k.$$.fragment,t),y(Q.$$.fragment,t),y(F.$$.fragment,t),y(lt.$$.fragment,t),y(ot.$$.fragment,t),y(Tt.$$.fragment,t),y(Jt.$$.fragment,t),y(ht.$$.fragment,t),y(It.$$.fragment,t),y(At.$$.fragment,t),y(xt.$$.fragment,t),y(_t.$$.fragment,t),y(Gt.$$.fragment,t),y(Et.$$.fragment,t),y(Xt.$$.fragment,t),_l=!0)},o(t){w(h.$$.fragment,t),w(U.$$.fragment,t),w(b.$$.fragment,t),w(k.$$.fragment,t),w(Q.$$.fragment,t),w(F.$$.fragment,t),w(lt.$$.fragment,t),w(ot.$$.fragment,t),w(Tt.$$.fragment,t),w(Jt.$$.fragment,t),w(ht.$$.fragment,t),w(It.$$.fragment,t),w(At.$$.fragment,t),w(xt.$$.fragment,t),w(_t.$$.fragment,t),w(Gt.$$.fragment,t),w(Et.$$.fragment,t),w(Xt.$$.fragment,t),_l=!1},d(t){t&&(l(Kt),l(Ft),l(Ot),l(te),l(ee),l(d),l(le),l(I),l(se),l(C),l(ne),l(f),l(ie),l(ae),l(A),l(oe),l(v),l(Me),l(g),l(pe),l(x),l(re),l(B),l(ue),l(_),l(ye),l(H),l(we),l(G),l(Te),l(L),l(ce),l($),l(me),l(Je),l(E),l(je),l(W),l(he),l(S),l(Ue),l(Z),l(de),l(R),l(Ie),l(Ce),l(Y),l(fe),l(V),l(be),l(z),l(Ae),l(q),l(ve),l(X),l(ge),l(N),l(xe),l(P),l(Be),l(_e),l(D),l(He),l(K),l(Ge),l(O),l(Le),l(tt),l($e),l(et),l(ke),l(Ee),l(st),l(We),l(nt),l(Se),l(it),l(Ze),l(at),l(Re),l(Qe),l(Mt),l(Ye),l(pt),l(Ve),l(rt),l(ze),l(ut),l(qe),l(yt),l(Xe),l(wt),l(Ne),l(Pe),l(ct),l(Fe),l(mt),l(De),l(Ke),l(jt),l(Oe),l(tl),l(Ut),l(el),l(dt),l(ll),l(sl),l(Ct),l(nl),l(ft),l(il),l(bt),l(al),l(ol),l(vt),l(Ml),l(gt),l(pl),l(j),l(rl),l(Bt),l(ul),l(yl),l(Ht),l(wl),l(Tl),l(Lt),l(cl),l($t),l(ml),l(kt),l(Jl),l(jl),l(Wt),l(hl),l(St),l(Ul),l(Zt),l(dl),l(Rt),l(Il),l(Cl),l(fl),l(Qt),l(bl),l(Yt),l(Al),l(Vt),l(vl),l(zt),l(gl),l(qt),l(xl),l(Bl),l(Dt)),l(m),T(h,t),T(U,t),T(b,t),T(k,t),T(Q,t),T(F,t),T(lt,t),T(ot,t),T(Tt,t),T(Jt,t),T(ht,t),T(It,t),T(At,t),T(xt),T(_t,t),T(Gt,t),T(Et,t),T(Xt,t)}}}const an='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3},{"title":"Model Context Protocol (MCP): a unified tool interface","local":"model-context-protocol-mcp-a-unified-tool-interface","sections":[],"depth":3}],"depth":2}],"depth":1}';function on(El){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends Os{constructor(m){super(),tn(this,m,on,nn,Fs,{})}}export{Tn as component};
