import{s as Kt,a as Pt,o as Ot,n as E}from"../chunks/scheduler.505acc25.js";import{S as el,i as tl,e as J,s as M,c as U,h as ll,a as w,d as t,b as c,f as Tt,g as I,j as T,k as W,l as sl,m as s,n as b,t as g,o as Z,p as C}from"../chunks/index.fbb49fb4.js";import{C as al}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as k}from"../chunks/CodeBlock.7f0851b7.js";import{H as V}from"../chunks/Heading.511e0027.js";import{H as ht,a as X}from"../chunks/HfOption.7b46941a.js";import{E as nl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function il($){let o,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>langchain.docstore.document</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGF0YXNldCUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIwZGF0YXNldCUyMGVudHJpZXMlMjBpbnRvJTIwRG9jdW1lbnQlMjBvYmplY3RzJTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]
`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),U(d.$$.fragment)},l(r){o=w(r,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1vrqwzz"&&(o.innerHTML=h),p=c(r),I(d.$$.fragment,r)},m(r,l){s(r,o,l),s(r,p,l),b(d,r,l),m=!0},p:E,i(r){m||(g(d.$$.fragment,r),m=!0)},o(r){Z(d.$$.fragment,r),m=!1},d(r){r&&(t(o),t(p)),C(d,r)}}}function ol($){let o,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>llama_index.core.schema</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5zY2hlbWElMjBpbXBvcnQlMjBEb2N1bWVudCUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkYXRhc2V0JTBBZ3Vlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJhZ2VudHMtY291cnNlJTJGdW5pdDMtaW52aXRlZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjBkYXRhc2V0JTIwZW50cmllcyUyMGludG8lMjBEb2N1bWVudCUyMG9iamVjdHMlMEFkb2NzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwRG9jdW1lbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidyZWxhdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidkZXNjcmlwdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidlbWFpbCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihndWVzdF9kYXRhc2V0KSklMEElNUQ=",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> llama_index.core.schema <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        text=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;relation&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;description&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;email&#x27;</span>][i]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}
    )
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(guest_dataset))
]`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),U(d.$$.fragment)},l(r){o=w(r,"P",{"data-svelte-h":!0}),T(o)!=="svelte-ag3ykm"&&(o.innerHTML=h),p=c(r),I(d.$$.fragment,r)},m(r,l){s(r,o,l),s(r,p,l),b(d,r,l),m=!0},p:E,i(r){m||(g(d.$$.fragment,r),m=!0)},o(r){Z(d.$$.fragment,r),m=!1},d(r){r&&(t(o),t(p)),C(d,r)}}}function rl($){let o,h="We will use the Hugging Face <code>datasets</code> library to load the dataset and convert it into a list of <code>Document</code> objects from the <code>langchain.docstore.document</code> module.",p,d,m;return d=new k({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGF0YXNldCUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIwZGF0YXNldCUyMGVudHJpZXMlMjBpbnRvJTIwRG9jdW1lbnQlMjBvYmplY3RzJTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RA==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Load the dataset</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convert dataset entries into Document objects</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),U(d.$$.fragment)},l(r){o=w(r,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1vrqwzz"&&(o.innerHTML=h),p=c(r),I(d.$$.fragment,r)},m(r,l){s(r,o,l),s(r,p,l),b(d,r,l),m=!0},p:E,i(r){m||(g(d.$$.fragment,r),m=!0)},o(r){Z(d.$$.fragment,r),m=!1},d(r){r&&(t(o),t(p)),C(d,r)}}}function pl($){let o,h,p,d,m,r;return o=new X({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[il]},$$scope:{ctx:$}}}),p=new X({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[ol]},$$scope:{ctx:$}}}),m=new X({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[rl]},$$scope:{ctx:$}}}),{c(){U(o.$$.fragment),h=M(),U(p.$$.fragment),d=M(),U(m.$$.fragment)},l(l){I(o.$$.fragment,l),h=c(l),I(p.$$.fragment,l),d=c(l),I(m.$$.fragment,l)},m(l,u){b(o,l,u),s(l,h,u),b(p,l,u),s(l,d,u),b(m,l,u),r=!0},p(l,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:l}),o.$set(j);const B={};u&2&&(B.$$scope={dirty:u,ctx:l}),p.$set(B);const y={};u&2&&(y.$$scope={dirty:u,ctx:l}),m.$set(y)},i(l){r||(g(o.$$.fragment,l),g(p.$$.fragment,l),g(m.$$.fragment,l),r=!0)},o(l){Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),r=!1},d(l){l&&(t(h),t(d)),C(o,l),C(p,l),C(m,l)}}}function Ml($){let o,h="We will use the <code>BM25Retriever</code> from the <code>langchain_community.retrievers</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,l,u,j,B="Let’s understand this tool step-by-step:",y,f,G="<li>The <code>name</code> and <code>description</code> help the agent understand when and how to use this tool</li> <li>The <code>inputs</code> define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The <code>forward</code> method processes the query and returns the most relevant guest information</li>",n;return l=new k({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEElMEFjbGFzcyUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyZ3Vlc3RfaW5mb19yZXRyaWV2ZXIlMjIlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUyMCUzRCUyMCUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMlRoZSUyMG5hbWUlMjBvciUyMHJlbGF0aW9uJTIwb2YlMjB0aGUlMjBndWVzdCUyMHlvdSUyMHdhbnQlMjBpbmZvcm1hdGlvbiUyMGFib3V0LiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGRvY3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pc19pbml0aWFsaXplZCUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZXRyaWV2ZXIlMjAlM0QlMjBCTTI1UmV0cmlldmVyLmZyb21fZG9jdW1lbnRzKGRvY3MpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwcXVlcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHNlbGYucmV0cmlldmVyLmdldF9yZWxldmFudF9kb2N1bWVudHMocXVlcnkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwZG9jJTIwaW4lMjByZXN1bHRzJTVCJTNBMyU1RCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyTm8lMjBtYXRjaGluZyUyMGd1ZXN0JTIwaW5mb3JtYXRpb24lMjBmb3VuZC4lMjIlMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdG9vbCUwQWd1ZXN0X2luZm9fdG9vbCUyMCUzRCUyMEd1ZXN0SW5mb1JldHJpZXZlclRvb2woZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GuestInfoRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;guest_info_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The name or relation of the guest you want information about.&quot;</span>
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs</span>):
        self.is_initialized = <span class="hljs-literal">False</span>
        self.retriever = BM25Retriever.from_documents(docs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>):
        results = self.retriever.get_relevant_documents(query)
        <span class="hljs-keyword">if</span> results:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

<span class="hljs-comment"># Initialize the tool</span>
guest_info_tool = GuestInfoRetrieverTool(docs)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),U(l.$$.fragment),u=M(),j=J("p"),j.textContent=B,y=M(),f=J("ul"),f.innerHTML=G,this.h()},l(a){o=w(a,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1weris3"&&(o.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),I(l.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-xficc2"&&(j.textContent=B),y=c(a),f=w(a,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-14ztz3k"&&(f.innerHTML=G),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,o,v),s(a,p,v),s(a,d,v),s(a,r,v),b(l,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,f,v),n=!0},p:E,i(a){n||(g(l.$$.fragment,a),n=!0)},o(a){Z(l.$$.fragment,a),n=!1},d(a){a&&(t(o),t(p),t(d),t(r),t(u),t(j),t(y),t(f)),C(l,a)}}}function cl($){let o,h="We will use the <code>BM25Retriever</code> from the <code>llama_index.retrievers.bm25</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,l,u,j,B="Let’s understand this tool step-by-step.",y,f,G="<li>The docstring helps the agent understand when and how to use this tool</li> <li>The type decorators define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The method processes the query and returns the most relevant guest information</li>",n;return l=new k({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgucmV0cmlldmVycy5ibTI1JTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RlZmF1bHRzKG5vZGVzJTNEZG9jcyklMEElMEFkZWYlMjBnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwYm0yNV9yZXRyaWV2ZXIucmV0cmlldmUocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MudGV4dCUyMGZvciUyMGRvYyUyMGluJTIwcmVzdWx0cyU1QiUzQTMlNUQlNUQpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMk5vJTIwbWF0Y2hpbmclMjBndWVzdCUyMGluZm9ybWF0aW9uJTIwZm91bmQuJTIyJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHRvb2wlMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBGdW5jdGlvblRvb2wuZnJvbV9kZWZhdWx0cyhnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool
<span class="hljs-keyword">from</span> llama_index.retrievers.bm25 <span class="hljs-keyword">import</span> BM25Retriever

bm25_retriever = BM25Retriever.from_defaults(nodes=docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_guest_info_retriever</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.retrieve(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.text <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

<span class="hljs-comment"># Initialize the tool</span>
guest_info_tool = FunctionTool.from_defaults(get_guest_info_retriever)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),U(l.$$.fragment),u=M(),j=J("p"),j.textContent=B,y=M(),f=J("ul"),f.innerHTML=G,this.h()},l(a){o=w(a,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1li0cac"&&(o.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),I(l.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-5xdv72"&&(j.textContent=B),y=c(a),f=w(a,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-1grz3gg"&&(f.innerHTML=G),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,o,v),s(a,p,v),s(a,d,v),s(a,r,v),b(l,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,f,v),n=!0},p:E,i(a){n||(g(l.$$.fragment,a),n=!0)},o(a){Z(l.$$.fragment,a),n=!1},d(a){a&&(t(o),t(p),t(d),t(r),t(u),t(j),t(y),t(f)),C(l,a)}}}function ul($){let o,h="We will use the <code>BM25Retriever</code> from the <code>langchain_community.retrievers</code> module to create a retriever tool.",p,d,m='<p>The <code>BM25Retriever</code> is a great starting point for retrieval, but for more advanced semantic search, you might consider using embedding-based retrievers like those from <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',r,l,u,j,B="Let’s understand this tool step-by-step.",y,f,G="<li>The <code>name</code> and <code>description</code> help the agent understand when and how to use this tool</li> <li>The type decorators define what parameters the tool expects (in this case, a search query)</li> <li>We’re using a <code>BM25Retriever</code>, which is a powerful text retrieval algorithm that doesn’t require embeddings</li> <li>The method processes the query and returns the most relevant guest information</li>",n;return l=new k({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnRvb2xzJTIwaW1wb3J0JTIwVG9vbCUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RvY3VtZW50cyhkb2NzKSUwQSUwQWRlZiUyMGV4dHJhY3RfdGV4dChxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmV0cmlldmVzJTIwZGV0YWlsZWQlMjBpbmZvcm1hdGlvbiUyMGFib3V0JTIwZ2FsYSUyMGd1ZXN0cyUyMGJhc2VkJTIwb24lMjB0aGVpciUyMG5hbWUlMjBvciUyMHJlbGF0aW9uLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBibTI1X3JldHJpZXZlci5pbnZva2UocXVlcnkpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXN1bHRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJTVDbiU1Q24lMjIuam9pbiglNUJkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwZG9jJTIwaW4lMjByZXN1bHRzJTVCJTNBMyU1RCU1RCklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyTm8lMjBtYXRjaGluZyUyMGd1ZXN0JTIwaW5mb3JtYXRpb24lMjBmb3VuZC4lMjIlMEElMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBUb29sKCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJndWVzdF9pbmZvX3JldHJpZXZlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGZ1bmMlM0RleHRyYWN0X3RleHQlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJldHJpZXZlcyUyMGRldGFpbGVkJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMGdhbGElMjBndWVzdHMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBuYW1lJTIwb3IlMjByZWxhdGlvbi4lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> langchain.tools <span class="hljs-keyword">import</span> Tool

bm25_retriever = BM25Retriever.from_documents(docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;&quot;&quot;</span>
    results = bm25_retriever.invoke(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No matching guest information found.&quot;</span>

guest_info_tool = Tool(
    name=<span class="hljs-string">&quot;guest_info_retriever&quot;</span>,
    func=extract_text,
    description=<span class="hljs-string">&quot;Retrieves detailed information about gala guests based on their name or relation.&quot;</span>
)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=h,p=M(),d=J("blockquote"),d.innerHTML=m,r=M(),U(l.$$.fragment),u=M(),j=J("p"),j.textContent=B,y=M(),f=J("ul"),f.innerHTML=G,this.h()},l(a){o=w(a,"P",{"data-svelte-h":!0}),T(o)!=="svelte-1weris3"&&(o.innerHTML=h),p=c(a),d=w(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(d)!=="svelte-jinfwb"&&(d.innerHTML=m),r=c(a),I(l.$$.fragment,a),u=c(a),j=w(a,"P",{"data-svelte-h":!0}),T(j)!=="svelte-5xdv72"&&(j.textContent=B),y=c(a),f=w(a,"UL",{"data-svelte-h":!0}),T(f)!=="svelte-95yww2"&&(f.innerHTML=G),this.h()},h(){W(d,"class","tip")},m(a,v){s(a,o,v),s(a,p,v),s(a,d,v),s(a,r,v),b(l,a,v),s(a,u,v),s(a,j,v),s(a,y,v),s(a,f,v),n=!0},p:E,i(a){n||(g(l.$$.fragment,a),n=!0)},o(a){Z(l.$$.fragment,a),n=!1},d(a){a&&(t(o),t(p),t(d),t(r),t(u),t(j),t(y),t(f)),C(l,a)}}}function dl($){let o,h,p,d,m,r;return o=new X({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[Ml]},$$scope:{ctx:$}}}),p=new X({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[cl]},$$scope:{ctx:$}}}),m=new X({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[ul]},$$scope:{ctx:$}}}),{c(){U(o.$$.fragment),h=M(),U(p.$$.fragment),d=M(),U(m.$$.fragment)},l(l){I(o.$$.fragment,l),h=c(l),I(p.$$.fragment,l),d=c(l),I(m.$$.fragment,l)},m(l,u){b(o,l,u),s(l,h,u),b(p,l,u),s(l,d,u),b(m,l,u),r=!0},p(l,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:l}),o.$set(j);const B={};u&2&&(B.$$scope={dirty:u,ctx:l}),p.$set(B);const y={};u&2&&(y.$$scope={dirty:u,ctx:l}),m.$set(y)},i(l){r||(g(o.$$.fragment,l),g(p.$$.fragment,l),g(m.$$.fragment,l),r=!0)},o(l){Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),r=!1},d(l){l&&(t(h),t(d)),C(o,l),C(p,l),C(m,l)}}}function ml($){let o,h,p,d="Expected output:",m,r,l,u,j="What’s happening in this final step:",B,y,f="<li>We initialize a Hugging Face model using the <code>InferenceClientModel</code> class</li> <li>We create our agent (Alfred) as a <code>CodeAgent</code>, which can execute Python code to solve problems</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",G;return o=new k({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwQWxmcmVkJTJDJTIwb3VyJTIwZ2FsYSUyMGFnZW50JTJDJTIwd2l0aCUyMHRoZSUyMGd1ZXN0JTIwaW5mbyUyMHRvb2wlMEFhbGZyZWQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJndWVzdF9pbmZvX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQSUyMyUyMEV4YW1wbGUlMjBxdWVyeSUyMEFsZnJlZCUyMG1pZ2h0JTIwcmVjZWl2ZSUyMGR1cmluZyUyMHRoZSUyMGdhbGElMEFyZXNwb25zZSUyMCUzRCUyMGFsZnJlZC5ydW4oJTIyVGVsbCUyMG1lJTIwYWJvdXQlMjBvdXIlMjBndWVzdCUyMG5hbWVkJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMEFsZnJlZCdzJTIwUmVzcG9uc2UlM0ElMjIpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Initialize the Hugging Face model</span>
model = InferenceClientModel()

<span class="hljs-comment"># Create Alfred, our gala agent, with the guest info tool</span>
alfred = CodeAgent(tools=[guest_info_tool], model=model)

<span class="hljs-comment"># Example query Alfred might receive during the gala</span>
response = alfred.run(<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUJhc2VkJTIwb24lMjB0aGUlMjBpbmZvcm1hdGlvbiUyMEklMjByZXRyaWV2ZWQlMkMlMjBMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBpcyUyMGFuJTIwZXN0ZWVtZWQlMjBtYXRoZW1hdGljaWFuJTIwYW5kJTIwZnJpZW5kLiUyMFNoZSUyMGlzJTIwcmVub3duZWQlMjBmb3IlMjBoZXIlMjBwaW9uZWVyaW5nJTIwd29yayUyMGluJTIwbWF0aGVtYXRpY3MlMjBhbmQlMjBjb21wdXRpbmclMkMlMjBvZnRlbiUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4lMjBIZXIlMjBlbWFpbCUyMGFkZHJlc3MlMjBpcyUyMGFkYS5sb3ZlbGFjZSU0MGV4YW1wbGUuY29tLg==",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Based <span class="hljs-keyword">on</span> the information I retrieved, Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> <span class="hljs-keyword">friend</span>. She <span class="hljs-built_in">is</span> renowned <span class="hljs-keyword">for</span> her pioneering work <span class="hljs-keyword">in</span> mathematics <span class="hljs-built_in">and</span> computing, often celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine. Her email address is ada.lovelace@example.com.</span>`,wrap:!1}}),{c(){U(o.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),U(r.$$.fragment),l=M(),u=J("p"),u.textContent=j,B=M(),y=J("ul"),y.innerHTML=f},l(n){I(o.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),I(r.$$.fragment,n),l=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),B=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1mwulne"&&(y.innerHTML=f)},m(n,a){b(o,n,a),s(n,h,a),s(n,p,a),s(n,m,a),b(r,n,a),s(n,l,a),s(n,u,a),s(n,B,a),s(n,y,a),G=!0},p:E,i(n){G||(g(o.$$.fragment,n),g(r.$$.fragment,n),G=!0)},o(n){Z(o.$$.fragment,n),Z(r.$$.fragment,n),G=!1},d(n){n&&(t(h),t(p),t(m),t(l),t(u),t(B),t(y)),C(o,n),C(r,n)}}}function Jl($){let o,h,p,d="Expected output:",m,r,l,u,j="What’s happening in this final step:",B,y,f="<li>We initialize a Hugging Face model using the <code>HuggingFaceInferenceAPI</code> class</li> <li>We create our agent (Alfred) as a <code>AgentWorkflow</code>, including the tool we just created</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",G;return o=new k({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuYWdlbnQud29ya2Zsb3clMjBpbXBvcnQlMjBBZ2VudFdvcmtmbG93JTBBZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBtb2RlbCUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwQWxmcmVkJTJDJTIwb3VyJTIwZ2FsYSUyMGFnZW50JTJDJTIwd2l0aCUyMHRoZSUyMGd1ZXN0JTIwaW5mbyUyMHRvb2wlMEFhbGZyZWQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1Qmd1ZXN0X2luZm9fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUyQyUwQSklMEElMEElMjMlMjBFeGFtcGxlJTIwcXVlcnklMjBBbGZyZWQlMjBtaWdodCUyMHJlY2VpdmUlMjBkdXJpbmclMjB0aGUlMjBnYWxhJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFsZnJlZC5ydW4oJTIyVGVsbCUyMG1lJTIwYWJvdXQlMjBvdXIlMjBndWVzdCUyMG5hbWVkJTIwJ0xhZHklMjBBZGElMjBMb3ZlbGFjZScuJTIyKSUwQSUwQXByaW50KCUyMiVGMCU5RiU4RSVBOSUyMEFsZnJlZCdzJTIwUmVzcG9uc2UlM0ElMjIpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Initialize the Hugging Face model</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># Create Alfred, our gala agent, with the guest info tool</span>
alfred = AgentWorkflow.from_tools_or_functions(
    [guest_info_tool],
    llm=llm,
)

<span class="hljs-comment"># Example query Alfred might receive during the gala</span>
response = <span class="hljs-keyword">await</span> alfred.run(<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUxhZHklMjBBZGElMjBMb3ZlbGFjZSUyMGlzJTIwYW4lMjBlc3RlZW1lZCUyMG1hdGhlbWF0aWNpYW4lMjBhbmQlMjBmcmllbmQlMkMlMjByZW5vd25lZCUyMGZvciUyMGhlciUyMHBpb25lZXJpbmclMjB3b3JrJTIwaW4lMjBtYXRoZW1hdGljcyUyMGFuZCUyMGNvbXB1dGluZy4lMjBTaGUlMjBpcyUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4lMjBIZXIlMjBlbWFpbCUyMGlzJTIwYWRhLmxvdmVsYWNlJTQwZXhhbXBsZS5jb20u",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> <span class="hljs-keyword">friend</span>, renowned <span class="hljs-keyword">for</span> her pioneering work <span class="hljs-keyword">in</span> mathematics <span class="hljs-built_in">and</span> computing. She <span class="hljs-built_in">is</span> celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine. Her email is ada.lovelace@example.com.</span>`,wrap:!1}}),{c(){U(o.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),U(r.$$.fragment),l=M(),u=J("p"),u.textContent=j,B=M(),y=J("ul"),y.innerHTML=f},l(n){I(o.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),I(r.$$.fragment,n),l=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),B=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1xe3pcb"&&(y.innerHTML=f)},m(n,a){b(o,n,a),s(n,h,a),s(n,p,a),s(n,m,a),b(r,n,a),s(n,l,a),s(n,u,a),s(n,B,a),s(n,y,a),G=!0},p:E,i(n){G||(g(o.$$.fragment,n),g(r.$$.fragment,n),G=!0)},o(n){Z(o.$$.fragment,n),Z(r.$$.fragment,n),G=!1},d(n){n&&(t(h),t(p),t(m),t(l),t(u),t(B),t(y)),C(o,n),C(r,n)}}}function wl($){let o,h,p,d="Expected output:",m,r,l,u,j="What’s happening in this final step:",B,y,f="<li>We initialize a Hugging Face model using the <code>HuggingFaceEndpoint</code> class. We also generate a chat interface and append the tools.</li> <li>We create our agent (Alfred) as a <code>StateGraph</code>, that combines 2 nodes (<code>assistant</code>, <code>tools</code>) using an edge</li> <li>We ask Alfred to retrieve information about a guest named “Lady Ada Lovelace”</li>",G;return o=new k({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, Annotated
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, HumanMessage, AIMessage
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langchain_huggingface <span class="hljs-keyword">import</span> HuggingFaceEndpoint, ChatHuggingFace

<span class="hljs-comment"># Generate the chat interface, including the tools</span>
llm = HuggingFaceEndpoint(
    repo_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
    huggingfacehub_api_token=HUGGINGFACEHUB_API_TOKEN,
)

chat = ChatHuggingFace(llm=llm, verbose=<span class="hljs-literal">True</span>)
tools = [guest_info_tool]
chat_with_tools = chat.bind_tools(tools)

<span class="hljs-comment"># Generate the AgentState and Agent graph</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [chat_with_tools.invoke(state[<span class="hljs-string">&quot;messages&quot;</span>])],
    }

<span class="hljs-comment">## The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
alfred = builder.<span class="hljs-built_in">compile</span>()

messages = [HumanMessage(content=<span class="hljs-string">&quot;Tell me about our guest named &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)]
response = alfred.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages})

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Alfred&#x27;s Response:&quot;</span>)
<span class="hljs-built_in">print</span>(response[<span class="hljs-string">&#x27;messages&#x27;</span>][-<span class="hljs-number">1</span>].content)`,wrap:!1}}),r=new k({props:{code:"JUYwJTlGJThFJUE5JTIwQWxmcmVkJ3MlMjBSZXNwb25zZSUzQSUwQUxhZHklMjBBZGElMjBMb3ZlbGFjZSUyMGlzJTIwYW4lMjBlc3RlZW1lZCUyMG1hdGhlbWF0aWNpYW4lMjBhbmQlMjBwaW9uZWVyJTIwaW4lMjBjb21wdXRpbmclMkMlMjBvZnRlbiUyMGNlbGVicmF0ZWQlMjBhcyUyMHRoZSUyMGZpcnN0JTIwY29tcHV0ZXIlMjBwcm9ncmFtbWVyJTIwZHVlJTIwdG8lMjBoZXIlMjB3b3JrJTIwb24lMjBDaGFybGVzJTIwQmFiYmFnZSdzJTIwQW5hbHl0aWNhbCUyMEVuZ2luZS4=",highlighted:`🎩 Alfred<span class="hljs-comment">&#x27;s Response:</span>
Lady Ada Lovelace <span class="hljs-built_in">is</span> an esteemed mathematician <span class="hljs-built_in">and</span> pioneer <span class="hljs-keyword">in</span> computing, often celebrated <span class="hljs-keyword">as</span> the first computer programmer due <span class="hljs-keyword">to</span> her work <span class="hljs-keyword">on</span> Charles Babbage<span class="hljs-comment">&#x27;s Analytical Engine.</span>`,wrap:!1}}),{c(){U(o.$$.fragment),h=M(),p=J("p"),p.textContent=d,m=M(),U(r.$$.fragment),l=M(),u=J("p"),u.textContent=j,B=M(),y=J("ul"),y.innerHTML=f},l(n){I(o.$$.fragment,n),h=c(n),p=w(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-15t3xg7"&&(p.textContent=d),m=c(n),I(r.$$.fragment,n),l=c(n),u=w(n,"P",{"data-svelte-h":!0}),T(u)!=="svelte-18avn85"&&(u.textContent=j),B=c(n),y=w(n,"UL",{"data-svelte-h":!0}),T(y)!=="svelte-1gzv19f"&&(y.innerHTML=f)},m(n,a){b(o,n,a),s(n,h,a),s(n,p,a),s(n,m,a),b(r,n,a),s(n,l,a),s(n,u,a),s(n,B,a),s(n,y,a),G=!0},p:E,i(n){G||(g(o.$$.fragment,n),g(r.$$.fragment,n),G=!0)},o(n){Z(o.$$.fragment,n),Z(r.$$.fragment,n),G=!1},d(n){n&&(t(h),t(p),t(m),t(l),t(u),t(B),t(y)),C(o,n),C(r,n)}}}function Tl($){let o,h,p,d,m,r;return o=new X({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[ml]},$$scope:{ctx:$}}}),p=new X({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[Jl]},$$scope:{ctx:$}}}),m=new X({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[wl]},$$scope:{ctx:$}}}),{c(){U(o.$$.fragment),h=M(),U(p.$$.fragment),d=M(),U(m.$$.fragment)},l(l){I(o.$$.fragment,l),h=c(l),I(p.$$.fragment,l),d=c(l),I(m.$$.fragment,l)},m(l,u){b(o,l,u),s(l,h,u),b(p,l,u),s(l,d,u),b(m,l,u),r=!0},p(l,u){const j={};u&2&&(j.$$scope={dirty:u,ctx:l}),o.$set(j);const B={};u&2&&(B.$$scope={dirty:u,ctx:l}),p.$set(B);const y={};u&2&&(y.$$scope={dirty:u,ctx:l}),m.$set(y)},i(l){r||(g(o.$$.fragment,l),g(p.$$.fragment,l),g(m.$$.fragment,l),r=!0)},o(l){Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),r=!1},d(l){l&&(t(h),t(d)),C(o,l),C(p,l),C(m,l)}}}function hl($){let o,h,p,d,m,r,l,u,j,B="Alfred, your trusted agent, is preparing for the most extravagant gala of the century. To ensure the event runs smoothly, Alfred needs quick access to up-to-date information about each guest. Let’s help Alfred by creating a custom Retrieval-Augmented Generation (RAG) tool, powered by our custom dataset.",y,f,G,n,a="Imagine Alfred mingling among the guests, needing to recall specific details about each person at a moment’s notice. A traditional LLM might struggle with this task because:",v,H,yt="<li>The guest list is specific to your event and not in the model’s training data</li> <li>Guest information may change or be updated frequently</li> <li>Alfred needs to retrieve precise details like email addresses</li>",Ce,Y,jt="This is where Retrieval Augmented Generation (RAG) shines! By combining a retrieval system with an LLM, Alfred can access accurate, up-to-date information about your guests on demand.",Be,Q,ft="<p>You can choose any of the frameworks covered in the course for this use case. Select your preferred option from the code tabs.</p>",ve,q,Ge,z,Ut="In this unit, we’ll develop our agent within a HF Space, as a structured Python project. This approach helps us maintain clean, modular code by organizing different functionalities into separate files.  Also, this makes for a more realistic use case where you would deploy the application for public use.",$e,L,We,D,It="<li><strong><code>tools.py</code></strong> – Provides auxiliary tools for the agent.</li> <li><strong><code>retriever.py</code></strong> – Implements retrieval functions to support knowledge access.</li> <li><strong><code>app.py</code></strong> – Integrates all components into a fully functional agent, which we’ll finalize in the last part of this unit.</li>",ke,P,bt='For a hands-on reference, check out <a href="https://huggingface.co/spaces/agents-course/Unit_3_Agentic_RAG" rel="nofollow">this HF Space</a>, where the Agentic RAG developed in this unit is live. Feel free to clone it and experiment!',Ve,K,gt="You can directly test the agent below:",Re,R,Zt,xe,O,Xe,ee,Ct='Our dataset <a href="https://huggingface.co/datasets/agents-course/unit3-invitees/" rel="nofollow"><code>agents-course/unit3-invitees</code></a> contains the following fields for each guest:',Ee,te,Bt="<li><strong>Name</strong>: Guest’s full name</li> <li><strong>Relation</strong>: How the guest is related to the host</li> <li><strong>Description</strong>: A brief biography or interesting facts about the guest</li> <li><strong>Email Address</strong>: Contact information for sending invitations or follow-ups</li>",Qe,le,vt="Below is a preview of the dataset:",_e,x,Gt,Ne,_,$t="<p>In a real-world scenario, this dataset could be expanded to include dietary preferences, gift interests, conversation topics to avoid, and other helpful details for a host.</p>",Ae,se,Fe,ae,Wt="We’ll create a custom tool that Alfred can use to quickly retrieve guest information during the gala. Let’s break this down into three manageable steps:",Se,ne,kt="<li>Load and prepare the dataset</li> <li>Create the Retriever Tool</li> <li>Integrate the Tool with Alfred</li>",He,ie,Vt="Let’s start with loading and preparing the dataset!",Ye,oe,qe,re,Rt="First, we need to transform our raw guest data into a format that’s optimized for retrieval.",ze,N,Le,pe,xt="In the code above, we:",De,Me,Xt="<li>Load the dataset</li> <li>Convert each guest entry into a <code>Document</code> object with formatted content</li> <li>Store the <code>Document</code> objects in a list</li>",Pe,ce,Et="This means we’ve got all of our data nicely available so we can get started with configuring our retrieval.",Ke,ue,Oe,de,Qt="Now, let’s create a custom tool that Alfred can use to search through our guest information.",et,A,tt,me,lt,Je,_t="Finally, let’s bring everything together by creating our agent and equipping it with our custom tool:",st,F,at,we,nt,Te,Nt="During the gala, a conversation might flow like this:",it,he,At="<strong>You:</strong> “Alfred, who is that gentleman talking to the ambassador?”",ot,ye,Ft="<strong>Alfred:</strong> <em>quickly searches the guest database</em> “That’s Dr. Nikola Tesla, sir. He’s an old friend from your university days. He’s recently patented a new wireless energy transmission system and would be delighted to discuss it with you. Just remember he’s passionate about pigeons, so that might make for good small talk.”",rt,je,pt,fe,Mt,Ue,St="Now that Alfred can retrieve guest information, consider how you might enhance this system:",ct,Ie,Ht='<li><strong>Improve the retriever</strong> to use a more sophisticated algorithm like <a href="https://www.sbert.net/" rel="nofollow">sentence-transformers</a></li> <li><strong>Implement a conversation memory</strong> so Alfred remembers previous interactions</li> <li><strong>Combine with web search</strong> to get the latest information on unfamiliar guests</li> <li><strong>Integrate multiple indexes</strong> to get more complete information from verified sources</li>',ut,be,Yt="Now Alfred is fully equipped to handle guest inquiries effortlessly, ensuring your gala is remembered as the most sophisticated and delightful event of the century!",dt,S,qt="<p>Try extending the retriever tool to also return conversation starters based on each guest’s interests or background. How would you modify the tool to accomplish this?</p> <p>When you’re done, implement your guest retriever tool in the <code>retriever.py</code> file.</p>",mt,ge,Jt,Ze,wt;return m=new al({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),l=new V({props:{title:"Creating a RAG Tool for Guest Stories",local:"creating-a-rag-tool-for-guest-stories",headingTag:"h1"}}),f=new V({props:{title:"Why RAG for a Gala?",local:"why-rag-for-a-gala",headingTag:"h2"}}),q=new V({props:{title:"Setting up our application",local:"setting-up-our-application",headingTag:"h2"}}),L=new V({props:{title:"Project Structure",local:"project-structure",headingTag:"h3"}}),O=new V({props:{title:"Dataset Overview",local:"dataset-overview",headingTag:"h2"}}),se=new V({props:{title:"Building the Guestbook Tool",local:"building-the-guestbook-tool",headingTag:"h2"}}),oe=new V({props:{title:"Step 1: Load and Prepare the Dataset",local:"step-1-load-and-prepare-the-dataset",headingTag:"h3"}}),N=new ht({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[pl]},$$scope:{ctx:$}}}),ue=new V({props:{title:"Step 2: Create the Retriever Tool",local:"step-2-create-the-retriever-tool",headingTag:"h3"}}),A=new ht({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[dl]},$$scope:{ctx:$}}}),me=new V({props:{title:"Step 3: Integrate the Tool with Alfred",local:"step-3-integrate-the-tool-with-alfred",headingTag:"h3"}}),F=new ht({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[Tl]},$$scope:{ctx:$}}}),we=new V({props:{title:"Example Interaction",local:"example-interaction",headingTag:"h2"}}),je=new k({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVsYXRpb24lMjIlM0ElMjAlMjJvbGQlMjBmcmllbmQlMjBmcm9tJTIwdW5pdmVyc2l0eSUyMGRheXMlMjIlMkMlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIwaXMlMjBhbiUyMG9sZCUyMGZyaWVuZCUyMGZyb20lMjB5b3VyJTIwdW5pdmVyc2l0eSUyMGRheXMuJTIwSGUncyUyMHJlY2VudGx5JTIwcGF0ZW50ZWQlMjBhJTIwbmV3JTIwd2lyZWxlc3MlMjBlbmVyZ3klMjB0cmFuc21pc3Npb24lMjBzeXN0ZW0lMjBhbmQlMjB3b3VsZCUyMGJlJTIwZGVsaWdodGVkJTIwdG8lMjBkaXNjdXNzJTIwaXQlMjB3aXRoJTIweW91LiUyMEp1c3QlMjByZW1lbWJlciUyMGhlJ3MlMjBwYXNzaW9uYXRlJTIwYWJvdXQlMjBwaWdlb25zJTJDJTIwc28lMjB0aGF0JTIwbWlnaHQlMjBtYWtlJTIwZm9yJTIwZ29vZCUyMHNtYWxsJTIwdGFsay4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbWFpbCUyMiUzQSUyMCUyMm5pa29sYS50ZXNsYSU0MGdtYWlsLmNvbSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;relation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;old friend from university days&quot;</span><span class="hljs-punctuation">,</span>  
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla is an old friend from your university days. He&#x27;s recently patented a new wireless energy transmission system and would be delighted to discuss it with you. Just remember he&#x27;s passionate about pigeons, so that might make for good small talk.&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;email&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nikola.tesla@gmail.com&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),fe=new V({props:{title:"Taking It Further",local:"taking-it-further",headingTag:"h2"}}),ge=new nl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit3/agentic-rag/invitees.mdx"}}),{c(){o=J("meta"),h=M(),p=J("p"),d=M(),U(m.$$.fragment),r=M(),U(l.$$.fragment),u=M(),j=J("p"),j.textContent=B,y=M(),U(f.$$.fragment),G=M(),n=J("p"),n.textContent=a,v=M(),H=J("ol"),H.innerHTML=yt,Ce=M(),Y=J("p"),Y.textContent=jt,Be=M(),Q=J("blockquote"),Q.innerHTML=ft,ve=M(),U(q.$$.fragment),Ge=M(),z=J("p"),z.textContent=Ut,$e=M(),U(L.$$.fragment),We=M(),D=J("ul"),D.innerHTML=It,ke=M(),P=J("p"),P.innerHTML=bt,Ve=M(),K=J("p"),K.textContent=gt,Re=M(),R=J("iframe"),xe=M(),U(O.$$.fragment),Xe=M(),ee=J("p"),ee.innerHTML=Ct,Ee=M(),te=J("ul"),te.innerHTML=Bt,Qe=M(),le=J("p"),le.textContent=vt,_e=M(),x=J("iframe"),Ne=M(),_=J("blockquote"),_.innerHTML=$t,Ae=M(),U(se.$$.fragment),Fe=M(),ae=J("p"),ae.textContent=Wt,Se=M(),ne=J("ol"),ne.innerHTML=kt,He=M(),ie=J("p"),ie.textContent=Vt,Ye=M(),U(oe.$$.fragment),qe=M(),re=J("p"),re.textContent=Rt,ze=M(),U(N.$$.fragment),Le=M(),pe=J("p"),pe.textContent=xt,De=M(),Me=J("ul"),Me.innerHTML=Xt,Pe=M(),ce=J("p"),ce.textContent=Et,Ke=M(),U(ue.$$.fragment),Oe=M(),de=J("p"),de.textContent=Qt,et=M(),U(A.$$.fragment),tt=M(),U(me.$$.fragment),lt=M(),Je=J("p"),Je.textContent=_t,st=M(),U(F.$$.fragment),at=M(),U(we.$$.fragment),nt=M(),Te=J("p"),Te.textContent=Nt,it=M(),he=J("p"),he.innerHTML=At,ot=M(),ye=J("p"),ye.innerHTML=Ft,rt=M(),U(je.$$.fragment),pt=M(),U(fe.$$.fragment),Mt=M(),Ue=J("p"),Ue.textContent=St,ct=M(),Ie=J("ol"),Ie.innerHTML=Ht,ut=M(),be=J("p"),be.textContent=Yt,dt=M(),S=J("blockquote"),S.innerHTML=qt,mt=M(),U(ge.$$.fragment),Jt=M(),Ze=J("p"),this.h()},l(e){const i=ll("svelte-u9bgzb",document.head);o=w(i,"META",{name:!0,content:!0}),i.forEach(t),h=c(e),p=w(e,"P",{}),Tt(p).forEach(t),d=c(e),I(m.$$.fragment,e),r=c(e),I(l.$$.fragment,e),u=c(e),j=w(e,"P",{"data-svelte-h":!0}),T(j)!=="svelte-1dmibto"&&(j.textContent=B),y=c(e),I(f.$$.fragment,e),G=c(e),n=w(e,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ohazl4"&&(n.textContent=a),v=c(e),H=w(e,"OL",{"data-svelte-h":!0}),T(H)!=="svelte-jzmsqw"&&(H.innerHTML=yt),Ce=c(e),Y=w(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-1pkxjfz"&&(Y.textContent=jt),Be=c(e),Q=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(Q)!=="svelte-7qfbjg"&&(Q.innerHTML=ft),ve=c(e),I(q.$$.fragment,e),Ge=c(e),z=w(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1dq0niz"&&(z.textContent=Ut),$e=c(e),I(L.$$.fragment,e),We=c(e),D=w(e,"UL",{"data-svelte-h":!0}),T(D)!=="svelte-718qhw"&&(D.innerHTML=It),ke=c(e),P=w(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1ahpfas"&&(P.innerHTML=bt),Ve=c(e),K=w(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-rbljri"&&(K.textContent=gt),Re=c(e),R=w(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tt(R).forEach(t),xe=c(e),I(O.$$.fragment,e),Xe=c(e),ee=w(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-1irlnn3"&&(ee.innerHTML=Ct),Ee=c(e),te=w(e,"UL",{"data-svelte-h":!0}),T(te)!=="svelte-kf7jwx"&&(te.innerHTML=Bt),Qe=c(e),le=w(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-79xtgg"&&(le.textContent=vt),_e=c(e),x=w(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tt(x).forEach(t),Ne=c(e),_=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(_)!=="svelte-1qutpnn"&&(_.innerHTML=$t),Ae=c(e),I(se.$$.fragment,e),Fe=c(e),ae=w(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-1oc2u9p"&&(ae.textContent=Wt),Se=c(e),ne=w(e,"OL",{"data-svelte-h":!0}),T(ne)!=="svelte-u61lb"&&(ne.innerHTML=kt),He=c(e),ie=w(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1psmdrg"&&(ie.textContent=Vt),Ye=c(e),I(oe.$$.fragment,e),qe=c(e),re=w(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-1qfcd42"&&(re.textContent=Rt),ze=c(e),I(N.$$.fragment,e),Le=c(e),pe=w(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-bw00jq"&&(pe.textContent=xt),De=c(e),Me=w(e,"UL",{"data-svelte-h":!0}),T(Me)!=="svelte-1676c5f"&&(Me.innerHTML=Xt),Pe=c(e),ce=w(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1mdm43h"&&(ce.textContent=Et),Ke=c(e),I(ue.$$.fragment,e),Oe=c(e),de=w(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1bgeoxd"&&(de.textContent=Qt),et=c(e),I(A.$$.fragment,e),tt=c(e),I(me.$$.fragment,e),lt=c(e),Je=w(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-11fbh5x"&&(Je.textContent=_t),st=c(e),I(F.$$.fragment,e),at=c(e),I(we.$$.fragment,e),nt=c(e),Te=w(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-12f07z5"&&(Te.textContent=Nt),it=c(e),he=w(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-r8vshx"&&(he.innerHTML=At),ot=c(e),ye=w(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-hi3m2m"&&(ye.innerHTML=Ft),rt=c(e),I(je.$$.fragment,e),pt=c(e),I(fe.$$.fragment,e),Mt=c(e),Ue=w(e,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-1up6x2f"&&(Ue.textContent=St),ct=c(e),Ie=w(e,"OL",{"data-svelte-h":!0}),T(Ie)!=="svelte-1eie5na"&&(Ie.innerHTML=Ht),ut=c(e),be=w(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-1upuje4"&&(be.textContent=Yt),dt=c(e),S=w(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(S)!=="svelte-1mvfvvl"&&(S.innerHTML=qt),mt=c(e),I(ge.$$.fragment,e),Jt=c(e),Ze=w(e,"P",{}),Tt(Ze).forEach(t),this.h()},h(){W(o,"name","hf:doc:metadata"),W(o,"content",yl),W(Q,"class","tip"),Pt(R.src,Zt="https://agents-course-unit-3-agentic-rag.hf.space")||W(R,"src",Zt),W(R,"frameborder","0"),W(R,"width","850"),W(R,"height","450"),Pt(x.src,Gt="https://huggingface.co/datasets/agents-course/unit3-invitees/embed/viewer/default/train")||W(x,"src",Gt),W(x,"frameborder","0"),W(x,"width","100%"),W(x,"height","560px"),W(_,"class","tip"),W(S,"class","tip")},m(e,i){sl(document.head,o),s(e,h,i),s(e,p,i),s(e,d,i),b(m,e,i),s(e,r,i),b(l,e,i),s(e,u,i),s(e,j,i),s(e,y,i),b(f,e,i),s(e,G,i),s(e,n,i),s(e,v,i),s(e,H,i),s(e,Ce,i),s(e,Y,i),s(e,Be,i),s(e,Q,i),s(e,ve,i),b(q,e,i),s(e,Ge,i),s(e,z,i),s(e,$e,i),b(L,e,i),s(e,We,i),s(e,D,i),s(e,ke,i),s(e,P,i),s(e,Ve,i),s(e,K,i),s(e,Re,i),s(e,R,i),s(e,xe,i),b(O,e,i),s(e,Xe,i),s(e,ee,i),s(e,Ee,i),s(e,te,i),s(e,Qe,i),s(e,le,i),s(e,_e,i),s(e,x,i),s(e,Ne,i),s(e,_,i),s(e,Ae,i),b(se,e,i),s(e,Fe,i),s(e,ae,i),s(e,Se,i),s(e,ne,i),s(e,He,i),s(e,ie,i),s(e,Ye,i),b(oe,e,i),s(e,qe,i),s(e,re,i),s(e,ze,i),b(N,e,i),s(e,Le,i),s(e,pe,i),s(e,De,i),s(e,Me,i),s(e,Pe,i),s(e,ce,i),s(e,Ke,i),b(ue,e,i),s(e,Oe,i),s(e,de,i),s(e,et,i),b(A,e,i),s(e,tt,i),b(me,e,i),s(e,lt,i),s(e,Je,i),s(e,st,i),b(F,e,i),s(e,at,i),b(we,e,i),s(e,nt,i),s(e,Te,i),s(e,it,i),s(e,he,i),s(e,ot,i),s(e,ye,i),s(e,rt,i),b(je,e,i),s(e,pt,i),b(fe,e,i),s(e,Mt,i),s(e,Ue,i),s(e,ct,i),s(e,Ie,i),s(e,ut,i),s(e,be,i),s(e,dt,i),s(e,S,i),s(e,mt,i),b(ge,e,i),s(e,Jt,i),s(e,Ze,i),wt=!0},p(e,[i]){const zt={};i&2&&(zt.$$scope={dirty:i,ctx:e}),N.$set(zt);const Lt={};i&2&&(Lt.$$scope={dirty:i,ctx:e}),A.$set(Lt);const Dt={};i&2&&(Dt.$$scope={dirty:i,ctx:e}),F.$set(Dt)},i(e){wt||(g(m.$$.fragment,e),g(l.$$.fragment,e),g(f.$$.fragment,e),g(q.$$.fragment,e),g(L.$$.fragment,e),g(O.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(N.$$.fragment,e),g(ue.$$.fragment,e),g(A.$$.fragment,e),g(me.$$.fragment,e),g(F.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),wt=!0)},o(e){Z(m.$$.fragment,e),Z(l.$$.fragment,e),Z(f.$$.fragment,e),Z(q.$$.fragment,e),Z(L.$$.fragment,e),Z(O.$$.fragment,e),Z(se.$$.fragment,e),Z(oe.$$.fragment,e),Z(N.$$.fragment,e),Z(ue.$$.fragment,e),Z(A.$$.fragment,e),Z(me.$$.fragment,e),Z(F.$$.fragment,e),Z(we.$$.fragment,e),Z(je.$$.fragment,e),Z(fe.$$.fragment,e),Z(ge.$$.fragment,e),wt=!1},d(e){e&&(t(h),t(p),t(d),t(r),t(u),t(j),t(y),t(G),t(n),t(v),t(H),t(Ce),t(Y),t(Be),t(Q),t(ve),t(Ge),t(z),t($e),t(We),t(D),t(ke),t(P),t(Ve),t(K),t(Re),t(R),t(xe),t(Xe),t(ee),t(Ee),t(te),t(Qe),t(le),t(_e),t(x),t(Ne),t(_),t(Ae),t(Fe),t(ae),t(Se),t(ne),t(He),t(ie),t(Ye),t(qe),t(re),t(ze),t(Le),t(pe),t(De),t(Me),t(Pe),t(ce),t(Ke),t(Oe),t(de),t(et),t(tt),t(lt),t(Je),t(st),t(at),t(nt),t(Te),t(it),t(he),t(ot),t(ye),t(rt),t(pt),t(Mt),t(Ue),t(ct),t(Ie),t(ut),t(be),t(dt),t(S),t(mt),t(Jt),t(Ze)),t(o),C(m,e),C(l,e),C(f,e),C(q,e),C(L,e),C(O,e),C(se,e),C(oe,e),C(N,e),C(ue,e),C(A,e),C(me,e),C(F,e),C(we,e),C(je,e),C(fe,e),C(ge,e)}}}const yl='{"title":"Creating a RAG Tool for Guest Stories","local":"creating-a-rag-tool-for-guest-stories","sections":[{"title":"Why RAG for a Gala?","local":"why-rag-for-a-gala","sections":[],"depth":2},{"title":"Setting up our application","local":"setting-up-our-application","sections":[{"title":"Project Structure","local":"project-structure","sections":[],"depth":3}],"depth":2},{"title":"Dataset Overview","local":"dataset-overview","sections":[],"depth":2},{"title":"Building the Guestbook Tool","local":"building-the-guestbook-tool","sections":[{"title":"Step 1: Load and Prepare the Dataset","local":"step-1-load-and-prepare-the-dataset","sections":[],"depth":3},{"title":"Step 2: Create the Retriever Tool","local":"step-2-create-the-retriever-tool","sections":[],"depth":3},{"title":"Step 3: Integrate the Tool with Alfred","local":"step-3-integrate-the-tool-with-alfred","sections":[],"depth":3}],"depth":2},{"title":"Example Interaction","local":"example-interaction","sections":[],"depth":2},{"title":"Taking It Further","local":"taking-it-further","sections":[],"depth":2}],"depth":1}';function jl($){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends el{constructor(o){super(),tl(this,o,jl,hl,Kt,{})}}export{Bl as component};
