# Welcome to the 🤗 AI Agents Course [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="AI Agents Course thumbnail" width="100%"/>
<figcaption>The background of the image was generated using <a href="https://scenario.com/">Scenario.com</a>
</figcaption>
</figure>


Welcome to the most exciting topic in AI today: **Agents**!

This free course will take you on a journey, **from beginner to expert**, in understanding, using and building AI agents.

This first unit will help you onboard:

- Discover the **course's syllabus**.
- **Choose the path** you're going to take (either self-audit or certification process).
- **Get more information about the certification process**.
- Get to know the team behind the course.
- Create your **Hugging Face account**.
- **Sign-up to our Discord server**, and meet your classmates and us.

Let's get started!

## What to expect from this course? [[expect]]

In this course, you will:

- 📖 Study AI Agents in **theory, design, and practice.**
- 🧑‍💻 Learn to **use established AI Agent libraries** such as [smolagents](https://huggingface.co/docs/smolagents/en/index), [LlamaIndex](https://www.llamaindex.ai/), and [LangGraph](https://langchain-ai.github.io/langgraph/).
- 💾 **Share your agents** on the Hugging Face Hub and explore agents created by the community.
- 🏆 Participate in challenges where you will **evaluate your agents against other students'.**
- 🎓 **Earn a certificate of completion** by completing assignments.

And more!

At the end of this course, you'll understand **how Agents work and how to build your own Agents using the latest libraries and tools**.

Don't forget to **<a href="https://bit.ly/hf-learn-agents">sign up to the course!</a>**

(We are respectful of your privacy. We collect your email address to be able to **send you the links when each Unit is published and give you information about the challenges and updates**).

## What does the course look like? [[course-look-like]]

The course is composed of:

- *Foundational Units*: where you learn Agents **concepts in theory**.
- *Hands-on*: where you'll learn **to use established AI Agent libraries** to train your agents in unique environments. These hands-on sections will be **Hugging Face Spaces** with a pre-configured environment.
- *Use case assignments*: where you'll apply the concepts you've learned to solve a real-world problem that you'll choose.
- *The Challenge*: you'll get to put your agent to compete against other agents in a challenge. There will also be [a leaderboard](https://huggingface.co/spaces/agents-course/Students_leaderboard) for you to compare the agents' performance.

This **course is a living project, evolving with your feedback and contributions!** Feel free to [open issues and PRs in GitHub](https://github.com/huggingface/agents-course), and engage in discussions in our Discord server.

After you have gone through the course, you can also send your feedback  [👉 using this form](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog)

## What's the syllabus? [[syllabus]]

Here is the **general syllabus for the course**. A more detailed list of topics will be released with each unit.

| Chapter | Topic | Description |
| :---- | :---- | :---- |
| 0 | Onboarding | Set you up with the tools and platforms that you will use. |
| 1 | Agent Fundamentals | Explain Tools, Thoughts, Actions, Observations, and their formats. Explain LLMs, messages, special tokens and chat templates. Show a simple use case using python functions as tools. |
| 2 | Frameworks | Understand how the fundamentals are implemented in popular libraries : smolagents, LangGraph, LLamaIndex |
| 3 | Use Cases | Let's build some real life use cases (open to PRs 🤗 from experienced Agent builders) |
| 4 | Final Assignment | Build an agent for a selected benchmark and prove your understanding of Agents on the student leaderboard  🚀 |

In addition to the main syllabus, you have 3 bonus units:
- *Bonus Unit 1* : Fine-tuning an LLM for Function-calling
- *Bonus Unit 2* : Agent Observability and Evaluation
- *Bonus Unit 3* : Agents in Games with Pokemon

For instance, in the Bonus Unit 3, you learn to build your Agent to play Pokemon battles 🥊.

## What are the prerequisites?

To be able to follow this course, you should have a:

- Basic knowledge of Python
- Basic knowledge of LLMs (we have a section in Unit 1 to recap what they are)


## What tools do I need? [[tools]]

You only need 2 things:

- *A computer* with an internet connection.
- A *Hugging Face Account*: to push and load models, agents, and create Spaces. If you don't have an account yet, you can create one **[here](https://hf.co/join)** (it's free).
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Course tools needed" width="100%"/>

## The Certification Process [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Two paths" width="100%"/>

You can choose to follow this course *in audit mode*, or do the activities and *get one of the two certificates we'll issue*.

If you audit the course, you can participate in all the challenges and do assignments if you want, and **you don't need to notify us**.

The certification process is **completely free**:

- *To get a certification for fundamentals*: you need to complete Unit 1 of the course. This is intended for students that want to get up to date with the latest trends in Agents.
- *To get a certificate of completion*: you need to complete Unit 1, one of the use case assignments we'll propose during the course, and the final challenge.

There's **no deadline** for the certification process.

## What is the recommended pace? [[recommended-pace]]

Each chapter in this course is designed **to be completed in 1 week, with approximately 3-4 hours of work per week**.

We provide you a recommended pace:

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Recommended Pace" width="100%"/>

## How to get the most out of the course? [[advice]]

To get the most out of the course, we have some advice:

1. <a href="https://discord.gg/UrrTSsSyjb">Join study groups in Discord</a>: studying in groups is always easier. To do that, you need to join our discord server and verify your Hugging Face account.
2. **Do the quizzes and assignments**: the best way to learn is through hands-on practice and self-assessment.
3. **Define a schedule to stay in sync**: you can use our recommended pace schedule below or create yours.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Course advice" width="100%"/>

## Who are we [[who-are-we]]

This course is maintained by [Ben Burtenshaw](https://huggingface.co/burtenshaw) and [Sergio Paniego](https://huggingface.co/sergiopaniego). If you have any questions, please contact us on the Hub!

## Acknowledgments

We would like to extend our gratitude to the following individuals for their invaluable contributions to this course:

- **[Joffrey Thomas](https://huggingface.co/Jofthomas)** – For writing and developing the course.
- **[Thomas Simonini](https://huggingface.co/ThomasSimonini)** – For writing and developing the course.
- **[Pedro Cuenca](https://huggingface.co/pcuenq)** – For guiding the course and providing feedback.
- **[Aymeric Roucher](https://huggingface.co/m-ric)** – For his amazing demo spaces ( decoding and final agent ) as well as his help on the smolagents parts. 
- **[Joshua Lochner](https://huggingface.co/Xenova)** – For his amazing demo space on tokenization.
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** – For his help on the course content.
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** – For his help on the course content and moderation.
- **[XiaXiao (ShawnSiao)](https://huggingface.co/SSSSSSSiao)** – Chinese translator for the course.
- **[Jiaming Huang](https://huggingface.co/nordicsushi)** – Chinese translator for the course.
- **[Kim Noel](https://github.com/knoel99)** - French translator for the course.
- **[Loïck Bourdois](https://huggingface.co/lbourdois)** - French translator for the course from [CATIE](https://www.catie.fr/).


## I found a bug, or I want to improve the course [[contribute]]

Contributions are **welcome** 🤗

- If you *found a bug 🐛 in a notebook*, please <a href="https://github.com/huggingface/agents-course/issues">open an issue</a> and **describe the problem**.
- If you *want to improve the course*, you can <a href="https://github.com/huggingface/agents-course/pulls">open a Pull Request.</a>
- If you *want to add a full section or a new unit*, the best is to <a href="https://github.com/huggingface/agents-course/issues">open an issue</a> and **describe what content you want to add before starting to write it so that we can guide you**.

## I still have questions [[questions]]

Please ask your question in our <a href="https://discord.gg/UrrTSsSyjb">discord server #agents-course-questions.</a>

Now that you have all the information, let's get on board ⛵

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Time to Onboard" width="100%"/>



<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit0/introduction.mdx" />