# What is GAIA?

[GAIA](https://huggingface.co/papers/2311.12983) is a **benchmark designed to evaluate AI assistants on real-world tasks** that require a combination of core capabilities—such as reasoning, multimodal understanding, web browsing, and proficient tool use.

It was introduced in the paper _"[GAIA: A Benchmark for General AI Assistants](https://huggingface.co/papers/2311.12983)"_.

The benchmark features **466 carefully curated questions** that are **conceptually simple for humans**, yet **remarkably challenging for current AI systems**. 

To illustrate the gap:
- **Humans**: ~92% success rate  
- **GPT-4 with plugins**: ~15%  
- **Deep Research (OpenAI)**: 67.36% on the validation set

GAIA highlights the current limitations of AI models and provides a rigorous benchmark to evaluate progress toward truly general-purpose AI assistants.

## 🌱 GAIA’s Core Principles

GAIA is carefully designed around the following pillars:

- 🔍 **Real-world difficulty**: Tasks require multi-step reasoning, multimodal understanding, and tool interaction.
- 🧾 **Human interpretability**: Despite their difficulty for AI, tasks remain conceptually simple and easy to follow for humans.
- 🛡️ **Non-gameability**: Correct answers demand full task execution, making brute-forcing ineffective.
- 🧰 **Simplicity of evaluation**: Answers are concise, factual, and unambiguous—ideal for benchmarking.

## Difficulty Levels

GAIA tasks are organized into **three levels of increasing complexity**, each testing specific skills:

- **Level 1**: Requires less than 5 steps and minimal tool usage.
- **Level 2**: Involves more complex reasoning and coordination between multiple tools and 5-10 steps.
- **Level 3**: Demands long-term planning and advanced integration of various tools.

![GAIA levels](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit4/gaia_levels.png)

## Example of a Hard GAIA Question

> Which of the fruits shown in the 2008 painting "Embroidery from Uzbekistan" were served as part of the October 1949 breakfast menu for the ocean liner that was later used as a floating prop for the film "The Last Voyage"? Give the items as a comma-separated list, ordering them in clockwise order based on their arrangement in the painting starting from the 12 o'clock position. Use the plural form of each fruit.

As you can see, this question challenges AI systems in several ways:

- Requires a **structured response format**
- Involves **multimodal reasoning** (e.g., analyzing images)
- Demands **multi-hop retrieval** of interdependent facts:
  - Identifying the fruits in the painting
  - Discovering which ocean liner was used in *The Last Voyage*
  - Looking up the breakfast menu from October 1949 for that ship
- Needs **correct sequencing** and high-level planning to solve in the right order

This kind of task highlights where standalone LLMs often fall short, making GAIA an ideal benchmark for **agent-based systems** that can reason, retrieve, and execute over multiple steps and modalities.

![GAIA capabilities plot](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit4/gaia_capabilities.png)

## Live Evaluation

To encourage continuous benchmarking, **GAIA provides a public leaderboard hosted on Hugging Face**, where you can test your models against **300 testing questions**.

👉 Check out the leaderboard [here](https://huggingface.co/spaces/gaia-benchmark/leaderboard)

<iframe
	src="https://gaia-benchmark-leaderboard.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Want to dive deeper into GAIA?

- 📄 [Read the full paper](https://huggingface.co/papers/2311.12983)
- 📄 [Deep Research release post by OpenAI](https://openai.com/index/introducing-deep-research/)
- 📄 [Open-source DeepResearch – Freeing our search agents](https://huggingface.co/blog/open-deep-research)

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit4/what-is-gaia.mdx" />