import{s as ua,a as ma,n as Ta,o as wa}from"../chunks/scheduler.505acc25.js";import{S as da,i as Ia,e as M,s as t,c as i,h as ha,a as o,d as a,b as n,f as qs,g as c,j as p,k as hl,l as Vs,m as e,n as r,t as j,o as y,p as J}from"../chunks/index.fbb49fb4.js";import{C as ba}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as m}from"../chunks/CodeBlock.2ead06c8.js";import{H as U}from"../chunks/Heading.511e0027.js";import{E as Ca}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function ga(Qs){let u,Bl,Cl,fl,w,Wl,d,Al,I,Ys="Ahora que entendemos los componentes básicos, vamos a ponerlos en práctica construyendo nuestro primer grafo funcional. Implementaremos el sistema de procesamiento de correos electrónicos de Alfred, donde necesita:",Zl,h,Ss="<li>Leer correos electrónicos entrantes</li> <li>Clasificarlos como spam o legítimos</li> <li>Redactar una respuesta preliminar para correos legítimos</li> <li>Enviar información al Sr. Wayne cuando son legítimos (solo impresión)</li>",El,b,zs="Este ejemplo demuestra cómo estructurar un flujo de trabajo con LangGraph que involucra toma de decisiones basada en LLM. Aunque esto no puede considerarse un Agente ya que no se involucra ninguna herramienta, esta sección se enfoca más en aprender el marco de trabajo de LangGraph que en Agentes.",Gl,T,bl,vs='Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/resolve/main/unit2/langgraph/mail_sorting.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.',Ns,C,Nl,g,Rs="Aquí está el flujo de trabajo que construiremos:",ql,B,ks,Vl,f,Ql,W,Fs="Primero, instalemos los paquetes necesarios:",Yl,A,Sl,Z,Xs="A continuación, importemos los módulos necesarios:",zl,E,vl,G,Rl,N,_s="Definamos qué información necesita rastrear Alfred durante el flujo de trabajo de procesamiento de correos electrónicos:",kl,q,Fl,V,$s="<p>💡 <strong>Tip:</strong> Haz que tu estado sea lo suficientemente completo para rastrear toda la información importante, pero evita sobrecargarlo con detalles innecesarios.</p>",Xl,Q,_l,Y,xs="Ahora, creemos las funciones de procesamiento que formarán nuestros nodos:",$l,S,xl,z,Hl,v,Hs="Necesitamos una función para determinar qué camino tomar después de la clasificación:",Ll,R,Dl,k,Ls="<p>💡 <strong>Nota:</strong> Esta función de enrutamiento es llamada por LangGraph para determinar qué arista(edge) seguir después del nodo de clasificación. El valor de retorno debe coincidir con una de las claves en nuestro mapeo de aristas(edges) condicionales.</p>",Pl,F,Kl,X,Ds="Ahora conectamos todo:",Ol,_,ls,$,Ps="Observa cómo usamos el nodo especial  <code>END</code> proporcionado por LangGraph. Esto indica estados terminales donde el flujo de trabajo se completa.",ss,x,as,H,Ks="Probemos nuestro grafo con un correo legítimo y un correo spam:",es,L,ts,D,ns,P,Os="Mientras Alfred perfecciona el Agente de Clasificación de Correo, se está cansando de depurar sus ejecuciones. Los agentes, por naturaleza, son impredecibles y difíciles de inspeccionar. Pero como su objetivo es construir el mejor Agente de Detección de Spam y desplegarlo en producción, necesita una trazabilidad robusta para el monitoreo y análisis futuros.",Ms,K,la='Para hacer esto, Alfred puede usar una herramienta de observabilidad como <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> para rastrear y monitorear el agente.',os,O,sa="Primero, instalamos Langfuse con pip:",ps,ll,is,sl,aa='Luego, agregamos las claves API de Langfuse y la dirección del host como variables de entorno. Puedes obtener tus credenciales de Langfuse registrándote en <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> o <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',cs,al,rs,el,ea='Luego, configuramos el <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> instrumentamos el agente añadiendo el <code>langfuse_callback</code> a la invocación del grafo: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',js,tl,ys,nl,ta="¡Alfred está ahora conectado 🔌! Las ejecuciones de LangGraph se están registrando en Langfuse, dándole visibilidad completa del comportamiento del agente. Con esta configuración, está listo para revisar ejecuciones anteriores y refinar aún más su Agente de Clasificación de Correo.",Js,Ml,na='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',Us,ol,Ma='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',ms,pl,oa="Visualizando Nuestro Grafo",us,il,pa="LangGraph nos permite visualizar nuestro flujo de trabajo para entender y depurar mejor su estructura:",Ts,cl,ws,rl,ia,ds,jl,ca="Esto produce una representación visual que muestra cómo están conectados nuestros nodos y los caminos condicionales que se pueden tomar.",Is,yl,hs,Jl,ra="Hemos creado un flujo de trabajo completo de procesamiento de correos electrónicos que:",bs,Ul,ja="<li>Toma un correo electrónico entrante</li> <li>Usa un LLM para clasificarlo como spam o legítimo</li> <li>Maneja el spam descartándolo</li> <li>Para correos legítimos, redacta una respuesta y notifica al Sr. Hugg</li>",Cs,ml,ya="Esto demuestra el poder de LangGraph para orquestar flujos de trabajo complejos con LLMs mientras mantiene un flujo claro y estructurado.",gs,ul,Bs,Tl,Ja="<li><strong>Gestión de Estado</strong>: Definimos un estado completo para rastrear todos los aspectos del procesamiento de correos electrónicos</li> <li><strong>Implementación de Nodos:</strong>: Creamos nodos funcionales que interactúan con un LLM</li> <li><strong>Enrutamiento Condicional</strong>: Implementamos lógica de ramificación basada en la clasificación de correos</li> <li><strong>Estados Terminales:</strong>: Usamos el nodo END para marcar puntos de finalización en nuestro flujo de trabajo</li>",fs,wl,Ws,dl,Ua="En la siguiente sección, exploraremos características más avanzadas de LangGraph, incluyendo el manejo de interacción humana en el flujo de trabajo y la implementación de lógica de ramificación más compleja basada en múltiples condiciones.",As,Il,Zs,gl,Es;return w=new ba({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new U({props:{title:"Construyendo Tu Primer LangGraph",local:"construyendo-tu-primer-langgraph",headingTag:"h1"}}),C=new U({props:{title:"Nuestro Flujo de Trabajo",local:"nuestro-flujo-de-trabajo",headingTag:"h2"}}),f=new U({props:{title:"Configurando Nuestro Entorno",local:"configurando-nuestro-entorno",headingTag:"h2"}}),A=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),E=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwRU5EJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTJDJTIwQUlNZXNzYWdl",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage, AIMessage`,wrap:!1}}),G=new U({props:{title:"Paso 1: Definir Nuestro Estado",local:"paso-1-definir-nuestro-estado",headingTag:"h2"}}),q=new m({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFbCUyMGNvcnJlbyUyMGVsZWN0ciVDMyVCM25pY28lMjBxdWUlMjBzZSUyMGVzdCVDMyVBMSUyMHByb2Nlc2FuZG8lMEElMjAlMjAlMjAlMjBlbWFpbCUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjAlMjAlMjMlMjBDb250aWVuZSUyMGFzdW50byUyQyUyMHJlbWl0ZW50ZSUyQyUyMGN1ZXJwbyUyQyUyMGV0Yy4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBBbiVDMyVBMWxpc2lzJTIweSUyMGRlY2lzaW9uZXMlMEElMjAlMjAlMjAlMjBpc19zcGFtJTNBJTIwT3B0aW9uYWwlNUJib29sJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2VuZXJhY2klQzMlQjNuJTIwZGUlMjByZXNwdWVzdGElMEElMjAlMjAlMjAlMjBkcmFmdF9yZXNwb25zZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwTWV0YWRhdG9zJTIwZGUlMjBwcm9jZXNhbWllbnRvJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBMaXN0JTVCRGljdCU1QnN0ciUyQyUyMEFueSU1RCU1RCUyMCUyMCUyMyUyMFJhc3RyZWElMjBsYSUyMGNvbnZlcnNhY2klQzMlQjNuJTIwY29uJTIwTExNJTIwcGFyYSUyMGFuJUMzJUExbGlzaXM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># El correo electrónico que se está procesando</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contiene asunto, remitente, cuerpo, etc.</span>
    
    <span class="hljs-comment"># Análisis y decisiones</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Generación de respuesta</span>
    draft_response: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Metadatos de procesamiento</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Rastrea la conversación con LLM para análisis</span>`,wrap:!1}}),Q=new U({props:{title:"Paso 2: Definir Nuestros Nodos",local:"paso-2-definir-nuestros-nodos",headingTag:"h2"}}),S=new m({props:{code:"JTIzJTIwSW5pY2lhbGl6YXIlMjBudWVzdHJvJTIwTExNJTBBbW9kZWwlMjAlM0QlMjBDaGF0T3BlbkFJKHRlbXBlcmF0dXJlJTNEMCklMEElMEFkZWYlMjByZWFkX2VtYWlsKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBsZWUlMjB5JTIwcmVnaXN0cmElMjBlbCUyMGNvcnJlbyUyMGVsZWN0ciVDMyVCM25pY28lMjBlbnRyYW50ZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEFxdSVDMyVBRCUyMHBvZHIlQzMlQURhbW9zJTIwaGFjZXIlMjBhbGclQzMlQkFuJTIwcHJlcHJvY2VzYW1pZW50byUyMGluaWNpYWwlMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxmcmVkJTIwZXN0JUMzJUExJTIwcHJvY2VzYW5kbyUyMHVuJTIwY29ycmVvJTIwZWxlY3RyJUMzJUIzbmljbyUyMGRlJTIwJTdCZW1haWwlNUInc2VuZGVyJyU1RCU3RCUyMGNvbiUyMGFzdW50byUzQSUyMCU3QmVtYWlsJTVCJ3N1YmplY3QnJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME5vJTIwc2UlMjBuZWNlc2l0YW4lMjBjYW1iaW9zJTIwZGUlMjBlc3RhZG8lMjBhcXUlQzMlQUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0QlMEElMEFkZWYlMjBjbGFzc2lmeV9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwdXNhJTIwdW4lMjBMTE0lMjBwYXJhJTIwZGV0ZXJtaW5hciUyMHNpJTIwZWwlMjBjb3JyZW8lMjBlcyUyMHNwYW0lMjBvJTIwbGVnJUMzJUFEdGltbyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMFByZXBhcmFyJTIwbnVlc3RybyUyMHByb21wdCUyMHBhcmElMjBlbCUyMExMTSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBDb21vJTIwQWxmcmVkJTIwZWwlMjBtYXlvcmRvbW8lMkMlMjBhbmFsaXphJTIwZXN0ZSUyMGNvcnJlbyUyMGVsZWN0ciVDMyVCM25pY28lMjB5JTIwZGV0ZXJtaW5hJTIwc2klMjBlcyUyMHNwYW0lMjBvJTIwbGVnJUMzJUFEdGltby4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBFbWFpbCUzQSUwQSUyMCUyMCUyMCUyMERlJTNBJTIwJTIwJTdCZW1haWwlNUInc2VuZGVyJyU1RCU3RCUwQSUyMCUyMCUyMCUyMEFzdW50byUzQSUyMCU3QmVtYWlsJTVCJ3N1YmplY3QnJTVEJTdEJTBBJTIwJTIwJTIwJTIwQm9keSUzQSUyMCU3QmVtYWlsJTVCJ2JvZHknJTVEJTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwUHJpbWVybyUyQyUyMGRldGVybWluYSUyMHNpJTIwZXN0ZSUyMGNvcnJlbyUyMGVzJTIwc3BhbS4lMjBTaSUyMGVzJTIwc3BhbSUyQyUyMGV4cGxpY2ElMjBwb3IlMjBxdSVDMyVBOS4lMEElMjAlMjAlMjAlMjBTaSUyMGVzJTIwbGVnJUMzJUFEdGltbyUyQyUyMGNhdGVnb3IlQzMlQUR6YWxvJTIwKGNvbnN1bHRhJTJDJTIwcXVlamElMkMlMjBhZ3JhZGVjaW1pZW50byUyQyUyMGV0Yy4pLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMExsYW1hciUyMGFsJTIwTExNJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRHByb21wdCklNUQlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMG1vZGVsLmludm9rZShtZXNzYWdlcyklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBMJUMzJUIzZ2ljYSUyMHNpbXBsZSUyMHBhcmElMjBhbmFsaXphciUyMGxhJTIwcmVzcHVlc3RhJTIwKGVuJTIwdW5hJTIwYXBsaWNhY2klQzMlQjNuJTIwcmVhbCUyQyUyMHF1ZXJyJUMzJUFEYXMlMjB1biUyMGFuJUMzJUExbGlzaXMlMjBtJUMzJUExcyUyMHJvYnVzdG8pJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2VfdGV4dCUyMCUzRCUyMHJlc3BvbnNlLmNvbnRlbnQubG93ZXIoKSUwQSUyMCUyMCUyMCUyMGlzX3NwYW0lMjAlM0QlMjAlMjJzcGFtJTIyJTIwaW4lMjByZXNwb25zZV90ZXh0JTIwYW5kJTIwJTIybm90JTIwc3BhbSUyMiUyMG5vdCUyMGluJTIwcmVzcG9uc2VfdGV4dCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhZXIlMjB1bmElMjByYXolQzMlQjNuJTIwc2klMjBlcyUyMHNwYW0lMEElMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBpZiUyMGlzX3NwYW0lMjBhbmQlMjAlMjJyZWFzb24lM0ElMjIlMjBpbiUyMHJlc3BvbnNlX3RleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyMHJlc3BvbnNlX3RleHQuc3BsaXQoJTIycmVhc29uJTNBJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMERldGVybWluYXIlMjBjYXRlZ29yJUMzJUFEYSUyMHNpJTIwZXMlMjBsZWclQzMlQUR0aW1vJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc19zcGFtJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcmllcyUyMCUzRCUyMCU1QiUyMmNvbnN1bHRhJTIyJTJDJTIwJTIycXVlamElMjIlMkMlMjAlMjJhZ3JhZGVjaW1pZW50byUyMiUyQyUyMCUyMnNvbGljaXR1ZCUyMiUyQyUyMCUyMmluZm9ybWFjaSVDMyVCM24lMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBjYXRlZ29yeSUyMGluJTIwY2F0ZWdvcmllcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwY2F0ZWdvcnklMjBpbiUyMHJlc3BvbnNlX3RleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWFpbF9jYXRlZ29yeSUyMCUzRCUyMGNhdGVnb3J5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBBY3R1YWxpemFyJTIwbWVuc2FqZXMlMjBwYXJhJTIwc2VndWltaWVudG8lMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVncmVzYXIlMjBhY3R1YWxpemFjaW9uZXMlMjBkZSUyMGVzdGFkbyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzX3NwYW0lMjIlM0ElMjBpc19zcGFtJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3BhbV9yZWFzb24lMjIlM0ElMjBzcGFtX3JlYXNvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVtYWlsX2NhdGVnb3J5JTIyJTNBJTIwZW1haWxfY2F0ZWdvcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMG5ld19tZXNzYWdlcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQWRlZiUyMGhhbmRsZV9zcGFtKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBkZXNjYXJ0YSUyMGVsJTIwY29ycmVvJTIwc3BhbSUyMGNvbiUyMHVuYSUyMG5vdGElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxmcmVkJTIwaGElMjBtYXJjYWRvJTIwZWwlMjBjb3JyZW8lMjBjb21vJTIwc3BhbS4lMjBSYXolQzMlQjNuJTNBJTIwJTdCc3RhdGUlNUInc3BhbV9yZWFzb24nJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkVsJTIwY29ycmVvJTIwaGElMjBzaWRvJTIwbW92aWRvJTIwYSUyMGxhJTIwY2FycGV0YSUyMGRlJTIwc3BhbS4lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwSGVtb3MlMjB0ZXJtaW5hZG8lMjBkZSUyMHByb2Nlc2FyJTIwZXN0ZSUyMGNvcnJlbyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQWRlZiUyMGRyYWZ0X3Jlc3BvbnNlKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjByZWRhY3RhJTIwdW5hJTIwcmVzcHVlc3RhJTIwcHJlbGltaW5hciUyMHBhcmElMjBjb3JyZW9zJTIwbGVnJUMzJUFEdGltb3MlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBlbWFpbCUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWwlMjIlNUQlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWxfY2F0ZWdvcnklMjIlNUQlMjBvciUyMCUyMmdlbmVyYWwlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjMlMjBQcmVwYXJhciUyMG51ZXN0cm8lMjBwcm9tcHQlMjBwYXJhJTIwZWwlMjBMTE0lMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQ29tbyUyMEFsZnJlZCUyMGVsJTIwbWF5b3Jkb21vJTJDJTIwcmVkYWN0YSUyMHVuYSUyMHJlc3B1ZXN0YSUyMHByZWxpbWluYXIlMjBjb3J0JUMzJUE5cyUyMGElMjBlc3RlJTIwY29ycmVvLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjBzdGUlMjBjb3JyZW8lMjBoYSUyMHNpZG8lMjBjYXRlZ29yaXphZG8lMjBjb21vJTNBJTIwJTdCY2F0ZWdvcnklN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBSZWRhY3RhJTIwdW5hJTIwcmVzcHVlc3RhJTIwYnJldmUlMjB5JTIwcHJvZmVzaW9uYWwlMjBxdWUlMjBlbCUyMFNyLiUyMEh1Z2clMjBwdWVkYSUyMHJldmlzYXIlMjB5JTIwcGVyc29uYWxpemFyJTIwYW50ZXMlMjBkZSUyMGVudmlhci4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBMbGFtYXIlMjBhbCUyMExMTSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCSHVtYW5NZXNzYWdlKGNvbnRlbnQlM0Rwcm9tcHQpJTVEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5pbnZva2UobWVzc2FnZXMpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQWN0dWFsaXphciUyMG1lbnNhamVzJTIwcGFyYSUyMHNlZ3VpbWllbnRvJTBBJTIwJTIwJTIwJTIwbmV3X21lc3NhZ2VzJTIwJTNEJTIwc3RhdGUuZ2V0KCUyMm1lc3NhZ2VzJTIyJTJDJTIwJTVCJTVEKSUyMCUyQiUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHByb21wdCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcmVzcG9uc2UuY29udGVudCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMFJlZ3Jlc2FyJTIwYWN0dWFsaXphY2lvbmVzJTIwZGUlMjBlc3RhZG8lMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyMHJlc3BvbnNlLmNvbnRlbnQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMG5ld19tZXNzYWdlcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQWRlZiUyMG5vdGlmeV9tcl9odWdnKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBub3RpZmljYSUyMGFsJTIwU3IuJTIwSHVnZyUyMHNvYnJlJTIwZWwlMjBjb3JyZW8lMjB5JTIwcHJlc2VudGElMjBlbCUyMGJvcnJhZG9yJTIwZGUlMjByZXNwdWVzdGElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBlbWFpbCUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWwlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuJTIyJTIwJTJCJTIwJTIyJTNEJTIyKjUwKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTZSVDMyVCMW9yJTJDJTIwaGElMjByZWNpYmlkbyUyMHVuJTIwY29ycmVvJTIwZWxlY3RyJUMzJUIzbmljbyUyMGRlJTIwJTdCZW1haWwlNUInc2VuZGVyJyU1RCU3RC4lMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlN1YmplY3QlM0ElMjAlN0JlbWFpbCU1QidzdWJqZWN0JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyQ2F0ZWdvciVDMyVBRGElM0ElMjAlN0JzdGF0ZSU1QidlbWFpbF9jYXRlZ29yeSclNUQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTVDbkhlJTIwcHJlcGFyYWRvJTIwdW4lMjBib3JyYWRvciUyMGRlJTIwcmVzcHVlc3RhJTIwcGFyYSUyMHN1JTIwcmV2aXNpJUMzJUIzbiUzQSUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjItJTIyKjUwKSUwQSUyMCUyMCUyMCUyMHByaW50KHN0YXRlJTVCJTIyZHJhZnRfcmVzcG9uc2UlMjIlNUQpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTNEJTIyKjUwJTIwJTJCJTIwJTIyJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBIZW1vcyUyMHRlcm1pbmFkbyUyMGRlJTIwcHJvY2VzYXIlMjBlc3RlJTIwY29ycmVvJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTdE",highlighted:`<span class="hljs-comment"># Inicializar nuestro LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred lee y registra el correo electrónico entrante&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Aquí podríamos hacer algún preprocesamiento inicial</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred está procesando un correo electrónico de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> con asunto: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No se necesitan cambios de estado aquí</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred usa un LLM para determinar si el correo es spam o legítimo&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
     <span class="hljs-comment"># Preparar nuestro prompt para el LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Como Alfred el mayordomo, analiza este correo electrónico y determina si es spam o legítimo.
    
    Email:
    De:  <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Asunto: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    Primero, determina si este correo es spam. Si es spam, explica por qué.
    Si es legítimo, categorízalo (consulta, queja, agradecimiento, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Llamar al LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Lógica simple para analizar la respuesta (en una aplicación real, querrías un análisis más robusto)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extraer una razón si es spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determinar categoría si es legítimo</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;consulta&quot;</span>, <span class="hljs-string">&quot;queja&quot;</span>, <span class="hljs-string">&quot;agradecimiento&quot;</span>, <span class="hljs-string">&quot;solicitud&quot;</span>, <span class="hljs-string">&quot;información&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Actualizar mensajes para seguimiento</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
     <span class="hljs-comment"># Regresar actualizaciones de estado</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred descarta el correo spam con una nota&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred ha marcado el correo como spam. Razón: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;El correo ha sido movido a la carpeta de spam.&quot;</span>)
    
    <span class="hljs-comment"># Hemos terminado de procesar este correo</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred redacta una respuesta preliminar para correos legítimos&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
   <span class="hljs-comment"># Preparar nuestro prompt para el LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Como Alfred el mayordomo, redacta una respuesta preliminar cortés a este correo.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
     ste correo ha sido categorizado como: <span class="hljs-subst">{category}</span>
    
    Redacta una respuesta breve y profesional que el Sr. Hugg pueda revisar y personalizar antes de enviar.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Llamar al LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Actualizar mensajes para seguimiento</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
     <span class="hljs-comment"># Regresar actualizaciones de estado</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;draft_response&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifica al Sr. Hugg sobre el correo y presenta el borrador de respuesta&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Señor, ha recibido un correo electrónico de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Categoría: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nHe preparado un borrador de respuesta para su revisión:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;draft_response&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># Hemos terminado de procesar este correo</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),z=new U({props:{title:"Paso 3: Definir Nuestra Lógica de Enrutamiento",local:"paso-3-definir-nuestra-lógica-de-enrutamiento",headingTag:"h2"}}),R=new m({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmFyJTIwZWwlMjBzaWd1aWVudGUlMjBwYXNvJTIwYmFzYWRvJTIwZW4lMjBsYSUyMGNsYXNpZmljYWNpJUMzJUIzbiUyMGRlJTIwc3BhbSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGUlNUIlMjJpc19zcGFtJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyc3BhbSUyMiUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJsZWdpdGltYXRlJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determinar el siguiente paso basado en la clasificación de spam&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),F=new U({props:{title:"Paso 4: Crear el StateGraph y Definir Aristas(Edges)",local:"paso-4-crear-el-stategraph-y-definir-aristasedges",headingTag:"h2"}}),_=new m({props:{code:"JTIzJTIwQ3JlYXIlMjBlbCUyMGdyYWZvJTBBZW1haWxfZ3JhcGglMjAlM0QlMjBTdGF0ZUdyYXBoKEVtYWlsU3RhdGUpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBub2RvcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBhcmlzdGFzKGVkZ2VzKSUyMC0lMjBkZWZpbmllbmRvJTIwZWwlMjBmbHVqbyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjAlMjJjbGFzc2lmeV9lbWFpbCUyMiklMEElMEElMjMlMjBBJUMzJUIxYWRpciUyMHJhbWlmaWNhY2klQzMlQjNuJTIwY29uZGljaW9uYWwlMjBkZXNkZSUyMGNsYXNzaWZ5X2VtYWlsJTBBZW1haWxfZ3JhcGguYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVfZW1haWwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtJTIyJTNBJTIwJTIyaGFuZGxlX3NwYW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWdpdGltYXRlJTIyJTNBJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBsYXMlMjBhcmlzdGFzKGVkZ2VzKSUyMGZpbmFsZXMlMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJoYW5kbGVfc3BhbSUyMiUyQyUyMEVORCklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMCUyMm5vdGlmeV9tcl9odWdnJTIyKSUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMENvbXBpbGFyJTIwZWwlMjBncmFmbyUwQWNvbXBpbGVkX2dyYXBoJTIwJTNEJTIwZW1haWxfZ3JhcGguY29tcGlsZSgp",highlighted:`<span class="hljs-comment"># Crear el grafo</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Añadir nodos</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Añadir aristas(edges) - definiendo el flujo</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Añadir ramificación condicional desde classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Añadir las aristas(edges) finales</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compilar el grafo</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),x=new U({props:{title:"Paso 5: Ejecutar la Aplicación",local:"paso-5-ejecutar-la-aplicación",headingTag:"h2"}}),L=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Ejemplo de correo legítimo</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Pregunta sobre sus servicios&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Estimado Sr. Hugg, un colega me recomendó contactarle y estoy interesado en conocer más sobre sus servicios de consultoría. ¿Podríamos programar una llamada la próxima semana? Saludos cordiales, John Smith&quot;</span>
}

<span class="hljs-comment"># Ejemplo de correo spam</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: ¡¡¡HAS GANADO $<span class="hljs-number">5</span>,<span class="hljs-number">000</span>,<span class="hljs-number">000</span>!!!<span class="hljs-string">&quot;,
    &quot;</span>body<span class="hljs-string">&quot;: &quot;</span>¡FELICIDADES! ¡Has sido seleccionado como el ganador de nuestra lotería internacional! Para reclamar tu premio de $<span class="hljs-number">5</span>,<span class="hljs-number">000</span>,<span class="hljs-number">000</span>, por favor envíanos tus datos bancarios y una tarifa de procesamiento de $<span class="hljs-number">100.</span><span class="hljs-string">&quot;
}

# Procesar el correo legítimo
print(&quot;</span>\\nProcesando correo legítimo...<span class="hljs-string">&quot;)
legitimate_result = compiled_graph.invoke({
    &quot;</span>email<span class="hljs-string">&quot;: legitimate_email,
    &quot;</span>is_spam<span class="hljs-string">&quot;: None,
    &quot;</span>spam_reason<span class="hljs-string">&quot;: None,
    &quot;</span>email_category<span class="hljs-string">&quot;: None,
    &quot;</span>draft_response<span class="hljs-string">&quot;: None,
    &quot;</span>messages<span class="hljs-string">&quot;: []
})

# Procesar el correo spam
print(&quot;</span>\\nProcesando correo spam...<span class="hljs-string">&quot;)
spam_result = compiled_graph.invoke({
    &quot;</span>email<span class="hljs-string">&quot;: spam_email,
    &quot;</span>is_spam<span class="hljs-string">&quot;: None,
    &quot;</span>spam_reason<span class="hljs-string">&quot;: None,
    &quot;</span>email_category<span class="hljs-string">&quot;: None,
    &quot;</span>draft_response<span class="hljs-string">&quot;: None,
    &quot;</span>messages<span class="hljs-string">&quot;: []
})</span>`,wrap:!1}}),D=new U({props:{title:"Paso 6: Inspeccionando Nuestro Agente de Clasificación de Correo con Langfuse 📡",local:"paso-6-inspeccionando-nuestro-agente-de-clasificación-de-correo-con-langfuse-",headingTag:"h2"}}),ll=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),al=new m({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBPYnQlQzMlQTluJTIwbGFzJTIwY2xhdmVzJTIwcGFyYSUyMHR1JTIwcHJveWVjdG8lMjBkZXNkZSUyMGxhJTIwcCVDMyVBMWdpbmElMjBkZSUyMGNvbmZpZ3VyYWNpJUMzJUIzbiUyMGRlbCUyMHByb3llY3RvJTNBJTIwaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfUFVCTElDX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnBrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9TRUNSRVRfS0VZJTIyJTVEJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMHJlZ2klQzMlQjNuJTIwZGUlMjBsYSUyMFVFJTBBJTIzJTIwb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVzLmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMyUyMCVGMCU5RiU4NyVCQSVGMCU5RiU4NyVCOCUyMHJlZ2klQzMlQjNuJTIwZGUlMjBFRS5V",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Obtén las claves para tu proyecto desde la página de configuración del proyecto: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 región de la UE</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 región de EE.U</span>`,wrap:!1}}),tl=new m({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmNhbGxiYWNrJTIwaW1wb3J0JTIwQ2FsbGJhY2tIYW5kbGVyJTBBJTBBJTIzJTIwSW5pY2lhbGl6YXIlMjBDYWxsYmFja0hhbmRsZXIlMjBkZSUyMExhbmdmdXNlJTIwcGFyYSUyMExhbmdHcmFwaCUyRkxhbmdjaGFpbiUyMCh0cmF6YWRvKSUwQWxhbmdmdXNlX2hhbmRsZXIlMjAlM0QlMjBDYWxsYmFja0hhbmRsZXIoKSUwQSUwQSUyMyUyMFByb2Nlc2FyJTIwY29ycmVvJTIwbGVnJUMzJUFEdGltbyUwQWxlZ2l0aW1hdGVfcmVzdWx0JTIwJTNEJTIwY29tcGlsZWRfZ3JhcGguaW52b2tlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTNEJTdCJTIyZW1haWwlMjIlM0ElMjBsZWdpdGltYXRlX2VtYWlsJTJDJTIwJTIyaXNfc3BhbSUyMiUzQSUyME5vbmUlMkMlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyME5vbmUlMkMlMjAlMjJlbWFpbF9jYXRlZ29yeSUyMiUzQSUyME5vbmUlMkMlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyME5vbmUlMkMlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRCU3QiUyMmNhbGxiYWNrcyUyMiUzQSUyMCU1QmxhbmdmdXNlX2hhbmRsZXIlNUQlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse.callback <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Inicializar CallbackHandler de Langfuse para LangGraph/Langchain (trazado)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Procesar correo legítimo</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),cl=new m({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),yl=new U({props:{title:"Lo Que Hemos Construido",local:"lo-que-hemos-construido",headingTag:"h2"}}),ul=new U({props:{title:"Puntos Clave",local:"puntos-clave",headingTag:"h2"}}),wl=new U({props:{title:"¿Qué Sigue?",local:"qué-sigue",headingTag:"h2"}}),Il=new Ca({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/first_graph.mdx"}}),{c(){u=M("meta"),Bl=t(),Cl=M("p"),fl=t(),i(w.$$.fragment),Wl=t(),i(d.$$.fragment),Al=t(),I=M("p"),I.textContent=Ys,Zl=t(),h=M("ol"),h.innerHTML=Ss,El=t(),b=M("p"),b.textContent=zs,Gl=t(),T=M("blockquote"),bl=M("p"),bl.innerHTML=vs,Ns=t(),i(C.$$.fragment),Nl=t(),g=M("p"),g.textContent=Rs,ql=t(),B=M("img"),Vl=t(),i(f.$$.fragment),Ql=t(),W=M("p"),W.textContent=Fs,Yl=t(),i(A.$$.fragment),Sl=t(),Z=M("p"),Z.textContent=Xs,zl=t(),i(E.$$.fragment),vl=t(),i(G.$$.fragment),Rl=t(),N=M("p"),N.textContent=_s,kl=t(),i(q.$$.fragment),Fl=t(),V=M("blockquote"),V.innerHTML=$s,Xl=t(),i(Q.$$.fragment),_l=t(),Y=M("p"),Y.textContent=xs,$l=t(),i(S.$$.fragment),xl=t(),i(z.$$.fragment),Hl=t(),v=M("p"),v.textContent=Hs,Ll=t(),i(R.$$.fragment),Dl=t(),k=M("blockquote"),k.innerHTML=Ls,Pl=t(),i(F.$$.fragment),Kl=t(),X=M("p"),X.textContent=Ds,Ol=t(),i(_.$$.fragment),ls=t(),$=M("p"),$.innerHTML=Ps,ss=t(),i(x.$$.fragment),as=t(),H=M("p"),H.textContent=Ks,es=t(),i(L.$$.fragment),ts=t(),i(D.$$.fragment),ns=t(),P=M("p"),P.textContent=Os,Ms=t(),K=M("p"),K.innerHTML=la,os=t(),O=M("p"),O.textContent=sa,ps=t(),i(ll.$$.fragment),is=t(),sl=M("p"),sl.innerHTML=aa,cs=t(),i(al.$$.fragment),rs=t(),el=M("p"),el.innerHTML=ea,js=t(),i(tl.$$.fragment),ys=t(),nl=M("p"),nl.textContent=ta,Js=t(),Ml=M("p"),Ml.innerHTML=na,Us=t(),ol=M("p"),ol.innerHTML=Ma,ms=t(),pl=M("p"),pl.textContent=oa,us=t(),il=M("p"),il.textContent=pa,Ts=t(),i(cl.$$.fragment),ws=t(),rl=M("img"),ds=t(),jl=M("p"),jl.textContent=ca,Is=t(),i(yl.$$.fragment),hs=t(),Jl=M("p"),Jl.textContent=ra,bs=t(),Ul=M("ol"),Ul.innerHTML=ja,Cs=t(),ml=M("p"),ml.textContent=ya,gs=t(),i(ul.$$.fragment),Bs=t(),Tl=M("ul"),Tl.innerHTML=Ja,fs=t(),i(wl.$$.fragment),Ws=t(),dl=M("p"),dl.textContent=Ua,As=t(),i(Il.$$.fragment),Zs=t(),gl=M("p"),this.h()},l(l){const s=ha("svelte-u9bgzb",document.head);u=o(s,"META",{name:!0,content:!0}),s.forEach(a),Bl=n(l),Cl=o(l,"P",{}),qs(Cl).forEach(a),fl=n(l),c(w.$$.fragment,l),Wl=n(l),c(d.$$.fragment,l),Al=n(l),I=o(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-doeu2a"&&(I.textContent=Ys),Zl=n(l),h=o(l,"OL",{"data-svelte-h":!0}),p(h)!=="svelte-18e50hn"&&(h.innerHTML=Ss),El=n(l),b=o(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1rwed3n"&&(b.textContent=zs),Gl=n(l),T=o(l,"BLOCKQUOTE",{class:!0});var Gs=qs(T);bl=o(Gs,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-1e6stzx"&&(bl.innerHTML=vs),Ns=n(Gs),c(C.$$.fragment,Gs),Gs.forEach(a),Nl=n(l),g=o(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-8xoej8"&&(g.textContent=Rs),ql=n(l),B=o(l,"IMG",{src:!0,alt:!0}),Vl=n(l),c(f.$$.fragment,l),Ql=n(l),W=o(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1tpjtub"&&(W.textContent=Fs),Yl=n(l),c(A.$$.fragment,l),Sl=n(l),Z=o(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1khiaor"&&(Z.textContent=Xs),zl=n(l),c(E.$$.fragment,l),vl=n(l),c(G.$$.fragment,l),Rl=n(l),N=o(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1tph6bi"&&(N.textContent=_s),kl=n(l),c(q.$$.fragment,l),Fl=n(l),V=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(V)!=="svelte-19va48"&&(V.innerHTML=$s),Xl=n(l),c(Q.$$.fragment,l),_l=n(l),Y=o(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-wfblmo"&&(Y.textContent=xs),$l=n(l),c(S.$$.fragment,l),xl=n(l),c(z.$$.fragment,l),Hl=n(l),v=o(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-jowye"&&(v.textContent=Hs),Ll=n(l),c(R.$$.fragment,l),Dl=n(l),k=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(k)!=="svelte-1jznpp5"&&(k.innerHTML=Ls),Pl=n(l),c(F.$$.fragment,l),Kl=n(l),X=o(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1u3rwx9"&&(X.textContent=Ds),Ol=n(l),c(_.$$.fragment,l),ls=n(l),$=o(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1panad1"&&($.innerHTML=Ps),ss=n(l),c(x.$$.fragment,l),as=n(l),H=o(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-19tq2o0"&&(H.textContent=Ks),es=n(l),c(L.$$.fragment,l),ts=n(l),c(D.$$.fragment,l),ns=n(l),P=o(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1qbfxk3"&&(P.textContent=Os),Ms=n(l),K=o(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-pa0rsu"&&(K.innerHTML=la),os=n(l),O=o(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1mkf60j"&&(O.textContent=sa),ps=n(l),c(ll.$$.fragment,l),is=n(l),sl=o(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1tnragj"&&(sl.innerHTML=aa),cs=n(l),c(al.$$.fragment,l),rs=n(l),el=o(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-jls7vc"&&(el.innerHTML=ea),js=n(l),c(tl.$$.fragment,l),ys=n(l),nl=o(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-nazjpc"&&(nl.textContent=ta),Js=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-3rgcl6"&&(Ml.innerHTML=na),Us=n(l),ol=o(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1kmw2a1"&&(ol.innerHTML=Ma),ms=n(l),pl=o(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-12rx4fm"&&(pl.textContent=oa),us=n(l),il=o(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-fg4lxm"&&(il.textContent=pa),Ts=n(l),c(cl.$$.fragment,l),ws=n(l),rl=o(l,"IMG",{src:!0,alt:!0}),ds=n(l),jl=o(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-pjb0mq"&&(jl.textContent=ca),Is=n(l),c(yl.$$.fragment,l),hs=n(l),Jl=o(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-bkdtjn"&&(Jl.textContent=ra),bs=n(l),Ul=o(l,"OL",{"data-svelte-h":!0}),p(Ul)!=="svelte-17og569"&&(Ul.innerHTML=ja),Cs=n(l),ml=o(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-ntcgtk"&&(ml.textContent=ya),gs=n(l),c(ul.$$.fragment,l),Bs=n(l),Tl=o(l,"UL",{"data-svelte-h":!0}),p(Tl)!=="svelte-1wjpek5"&&(Tl.innerHTML=Ja),fs=n(l),c(wl.$$.fragment,l),Ws=n(l),dl=o(l,"P",{"data-svelte-h":!0}),p(dl)!=="svelte-1fk3r9z"&&(dl.textContent=Ua),As=n(l),c(Il.$$.fragment,l),Zs=n(l),gl=o(l,"P",{}),qs(gl).forEach(a),this.h()},h(){hl(u,"name","hf:doc:metadata"),hl(u,"content",Ba),hl(T,"class","tip"),ma(B.src,ks="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||hl(B,"src",ks),hl(B,"alt","First LangGraph"),ma(rl.src,ia="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||hl(rl,"src",ia),hl(rl,"alt","Mail LangGraph")},m(l,s){Vs(document.head,u),e(l,Bl,s),e(l,Cl,s),e(l,fl,s),r(w,l,s),e(l,Wl,s),r(d,l,s),e(l,Al,s),e(l,I,s),e(l,Zl,s),e(l,h,s),e(l,El,s),e(l,b,s),e(l,Gl,s),e(l,T,s),Vs(T,bl),Vs(T,Ns),r(C,T,null),e(l,Nl,s),e(l,g,s),e(l,ql,s),e(l,B,s),e(l,Vl,s),r(f,l,s),e(l,Ql,s),e(l,W,s),e(l,Yl,s),r(A,l,s),e(l,Sl,s),e(l,Z,s),e(l,zl,s),r(E,l,s),e(l,vl,s),r(G,l,s),e(l,Rl,s),e(l,N,s),e(l,kl,s),r(q,l,s),e(l,Fl,s),e(l,V,s),e(l,Xl,s),r(Q,l,s),e(l,_l,s),e(l,Y,s),e(l,$l,s),r(S,l,s),e(l,xl,s),r(z,l,s),e(l,Hl,s),e(l,v,s),e(l,Ll,s),r(R,l,s),e(l,Dl,s),e(l,k,s),e(l,Pl,s),r(F,l,s),e(l,Kl,s),e(l,X,s),e(l,Ol,s),r(_,l,s),e(l,ls,s),e(l,$,s),e(l,ss,s),r(x,l,s),e(l,as,s),e(l,H,s),e(l,es,s),r(L,l,s),e(l,ts,s),r(D,l,s),e(l,ns,s),e(l,P,s),e(l,Ms,s),e(l,K,s),e(l,os,s),e(l,O,s),e(l,ps,s),r(ll,l,s),e(l,is,s),e(l,sl,s),e(l,cs,s),r(al,l,s),e(l,rs,s),e(l,el,s),e(l,js,s),r(tl,l,s),e(l,ys,s),e(l,nl,s),e(l,Js,s),e(l,Ml,s),e(l,Us,s),e(l,ol,s),e(l,ms,s),e(l,pl,s),e(l,us,s),e(l,il,s),e(l,Ts,s),r(cl,l,s),e(l,ws,s),e(l,rl,s),e(l,ds,s),e(l,jl,s),e(l,Is,s),r(yl,l,s),e(l,hs,s),e(l,Jl,s),e(l,bs,s),e(l,Ul,s),e(l,Cs,s),e(l,ml,s),e(l,gs,s),r(ul,l,s),e(l,Bs,s),e(l,Tl,s),e(l,fs,s),r(wl,l,s),e(l,Ws,s),e(l,dl,s),e(l,As,s),r(Il,l,s),e(l,Zs,s),e(l,gl,s),Es=!0},p:Ta,i(l){Es||(j(w.$$.fragment,l),j(d.$$.fragment,l),j(C.$$.fragment,l),j(f.$$.fragment,l),j(A.$$.fragment,l),j(E.$$.fragment,l),j(G.$$.fragment,l),j(q.$$.fragment,l),j(Q.$$.fragment,l),j(S.$$.fragment,l),j(z.$$.fragment,l),j(R.$$.fragment,l),j(F.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(L.$$.fragment,l),j(D.$$.fragment,l),j(ll.$$.fragment,l),j(al.$$.fragment,l),j(tl.$$.fragment,l),j(cl.$$.fragment,l),j(yl.$$.fragment,l),j(ul.$$.fragment,l),j(wl.$$.fragment,l),j(Il.$$.fragment,l),Es=!0)},o(l){y(w.$$.fragment,l),y(d.$$.fragment,l),y(C.$$.fragment,l),y(f.$$.fragment,l),y(A.$$.fragment,l),y(E.$$.fragment,l),y(G.$$.fragment,l),y(q.$$.fragment,l),y(Q.$$.fragment,l),y(S.$$.fragment,l),y(z.$$.fragment,l),y(R.$$.fragment,l),y(F.$$.fragment,l),y(_.$$.fragment,l),y(x.$$.fragment,l),y(L.$$.fragment,l),y(D.$$.fragment,l),y(ll.$$.fragment,l),y(al.$$.fragment,l),y(tl.$$.fragment,l),y(cl.$$.fragment,l),y(yl.$$.fragment,l),y(ul.$$.fragment,l),y(wl.$$.fragment,l),y(Il.$$.fragment,l),Es=!1},d(l){l&&(a(Bl),a(Cl),a(fl),a(Wl),a(Al),a(I),a(Zl),a(h),a(El),a(b),a(Gl),a(T),a(Nl),a(g),a(ql),a(B),a(Vl),a(Ql),a(W),a(Yl),a(Sl),a(Z),a(zl),a(vl),a(Rl),a(N),a(kl),a(Fl),a(V),a(Xl),a(_l),a(Y),a($l),a(xl),a(Hl),a(v),a(Ll),a(Dl),a(k),a(Pl),a(Kl),a(X),a(Ol),a(ls),a($),a(ss),a(as),a(H),a(es),a(ts),a(ns),a(P),a(Ms),a(K),a(os),a(O),a(ps),a(is),a(sl),a(cs),a(rs),a(el),a(js),a(ys),a(nl),a(Js),a(Ml),a(Us),a(ol),a(ms),a(pl),a(us),a(il),a(Ts),a(ws),a(rl),a(ds),a(jl),a(Is),a(hs),a(Jl),a(bs),a(Ul),a(Cs),a(ml),a(gs),a(Bs),a(Tl),a(fs),a(Ws),a(dl),a(As),a(Zs),a(gl)),a(u),J(w,l),J(d,l),J(C),J(f,l),J(A,l),J(E,l),J(G,l),J(q,l),J(Q,l),J(S,l),J(z,l),J(R,l),J(F,l),J(_,l),J(x,l),J(L,l),J(D,l),J(ll,l),J(al,l),J(tl,l),J(cl,l),J(yl,l),J(ul,l),J(wl,l),J(Il,l)}}}const Ba='{"title":"Construyendo Tu Primer LangGraph","local":"construyendo-tu-primer-langgraph","sections":[{"title":"Nuestro Flujo de Trabajo","local":"nuestro-flujo-de-trabajo","sections":[],"depth":2},{"title":"Configurando Nuestro Entorno","local":"configurando-nuestro-entorno","sections":[],"depth":2},{"title":"Paso 1: Definir Nuestro Estado","local":"paso-1-definir-nuestro-estado","sections":[],"depth":2},{"title":"Paso 2: Definir Nuestros Nodos","local":"paso-2-definir-nuestros-nodos","sections":[],"depth":2},{"title":"Paso 3: Definir Nuestra Lógica de Enrutamiento","local":"paso-3-definir-nuestra-lógica-de-enrutamiento","sections":[],"depth":2},{"title":"Paso 4: Crear el StateGraph y Definir Aristas(Edges)","local":"paso-4-crear-el-stategraph-y-definir-aristasedges","sections":[],"depth":2},{"title":"Paso 5: Ejecutar la Aplicación","local":"paso-5-ejecutar-la-aplicación","sections":[],"depth":2},{"title":"Paso 6: Inspeccionando Nuestro Agente de Clasificación de Correo con Langfuse 📡","local":"paso-6-inspeccionando-nuestro-agente-de-clasificación-de-correo-con-langfuse-","sections":[],"depth":2},{"title":"Lo Que Hemos Construido","local":"lo-que-hemos-construido","sections":[],"depth":2},{"title":"Puntos Clave","local":"puntos-clave","sections":[],"depth":2},{"title":"¿Qué Sigue?","local":"qué-sigue","sections":[],"depth":2}],"depth":1}';function fa(Qs){return wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qa extends da{constructor(u){super(),Ia(this,u,fa,ga,ua,{})}}export{qa as component};
