import{s as Pe,n as De,o as Ke}from"../chunks/scheduler.505acc25.js";import{S as Oe,i as sl,e as o,s as t,c as r,q as el,h as ll,a as p,d as l,b as n,f as ye,g as c,j as i,r as al,k as Me,l as je,m as a,n as u,t as d,o as m,p as M}from"../chunks/index.fbb49fb4.js";import{C as tl}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as T}from"../chunks/CodeBlock.2ead06c8.js";import{H as U}from"../chunks/Heading.511e0027.js";import{E as nl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function ol(Je){let w,ys,Ms,js,b,Js,f,Ts,h,Te="Un workflow en LlamaIndex proporciona una forma estructurada de organizar su código en pasos secuenciales y manejables.",Us,I,Ue="Tal workflow se crea definiendo <code>Steps</code> que se activan por <code>Events</code>, y emiten <code>Events</code> para activar pasos posteriores.",bs,C,be="Echemos un vistazo a Alfred mostrando un workflow de LlamaIndex para una tarea de RAG.",fs,B,fe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflows esquematico"/>',hs,g,he="<strong>Workflows ofrecen varios beneficios clave:</strong>",Is,v,Ie="<li>Organizacion clara de código en pasos discretos</li> <li>Arquitectura de control de flujo basada en eventos flexible</li> <li>Comunicación de tipado segura entre pasos</li> <li>Manejo de estado integrado</li> <li>Apoyo para agentes simples y complejos</li>",Cs,k,Ce="Como podra haber adivinado, <strong>workflows ofrecen un equilibrio entre la autonomía de los agentes mientras se mantiene el control sobre el workflow global.</strong>",Bs,G,Be="Asi que, vamos a aprender como crear un workflow nosotros mismos!",gs,V,vs,y,ge='<p>Puede seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">esta notebook</a> que puede ejecutar utilizando Google Colab.</p>',ks,Z,Gs,j,ms,ve="Instalar el paquete Workflow",we,_,Vs,E,ke=`Podemos crear un flujo de trabajo de un solo paso definiendo una clase que herede de <code>Workflow</code> y decorando tus funciones con <code>@step</code>.
También necesitaremos añadir <code>StartEvent</code> y <code>StopEvent</code>, que son eventos especiales que se utilizan para indicar el inicio y el fin del flujo de trabajo.`,Zs,x,_s,W,Ge="Como puedes ver, ahora podemos ejecutar el flujo de trabajo llamando a <code>w.run()</code>.",Es,$,xs,z,Ve=`Para conectar múltiples pasos, <strong>creamos eventos personalizados que transportan datos entre pasos.</strong>
Para hacerlo, necesitamos agregar un <code>Event</code> que se pasa entre los pasos y transfiere la salida del primer paso al segundo paso.`,Ws,q,$s,Q,Ze="La indicación de tipo es importante aquí, ya que asegura que el flujo de trabajo se ejecute correctamente. ¡Vamos a complicar un poco más las cosas!",zs,S,qs,X,_e="La indicación de tipo es la parte más poderosa de los flujos de trabajo porque nos permite crear ramificaciones, bucles y uniones para facilitar flujos de trabajo más complejos.",Qs,H,Ee=`Veamos un ejemplo de <strong>creación de un bucle</strong> usando el operador de unión <code>|</code>.
En el ejemplo siguiente, vemos que el <code>LoopEvent</code> se toma como entrada para el paso y también puede devolverse como salida.`,Ss,N,Xs,R,Hs,A,xe="También podemos dibujar flujos de trabajo. Usemos la función <code>draw_all_possible_flows</code> para dibujar el flujo de trabajo. Esto almacena el flujo de trabajo en un archivo HTML.",Ns,F,Rs,Y,We='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="dibujo del flujo de trabajo"/>',As,L,$e="Hay un último truco interesante que cubriremos en el curso, que es la capacidad de añadir estado al flujo de trabajo.",Fs,P,Ys,D,ze=`La gestión de estado es útil cuando quieres hacer un seguimiento del estado del flujo de trabajo, para que cada paso tenga acceso al mismo estado.
Podemos hacer esto usando la pista de tipo <code>Context</code> encima de un parámetro en la función del paso.`,Ls,K,Ps,O,qe="¡Genial! ¡Ahora sabes cómo crear flujos de trabajo básicos en LlamaIndex!",Ds,J,Qe='<p>Hay algunos matices más complejos en los flujos de trabajo, que puedes aprender en <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">la documentación de LlamaIndex</a>.</p>',Ks,ss,Se="Sin embargo, hay otra forma de crear flujos de trabajo, que se basa en la clase <code>AgentWorkflow</code>. Veamos cómo podemos usar esto para crear un flujo de trabajo multiagente.",Os,es,se,ls,Xe=`En lugar de la creación manual de flujos de trabajo, podemos usar la clase <strong><code>AgentWorkflow</code> para crear un flujo de trabajo multiagente</strong>.
El <code>AgentWorkflow</code> utiliza Agentes de Flujo de Trabajo para permitirte crear un sistema de uno o más agentes que pueden colaborar y transferir tareas entre sí según sus capacidades especializadas.
Esto permite construir sistemas de agentes complejos donde diferentes agentes manejan diferentes aspectos de una tarea.
En lugar de importar clases de <code>llama_index.core.agent</code>, importaremos las clases de agente de <code>llama_index.core.agent.workflow</code>.
Un agente debe ser designado como el agente raíz en el constructor de <code>AgentWorkflow</code>.
Cuando llega un mensaje de usuario, primero se dirige al agente raíz.`,ee,as,He="Cada agente puede entonces:",le,ts,Ne="<li>Manejar la solicitud directamente usando sus herramientas</li> <li>Transferir a otro agente mejor preparado para la tarea</li> <li>Devolver una respuesta al usuario</li>",ae,ns,Re="Veamos cómo crear un flujo de trabajo multiagente.",te,os,ne,ps,Ae=`Las herramientas del agente también pueden modificar el estado del flujo de trabajo que mencionamos anteriormente. Antes de iniciar el flujo de trabajo, podemos proporcionar un diccionario de estado inicial que estará disponible para todos los agentes.
El estado se almacena en la clave state del contexto del flujo de trabajo. Se inyectará en el state_prompt que aumenta cada nuevo mensaje de usuario.`,oe,is,Fe="Vamos a inyectar un contador para contar las llamadas a funciones modificando el ejemplo anterior:",pe,rs,ie,cs,Ye="¡Felicidades! ¡Ahora has dominado los conceptos básicos de los Agentes en LlamaIndex! 🎉",re,us,Le="¡Continuemos con un último cuestionario para consolidar tu conocimiento! 🚀",ce,ds,ue,ws,de;return b=new tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new U({props:{title:"Crear workflows agenticos en LlamaIndex",local:"crear-workflows-agenticos-en-llamaindex",headingTag:"h1"}}),V=new U({props:{title:"Crear Workflows",local:"crear-workflows",headingTag:"h2"}}),Z=new U({props:{title:"Crear un workflow básico",local:"crear-un-workflow-básico",headingTag:"h3"}}),_=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),x=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwaGFjZXIlMjBhbGdvJTIwYXF1JUMzJUFEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMiVDMiVBMUhvbGElMkMlMjBtdW5kbyElMjIpJTBBJTBBJTBBdyUyMCUzRCUyME15V29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># hacer algo aquí</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;¡Hola, mundo!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),$=new U({props:{title:"Conectando Múltiples Pasos",local:"conectando-múltiples-pasos",headingTag:"h3"}}),q=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc2FyJTIwZGF0b3MlMjBpbmljaWFsZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBQcm9jZXNzaW5nRXZlbnQoaW50ZXJtZWRpYXRlX3Jlc3VsdCUzRCUyMlBhc28lMjAxJTIwY29tcGxldGFkbyUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzYXIlMjBlbCUyMHJlc3VsdGFkbyUyMGludGVybWVkaW8lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyUHJvY2VzYW1pZW50byUyMGZpbmFsaXphZG8lM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Procesar datos iniciales</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Paso 1 completado&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Usar el resultado intermedio</span>
        final_result = <span class="hljs-string">f&quot;Procesamiento finalizado: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),S=new U({props:{title:"Bucles y Ramificaciones",local:"bucles-y-ramificaciones",headingTag:"h3"}}),N=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyT2N1cnJpJUMzJUIzJTIwYWxnbyUyMG1hbG8lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTG9vcEV2ZW50KGxvb3Bfb3V0cHV0JTNEJTIyVm9sdmVyJTIwYWwlMjBwYXNvJTIwdW5vLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyT2N1cnJpJUMzJUIzJTIwYWxnbyUyMGJ1ZW5vJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyUHJpbWVyJTIwcGFzbyUyMGNvbXBsZXRhZG8uJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfdHdvKHNlbGYlMkMlMjBldiUzQSUyMFByb2Nlc3NpbmdFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVXNhciUyMGVsJTIwcmVzdWx0YWRvJTIwaW50ZXJtZWRpbyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJQcm9jZXNhbWllbnRvJTIwZmluYWxpemFkbyUzQSUyMCU3QmV2LmludGVybWVkaWF0ZV9yZXN1bHQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBTdG9wRXZlbnQocmVzdWx0JTNEZmluYWxfcmVzdWx0KSUwQSUwQSUwQXclMjAlM0QlMjBNdWx0aVN0ZXBXb3JrZmxvdyh2ZXJib3NlJTNERmFsc2UpJTBBcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjB3LnJ1bigpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Ocurrió algo malo&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Volver al paso uno.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Ocurrió algo bueno&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Primer paso completado.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent | LoopEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Usar el resultado intermedio</span>
        final_result = <span class="hljs-string">f&quot;Procesamiento finalizado: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),R=new U({props:{title:"Dibujando Flujos de Trabajo",local:"dibujando-flujos-de-trabajo",headingTag:"h3"}}),F=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwY29tbyUyMHNlJTIwZGVmaW5pJUMzJUIzJTIwZW4lMjBsYSUyMHNlY2NpJUMzJUIzbiUyMGFudGVyaW9yJTBBZHJhd19hbGxfcG9zc2libGVfZmxvd3ModyUyQyUyMCUyMmZsb3cuaHRtbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># como se definió en la sección anterior</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),P=new U({props:{title:"Gestión de Estado",local:"gestión-de-estado",headingTag:"h3"}}),K=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBhbG1hY2VuYXIlMjBlbiUyMGNvbnRleHRvJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc3RvcmUuc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyJUMyJUJGQ3UlQzMlQTFsJTIwZXMlMjBsYSUyMGNhcGl0YWwlMjBkZSUyMEZyYW5jaWElM0YlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwaGFjZXIlMjBhbGdvJTIwY29uJTIwZWwlMjBjb250ZXh0byUyMHklMjBlbCUyMGV2ZW50byUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJlY3VwZXJhciUyMGRlbCUyMGNvbnRleHRvJTBBJTIwJTIwJTIwJTIwcXVlcnklMjAlM0QlMjBhd2FpdCUyMGN0eC5zdG9yZS5nZXQoJTIycXVlcnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># almacenar en contexto</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;¿Cuál es la capital de Francia?&quot;</span>)

    <span class="hljs-comment"># hacer algo con el contexto y el evento</span>
    val = ...

    <span class="hljs-comment"># recuperar del contexto</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=result)`,wrap:!1}}),es=new U({props:{title:"Automatizando flujos de trabajo con Flujos de Trabajo Multiagente",local:"automatizando-flujos-de-trabajo-con-flujos-de-trabajo-multiagente",headingTag:"h2"}}),os=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Definir algunas herramientas</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Sumar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplicar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># podemos pasar funciones directamente sin FunctionTool -- la función/docstring se analizan para el nombre/descripción</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Es capaz de multiplicar dos enteros&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Un asistente útil que puede usar una herramienta para multiplicar números.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Es capaz de sumar dos enteros&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Un asistente útil que puede usar una herramienta para sumar números.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Crear el flujo de trabajo</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Ejecutar el sistema</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;¿Puedes sumar 5 y 3?&quot;</span>)`,wrap:!1}}),rs=new T({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Definir algunas herramientas</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Sumar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># actualizar nuestro contador</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplicar dos números.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># actualizar nuestro contador</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Estado actual: {state}. Mensaje del usuario: {msg}&quot;</span>,
)

<span class="hljs-comment"># ejecutar el flujo de trabajo con contexto</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;¿Puedes sumar 5 y 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># extraer e inspeccionar el estado</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),ds=new nl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/workflows.mdx"}}),{c(){w=o("meta"),ys=t(),Ms=o("p"),js=t(),r(b.$$.fragment),Js=t(),r(f.$$.fragment),Ts=t(),h=o("p"),h.textContent=Te,Us=t(),I=o("p"),I.innerHTML=Ue,bs=t(),C=o("p"),C.textContent=be,fs=t(),B=o("p"),B.innerHTML=fe,hs=t(),g=o("p"),g.innerHTML=he,Is=t(),v=o("ul"),v.innerHTML=Ie,Cs=t(),k=o("p"),k.innerHTML=Ce,Bs=t(),G=o("p"),G.textContent=Be,gs=t(),r(V.$$.fragment),vs=t(),y=o("blockquote"),y.innerHTML=ge,ks=t(),r(Z.$$.fragment),Gs=t(),j=o("details"),ms=o("summary"),ms.textContent=ve,we=el(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el paquete Workflow con el siguiente comando:

	`),r(_.$$.fragment),Vs=t(),E=o("p"),E.innerHTML=ke,Zs=t(),r(x.$$.fragment),_s=t(),W=o("p"),W.innerHTML=Ge,Es=t(),r($.$$.fragment),xs=t(),z=o("p"),z.innerHTML=Ve,Ws=t(),r(q.$$.fragment),$s=t(),Q=o("p"),Q.textContent=Ze,zs=t(),r(S.$$.fragment),qs=t(),X=o("p"),X.textContent=_e,Qs=t(),H=o("p"),H.innerHTML=Ee,Ss=t(),r(N.$$.fragment),Xs=t(),r(R.$$.fragment),Hs=t(),A=o("p"),A.innerHTML=xe,Ns=t(),r(F.$$.fragment),Rs=t(),Y=o("p"),Y.innerHTML=We,As=t(),L=o("p"),L.textContent=$e,Fs=t(),r(P.$$.fragment),Ys=t(),D=o("p"),D.innerHTML=ze,Ls=t(),r(K.$$.fragment),Ps=t(),O=o("p"),O.textContent=qe,Ds=t(),J=o("blockquote"),J.innerHTML=Qe,Ks=t(),ss=o("p"),ss.innerHTML=Se,Os=t(),r(es.$$.fragment),se=t(),ls=o("p"),ls.innerHTML=Xe,ee=t(),as=o("p"),as.textContent=He,le=t(),ts=o("ul"),ts.innerHTML=Ne,ae=t(),ns=o("p"),ns.textContent=Re,te=t(),r(os.$$.fragment),ne=t(),ps=o("p"),ps.textContent=Ae,oe=t(),is=o("p"),is.textContent=Fe,pe=t(),r(rs.$$.fragment),ie=t(),cs=o("p"),cs.textContent=Ye,re=t(),us=o("p"),us.textContent=Le,ce=t(),r(ds.$$.fragment),ue=t(),ws=o("p"),this.h()},l(s){const e=ll("svelte-u9bgzb",document.head);w=p(e,"META",{name:!0,content:!0}),e.forEach(l),ys=n(s),Ms=p(s,"P",{}),ye(Ms).forEach(l),js=n(s),c(b.$$.fragment,s),Js=n(s),c(f.$$.fragment,s),Ts=n(s),h=p(s,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1lix0g5"&&(h.textContent=Te),Us=n(s),I=p(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1m5c0tu"&&(I.innerHTML=Ue),bs=n(s),C=p(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-khslop"&&(C.textContent=be),fs=n(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-w1nyou"&&(B.innerHTML=fe),hs=n(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1drxdlt"&&(g.innerHTML=he),Is=n(s),v=p(s,"UL",{"data-svelte-h":!0}),i(v)!=="svelte-jiyuvc"&&(v.innerHTML=Ie),Cs=n(s),k=p(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1gm9hbm"&&(k.innerHTML=Ce),Bs=n(s),G=p(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ung185"&&(G.textContent=Be),gs=n(s),c(V.$$.fragment,s),vs=n(s),y=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-103t8nk"&&(y.innerHTML=ge),ks=n(s),c(Z.$$.fragment,s),Gs=n(s),j=p(s,"DETAILS",{});var me=ye(j);ms=p(me,"SUMMARY",{"data-svelte-h":!0}),i(ms)!=="svelte-nidhp3"&&(ms.textContent=ve),we=al(me,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el paquete Workflow con el siguiente comando:

	`),c(_.$$.fragment,me),me.forEach(l),Vs=n(s),E=p(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1q8rqbj"&&(E.innerHTML=ke),Zs=n(s),c(x.$$.fragment,s),_s=n(s),W=p(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-113newy"&&(W.innerHTML=Ge),Es=n(s),c($.$$.fragment,s),xs=n(s),z=p(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1gigad5"&&(z.innerHTML=Ve),Ws=n(s),c(q.$$.fragment,s),$s=n(s),Q=p(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1ctrgy3"&&(Q.textContent=Ze),zs=n(s),c(S.$$.fragment,s),qs=n(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1yaw7gt"&&(X.textContent=_e),Qs=n(s),H=p(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-zm1jpc"&&(H.innerHTML=Ee),Ss=n(s),c(N.$$.fragment,s),Xs=n(s),c(R.$$.fragment,s),Hs=n(s),A=p(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-e8mj9m"&&(A.innerHTML=xe),Ns=n(s),c(F.$$.fragment,s),Rs=n(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-s95098"&&(Y.innerHTML=We),As=n(s),L=p(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-fe8nvj"&&(L.textContent=$e),Fs=n(s),c(P.$$.fragment,s),Ys=n(s),D=p(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-mobhjv"&&(D.innerHTML=ze),Ls=n(s),c(K.$$.fragment,s),Ps=n(s),O=p(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-yqpb97"&&(O.textContent=qe),Ds=n(s),J=p(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(J)!=="svelte-wck0n7"&&(J.innerHTML=Qe),Ks=n(s),ss=p(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-gmv6hb"&&(ss.innerHTML=Se),Os=n(s),c(es.$$.fragment,s),se=n(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-tz499j"&&(ls.innerHTML=Xe),ee=n(s),as=p(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1hnc17x"&&(as.textContent=He),le=n(s),ts=p(s,"UL",{"data-svelte-h":!0}),i(ts)!=="svelte-2x6jux"&&(ts.innerHTML=Ne),ae=n(s),ns=p(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-tm81au"&&(ns.textContent=Re),te=n(s),c(os.$$.fragment,s),ne=n(s),ps=p(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1hvckkj"&&(ps.textContent=Ae),oe=n(s),is=p(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-131zgzc"&&(is.textContent=Fe),pe=n(s),c(rs.$$.fragment,s),ie=n(s),cs=p(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-1dnh5hk"&&(cs.textContent=Ye),re=n(s),us=p(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-172wyo2"&&(us.textContent=Le),ce=n(s),c(ds.$$.fragment,s),ue=n(s),ws=p(s,"P",{}),ye(ws).forEach(l),this.h()},h(){Me(w,"name","hf:doc:metadata"),Me(w,"content",pl),Me(y,"class","tip"),Me(J,"class","tip")},m(s,e){je(document.head,w),a(s,ys,e),a(s,Ms,e),a(s,js,e),u(b,s,e),a(s,Js,e),u(f,s,e),a(s,Ts,e),a(s,h,e),a(s,Us,e),a(s,I,e),a(s,bs,e),a(s,C,e),a(s,fs,e),a(s,B,e),a(s,hs,e),a(s,g,e),a(s,Is,e),a(s,v,e),a(s,Cs,e),a(s,k,e),a(s,Bs,e),a(s,G,e),a(s,gs,e),u(V,s,e),a(s,vs,e),a(s,y,e),a(s,ks,e),u(Z,s,e),a(s,Gs,e),a(s,j,e),je(j,ms),je(j,we),u(_,j,null),a(s,Vs,e),a(s,E,e),a(s,Zs,e),u(x,s,e),a(s,_s,e),a(s,W,e),a(s,Es,e),u($,s,e),a(s,xs,e),a(s,z,e),a(s,Ws,e),u(q,s,e),a(s,$s,e),a(s,Q,e),a(s,zs,e),u(S,s,e),a(s,qs,e),a(s,X,e),a(s,Qs,e),a(s,H,e),a(s,Ss,e),u(N,s,e),a(s,Xs,e),u(R,s,e),a(s,Hs,e),a(s,A,e),a(s,Ns,e),u(F,s,e),a(s,Rs,e),a(s,Y,e),a(s,As,e),a(s,L,e),a(s,Fs,e),u(P,s,e),a(s,Ys,e),a(s,D,e),a(s,Ls,e),u(K,s,e),a(s,Ps,e),a(s,O,e),a(s,Ds,e),a(s,J,e),a(s,Ks,e),a(s,ss,e),a(s,Os,e),u(es,s,e),a(s,se,e),a(s,ls,e),a(s,ee,e),a(s,as,e),a(s,le,e),a(s,ts,e),a(s,ae,e),a(s,ns,e),a(s,te,e),u(os,s,e),a(s,ne,e),a(s,ps,e),a(s,oe,e),a(s,is,e),a(s,pe,e),u(rs,s,e),a(s,ie,e),a(s,cs,e),a(s,re,e),a(s,us,e),a(s,ce,e),u(ds,s,e),a(s,ue,e),a(s,ws,e),de=!0},p:De,i(s){de||(d(b.$$.fragment,s),d(f.$$.fragment,s),d(V.$$.fragment,s),d(Z.$$.fragment,s),d(_.$$.fragment,s),d(x.$$.fragment,s),d($.$$.fragment,s),d(q.$$.fragment,s),d(S.$$.fragment,s),d(N.$$.fragment,s),d(R.$$.fragment,s),d(F.$$.fragment,s),d(P.$$.fragment,s),d(K.$$.fragment,s),d(es.$$.fragment,s),d(os.$$.fragment,s),d(rs.$$.fragment,s),d(ds.$$.fragment,s),de=!0)},o(s){m(b.$$.fragment,s),m(f.$$.fragment,s),m(V.$$.fragment,s),m(Z.$$.fragment,s),m(_.$$.fragment,s),m(x.$$.fragment,s),m($.$$.fragment,s),m(q.$$.fragment,s),m(S.$$.fragment,s),m(N.$$.fragment,s),m(R.$$.fragment,s),m(F.$$.fragment,s),m(P.$$.fragment,s),m(K.$$.fragment,s),m(es.$$.fragment,s),m(os.$$.fragment,s),m(rs.$$.fragment,s),m(ds.$$.fragment,s),de=!1},d(s){s&&(l(ys),l(Ms),l(js),l(Js),l(Ts),l(h),l(Us),l(I),l(bs),l(C),l(fs),l(B),l(hs),l(g),l(Is),l(v),l(Cs),l(k),l(Bs),l(G),l(gs),l(vs),l(y),l(ks),l(Gs),l(j),l(Vs),l(E),l(Zs),l(_s),l(W),l(Es),l(xs),l(z),l(Ws),l($s),l(Q),l(zs),l(qs),l(X),l(Qs),l(H),l(Ss),l(Xs),l(Hs),l(A),l(Ns),l(Rs),l(Y),l(As),l(L),l(Fs),l(Ys),l(D),l(Ls),l(Ps),l(O),l(Ds),l(J),l(Ks),l(ss),l(Os),l(se),l(ls),l(ee),l(as),l(le),l(ts),l(ae),l(ns),l(te),l(ne),l(ps),l(oe),l(is),l(pe),l(ie),l(cs),l(re),l(us),l(ce),l(ue),l(ws)),l(w),M(b,s),M(f,s),M(V,s),M(Z,s),M(_),M(x,s),M($,s),M(q,s),M(S,s),M(N,s),M(R,s),M(F,s),M(P,s),M(K,s),M(es,s),M(os,s),M(rs,s),M(ds,s)}}}const pl='{"title":"Crear workflows agenticos en LlamaIndex","local":"crear-workflows-agenticos-en-llamaindex","sections":[{"title":"Crear Workflows","local":"crear-workflows","sections":[{"title":"Crear un workflow básico","local":"crear-un-workflow-básico","sections":[],"depth":3},{"title":"Conectando Múltiples Pasos","local":"conectando-múltiples-pasos","sections":[],"depth":3},{"title":"Bucles y Ramificaciones","local":"bucles-y-ramificaciones","sections":[],"depth":3},{"title":"Dibujando Flujos de Trabajo","local":"dibujando-flujos-de-trabajo","sections":[],"depth":3},{"title":"Gestión de Estado","local":"gestión-de-estado","sections":[],"depth":3}],"depth":2},{"title":"Automatizando flujos de trabajo con Flujos de Trabajo Multiagente","local":"automatizando-flujos-de-trabajo-con-flujos-de-trabajo-multiagente","sections":[],"depth":2}],"depth":1}';function il(Je){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends Oe{constructor(w){super(),sl(this,w,il,ol,Pe,{})}}export{wl as component};
