# ¿Y ahora? ¿Qué temas debería aprender?

La IA Agéntica es un campo en rápida evolución, y comprender los protocolos fundamentales es esencial para construir sistemas inteligentes y autónomos.

Dos estándares importantes con los que deberías familiarizarte son:

- El **Protocolo de Contexto del Modelo (MCP)**
- El **Protocolo Agente a Agente (A2A)**

## 🔌 Protocolo de Contexto del Modelo (MCP)

El **Protocolo de Contexto del Modelo (MCP)** de Anthropic es un estándar abierto que permite a los modelos de IA **conectarse de forma segura y fluida con herramientas externas, fuentes de datos y aplicaciones**, haciendo que los agentes sean más capaces y autónomos.

Piensa en el MCP como un **adaptador universal**, como un puerto USB-C, que permite a los modelos de IA conectarse a diversos entornos digitales **sin necesidad de una integración personalizada para cada uno**.

El MCP está ganando rápidamente terreno en la industria, con grandes empresas como OpenAI y Google comenzando a adoptarlo.

📚 Aprende más:
- [Anuncio oficial y documentación de Anthropic](https://www.anthropic.com/news/model-context-protocol)
- [MCP en Wikipedia (en inglés)](https://en.wikipedia.org/wiki/Model_Context_Protocol)
- [Blog sobre MCP (en inglés)](https://huggingface.co/blog/Kseniase/mcp)

## 🤝 Protocolo Agente a Agente (A2A)

Google ha desarrollado el **Protocolo Agente a Agente (A2A)** como contraparte complementaria al Protocolo de Contexto del Modelo (MCP) de Anthropic.

Mientras que el MCP conecta a los agentes con herramientas externas, **el A2A conecta a los agentes entre sí**, allanando el camino para sistemas cooperativos multiagente que pueden trabajar juntos para resolver problemas complejos.

📚 Profundiza en A2A:
- [Anuncio de A2A de Google (en inglés)](https://developers.googleblog.com/en/a2a-a-new-era-of-agent-interoperability/)


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/es/unit4/additional-readings.mdx" />