import{s as tn,a as Hl,n as ln,o as sn}from"../chunks/scheduler.505acc25.js";import{S as nn,i as un,e as u,s as n,c as M,h as an,a,d as l,b as i,f as Ql,g as p,j as o,k as y,l as Zl,m as s,n as r,t as c,o as T,p as m}from"../chunks/index.b1175496.js";import{C as on,H as Pe}from"../chunks/Heading.988e52fa.js";import{C as U}from"../chunks/CodeBlock.ed64aebc.js";import{E as Mn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function pn(zl){let J,Oe,De,et,d,tt,I,lt,j,Xl,st,C,Vl="Un aspect crucial des agents est leur capacité à prendre des <strong>actions</strong>. Comme nous l’avons vu, cela se fait par l’utilisation d’<strong>outils</strong>.",nt,f,Yl="Dans cette section, nous verrons ce que sont les outils, comment les concevoir efficacement, et comment les intégrer à votre agent via le message système.",it,b,Wl="En fournissant à votre agent les bons outils — et en décrivant clairement le fonctionnement de ces outils — vous pouvez augmenter de manière spectaculaire ce que votre IA peut accomplir. Plongeons-nous dedans !",ut,v,at,x,kl="Un <strong>outil est une fonction fournie au LLM</strong>. Cette fonction doit remplir un <strong>objectif clair</strong>.",ot,B,Nl="Voici quelques outils couramment utilisés dans les agents :",Mt,A,El="<thead><tr><th>Outil</th> <th>Description</th></tr></thead> <tbody><tr><td>Recherche Web</td> <td>Permet à l’agent de récupérer des informations à jour depuis Internet.</td></tr> <tr><td>Génération d’images</td> <td>Crée des images à partir de descriptions textuelles.</td></tr> <tr><td>Recherche</td> <td>Récupère des informations à partir d’une source externe.</td></tr> <tr><td>Interface API</td> <td>Interagit avec une API externe (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",pt,h,Pl="Ce ne sont que des exemples, car en réalité, vous pouvez créer un outil pour n’importe quel cas d’utilisation !",rt,_,Fl="Un bon outil doit être quelque chose qui <strong>complémente la puissance d’un LLM</strong>.",ct,q,Dl="Par exemple, si vous devez effectuer des opérations arithmétiques, fournir une <strong>calculatrice</strong> à votre LLM donnera de meilleurs résultats que de se fier aux capacités natives du modèle.",Tt,g,Kl="De plus, <strong>les LLM prédisent la complétion du <em>prompt</em> en se basant sur leurs données d’entraînement</strong>, ce qui signifie que leur connaissance interne n’inclut que les événements antérieurs à leur entraînement. Par conséquent, si votre agent a besoin de données à jour, vous devez les fournir via un outil.",mt,G,Ol="Par exemple, si vous demandez directement à un LLM (sans outil de recherche) la météo d’aujourd’hui, le LLM pourrait inventer une météo aléatoire.",yt,L,es,Jt,$,ts="<li><p>Un outil doit contenir :</p> <ul><li>Une <strong>description textuelle de ce que fait la fonction</strong>.</li> <li>Un <em>appeleur</em> (quelque chose pour effectuer une action).</li> <li>Des <em>arguments</em> avec typage.</li> <li>(Optionnel) Des sorties avec typage.</li></ul></li>",Ut,S,wt,H,ls=`Comme nous l’avons vu, les LLM ne peuvent recevoir que des entrées textuelles et générer des sorties textuelles. Ils ne peuvent pas appeler des outils par eux-mêmes.
Lorsque nous parlons de fournir des outils à un agent, nous entendons enseigner au LLM l’existence de ces outils et lui demander de générer des invocations textuelles en cas de besoin.`,dt,R,ss="Par exemple, si nous fournissons un outil pour vérifier le temps qu’il fait à un endroit donné à partir d’internet et que nous demandons ensuite au LLM le temps qu’il fait à Paris, le LLM reconnaîtra qu’il s’agit d’une occasion d’utiliser l’outil « météo ». Au lieu de récupérer les données météorologiques elles-mêmes, le LLM générera un texte pour appeller l’outil, tel que `<code>call weather_tool(&quot;Paris&quot;)</code>.",It,Q,ns="L’agent lit alors cette réponse, identifie qu’un appel d’outil est nécessaire, exécute l’outil au nom du LLM et récupère les données météorologiques réelles.",jt,Z,is="Les étapes de l’appel d’outil ne sont généralement pas montrées à l’utilisateur : l’agent les ajoute à un nouveau message avant de transmettre à nouveau la conversation mise à jour au LLM. Le LLM traite alors ce contexte supplémentaire et génère une réponse naturelle pour l’utilisateur. Du point de vue de l’utilisateur, il semble que le LLM interagisse directement avec l’outil, mais en réalité, c’est l’agent qui gère l’ensemble du processus d’exécution en arrière-plan.",Ct,z,us="Nous reviendrons plus en détail sur ce processus dans les prochaines sessions.",ft,X,bt,V,as="La réponse complète peut sembler complexe, mais nous utilisons essentiellement le <em>prompt</em> système pour fournir au modèle des descriptions textuelles des outils disponibles :",vt,Y,os,xt,W,Ms="Pour que cela fonctionne, nous devons être très précis et rigoureux concernant :",Bt,k,ps="<li><strong>Ce que fait l’outil</strong></li> <li><strong>Les entrées exactes qu’il attend</strong></li>",At,N,rs="C’est la raison pour laquelle les descriptions d’outils sont généralement fournies en utilisant des structures expressives mais précises, telles que des langages informatiques ou du JSON. Il n’est pas <em>nécessaire</em> de procéder ainsi, tout format précis et cohérent fonctionnerait.",ht,E,cs="Si cela semble trop théorique, voyons cela à travers un exemple concret.",_t,P,Ts="Nous allons implémenter un outil simplifié <strong>calculatrice</strong> qui se contentera de multiplier deux entiers. Voici une implémentation en Python :",qt,F,gt,D,ms="Ainsi, notre outil s’appelle <code>calculator</code>, il <strong>multiplie deux entiers</strong>, et il requiert les entrées suivantes :",Gt,K,ys="<li><strong><code>a</code></strong> (<em>int</em>): Un entier.</li> <li><strong><code>b</code></strong> (<em>int</em>): Un entier.</li>",Lt,O,Js="La sortie de l’outil est un autre nombre entier que nous pouvons décrire ainsi :",$t,ee,Us="<li>(<em>int</em>): Le produit de <code>a</code> et <code>b</code>.</li>",St,te,ws="Tous ces détails sont importants. Rassemblons-les dans une chaîne de texte qui décrit notre outil pour que le LLM puisse le comprendre.",Ht,le,Rt,se,ds="<p><strong>Rappel :</strong> Cette description textuelle est <em>ce que nous voulons que le LLM sache à propos de l’outil</em>.</p>",Qt,ne,Is="Lorsque nous passons la chaîne précédente dans l’entrée du LLM, le modèle la reconnaîtra comme un outil et saura quelles entrées fournir et ce qu’il doit attendre en sortie.",Zt,ie,js="Si nous souhaitons fournir des outils supplémentaires, nous devons rester cohérents et utiliser toujours le même format. Ce processus peut être fragile, et nous pourrions accidentellement négliger certains détails.",zt,ue,Cs="Existe-t-il une meilleure méthode ?",Xt,ae,Vt,oe,fs="Notre outil a été écrit en Python, et l’implémentation fournit déjà tout ce dont nous avons besoin :",Yt,Me,bs="<li>Un nom descriptif de ce qu’il fait : <code>calculator</code></li> <li>Une description plus détaillée, fournie par le commentaire docstring de la fonction : <code>Multiplie deux entiers.</code></li> <li>Les entrées et leur type : la fonction attend clairement deux <code>int</code>.</li> <li>Le type de la sortie.</li>",Wt,pe,vs="Il y a une raison pour laquelle on utilise des langages de programmation : ils sont expressifs, concis et précis.",kt,re,xs="Nous pourrions fournir le code source Python comme <em>spécification</em> de l’outil pour le LLM, mais la manière dont l’outil est implémenté n’a pas d’importance. Tout ce qui compte, c’est son nom, ce qu’il fait, les entrées qu’il attend et la sortie qu’il fournit.",Nt,ce,Bs="Nous tirerons parti des fonctionnalités d’introspection de Python pour exploiter le code source et construire automatiquement une description de l’outil. Tout ce dont nous avons besoin, c’est que l’implémentation de l’outil utilise des annotations de types, des docstrings et des noms de fonction pertinents. Nous écrirons un peu de code pour extraire les parties pertinentes du code source.",Et,Te,As="Une fois cela fait, il nous suffira d’utiliser un décorateur Python pour indiquer que la fonction <code>calculator</code> est un outil :",Pt,me,Ft,ye,hs="Notez le décorateur <code>@tool</code> avant la définition de la fonction.",Dt,Je,_s="Avec l’implémentation que nous verrons ensuite, nous serons capables d’extraire automatiquement le texte suivant à partir du code source :",Kt,Ue,Ot,we,qs="Comme vous pouvez le constater, c’est la même chose que nous avons écrit manuellement précédemment !",el,de,tl,Ie,gs="Nous créons une classe générique <code>Tool</code> que nous pouvons réutiliser chaque fois que nous avons besoin d’utiliser un outil.",ll,je,Gs="<p><strong>Avertissement :</strong> Cette implémentation à titre d’exemple est fictive mais ressemble de près aux implémentations réelles dans la plupart des bibliothèques.</p>",sl,Ce,nl,fe,Ls="Cela peut sembler compliqué, mais en y allant pas à pas, nous pouvons voir ce qu’elle fait. Nous définissons une classe <strong><code>Tool</code></strong> qui inclut :",il,be,$s="<li><strong><code>name</code></strong> (<em>str</em>): Le nom de l’outil.</li> <li><strong><code>description</code></strong> (<em>str</em>): Une brève description de ce que fait l’outil.</li> <li><strong><code>function</code></strong> (<em>callable</em>): La fonction que l’outil exécute.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): Les paramètres d’entrée attendus.</li> <li><strong><code>outputs</code></strong> (<em>str</em> ou <em>list</em>): Les sorties attendues de l’outil.</li> <li><strong><code>__call__()</code></strong> : Appelle la fonction lorsque l’instance de l’outil est invoquée.</li> <li><strong><code>to_string()</code></strong> : Convertit les attributs de l’outil en une représentation textuelle.</li>",ul,ve,Ss="Nous pourrions créer un outil avec cette classe en utilisant le code suivant :",al,xe,ol,Be,Hs="Mais nous pouvons également utiliser le module <code>inspect</code> de Python pour récupérer toutes les informations pour nous ! C’est ce que fait le décorateur <code>@tool</code>.",Ml,Ae,Rs="<p>Si cela vous intéresse, vous pouvez afficher la section suivante pour voir l’implémentation du décorateur.</p>",pl,w,Fe,Qs="code du décorateur",Rl,he,rl,_e,Zs="Pour réitérer, avec ce décorateur en place, nous pouvons implémenter notre outil comme ceci :",cl,qe,Tl,ge,zs="Et nous pouvons utiliser la méthode <code>to_string</code> de <code>Tool</code> pour récupérer automatiquement un texte adapté à être utilisé comme description d’un outil pour un LLM :",ml,Ge,yl,Le,Xs="La description est <strong>injectée</strong> dans le <em>prompt</em> système. En reprenant l’exemple avec lequel nous avons commencé cette section, voici à quoi cela ressemblerait après avoir remplacé le <code>tools_description</code> :",Jl,$e,Vs,Ul,Se,Ys='Dans la section sur les <a href="actions">actions</a>, nous en apprendrons davantage sur la façon dont un agent peut <strong>appeler</strong> cet outil que nous venons de créer.',wl,dl,Il,He,Ws="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents.",jl,Re,Cl,Qe,ks=`<em>Model Context Protocol</em> (MCP) est un <strong>protocole ouvert</strong> qui standardise la manière dont les applications <strong>fournissent des outils aux LLM</strong>.
MCP offre :`,fl,Ze,Ns="<li>Une liste croissante d’intégrations pré-construites que votre LLM peut directement utiliser</li> <li>La flexibilité de changer entre fournisseurs et vendeurs de LLM</li> <li>Les meilleures pratiques pour sécuriser vos données dans votre infrastructure</li>",bl,ze,Es="Cela signifie que <strong>tout <em>framework</em> intégrant MCP peut utiliser les outils définis dans le protocole</strong>, éliminant le besoin de réimplémenter la même interface d’outils pour chaque <em>framework</em>.",vl,Xe,Ps='Si vous voulez approfondir MCP, vous pouvez consulter notre <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">cours gratuit sur MCP</a>.',xl,Bl,Al,Ve,Fs="Les outils jouent un rôle crucial dans l’amélioration des capacités des agents.",hl,Ye,Ds="Pour résumer, nous avons appris :",_l,We,Ks="<li><p><em>Ce que sont les outils</em> : des fonctions qui offrent des capacités supplémentaires aux LLM, comme effectuer des calculs ou accéder à des données externes.</p></li> <li><p><em>Comment définir un outil</em> : en fournissant une description textuelle claire, des entrées, des sorties, et une fonction exécutable.</p></li> <li><p><em>Pourquoi les outils sont essentiels</em> : ils permettent aux agents de surmonter les limites de l’entraînement statique des modèles, de gérer des tâches en temps réel, et d’effectuer des actions spécialisées.</p></li>",ql,ke,Os='Maintenant, nous pouvons passer au <a href="agent-steps-and-structure"><em>workflow</em> de l’agent</a> où vous verrez comment un agent observe, réfléchit et agit. Cela <strong>rassemble tout ce que nous avons vu jusqu’à présent</strong> et prépare le terrain pour créer votre propre agent entièrement fonctionnel.',gl,Ne,en="Mais d’abord, il est temps pour un autre court quiz !",Gl,Ee,Ll,Ke,$l;return d=new on({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new Pe({props:{title:"Que sont les outils ?",local:"que-sont-les-outils-",headingTag:"h1"}}),v=new Pe({props:{title:"Que sont les outils d’IA ?",local:"que-sont-les-outils-dia-",headingTag:"h2"}}),S=new Pe({props:{title:"Comment fonctionnent les outils ?",local:"comment-fonctionnent-les-outils-",headingTag:"h2"}}),X=new Pe({props:{title:"Comment fournir des outils à un LLM ?",local:"comment-fournir-des-outils-à-un-llm-",headingTag:"h2"}}),F=new U({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),le=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),ae=new Pe({props:{title:"Sections d’auto-formatage des outils",local:"sections-dauto-formatage-des-outils",headingTag:"h3"}}),me=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Ue=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),de=new Pe({props:{title:"Implémentation générique d’un outil",local:"implémentation-générique-dun-outil",headingTag:"h3"}}),Ce=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Une classe représentant un morceau de code réutilisable (Outil).
    
    Attributs:
        name (str): Nom de l&#x27;outil.
        description (str): Une description textuelle de ce que fait l&#x27;outil.
        func (callable): La fonction que cet outil encapsule.
        arguments (list): Une liste d&#x27;arguments.
        outputs (str ou list): Le(s) type(s) de retour de la fonction encapsulée.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Retourne une représentation sous forme de chaîne de l&#x27;outil, 
        incluant son nom, sa description, ses arguments, et ses sorties.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoque la fonction sous-jacente (callable) avec les arguments fournis.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),xe=new U({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbm9tJTBBJTIwJTIwJTIwJTIwJTIyTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9uY3Rpb24lMjAlQzMlQTAlMjBhcHBlbGVyJTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwZW50ciVDMyVBOWVzJTIwKG5vbXMlMjBldCUyMHR5cGVzKSUwQSUyMCUyMCUyMCUyMCUyMmludCUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNvcnRpZSUwQSk=",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># nom</span>
    <span class="hljs-string">&quot;Multiplie deux entiers.&quot;</span>,      <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># fonction à appeler</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># entrées (noms et types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># sortie</span>
)`,wrap:!1}}),he=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Un décorateur qui crée une instance de Tool à partir de la fonction donnée.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Récupérer la signature de la fonction</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extraire les paires (nom_param, annotation_param) pour les entrées</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Déterminer l&#x27;annotation de retour</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;Pas d&#x27;annotation de retour&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Utiliser la docstring de la fonction comme description (par défaut si vide)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># Le nom de la fonction devient le nom de l&#x27;outil</span>
    name = func.__name__
    
    <span class="hljs-comment"># Retourner une nouvelle instance de Tool</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),qe=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZSUyMGRldXglMjBlbnRpZXJzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYiUwQSUwQXByaW50KGNhbGN1bGF0b3IudG9fc3RyaW5nKCkp",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplie deux entiers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Ge=new U({props:{code:"Tm9tJTIwZGUlMjBsJ291dGlsJTNBJTIwY2FsY3VsYXRvciUyQyUyMERlc2NyaXB0aW9uJTNBJTIwTXVsdGlwbGllJTIwZGV1eCUyMGVudGllcnMuJTJDJTIwQXJndW1lbnRzJTNBJTIwYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQlMkMlMjBTb3J0aWVzJTNBJTIwaW50",highlighted:'<span class="hljs-type">Nom</span> de l&#x27;outil: calculator, <span class="hljs-type">Description</span>: <span class="hljs-type">Multiplie</span> deux entiers., <span class="hljs-type">Arguments</span>: a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span>, <span class="hljs-type">Sorties</span>: <span class="hljs-built_in">int</span>',wrap:!1}}),Re=new Pe({props:{title:"Model Context Protocol (MCP) : une interface d’outils unifiée",local:"model-context-protocol-mcp--une-interface-doutils-unifiée",headingTag:"h3"}}),Ee=new Mn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tools.mdx"}}),{c(){J=u("meta"),Oe=n(),De=u("p"),et=n(),M(d.$$.fragment),tt=n(),M(I.$$.fragment),lt=n(),j=u("img"),st=n(),C=u("p"),C.innerHTML=Vl,nt=n(),f=u("p"),f.textContent=Yl,it=n(),b=u("p"),b.textContent=Wl,ut=n(),M(v.$$.fragment),at=n(),x=u("p"),x.innerHTML=kl,ot=n(),B=u("p"),B.textContent=Nl,Mt=n(),A=u("table"),A.innerHTML=El,pt=n(),h=u("p"),h.textContent=Pl,rt=n(),_=u("p"),_.innerHTML=Fl,ct=n(),q=u("p"),q.innerHTML=Dl,Tt=n(),g=u("p"),g.innerHTML=Kl,mt=n(),G=u("p"),G.textContent=Ol,yt=n(),L=u("img"),Jt=n(),$=u("ul"),$.innerHTML=ts,Ut=n(),M(S.$$.fragment),wt=n(),H=u("p"),H.textContent=ls,dt=n(),R=u("p"),R.innerHTML=ss,It=n(),Q=u("p"),Q.textContent=ns,jt=n(),Z=u("p"),Z.textContent=is,Ct=n(),z=u("p"),z.textContent=us,ft=n(),M(X.$$.fragment),bt=n(),V=u("p"),V.innerHTML=as,vt=n(),Y=u("img"),xt=n(),W=u("p"),W.textContent=Ms,Bt=n(),k=u("ol"),k.innerHTML=ps,At=n(),N=u("p"),N.innerHTML=rs,ht=n(),E=u("p"),E.textContent=cs,_t=n(),P=u("p"),P.innerHTML=Ts,qt=n(),M(F.$$.fragment),gt=n(),D=u("p"),D.innerHTML=ms,Gt=n(),K=u("ul"),K.innerHTML=ys,Lt=n(),O=u("p"),O.textContent=Js,$t=n(),ee=u("ul"),ee.innerHTML=Us,St=n(),te=u("p"),te.textContent=ws,Ht=n(),M(le.$$.fragment),Rt=n(),se=u("blockquote"),se.innerHTML=ds,Qt=n(),ne=u("p"),ne.textContent=Is,Zt=n(),ie=u("p"),ie.textContent=js,zt=n(),ue=u("p"),ue.textContent=Cs,Xt=n(),M(ae.$$.fragment),Vt=n(),oe=u("p"),oe.textContent=fs,Yt=n(),Me=u("ul"),Me.innerHTML=bs,Wt=n(),pe=u("p"),pe.textContent=vs,kt=n(),re=u("p"),re.innerHTML=xs,Nt=n(),ce=u("p"),ce.textContent=Bs,Et=n(),Te=u("p"),Te.innerHTML=As,Pt=n(),M(me.$$.fragment),Ft=n(),ye=u("p"),ye.innerHTML=hs,Dt=n(),Je=u("p"),Je.textContent=_s,Kt=n(),M(Ue.$$.fragment),Ot=n(),we=u("p"),we.textContent=qs,el=n(),M(de.$$.fragment),tl=n(),Ie=u("p"),Ie.innerHTML=gs,ll=n(),je=u("blockquote"),je.innerHTML=Gs,sl=n(),M(Ce.$$.fragment),nl=n(),fe=u("p"),fe.innerHTML=Ls,il=n(),be=u("ul"),be.innerHTML=$s,ul=n(),ve=u("p"),ve.textContent=Ss,al=n(),M(xe.$$.fragment),ol=n(),Be=u("p"),Be.innerHTML=Hs,Ml=n(),Ae=u("blockquote"),Ae.innerHTML=Rs,pl=n(),w=u("details"),Fe=u("summary"),Fe.textContent=Qs,Rl=n(),M(he.$$.fragment),rl=n(),_e=u("p"),_e.textContent=Zs,cl=n(),M(qe.$$.fragment),Tl=n(),ge=u("p"),ge.innerHTML=zs,ml=n(),M(Ge.$$.fragment),yl=n(),Le=u("p"),Le.innerHTML=Xs,Jl=n(),$e=u("img"),Ul=n(),Se=u("p"),Se.innerHTML=Ys,wl=n(),dl=u("hr"),Il=n(),He=u("p"),He.textContent=Ws,jl=n(),M(Re.$$.fragment),Cl=n(),Qe=u("p"),Qe.innerHTML=ks,fl=n(),Ze=u("ul"),Ze.innerHTML=Ns,bl=n(),ze=u("p"),ze.innerHTML=Es,vl=n(),Xe=u("p"),Xe.innerHTML=Ps,xl=n(),Bl=u("hr"),Al=n(),Ve=u("p"),Ve.textContent=Fs,hl=n(),Ye=u("p"),Ye.textContent=Ds,_l=n(),We=u("ul"),We.innerHTML=Ks,ql=n(),ke=u("p"),ke.innerHTML=Os,gl=n(),Ne=u("p"),Ne.textContent=en,Gl=n(),M(Ee.$$.fragment),Ll=n(),Ke=u("p"),this.h()},l(e){const t=an("svelte-u9bgzb",document.head);J=a(t,"META",{name:!0,content:!0}),t.forEach(l),Oe=i(e),De=a(e,"P",{}),Ql(De).forEach(l),et=i(e),p(d.$$.fragment,e),tt=i(e),p(I.$$.fragment,e),lt=i(e),j=a(e,"IMG",{src:!0,alt:!0}),st=i(e),C=a(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1g8bkuz"&&(C.innerHTML=Vl),nt=i(e),f=a(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-oqbuss"&&(f.textContent=Yl),it=i(e),b=a(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1lpseza"&&(b.textContent=Wl),ut=i(e),p(v.$$.fragment,e),at=i(e),x=a(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-cvxsx9"&&(x.innerHTML=kl),ot=i(e),B=a(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1ldwtbu"&&(B.textContent=Nl),Mt=i(e),A=a(e,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-1d3jabr"&&(A.innerHTML=El),pt=i(e),h=a(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1578lad"&&(h.textContent=Pl),rt=i(e),_=a(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-zavgkk"&&(_.innerHTML=Fl),ct=i(e),q=a(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-x4kr7z"&&(q.innerHTML=Dl),Tt=i(e),g=a(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1avsaye"&&(g.innerHTML=Kl),mt=i(e),G=a(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1doz4nr"&&(G.textContent=Ol),yt=i(e),L=a(e,"IMG",{src:!0,alt:!0}),Jt=i(e),$=a(e,"UL",{"data-svelte-h":!0}),o($)!=="svelte-134oyeu"&&($.innerHTML=ts),Ut=i(e),p(S.$$.fragment,e),wt=i(e),H=a(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-2xnaw2"&&(H.textContent=ls),dt=i(e),R=a(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1vubwmk"&&(R.innerHTML=ss),It=i(e),Q=a(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-t3ocl8"&&(Q.textContent=ns),jt=i(e),Z=a(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-10bnu1v"&&(Z.textContent=is),Ct=i(e),z=a(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1imfon4"&&(z.textContent=us),ft=i(e),p(X.$$.fragment,e),bt=i(e),V=a(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1diipdl"&&(V.innerHTML=as),vt=i(e),Y=a(e,"IMG",{src:!0,alt:!0}),xt=i(e),W=a(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1l232mj"&&(W.textContent=Ms),Bt=i(e),k=a(e,"OL",{"data-svelte-h":!0}),o(k)!=="svelte-mo4qti"&&(k.innerHTML=ps),At=i(e),N=a(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-geocds"&&(N.innerHTML=rs),ht=i(e),E=a(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12f7933"&&(E.textContent=cs),_t=i(e),P=a(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1b444o6"&&(P.innerHTML=Ts),qt=i(e),p(F.$$.fragment,e),gt=i(e),D=a(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-b5enmt"&&(D.innerHTML=ms),Gt=i(e),K=a(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-ym5xkp"&&(K.innerHTML=ys),Lt=i(e),O=a(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-i6tzj8"&&(O.textContent=Js),$t=i(e),ee=a(e,"UL",{"data-svelte-h":!0}),o(ee)!=="svelte-eem86h"&&(ee.innerHTML=Us),St=i(e),te=a(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1bsj63c"&&(te.textContent=ws),Ht=i(e),p(le.$$.fragment,e),Rt=i(e),se=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(se)!=="svelte-xgy7yp"&&(se.innerHTML=ds),Qt=i(e),ne=a(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-t0nt59"&&(ne.textContent=Is),Zt=i(e),ie=a(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1kxkz2u"&&(ie.textContent=js),zt=i(e),ue=a(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-ojbeji"&&(ue.textContent=Cs),Xt=i(e),p(ae.$$.fragment,e),Vt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-f16tzr"&&(oe.textContent=fs),Yt=i(e),Me=a(e,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-m90lk1"&&(Me.innerHTML=bs),Wt=i(e),pe=a(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1etx7od"&&(pe.textContent=vs),kt=i(e),re=a(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-fvbzuf"&&(re.innerHTML=xs),Nt=i(e),ce=a(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-dbo8tr"&&(ce.textContent=Bs),Et=i(e),Te=a(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-gayksv"&&(Te.innerHTML=As),Pt=i(e),p(me.$$.fragment,e),Ft=i(e),ye=a(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-fc7lom"&&(ye.innerHTML=hs),Dt=i(e),Je=a(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-15dwiii"&&(Je.textContent=_s),Kt=i(e),p(Ue.$$.fragment,e),Ot=i(e),we=a(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-41gbqm"&&(we.textContent=qs),el=i(e),p(de.$$.fragment,e),tl=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1ux3i79"&&(Ie.innerHTML=gs),ll=i(e),je=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(je)!=="svelte-pi7ybl"&&(je.innerHTML=Gs),sl=i(e),p(Ce.$$.fragment,e),nl=i(e),fe=a(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-v6nit1"&&(fe.innerHTML=Ls),il=i(e),be=a(e,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-19ugnw6"&&(be.innerHTML=$s),ul=i(e),ve=a(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-59sgl4"&&(ve.textContent=Ss),al=i(e),p(xe.$$.fragment,e),ol=i(e),Be=a(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1glbf26"&&(Be.innerHTML=Hs),Ml=i(e),Ae=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Ae)!=="svelte-1xl9l5i"&&(Ae.innerHTML=Rs),pl=i(e),w=a(e,"DETAILS",{});var Sl=Ql(w);Fe=a(Sl,"SUMMARY",{"data-svelte-h":!0}),o(Fe)!=="svelte-14dl2fo"&&(Fe.textContent=Qs),Rl=i(Sl),p(he.$$.fragment,Sl),Sl.forEach(l),rl=i(e),_e=a(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1p3ayi2"&&(_e.textContent=Zs),cl=i(e),p(qe.$$.fragment,e),Tl=i(e),ge=a(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-bs59s"&&(ge.innerHTML=zs),ml=i(e),p(Ge.$$.fragment,e),yl=i(e),Le=a(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-4itkv6"&&(Le.innerHTML=Xs),Jl=i(e),$e=a(e,"IMG",{src:!0,alt:!0}),Ul=i(e),Se=a(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-g2c2f3"&&(Se.innerHTML=Ys),wl=i(e),dl=a(e,"HR",{}),Il=i(e),He=a(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1cut2me"&&(He.textContent=Ws),jl=i(e),p(Re.$$.fragment,e),Cl=i(e),Qe=a(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-jag5v6"&&(Qe.innerHTML=ks),fl=i(e),Ze=a(e,"UL",{"data-svelte-h":!0}),o(Ze)!=="svelte-cvddem"&&(Ze.innerHTML=Ns),bl=i(e),ze=a(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1qj01zj"&&(ze.innerHTML=Es),vl=i(e),Xe=a(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-183ro16"&&(Xe.innerHTML=Ps),xl=i(e),Bl=a(e,"HR",{}),Al=i(e),Ve=a(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1cut2me"&&(Ve.textContent=Fs),hl=i(e),Ye=a(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-13rq5ja"&&(Ye.textContent=Ds),_l=i(e),We=a(e,"UL",{"data-svelte-h":!0}),o(We)!=="svelte-1i82t9i"&&(We.innerHTML=Ks),ql=i(e),ke=a(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-k59nnb"&&(ke.innerHTML=Os),gl=i(e),Ne=a(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-gu9wbg"&&(Ne.textContent=en),Gl=i(e),p(Ee.$$.fragment,e),Ll=i(e),Ke=a(e,"P",{}),Ql(Ke).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",rn),Hl(j.src,Xl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(j,"src",Xl),y(j,"alt","Planification de l'Unité 1"),Hl(L.src,es="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(L,"src",es),y(L,"alt","Météo"),Hl(Y.src,os="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y(Y,"src",os),y(Y,"alt","Prompt système pour les outils"),Hl($e.src,Vs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y($e,"src",Vs),y($e,"alt","Prompt système pour les outils")},m(e,t){Zl(document.head,J),s(e,Oe,t),s(e,De,t),s(e,et,t),r(d,e,t),s(e,tt,t),r(I,e,t),s(e,lt,t),s(e,j,t),s(e,st,t),s(e,C,t),s(e,nt,t),s(e,f,t),s(e,it,t),s(e,b,t),s(e,ut,t),r(v,e,t),s(e,at,t),s(e,x,t),s(e,ot,t),s(e,B,t),s(e,Mt,t),s(e,A,t),s(e,pt,t),s(e,h,t),s(e,rt,t),s(e,_,t),s(e,ct,t),s(e,q,t),s(e,Tt,t),s(e,g,t),s(e,mt,t),s(e,G,t),s(e,yt,t),s(e,L,t),s(e,Jt,t),s(e,$,t),s(e,Ut,t),r(S,e,t),s(e,wt,t),s(e,H,t),s(e,dt,t),s(e,R,t),s(e,It,t),s(e,Q,t),s(e,jt,t),s(e,Z,t),s(e,Ct,t),s(e,z,t),s(e,ft,t),r(X,e,t),s(e,bt,t),s(e,V,t),s(e,vt,t),s(e,Y,t),s(e,xt,t),s(e,W,t),s(e,Bt,t),s(e,k,t),s(e,At,t),s(e,N,t),s(e,ht,t),s(e,E,t),s(e,_t,t),s(e,P,t),s(e,qt,t),r(F,e,t),s(e,gt,t),s(e,D,t),s(e,Gt,t),s(e,K,t),s(e,Lt,t),s(e,O,t),s(e,$t,t),s(e,ee,t),s(e,St,t),s(e,te,t),s(e,Ht,t),r(le,e,t),s(e,Rt,t),s(e,se,t),s(e,Qt,t),s(e,ne,t),s(e,Zt,t),s(e,ie,t),s(e,zt,t),s(e,ue,t),s(e,Xt,t),r(ae,e,t),s(e,Vt,t),s(e,oe,t),s(e,Yt,t),s(e,Me,t),s(e,Wt,t),s(e,pe,t),s(e,kt,t),s(e,re,t),s(e,Nt,t),s(e,ce,t),s(e,Et,t),s(e,Te,t),s(e,Pt,t),r(me,e,t),s(e,Ft,t),s(e,ye,t),s(e,Dt,t),s(e,Je,t),s(e,Kt,t),r(Ue,e,t),s(e,Ot,t),s(e,we,t),s(e,el,t),r(de,e,t),s(e,tl,t),s(e,Ie,t),s(e,ll,t),s(e,je,t),s(e,sl,t),r(Ce,e,t),s(e,nl,t),s(e,fe,t),s(e,il,t),s(e,be,t),s(e,ul,t),s(e,ve,t),s(e,al,t),r(xe,e,t),s(e,ol,t),s(e,Be,t),s(e,Ml,t),s(e,Ae,t),s(e,pl,t),s(e,w,t),Zl(w,Fe),Zl(w,Rl),r(he,w,null),s(e,rl,t),s(e,_e,t),s(e,cl,t),r(qe,e,t),s(e,Tl,t),s(e,ge,t),s(e,ml,t),r(Ge,e,t),s(e,yl,t),s(e,Le,t),s(e,Jl,t),s(e,$e,t),s(e,Ul,t),s(e,Se,t),s(e,wl,t),s(e,dl,t),s(e,Il,t),s(e,He,t),s(e,jl,t),r(Re,e,t),s(e,Cl,t),s(e,Qe,t),s(e,fl,t),s(e,Ze,t),s(e,bl,t),s(e,ze,t),s(e,vl,t),s(e,Xe,t),s(e,xl,t),s(e,Bl,t),s(e,Al,t),s(e,Ve,t),s(e,hl,t),s(e,Ye,t),s(e,_l,t),s(e,We,t),s(e,ql,t),s(e,ke,t),s(e,gl,t),s(e,Ne,t),s(e,Gl,t),r(Ee,e,t),s(e,Ll,t),s(e,Ke,t),$l=!0},p:ln,i(e){$l||(c(d.$$.fragment,e),c(I.$$.fragment,e),c(v.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(me.$$.fragment,e),c(Ue.$$.fragment,e),c(de.$$.fragment,e),c(Ce.$$.fragment,e),c(xe.$$.fragment,e),c(he.$$.fragment,e),c(qe.$$.fragment,e),c(Ge.$$.fragment,e),c(Re.$$.fragment,e),c(Ee.$$.fragment,e),$l=!0)},o(e){T(d.$$.fragment,e),T(I.$$.fragment,e),T(v.$$.fragment,e),T(S.$$.fragment,e),T(X.$$.fragment,e),T(F.$$.fragment,e),T(le.$$.fragment,e),T(ae.$$.fragment,e),T(me.$$.fragment,e),T(Ue.$$.fragment,e),T(de.$$.fragment,e),T(Ce.$$.fragment,e),T(xe.$$.fragment,e),T(he.$$.fragment,e),T(qe.$$.fragment,e),T(Ge.$$.fragment,e),T(Re.$$.fragment,e),T(Ee.$$.fragment,e),$l=!1},d(e){e&&(l(Oe),l(De),l(et),l(tt),l(lt),l(j),l(st),l(C),l(nt),l(f),l(it),l(b),l(ut),l(at),l(x),l(ot),l(B),l(Mt),l(A),l(pt),l(h),l(rt),l(_),l(ct),l(q),l(Tt),l(g),l(mt),l(G),l(yt),l(L),l(Jt),l($),l(Ut),l(wt),l(H),l(dt),l(R),l(It),l(Q),l(jt),l(Z),l(Ct),l(z),l(ft),l(bt),l(V),l(vt),l(Y),l(xt),l(W),l(Bt),l(k),l(At),l(N),l(ht),l(E),l(_t),l(P),l(qt),l(gt),l(D),l(Gt),l(K),l(Lt),l(O),l($t),l(ee),l(St),l(te),l(Ht),l(Rt),l(se),l(Qt),l(ne),l(Zt),l(ie),l(zt),l(ue),l(Xt),l(Vt),l(oe),l(Yt),l(Me),l(Wt),l(pe),l(kt),l(re),l(Nt),l(ce),l(Et),l(Te),l(Pt),l(Ft),l(ye),l(Dt),l(Je),l(Kt),l(Ot),l(we),l(el),l(tl),l(Ie),l(ll),l(je),l(sl),l(nl),l(fe),l(il),l(be),l(ul),l(ve),l(al),l(ol),l(Be),l(Ml),l(Ae),l(pl),l(w),l(rl),l(_e),l(cl),l(Tl),l(ge),l(ml),l(yl),l(Le),l(Jl),l($e),l(Ul),l(Se),l(wl),l(dl),l(Il),l(He),l(jl),l(Cl),l(Qe),l(fl),l(Ze),l(bl),l(ze),l(vl),l(Xe),l(xl),l(Bl),l(Al),l(Ve),l(hl),l(Ye),l(_l),l(We),l(ql),l(ke),l(gl),l(Ne),l(Gl),l(Ll),l(Ke)),l(J),m(d,e),m(I,e),m(v,e),m(S,e),m(X,e),m(F,e),m(le,e),m(ae,e),m(me,e),m(Ue,e),m(de,e),m(Ce,e),m(xe,e),m(he),m(qe,e),m(Ge,e),m(Re,e),m(Ee,e)}}}const rn='{"title":"Que sont les outils ?","local":"que-sont-les-outils-","sections":[{"title":"Que sont les outils d’IA ?","local":"que-sont-les-outils-dia-","sections":[],"depth":2},{"title":"Comment fonctionnent les outils ?","local":"comment-fonctionnent-les-outils-","sections":[],"depth":2},{"title":"Comment fournir des outils à un LLM ?","local":"comment-fournir-des-outils-à-un-llm-","sections":[{"title":"Sections d’auto-formatage des outils","local":"sections-dauto-formatage-des-outils","sections":[],"depth":3},{"title":"Implémentation générique d’un outil","local":"implémentation-générique-dun-outil","sections":[],"depth":3},{"title":"Model Context Protocol (MCP) : une interface d’outils unifiée","local":"model-context-protocol-mcp--une-interface-doutils-unifiée","sections":[],"depth":3}],"depth":2}],"depth":1}';function cn(zl){return sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends nn{constructor(J){super(),un(this,J,cn,pn,tn,{})}}export{wn as component};
