# Introduction à LangGraph

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/LangGraph.png" alt="Unit 2.3 Thumbnail"/>

Bienvenue dans cette nouvelle partie de notre voyage, où vous allez apprendre **comment créer des applications** en utilisant le *framework* [`LangGraph`](https://github.com/langchain-ai/langgraph) conçu pour vous aider à structurer et orchestrer des *workflows* complexes avec des LLM.

`LangGraph` est un framework qui vous permet de créer des applications **prêtes pour la production** en vous donnant des outils de **contrôle** sur le flux de votre agent.

## Aperçu du module

Dans cette unité, vous découvrirez :

### 1️⃣ [Qu'est-ce que LangGraph et quand l'utiliser ?](./when_to_use_langgraph)
### 2️⃣ [Les composants de base de LangGraph](./building_blocks)
### 3️⃣ [Alfred, le majordome trieur de courrier](./first_graph)
### 4️⃣ [Alfred, l'agent d'analyse de documents](./document_analysis_agent)
### 5️⃣ [Quiz](./quiz1)

> [!WARNING]
> Les exemples de cette section nécessitent l'accès à un modèle LLM/VLM puissant. Nous les avons exécutés en utilisant l'API GPT-4o car elle offre la meilleure compatibilité avec LangGraph.

À la fin de cette unité, vous serez en mesure de créer des applications robustes, organisées et prêtes pour la production !

Cela étant dit, cette section est une introduction à LangGraph et des sujets plus avancés peuvent être découverts dans le cours gratuit de la *LangChain academy* : [*Introduction to LangGraph*](https://academy.langchain.com/courses/intro-to-langgraph).

Commençons !

## Ressources

- [*LangGraph Agents*](https://langchain-ai.github.io/langgraph/) - Exemples d'agents LangGraph
- [*LangChain academy*](https://academy.langchain.com/courses/intro-to-langgraph) - Cours complet sur LangGraph de LangChain


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/introduction.mdx" />