# Et maintenant ? Quels sujets devrais-je apprendre ?

L'IA agentique est un domaine en évolution rapide, et comprendre les protocoles fondamentaux est essentiel pour construire des systèmes intelligents et autonomes. 

Deux standards importants avec lesquels vous devriez vous familiariser sont :

- Le ***Model Context Protocol* (MCP)**  
- Le ***Agent-to-Agent Protocol* (A2A)**

## 🔌 *Model Context Protocol* (MCP)

Le ***Model Context Protocol* (MCP)** d'Anthropic est un standard ouvert qui permet aux modèles de se connecter de manière sécurisée et transparente **avec des outils externes, des sources de données et des applications**, rendant les agents plus compétents et autonomes.

Pensez à MCP comme un **adaptateur universel**, comme un port USB-C, qui permet aux modèles de se connecter à divers environnements numériques **sans avoir besoin d'intégration personnalisée pour chacun**.

MCP gagne rapidement en popularité dans l'industrie, avec des entreprises majeures comme *OpenAI* et *Google* qui commencent à l'adopter. 

📚 En savoir plus :
- [Annonce officielle et documentation d'Anthropic](https://www.anthropic.com/news/model-context-protocol)
- [MCP sur Wikipedia](https://en.wikipedia.org/wiki/Model_Context_Protocol)
- [Un article de blog sur MCP](https://huggingface.co/blog/Kseniase/mcp)
- [Le cours d'Hugging Face sur le sujet](https://huggingface.co/learn/mcp-course/unit0/introduction)

## 🤝 Protocole *Agent-to-Agent* (A2A)

Google a développé le **protocole *Agent-to-Agent* (A2A)** comme un complément au *Model Context Protocol* (MCP) d'Anthropic.

Alors que MCP connecte les agents aux outils externes, **A2A connecte les agents entre eux**, ouvrant la voie à des systèmes multi-agents coopératifs qui peuvent travailler ensemble pour résoudre des problèmes complexes.

📚 En savoir plus :  
- [L'annonce de Google](https://developers.googleblog.com/en/a2a-a-new-era-of-agent-interoperability/)

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/fr/unit4/additional-readings.mdx" />