# AI 에이전트 코스에 오신걸 환영합니다 🤗 [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="AI Agents Course thumbnail" width="100%"/>
<figcaption>이미지 배경은 <a href="https://scenario.com/">Scenario.com 을 활용하여 제작되었습니다.</a>
</figcaption>
</figure>


오늘날 AI에서 가장 흥미로운 주제인 **에이전트(Agents)**에 오신 것을 환영합니다!

이 무료 코스에서는 **초급부터 전문가 수준**까지, AI 에이전트를 이해하고 활용하며 직접 구축하는 방법을 배울 수 있습니다.

첫 번째 유닛에서는 다음과 같은 내용을 다룹니다:

- **강의 커리큘럼** 살펴보기
- **수강 방식 선택** (자기주도 학습 또는 인증 과정)
- **인증 과정 및 마감일 정보**
- 코스 운영팀 소개
- **Hugging Face** 계정 만들기.
- **Discord 서버** 가입하고 다른 학습자 및 강사들과 소통하기 

지금 바로 시작해 보세요!

## 이 코스에서 무엇을 배울 수 있나요? [[expect]]

해당 코스에서는 다음과 같은 내용을 학습합니다:

- 📖 AI 에이전트의 **이론, 설계, 실전 활용**에 대해 공부합니다.
- 🧑‍💻 [smolagents](https://huggingface.co/docs/smolagents/en/index), [LangChain](https://www.langchain.com/), and [LlamaIndex](https://www.llamaindex.ai/)  등의 **AI 에이전트 라이브러리** 활용법을 배웁니다.
- 💾 Hugging Face Hub에 **자신이 만든 에이전트**를 공유하고, 커뮤니티에서 제작한 에이전트를 탐색합니다.
- 🏆 **다른 학습자의 에이전트와 비교 평가**하는 챌린지에 참여합니다.
- 🎓 과제를 완료하면 **수료 인증서**를 받을 수 있습니다.

그 외에도 다양한 내용을 다룹니다!

이 코스를 마치면 **AI 에이전트의 동작 원리를 이해하고, 최신 라이브러리와 도구를 활용하여 직접 구현하는 방법**을 익히게 됩니다.

👉 <a href="https://bit.ly/hf-learn-agents">지금 바로 코스에 등록하세요!</a>

(HuggingFace는 개인정보 보호를 존중합니다. 이메일 주소는 **각 단원 공개시 링크, 챌린지 및 업데이트 정보**를 제공하는 용도로만 사용됩니다.)

## 이 코스는 어떻게 진행되나요? [[course-look-like]]

이 코스는 다음과 같이 구성됩니다:

- *기본 개념 학습*: 에이전트 개념을 **이론적**으로 배우는 단계입니다.
- *실습*:  **기존 AI 에이전트 라이브러리**를 활용해 특정 환경에서 에이전트를 훈련하는 방법을 배웁니다. 실습은 사전 구성된 환경을 제공하는 **Hugging Face Spaces**에서 진행됩니다.
- *실전 적용 과제*: 배운 개념을 활용해 현실 문제를 해결하는 과제입니다. 
- *챌린지*: 여러분이 개발한 에이전트를 다른 에이전트와 경쟁시켜 볼 수 있습니다. 또한, 에이전트 성능을 비교할 수 있는 [리더보드](https://huggingface.co/spaces/huggingface-projects/AI-Agents-Leaderboard) 도 곧 제공될 예정입니다.

**에이전트 코스는 여러분의 피드백과 기여를 통해 발전되는 프로젝트입니다 !**  [GitHub에서 이슈나 PR을 제출하거나](https://github.com/huggingface/agents-course), Discord 에서 토론에 참여해주세요!

코스를 완료한 후에는  [👉 이 폼](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog) 을 통해 피드백을 보낼 수 있습니다.

## 코스 개요 [[syllabus]]

 **전체적인 코스 커리큘럼**입니다.  각 단원 세부 주제 목록들은 해당 단원 공개 시 함께 제공됩니다.

| 단원 | 주제 | 설명 |
| :---- | :---- | :---- |
| 0 | 온보딩 | 강의에서 사용할 도구 및 플랫폼을 설정합니다. |
| 1 | 에이전트 기본 개념 | 도구, 사고 과정, 행동, 관찰 및 해당 형식에 대해 설명합니다.  또한 LLM, 메세지, 특수 토큰, 채팅 템플릿에 대해 설명하고,  python 함수를 도구로 사용하는 간단한 사례를 소개합니다. |
| 1.5 | Bonus : 함수 호출을 위한 LLM 미세 조정 | LoRa 를 사용하여 노트북 내에서 함수 호출을 수행하는 모델을 미세 조정합니다. |
| 2 | 프레임워크 | 기본 개념이 인기 라이브러리 smolagents, LangGraph, LLamaIndex 에서 어떻게 구현되는지 살펴봅니다. |
| 3 | 실전 적용 사례 | 실제 활용 사례를 구현해봅니다. (경험이 있는 에이전트 개발자분들의 PR 환영 🤗) |
| 4 | 최종 과제 | 특정 벤치마크를 위한 에이전트를 구현하고, 학생 리더보드에서 성능을 평가합니다. 🚀 |

*보너스 단원도 제공되니 기대해 주세요!*

## 선수 지식 [[what-are-the-prerequisites]]

이 코스를 완주하기 위해 다음과 같은 기본 지식이 필요합니다:

- Python 기본지식
- LLM 기본 개념 (1단원에서 LLM 복습 섹션을 제공합니다.)


## 필요 도구 [[tools]]

코스를 수강하기 위해 단 2가지만 필요합니다:

- *인터넷이 연결된 컴퓨터*
- *Hugging Face 계정*: 모델 및 에이전트를 푸쉬/업로드하고 Spaces를 생성하는 데 필요합니다. 계정이 없으시다면, **[이곳](https://hf.co/join)** 에서 무료로 생성 할 수 있습니다. 
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Course tools needed" width="100%"/>

## 인증 과정 [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Two paths" width="100%"/>

이 코스는 *자유 수강 모드*로 진행할 수도 있고, 활동을 수행하여 *두 가지 인증서 중 하나*를 받을 수도 있습니다.

자유 수강 모드에서는 원하는 경우 과제와 챌린지에 참여할 수 있으며, **별도로 인증을 신청할 필요가 없습니다.**

인증 과정은 **무료**입니다:

- *기본 개념 인증서*: 1단원을 완료해야합니다. *최신 에이전트 트렌드를 배우고자 하는 학생들을 위한 과정*
- *완료 인증서*: 1단원, 실전 활용 사례 과제 중 하나, 최종 과제를 완료해야합니다.

인증 과정에는 마감기한이 있으며, 모든 과제는**2025년 5월 1일 이전에** 완료해야 합니다.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/deadline.jpg" alt="Deadline" width="100%"/>

## 권장 학습 속도 [[recommended-pace]]

코스 각 단원은 **1주일 이내**에 완료할 수 있도록 설계되었으며, **주당 약 3-4시간**의 학습 시간이 필요합니다.

인증 과정 마감 기한이 있기 때문에, 권장 학습 속도를 제공해드립니다! 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Recommended Pace" width="100%"/>

## 코스 최대한 활용하는 방법 [[advice]]

코스를 최대한 활용할 수 있는 방법을 제안해 드립니다:

1. <a href="https://discord.gg/UrrTSsSyjb"> Discord에서 스터디 그룹에 참여하세요.</a>: 그룹으로 학습하는 것이 효과적입니다. 지금 바로 Discord 서버에 가입하고 Hugging Face 계정을 인증하세요!
2. **퀴즈와 과제를 수행하세요**: 가장 좋은 학습 방법은 실습과 자기 평가입니다.
3. **일정을 정하고 꾸준히 학습하세요**: 아래 권장 학습 속도를 참고하시거나, 자신만의 일정을 만들어 보세요..

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Course advice" width="100%"/>

## 우리는 누구인가 [[who-are-we]]

저자 소개:

### Joffrey Thomas [[joffrey-thomas]]

Joffrey는 Hugging Face의 머신러닝 엔지니어로, AI 에이전트를 구현하고 실제 환경에 배포한 경험이 있습니다. Joffrey는 이 코스의 메인 강사입니다.

- [Joffrey Hugging Face에서 팔로우 하기](https://huggingface.co/Jofthomas)
- [Joffrey X에서 팔로우 하기](https://x.com/Jthmas404)
- [Joffrey Linkedin에서 팔로우 하기](https://www.linkedin.com/in/joffrey-thomas/)

### Ben Burtenshaw [[ben-burtenshaw]]

Ben은 Hugging Face의 머신러닝 엔지니어로, 다양한 플랫폼에서 강의 경험이 있습니다. Ben의 목표는 이 코스를 모든 사람이 접근할 수 있도록 만드는 것 입니다.

- [Ben Hugging Face에서 팔로우 하기](https://huggingface.co/burtenshaw)
- [Ben X에서 팔로우 하기](https://x.com/ben_burtenshaw)
- [Ben Linkedin에서 팔로우 하기](https://www.linkedin.com/in/ben-burtenshaw/)

### Thomas Simonini [[thomas-simonini]]

Thomas는 Hugging Face의 머신러닝 엔지니어로, HuggingFace의 <a href="https://huggingface.co/learn/deep-rl-course/unit0/introduction">Deep RL</a>코스와 <a href="https://huggingface.co/learn/ml-games-course/en/unit0/introduction">ML for games</a> 코스를 진행했습니다. Thomas는 에이전트의 큰 팬으로, 커뮤니티가 무엇을 만들지 기대하고 있습니다! 

- [Thomas Hugging Face에서 팔로우 하기 ](https://huggingface.co/ThomasSimonini)
- [Thomas X에서 팔로우 하기](https://x.com/ThomasSimonini)
- [Thomas Linkedin에서 팔로우 하기](https://www.linkedin.com/in/simoninithomas/)

## 감사의 말씀  [[acknowledgments]]

이 코스에 중요한 기여를 해주신 다음 분들께 감사의 말씀을 전합니다:

- **[Pedro Cuenca](https://huggingface.co/pcuenq)** – 자료 검토 지도와 전문적인 도움
- **[Aymeric Roucher](https://huggingface.co/m-ric)** – 디코딩 및 최종 에이전트 데모 스페이스와 smolagents 파트 도움 
- **[Joshua Lochner](https://huggingface.co/Xenova)** – 토큰화 데모 스페이스
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** – 코스 내용에 대한 도움
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** – 코스 내용 및 조정 도움

## 버그 발견& 강의 개선점 제안! [[contribute]]

기여는 **환영**입니다 🤗

- 만약 *노트북에서 버그🐛*를 발견하셨다면, <a href="https://github.com/huggingface/agents-course/issues">이슈</a>를 열고 **문제를 설명해주세요**.
- 만약 *코스를 개선하고 싶다면*, <a href="https://github.com/huggingface/agents-course/pulls"> 풀 리쿼스트</a>를 열어주세요.
- *전체 섹션 또는 새로운 단원*을 추가하고 싶다면, 가장 좋은 방법은<a href="https://github.com/huggingface/agents-course/issues">이슈</a>를 열고 **추가하고 싶은 내용을 설명해주세요! 이후 저희가 내용 작성을 시작하실 수 있도록 안내해드리겠습니다.**

## 그 외에도 질문이 있으시다면? [[questions]]

 <a href="https://discord.gg/UrrTSsSyjb">discord 서버의 #ai-agents-discussions.</a>채널에 질문을 남겨주세요.


코스 학습에 앞서 필요한 모든 정보를 습득하셨으니, 출발 준비를 해봅시다!⛵ 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Time to Onboard" width="100%"/>



<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ko/unit0/introduction.mdx" />