# Мысль: Внутреннее Рассуждение и Re-Act подход

> [!TIP]
> В этом разделе мы погрузимся во внутреннюю работу AI агента - его способность рассуждать и планировать. Мы рассмотрим, как агент использует свой внутренний диалог для анализа информации, разбиения комплексных проблем на управляемые шаги и принятия решения о том, какие действия следует предпринять дальше. Кроме того, мы представим подход Re-Act - технику подсказок, которая побуждает модель думать «шаг за шагом», прежде чем действовать.

Мысли представляют собой внутренние процессы **рассуждения и планирования** агента для решения задачи.

При этом используется способность Большой Языковой Модели (Large Language Model, LLM) агента **анализировать информацию, представленную в подсказке**.

Считайте это внутренним диалогом агента, в ходе которого он обдумывает поставленную задачу и разрабатывает стратегию действий.

Мысли Агента отвечают за доступ к текущим наблюдениям и решение о том, каким должно быть следующее действие (действия).

Благодаря этому процессу агент может **разбивать сложные проблемы на более мелкие и управляемые шаги**, рефлексировать над прошлым опытом и постоянно корректировать свои планы основываясь на новой информации.

Вот несколько примеров общих мыслей:

| Тип мышления | Пример |
|----------------|---------|
| Планирование | "Мне нужно разбить эту задачу на три этапа: 1) собрать данные, 2) проанализировать тенденции, 3) создать отчет"|   
| Анализ | "Судя по сообщению об ошибке, проблема заключается в параметрах подключения к базе данных" |   
| Принятие решений | "Учитывая бюджетные ограничения пользователя, я должен рекомендовать вариант среднего уровня"|   
| Решение проблем | "Чтобы оптимизировать этот код, я должен сначала профилировать его, чтобы выявить узкие места" |   
| Интеграция памяти | "Пользователь ранее упоминал, что предпочитает Python, поэтому я приведу примеры на Python"|
| Саморефлексия | "Мой последний подход не сработал, я должен попробовать другую стратегию"|    
| Постановка цели | "Чтобы выполнить эту задачу, мне нужно сначала установить критерии приемки" |    
| Приоритизация | "Уязвимость безопасности должна быть устранена до добавления новых функций" |    

> **Примечание:** В случае дообучения LLM вызову функций, процесс мышления необязателен.
> *Если вы не знакомы с вызовом функций, более подробно об этом будет рассказано в разделе Действия.*

## Подход Re-Act

Ключевым методом является **ReAct подход**, который представляет собой конкатенацию " Рассуждения (Reasoning)" (Мысли) и "Действия (Acting)". 

ReAct - это простая техника подсказки, которая добавляет «Давайте думать шаг за шагом», прежде чем позволить LLM декодировать следующие токены. 

Действительно, побуждение модели думать "шаг за шагом" стимулирует процесс декодирования следующих токенов **которые генерируют план**, а не окончательное решение, поскольку модель поощряется **декомпозировать** проблему на *подзадачи*.

Это позволяет модели рассматривать подзадачи более детально, что в целом приводит к меньшему количеству ошибок, чем при попытке непосредственно сгенерировать окончательное решение.

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/ReAct.png" alt="ReAct"/>
<figcaption>(d) - это пример подхода Re-Act, когда мы подсказываем: " Давай думать шаг за шагом".
</figcaption>
</figure>

> [!TIP]
> В последнее время мы наблюдаем большой интерес к стратегиям рассуждений. Именно это лежит в основе таких моделей, как Deepseek R1 или OpenAI o1, которые были дообучены "думать перед ответом".
>
> Эти модели были обучены всегда включать определенные секции _размышлений_ (заключенные между специальными токенами `<think>` и `</think>`). Это не просто техника подсказки, как в ReAct, а метод обучения, при котором модель учится генерировать эти секции после анализа тысяч примеров, которые показывают, чего мы от нее ожидаем.

--- 
Теперь, когда мы лучше понимаем процесс Мышления, давайте углубимся во вторую часть процесса: Действие.


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/thoughts.mdx" />