import{s as ks,n as Fs,o as Vs}from"../chunks/scheduler.505acc25.js";import{S as Ys,i as Zs,e as a,s as M,c as n,h as Ws,a as J,d as t,b as e,f as Js,g as T,j as w,k as ns,l as Ts,m as U,n as y,t as j,o as p,p as i}from"../chunks/index.b1175496.js";import{C as $s,H as C}from"../chunks/Heading.eda51538.js";import{C as m}from"../chunks/CodeBlock.9d480d26.js";import{E as Ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea377ea6.js";function Ns(ys){let I,pl,yl,il,c,wl,h,Cl,g,js="Alfred 为您服务。作为韦恩先生值得信赖的管家，我已记录下协助处理各类文档需求的工作流程。当 Mr Wayne 外出进行…夜间活动时，我会确保所有文件、训练计划和营养方案都得到妥善分析和整理。",ml,r,ps="在离开前，他留下了本周训练计划的笔记。我随后负责拟定了明日餐点的<strong>菜单</strong>。",Il,u,is="为应对未来的类似需求，让我们使用 LangGraph 构建一个文档分析系统来服务 Mr Wayne。该系统能够：",ol,A,ws="<li>处理图像文档</li> <li>使用视觉模型 (Vision Language Model) 提取文本</li> <li>在需要时执行计算（用于演示常规工具）</li> <li>分析内容并提供简明摘要</li> <li>执行与文档相关的特定指令</li>",cl,d,hl,Q,Cs="我们将构建的工作流程遵循以下结构化方案：",gl,b,ms='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',rl,o,Tl,Is='您可以在 <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb" target="_blank">这个 notebook</a> 中查看代码，并通过 Google Colab 运行。',as,B,ul,R,Al,E,os="and imports :",dl,G,Ql,f,bl,k,cs=`这个状态比我们之前见过的稍微复杂些。
AnyMessage 是来自 langchain 的类，用于定义消息，而 add_messages 是一个操作符，它会添加最新消息而不是覆盖现有状态。`,Bl,F,hs="这是 langGraph 中的一个新概念，您可以在状态中添加 operators 来定义它们之间的交互方式。",Rl,V,El,Y,Gl,Z,fl,W,kl,$,Fl,S,Vl,N,gs="请允许我解释该智能体的工作方式。该智能体遵循被称为 ReAct 的模式（推理-行动-观察）",Yl,O,rs="<li><strong>推理</strong> 分析文档和请求内容</li> <li><strong>行动</strong> 通过调用合适的工具执行操作</li> <li><strong>观察</strong> 工具执行结果</li> <li><strong>重复</strong> 上述步骤直到完全满足需求</li>",Zl,x,us="这是使用 langGraph 实现的简单智能体实现。",Wl,_,$l,v,As='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Sl,X,Nl,z,Ol,q,ds="在以下示例中，我们添加这个 divide 示例仅作为演示用途。",xl,D,_l,H,Qs="对话将会继续：",vl,L,Xl,P,zl,K,bs="当 Wayne 大师留下他的训练和​​用餐笔记时：",ql,ll,Dl,sl,Bs="交互将进行：",Hl,tl,Ll,Ul,Pl,Ml,Rs="若您希望创建自己的文档分析管家，请遵循以下关键原则：",Kl,el,Es="<li><strong>定义清晰的工具</strong>（Define clear tools）用于特定文档相关任务</li> <li><strong>创建强大的状态跟踪器</strong>（Create a robust state tracker）以保持工具调用之间的上下文</li> <li><strong>考虑错误处理机制</strong>（Consider error handling）应对工具调用失败</li> <li><strong>保持上下文感知能力</strong>（Maintain contextual awareness）通过 add_messages 操作符确保历史交互的连贯性</li>",ls,al,Gs="遵循这些原则，您也能提供符合韦恩庄园标准的卓越文档分析服务。",ss,Jl,fs="<em>相信以上解释已足够详尽。恕我失陪，韦恩老爷的披风还需在夜巡前熨烫妥当。</em>",ts,nl,Us,jl,Ms;return c=new $s({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new C({props:{title:"文档分析图",local:"文档分析图",headingTag:"h1"}}),d=new C({props:{title:"管家的工作流程",local:"管家的工作流程",headingTag:"h2"}}),B=new C({props:{title:"设置环境",local:"设置环境",headingTag:"h2"}}),R=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBQaWxsb3clMjBiYXNlNjQlMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai Pillow base64 langchain_core",wrap:!1}}),G=new m({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW4uc2NoZW1hJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwQW55TWVzc2FnZSUyQyUyMFN5c3RlbU1lc3NhZ2UlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoLm1lc3NhZ2UlMjBpbXBvcnQlMjBhZGRfbWVzc2FnZXMlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoJTIwaW1wb3J0JTIwU1RBUlQlMkMlMjBTdGF0ZUdyYXBoJTBBZnJvbSUyMGxhbmdncmFwaC5wcmVidWlsdCUyMGltcG9ydCUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain.schema <span class="hljs-keyword">import</span> HumanMessage
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),f=new C({props:{title:"定义智能体的状态",local:"定义智能体的状态",headingTag:"h2"}}),V=new m({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTYlOEYlOTAlRTQlQkUlOUIlRTclOUElODQlRTYlOTYlODclRTQlQkIlQjYlMEElMjAlMjAlMjAlMjBpbnB1dF9maWxlJTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlMjAlMjMlMjBDb250YWlucyUyMGZpbGUlMjBwYXRoJTIwKFBERiUyRlBORyklMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMEFubm90YXRlZCU1Qmxpc3QlNUJBbnlNZXNzYWdlJTVEJTJDJTIwYWRkX21lc3NhZ2VzJTVE",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># 提供的文件</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contains file path (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),Y=new C({props:{title:"准备工具",local:"准备工具",headingTag:"h2"}}),Z=new m({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extract text from an image file using a multimodal model.
    
    Master Wayne often leaves notes with his training regimen or meal plans.
    This allows me to properly analyze the contents.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># 读取图像并编码为 base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># 准备包含 base64 图像数据的提示</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extract all the text from this image. &quot;</span>
                            <span class="hljs-string">&quot;Return only the extracted text, no explanations.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># 调用具有视觉功能的模型</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># 附加提取的文本</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># 管家应优雅地处理错误</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a and b - for Master Wayne&#x27;s occasional calculations.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># 为管家配备工具</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),W=new C({props:{title:"节点",local:"节点",headingTag:"h2"}}),$=new m({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTclQjMlQkIlRTclQkIlOUYlRTYlQjYlODglRTYlODElQUYlMEElMjAlMjAlMjAlMjB0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlM0QlMjIlMjIlMjIlMEFleHRyYWN0X3RleHQoaW1nX3BhdGglM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMEV4dHJhY3QlMjB0ZXh0JTIwZnJvbSUyMGFuJTIwaW1hZ2UlMjBmaWxlJTIwdXNpbmclMjBhJTIwbXVsdGltb2RhbCUyMG1vZGVsLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWdfcGF0aCUzQSUyMEElMjBsb2NhbCUyMGltYWdlJTIwZmlsZSUyMHBhdGglMjAoc3RyaW5ncykuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEElMjBzaW5nbGUlMjBzdHJpbmclMjBjb250YWluaW5nJTIwdGhlJTIwY29uY2F0ZW5hdGVkJTIwdGV4dCUyMGV4dHJhY3RlZCUyMGZyb20lMjBlYWNoJTIwaW1hZ2UuJTBBZGl2aWRlKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBmbG9hdCUzQSUwQSUyMCUyMCUyMCUyMERpdmlkZSUyMGElMjBhbmQlMjBiJTBBJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RzdGF0ZSU1QiUyMmlucHV0X2ZpbGUlMjIlNUQlMEElMjAlMjAlMjAlMjBzeXNfbXNnJTIwJTNEJTIwU3lzdGVtTWVzc2FnZShjb250ZW50JTNEZiUyMllvdSUyMGFyZSUyMGFuJTIwaGVscGZ1bCUyMGJ1dGxlciUyMG5hbWVkJTIwQWxmcmVkJTIwdGhhdCUyMHNlcnZlcyUyME1yLiUyMFdheW5lJTIwYW5kJTIwQmF0bWFuLiUyMFlvdSUyMGNhbiUyMGFuYWx5c2UlMjBkb2N1bWVudHMlMjBhbmQlMjBydW4lMjBjb21wdXRhdGlvbnMlMjB3aXRoJTIwcHJvdmlkZWQlMjB0b29scyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwWW91JTIwaGF2ZSUyMGFjY2VzcyUyMHRvJTIwc29tZSUyMG9wdGlvbmFsJTIwaW1hZ2VzLiUyMEN1cnJlbnRseSUyMHRoZSUyMGxvYWRlZCUyMGltYWdlJTIwaXMlM0ElMjAlN0JpbWFnZSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QmxsbV93aXRoX3Rvb2xzLmludm9rZSglNUJzeXNfbXNnJTVEJTIwJTJCJTIwc3RhdGUlNUIlMjJtZXNzYWdlcyUyMiU1RCklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># 系统消息</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extract text from an image file using a multimodal model.

    Args:
        img_path: A local image file path (strings).

    Returns:
        A single string containing the concatenated text extracted from each image.
divide(a: int, b: int) -&gt; float:
    Divide a and b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;You are an helpful butler named Alfred that serves Mr. Wayne and Batman. You can analyse documents and run computations with provided tools:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n You have access to some optional images. Currently the loaded image is: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),S=new C({props:{title:"ReAct 模式：我如何协助 Wayne 先生",local:"react-模式我如何协助-wayne-先生",headingTag:"h2"}}),_=new m({props:{code:"JTIzJTIzJTIwVGhlJTIwZ3JhcGglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMCVFNSVBRSU5QSVFNCVCOSU4OSVFOCU4QSU4MiVFNyU4MiVCOSVFRiVCQyU5QSVFOCVCRiU5OSVFNCVCQSU5QiVFOCU4QSU4MiVFNyU4MiVCOSVFNSVBRSU4QyVFNiU4OCU5MCVFNSVCNyVBNSVFNCVCRCU5QyUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwJUU1JUFFJTlBJUU0JUI5JTg5JUU4JUJFJUI5JUVGJUJDJTlBJUU4JUJGJTk5JUU0JUJBJTlCJUU1JTg2JUIzJUU1JUFFJTlBJUU0JUJBJTg2JUU2JThFJUE3JUU1JTg4JUI2JUU2JUI1JTgxJUU1JUE2JTgyJUU0JUJEJTk1JUU3JUE3JUJCJUU1JThBJUE4JTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlQTYlODIlRTYlOUUlOUMlRTYlOUMlODAlRTYlOTYlQjAlRTYlQjYlODglRTYlODElQUYlRTklOUMlODAlRTglQTYlODElRTUlQjclQTUlRTUlODUlQjclRUYlQkMlOEMlRTUlODglOTklRTglQjclQUYlRTclOTQlQjElRTglODclQjMlRTUlQjclQTUlRTUlODUlQjclMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOTAlQTYlRTUlODglOTklRUYlQkMlOEMlRTglQUYlQjclRTclOUIlQjQlRTYlOEUlQTUlRTUlOUIlOUUlRTUlQTQlOEQlMEElMjAlMjAlMjAlMjB0b29sc19jb25kaXRpb24lMkMlMEEpJTBBYnVpbGRlci5hZGRfZWRnZSglMjJ0b29scyUyMiUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFyZWFjdF9ncmFwaCUyMCUzRCUyMGJ1aWxkZXIuY29tcGlsZSgpJTBBJTBBJTIzJTIwJUU1JUIxJTk1JUU3JThFJUIwJUU3JUFFJUExJUU1JUFFJUI2JUU3JTlBJTg0JUU2JTgwJTlEJUU4JTgwJTgzJUU4JUJGJTg3JUU3JUE4JThCJTBBZGlzcGxheShJbWFnZShyZWFjdF9ncmFwaC5nZXRfZ3JhcGgoeHJheSUzRFRydWUpLmRyYXdfbWVybWFpZF9wbmcoKSkp",highlighted:`<span class="hljs-comment">## The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># 定义节点：这些节点完成工作</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># 定义边：这些决定了控制流如何移动</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># 如果最新消息需要工具，则路由至工具</span>
    <span class="hljs-comment"># 否则，请直接回复</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># 展现管家的思考过程</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),X=new C({props:{title:"管家实战示例",local:"管家实战示例",headingTag:"h2"}}),z=new C({props:{title:"示例1：简单计算",local:"示例1简单计算",headingTag:"h3"}}),D=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBieSUyMDUlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBOb25lJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 by 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})`,wrap:!1}}),L=new m({props:{code:"SHVtYW4lM0ElMjBEaXZpZGUlMjA2NzkwJTIwYnklMjA1JTBBJTBBQUklMjBUb29sJTIwQ2FsbCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQVRvb2wlMjBSZXNwb25zZSUzQSUyMDEzNTguMCUwQSUwQUFsZnJlZCUzQSUyMFRoZSUyMHJlc3VsdCUyMG9mJTIwZGl2aWRpbmclMjA2NzkwJTIwYnklMjA1JTIwaXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Human</span>: Divide <span class="hljs-number">6790</span> by <span class="hljs-number">5</span>

<span class="hljs-attribute">AI</span> Tool Call: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Tool</span> Response: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: The result of dividing <span class="hljs-number">6790</span> by <span class="hljs-number">5</span> is <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),P=new C({props:{title:"示例 2：分析 Wayne 大师的训练文档",local:"示例-2分析-wayne-大师的训练文档",headingTag:"h3"}}),ll=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkFjY29yZGluZyUyMHRvJTIwdGhlJTIwbm90ZSUyMHByb3ZpZGVkJTIwYnklMjBNci4lMjBXYXluZSUyMGluJTIwdGhlJTIwcHJvdmlkZWQlMjBpbWFnZXMuJTIwV2hhdCdzJTIwdGhlJTIwbGlzdCUyMG9mJTIwaXRlbXMlMjBJJTIwc2hvdWxkJTIwYnV5JTIwZm9yJTIwdGhlJTIwZGlubmVyJTIwbWVudSUzRiUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMCUyMkJhdG1hbl90cmFpbmluZ19hbmRfbWVhbHMucG5nJTIyJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;According to the note provided by Mr. Wayne in the provided images. What&#x27;s the list of items I should buy for the dinner menu?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),tl=new m({props:{code:"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",highlighted:`用户：根据 Wayne 先生在提供的图像中的注释。我应该为晚餐菜单购买哪些物品？

AI<span class="hljs-built_in"> Tool </span>Call: extract_text(<span class="hljs-attribute">img_path</span>=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)
<span class="hljs-built_in">
Tool </span>Response: [包含训练计划和菜单详情的提取文本]

Alfred：根据晚餐菜单，您应该购买以下物品：

1. 草饲本地西冷牛排（Grass-fed local sirloin steak）
2. 有机菠菜（Organic spinach）
3. 皮克略辣椒（Piquillo peppers） 
4. 土豆（用于烤制金黄香草土豆）
5. 鱼油（2 克）

确保牛排是草饲的，并且菠菜和辣椒是有机的，以获得最佳品质的餐点。`,wrap:!1}}),Ul=new C({props:{title:"关键要点",local:"关键要点",headingTag:"h2"}}),nl=new Ss({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){I=a("meta"),pl=M(),yl=a("p"),il=M(),n(c.$$.fragment),wl=M(),n(h.$$.fragment),Cl=M(),g=a("p"),g.textContent=js,ml=M(),r=a("p"),r.innerHTML=ps,Il=M(),u=a("p"),u.textContent=is,ol=M(),A=a("ol"),A.innerHTML=ws,cl=M(),n(d.$$.fragment),hl=M(),Q=a("p"),Q.textContent=Cs,gl=M(),b=a("p"),b.innerHTML=ms,rl=M(),o=a("blockquote"),Tl=a("p"),Tl.innerHTML=Is,as=M(),n(B.$$.fragment),ul=M(),n(R.$$.fragment),Al=M(),E=a("p"),E.textContent=os,dl=M(),n(G.$$.fragment),Ql=M(),n(f.$$.fragment),bl=M(),k=a("p"),k.textContent=cs,Bl=M(),F=a("p"),F.textContent=hs,Rl=M(),n(V.$$.fragment),El=M(),n(Y.$$.fragment),Gl=M(),n(Z.$$.fragment),fl=M(),n(W.$$.fragment),kl=M(),n($.$$.fragment),Fl=M(),n(S.$$.fragment),Vl=M(),N=a("p"),N.textContent=gs,Yl=M(),O=a("ol"),O.innerHTML=rs,Zl=M(),x=a("p"),x.textContent=us,Wl=M(),n(_.$$.fragment),$l=M(),v=a("p"),v.innerHTML=As,Sl=M(),n(X.$$.fragment),Nl=M(),n(z.$$.fragment),Ol=M(),q=a("p"),q.textContent=ds,xl=M(),n(D.$$.fragment),_l=M(),H=a("p"),H.textContent=Qs,vl=M(),n(L.$$.fragment),Xl=M(),n(P.$$.fragment),zl=M(),K=a("p"),K.textContent=bs,ql=M(),n(ll.$$.fragment),Dl=M(),sl=a("p"),sl.textContent=Bs,Hl=M(),n(tl.$$.fragment),Ll=M(),n(Ul.$$.fragment),Pl=M(),Ml=a("p"),Ml.textContent=Rs,Kl=M(),el=a("ol"),el.innerHTML=Es,ls=M(),al=a("p"),al.textContent=Gs,ss=M(),Jl=a("p"),Jl.innerHTML=fs,ts=M(),n(nl.$$.fragment),Us=M(),jl=a("p"),this.h()},l(l){const s=Ws("svelte-u9bgzb",document.head);I=J(s,"META",{name:!0,content:!0}),s.forEach(t),pl=e(l),yl=J(l,"P",{}),Js(yl).forEach(t),il=e(l),T(c.$$.fragment,l),wl=e(l),T(h.$$.fragment,l),Cl=e(l),g=J(l,"P",{"data-svelte-h":!0}),w(g)!=="svelte-j7qwy"&&(g.textContent=js),ml=e(l),r=J(l,"P",{"data-svelte-h":!0}),w(r)!=="svelte-bhamdi"&&(r.innerHTML=ps),Il=e(l),u=J(l,"P",{"data-svelte-h":!0}),w(u)!=="svelte-bcok6p"&&(u.textContent=is),ol=e(l),A=J(l,"OL",{"data-svelte-h":!0}),w(A)!=="svelte-2x2gky"&&(A.innerHTML=ws),cl=e(l),T(d.$$.fragment,l),hl=e(l),Q=J(l,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-g72w59"&&(Q.textContent=Cs),gl=e(l),b=J(l,"P",{"data-svelte-h":!0}),w(b)!=="svelte-g7cpwr"&&(b.innerHTML=ms),rl=e(l),o=J(l,"BLOCKQUOTE",{class:!0});var es=Js(o);Tl=J(es,"P",{"data-svelte-h":!0}),w(Tl)!=="svelte-8okjg5"&&(Tl.innerHTML=Is),as=e(es),T(B.$$.fragment,es),es.forEach(t),ul=e(l),T(R.$$.fragment,l),Al=e(l),E=J(l,"P",{"data-svelte-h":!0}),w(E)!=="svelte-1ey17wx"&&(E.textContent=os),dl=e(l),T(G.$$.fragment,l),Ql=e(l),T(f.$$.fragment,l),bl=e(l),k=J(l,"P",{"data-svelte-h":!0}),w(k)!=="svelte-15ot7z4"&&(k.textContent=cs),Bl=e(l),F=J(l,"P",{"data-svelte-h":!0}),w(F)!=="svelte-ay1eqk"&&(F.textContent=hs),Rl=e(l),T(V.$$.fragment,l),El=e(l),T(Y.$$.fragment,l),Gl=e(l),T(Z.$$.fragment,l),fl=e(l),T(W.$$.fragment,l),kl=e(l),T($.$$.fragment,l),Fl=e(l),T(S.$$.fragment,l),Vl=e(l),N=J(l,"P",{"data-svelte-h":!0}),w(N)!=="svelte-9ivy9a"&&(N.textContent=gs),Yl=e(l),O=J(l,"OL",{"data-svelte-h":!0}),w(O)!=="svelte-11lwswh"&&(O.innerHTML=rs),Zl=e(l),x=J(l,"P",{"data-svelte-h":!0}),w(x)!=="svelte-1e5nt7w"&&(x.textContent=us),Wl=e(l),T(_.$$.fragment,l),$l=e(l),v=J(l,"P",{"data-svelte-h":!0}),w(v)!=="svelte-1nhlurw"&&(v.innerHTML=As),Sl=e(l),T(X.$$.fragment,l),Nl=e(l),T(z.$$.fragment,l),Ol=e(l),q=J(l,"P",{"data-svelte-h":!0}),w(q)!=="svelte-dxehyw"&&(q.textContent=ds),xl=e(l),T(D.$$.fragment,l),_l=e(l),H=J(l,"P",{"data-svelte-h":!0}),w(H)!=="svelte-16kdhwk"&&(H.textContent=Qs),vl=e(l),T(L.$$.fragment,l),Xl=e(l),T(P.$$.fragment,l),zl=e(l),K=J(l,"P",{"data-svelte-h":!0}),w(K)!=="svelte-cyjxhu"&&(K.textContent=bs),ql=e(l),T(ll.$$.fragment,l),Dl=e(l),sl=J(l,"P",{"data-svelte-h":!0}),w(sl)!=="svelte-1m9vwg1"&&(sl.textContent=Bs),Hl=e(l),T(tl.$$.fragment,l),Ll=e(l),T(Ul.$$.fragment,l),Pl=e(l),Ml=J(l,"P",{"data-svelte-h":!0}),w(Ml)!=="svelte-1fm4afm"&&(Ml.textContent=Rs),Kl=e(l),el=J(l,"OL",{"data-svelte-h":!0}),w(el)!=="svelte-6zgrsn"&&(el.innerHTML=Es),ls=e(l),al=J(l,"P",{"data-svelte-h":!0}),w(al)!=="svelte-lcweis"&&(al.textContent=Gs),ss=e(l),Jl=J(l,"P",{"data-svelte-h":!0}),w(Jl)!=="svelte-3gl5yz"&&(Jl.innerHTML=fs),ts=e(l),T(nl.$$.fragment,l),Us=e(l),jl=J(l,"P",{}),Js(jl).forEach(t),this.h()},h(){ns(I,"name","hf:doc:metadata"),ns(I,"content",Os),ns(o,"class","tip")},m(l,s){Ts(document.head,I),U(l,pl,s),U(l,yl,s),U(l,il,s),y(c,l,s),U(l,wl,s),y(h,l,s),U(l,Cl,s),U(l,g,s),U(l,ml,s),U(l,r,s),U(l,Il,s),U(l,u,s),U(l,ol,s),U(l,A,s),U(l,cl,s),y(d,l,s),U(l,hl,s),U(l,Q,s),U(l,gl,s),U(l,b,s),U(l,rl,s),U(l,o,s),Ts(o,Tl),Ts(o,as),y(B,o,null),U(l,ul,s),y(R,l,s),U(l,Al,s),U(l,E,s),U(l,dl,s),y(G,l,s),U(l,Ql,s),y(f,l,s),U(l,bl,s),U(l,k,s),U(l,Bl,s),U(l,F,s),U(l,Rl,s),y(V,l,s),U(l,El,s),y(Y,l,s),U(l,Gl,s),y(Z,l,s),U(l,fl,s),y(W,l,s),U(l,kl,s),y($,l,s),U(l,Fl,s),y(S,l,s),U(l,Vl,s),U(l,N,s),U(l,Yl,s),U(l,O,s),U(l,Zl,s),U(l,x,s),U(l,Wl,s),y(_,l,s),U(l,$l,s),U(l,v,s),U(l,Sl,s),y(X,l,s),U(l,Nl,s),y(z,l,s),U(l,Ol,s),U(l,q,s),U(l,xl,s),y(D,l,s),U(l,_l,s),U(l,H,s),U(l,vl,s),y(L,l,s),U(l,Xl,s),y(P,l,s),U(l,zl,s),U(l,K,s),U(l,ql,s),y(ll,l,s),U(l,Dl,s),U(l,sl,s),U(l,Hl,s),y(tl,l,s),U(l,Ll,s),y(Ul,l,s),U(l,Pl,s),U(l,Ml,s),U(l,Kl,s),U(l,el,s),U(l,ls,s),U(l,al,s),U(l,ss,s),U(l,Jl,s),U(l,ts,s),y(nl,l,s),U(l,Us,s),U(l,jl,s),Ms=!0},p:Fs,i(l){Ms||(j(c.$$.fragment,l),j(h.$$.fragment,l),j(d.$$.fragment,l),j(B.$$.fragment,l),j(R.$$.fragment,l),j(G.$$.fragment,l),j(f.$$.fragment,l),j(V.$$.fragment,l),j(Y.$$.fragment,l),j(Z.$$.fragment,l),j(W.$$.fragment,l),j($.$$.fragment,l),j(S.$$.fragment,l),j(_.$$.fragment,l),j(X.$$.fragment,l),j(z.$$.fragment,l),j(D.$$.fragment,l),j(L.$$.fragment,l),j(P.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(Ul.$$.fragment,l),j(nl.$$.fragment,l),Ms=!0)},o(l){p(c.$$.fragment,l),p(h.$$.fragment,l),p(d.$$.fragment,l),p(B.$$.fragment,l),p(R.$$.fragment,l),p(G.$$.fragment,l),p(f.$$.fragment,l),p(V.$$.fragment,l),p(Y.$$.fragment,l),p(Z.$$.fragment,l),p(W.$$.fragment,l),p($.$$.fragment,l),p(S.$$.fragment,l),p(_.$$.fragment,l),p(X.$$.fragment,l),p(z.$$.fragment,l),p(D.$$.fragment,l),p(L.$$.fragment,l),p(P.$$.fragment,l),p(ll.$$.fragment,l),p(tl.$$.fragment,l),p(Ul.$$.fragment,l),p(nl.$$.fragment,l),Ms=!1},d(l){l&&(t(pl),t(yl),t(il),t(wl),t(Cl),t(g),t(ml),t(r),t(Il),t(u),t(ol),t(A),t(cl),t(hl),t(Q),t(gl),t(b),t(rl),t(o),t(ul),t(Al),t(E),t(dl),t(Ql),t(bl),t(k),t(Bl),t(F),t(Rl),t(El),t(Gl),t(fl),t(kl),t(Fl),t(Vl),t(N),t(Yl),t(O),t(Zl),t(x),t(Wl),t($l),t(v),t(Sl),t(Nl),t(Ol),t(q),t(xl),t(_l),t(H),t(vl),t(Xl),t(zl),t(K),t(ql),t(Dl),t(sl),t(Hl),t(Ll),t(Pl),t(Ml),t(Kl),t(el),t(ls),t(al),t(ss),t(Jl),t(ts),t(Us),t(jl)),t(I),i(c,l),i(h,l),i(d,l),i(B),i(R,l),i(G,l),i(f,l),i(V,l),i(Y,l),i(Z,l),i(W,l),i($,l),i(S,l),i(_,l),i(X,l),i(z,l),i(D,l),i(L,l),i(P,l),i(ll,l),i(tl,l),i(Ul,l),i(nl,l)}}}const Os='{"title":"文档分析图","local":"文档分析图","sections":[{"title":"管家的工作流程","local":"管家的工作流程","sections":[],"depth":2},{"title":"设置环境","local":"设置环境","sections":[],"depth":2},{"title":"定义智能体的状态","local":"定义智能体的状态","sections":[],"depth":2},{"title":"准备工具","local":"准备工具","sections":[],"depth":2},{"title":"节点","local":"节点","sections":[],"depth":2},{"title":"ReAct 模式：我如何协助 Wayne 先生","local":"react-模式我如何协助-wayne-先生","sections":[],"depth":2},{"title":"管家实战示例","local":"管家实战示例","sections":[{"title":"示例1：简单计算","local":"示例1简单计算","sections":[],"depth":3},{"title":"示例 2：分析 Wayne 大师的训练文档","local":"示例-2分析-wayne-大师的训练文档","sections":[],"depth":3}],"depth":2},{"title":"关键要点","local":"关键要点","sections":[],"depth":2}],"depth":1}';function xs(ys){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ys{constructor(I){super(),Zs(this,I,xs,Ns,ks,{})}}export{Ds as component};
