# 简介 (Introduction)

![附加单元1缩略图](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit1/thumbnail.jpg)

欢迎来到第一个**附加单元**，在这里你将学习如何**为函数调用 (function calling) 微调大语言模型 (Large Language Model, LLM)**。

在大语言模型领域，函数调用正在迅速成为一项*必须掌握*的技术。

这个想法是，不同于我们在第1单元中仅依赖基于提示的方法，函数调用在训练阶段就训练你的模型**采取行动和解释观察结果**，使你的人工智能更加健壮。

> **我应该什么时候学习这个附加单元？**
>
> 这个部分是**可选的**，比第1单元更高级，所以不要犹豫，你可以现在就学习这个单元，或者在通过本课程提高了知识水平后再回来学习。
>  
> 但不用担心，这个附加单元设计时包含了你需要的所有信息，所以即使你还没有学习微调的内部工作原理，我们也会带你了解为函数调用微调模型的每个核心概念。

让你能够跟上这个附加单元的最佳方式是：

1. 了解如何使用 Transformers 微调大语言模型，如果你还不了解，[请查看这里](https://huggingface.co/learn/nlp-course/chapter3/1?fw=pt)

2. 了解如何使用 `SFTTrainer` 来微调我们的模型，要了解更多信息，[请查看这份文档](https://huggingface.co/learn/nlp-course/en/chapter11/1)

---

## 你将学到什么

1. **函数调用 (Function Calling)**  
   现代大语言模型如何有效地构建对话，使它们能够触发**工具 (Tools)**。

2. **LoRA（低秩适应，Low-Rank Adaptation）**  
   一种**轻量级且高效**的微调方法，减少计算和存储开销。LoRA 使大型模型的训练变得*更快、更便宜、更容易*部署。

3. **函数调用模型中的思考 → 行动 → 观察循环(Thought → Act → Observe Cycle)**  
   一种简单但强大的方法，用于构建模型如何决定何时（以及如何）调用函数、跟踪中间步骤以及解释来自外部工具或API的结果。

4. **新的特殊词元 (Special Tokens)**  
   我们将介绍**特殊标记**，帮助模型区分：
   - 内部"思维链"推理  
   - 外部函数调用  
   - 来自外部工具的响应

---

在完成这个附加单元后，你将能够：

- **理解**工具相关的 API 内部工作原理。  
- 使用 LoRA 技术**微调**模型。  
- **实现**和**修改**思考 → 行动 → 观察循环，以创建健壮和可维护的函数调用工作流。  
- **设计和使用**特殊词元，无缝分离模型的内部推理和外部行动。

而且你将**拥有自己微调的模型来进行函数调用。** 🔥

让我们深入了解**函数调用**吧！

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus-unit1/introduction.mdx" />