# 欢迎加入 🤗 AI Agents 课程 [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="AI Agents Course thumbnail" width="100%"/>
<figcaption>该图片背景使用 <a href="https://scenario.com/">Scenario.com</a> 生成
</figcaption>
</figure>


欢迎来到当今 AI 领域最激动人心的主题： **Agents**！

本免费课程将带您完成**从新手到专家**的蜕变之旅，全面掌握 AI 智能体的理解、使用与构建技能。

首个单元将帮助您快速入门：

- 了解**课程大纲**。
- **选择学习路径**：自主研修或认证课程。
- **获取认证流程与截止日期详情**。
- 认识课程开发团队。
- 创建您的 **Hugging Face 账号**。
- **登录 Discord 服务**, 并与同学及导师互动。

开始学习之旅！

## 课程内容概览 [[expect]]

在本课程中，您将：

- 📖 系统学习 AI 智能体的**理论架构、设计原理与实践应用**
- 🧑‍💻 掌握主流 AI 智能体开发库的使用，包括 [smolagents](https://huggingface.co/docs/smolagents/en/index)、 [LangChain](https://www.langchain.com/) 和 [LlamaIndex](https://www.llamaindex.ai/).
- 💾 在 Hugging Face Hub 上**发布您的** agents 并探索社区作品
- 🏆 参与挑战赛，在实战中**与其他学员的 agents 进行性能对标**
- 🎓 通过课程作业**获取结业证书**

此外！

在本课程结束时，您将理解智能体的工作原理，以及如何运用最新库和工具构建自己的智能体。

别忘了 **<a href="https://bit.ly/hf-learn-agents">立即报名课程！</a>** 

(我们尊重您的隐私。收集邮箱仅用于**在每单元发布时发送课程链接，并向您同步挑战动态与课程更新**。)

## 课程结构 [[course-look-like]]

课程包含四大模块：

- *基础单元*：系统学习智能体的核心理论知识。
- *实践环节*：通过预配置环境的 Hugging Face Spaces，掌握如何用成熟的AI智能体库训练专属智能体。
- *应用案例作业*：自选真实场景，运用所学知识解决实际问题。
- *终极挑战*：让您的智能体与其他参赛者同台竞技，最终成绩将登上 [排行榜](https://huggingface.co/spaces/huggingface-projects/AI-Agents-Leaderboard) （即将开放）。

本课程是持续进化的动态项目，您的反馈与贡献将推动课程迭代！ 欢迎通过 [GitHub 提交问题与代码](https://github.com/huggingface/agents-course)参与建设，或在 Discord 社区展开讨论。

完成课程后，您可通过  [👉 反馈表单](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog)提交宝贵建议。

## 课程大纲 [[syllabus]]

以下是**课程总体大纲**，各单元发布时将附详细知识点列表。

| 章节 | 主题 | 描述 |
| :---- | :---- | :---- |
| 0 | 入门准备 | 配置课程所需的工具与平台环境 |
| 1 | 智能体基础 | 解析工具（Tools）、思维（Thoughts）、行动（Actions）、观测（Observations）及其格式，详解大语言模型 (LLMs)、消息结构、特殊标记与对话模板，演示基于 Python 函数的工具使用案例 |
|1.5| 拓展单元：微调一个适用于函数调用（Function Calling）的大语言模型 | 让我们使用低秩序适应（LoRa）并对模型进行微调，使其在笔记本内执行函数调用（Function Calling） |
| 2 | 框架实践 | 探索主流智能体库的实现原理：smolagents、LangGraph、LLamaIndex |
|2.5| 扩展单元：智能体的可观测性和评估 | 了解如何追踪和评估智能体，使其为投入生产做好准备 |
| 3 | 应用案例 | 构建真实场景应用案例（欢迎有经验的智能体开发者通过PR贡献案例 🤗） |
| 4 | 期末大作业 | 针对选定基准测试开发智能体，用学员排行榜 🚀 上的表现证明实力 |

除了主要教学大纲外，我们还提供3个扩展单元：

- 扩展单元1：针对函数调用的LLM微调
- 扩展单元2：智能体的可观测性和评估
- 扩展单元3：游戏中的智能体——以Pokemon为例

例如，在扩展单元3中，你可以了解如何构建你自己的智能体，使其可以参加Pokemon对战游戏 🥊。

## 学习要求

参与本课程需具备以下基础：

- Python 基础语法能力
- 大语言模型（LLMs）基本认知（第1单元设有知识回顾环节）


## 所需工具  [[tools]]

仅需准备两样物品：

- 一台*可联网的电脑*
- *Hugging Face 账号*：用于上传/加载模型与智能体、创建 Spaces 。若未注册，可点击**[此处](https://hf.co/join)** 免费创建。
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Course tools needed" width="100%"/>

## 认证机制 [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Three paths" width="100%"/>

您可选择*旁听模式*自由学习，或通过考核获取*双轨认证*：

旁听模式：可自由参与挑战与作业（无需告知我们）

*认证模式*（完全免费）：

- *基础认证*: 完成第1单元学习，适合希望掌握智能体前沿趋势的学习者
- *结业认证*: 需完成第1单元、任一应用案例作业及最终挑战

认证截止日期：所有考核作业需在*2025年7月1日*前完成。 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/deadline.jpg" alt="Deadline" width="100%"/>

## 推荐学习进度 [[recommended-pace]]

本课程每个章节设计为**建议在1周内完成，每周约需投入3-4小时学习时间**。

为帮助您更好地把握学习节奏，我们提供以下进度建议：

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Recommended Pace" width="100%"/>

## 如何高效学习课程？ [[advice]]

为帮助您获得最佳学习效果，我们提供以下建议：

1. <a href="https://discord.gg/UrrTSsSyjb">加入 Discord 学习小组</a>: 群体学习往往事半功倍。加入我们的 Discord 服务器后，请先完成 Hugging Face 账户验证。
2. **完成测验与实践作业**: 通过实践操作和自我检测是最高效的学习方式。
3. **制定学习计划保持同步**: 您可参考下方的推荐进度表，或创建个性化学习计划。

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Course advice" width="100%"/>

## 关于我们 [[who-are-we]]

课程作者团队：

### 乔弗里·托马斯（Joffrey Thomas）

Hugging Face 机器学习工程师，拥有生产环境 AI 智能体开发部署经验，担任本课程首席讲师。

- [在 Hugging Face 关注 Joffrey](https://huggingface.co/Jofthomas)
- [在 X 关注 Joffrey](https://x.com/Jthmas404)
- [在 Linkedin 关注 Joffrey](https://www.linkedin.com/in/joffrey-thomas/)

### 本·伯滕肖（Ben Burtenshaw）

Hugging Face 机器学习工程师，拥有多平台课程开发经验，致力于打造普惠型技术教育课程。

- [在 Hugging Face 关注 Ben](https://huggingface.co/burtenshaw)
- [在 X 关注 Ben](https://x.com/ben_burtenshaw)
- [在 LinkedIn 上关注Ben](https://www.linkedin.com/in/ben-burtenshaw/)

### 托马斯·西蒙尼尼（Thomas Simonini）

Thomas 是 Hugging Face 的机器学习工程师，主导开发了广受欢迎的 <a href="https://huggingface.co/learn/deep-rl-course/unit0/introduction">深度强化学习课程</a> 和 <a href="https://huggingface.co/learn/ml-games-course/en/unit0/introduction">游戏机器学习课程</a>。他是智能体技术的忠实拥趸，并期待见证社区成员将构建的创新成果。

- [在 Hugging Face 关注 Thomas](https://huggingface.co/ThomasSimonini)
- [在 X 平台关注 Thomas](https://x.com/ThomasSimonini)
- [在 LinkedIn 关注Thomas](https://www.linkedin.com/in/simoninithomas/)

## 致谢  

我们衷心感谢以下人士对本课程作出的宝贵贡献：

- **[Pedro Cuenca](https://huggingface.co/pcuenq)** – 在课程材料审核中提供的专业指导
- **[Aymeric Roucher](https://huggingface.co/m-ric)** – 打造了惊艳的解码演示空间和最终智能体演示
- **[Joshua Lochner](https://huggingface.co/Xenova)** – 贡献了卓越的分词技术演示空间
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** – 感谢他对课程内容的帮助
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** – 感谢他对课程内容和主持提供的帮助
- **[夏潇 (ShawnSiao)](https://huggingface.co/SSSSSSSiao)** – 课程的中文翻译者
- **[Jiaming Huang](https://huggingface.co/nordicsushi)** – 课程的中文翻译者

## 问题反馈与课程改进 [[contribute]]

我们**热烈欢迎**您的贡献  🤗

- 若您在 notebook 中发现程序错误🐛，请 <a href="https://github.com/huggingface/agents-course/issues">提交问题报告</a> 并详细描述问题现象。
- 若您希望优化课程内容，可直接 <a href="https://github.com/huggingface/agents-course/pulls">提交 Pull Request</a>。
- 若您计划新增完整章节或单元，建议先 <a href="https://github.com/huggingface/agents-course/issues">创建讨论议题</a> **说明拟新增内容概要**，以便我们提供协作指导。

## 仍有疑问？ [[questions]]

欢迎加入我们的 <a href="https://discord.gg/UrrTSsSyjb">discord server #ai-agents-discussions 频道</a>进行交流


一切准备就绪，让我们启程探索吧 ⛵ 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Time to Onboard" width="100%"/>



<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit0/introduction.mdx" />