# Observe: 整合反馈以反思和调整

Observations（观察）是**智能体感知其行动结果的方式**。

它们提供关键信息，为智能体的思考过程提供燃料并指导未来行动。

这些是**来自环境的信号**——无论是 API 返回的数据、错误信息还是系统日志——它们指导着下一轮的思考循环。

在观察阶段，智能体会：

- **收集反馈**：接收数据或确认其行动是否成功
- **附加结果**：将新信息整合到现有上下文中，有效更新记忆
- **调整策略**：使用更新后的上下文来优化后续思考和行动

例如，当天气 API 返回数据*"partly cloudy, 15°C, 60% humidity"*（局部多云，15°C，60% 湿度）时，该观察结果会被附加到智能体的记忆（位于提示末尾）。

智能体随后利用这些信息决定是否需要额外数据，或是否准备好提供最终答案。

这种**迭代式反馈整合确保智能体始终保持与目标的动态对齐**，根据现实结果不断学习和调整。

这些观察**可能呈现多种形式**，从读取网页文本到监测机械臂位置。这可以视为工具"日志"，为行动执行提供文本反馈。

| 观察类型            | 示例                                                                       |
|---------------------|---------------------------------------------------------------------------|
| 系统反馈            | 错误信息、成功通知、状态码                                                   |
| 数据变更            | 数据库更新、文件系统修改、状态变更                                            |
| 环境数据            | 传感器读数、系统指标、资源使用情况                                            |
| 响应分析            | API 响应、查询结果、计算输出                                                  |
| 基于时间的事件       | 截止时间到达、定时任务完成                                                   |

## 结果如何被附加？

执行操作后，框架按以下步骤处理：

1. **解析操作** 以识别要调用的函数和使用的参数  
2. **执行操作**  
3. **将结果附加** 作为 **Observation**  

---
至此我们已经学习了智能体的思考-行动-观察循环。

如果某些概念仍显模糊，不必担心——我们将在后续单元中重访并深化这些概念。

现在，是时候通过编写你的第一个智能体来实践所学知识了！


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/observations.mdx" />