import{s as Aa,n as Ba,o as ga}from"../chunks/scheduler.1f027d5a.js";import{S as Za,i as fa,e,s as a,c as i,h as Ga,a as p,d as n,b as t,f as ba,g as y,j as o,k as ha,l as Ra,m as M,n as J,t as j,o as U,p as T}from"../chunks/index.5cb6ce42.js";import{C as Wa}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Ea,C as c}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as w,E as Xa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Qa(hM){let m,Is,cs,rs,I,us,r,ds,u,Cs,d,AM='<em>Authored by: <a href="https://github.com/behroozazarkhalili" rel="nofollow">Behrooz Azarkhalili</a></em>',bs,C,BM="This notebook demonstrates how to fine-tune language models for function calling capabilities using the <strong>xLAM dataset</strong> from Salesforce and <strong>QLoRA</strong> (Quantized Low-Rank Adaptation) technique. We’ll work with popular models like Llama 3, Qwen2, Mistral, and others.",hs,b,gM=`<strong>What is Function Calling?</strong>
Function calling enables language models to interact with external tools and APIs by generating structured function invocations. Instead of just generating text, the model learns to call specific functions with the right parameters based on user requests.`,As,h,ZM="<strong>What You’ll Learn:</strong>",Bs,A,fM="<li><strong>Data Processing</strong>: How to format the xLAM dataset for function calling training</li> <li><strong>Model Fine-tuning</strong>: Using QLoRA for memory-efficient training on consumer GPUs</li> <li><strong>Evaluation</strong>: Testing the fine-tuned models with example prompts</li> <li><strong>Multi-model Support</strong>: Working with different model architectures</li>",gs,B,GM="<strong>Key Benefits:</strong>",Zs,g,RM="<li><strong>Memory Efficient</strong>: QLoRA enables training on 16-24GB GPUs</li> <li><strong>Production Ready</strong>: Modular code with proper error handling</li> <li><strong>Flexible Architecture</strong>: Easy to adapt for different models and datasets</li> <li><strong>Universal Support</strong>: Works with Llama, Qwen, Mistral, Gemma, Phi, and more</li>",fs,Z,WM="<strong>Hardware Requirements:</strong>",Gs,f,EM="<li><strong>GPU</strong>: 16GB+ VRAM (24GB recommended for larger models)</li> <li><strong>RAM</strong>: 32GB+ system memory</li> <li><strong>Storage</strong>: 50GB+ free space for models and datasets</li>",Rs,G,XM=`<strong>Software Dependencies:</strong>
The notebook will install required packages automatically, including:`,Ws,R,QM="<li><code>transformers</code>, <code>peft</code>, <code>bitsandbytes</code>, <code>trl</code>, <code>datasets</code>, <code>accelerate</code></li>",Es,W,VM='<em>For detailed methodology and results, see: <a href="https://newsletter.kaitchup.com/p/function-calling-fine-tuning-llama" rel="nofollow">Function Calling: Fine-tuning Llama 3 and Qwen2 on xLAM</a></em>',Xs,E,Qs,X,Vs,Q,_M="Let’s start with the essential imports and basic setup for our notebook.",_s,V,ks,_,kM=`PyTorch version: 2.8.0+cu128
CUDA available: True
GPU: NVIDIA H100 NVL
VRAM: 100.0 GB
`,Ns,k,Ss,N,NM="Next, we’ll set up authentication with HuggingFace Hub. This allows us to download models and datasets, and optionally upload our fine-tuned models.",Fs,S,vs,F,SM=`✅ Successfully authenticated with HuggingFace!
`,Ys,v,zs,Y,FM="We’ll create two configuration classes to organize our settings:",Hs,z,vM="<li><strong>ModelConfig</strong>: Stores model-specific settings like tokenizer configuration</li> <li><strong>TrainingConfig</strong>: Stores training parameters like learning rate and batch size</li>",xs,H,qs,x,$s,q,YM="This function automatically detects the model’s tokenizer settings and creates a proper configuration. It handles different model architectures (Llama, Qwen, Mistral, etc.) and their specific token requirements.",Ls,$,Ds,L,Ks,D,zM=`✅ Configuration system ready!
💡 Supports Llama, Qwen, Mistral, Gemma, Phi, and more
`,Os,K,Ps,O,HM="Let’s detect our hardware capabilities and configure optimal settings. We’ll check for bfloat16 support and set up the best attention mechanism for our GPU.",ln,P,sn,ll,nn,sl,xM="Now let’s create a function to set up our tokenizer with the right configuration from our model settings.",Mn,nl,an,Ml,qM=`📊 Hardware Configuration Complete:
   • Compute dtype: torch.bfloat16
   • Attention implementation: flash_attention_2
   • Device: NVIDIA H100 NVL
`,tn,al,en,tl,$M="Now we’ll work with the xLAM dataset from Salesforce. This dataset contains about 60,000 examples of function calling conversations that we’ll use to train our model.",pn,el,LM="<strong>Key Functions:</strong>",yn,pl,DM="<li><strong><code>process_xlam_sample()</code></strong>: Converts a single dataset example into the training format with special tags (<code>&lt;user&gt;</code>, <code>&lt;tools&gt;</code>, <code>&lt;calls&gt;</code>) and EOS token</li> <li><strong><code>load_and_process_xlam_dataset()</code></strong>: Loads the complete xLAM dataset (60K samples) from Hugging Face and processes all samples using multiprocessing for efficiency</li> <li><strong><code>preview_dataset_sample()</code></strong>: Displays a formatted preview of a processed dataset sample for inspection with statistics</li>",Jn,il,jn,yl,Un,Jl,Tn,jl,on,Ul,KM="Now let’s add functions to load the xLAM dataset and process it into the format our model needs for training.",wn,Tl,cn,ol,mn,wl,OM="QLoRA (Quantized Low-Rank Adaptation) allows us to fine-tune large language models efficiently. It uses 4-bit quantization to reduce memory usage while maintaining training quality.",In,cl,rn,ml,un,Il,PM="LoRA (Low-Rank Adaptation) is the key technique that makes efficient fine-tuning possible. Instead of updating all model parameters, LoRA adds small trainable matrices to specific layers while keeping the base model frozen.",dn,rl,Cn,ul,la="Now we’ll create the main training function that puts everything together. This function configures the training arguments and executes the fine-tuning process using TRL’s SFTTrainer.",bn,dl,hn,Cl,An,bl,sa="<strong>Choose any model for fine-tuning!</strong> This notebook supports a wide range of popular models. Simply uncomment the model you want to use or specify your own.",Bn,hl,gn,Al,na="Uncomment one of these popular models or specify your own:",Zn,Bl,Ma="<strong>Why Llama 3-8B-Instruct as default?</strong>",fn,gl,aa="<li><strong>Proven Performance</strong>: Excellent function calling capabilities and instruction following</li> <li><strong>Optimal Size</strong>: 8B parameters provide great balance between performance and resource usage</li>",Gn,Zl,Rn,fl,ta=`🎯 Selected Model: meta-llama/Meta-Llama-3-8B-Instruct

🔧 Auto-configuring everything for meta-llama/Meta-Llama-3-8B-Instruct...
🔍 Loading model configuration: meta-llama/Meta-Llama-3-8B-Instruct
📊 Model: llama, vocab_size: 128,256
✅ Configured - pad: '<|eot_id|>' (ID: 128009), eos: '<|eot_id|>' (ID: 128009)

🎉 Ready to fine-tune! Everything configured automatically:
   ✅ Model type: llama
   ✅ Vocabulary: 128,256 tokens
   ✅ Pad token: '<|eot_id|>' (ID: 128009)
   ✅ Output dir: ./Meta_Llama_3_8B_Instruct_xLAM

🚀 Configuration complete for meta-llama/Meta-Llama-3-8B-Instruct!
`,Wn,Gl,En,Rl,Xn,Wl,ea="After training is complete, we need to load the trained model for inference. This function loads the base model with quantization and applies the trained LoRA adapters.",Qn,El,Vn,Xl,_n,Ql,pa="Now let’s create the function that generates responses from our fine-tuned model. This handles tokenization, generation parameters, and decoding.",kn,Vl,Nn,_l,Sn,kl,ia="This function provides a comprehensive test suite to evaluate our fine-tuned model with different types of function calling scenarios.",Fn,Nl,vn,Sl,Yn,Fl,zn,vl,ya=`🧪 Testing function calling capabilities...

============================================================
Test Case 1: Mathematical Function
============================================================
🎯 Generating response for prompt...
📝 Input: <user>Check if the numbers 8 and 1233 are powers of two.</user>

<tools>
✅ Generation completed!
📊 Generated 90 new tokens

🔍 Complete Response:
----------------------------------------
<user>Check if the numbers 8 and 1233 are powers of two.</user>

<tools>&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;description&#39;: &#39;Checks if a number is a power of two.&#39;, &#39;parameters&#39;: &amp;#123;&#39;num&#39;: &amp;#123;&#39;description&#39;: &#39;The number to check.&#39;, &#39;type&#39;: &#39;int&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;arguments&#39;: &amp;#123;&#39;num&#39;: 8}}
&amp;#123;&#39;name&#39;: &#39;is_power_of_two&#39;, &#39;arguments&#39;: &amp;#123;&#39;num&#39;: 1233}}</calls>
----------------------------------------

============================================================
Test Case 2: Weather Query
============================================================
🎯 Generating response for prompt...
📝 Input: <user>What&#39;s the weather like in New York today?</user>

<tools>
✅ Generation completed!
📊 Generated 105 new tokens

🔍 Complete Response:
----------------------------------------
<user>What&#39;s the weather like in New York today?</user>

<tools>&amp;#123;&#39;name&#39;:&#39;realtime_weather_api&#39;, &#39;description&#39;: &#39;Fetches current weather information based on the provided query parameter.&#39;, &#39;parameters&#39;: &amp;#123;&#39;q&#39;: &amp;#123;&#39;description&#39;: &#39;Query parameter used to specify the location for which weather data is required. It can be in various formats such as:&#39;, &#39;type&#39;:&#39;str&#39;, &#39;default&#39;: &#39;53.1,-0.13&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;:&#39;realtime_weather_api&#39;, &#39;arguments&#39;: &amp;#123;&#39;q&#39;: &#39;New York&#39;}}</calls>
----------------------------------------

============================================================
Test Case 3: Data Processing
============================================================
🎯 Generating response for prompt...
📝 Input: <user>Calculate the average of these numbers: 10, 20, 30, 40, 50</user>

<tools>
✅ Generation completed!
📊 Generated 81 new tokens

🔍 Complete Response:
----------------------------------------
<user>Calculate the average of these numbers: 10, 20, 30, 40, 50</user>

<tools>&amp;#123;&#39;name&#39;: &#39;average&#39;, &#39;description&#39;: &#39;Calculates the arithmetic mean of a list of numbers.&#39;, &#39;parameters&#39;: &amp;#123;&#39;numbers&#39;: &amp;#123;&#39;description&#39;: &#39;The list of numbers.&#39;, &#39;type&#39;: &#39;List[float]&#39;}}}</tools>

<calls>&amp;#123;&#39;name&#39;: &#39;average&#39;, &#39;arguments&#39;: &amp;#123;&#39;numbers&#39;: [10, 20, 30, 40, 50]}}</calls>
----------------------------------------

✅ All test cases completed!
</tools></tools></tools>`,Hn,Yl,xn,qn,$n,zl,Ln,Hl,Ja="This notebook demonstrated a <strong>complete, production-ready, universal pipeline</strong> for fine-tuning language models for function calling capabilities using:",Dn,xl,ja="<li><strong>🎯 Universal Model Support</strong>: Works with any model - just change the <code>MODEL_NAME</code> variable</li> <li><strong>🔧 Intelligent Configuration</strong>: Automatic token detection using <code>auto_configure_model()</code></li> <li><strong>⚡ QLoRA Efficiency</strong>: Memory-efficient training on consumer GPUs (16-24GB)</li> <li><strong>📋 Comprehensive Testing</strong>: Automated evaluation and interactive testing capabilities</li>",Kn,ql,On,$l,Pn,Ll,Ua="<li>✅ <strong>Multi-Model Support</strong>: Works with Llama, Qwen, Mistral, Gemma, Phi, DeepSeek, Yi, and more</li> <li>✅ <strong>Smart Token Detection</strong>: Automatically finds pad/EOS tokens from any model’s tokenizer</li> <li>✅ <strong>Error Prevention</strong>: Validates configurations and provides helpful error messages</li> <li>✅ <strong>Flexible Architecture</strong>: Easy to add new models without code changes</li>",lM,Dl,sM,Kl,Ta="<li>✅ <strong>Type Hints</strong>: Full type annotations for better IDE support and error catching</li> <li>✅ <strong>Docstrings</strong>: Comprehensive documentation for all functions</li> <li>✅ <strong>Error Handling</strong>: Robust error handling with informative messages</li> <li>✅ <strong>Modular Design</strong>: Clean separation of concerns and reusable components</li>",nM,Ol,MM,Pl,oa="<li>✅ <strong>One-Line Model Selection</strong>: Simply change <code>MODEL_NAME</code> variable</li> <li>✅ <strong>Automatic Configuration</strong>: Everything extracted from transformers automatically</li> <li>✅ <strong>Clear Progress Indicators</strong>: Emojis and detailed logging throughout</li> <li>✅ <strong>Production Ready</strong>: Code suitable for research and deployment</li>",aM,ls,tM,ss,eM,ns,wa="<li><strong>Try Different Models</strong>: Simply change the <code>MODEL_NAME</code> variable and re-run</li> <li><strong>Hyperparameter Tuning</strong>: Experiment with different LoRA ranks, learning rates</li> <li><strong>Extended Training</strong>: Try multi-epoch training for better convergence</li>",pM,Ms,iM,as,ca="<li><strong>Quantitative Metrics</strong>: Add BLEU, ROUGE, or custom function calling accuracy</li> <li><strong>Benchmark Datasets</strong>: Test on additional function calling benchmarks</li> <li><strong>Multi-Model Comparison</strong>: Compare performance across different model families</li>",yM,ts,JM,es,ma="<li><strong>Model Serving</strong>: Deploy with FastAPI, TensorRT, or vLLM</li> <li><strong>Integration</strong>: Connect with real APIs and function execution environments</li> <li><strong>Optimization</strong>: Implement model quantization and pruning for production</li>",jM,ps,UM,is,Ia="<li><strong>Multi-turn Conversations</strong>: Extend to handle conversation context</li> <li><strong>Tool Selection</strong>: Improve tool selection and reasoning capabilities</li> <li><strong>Error Recovery</strong>: Add error handling and recovery mechanisms</li>",TM,ys,oM,Js,ra='<li><strong>xLAM Dataset</strong>: <a href="https://huggingface.co/datasets/Salesforce/xlam-function-calling-60k" rel="nofollow">Salesforce/xlam-function-calling-60k</a></li> <li><strong>QLoRA Paper</strong>: <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">Efficient Finetuning of Quantized LLMs</a></li> <li><strong>Function Calling Guide</strong>: <a href="https://newsletter.kaitchup.com/p/function-calling-fine-tuning-llama" rel="nofollow">Complete methodology article</a></li> <li><strong>PEFT Library</strong>: <a href="https://huggingface.co/docs/peft" rel="nofollow">Hugging Face PEFT Documentation</a></li>',wM,js,cM,Us,ua="<strong>🏆 Universal Function Calling Fine-tuning Master!</strong>",mM,Ts,da="You now have a production-ready system that can fine-tune virtually any open-source language model for function calling with just a single line change!",IM,rM,uM,os,Ca="<strong>Happy Fine-tuning! 🚀</strong> Try different models, share your results, and contribute back to the community!",dM,ws,CM,ms,bM;return I=new Ea({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/function_calling_fine_tuning_llms_on_xlam.ipynb"}]}}),r=new Wa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new w({props:{title:"Fine-tuning LLMs for Function Calling with xLAM Dataset",local:"fine-tuning-llms-for-function-calling-with-xlam-dataset",headingTag:"h1"}}),E=new c({props:{code:"JTIzJTIwSW5zdGFsbCUyMHJlcXVpcmVkJTIwcGFja2FnZXMlMjBmb3IlMjBmdW5jdGlvbiUyMGNhbGxpbmclMjBmaW5lLXR1bmluZyUwQSUyMyUyMCF1diUyMHBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBiaXRzYW5kYnl0ZXMlMjBwZWZ0JTIwdHJsJTIwcHl0aG9uLWRvdGVudg==",highlighted:`<span class="hljs-comment"># Install required packages for function calling fine-tuning</span>
<span class="hljs-comment"># !uv pip install --upgrade bitsandbytes peft trl python-dotenv</span>`,wrap:!1}}),X=new w({props:{title:"Basic Setup and Imports",local:"basic-setup-and-imports",headingTag:"h2"}}),V=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQWltcG9ydCUyMHdhcm5pbmdzJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUyQyUyMFR1cGxlJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBHUFUlMjBhbmQlMjBzdXBwcmVzcyUyMHdhcm5pbmdzJTIwZm9yJTIwY2xlYW5lciUyMG91dHB1dCUwQW9zLmVudmlyb24lNUIlMjJDVURBX1ZJU0lCTEVfREVWSUNFUyUyMiU1RCUyMCUzRCUyMCUyMjAlMjIlMEF3YXJuaW5ncy5maWx0ZXJ3YXJuaW5ncyglMjJpZ25vcmUlMjIpJTBBJTBBcHJpbnQoZiUyMlB5VG9yY2glMjB2ZXJzaW9uJTNBJTIwJTdCdG9yY2guX192ZXJzaW9uX18lN0QlMjIpJTBBcHJpbnQoZiUyMkNVREElMjBhdmFpbGFibGUlM0ElMjAlN0J0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTdEJTIyKSUwQWlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHUFUlM0ElMjAlN0J0b3JjaC5jdWRhLmdldF9kZXZpY2VfbmFtZSgwKSU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyVlJBTSUzQSUyMCU3QnRvcmNoLmN1ZGEuZ2V0X2RldmljZV9wcm9wZXJ0aWVzKDApLnRvdGFsX21lbW9yeSUyMCUyRiUyMDFlOSUzQS4xZiU3RCUyMEdCJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> warnings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up GPU and suppress warnings for cleaner output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>warnings.filterwarnings(<span class="hljs-string">&quot;ignore&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;PyTorch version: <span class="hljs-subst">{torch.__version__}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;CUDA available: <span class="hljs-subst">{torch.cuda.is_available()}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> torch.cuda.is_available():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU: <span class="hljs-subst">{torch.cuda.get_device_name(<span class="hljs-number">0</span>)}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;VRAM: <span class="hljs-subst">{torch.cuda.get_device_properties(<span class="hljs-number">0</span>).total_memory / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)`,wrap:!1}}),k=new w({props:{title:"Hugging Face Authentication Setup",local:"hugging-face-authentication-setup",headingTag:"h2"}}),S=new c({props:{code:"JTIzJTIwU2V0JTIwdXAlMjBIdWdnaW5nRmFjZSUyMGF1dGhlbnRpY2F0aW9uJTBBZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBJTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwZnJvbSUyMC5lbnYlMjBmaWxlJTIwKG9wdGlvbmFsKSUwQWxvYWRfZG90ZW52KCklMEElMEElMjMlMjBBdXRoZW50aWNhdGUlMjB3aXRoJTIwSHVnZ2luZ0ZhY2UlMjB1c2luZyUyMHRva2VuJTIwZnJvbSUyMC5lbnYlMjBmaWxlJTBBaGZfdG9rZW4lMjAlM0QlMjBvcy5nZXRlbnYoJ2hmX2FwaV9rZXknKSUwQWlmJTIwaGZfdG9rZW4lM0ElMEElMjAlMjAlMjAlMjBsb2dpbih0b2tlbiUzRGhmX3Rva2VuKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QyU4NSUyMFN1Y2Nlc3NmdWxseSUyMGF1dGhlbnRpY2F0ZWQlMjB3aXRoJTIwSHVnZ2luZ0ZhY2UhJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUElQTAlRUYlQjglOEYlMjAlMjBXYXJuaW5nJTNBJTIwSEZfQVBJX0tFWSUyMG5vdCUyMGZvdW5kJTIwaW4lMjAuZW52JTIwZmlsZSUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlMjAlMjAlMjBZb3UlMjBjYW4lMjBzdGlsbCUyMHJ1biUyMHRoZSUyMG5vdGVib29rJTJDJTIwYnV0JTIwd29uJ3QlMjBiZSUyMGFibGUlMjB0byUyMHVwbG9hZCUyMG1vZGVscyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set up HuggingFace authentication</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load environment variables from .env file (optional)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dotenv()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Authenticate with HuggingFace using token from .env file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_token = os.getenv(<span class="hljs-string">&#x27;hf_api_key&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> hf_token:
<span class="hljs-meta">... </span>    login(token=hf_token)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Successfully authenticated with HuggingFace!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  Warning: HF_API_KEY not found in .env file&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;   You can still run the notebook, but won&#x27;t be able to upload models&quot;</span>)`,wrap:!1}}),v=new w({props:{title:"Model Configuration Classes",local:"model-configuration-classes",headingTag:"h2"}}),H=new c({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNb2RlbENvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvbmZpZ3VyYXRpb24lMjBmb3IlMjBtb2RlbC1zcGVjaWZpYyUyMHNldHRpbmdzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0ElMjBzdHIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBIdWdnaW5nRmFjZSUyMG1vZGVsJTIwaWRlbnRpZmllciUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzQSUyMHN0ciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFBhZGRpbmclMjB0b2tlbiUyMGZvciUyMHRoZSUyMHRva2VuaXplciUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbl9pZCUzQSUyMGludCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME51bWVyaWNhbCUyMElEJTIwZm9yJTIwdGhlJTIwcGFkZGluZyUyMHRva2VuJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNBJTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2lkZSUyMHRvJTIwYWRkJTIwcGFkZGluZyUyMCgnbGVmdCclMjBvciUyMCdyaWdodCcpJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNBJTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5kJTIwb2YlMjBzZXF1ZW5jZSUyMHRva2VuJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuX2lkJTNBJTIwaW50JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5kJTIwb2YlMjBzZXF1ZW5jZSUyMHRva2VuJTIwSUQlMEElMjAlMjAlMjAlMjB2b2NhYl9zaXplJTNBJTIwaW50JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVm9jYWJ1bGFyeSUyMHNpemUlMEElMjAlMjAlMjAlMjBtb2RlbF90eXBlJTNBJTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTW9kZWwlMjBhcmNoaXRlY3R1cmUlMjB0eXBlJTBBJTBBJTQwZGF0YWNsYXNzJTIwJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvbmZpZ3VyYXRpb24lMjBmb3IlMjB0cmFpbmluZyUyMGh5cGVycGFyYW1ldGVycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNBJTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGlyZWN0b3J5JTIwdG8lMjBzYXZlJTIwbW9kZWwlMjBjaGVja3BvaW50cyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjAxNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYWluaW5nJTIwYmF0Y2glMjBzaXplJTIwcGVyJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwaW50JTIwJTNEJTIwOCUyMCUyMCUyMyUyMFN0ZXBzJTIwdG8lMjBhY2N1bXVsYXRlJTIwZ3JhZGllbnRzJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzQSUyMGZsb2F0JTIwJTNEJTIwMWUtNCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExlYXJuaW5nJTIwcmF0ZSUyMGZvciUyMG9wdGltaXphdGlvbiUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzQSUyMGludCUyMCUzRCUyMDEwMDAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNYXhpbXVtJTIwdHJhaW5pbmclMjBzdGVwcyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNBJTIwaW50JTIwJTNEJTIwMjA0OCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heGltdW0lMjBzZXF1ZW5jZSUyMGxlbmd0aCUwQSUyMCUyMCUyMCUyMGxvcmFfciUzQSUyMGludCUyMCUzRCUyMDE2JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9SQSUyMHJhbmslMjBwYXJhbWV0ZXIlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNBJTIwaW50JTIwJTNEJTIwMTYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMb1JBJTIwYWxwaGElMjBzY2FsaW5nJTIwcGFyYW1ldGVyJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNBJTIwZmxvYXQlMjAlM0QlMjAwLjA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9SQSUyMGRyb3BvdXQlMjByYXRlJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzQSUyMGludCUyMCUzRCUyMDI1MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0ZXBzJTIwYmV0d2VlbiUyMGNoZWNrcG9pbnQlMjBzYXZlcyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0ElMjBpbnQlMjAlM0QlMjAxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0ZXBzJTIwYmV0d2VlbiUyMGxvZyUyMG91dHB1dHMlMEElMjAlMjAlMjAlMjB3YXJtdXBfcmF0aW8lM0ElMjBmbG9hdCUyMCUzRCUyMDAuMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdhcm11cCUyMHJhdGlvJTIwZm9yJTIwbGVhcm5pbmclMjByYXRl",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">ModelConfig</span>:
    <span class="hljs-string">&quot;&quot;&quot;Configuration for model-specific settings.&quot;&quot;&quot;</span>
    model_name: <span class="hljs-built_in">str</span>           <span class="hljs-comment"># HuggingFace model identifier</span>
    pad_token: <span class="hljs-built_in">str</span>           <span class="hljs-comment"># Padding token for the tokenizer</span>
    pad_token_id: <span class="hljs-built_in">int</span>        <span class="hljs-comment"># Numerical ID for the padding token</span>
    padding_side: <span class="hljs-built_in">str</span>        <span class="hljs-comment"># Side to add padding (&#x27;left&#x27; or &#x27;right&#x27;)</span>
    eos_token: <span class="hljs-built_in">str</span>          <span class="hljs-comment"># End of sequence token</span>
    eos_token_id: <span class="hljs-built_in">int</span>       <span class="hljs-comment"># End of sequence token ID</span>
    vocab_size: <span class="hljs-built_in">int</span>         <span class="hljs-comment"># Vocabulary size</span>
    model_type: <span class="hljs-built_in">str</span>         <span class="hljs-comment"># Model architecture type</span>

<span class="hljs-meta">@dataclass </span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
    <span class="hljs-string">&quot;&quot;&quot;Configuration for training hyperparameters.&quot;&quot;&quot;</span>
    output_dir: <span class="hljs-built_in">str</span>                    <span class="hljs-comment"># Directory to save model checkpoints</span>
    batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>              <span class="hljs-comment"># Training batch size per device</span>
    gradient_accumulation_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">8</span>  <span class="hljs-comment"># Steps to accumulate gradients</span>
    learning_rate: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-4</span>       <span class="hljs-comment"># Learning rate for optimization</span>
    max_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>             <span class="hljs-comment"># Maximum training steps</span>
    max_seq_length: <span class="hljs-built_in">int</span> = <span class="hljs-number">2048</span>        <span class="hljs-comment"># Maximum sequence length</span>
    lora_r: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>                  <span class="hljs-comment"># LoRA rank parameter</span>
    lora_alpha: <span class="hljs-built_in">int</span> = <span class="hljs-number">16</span>              <span class="hljs-comment"># LoRA alpha scaling parameter</span>
    lora_dropout: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.05</span>        <span class="hljs-comment"># LoRA dropout rate</span>
    save_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">250</span>             <span class="hljs-comment"># Steps between checkpoint saves</span>
    logging_steps: <span class="hljs-built_in">int</span> = <span class="hljs-number">10</span>           <span class="hljs-comment"># Steps between log outputs</span>
    warmup_ratio: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.1</span>         <span class="hljs-comment"># Warmup ratio for learning rate</span>`,wrap:!1}}),x=new w({props:{title:"Automatic Model Configuration",local:"automatic-model-configuration",headingTag:"h2"}}),$=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoConfig

<span class="hljs-keyword">def</span> <span class="hljs-title function_">auto_configure_model</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, custom_pad_token: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>) -&gt; ModelConfig:
    <span class="hljs-string">&quot;&quot;&quot;
    Automatically configure any model by extracting information from its tokenizer.
    
    Args:
        model_name: HuggingFace model identifier
        custom_pad_token: Custom pad token if model doesn&#x27;t have one
        
    Returns:
        ModelConfig: Complete model configuration
    &quot;&quot;&quot;</span>
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 Loading model configuration: <span class="hljs-subst">{model_name}</span>&quot;</span>)
    
    <span class="hljs-comment"># Load tokenizer and model config</span>
    tokenizer = AutoTokenizer.from_pretrained(model_name, use_fast=<span class="hljs-literal">True</span>)
    model_config = AutoConfig.from_pretrained(model_name)
    
    <span class="hljs-comment"># Extract basic model info</span>
    model_type = <span class="hljs-built_in">getattr</span>(model_config, <span class="hljs-string">&#x27;model_type&#x27;</span>, <span class="hljs-string">&#x27;unknown&#x27;</span>)
    vocab_size = <span class="hljs-built_in">getattr</span>(model_config, <span class="hljs-string">&#x27;vocab_size&#x27;</span>, <span class="hljs-built_in">len</span>(tokenizer.get_vocab()))
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Model: <span class="hljs-subst">{model_type}</span>, vocab_size: <span class="hljs-subst">{vocab_size:,}</span>&quot;</span>)
    
    <span class="hljs-comment"># Get EOS token (required)</span>
    eos_token = tokenizer.eos_token
    eos_token_id = tokenizer.eos_token_id
    
    <span class="hljs-keyword">if</span> eos_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Model &#x27;<span class="hljs-subst">{model_name}</span>&#x27; missing EOS token&quot;</span>)
    
    <span class="hljs-comment"># Get or set pad token</span>
    pad_token = tokenizer.pad_token
    pad_token_id = tokenizer.pad_token_id
    
    <span class="hljs-keyword">if</span> pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">if</span> custom_pad_token <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;Model needs custom_pad_token. Use &#x27;&lt;|eot_id|&gt;&#x27; for Llama, &#x27;&lt;|im_end|&gt;&#x27; for Qwen&quot;</span>)
        
        pad_token = custom_pad_token
        <span class="hljs-keyword">if</span> pad_token <span class="hljs-keyword">in</span> tokenizer.get_vocab():
            pad_token_id = tokenizer.get_vocab()[pad_token]
        <span class="hljs-keyword">else</span>:
            tokenizer.add_special_tokens({<span class="hljs-string">&#x27;pad_token&#x27;</span>: pad_token})
            pad_token_id = tokenizer.pad_token_id
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Configured - pad: &#x27;<span class="hljs-subst">{pad_token}</span>&#x27; (ID: <span class="hljs-subst">{pad_token_id}</span>), eos: &#x27;<span class="hljs-subst">{eos_token}</span>&#x27; (ID: <span class="hljs-subst">{eos_token_id}</span>)&quot;</span>)
    
    <span class="hljs-keyword">return</span> ModelConfig(
        model_name=model_name,
        pad_token=pad_token,
        pad_token_id=pad_token_id,
        padding_side=<span class="hljs-string">&#x27;left&#x27;</span>,  <span class="hljs-comment"># Standard for causal LMs</span>
        eos_token=eos_token,
        eos_token_id=eos_token_id,
        vocab_size=vocab_size,
        model_type=model_type
    )`,wrap:!1}}),L=new c({props:{code:"ZGVmJTIwY3JlYXRlX3RyYWluaW5nX2NvbmZpZyhtb2RlbF9uYW1lJTNBJTIwc3RyJTJDJTIwKiprd2FyZ3MpJTIwLSUzRSUyMFRyYWluaW5nQ29uZmlnJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ3JlYXRlJTIwdHJhaW5pbmclMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMGF1dG9tYXRpYyUyMG91dHB1dCUyMGRpcmVjdG9yeS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGUlMjBjbGVhbiUyMGRpcmVjdG9yeSUyMG5hbWUlMjBmcm9tJTIwbW9kZWwlMjBuYW1lJTBBJTIwJTIwJTIwJTIwbW9kZWxfY2xlYW4lMjAlM0QlMjBtb2RlbF9uYW1lLnNwbGl0KCclMkYnKSU1Qi0xJTVELnJlcGxhY2UoJy0nJTJDJTIwJ18nKS5yZXBsYWNlKCcuJyUyQyUyMCdfJyklMEElMjAlMjAlMjAlMjBkZWZhdWx0X291dHB1dF9kaXIlMjAlM0QlMjBmJTIyLiUyRiU3Qm1vZGVsX2NsZWFuJTdEX3hMQU0lMjIlMEElMjAlMjAlMjAlMjBjb25maWdfZGljdCUyMCUzRCUyMCU3QidvdXRwdXRfZGlyJyUzQSUyMGRlZmF1bHRfb3V0cHV0X2RpciUyQyUyMCoqa3dhcmdzJTdEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwVHJhaW5pbmdDb25maWcoKipjb25maWdfZGljdCklMEElMEFwcmludCglMjIlRTIlOUMlODUlMjBDb25maWd1cmF0aW9uJTIwc3lzdGVtJTIwcmVhZHkhJTIyKSUwQXByaW50KCUyMiVGMCU5RiU5MiVBMSUyMFN1cHBvcnRzJTIwTGxhbWElMkMlMjBRd2VuJTJDJTIwTWlzdHJhbCUyQyUyMEdlbW1hJTJDJTIwUGhpJTJDJTIwYW5kJTIwbW9yZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_training_config</span>(<span class="hljs-params">model_name: <span class="hljs-built_in">str</span>, **kwargs</span>) -&gt; TrainingConfig:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Create training configuration with automatic output directory.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Create clean directory name from model name</span>
<span class="hljs-meta">... </span>    model_clean = model_name.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">1</span>].replace(<span class="hljs-string">&#x27;-&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>).replace(<span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>)
<span class="hljs-meta">... </span>    default_output_dir = <span class="hljs-string">f&quot;./<span class="hljs-subst">{model_clean}</span>_xLAM&quot;</span>
    
<span class="hljs-meta">... </span>    config_dict = {<span class="hljs-string">&#x27;output_dir&#x27;</span>: default_output_dir, **kwargs}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> TrainingConfig(**config_dict)

<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Configuration system ready!&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;💡 Supports Llama, Qwen, Mistral, Gemma, Phi, and more&quot;</span>)`,wrap:!1}}),K=new w({props:{title:"Hardware Detection and Setup",local:"hardware-detection-and-setup",headingTag:"h2"}}),P=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">setup_hardware_config</span>() -&gt; <span class="hljs-type">Tuple</span>[torch.dtype, <span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;
    Automatically detect and configure hardware-specific settings.
    
    Returns:
        Tuple[torch.dtype, str]: compute_dtype and attention_implementation
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔍 Detecting hardware capabilities...&quot;</span>)
    
    <span class="hljs-keyword">if</span> torch.cuda.is_bf16_supported():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ bfloat16 supported - using optimal precision&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📦 Installing FlashAttention for better performance...&quot;</span>)
        
        <span class="hljs-comment"># Install FlashAttention for supported hardware</span>
        os.system(<span class="hljs-string">&#x27;pip install flash_attn --no-build-isolation&#x27;</span>)
        
        compute_dtype = torch.bfloat16
        attn_implementation = <span class="hljs-string">&#x27;flash_attention_2&#x27;</span>
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Configuration: bfloat16 + FlashAttention 2&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  bfloat16 not supported - using float16 fallback&quot;</span>)
        compute_dtype = torch.float16
        attn_implementation = <span class="hljs-string">&#x27;sdpa&#x27;</span>  <span class="hljs-comment"># Scaled Dot Product Attention</span>
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Configuration: float16 + SDPA&quot;</span>)
    
    <span class="hljs-keyword">return</span> compute_dtype, attn_implementation

<span class="hljs-comment"># Configure hardware settings</span>
compute_dtype, attn_implementation = setup_hardware_config()`,wrap:!1}}),ll=new w({props:{title:"Tokenizer Setup Function",local:"tokenizer-setup-function",headingTag:"h2"}}),nl=new c({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">setup_tokenizer</span>(<span class="hljs-params">model_config: ModelConfig</span>) -&gt; AutoTokenizer:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Initialize and configure the tokenizer using model configuration.
    
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        model_config: Model configuration with all token information
        
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        AutoTokenizer: Configured tokenizer with proper pad token settings
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔤 Loading tokenizer for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)
    
<span class="hljs-meta">... </span>    tokenizer = AutoTokenizer.from_pretrained(model_config.model_name, use_fast=<span class="hljs-literal">True</span>)
    
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Configure padding token using values from model_config</span>
<span class="hljs-meta">... </span>    tokenizer.pad_token = model_config.pad_token
<span class="hljs-meta">... </span>    tokenizer.pad_token_id = model_config.pad_token_id
<span class="hljs-meta">... </span>    tokenizer.padding_side = model_config.padding_side
    
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Tokenizer configured - pad: &#x27;<span class="hljs-subst">{model_config.pad_token}</span>&#x27; (ID: <span class="hljs-subst">{model_config.pad_token_id}</span>)&quot;</span>)
    
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Hardware Configuration Complete:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Compute dtype: <span class="hljs-subst">{compute_dtype}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Attention implementation: <span class="hljs-subst">{attn_implementation}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Device: <span class="hljs-subst">{torch.cuda.get_device_name(<span class="hljs-number">0</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;CPU&#x27;</span>}</span>&quot;</span>)`,wrap:!1}}),al=new w({props:{title:"Dataset Processing",local:"dataset-processing",headingTag:"h2"}}),il=new c({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG11bHRpcHJvY2Vzc2luZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMEElMEFkZWYlMjBwcm9jZXNzX3hsYW1fc2FtcGxlKHJvdyUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQlMkMlMjB0b2tlbml6ZXIpJTIwLSUzRSUyMERpY3QlNUJzdHIlMkMlMjBzdHIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBQcm9jZXNzJTIwYSUyMHNpbmdsZSUyMHhMQU0lMjBkYXRhc2V0JTIwc2FtcGxlJTIwaW50byUyMHRyYWluaW5nJTIwZm9ybWF0LiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMFRoZSUyMGZvcm1hdCUyMHdlJTIwY3JlYXRlJTIwaXMlM0ElMEElMjAlMjAlMjAlMjAlM0N1c2VyJTNFJTVCdXNlciUyMHF1ZXJ5JTVEJTNDJTJGdXNlciUzRSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUzQ3Rvb2xzJTNFJTBBJTIwJTIwJTIwJTIwJTVCdG9vbCUyMGRlZmluaXRpb25zJTVEJTBBJTIwJTIwJTIwJTIwJTNDJTJGdG9vbHMlM0UlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlM0NjYWxscyUzRSUwQSUyMCUyMCUyMCUyMCU1QmV4cGVjdGVkJTIwZnVuY3Rpb24lMjBjYWxscyU1RCUwQSUyMCUyMCUyMCUyMCUzQyUyRmNhbGxzJTNFJTVCRU9TX1RPS0VOJTVEJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9ybWF0JTIwdXNlciUyMHF1ZXJ5JTBBJTIwJTIwJTIwJTIwZm9ybWF0dGVkX3F1ZXJ5JTIwJTNEJTIwZiUyMiUzQ3VzZXIlM0UlN0Jyb3clNUIncXVlcnknJTVEJTdEJTNDJTJGdXNlciUzRSU1Q24lNUNuJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGFyc2UlMjBhbmQlMjBmb3JtYXQlMjBhdmFpbGFibGUlMjB0b29scyUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnNlZF90b29scyUyMCUzRCUyMGpzb24ubG9hZHMocm93JTVCJTIydG9vbHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9vbHNfdGV4dCUyMCUzRCUyMCclNUNuJy5qb2luKHN0cih0b29sKSUyMGZvciUyMHRvb2wlMjBpbiUyMHBhcnNlZF90b29scyklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBqc29uLkpTT05EZWNvZGVFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvb2xzX3RleHQlMjAlM0QlMjBzdHIocm93JTVCJTIydG9vbHMlMjIlNUQpJTIwJTIwJTIzJTIwRmFsbGJhY2slMjB0byUyMHJhdyUyMHN0cmluZyUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGZvcm1hdHRlZF90b29scyUyMCUzRCUyMGYlMjIlM0N0b29scyUzRSU3QnRvb2xzX3RleHQlN0QlM0MlMkZ0b29scyUzRSU1Q24lNUNuJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGFyc2UlMjBhbmQlMjBmb3JtYXQlMjBleHBlY3RlZCUyMGZ1bmN0aW9uJTIwY2FsbHMlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXJzZWRfYW5zd2VycyUyMCUzRCUyMGpzb24ubG9hZHMocm93JTVCJTIyYW5zd2VycyUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXJzX3RleHQlMjAlM0QlMjAnJTVDbicuam9pbihzdHIoYW5zd2VyKSUyMGZvciUyMGFuc3dlciUyMGluJTIwcGFyc2VkX2Fuc3dlcnMpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwanNvbi5KU09ORGVjb2RlRXJyb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbnN3ZXJzX3RleHQlMjAlM0QlMjBzdHIocm93JTVCJTIyYW5zd2VycyUyMiU1RCklMjAlMjAlMjMlMjBGYWxsYmFjayUyMHRvJTIwcmF3JTIwc3RyaW5nJTBBJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGVkX2Fuc3dlcnMlMjAlM0QlMjBmJTIyJTNDY2FsbHMlM0UlN0JhbnN3ZXJzX3RleHQlN0QlM0MlMkZjYWxscyUzRSUyMiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENvbWJpbmUlMjBhbGwlMjBwYXJ0cyUyMHdpdGglMjBFT1MlMjB0b2tlbiUwQSUyMCUyMCUyMCUyMGNvbXBsZXRlX3RleHQlMjAlM0QlMjBmb3JtYXR0ZWRfcXVlcnklMjAlMkIlMjBmb3JtYXR0ZWRfdG9vbHMlMjAlMkIlMjBmb3JtYXR0ZWRfYW5zd2VycyUyMCUyQiUyMHRva2VuaXplci5lb3NfdG9rZW4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBVcGRhdGUlMjByb3clMjB3aXRoJTIwcHJvY2Vzc2VkJTIwZGF0YSUwQSUyMCUyMCUyMCUyMHJvdyU1QiUyMnF1ZXJ5JTIyJTVEJTIwJTNEJTIwZm9ybWF0dGVkX3F1ZXJ5JTBBJTIwJTIwJTIwJTIwcm93JTVCJTIydG9vbHMlMjIlNUQlMjAlM0QlMjBmb3JtYXR0ZWRfdG9vbHMlMEElMjAlMjAlMjAlMjByb3clNUIlMjJhbnN3ZXJzJTIyJTVEJTIwJTNEJTIwZm9ybWF0dGVkX2Fuc3dlcnMlMEElMjAlMjAlMjAlMjByb3clNUIlMjJ0ZXh0JTIyJTVEJTIwJTNEJTIwY29tcGxldGVfdGV4dCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJvdw==",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> multiprocessing
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_xlam_sample</span>(<span class="hljs-params">row: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], tokenizer</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]:
    <span class="hljs-string">&quot;&quot;&quot;
    Process a single xLAM dataset sample into training format.
    
    The format we create is:
    &lt;user&gt;[user query]&lt;/user&gt;
    
    &lt;tools&gt;
    [tool definitions]
    &lt;/tools&gt;
    
    &lt;calls&gt;
    [expected function calls]
    &lt;/calls&gt;[EOS_TOKEN]
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Format user query</span>
    formatted_query = <span class="hljs-string">f&quot;&lt;user&gt;<span class="hljs-subst">{row[<span class="hljs-string">&#x27;query&#x27;</span>]}</span>&lt;/user&gt;\\n\\n&quot;</span>

    <span class="hljs-comment"># Parse and format available tools</span>
    <span class="hljs-keyword">try</span>:
        parsed_tools = json.loads(row[<span class="hljs-string">&quot;tools&quot;</span>])
        tools_text = <span class="hljs-string">&#x27;\\n&#x27;</span>.join(<span class="hljs-built_in">str</span>(tool) <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> parsed_tools)
    <span class="hljs-keyword">except</span> json.JSONDecodeError:
        tools_text = <span class="hljs-built_in">str</span>(row[<span class="hljs-string">&quot;tools&quot;</span>])  <span class="hljs-comment"># Fallback to raw string</span>
    
    formatted_tools = <span class="hljs-string">f&quot;&lt;tools&gt;<span class="hljs-subst">{tools_text}</span>&lt;/tools&gt;\\n\\n&quot;</span>

    <span class="hljs-comment"># Parse and format expected function calls</span>
    <span class="hljs-keyword">try</span>:
        parsed_answers = json.loads(row[<span class="hljs-string">&quot;answers&quot;</span>])
        answers_text = <span class="hljs-string">&#x27;\\n&#x27;</span>.join(<span class="hljs-built_in">str</span>(answer) <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> parsed_answers)
    <span class="hljs-keyword">except</span> json.JSONDecodeError:
        answers_text = <span class="hljs-built_in">str</span>(row[<span class="hljs-string">&quot;answers&quot;</span>])  <span class="hljs-comment"># Fallback to raw string</span>

    formatted_answers = <span class="hljs-string">f&quot;&lt;calls&gt;<span class="hljs-subst">{answers_text}</span>&lt;/calls&gt;&quot;</span>

    <span class="hljs-comment"># Combine all parts with EOS token</span>
    complete_text = formatted_query + formatted_tools + formatted_answers + tokenizer.eos_token

    <span class="hljs-comment"># Update row with processed data</span>
    row[<span class="hljs-string">&quot;query&quot;</span>] = formatted_query
    row[<span class="hljs-string">&quot;tools&quot;</span>] = formatted_tools
    row[<span class="hljs-string">&quot;answers&quot;</span>] = formatted_answers
    row[<span class="hljs-string">&quot;text&quot;</span>] = complete_text

    <span class="hljs-keyword">return</span> row`,wrap:!1}}),yl=new c({props:{code:"ZGVmJTIwbG9hZF9hbmRfcHJvY2Vzc194bGFtX2RhdGFzZXQodG9rZW5pemVyJTNBJTIwQXV0b1Rva2VuaXplciUyQyUyMHNhbXBsZV9zaXplJTNBJTIwT3B0aW9uYWwlNUJpbnQlNUQlMjAlM0QlMjBOb25lKSUyMC0lM0UlMjBEYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwTG9hZCUyMGFuZCUyMHByb2Nlc3MlMjB0aGUlMjBjb21wbGV0ZSUyMHhMQU0lMjBkYXRhc2V0JTIwZm9yJTIwZnVuY3Rpb24lMjBjYWxsaW5nJTIwdHJhaW5pbmcuJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplciUzQSUyMENvbmZpZ3VyZWQlMjB0b2tlbml6ZXIlMjBmb3IlMjB0aGUlMjBtb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZV9zaXplJTNBJTIwT3B0aW9uYWwlMjBudW1iZXIlMjBvZiUyMHNhbXBsZXMlMjB0byUyMHVzZSUyMChOb25lJTIwZm9yJTIwZnVsbCUyMGRhdGFzZXQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMERhdGFzZXQlM0ElMjBQcm9jZXNzZWQlMjBkYXRhc2V0JTIwcmVhZHklMjBmb3IlMjB0cmFpbmluZyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVGMCU5RiU5MyU4QSUyMExvYWRpbmclMjB4TEFNJTIwZnVuY3Rpb24lMjBjYWxsaW5nJTIwZGF0YXNldC4uLiUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkJTIwdGhlJTIwU2FsZXNmb3JjZSUyMHhMQU0lMjBkYXRhc2V0JTIwZnJvbSUyMEh1Z2dpbmclMjBGYWNlJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTYWxlc2ZvcmNlJTJGeGxhbS1mdW5jdGlvbi1jYWxsaW5nLTYwayUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU4QiUyME9yaWdpbmFsJTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklM0ElMkMlN0QlMjBzYW1wbGVzJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFNhbXBsZSUyMGRhdGFzZXQlMjBpZiUyMHJlcXVlc3RlZCUyMCh1c2VmdWwlMjBmb3IlMjB0ZXN0aW5nKSUwQSUyMCUyMCUyMCUyMGlmJTIwc2FtcGxlX3NpemUlMjBpcyUyMG5vdCUyME5vbmUlMjBhbmQlMjBzYW1wbGVfc2l6ZSUyMCUzQyUyMGxlbihkYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdChyYW5nZShzYW1wbGVfc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCVBQyUyMFVzaW5nJTIwc2FtcGxlJTIwc2l6ZSUzQSUyMCU3QnNhbXBsZV9zaXplJTNBJTJDJTdEJTIwc2FtcGxlcyUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzJTIwYWxsJTIwc2FtcGxlcyUyMHVzaW5nJTIwbXVsdGlwcm9jZXNzaW5nJTIwZm9yJTIwZWZmaWNpZW5jeSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QSU5OSVFRiVCOCU4RiUyMFByb2Nlc3NpbmclMjBkYXRhc2V0JTIwc2FtcGxlcyUyMGludG8lMjB0cmFpbmluZyUyMGZvcm1hdC4uLiUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBkZWYlMjBwcm9jZXNzX2JhdGNoKGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMlByb2Nlc3MlMjBhJTIwYmF0Y2glMjBvZiUyMHNhbXBsZXMlMjB3aXRoJTIwdGhlJTIwdG9rZW5pemVyLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2Nlc3NlZF9iYXRjaCUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihiYXRjaCU1QidxdWVyeSclNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvdyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdxdWVyeSclM0ElMjBiYXRjaCU1QidxdWVyeSclNUQlNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Rvb2xzJyUzQSUyMGJhdGNoJTVCJ3Rvb2xzJyU1RCU1QmklNUQlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnYW5zd2VycyclM0ElMjBiYXRjaCU1QidhbnN3ZXJzJyU1RCU1QmklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9jZXNzZWRfcm93JTIwJTNEJTIwcHJvY2Vzc194bGFtX3NhbXBsZShyb3clMkMlMjB0b2tlbml6ZXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc2VkX2JhdGNoLmFwcGVuZChwcm9jZXNzZWRfcm93KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnZlcnQlMjB0byUyMGJhdGNoJTIwZm9ybWF0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3RleHQnJTNBJTIwJTVCaXRlbSU1Qid0ZXh0JyU1RCUyMGZvciUyMGl0ZW0lMjBpbiUyMHByb2Nlc3NlZF9iYXRjaCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdxdWVyeSclM0ElMjAlNUJpdGVtJTVCJ3F1ZXJ5JyU1RCUyMGZvciUyMGl0ZW0lMjBpbiUyMHByb2Nlc3NlZF9iYXRjaCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd0b29scyclM0ElMjAlNUJpdGVtJTVCJ3Rvb2xzJyU1RCUyMGZvciUyMGl0ZW0lMjBpbiUyMHByb2Nlc3NlZF9iYXRjaCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdhbnN3ZXJzJyUzQSUyMCU1Qml0ZW0lNUInYW5zd2VycyclNUQlMjBmb3IlMjBpdGVtJTIwaW4lMjBwcm9jZXNzZWRfYmF0Y2glNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcm9jZXNzJTIwdGhlJTIwZGF0YXNldCUwQSUyMCUyMCUyMCUyMHByb2Nlc3NlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc19iYXRjaCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDEwMDAlMkMlMjAlMjAlMjMlMjBQcm9jZXNzJTIwaW4lMjBiYXRjaGVzJTIwZm9yJTIwZWZmaWNpZW5jeSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9wcm9jJTNEbWluKDQlMkMlMjBtdWx0aXByb2Nlc3NpbmcuY3B1X2NvdW50KCkpJTJDJTIwJTIwJTIzJTIwVXNlJTIwbXVsdGlwbGUlMjBjb3JlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlc2MlM0QlMjJQcm9jZXNzaW5nJTIweExBTSUyMHNhbXBsZXMlMjIlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlDJTg1JTIwRGF0YXNldCUyMHByb2Nlc3NpbmclMjBjb21wbGV0ZSElMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU4QSUyMEZpbmFsJTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4ocHJvY2Vzc2VkX2RhdGFzZXQpJTNBJTJDJTdEJTIwc2FtcGxlcyUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTk0JUE0JTIwQXZlcmFnZSUyMHRleHQlMjBsZW5ndGglM0ElMjAlN0JzdW0obGVuKHRleHQpJTIwZm9yJTIwdGV4dCUyMGluJTIwcHJvY2Vzc2VkX2RhdGFzZXQlNUIndGV4dCclNUQpJTIwJTJGJTIwbGVuKHByb2Nlc3NlZF9kYXRhc2V0KSUzQSUyQy4wZiU3RCUyMGNoYXJhY3RlcnMlMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_and_process_xlam_dataset</span>(<span class="hljs-params">tokenizer: AutoTokenizer, sample_size: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">int</span>] = <span class="hljs-literal">None</span></span>) -&gt; Dataset:
    <span class="hljs-string">&quot;&quot;&quot;
    Load and process the complete xLAM dataset for function calling training.
    
    Args:
        tokenizer: Configured tokenizer for the model
        sample_size: Optional number of samples to use (None for full dataset)
        
    Returns:
        Dataset: Processed dataset ready for training
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📊 Loading xLAM function calling dataset...&quot;</span>)
    
    <span class="hljs-comment"># Load the Salesforce xLAM dataset from Hugging Face</span>
    dataset = load_dataset(<span class="hljs-string">&quot;Salesforce/xlam-function-calling-60k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📋 Original dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> samples&quot;</span>)
    
    <span class="hljs-comment"># Sample dataset if requested (useful for testing)</span>
    <span class="hljs-keyword">if</span> sample_size <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sample_size &lt; <span class="hljs-built_in">len</span>(dataset):
        dataset = dataset.select(<span class="hljs-built_in">range</span>(sample_size))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔬 Using sample size: <span class="hljs-subst">{sample_size:,}</span> samples&quot;</span>)
    
    <span class="hljs-comment"># Process all samples using multiprocessing for efficiency</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚙️ Processing dataset samples into training format...&quot;</span>)
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_batch</span>(<span class="hljs-params">batch</span>):
        <span class="hljs-string">&quot;&quot;&quot;Process a batch of samples with the tokenizer.&quot;&quot;&quot;</span>
        processed_batch = []
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&#x27;query&#x27;</span>])):
            row = {
                <span class="hljs-string">&#x27;query&#x27;</span>: batch[<span class="hljs-string">&#x27;query&#x27;</span>][i],
                <span class="hljs-string">&#x27;tools&#x27;</span>: batch[<span class="hljs-string">&#x27;tools&#x27;</span>][i], 
                <span class="hljs-string">&#x27;answers&#x27;</span>: batch[<span class="hljs-string">&#x27;answers&#x27;</span>][i]
            }
            processed_row = process_xlam_sample(row, tokenizer)
            processed_batch.append(processed_row)
        
        <span class="hljs-comment"># Convert to batch format</span>
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&#x27;text&#x27;</span>: [item[<span class="hljs-string">&#x27;text&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&#x27;query&#x27;</span>: [item[<span class="hljs-string">&#x27;query&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&#x27;tools&#x27;</span>: [item[<span class="hljs-string">&#x27;tools&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch],
            <span class="hljs-string">&#x27;answers&#x27;</span>: [item[<span class="hljs-string">&#x27;answers&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> processed_batch]
        }
    
    <span class="hljs-comment"># Process the dataset</span>
    processed_dataset = dataset.<span class="hljs-built_in">map</span>(
        process_batch,
        batched=<span class="hljs-literal">True</span>,
        batch_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># Process in batches for efficiency</span>
        num_proc=<span class="hljs-built_in">min</span>(<span class="hljs-number">4</span>, multiprocessing.cpu_count()),  <span class="hljs-comment"># Use multiple cores</span>
        desc=<span class="hljs-string">&quot;Processing xLAM samples&quot;</span>
    )
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Dataset processing complete!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Final dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(processed_dataset):,}</span> samples&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔤 Average text length: <span class="hljs-subst">{<span class="hljs-built_in">sum</span>(<span class="hljs-built_in">len</span>(text) <span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> processed_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) / <span class="hljs-built_in">len</span>(processed_dataset):,<span class="hljs-number">.0</span>f}</span> characters&quot;</span>)
    
    <span class="hljs-keyword">return</span> processed_dataset`,wrap:!1}}),Jl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preview_dataset_sample</span>(<span class="hljs-params">dataset: Dataset, index: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span></span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Display a formatted preview of a dataset sample for inspection.
    
    Args:
        dataset: The processed dataset
        index: Index of the sample to preview (default: 0)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> index &gt;= <span class="hljs-built_in">len</span>(dataset):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Index <span class="hljs-subst">{index}</span> is out of range. Dataset has <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span> samples.&quot;</span>)
        <span class="hljs-keyword">return</span>
    
    sample = dataset[index]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📋 Dataset Sample Preview (Index: <span class="hljs-subst">{index}</span>)&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span> * <span class="hljs-number">80</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔍 Raw Components:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Query: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;query&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;query&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Tools: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;tools&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;tools&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answers: <span class="hljs-subst">{sample[<span class="hljs-string">&#x27;answers&#x27;</span>][:<span class="hljs-number">200</span>]}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;...&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;answers&#x27;</span>]) &gt; <span class="hljs-number">200</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📝 Complete Training Text:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
    <span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&#x27;text&#x27;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📊 Sample Statistics:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Text length: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;text&#x27;</span>]):,}</span> characters&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Estimated tokens: ~<span class="hljs-subst">{<span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&#x27;text&#x27;</span>]) // <span class="hljs-number">4</span>:,}</span> tokens&quot;</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n✅ Preview complete!&quot;</span>)`,wrap:!1}}),jl=new w({props:{title:"Loading and Processing the Dataset",local:"loading-and-processing-the-dataset",headingTag:"h2"}}),Tl=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Import QLoRA training components when we need them</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, prepare_model_for_kbit_training
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_qlora_model</span>(<span class="hljs-params">model_config: ModelConfig, 
                       tokenizer: AutoTokenizer,
                       compute_dtype: torch.dtype, 
                       attn_implementation: <span class="hljs-built_in">str</span></span>) -&gt; AutoModelForCausalLM:
    <span class="hljs-string">&quot;&quot;&quot;
    Create and configure a QLoRA-enabled model for efficient fine-tuning.
    
    QLoRA uses 4-bit quantization and low-rank adapters to enable
    fine-tuning large models on consumer GPUs.
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏗️  Creating QLoRA model: <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)
    
    <span class="hljs-comment"># Configure 4-bit quantization for memory efficiency</span>
    bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,                    <span class="hljs-comment"># Enable 4-bit quantization</span>
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,           <span class="hljs-comment"># Use NF4 quantization</span>
        bnb_4bit_compute_dtype=compute_dtype, <span class="hljs-comment"># Computation data type</span>
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,      <span class="hljs-comment"># Double quantization for more memory savings</span>
    )
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;📦 Loading quantized model...&quot;</span>)
    
    <span class="hljs-comment"># Load model with quantization</span>
    model = AutoModelForCausalLM.from_pretrained(
        model_config.model_name,
        quantization_config=bnb_config,
        device_map={<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>},                  <span class="hljs-comment"># Load on first GPU</span>
        attn_implementation=attn_implementation,
        torch_dtype=compute_dtype,
        trust_remote_code=<span class="hljs-literal">True</span>,              <span class="hljs-comment"># Required for some models</span>
    )
    
    <span class="hljs-comment"># Prepare model for k-bit training (required for QLoRA)</span>
    model = prepare_model_for_kbit_training(
        model, 
        gradient_checkpointing_kwargs={<span class="hljs-string">&#x27;use_reentrant&#x27;</span>: <span class="hljs-literal">True</span>}
    )
    
    <span class="hljs-comment"># Configure tokenizer settings in model</span>
    model.config.pad_token_id = tokenizer.pad_token_id
    model.config.use_cache = <span class="hljs-literal">False</span>  <span class="hljs-comment"># Disable cache for training</span>
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ QLoRA model prepared successfully!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Model memory footprint: ~<span class="hljs-subst">{model.get_memory_footprint() / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)
    
    <span class="hljs-keyword">return</span> model`,wrap:!1}}),ol=new w({props:{title:"QLoRA Training Setup",local:"qlora-training-setup",headingTag:"h2"}}),cl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_lora_config</span>(<span class="hljs-params">training_config: TrainingConfig</span>) -&gt; LoraConfig:
    <span class="hljs-string">&quot;&quot;&quot;
    Create LoRA configuration for parameter-efficient fine-tuning.
    
    LoRA (Low-Rank Adaptation) adds small trainable matrices to specific
    model layers while keeping the base model frozen.
    
    Args:
        training_config (TrainingConfig): Training configuration with LoRA parameters
        
    Returns:
        LoraConfig: Configured LoRA adapter settings
        
    LoRA Parameters:
        - r (rank): Dimensionality of adaptation matrices (higher = more capacity)
        - alpha: Scaling factor for LoRA weights
        - dropout: Regularization to prevent overfitting
        - target_modules: Which model layers to adapt
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚙️ Configuring LoRA adapters...&quot;</span>)
    
    <span class="hljs-comment"># Target modules for both Llama and Qwen architectures</span>
    target_modules = [
        <span class="hljs-string">&#x27;k_proj&#x27;</span>, <span class="hljs-string">&#x27;q_proj&#x27;</span>, <span class="hljs-string">&#x27;v_proj&#x27;</span>, <span class="hljs-string">&#x27;o_proj&#x27;</span>,  <span class="hljs-comment"># Attention projections</span>
        <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>       <span class="hljs-comment"># Feed-forward projections</span>
    ]
    
    lora_config = LoraConfig(
        lora_alpha=training_config.lora_alpha,
        lora_dropout=training_config.lora_dropout,
        r=training_config.lora_r,
        bias=<span class="hljs-string">&quot;none&quot;</span>,                             <span class="hljs-comment"># Don&#x27;t adapt bias terms</span>
        task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,                   <span class="hljs-comment"># Causal language modeling</span>
        target_modules=target_modules
    )
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 LoRA targeting modules: <span class="hljs-subst">{target_modules}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 LoRA parameters: r=<span class="hljs-subst">{training_config.lora_r}</span>, alpha=<span class="hljs-subst">{training_config.lora_alpha}</span>&quot;</span>)
    
    <span class="hljs-keyword">return</span> lora_config`,wrap:!1}}),ml=new w({props:{title:"LoRA Configuration",local:"lora-configuration",headingTag:"h2"}}),rl=new w({props:{title:"Training Execution",local:"training-execution",headingTag:"h2"}}),dl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_qlora_model</span>(<span class="hljs-params">dataset: Dataset, 
                      model: AutoModelForCausalLM,
                      training_config: TrainingConfig,
                      compute_dtype: torch.dtype</span>) -&gt; SFTTrainer:
    <span class="hljs-string">&quot;&quot;&quot;
    Execute QLoRA fine-tuning with comprehensive configuration and monitoring.
    
    Args:
        dataset (Dataset): Processed training dataset
        model (AutoModelForCausalLM): QLoRA-configured model
        training_config (TrainingConfig): Training hyperparameters
        compute_dtype (torch.dtype): Computation data type
        
    Returns:
        SFTTrainer: Trained model trainer
        
    Training Features:
        - Supervised fine-tuning with SFTTrainer
        - Memory-optimized settings for consumer GPUs
        - Comprehensive logging and checkpointing
        - Automatic mixed precision training
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🚀 Starting QLoRA fine-tuning...&quot;</span>)
    
    <span class="hljs-comment"># Create LoRA configuration</span>
    peft_config = create_lora_config(training_config)
    
    <span class="hljs-comment"># Configure training arguments</span>
    training_arguments = SFTConfig(
        output_dir=training_config.output_dir,
        optim=<span class="hljs-string">&quot;adamw_8bit&quot;</span>,                      <span class="hljs-comment"># 8-bit optimizer for memory efficiency</span>
        per_device_train_batch_size=training_config.batch_size,
        gradient_accumulation_steps=training_config.gradient_accumulation_steps,
        log_level=<span class="hljs-string">&quot;info&quot;</span>,                        <span class="hljs-comment"># Detailed logging</span>
        save_steps=training_config.save_steps,
        logging_steps=training_config.logging_steps,
        learning_rate=training_config.learning_rate,
        fp16=compute_dtype == torch.float16,     <span class="hljs-comment"># Use FP16 if not using bfloat16</span>
        bf16=compute_dtype == torch.bfloat16,    <span class="hljs-comment"># Use bfloat16 if supported</span>
        max_steps=training_config.max_steps,
        warmup_ratio=training_config.warmup_ratio,
        lr_scheduler_type=<span class="hljs-string">&quot;linear&quot;</span>,
        dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,               <span class="hljs-comment"># Field containing training text</span>
        max_length=training_config.max_seq_length,
        remove_unused_columns=<span class="hljs-literal">False</span>,             <span class="hljs-comment"># Keep all dataset columns</span>
        
        <span class="hljs-comment"># Additional stability and performance settings</span>
        dataloader_drop_last=<span class="hljs-literal">True</span>,               <span class="hljs-comment"># Drop incomplete batches</span>
        gradient_checkpointing=<span class="hljs-literal">True</span>,             <span class="hljs-comment"># Enable gradient checkpointing</span>
        save_total_limit=<span class="hljs-number">3</span>,                      <span class="hljs-comment"># Keep only 3 most recent checkpoints</span>
        load_best_model_at_end=<span class="hljs-literal">False</span>,            <span class="hljs-comment"># Don&#x27;t load best model (saves memory)</span>
    )
    
    <span class="hljs-comment"># Create trainer</span>
    trainer = SFTTrainer(
        model=model,
        train_dataset=dataset,
        peft_config=peft_config,
        args=training_arguments,
    )
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Training configuration:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset):,}</span> samples&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Batch size: <span class="hljs-subst">{training_config.batch_size}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Gradient accumulation: <span class="hljs-subst">{training_config.gradient_accumulation_steps}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Effective batch size: <span class="hljs-subst">{training_config.batch_size * training_config.gradient_accumulation_steps}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Max steps: <span class="hljs-subst">{training_config.max_steps:,}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Learning rate: <span class="hljs-subst">{training_config.learning_rate}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   • Output directory: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)
    
    <span class="hljs-comment"># Start training</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n🏁 Beginning training...&quot;</span>)
    trainer.train()
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Training completed successfully!&quot;</span>)
    
    <span class="hljs-keyword">return</span> trainer`,wrap:!1}}),Cl=new w({props:{title:"🎯 Universal Model Selection",local:"-universal-model-selection",headingTag:"h2"}}),hl=new w({props:{title:"📋 Quick Model Selection",local:"-quick-model-selection",headingTag:"h3"}}),Zl=new c({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 🎯 ONE-LINE MODEL CONFIGURATION 🎯</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Just specify any Hugging Face model and its custom pad token - everything else is automatic!</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># === Simply change this line to use ANY model ===</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>MODEL_NAME = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>custom_pad_token = <span class="hljs-string">&quot;&lt;|eot_id|&gt;&quot;</span>  
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use &#x27;&lt;|eot_id|&gt;&#x27; for Llama3+ models, &#x27;&lt;|im_end|&gt;&#x27; for Qwen2+ models, &#x27;&lt;/s&gt;&#x27; for Mistral models, &#x27;&lt;|end|&gt;&#x27; for Phi3+ models</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># === Popular alternatives (uncomment to use) ===</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;Qwen/Qwen2-7B-Instruct&quot;                # Qwen2 </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;mistralai/Mistral-7B-Instruct-v0.2&quot;    # Mistral </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;microsoft/Phi-3-mini-4k-instruct&quot;      # Phi-3 Mini </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;google/gemma-1.1-7b-it&quot;                # Gemma </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># MODEL_NAME = &quot;your-custom-model/model-name&quot;          # Any custom model</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Selected Model: <span class="hljs-subst">{MODEL_NAME}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 🚀 AUTOMATIC CONFIGURATION - No manual setup needed!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔧 Auto-configuring everything for <span class="hljs-subst">{MODEL_NAME}</span>...&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Extract ALL information automatically using transformers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_config = auto_configure_model(MODEL_NAME, custom_pad_token=custom_pad_token) 
<span class="hljs-meta">&gt;&gt;&gt; </span>training_config = create_training_config(MODEL_NAME)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎉 Ready to fine-tune! Everything configured automatically:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Model type: <span class="hljs-subst">{model_config.model_type}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Vocabulary: <span class="hljs-subst">{model_config.vocab_size:,}</span> tokens&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Pad token: &#x27;<span class="hljs-subst">{model_config.pad_token}</span>&#x27; (ID: <span class="hljs-subst">{model_config.pad_token_id}</span>)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;   ✅ Output dir: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🚀 Configuration complete for <span class="hljs-subst">{MODEL_NAME}</span>!&quot;</span>)`,wrap:!1}}),Gl=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Universal fine-tuning pipeline - works with any model!</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🚀 Starting fine-tuning pipeline for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)

<span class="hljs-comment"># Step 1: Setup tokenizer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📝 Setting up tokenizer...&quot;</span>)
tokenizer = setup_tokenizer(model_config)

<span class="hljs-comment"># Step 2: Load and process dataset</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n📊 Loading and processing xLAM dataset...&quot;</span>)
dataset = load_and_process_xlam_dataset(tokenizer, sample_size=<span class="hljs-literal">None</span>)  <span class="hljs-comment"># Set sample_size for testing</span>

<span class="hljs-comment"># Step 3: Preview dataset sample</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n👀 Dataset sample preview:&quot;</span>)
preview_dataset_sample(dataset, index=<span class="hljs-number">0</span>)

<span class="hljs-comment"># Step 4: Create QLoRA model</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🏗️  Creating QLoRA model...&quot;</span>)
model = create_qlora_model(
    model_config, 
    tokenizer, 
    compute_dtype, 
    attn_implementation
)

<span class="hljs-comment"># Step 5: Execute training</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎯 Starting training...&quot;</span>)
trainer = train_qlora_model(
    dataset=dataset,
    model=model,
    training_config=training_config,
    compute_dtype=compute_dtype
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎉 Fine-tuning completed for <span class="hljs-subst">{model_config.model_name.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">1</span>]}</span>!&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📁 Model saved to: <span class="hljs-subst">{training_config.output_dir}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 To test the model, run the inference cells below&quot;</span>)`,wrap:!1}}),Rl=new w({props:{title:"Model Loading for Inference",local:"model-loading-for-inference",headingTag:"h2"}}),El=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Import required components for inference</span>
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_trained_model</span>(<span class="hljs-params">model_config: ModelConfig, 
                       adapter_path: <span class="hljs-built_in">str</span>,
                       compute_dtype: torch.dtype,
                       attn_implementation: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Tuple</span>[AutoModelForCausalLM, AutoTokenizer]:
    <span class="hljs-string">&quot;&quot;&quot;
    Load a trained model with LoRA adapters for inference.
    
    This function loads the base model with quantization and applies the trained
    LoRA adapters for efficient inference. It&#x27;s designed to work after training
    completion or for loading previously saved models.
    
    Args:
        model_config (ModelConfig): Configuration for the base model
        adapter_path (str): Path to the saved LoRA adapter
        compute_dtype (torch.dtype): Computation data type
        attn_implementation (str): Attention implementation
        
    Returns:
        Tuple[AutoModelForCausalLM, AutoTokenizer]: Loaded model and tokenizer
        
    Note:
        You may need to restart the notebook to free GPU memory before loading
        the model for inference, especially after training.
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔄 Loading trained model from <span class="hljs-subst">{adapter_path}</span>&quot;</span>)
    
    <span class="hljs-comment"># Configure quantization for inference</span>
    quantization_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_compute_dtype=compute_dtype,
        bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    )
    
    <span class="hljs-comment"># Load tokenizer with proper configuration</span>
    tokenizer = setup_tokenizer(model_config)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔤 Tokenizer loaded for <span class="hljs-subst">{model_config.model_name}</span>&quot;</span>)
    
    <span class="hljs-comment"># Load base model</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📦 Loading base model <span class="hljs-subst">{model_config.model_name}</span>...&quot;</span>)
    base_model = AutoModelForCausalLM.from_pretrained(
        model_config.model_name,
        quantization_config=quantization_config,
        torch_dtype=compute_dtype,
        device_map={<span class="hljs-string">&quot;&quot;</span>: <span class="hljs-number">0</span>},
        attn_implementation=attn_implementation,
        trust_remote_code=<span class="hljs-literal">True</span>,
    )
    
    <span class="hljs-comment"># Load LoRA adapters</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔗 Loading LoRA adapters from <span class="hljs-subst">{adapter_path}</span>...&quot;</span>)
    model = PeftModel.from_pretrained(base_model, adapter_path)
    
    <span class="hljs-comment"># Enable evaluation mode</span>
    model.<span class="hljs-built_in">eval</span>()
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Model loaded successfully and ready for inference!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;💾 Total memory usage: ~<span class="hljs-subst">{model.get_memory_footprint() / <span class="hljs-number">1e9</span>:<span class="hljs-number">.1</span>f}</span> GB&quot;</span>)
    
    <span class="hljs-keyword">return</span> model, tokenizer`,wrap:!1}}),Xl=new w({props:{title:"Text Generation for Function Calls",local:"text-generation-for-function-calls",headingTag:"h2"}}),Vl=new c({props:{code:"ZGVmJTIwZ2VuZXJhdGVfZnVuY3Rpb25fY2FsbChtb2RlbCUzQSUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNBJTIwQXV0b1Rva2VuaXplciUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUzQSUyMHN0ciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwaW50JTIwJTNEJTIwNTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjBmbG9hdCUyMCUzRCUyMDAuNyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzQSUyMGJvb2wlMjAlM0QlMjBUcnVlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMGElMjBmdW5jdGlvbiUyMGNhbGwlMjByZXNwb25zZSUyMHVzaW5nJTIwdGhlJTIwZmluZS10dW5lZCUyMG1vZGVsLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMChBdXRvTW9kZWxGb3JDYXVzYWxMTSklM0ElMjBGaW5lLXR1bmVkJTIwbW9kZWwlMjB3aXRoJTIwTG9SQSUyMGFkYXB0ZXJzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyJTIwKEF1dG9Ub2tlbml6ZXIpJTNBJTIwTW9kZWwlMjB0b2tlbml6ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAoc3RyKSUzQSUyMElucHV0JTIwcHJvbXB0JTIwZm9yJTIwZnVuY3Rpb24lMjBjYWxsaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlMjAoaW50KSUzQSUyME1heGltdW0lMjB0b2tlbnMlMjB0byUyMGdlbmVyYXRlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlMjAoZmxvYXQpJTNBJTIwU2FtcGxpbmclMjB0ZW1wZXJhdHVyZSUyMChvbmx5JTIwdXNlZCUyMHdoZW4lMjBkb19zYW1wbGUlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUyMChib29sKSUzQSUyMFdoZXRoZXIlMjB0byUyMHVzZSUyMHNhbXBsaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0ciUzQSUyMEdlbmVyYXRlZCUyMHJlc3BvbnNlJTIwd2l0aCUyMGZ1bmN0aW9uJTIwY2FsbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBFeGFtcGxlJTIwUHJvbXB0JTIwRm9ybWF0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTNDdXNlciUzRUNoZWNrJTIwaWYlMjB0aGUlMjBudW1iZXJzJTIwOCUyMGFuZCUyMDEyMzMlMjBhcmUlMjBwb3dlcnMlMjBvZiUyMHR3by4lM0MlMkZ1c2VyJTNFJTVDbiU1Q24lM0N0b29scyUzRSUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOEUlQUYlMjBHZW5lcmF0aW5nJTIwcmVzcG9uc2UlMjBmb3IlMjBwcm9tcHQuLi4lMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU5RCUyMElucHV0JTNBJTIwJTdCcHJvbXB0JTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwaW5wdXQlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMHJlc3BvbnNlJTIwd2l0aCUyMHByb3BlciUyMHBhcmFtZXRlciUyMGhhbmRsaW5nJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMG1heF9uZXdfdG9rZW5zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFkX3Rva2VuX2lkJTIyJTNBJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVvc190b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBkb19zYW1wbGUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBPbmx5JTIwYWRkJTIwc2FtcGxpbmclMjBwYXJhbWV0ZXJzJTIwaWYlMjBkb19zYW1wbGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwaWYlMjBkb19zYW1wbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2t3YXJncyU1QiUyMnRlbXBlcmF0dXJlJTIyJTVEJTIwJTNEJTIwdGVtcGVyYXR1cmUlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipnZW5lcmF0aW9uX2t3YXJncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBEZWNvZGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUUyJTlDJTg1JTIwR2VuZXJhdGlvbiUyMGNvbXBsZXRlZCElMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU4QSUyMEdlbmVyYXRlZCUyMCU3QmxlbihvdXRwdXRzJTVCMCU1RCklMjAtJTIwbGVuKGlucHV0cyU1QidpbnB1dF9pZHMnJTVEJTVCMCU1RCklN0QlMjBuZXclMjB0b2tlbnMlMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_function_call</span>(<span class="hljs-params">model: AutoModelForCausalLM,
                          tokenizer: AutoTokenizer, 
                          prompt: <span class="hljs-built_in">str</span>,
                          max_new_tokens: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>,
                          temperature: <span class="hljs-built_in">float</span> = <span class="hljs-number">0.7</span>,
                          do_sample: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a function call response using the fine-tuned model.
    
    Args:
        model (AutoModelForCausalLM): Fine-tuned model with LoRA adapters
        tokenizer (AutoTokenizer): Model tokenizer
        prompt (str): Input prompt for function calling
        max_new_tokens (int): Maximum tokens to generate
        temperature (float): Sampling temperature (only used when do_sample=True)
        do_sample (bool): Whether to use sampling
        
    Returns:
        str: Generated response with function calls
        
    Example Prompt Format:
        &quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🎯 Generating response for prompt...&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📝 Input: <span class="hljs-subst">{prompt}</span>&quot;</span>)

    <span class="hljs-comment"># Tokenize input</span>
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
    
    <span class="hljs-comment"># Generate response with proper parameter handling</span>
    generation_kwargs = {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: max_new_tokens,
        <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.pad_token_id,
        <span class="hljs-string">&quot;eos_token_id&quot;</span>: tokenizer.eos_token_id,
        <span class="hljs-string">&quot;do_sample&quot;</span>: do_sample,
    }
    
    <span class="hljs-comment"># Only add sampling parameters if do_sample=True</span>
    <span class="hljs-keyword">if</span> do_sample:
        generation_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = temperature
    
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model.generate(
            **inputs,
            **generation_kwargs
        )
    
    <span class="hljs-comment"># Decode result</span>
    result = tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Generation completed!&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📊 Generated <span class="hljs-subst">{<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>]) - <span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&#x27;input_ids&#x27;</span>][<span class="hljs-number">0</span>])}</span> new tokens&quot;</span>)
    
    <span class="hljs-keyword">return</span> result`,wrap:!1}}),_l=new w({props:{title:"Testing Function Calling Capabilities",local:"testing-function-calling-capabilities",headingTag:"h2"}}),Nl=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">test_function_calling_examples</span>(<span class="hljs-params">model: AutoModelForCausalLM, 
                                  tokenizer: AutoTokenizer</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Test the model with various function calling examples.
    
    Args:
        model (AutoModelForCausalLM): Fine-tuned model
        tokenizer (AutoTokenizer): Model tokenizer
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🧪 Testing function calling capabilities...&quot;</span>)
    
    test_cases = [
        {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Mathematical Function&quot;</span>,
            <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>
        },
        {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Weather Query&quot;</span>, 
            <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;What&#x27;s the weather like in New York today?&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>
        },
        {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Data Processing&quot;</span>,
            <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;&lt;user&gt;Calculate the average of these numbers: 10, 20, 30, 40, 50&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>
        }
    ]
    
    <span class="hljs-keyword">for</span> i, test_case <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(test_cases, <span class="hljs-number">1</span>):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n<span class="hljs-subst">{<span class="hljs-string">&#x27;=&#x27;</span>*<span class="hljs-number">60</span>}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Test Case <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{test_case[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-string">&#x27;=&#x27;</span>*<span class="hljs-number">60</span>}</span>&quot;</span>)
        
        result = generate_function_call(
            model=model,
            tokenizer=tokenizer,
            prompt=test_case[<span class="hljs-string">&quot;prompt&quot;</span>],
            max_new_tokens=<span class="hljs-number">512</span>,  <span class="hljs-comment"># Adjust as needed</span>
            temperature=<span class="hljs-number">0.7</span>,
            do_sample=<span class="hljs-literal">True</span>  <span class="hljs-comment"># Fixed: Use sampling with temperature</span>
        )
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🔍 Complete Response:&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
        <span class="hljs-built_in">print</span>(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">40</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n✅ All test cases completed!&quot;</span>)`,wrap:!1}}),Sl=new c({props:{code:"JTIzJTIwTG9hZCUyMGFuZCUyMHRlc3QlMjB0aGUlMjB0cmFpbmVkJTIwbW9kZWwlMEElMjMlMjBOb3RlJTNBJTIwWW91JTIwbWF5JTIwbmVlZCUyMHRvJTIwcmVzdGFydCUyMHRoZSUyMG5vdGVib29rJTIwdG8lMjBmcmVlJTIwbWVtb3J5JTIwYmVmb3JlJTIwcnVubmluZyUyMHRoaXMlMEElMEFwcmludCglMjIlRjAlOUYlOTQlODQlMjBMb2FkaW5nJTIwdHJhaW5lZCUyMG1vZGVsJTIwZm9yJTIwdGVzdGluZy4uLiUyMiklMEFwcmludCglMjIlRTIlOUElQTAlRUYlQjglOEYlMjAlMjBJZiUyMHlvdSUyMGVuY291bnRlciUyMG1lbW9yeSUyMGlzc3VlcyUyQyUyMHJlc3RhcnQlMjB0aGUlMjBub3RlYm9vayUyMGFuZCUyMHJ1biUyMG9ubHklMjB0aGlzJTIwY2VsbCUyMiklMEElMEElMjMlMjBEZXRlcm1pbmUlMjB0aGUlMjBhZGFwdGVyJTIwcGF0aCUyMGJhc2VkJTIwb24lMjB0aGUlMjB0cmFpbmluZyUyMGNvbmZpZ3VyYXRpb24lMEFhZGFwdGVyX3BhdGglMjAlM0QlMjBmJTIyJTdCdHJhaW5pbmdfY29uZmlnLm91dHB1dF9kaXIlN0QlMkZjaGVja3BvaW50LSU3QnRyYWluaW5nX2NvbmZpZy5tYXhfc3RlcHMlN0QlMjIlMEElMEFwcmludChmJTIyJUYwJTlGJTkzJTgxJTIwTG9va2luZyUyMGZvciUyMGFkYXB0ZXIlMjBhdCUzQSUyMCU3QmFkYXB0ZXJfcGF0aCU3RCUyMiklMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwdHJhaW5lZCUyMG1vZGVsJTBBdHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyJTIwJTNEJTIwbG9hZF90cmFpbmVkX21vZGVsKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2NvbmZpZyUzRG1vZGVsX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfcGF0aCUzRGFkYXB0ZXJfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfZHR5cGUlM0Rjb21wdXRlX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRGF0dG5faW1wbGVtZW50YXRpb24lMEEpJTBBJTBBJTIzJTIwVGVzdCUyMHdpdGglMjBhJTIwc2luZ2xlJTIwZXhhbXBsZSUwQXRlc3RfcHJvbXB0JTIwJTNEJTIwJTIyJTNDdXNlciUzRUNoZWNrJTIwaWYlMjB0aGUlMjBudW1iZXJzJTIwOCUyMGFuZCUyMDEyMzMlMjBhcmUlMjBwb3dlcnMlMjBvZiUyMHR3by4lM0MlMkZ1c2VyJTNFJTVDbiU1Q24lM0N0b29scyUzRSUyMiUwQXJlc3VsdCUyMCUzRCUyMGdlbmVyYXRlX2Z1bmN0aW9uX2NhbGwodHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyJTJDJTIwdGVzdF9wcm9tcHQpJTBBJTBBcHJpbnQoZiUyMiU1Q24lRjAlOUYlOEUlQUYlMjBUZXN0JTIwUmVzdWx0JTIwZm9yJTIwJTdCbW9kZWxfY29uZmlnLm1vZGVsX25hbWUuc3BsaXQoJyUyRicpJTVCLTElNUQlN0QlM0ElMjIpJTBBcHJpbnQoJTIyJTNEJTIyKjgwKSUwQXByaW50KHJlc3VsdCklMEFwcmludCglMjIlM0QlMjIqODAp",highlighted:`<span class="hljs-comment"># Load and test the trained model</span>
<span class="hljs-comment"># Note: You may need to restart the notebook to free memory before running this</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔄 Loading trained model for testing...&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;⚠️  If you encounter memory issues, restart the notebook and run only this cell&quot;</span>)

<span class="hljs-comment"># Determine the adapter path based on the training configuration</span>
adapter_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{training_config.output_dir}</span>/checkpoint-<span class="hljs-subst">{training_config.max_steps}</span>&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📁 Looking for adapter at: <span class="hljs-subst">{adapter_path}</span>&quot;</span>)

<span class="hljs-comment"># Load the trained model</span>
trained_model, trained_tokenizer = load_trained_model(
    model_config=model_config,
    adapter_path=adapter_path,
    compute_dtype=compute_dtype,
    attn_implementation=attn_implementation
)

<span class="hljs-comment"># Test with a single example</span>
test_prompt = <span class="hljs-string">&quot;&lt;user&gt;Check if the numbers 8 and 1233 are powers of two.&lt;/user&gt;\\n\\n&lt;tools&gt;&quot;</span>
result = generate_function_call(trained_model, trained_tokenizer, test_prompt)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\n🎯 Test Result for <span class="hljs-subst">{model_config.model_name.split(<span class="hljs-string">&#x27;/&#x27;</span>)[-<span class="hljs-number">1</span>]}</span>:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">80</span>)
<span class="hljs-built_in">print</span>(result)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">80</span>)`,wrap:!1}}),Fl=new c({props:{code:"JTIzJTIwUnVuJTIwY29tcHJlaGVuc2l2ZSUyMHRlc3RpbmclMjBzdWl0ZSUyMGZvciUyMHlvdXIlMjB0cmFpbmVkJTIwbW9kZWwlMEF0ZXN0X2Z1bmN0aW9uX2NhbGxpbmdfZXhhbXBsZXModHJhaW5lZF9tb2RlbCUyQyUyMHRyYWluZWRfdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run comprehensive testing suite for your trained model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_function_calling_examples(trained_model, trained_tokenizer)`,wrap:!1}}),Yl=new w({props:{title:"🎉 Conclusion and Next Steps",local:"-conclusion-and-next-steps",headingTag:"h2"}}),zl=new w({props:{title:"📊 Summary",local:"-summary",headingTag:"h3"}}),ql=new w({props:{title:"🚀 Key Improvements Made",local:"-key-improvements-made",headingTag:"h3"}}),$l=new w({props:{title:"Universal Compatibility",local:"universal-compatibility",headingTag:"h4"}}),Dl=new w({props:{title:"Code Quality",local:"code-quality",headingTag:"h4"}}),Ol=new w({props:{title:"User Experience",local:"user-experience",headingTag:"h4"}}),ls=new w({props:{title:"🔄 Next Steps and Extensions",local:"-next-steps-and-extensions",headingTag:"h3"}}),ss=new w({props:{title:"Model Improvements",local:"model-improvements",headingTag:"h4"}}),Ms=new w({props:{title:"Evaluation Enhancements",local:"evaluation-enhancements",headingTag:"h4"}}),ts=new w({props:{title:"Deployment Options",local:"deployment-options",headingTag:"h4"}}),ps=new w({props:{title:"Additional Features",local:"additional-features",headingTag:"h4"}}),ys=new w({props:{title:"📚 Resources and References",local:"-resources-and-references",headingTag:"h3"}}),js=new w({props:{title:"🎖️ Achievement Unlocked",local:"-achievement-unlocked",headingTag:"h3"}}),ws=new Xa({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/function_calling_fine_tuning_llms_on_xlam.md"}}),{c(){m=e("meta"),Is=a(),cs=e("p"),rs=a(),i(I.$$.fragment),us=a(),i(r.$$.fragment),ds=a(),i(u.$$.fragment),Cs=a(),d=e("p"),d.innerHTML=AM,bs=a(),C=e("p"),C.innerHTML=BM,hs=a(),b=e("p"),b.innerHTML=gM,As=a(),h=e("p"),h.innerHTML=ZM,Bs=a(),A=e("ul"),A.innerHTML=fM,gs=a(),B=e("p"),B.innerHTML=GM,Zs=a(),g=e("ul"),g.innerHTML=RM,fs=a(),Z=e("p"),Z.innerHTML=WM,Gs=a(),f=e("ul"),f.innerHTML=EM,Rs=a(),G=e("p"),G.innerHTML=XM,Ws=a(),R=e("ul"),R.innerHTML=QM,Es=a(),W=e("p"),W.innerHTML=VM,Xs=a(),i(E.$$.fragment),Qs=a(),i(X.$$.fragment),Vs=a(),Q=e("p"),Q.textContent=_M,_s=a(),i(V.$$.fragment),ks=a(),_=e("pre"),_.textContent=kM,Ns=a(),i(k.$$.fragment),Ss=a(),N=e("p"),N.textContent=NM,Fs=a(),i(S.$$.fragment),vs=a(),F=e("pre"),F.textContent=SM,Ys=a(),i(v.$$.fragment),zs=a(),Y=e("p"),Y.textContent=FM,Hs=a(),z=e("ol"),z.innerHTML=vM,xs=a(),i(H.$$.fragment),qs=a(),i(x.$$.fragment),$s=a(),q=e("p"),q.textContent=YM,Ls=a(),i($.$$.fragment),Ds=a(),i(L.$$.fragment),Ks=a(),D=e("pre"),D.textContent=zM,Os=a(),i(K.$$.fragment),Ps=a(),O=e("p"),O.textContent=HM,ln=a(),i(P.$$.fragment),sn=a(),i(ll.$$.fragment),nn=a(),sl=e("p"),sl.textContent=xM,Mn=a(),i(nl.$$.fragment),an=a(),Ml=e("pre"),Ml.textContent=qM,tn=a(),i(al.$$.fragment),en=a(),tl=e("p"),tl.textContent=$M,pn=a(),el=e("p"),el.innerHTML=LM,yn=a(),pl=e("ul"),pl.innerHTML=DM,Jn=a(),i(il.$$.fragment),jn=a(),i(yl.$$.fragment),Un=a(),i(Jl.$$.fragment),Tn=a(),i(jl.$$.fragment),on=a(),Ul=e("p"),Ul.textContent=KM,wn=a(),i(Tl.$$.fragment),cn=a(),i(ol.$$.fragment),mn=a(),wl=e("p"),wl.textContent=OM,In=a(),i(cl.$$.fragment),rn=a(),i(ml.$$.fragment),un=a(),Il=e("p"),Il.textContent=PM,dn=a(),i(rl.$$.fragment),Cn=a(),ul=e("p"),ul.textContent=la,bn=a(),i(dl.$$.fragment),hn=a(),i(Cl.$$.fragment),An=a(),bl=e("p"),bl.innerHTML=sa,Bn=a(),i(hl.$$.fragment),gn=a(),Al=e("p"),Al.textContent=na,Zn=a(),Bl=e("p"),Bl.innerHTML=Ma,fn=a(),gl=e("ul"),gl.innerHTML=aa,Gn=a(),i(Zl.$$.fragment),Rn=a(),fl=e("pre"),fl.textContent=ta,Wn=a(),i(Gl.$$.fragment),En=a(),i(Rl.$$.fragment),Xn=a(),Wl=e("p"),Wl.textContent=ea,Qn=a(),i(El.$$.fragment),Vn=a(),i(Xl.$$.fragment),_n=a(),Ql=e("p"),Ql.textContent=pa,kn=a(),i(Vl.$$.fragment),Nn=a(),i(_l.$$.fragment),Sn=a(),kl=e("p"),kl.textContent=ia,Fn=a(),i(Nl.$$.fragment),vn=a(),i(Sl.$$.fragment),Yn=a(),i(Fl.$$.fragment),zn=a(),vl=e("pre"),vl.innerHTML=ya,Hn=a(),i(Yl.$$.fragment),xn=a(),qn=e("hr"),$n=a(),i(zl.$$.fragment),Ln=a(),Hl=e("p"),Hl.innerHTML=Ja,Dn=a(),xl=e("ul"),xl.innerHTML=ja,Kn=a(),i(ql.$$.fragment),On=a(),i($l.$$.fragment),Pn=a(),Ll=e("ul"),Ll.innerHTML=Ua,lM=a(),i(Dl.$$.fragment),sM=a(),Kl=e("ul"),Kl.innerHTML=Ta,nM=a(),i(Ol.$$.fragment),MM=a(),Pl=e("ul"),Pl.innerHTML=oa,aM=a(),i(ls.$$.fragment),tM=a(),i(ss.$$.fragment),eM=a(),ns=e("ol"),ns.innerHTML=wa,pM=a(),i(Ms.$$.fragment),iM=a(),as=e("ol"),as.innerHTML=ca,yM=a(),i(ts.$$.fragment),JM=a(),es=e("ol"),es.innerHTML=ma,jM=a(),i(ps.$$.fragment),UM=a(),is=e("ol"),is.innerHTML=Ia,TM=a(),i(ys.$$.fragment),oM=a(),Js=e("ul"),Js.innerHTML=ra,wM=a(),i(js.$$.fragment),cM=a(),Us=e("p"),Us.innerHTML=ua,mM=a(),Ts=e("p"),Ts.textContent=da,IM=a(),rM=e("hr"),uM=a(),os=e("p"),os.innerHTML=Ca,dM=a(),i(ws.$$.fragment),CM=a(),ms=e("p"),this.h()},l(l){const s=Ga("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(n),Is=t(l),cs=p(l,"P",{}),ba(cs).forEach(n),rs=t(l),y(I.$$.fragment,l),us=t(l),y(r.$$.fragment,l),ds=t(l),y(u.$$.fragment,l),Cs=t(l),d=p(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1wcfxf7"&&(d.innerHTML=AM),bs=t(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-nk8pjg"&&(C.innerHTML=BM),hs=t(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-p86hf7"&&(b.innerHTML=gM),As=t(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-144uh4x"&&(h.innerHTML=ZM),Bs=t(l),A=p(l,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-1lvcm95"&&(A.innerHTML=fM),gs=t(l),B=p(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1c3q00"&&(B.innerHTML=GM),Zs=t(l),g=p(l,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1ygkxbz"&&(g.innerHTML=RM),fs=t(l),Z=p(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1l0t8mb"&&(Z.innerHTML=WM),Gs=t(l),f=p(l,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-19sjw7i"&&(f.innerHTML=EM),Rs=t(l),G=p(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-ygvktk"&&(G.innerHTML=XM),Ws=t(l),R=p(l,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-tnnr46"&&(R.innerHTML=QM),Es=t(l),W=p(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-cucop9"&&(W.innerHTML=VM),Xs=t(l),y(E.$$.fragment,l),Qs=t(l),y(X.$$.fragment,l),Vs=t(l),Q=p(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-4pzxfo"&&(Q.textContent=_M),_s=t(l),y(V.$$.fragment,l),ks=t(l),_=p(l,"PRE",{"data-svelte-h":!0}),o(_)!=="svelte-1nn5gbv"&&(_.textContent=kM),Ns=t(l),y(k.$$.fragment,l),Ss=t(l),N=p(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-h19jbj"&&(N.textContent=NM),Fs=t(l),y(S.$$.fragment,l),vs=t(l),F=p(l,"PRE",{"data-svelte-h":!0}),o(F)!=="svelte-1yaudwa"&&(F.textContent=SM),Ys=t(l),y(v.$$.fragment,l),zs=t(l),Y=p(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1rfz7gc"&&(Y.textContent=FM),Hs=t(l),z=p(l,"OL",{"data-svelte-h":!0}),o(z)!=="svelte-ewbwt7"&&(z.innerHTML=vM),xs=t(l),y(H.$$.fragment,l),qs=t(l),y(x.$$.fragment,l),$s=t(l),q=p(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1v4wkkr"&&(q.textContent=YM),Ls=t(l),y($.$$.fragment,l),Ds=t(l),y(L.$$.fragment,l),Ks=t(l),D=p(l,"PRE",{"data-svelte-h":!0}),o(D)!=="svelte-euglyw"&&(D.textContent=zM),Os=t(l),y(K.$$.fragment,l),Ps=t(l),O=p(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1apgrdp"&&(O.textContent=HM),ln=t(l),y(P.$$.fragment,l),sn=t(l),y(ll.$$.fragment,l),nn=t(l),sl=p(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-16i4o06"&&(sl.textContent=xM),Mn=t(l),y(nl.$$.fragment,l),an=t(l),Ml=p(l,"PRE",{"data-svelte-h":!0}),o(Ml)!=="svelte-fqnc52"&&(Ml.textContent=qM),tn=t(l),y(al.$$.fragment,l),en=t(l),tl=p(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1c113tt"&&(tl.textContent=$M),pn=t(l),el=p(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1da1j5l"&&(el.innerHTML=LM),yn=t(l),pl=p(l,"UL",{"data-svelte-h":!0}),o(pl)!=="svelte-1bzadrj"&&(pl.innerHTML=DM),Jn=t(l),y(il.$$.fragment,l),jn=t(l),y(yl.$$.fragment,l),Un=t(l),y(Jl.$$.fragment,l),Tn=t(l),y(jl.$$.fragment,l),on=t(l),Ul=p(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-y099h"&&(Ul.textContent=KM),wn=t(l),y(Tl.$$.fragment,l),cn=t(l),y(ol.$$.fragment,l),mn=t(l),wl=p(l,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-10lfqbi"&&(wl.textContent=OM),In=t(l),y(cl.$$.fragment,l),rn=t(l),y(ml.$$.fragment,l),un=t(l),Il=p(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-q6lhkl"&&(Il.textContent=PM),dn=t(l),y(rl.$$.fragment,l),Cn=t(l),ul=p(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-8nn6e4"&&(ul.textContent=la),bn=t(l),y(dl.$$.fragment,l),hn=t(l),y(Cl.$$.fragment,l),An=t(l),bl=p(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-m8etyh"&&(bl.innerHTML=sa),Bn=t(l),y(hl.$$.fragment,l),gn=t(l),Al=p(l,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-1o215q8"&&(Al.textContent=na),Zn=t(l),Bl=p(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-1ds7t4j"&&(Bl.innerHTML=Ma),fn=t(l),gl=p(l,"UL",{"data-svelte-h":!0}),o(gl)!=="svelte-4ybqyv"&&(gl.innerHTML=aa),Gn=t(l),y(Zl.$$.fragment,l),Rn=t(l),fl=p(l,"PRE",{"data-svelte-h":!0}),o(fl)!=="svelte-c4t8wc"&&(fl.textContent=ta),Wn=t(l),y(Gl.$$.fragment,l),En=t(l),y(Rl.$$.fragment,l),Xn=t(l),Wl=p(l,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-exsagt"&&(Wl.textContent=ea),Qn=t(l),y(El.$$.fragment,l),Vn=t(l),y(Xl.$$.fragment,l),_n=t(l),Ql=p(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-1b6dez5"&&(Ql.textContent=pa),kn=t(l),y(Vl.$$.fragment,l),Nn=t(l),y(_l.$$.fragment,l),Sn=t(l),kl=p(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-10wzkmt"&&(kl.textContent=ia),Fn=t(l),y(Nl.$$.fragment,l),vn=t(l),y(Sl.$$.fragment,l),Yn=t(l),y(Fl.$$.fragment,l),zn=t(l),vl=p(l,"PRE",{"data-svelte-h":!0}),o(vl)!=="svelte-yrs79z"&&(vl.innerHTML=ya),Hn=t(l),y(Yl.$$.fragment,l),xn=t(l),qn=p(l,"HR",{}),$n=t(l),y(zl.$$.fragment,l),Ln=t(l),Hl=p(l,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-1okcj8g"&&(Hl.innerHTML=Ja),Dn=t(l),xl=p(l,"UL",{"data-svelte-h":!0}),o(xl)!=="svelte-1b0hkxy"&&(xl.innerHTML=ja),Kn=t(l),y(ql.$$.fragment,l),On=t(l),y($l.$$.fragment,l),Pn=t(l),Ll=p(l,"UL",{"data-svelte-h":!0}),o(Ll)!=="svelte-1he7ow6"&&(Ll.innerHTML=Ua),lM=t(l),y(Dl.$$.fragment,l),sM=t(l),Kl=p(l,"UL",{"data-svelte-h":!0}),o(Kl)!=="svelte-x5pxte"&&(Kl.innerHTML=Ta),nM=t(l),y(Ol.$$.fragment,l),MM=t(l),Pl=p(l,"UL",{"data-svelte-h":!0}),o(Pl)!=="svelte-1co223r"&&(Pl.innerHTML=oa),aM=t(l),y(ls.$$.fragment,l),tM=t(l),y(ss.$$.fragment,l),eM=t(l),ns=p(l,"OL",{"data-svelte-h":!0}),o(ns)!=="svelte-1xupp26"&&(ns.innerHTML=wa),pM=t(l),y(Ms.$$.fragment,l),iM=t(l),as=p(l,"OL",{"data-svelte-h":!0}),o(as)!=="svelte-1xcwpje"&&(as.innerHTML=ca),yM=t(l),y(ts.$$.fragment,l),JM=t(l),es=p(l,"OL",{"data-svelte-h":!0}),o(es)!=="svelte-1hftmkl"&&(es.innerHTML=ma),jM=t(l),y(ps.$$.fragment,l),UM=t(l),is=p(l,"OL",{"data-svelte-h":!0}),o(is)!=="svelte-1vc2fxa"&&(is.innerHTML=Ia),TM=t(l),y(ys.$$.fragment,l),oM=t(l),Js=p(l,"UL",{"data-svelte-h":!0}),o(Js)!=="svelte-7yazkv"&&(Js.innerHTML=ra),wM=t(l),y(js.$$.fragment,l),cM=t(l),Us=p(l,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1m5ldvz"&&(Us.innerHTML=ua),mM=t(l),Ts=p(l,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1oyjwag"&&(Ts.textContent=da),IM=t(l),rM=p(l,"HR",{}),uM=t(l),os=p(l,"P",{"data-svelte-h":!0}),o(os)!=="svelte-186p5gg"&&(os.innerHTML=Ca),dM=t(l),y(ws.$$.fragment,l),CM=t(l),ms=p(l,"P",{}),ba(ms).forEach(n),this.h()},h(){ha(m,"name","hf:doc:metadata"),ha(m,"content",Va)},m(l,s){Ra(document.head,m),M(l,Is,s),M(l,cs,s),M(l,rs,s),J(I,l,s),M(l,us,s),J(r,l,s),M(l,ds,s),J(u,l,s),M(l,Cs,s),M(l,d,s),M(l,bs,s),M(l,C,s),M(l,hs,s),M(l,b,s),M(l,As,s),M(l,h,s),M(l,Bs,s),M(l,A,s),M(l,gs,s),M(l,B,s),M(l,Zs,s),M(l,g,s),M(l,fs,s),M(l,Z,s),M(l,Gs,s),M(l,f,s),M(l,Rs,s),M(l,G,s),M(l,Ws,s),M(l,R,s),M(l,Es,s),M(l,W,s),M(l,Xs,s),J(E,l,s),M(l,Qs,s),J(X,l,s),M(l,Vs,s),M(l,Q,s),M(l,_s,s),J(V,l,s),M(l,ks,s),M(l,_,s),M(l,Ns,s),J(k,l,s),M(l,Ss,s),M(l,N,s),M(l,Fs,s),J(S,l,s),M(l,vs,s),M(l,F,s),M(l,Ys,s),J(v,l,s),M(l,zs,s),M(l,Y,s),M(l,Hs,s),M(l,z,s),M(l,xs,s),J(H,l,s),M(l,qs,s),J(x,l,s),M(l,$s,s),M(l,q,s),M(l,Ls,s),J($,l,s),M(l,Ds,s),J(L,l,s),M(l,Ks,s),M(l,D,s),M(l,Os,s),J(K,l,s),M(l,Ps,s),M(l,O,s),M(l,ln,s),J(P,l,s),M(l,sn,s),J(ll,l,s),M(l,nn,s),M(l,sl,s),M(l,Mn,s),J(nl,l,s),M(l,an,s),M(l,Ml,s),M(l,tn,s),J(al,l,s),M(l,en,s),M(l,tl,s),M(l,pn,s),M(l,el,s),M(l,yn,s),M(l,pl,s),M(l,Jn,s),J(il,l,s),M(l,jn,s),J(yl,l,s),M(l,Un,s),J(Jl,l,s),M(l,Tn,s),J(jl,l,s),M(l,on,s),M(l,Ul,s),M(l,wn,s),J(Tl,l,s),M(l,cn,s),J(ol,l,s),M(l,mn,s),M(l,wl,s),M(l,In,s),J(cl,l,s),M(l,rn,s),J(ml,l,s),M(l,un,s),M(l,Il,s),M(l,dn,s),J(rl,l,s),M(l,Cn,s),M(l,ul,s),M(l,bn,s),J(dl,l,s),M(l,hn,s),J(Cl,l,s),M(l,An,s),M(l,bl,s),M(l,Bn,s),J(hl,l,s),M(l,gn,s),M(l,Al,s),M(l,Zn,s),M(l,Bl,s),M(l,fn,s),M(l,gl,s),M(l,Gn,s),J(Zl,l,s),M(l,Rn,s),M(l,fl,s),M(l,Wn,s),J(Gl,l,s),M(l,En,s),J(Rl,l,s),M(l,Xn,s),M(l,Wl,s),M(l,Qn,s),J(El,l,s),M(l,Vn,s),J(Xl,l,s),M(l,_n,s),M(l,Ql,s),M(l,kn,s),J(Vl,l,s),M(l,Nn,s),J(_l,l,s),M(l,Sn,s),M(l,kl,s),M(l,Fn,s),J(Nl,l,s),M(l,vn,s),J(Sl,l,s),M(l,Yn,s),J(Fl,l,s),M(l,zn,s),M(l,vl,s),M(l,Hn,s),J(Yl,l,s),M(l,xn,s),M(l,qn,s),M(l,$n,s),J(zl,l,s),M(l,Ln,s),M(l,Hl,s),M(l,Dn,s),M(l,xl,s),M(l,Kn,s),J(ql,l,s),M(l,On,s),J($l,l,s),M(l,Pn,s),M(l,Ll,s),M(l,lM,s),J(Dl,l,s),M(l,sM,s),M(l,Kl,s),M(l,nM,s),J(Ol,l,s),M(l,MM,s),M(l,Pl,s),M(l,aM,s),J(ls,l,s),M(l,tM,s),J(ss,l,s),M(l,eM,s),M(l,ns,s),M(l,pM,s),J(Ms,l,s),M(l,iM,s),M(l,as,s),M(l,yM,s),J(ts,l,s),M(l,JM,s),M(l,es,s),M(l,jM,s),J(ps,l,s),M(l,UM,s),M(l,is,s),M(l,TM,s),J(ys,l,s),M(l,oM,s),M(l,Js,s),M(l,wM,s),J(js,l,s),M(l,cM,s),M(l,Us,s),M(l,mM,s),M(l,Ts,s),M(l,IM,s),M(l,rM,s),M(l,uM,s),M(l,os,s),M(l,dM,s),J(ws,l,s),M(l,CM,s),M(l,ms,s),bM=!0},p:Ba,i(l){bM||(j(I.$$.fragment,l),j(r.$$.fragment,l),j(u.$$.fragment,l),j(E.$$.fragment,l),j(X.$$.fragment,l),j(V.$$.fragment,l),j(k.$$.fragment,l),j(S.$$.fragment,l),j(v.$$.fragment,l),j(H.$$.fragment,l),j(x.$$.fragment,l),j($.$$.fragment,l),j(L.$$.fragment,l),j(K.$$.fragment,l),j(P.$$.fragment,l),j(ll.$$.fragment,l),j(nl.$$.fragment,l),j(al.$$.fragment,l),j(il.$$.fragment,l),j(yl.$$.fragment,l),j(Jl.$$.fragment,l),j(jl.$$.fragment,l),j(Tl.$$.fragment,l),j(ol.$$.fragment,l),j(cl.$$.fragment,l),j(ml.$$.fragment,l),j(rl.$$.fragment,l),j(dl.$$.fragment,l),j(Cl.$$.fragment,l),j(hl.$$.fragment,l),j(Zl.$$.fragment,l),j(Gl.$$.fragment,l),j(Rl.$$.fragment,l),j(El.$$.fragment,l),j(Xl.$$.fragment,l),j(Vl.$$.fragment,l),j(_l.$$.fragment,l),j(Nl.$$.fragment,l),j(Sl.$$.fragment,l),j(Fl.$$.fragment,l),j(Yl.$$.fragment,l),j(zl.$$.fragment,l),j(ql.$$.fragment,l),j($l.$$.fragment,l),j(Dl.$$.fragment,l),j(Ol.$$.fragment,l),j(ls.$$.fragment,l),j(ss.$$.fragment,l),j(Ms.$$.fragment,l),j(ts.$$.fragment,l),j(ps.$$.fragment,l),j(ys.$$.fragment,l),j(js.$$.fragment,l),j(ws.$$.fragment,l),bM=!0)},o(l){U(I.$$.fragment,l),U(r.$$.fragment,l),U(u.$$.fragment,l),U(E.$$.fragment,l),U(X.$$.fragment,l),U(V.$$.fragment,l),U(k.$$.fragment,l),U(S.$$.fragment,l),U(v.$$.fragment,l),U(H.$$.fragment,l),U(x.$$.fragment,l),U($.$$.fragment,l),U(L.$$.fragment,l),U(K.$$.fragment,l),U(P.$$.fragment,l),U(ll.$$.fragment,l),U(nl.$$.fragment,l),U(al.$$.fragment,l),U(il.$$.fragment,l),U(yl.$$.fragment,l),U(Jl.$$.fragment,l),U(jl.$$.fragment,l),U(Tl.$$.fragment,l),U(ol.$$.fragment,l),U(cl.$$.fragment,l),U(ml.$$.fragment,l),U(rl.$$.fragment,l),U(dl.$$.fragment,l),U(Cl.$$.fragment,l),U(hl.$$.fragment,l),U(Zl.$$.fragment,l),U(Gl.$$.fragment,l),U(Rl.$$.fragment,l),U(El.$$.fragment,l),U(Xl.$$.fragment,l),U(Vl.$$.fragment,l),U(_l.$$.fragment,l),U(Nl.$$.fragment,l),U(Sl.$$.fragment,l),U(Fl.$$.fragment,l),U(Yl.$$.fragment,l),U(zl.$$.fragment,l),U(ql.$$.fragment,l),U($l.$$.fragment,l),U(Dl.$$.fragment,l),U(Ol.$$.fragment,l),U(ls.$$.fragment,l),U(ss.$$.fragment,l),U(Ms.$$.fragment,l),U(ts.$$.fragment,l),U(ps.$$.fragment,l),U(ys.$$.fragment,l),U(js.$$.fragment,l),U(ws.$$.fragment,l),bM=!1},d(l){l&&(n(Is),n(cs),n(rs),n(us),n(ds),n(Cs),n(d),n(bs),n(C),n(hs),n(b),n(As),n(h),n(Bs),n(A),n(gs),n(B),n(Zs),n(g),n(fs),n(Z),n(Gs),n(f),n(Rs),n(G),n(Ws),n(R),n(Es),n(W),n(Xs),n(Qs),n(Vs),n(Q),n(_s),n(ks),n(_),n(Ns),n(Ss),n(N),n(Fs),n(vs),n(F),n(Ys),n(zs),n(Y),n(Hs),n(z),n(xs),n(qs),n($s),n(q),n(Ls),n(Ds),n(Ks),n(D),n(Os),n(Ps),n(O),n(ln),n(sn),n(nn),n(sl),n(Mn),n(an),n(Ml),n(tn),n(en),n(tl),n(pn),n(el),n(yn),n(pl),n(Jn),n(jn),n(Un),n(Tn),n(on),n(Ul),n(wn),n(cn),n(mn),n(wl),n(In),n(rn),n(un),n(Il),n(dn),n(Cn),n(ul),n(bn),n(hn),n(An),n(bl),n(Bn),n(gn),n(Al),n(Zn),n(Bl),n(fn),n(gl),n(Gn),n(Rn),n(fl),n(Wn),n(En),n(Xn),n(Wl),n(Qn),n(Vn),n(_n),n(Ql),n(kn),n(Nn),n(Sn),n(kl),n(Fn),n(vn),n(Yn),n(zn),n(vl),n(Hn),n(xn),n(qn),n($n),n(Ln),n(Hl),n(Dn),n(xl),n(Kn),n(On),n(Pn),n(Ll),n(lM),n(sM),n(Kl),n(nM),n(MM),n(Pl),n(aM),n(tM),n(eM),n(ns),n(pM),n(iM),n(as),n(yM),n(JM),n(es),n(jM),n(UM),n(is),n(TM),n(oM),n(Js),n(wM),n(cM),n(Us),n(mM),n(Ts),n(IM),n(rM),n(uM),n(os),n(dM),n(CM),n(ms)),n(m),T(I,l),T(r,l),T(u,l),T(E,l),T(X,l),T(V,l),T(k,l),T(S,l),T(v,l),T(H,l),T(x,l),T($,l),T(L,l),T(K,l),T(P,l),T(ll,l),T(nl,l),T(al,l),T(il,l),T(yl,l),T(Jl,l),T(jl,l),T(Tl,l),T(ol,l),T(cl,l),T(ml,l),T(rl,l),T(dl,l),T(Cl,l),T(hl,l),T(Zl,l),T(Gl,l),T(Rl,l),T(El,l),T(Xl,l),T(Vl,l),T(_l,l),T(Nl,l),T(Sl,l),T(Fl,l),T(Yl,l),T(zl,l),T(ql,l),T($l,l),T(Dl,l),T(Ol,l),T(ls,l),T(ss,l),T(Ms,l),T(ts,l),T(ps,l),T(ys,l),T(js,l),T(ws,l)}}}const Va='{"title":"Fine-tuning LLMs for Function Calling with xLAM Dataset","local":"fine-tuning-llms-for-function-calling-with-xlam-dataset","sections":[{"title":"Basic Setup and Imports","local":"basic-setup-and-imports","sections":[],"depth":2},{"title":"Hugging Face Authentication Setup","local":"hugging-face-authentication-setup","sections":[],"depth":2},{"title":"Model Configuration Classes","local":"model-configuration-classes","sections":[],"depth":2},{"title":"Automatic Model Configuration","local":"automatic-model-configuration","sections":[],"depth":2},{"title":"Hardware Detection and Setup","local":"hardware-detection-and-setup","sections":[],"depth":2},{"title":"Tokenizer Setup Function","local":"tokenizer-setup-function","sections":[],"depth":2},{"title":"Dataset Processing","local":"dataset-processing","sections":[],"depth":2},{"title":"Loading and Processing the Dataset","local":"loading-and-processing-the-dataset","sections":[],"depth":2},{"title":"QLoRA Training Setup","local":"qlora-training-setup","sections":[],"depth":2},{"title":"LoRA Configuration","local":"lora-configuration","sections":[],"depth":2},{"title":"Training Execution","local":"training-execution","sections":[],"depth":2},{"title":"🎯 Universal Model Selection","local":"-universal-model-selection","sections":[{"title":"📋 Quick Model Selection","local":"-quick-model-selection","sections":[],"depth":3}],"depth":2},{"title":"Model Loading for Inference","local":"model-loading-for-inference","sections":[],"depth":2},{"title":"Text Generation for Function Calls","local":"text-generation-for-function-calls","sections":[],"depth":2},{"title":"Testing Function Calling Capabilities","local":"testing-function-calling-capabilities","sections":[],"depth":2},{"title":"🎉 Conclusion and Next Steps","local":"-conclusion-and-next-steps","sections":[{"title":"📊 Summary","local":"-summary","sections":[],"depth":3},{"title":"🚀 Key Improvements Made","local":"-key-improvements-made","sections":[{"title":"Universal Compatibility","local":"universal-compatibility","sections":[],"depth":4},{"title":"Code Quality","local":"code-quality","sections":[],"depth":4},{"title":"User Experience","local":"user-experience","sections":[],"depth":4}],"depth":3},{"title":"🔄 Next Steps and Extensions","local":"-next-steps-and-extensions","sections":[{"title":"Model Improvements","local":"model-improvements","sections":[],"depth":4},{"title":"Evaluation Enhancements","local":"evaluation-enhancements","sections":[],"depth":4},{"title":"Deployment Options","local":"deployment-options","sections":[],"depth":4},{"title":"Additional Features","local":"additional-features","sections":[],"depth":4}],"depth":3},{"title":"📚 Resources and References","local":"-resources-and-references","sections":[],"depth":3},{"title":"🎖️ Achievement Unlocked","local":"-achievement-unlocked","sections":[],"depth":3}],"depth":2}],"depth":1}';function _a(hM){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ya extends Za{constructor(m){super(),fa(this,m,_a,Qa,Aa,{})}}export{Ya as component};
