import{s as ql,n as zl,o as Ql}from"../chunks/scheduler.1f027d5a.js";import{S as El,i as Dl,e as i,s as a,c as d,h as Pl,a as r,d as s,b as n,f as Nl,g as p,j as o,k as Ys,l as Al,m as l,n as u,t as m,o as c,p as b}from"../chunks/index.5cb6ce42.js";import{C as Sl}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Kl,C as h}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as f,E as Ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function ea(Xs){let y,st,et,lt,M,at,g,nt,x,it,$,Ns='Authored by: <a href="https://huggingface.co/aravindputrevu" rel="nofollow">Aravind Putrevu</a>',rt,T,qs='In this 5-minute quickstart tutorial, we use Cleanlab to detect various issues in an intent classification dataset composed of (text) customer service requests at an online bank. We consider a subset of the <a href="https://arxiv.org/abs/2106.04564" rel="nofollow">Banking77-OOS Dataset</a> containing 1,000 customer service requests which are classified into 10 categories based on their intent (you can run this same code on any text classification dataset). <a href="https://github.com/cleanlab/cleanlab" rel="nofollow">Cleanlab</a> automatically identifies bad examples in our dataset, including mislabeled data, out-of-scope examples (outliers), or otherwise ambiguous examples. Consider filtering or correcting such bad examples before you dive deep into modeling your data!',ot,v,zs="<strong>Overview of what we’ll do in this tutorial:</strong>",dt,J,Qs="<li><p>Use a pretrained transformer model to extract the text embeddings from the customer service requests</p></li> <li><p>Train a simple Logistic Regression model on the text embeddings to compute out-of-sample predicted probabilities</p></li> <li><p>Run Cleanlab’s <code>Datalab</code> audit with these predictions and embeddings in order to identify problems like: label issues, outliers, and near duplicates in the dataset.</p></li>",pt,_,ut,j,Es="Already have (out-of-sample) <code>pred_probs</code> from a model trained on an existing set of labels? Maybe you have some numeric <code>features</code> as well? Run the code below to find any potential label errors in your dataset.",mt,C,Ds="<strong>Note:</strong> If running on Colab, may want to use GPU (select: Runtime &gt; Change runtime type &gt; Hardware accelerator &gt; GPU)",ct,U,bt,W,ht,k,Ps="You can use <code>pip</code> to install all packages required for this tutorial as follows:",ft,Z,yt,G,wt,I,Mt,F,gt,B,xt,H,$t,V,As=`This dataset has 7 classes.
Classes: &#123;32, 34, 36, 11, 13, 46, 17}
`,Tt,R,Ss="Let’s view the i-th example in the dataset:",vt,L,Jt,Y,Ks=`Example Label: 11
Example Text: What can I do if my card still hasn't arrived after 2 weeks?
`,_t,X,Os="The data is stored as two numpy arrays:",jt,N,el="<li><code>raw_texts</code> stores the customer service requests utterances in text format</li> <li><code>labels</code> stores the intent categories (labels) for each example</li>",Ct,w,tl=`Bringing Your Own Data (BYOD)?
<p>You can easily replace the above with your own text dataset, and continue with the rest of the tutorial.</p>`,Ut,q,sl="Next we convert the text strings into vectors better suited as inputs for our ML models.",Wt,z,ll='We will use numeric representations from a pretrained Transformer model as embeddings of our text. The <a href="https://huggingface.co/docs/hub/sentence-transformers" rel="nofollow">Sentence Transformers</a> library offers simple methods to compute these embeddings for text data. Here, we load the pretrained <code>electra-small-discriminator</code> model, and then run our data through network to extract a vector embedding of each example.',kt,Q,Zt,E,al="Our subsequent ML model will directly operate on elements of <code>text_embeddings</code> in order to classify the customer service requests.",Gt,D,It,P,nl="A typical way to leverage pretrained networks for a particular classification task is to add a linear output layer and fine-tune the network parameters on the new data. However this can be computationally intensive. Alternatively, we can freeze the pretrained weights of the network and only train the output layer without having to rely on GPU(s). Here we do this conveniently by fitting a scikit-learn linear model on top of the extracted embeddings.",Ft,A,il="To identify label issues, cleanlab requires a probabilistic prediction from your model for each datapoint. However these predictions will be <em>overfit</em> (and thus unreliable) for datapoints the model was previously trained on. cleanlab is intended to only be used with <strong>out-of-sample</strong> predicted class probabilities, i.e. on datapoints held-out from the model during the training.",Bt,S,rl=`Here we obtain out-of-sample predicted class probabilities for every example in our dataset using a Logistic Regression model with cross-validation.
Make sure that the columns of your <code>pred_probs</code> are properly ordered with respect to the ordering of classes, which for Datalab is: lexicographically sorted by class name.`,Ht,K,Vt,O,Rt,ee,ol="Given feature embeddings and the (out-of-sample) predicted class probabilities obtained from any model you have, cleanlab can quickly help you identify low-quality examples in your dataset.",Lt,te,dl="Here, we use Cleanlab’s <code>Datalab</code> to find issues in our data. Datalab offers several ways of loading the data; we’ll simply wrap the training features and noisy labels in a dictionary.",Yt,se,Xt,le,pl="All that is need to audit your data is to call <code>find_issues()</code>. We pass in the predicted probabilities and the feature embeddings obtained above, but you do not necessarily need to provide all of this information depending on which types of issues you are interested in. The more inputs you provide, the more types of issues <code>Datalab</code> can detect in your data. Using a better model to produce these inputs will ensure cleanlab more accurately estimates issues.",Nt,ae,qt,ne,ul="The output would look like:",zt,ie,Qt,re,ml="After the audit is complete, review the findings using the <code>report</code> method:",Et,oe,Dt,de,cl=`Here is a summary of the different kinds of issues found in the data:

    issue_type  num_issues
       outlier          37
near_duplicate          14
         label          10
       non_iid           1

Dataset Information: num_examples: 1000, num_classes: 7


---------------------- outlier issues ----------------------

About this issue:
	Examples that are very different from the rest of the dataset 
    (i.e. potentially out-of-distribution or rare/anomalous instances).
    

Number of examples with this issue: 37
Overall dataset quality in terms of this issue: 0.3671

Examples representing most severe instances of this issue:
     is_outlier_issue  outlier_score
791              True       0.024866
601              True       0.031162
863              True       0.060738
355              True       0.064199
157              True       0.065075


------------------ near_duplicate issues -------------------

About this issue:
	A (near) duplicate issue refers to two or more examples in
    a dataset that are extremely similar to each other, relative
    to the rest of the dataset.  The examples flagged with this issue
    may be exactly duplicated, or lie atypically close together when
    represented as vectors (i.e. feature embeddings).
    

Number of examples with this issue: 14
Overall dataset quality in terms of this issue: 0.5961

Examples representing most severe instances of this issue:
     is_near_duplicate_issue  near_duplicate_score near_duplicate_sets  distance_to_nearest_neighbor
459                     True              0.009544               [429]                      0.000566
429                     True              0.009544               [459]                      0.000566
501                     True              0.046044          [412, 517]                      0.002781
412                     True              0.046044               [501]                      0.002781
698                     True              0.054626               [607]                      0.003314


----------------------- label issues -----------------------

About this issue:
	Examples whose given label is estimated to be potentially incorrect
    (e.g. due to annotation error) are flagged as having label issues.
    

Number of examples with this issue: 10
Overall dataset quality in terms of this issue: 0.9930

Examples representing most severe instances of this issue:
     is_label_issue  label_score  given_label  predicted_label
379           False     0.025486           32               11
100           False     0.032102           11               36
300           False     0.037742           32               46
485            True     0.057666           17               34
159            True     0.059408           13               11


---------------------- non_iid issues ----------------------

About this issue:
	Whether the dataset exhibits statistically significant
    violations of the IID assumption like:
    changepoints or shift, drift, autocorrelation, etc.
    The specific violation considered is whether the
    examples are ordered such that almost adjacent examples
    tend to have more similar feature values.
    

Number of examples with this issue: 1
Overall dataset quality in terms of this issue: 0.0000

Examples representing most severe instances of this issue:
     is_non_iid_issue  non_iid_score
988              True       0.563774
975             False       0.570179
997             False       0.571891
967             False       0.572357
956             False       0.577413

Additional Information: 
p-value: 0.0
`,Pt,pe,At,ue,bl="The report indicates that cleanlab identified many label issues in our dataset. We can see which examples are flagged as likely mislabeled and the label quality score for each example using the <code>get_issues</code> method, specifying <code>label</code> as an argument to focus on label issues in the data.",St,me,Kt,ce,hl="<thead><tr><th></th> <th>is_label_issue</th> <th>label_score</th> <th>given_label</th> <th>predicted_label</th></tr></thead> <tbody><tr><td>0</td> <td>False</td> <td>0.903926</td> <td>11</td> <td>11</td></tr> <tr><td>1</td> <td>False</td> <td>0.860544</td> <td>11</td> <td>11</td></tr> <tr><td>2</td> <td>False</td> <td>0.658309</td> <td>11</td> <td>11</td></tr> <tr><td>3</td> <td>False</td> <td>0.697085</td> <td>11</td> <td>11</td></tr> <tr><td>4</td> <td>False</td> <td>0.434934</td> <td>11</td> <td>11</td></tr></tbody>",Ot,be,fl="This method returns a dataframe containing a label quality score for each example. These numeric scores lie between 0 and 1, where lower scores indicate examples more likely to be mislabeled. The dataframe also contains a boolean column specifying whether or not each example is identified to have a label issue (indicating it is likely mislabeled).",es,he,yl="We can get the subset of examples flagged with label issues, and also sort by label quality score to find the indices of the 5 most likely mislabeled examples in our dataset.",ts,fe,ss,ye,wl=`cleanlab found 10 potential label errors in the dataset.
Here are indices of the top 5 most likely errors: 
 [379 100 300 485 159]
`,ls,we,Ml="Let’s review some of the most likely label errors.",as,Me,gl="Here we display the top 5 examples identified as the most likely label errors in the dataset, together with their given (original) label and a suggested alternative label from cleanlab.",ns,ge,is,xe,xl="The output to the above command would like below:",rs,$e,$l="<thead><tr><th></th> <th>text</th> <th>given_label</th> <th>suggested_label</th></tr></thead> <tbody><tr><td>379</td> <td>Is there a specific source that the exchange rate for the transfer I’m planning on making is pulled from?</td> <td>32</td> <td>11</td></tr> <tr><td>100</td> <td>can you share card tracking number?</td> <td>11</td> <td>36</td></tr> <tr><td>300</td> <td>If I need to cash foreign transfers, how does that work?</td> <td>32</td> <td>46</td></tr> <tr><td>485</td> <td>Was I charged more than I should of been for a currency exchange?</td> <td>17</td> <td>34</td></tr> <tr><td>159</td> <td>Is there any way to see my card in the app?</td> <td>13</td> <td>11</td></tr></tbody>",os,Te,Tl="These are very clear label errors that cleanlab has identified in this data! Note that the <code>given_label</code> does not correctly reflect the intent of these requests, whoever produced this dataset made many mistakes that are important to address before modeling the data.",ds,ve,ps,Je,vl=`According to the report, our dataset contains some outliers.
We can see which examples are outliers (and a numeric quality score quantifying how typical each example appears to be) via <code>get_issues</code>. We sort the resulting DataFrame by cleanlab’s outlier quality score to see the most severe outliers in our dataset.`,us,_e,ms,je,Jl="Output would look like below:",cs,Ce,_l="<thead><tr><th></th> <th>is_outlier_issue</th> <th>outlier_score</th></tr></thead> <tbody><tr><td>791</td> <td>True</td> <td>0.024866</td></tr> <tr><td>601</td> <td>True</td> <td>0.031162</td></tr> <tr><td>863</td> <td>True</td> <td>0.060738</td></tr> <tr><td>355</td> <td>True</td> <td>0.064199</td></tr> <tr><td>157</td> <td>True</td> <td>0.065075</td></tr></tbody>",bs,Ue,hs,We,jl="A sample output for the lowest quality outliers would look like below:",fs,ke,Cl="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>791</td> <td>withdrawal pending meaning?</td> <td>46</td></tr> <tr><td>601</td> <td>$1 charge in transaction.</td> <td>34</td></tr> <tr><td>863</td> <td>My atm withdraw is stillpending</td> <td>46</td></tr> <tr><td>355</td> <td>explain the interbank exchange rate</td> <td>32</td></tr> <tr><td>157</td> <td>lost card found, want to put it back in app</td> <td>13</td></tr></tbody>",ys,Ze,Ul="We see that cleanlab has identified entries in this dataset that do not appear to be proper customer requests. Outliers in this dataset appear to be out-of-scope customer requests and other nonsensical text which does not make sense for intent classification. Carefully consider whether such outliers may detrimentally affect your data modeling, and consider removing them from the dataset if so.",ws,Ge,Ms,Ie,Wl=`According to the report, our dataset contains some sets of nearly duplicated examples.
We can see which examples are (nearly) duplicated (and a numeric quality score quantifying how dissimilar each example is from its nearest neighbor in the dataset) via <code>get_issues</code>. We sort the resulting DataFrame by cleanlab’s near-duplicate quality score to see the text examples in our dataset that are most nearly duplicated.`,gs,Fe,xs,Be,kl="The results above show which examples cleanlab considers nearly duplicated (rows where <code>is_near_duplicate_issue == True</code>). Here, we see that example 459 and 429 are nearly duplicated, as are example 501 and 412.",$s,He,Zl="Let’s view these examples to see how similar they are.",Ts,Ve,vs,Re,Gl="Sample output:",Js,Le,Il="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>459</td> <td>I purchased something abroad and the incorrect exchange rate was applied.</td> <td>17</td></tr> <tr><td>429</td> <td>I purchased something overseas and the incorrect exchange rate was applied.</td> <td>17</td></tr></tbody>",_s,Ye,js,Xe,Fl="Sample output:",Cs,Ne,Bl="<thead><tr><th>index</th> <th>text</th> <th>label</th></tr></thead> <tbody><tr><td>501</td> <td>The exchange rate you are using is really bad.This can’t be the official interbank exchange rate.</td> <td>17</td></tr> <tr><td>412</td> <td>The exchange rate you are using is bad.This can’t be the official interbank exchange rate.</td> <td>17</td></tr></tbody>",Us,qe,Hl='We see that these two sets of request are indeed very similar to one another! Including near duplicates in a dataset may have unintended effects on models, and be wary about splitting them across training/test sets. Learn more about handling near duplicates in a dataset from <a href="https://docs.cleanlab.ai/stable/tutorials/faq.html#How-to-handle-near-duplicate-data-identified-by-Datalab?" rel="nofollow">the FAQ</a>.',Ws,ze,ks,Qe,Vl="According to the report, our dataset does not appear to be Independent and Identically Distributed (IID).  The overall non-iid score for the dataset (displayed below) corresponds to the <code>p-value</code> of a statistical test for whether the ordering of samples in the dataset appears related to the similarity between their feature values.  A low <code>p-value</code> strongly suggests that the dataset violates the IID assumption, which is a key assumption required for conclusions (models) produced from the dataset to generalize to a larger population.",Zs,Ee,Gs,De,Rl="Here, our dataset was flagged as non-IID because the rows happened to be sorted by class label in the original data. This may be benign if we remember to shuffle rows before model training and data splitting. But if you don’t know why your data was flagged as non-IID, then you should be worried about potential data drift or unexpected interactions between data points (their values may not be statistically independent). Think carefully about what future test data may look like (and whether your data is representative of the population you care about). You should not shuffle your data before the non-IID test runs (will invalidate its conclusions).",Is,Pe,Ll="As demonstrated above, cleanlab can automatically shortlist the most likely issues in your dataset to help you better curate your dataset for subsequent modeling. With this shortlist, you can decide whether to fix these label issues or remove nonsensical or duplicated examples from your dataset to obtain a higher-quality dataset for training your next ML model. cleanlab’s issue detection can be run with outputs from <em>any</em> type of model you initially trained.",Fs,Ae,Bs,Se,Yl='<a href="https://github.com/cleanlab/cleanlab" rel="nofollow">Cleanlab</a> is a standard Data-centric AI package designed to address data quality issues for messy, real-world data.',Hs,Ke,Xl='Do consider giving Cleanlab Github Repository a Star, and we welcome <a href="https://github.com/cleanlab/cleanlab/issues?q=is:issue+is:open+label:%22good+first+issue%22" rel="nofollow">contributions</a> to the project.',Vs,Oe,Rs,tt,Ls;return M=new Kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/issues_in_text_dataset.ipynb"}]}}),g=new Sl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),x=new f({props:{title:"Detecting Issues in a Text Dataset with Cleanlab",local:"detecting-issues-in-a-text-dataset-with-cleanlab",headingTag:"h1"}}),_=new f({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),U=new h({props:{code:"ZnJvbSUyMGNsZWFubGFiJTIwaW1wb3J0JTIwRGF0YWxhYiUwQSUwQWxhYiUyMCUzRCUyMERhdGFsYWIoZGF0YSUzRHlvdXJfZGF0YXNldCUyQyUyMGxhYmVsX25hbWUlM0QlMjJjb2x1bW5fbmFtZV9vZl9sYWJlbHMlMjIpJTBBbGFiLmZpbmRfaXNzdWVzKHByZWRfcHJvYnMlM0R5b3VyX3ByZWRfcHJvYnMlMkMlMjBmZWF0dXJlcyUzRHlvdXJfZmVhdHVyZXMpJTBBJTBBbGFiLnJlcG9ydCgpJTBBbGFiLmdldF9pc3N1ZXMoKQ==",highlighted:`<span class="hljs-keyword">from</span> cleanlab <span class="hljs-keyword">import</span> Datalab

lab = Datalab(data=your_dataset, label_name=<span class="hljs-string">&quot;column_name_of_labels&quot;</span>)
lab.find_issues(pred_probs=your_pred_probs, features=your_features)

lab.report()
lab.get_issues()`,wrap:!1}}),W=new f({props:{title:"Install required dependencies",local:"install-required-dependencies",headingTag:"h2"}}),Z=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtVSUyMHNjaWtpdC1sZWFybiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTBBIXBpcCUyMGluc3RhbGwlMjAtVSUyMCUyMmNsZWFubGFiJTVCZGF0YWxhYiU1RCUyMg==",highlighted:`!pip install -U scikit-learn sentence-transformers datasets
!pip install -U <span class="hljs-string">&quot;cleanlab[datalab]&quot;</span>`,wrap:!1}}),G=new h({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBzdHJpbmclMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMGFjY3VyYWN5X3Njb3JlJTJDJTIwbG9nX2xvc3MlMEFmcm9tJTIwc2tsZWFybi5tb2RlbF9zZWxlY3Rpb24lMjBpbXBvcnQlMjBjcm9zc192YWxfcHJlZGljdCUwQWZyb20lMjBza2xlYXJuLmxpbmVhcl9tb2RlbCUyMGltcG9ydCUyMExvZ2lzdGljUmVncmVzc2lvbiUwQWZyb20lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBTZW50ZW5jZVRyYW5zZm9ybWVyJTBBJTBBZnJvbSUyMGNsZWFubGFiJTIwaW1wb3J0JTIwRGF0YWxhYg==",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> string
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> accuracy_score, log_loss
<span class="hljs-keyword">from</span> sklearn.model_selection <span class="hljs-keyword">import</span> cross_val_predict
<span class="hljs-keyword">from</span> sklearn.linear_model <span class="hljs-keyword">import</span> LogisticRegression
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-keyword">from</span> cleanlab <span class="hljs-keyword">import</span> Datalab`,wrap:!1}}),I=new h({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTBBJTBBU0VFRCUyMCUzRCUyMDEyMzQ1NiUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQW5wLnJhbmRvbS5zZWVkKFNFRUQpJTBBcmFuZG9tLnNlZWQoU0VFRCk=",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

SEED = <span class="hljs-number">123456</span>  <span class="hljs-comment"># for reproducibility</span>
np.random.seed(SEED)
random.seed(SEED)`,wrap:!1}}),F=new f({props:{title:"Load and format the text dataset",local:"load-and-format-the-text-dataset",headingTag:"h2"}}),B=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZiYW5raW5nNzclMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWRhdGElMjAlM0QlMjBwZC5EYXRhRnJhbWUoZGF0YXNldCU1QiUzQTEwMDAlNUQpJTBBZGF0YS5oZWFkKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/banking77&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
data = pd.DataFrame(dataset[:<span class="hljs-number">1000</span>])
data.head()`,wrap:!1}}),H=new h({props:{code:"cmF3X3RleHRzJTJDJTIwbGFiZWxzJTIwJTNEJTIwZGF0YSU1QiUyMnRleHQlMjIlNUQudmFsdWVzJTJDJTIwZGF0YSU1QiUyMmxhYmVsJTIyJTVELnZhbHVlcyUwQW51bV9jbGFzc2VzJTIwJTNEJTIwbGVuKHNldChsYWJlbHMpKSUwQSUwQXByaW50KGYlMjJUaGlzJTIwZGF0YXNldCUyMGhhcyUyMCU3Qm51bV9jbGFzc2VzJTdEJTIwY2xhc3Nlcy4lMjIpJTBBcHJpbnQoZiUyMkNsYXNzZXMlM0ElMjAlN0JzZXQobGFiZWxzKSU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>raw_texts, labels = data[<span class="hljs-string">&quot;text&quot;</span>].values, data[<span class="hljs-string">&quot;label&quot;</span>].values
<span class="hljs-meta">&gt;&gt;&gt; </span>num_classes = <span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(labels))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This dataset has <span class="hljs-subst">{num_classes}</span> classes.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Classes: <span class="hljs-subst">{<span class="hljs-built_in">set</span>(labels)}</span>&quot;</span>)`,wrap:!1}}),L=new h({props:{code:"aSUyMCUzRCUyMDElMjAlMjAlMjMlMjBjaGFuZ2UlMjB0aGlzJTIwdG8lMjB2aWV3JTIwb3RoZXIlMjBleGFtcGxlcyUyMGZyb20lMjB0aGUlMjBkYXRhc2V0JTBBcHJpbnQoZiUyMkV4YW1wbGUlMjBMYWJlbCUzQSUyMCU3QmxhYmVscyU1QmklNUQlN0QlMjIpJTBBcHJpbnQoZiUyMkV4YW1wbGUlMjBUZXh0JTNBJTIwJTdCcmF3X3RleHRzJTVCaSU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">1</span>  <span class="hljs-comment"># change this to view other examples from the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Example Label: <span class="hljs-subst">{labels[i]}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Example Text: <span class="hljs-subst">{raw_texts[i]}</span>&quot;</span>)`,wrap:!1}}),Q=new h({props:{code:"dHJhbnNmb3JtZXIlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCdnb29nbGUlMkZlbGVjdHJhLXNtYWxsLWRpc2NyaW1pbmF0b3InKSUwQXRleHRfZW1iZWRkaW5ncyUyMCUzRCUyMHRyYW5zZm9ybWVyLmVuY29kZShyYXdfdGV4dHMp",highlighted:`transformer = SentenceTransformer(<span class="hljs-string">&#x27;google/electra-small-discriminator&#x27;</span>)
text_embeddings = transformer.encode(raw_texts)`,wrap:!1}}),D=new f({props:{title:"Define a classification model and compute out-of-sample predicted probabilities",local:"define-a-classification-model-and-compute-out-of-sample-predicted-probabilities",headingTag:"h2"}}),K=new h({props:{code:"bW9kZWwlMjAlM0QlMjBMb2dpc3RpY1JlZ3Jlc3Npb24obWF4X2l0ZXIlM0Q0MDApJTBBJTBBcHJlZF9wcm9icyUyMCUzRCUyMGNyb3NzX3ZhbF9wcmVkaWN0KG1vZGVsJTJDJTIwdGV4dF9lbWJlZGRpbmdzJTJDJTIwbGFiZWxzJTJDJTIwbWV0aG9kJTNEJTIycHJlZGljdF9wcm9iYSUyMik=",highlighted:`model = LogisticRegression(max_iter=<span class="hljs-number">400</span>)

pred_probs = cross_val_predict(model, text_embeddings, labels, method=<span class="hljs-string">&quot;predict_proba&quot;</span>)`,wrap:!1}}),O=new f({props:{title:"Use Cleanlab to find issues in your dataset",local:"use-cleanlab-to-find-issues-in-your-dataset",headingTag:"h2"}}),se=new h({props:{code:"ZGF0YV9kaWN0JTIwJTNEJTIwJTdCJTIydGV4dHMlMjIlM0ElMjByYXdfdGV4dHMlMkMlMjAlMjJsYWJlbHMlMjIlM0ElMjBsYWJlbHMlN0Q=",highlighted:'data_dict = {<span class="hljs-string">&quot;texts&quot;</span>: raw_texts, <span class="hljs-string">&quot;labels&quot;</span>: labels}',wrap:!1}}),ae=new h({props:{code:"bGFiJTIwJTNEJTIwRGF0YWxhYihkYXRhX2RpY3QlMkMlMjBsYWJlbF9uYW1lJTNEJTIybGFiZWxzJTIyKSUwQWxhYi5maW5kX2lzc3VlcyhwcmVkX3Byb2JzJTNEcHJlZF9wcm9icyUyQyUyMGZlYXR1cmVzJTNEdGV4dF9lbWJlZGRpbmdzKQ==",highlighted:`lab = Datalab(data_dict, label_name=<span class="hljs-string">&quot;labels&quot;</span>)
lab.find_issues(pred_probs=pred_probs, features=text_embeddings)`,wrap:!1}}),ie=new h({props:{code:"RmluZGluZyUyMG51bGwlMjBpc3N1ZXMlMjAuLi4lMEFGaW5kaW5nJTIwbGFiZWwlMjBpc3N1ZXMlMjAuLi4lMEFGaW5kaW5nJTIwb3V0bGllciUyMGlzc3VlcyUyMC4uLiUwQUZpdHRpbmclMjBPT0QlMjBlc3RpbWF0b3IlMjBiYXNlZCUyMG9uJTIwcHJvdmlkZWQlMjBmZWF0dXJlcyUyMC4uLiUwQUZpbmRpbmclMjBuZWFyX2R1cGxpY2F0ZSUyMGlzc3VlcyUyMC4uLiUwQUZpbmRpbmclMjBub25faWlkJTIwaXNzdWVzJTIwLi4uJTBBRmluZGluZyUyMGNsYXNzX2ltYmFsYW5jZSUyMGlzc3VlcyUyMC4uLiUwQUZpbmRpbmclMjB1bmRlcnBlcmZvcm1pbmdfZ3JvdXAlMjBpc3N1ZXMlMjAuLi4lMEElMEFBdWRpdCUyMGNvbXBsZXRlLiUyMDYyJTIwaXNzdWVzJTIwZm91bmQlMjBpbiUyMHRoZSUyMGRhdGFzZXQu",highlighted:`Finding null issues ...
Finding label issues ...
Finding outlier issues ...
Fitting OOD estimator based on provided features ...
Finding near_duplicate issues ...
Finding non_iid issues ...
Finding class_imbalance issues ...
Finding underperforming_group issues ...

Audit complete. 62 issues found <span class="hljs-keyword">in</span> the dataset.`,wrap:!1}}),oe=new h({props:{code:"bGFiLnJlcG9ydCgp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>lab.report()',wrap:!1}}),pe=new f({props:{title:"Label issues",local:"label-issues",headingTag:"h3"}}),me=new h({props:{code:"bGFiZWxfaXNzdWVzJTIwJTNEJTIwbGFiLmdldF9pc3N1ZXMoJTIybGFiZWwlMjIpJTBBbGFiZWxfaXNzdWVzLmhlYWQoKQ==",highlighted:`label_issues = lab.get_issues(<span class="hljs-string">&quot;label&quot;</span>)
label_issues.head()`,wrap:!1}}),fe=new h({props:{code:"aWRlbnRpZmllZF9sYWJlbF9pc3N1ZXMlMjAlM0QlMjBsYWJlbF9pc3N1ZXMlNUJsYWJlbF9pc3N1ZXMlNUIlMjJpc19sYWJlbF9pc3N1ZSUyMiU1RCUyMCUzRCUzRCUyMFRydWUlNUQlMEFsb3dlc3RfcXVhbGl0eV9sYWJlbHMlMjAlM0QlMjBsYWJlbF9pc3N1ZXMlNUIlMjJsYWJlbF9zY29yZSUyMiU1RC5hcmdzb3J0KCklNUIlM0E1JTVELnRvX251bXB5KCklMEElMEFwcmludCglMEElMjAlMjAlMjAlMjBmJTIyY2xlYW5sYWIlMjBmb3VuZCUyMCU3QmxlbihpZGVudGlmaWVkX2xhYmVsX2lzc3VlcyklN0QlMjBwb3RlbnRpYWwlMjBsYWJlbCUyMGVycm9ycyUyMGluJTIwdGhlJTIwZGF0YXNldC4lNUNuJTIyJTBBJTIwJTIwJTIwJTIwZiUyMkhlcmUlMjBhcmUlMjBpbmRpY2VzJTIwb2YlMjB0aGUlMjB0b3AlMjA1JTIwbW9zdCUyMGxpa2VseSUyMGVycm9ycyUzQSUyMCU1Q24lMjAlN0Jsb3dlc3RfcXVhbGl0eV9sYWJlbHMlN0QlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>identified_label_issues = label_issues[label_issues[<span class="hljs-string">&quot;is_label_issue&quot;</span>] == <span class="hljs-literal">True</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>lowest_quality_labels = label_issues[<span class="hljs-string">&quot;label_score&quot;</span>].argsort()[:<span class="hljs-number">5</span>].to_numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;cleanlab found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(identified_label_issues)}</span> potential label errors in the dataset.\\n&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;Here are indices of the top 5 most likely errors: \\n <span class="hljs-subst">{lowest_quality_labels}</span>&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ge=new h({props:{code:"ZGF0YV93aXRoX3N1Z2dlc3RlZF9sYWJlbHMlMjAlM0QlMjBwZC5EYXRhRnJhbWUoJTBBJTIwJTIwJTIwJTIwJTdCJTIydGV4dCUyMiUzQSUyMHJhd190ZXh0cyUyQyUyMCUyMmdpdmVuX2xhYmVsJTIyJTNBJTIwbGFiZWxzJTJDJTIwJTIyc3VnZ2VzdGVkX2xhYmVsJTIyJTNBJTIwbGFiZWxfaXNzdWVzJTVCJTIycHJlZGljdGVkX2xhYmVsJTIyJTVEJTdEJTBBKSUwQWRhdGFfd2l0aF9zdWdnZXN0ZWRfbGFiZWxzLmlsb2MlNUJsb3dlc3RfcXVhbGl0eV9sYWJlbHMlNUQ=",highlighted:`data_with_suggested_labels = pd.DataFrame(
    {<span class="hljs-string">&quot;text&quot;</span>: raw_texts, <span class="hljs-string">&quot;given_label&quot;</span>: labels, <span class="hljs-string">&quot;suggested_label&quot;</span>: label_issues[<span class="hljs-string">&quot;predicted_label&quot;</span>]}
)
data_with_suggested_labels.iloc[lowest_quality_labels]`,wrap:!1}}),ve=new f({props:{title:"Outlier issues",local:"outlier-issues",headingTag:"h3"}}),_e=new h({props:{code:"b3V0bGllcl9pc3N1ZXMlMjAlM0QlMjBsYWIuZ2V0X2lzc3VlcyglMjJvdXRsaWVyJTIyKSUwQW91dGxpZXJfaXNzdWVzLnNvcnRfdmFsdWVzKCUyMm91dGxpZXJfc2NvcmUlMjIpLmhlYWQoKQ==",highlighted:`outlier_issues = lab.get_issues(<span class="hljs-string">&quot;outlier&quot;</span>)
outlier_issues.sort_values(<span class="hljs-string">&quot;outlier_score&quot;</span>).head()`,wrap:!1}}),Ue=new h({props:{code:"bG93ZXN0X3F1YWxpdHlfb3V0bGllcnMlMjAlM0QlMjBvdXRsaWVyX2lzc3VlcyU1QiUyMm91dGxpZXJfc2NvcmUlMjIlNUQuYXJnc29ydCgpJTVCJTNBNSU1RCUwQSUwQWRhdGEuaWxvYyU1Qmxvd2VzdF9xdWFsaXR5X291dGxpZXJzJTVE",highlighted:`lowest_quality_outliers = outlier_issues[<span class="hljs-string">&quot;outlier_score&quot;</span>].argsort()[:<span class="hljs-number">5</span>]

data.iloc[lowest_quality_outliers]`,wrap:!1}}),Ge=new f({props:{title:"Near-duplicate issues",local:"near-duplicate-issues",headingTag:"h3"}}),Fe=new h({props:{code:"ZHVwbGljYXRlX2lzc3VlcyUyMCUzRCUyMGxhYi5nZXRfaXNzdWVzKCUyMm5lYXJfZHVwbGljYXRlJTIyKSUwQWR1cGxpY2F0ZV9pc3N1ZXMuc29ydF92YWx1ZXMoJTIybmVhcl9kdXBsaWNhdGVfc2NvcmUlMjIpLmhlYWQoKQ==",highlighted:`duplicate_issues = lab.get_issues(<span class="hljs-string">&quot;near_duplicate&quot;</span>)
duplicate_issues.sort_values(<span class="hljs-string">&quot;near_duplicate_score&quot;</span>).head()`,wrap:!1}}),Ve=new h({props:{code:"ZGF0YS5pbG9jJTVCJTVCNDU5JTJDJTIwNDI5JTVEJTVE",highlighted:'data.iloc[[<span class="hljs-number">459</span>, <span class="hljs-number">429</span>]]',wrap:!1}}),Ye=new h({props:{code:"ZGF0YS5pbG9jJTVCJTVCNTAxJTJDJTIwNDEyJTVEJTVE",highlighted:'data.iloc[[<span class="hljs-number">501</span>, <span class="hljs-number">412</span>]]',wrap:!1}}),ze=new f({props:{title:"Non-IID issues (data drift)",local:"non-iid-issues-data-drift",headingTag:"h3"}}),Ee=new h({props:{code:"cF92YWx1ZSUyMCUzRCUyMGxhYi5nZXRfaW5mbygnbm9uX2lpZCcpJTVCJ3AtdmFsdWUnJTVEJTBBcF92YWx1ZQ==",highlighted:`p_value = lab.get_info(<span class="hljs-string">&#x27;non_iid&#x27;</span>)[<span class="hljs-string">&#x27;p-value&#x27;</span>]
p_value`,wrap:!1}}),Ae=new f({props:{title:"Cleanlab Opensource Project",local:"cleanlab-opensource-project",headingTag:"h3"}}),Oe=new Ol({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/issues_in_text_dataset.md"}}),{c(){y=i("meta"),st=a(),et=i("p"),lt=a(),d(M.$$.fragment),at=a(),d(g.$$.fragment),nt=a(),d(x.$$.fragment),it=a(),$=i("p"),$.innerHTML=Ns,rt=a(),T=i("p"),T.innerHTML=qs,ot=a(),v=i("p"),v.innerHTML=zs,dt=a(),J=i("ul"),J.innerHTML=Qs,pt=a(),d(_.$$.fragment),ut=a(),j=i("p"),j.innerHTML=Es,mt=a(),C=i("p"),C.innerHTML=Ds,ct=a(),d(U.$$.fragment),bt=a(),d(W.$$.fragment),ht=a(),k=i("p"),k.innerHTML=Ps,ft=a(),d(Z.$$.fragment),yt=a(),d(G.$$.fragment),wt=a(),d(I.$$.fragment),Mt=a(),d(F.$$.fragment),gt=a(),d(B.$$.fragment),xt=a(),d(H.$$.fragment),$t=a(),V=i("pre"),V.textContent=As,Tt=a(),R=i("p"),R.textContent=Ss,vt=a(),d(L.$$.fragment),Jt=a(),Y=i("pre"),Y.textContent=Ks,_t=a(),X=i("p"),X.textContent=Os,jt=a(),N=i("ol"),N.innerHTML=el,Ct=a(),w=i("div"),w.innerHTML=tl,Ut=a(),q=i("p"),q.textContent=sl,Wt=a(),z=i("p"),z.innerHTML=ll,kt=a(),d(Q.$$.fragment),Zt=a(),E=i("p"),E.innerHTML=al,Gt=a(),d(D.$$.fragment),It=a(),P=i("p"),P.textContent=nl,Ft=a(),A=i("p"),A.innerHTML=il,Bt=a(),S=i("p"),S.innerHTML=rl,Ht=a(),d(K.$$.fragment),Vt=a(),d(O.$$.fragment),Rt=a(),ee=i("p"),ee.textContent=ol,Lt=a(),te=i("p"),te.innerHTML=dl,Yt=a(),d(se.$$.fragment),Xt=a(),le=i("p"),le.innerHTML=pl,Nt=a(),d(ae.$$.fragment),qt=a(),ne=i("p"),ne.textContent=ul,zt=a(),d(ie.$$.fragment),Qt=a(),re=i("p"),re.innerHTML=ml,Et=a(),d(oe.$$.fragment),Dt=a(),de=i("pre"),de.textContent=cl,Pt=a(),d(pe.$$.fragment),At=a(),ue=i("p"),ue.innerHTML=bl,St=a(),d(me.$$.fragment),Kt=a(),ce=i("table"),ce.innerHTML=hl,Ot=a(),be=i("p"),be.textContent=fl,es=a(),he=i("p"),he.textContent=yl,ts=a(),d(fe.$$.fragment),ss=a(),ye=i("pre"),ye.textContent=wl,ls=a(),we=i("p"),we.textContent=Ml,as=a(),Me=i("p"),Me.textContent=gl,ns=a(),d(ge.$$.fragment),is=a(),xe=i("p"),xe.textContent=xl,rs=a(),$e=i("table"),$e.innerHTML=$l,os=a(),Te=i("p"),Te.innerHTML=Tl,ds=a(),d(ve.$$.fragment),ps=a(),Je=i("p"),Je.innerHTML=vl,us=a(),d(_e.$$.fragment),ms=a(),je=i("p"),je.textContent=Jl,cs=a(),Ce=i("table"),Ce.innerHTML=_l,bs=a(),d(Ue.$$.fragment),hs=a(),We=i("p"),We.textContent=jl,fs=a(),ke=i("table"),ke.innerHTML=Cl,ys=a(),Ze=i("p"),Ze.textContent=Ul,ws=a(),d(Ge.$$.fragment),Ms=a(),Ie=i("p"),Ie.innerHTML=Wl,gs=a(),d(Fe.$$.fragment),xs=a(),Be=i("p"),Be.innerHTML=kl,$s=a(),He=i("p"),He.textContent=Zl,Ts=a(),d(Ve.$$.fragment),vs=a(),Re=i("p"),Re.textContent=Gl,Js=a(),Le=i("table"),Le.innerHTML=Il,_s=a(),d(Ye.$$.fragment),js=a(),Xe=i("p"),Xe.textContent=Fl,Cs=a(),Ne=i("table"),Ne.innerHTML=Bl,Us=a(),qe=i("p"),qe.innerHTML=Hl,Ws=a(),d(ze.$$.fragment),ks=a(),Qe=i("p"),Qe.innerHTML=Vl,Zs=a(),d(Ee.$$.fragment),Gs=a(),De=i("p"),De.textContent=Rl,Is=a(),Pe=i("p"),Pe.innerHTML=Ll,Fs=a(),d(Ae.$$.fragment),Bs=a(),Se=i("p"),Se.innerHTML=Yl,Hs=a(),Ke=i("p"),Ke.innerHTML=Xl,Vs=a(),d(Oe.$$.fragment),Rs=a(),tt=i("p"),this.h()},l(e){const t=Pl("svelte-u9bgzb",document.head);y=r(t,"META",{name:!0,content:!0}),t.forEach(s),st=n(e),et=r(e,"P",{}),Nl(et).forEach(s),lt=n(e),p(M.$$.fragment,e),at=n(e),p(g.$$.fragment,e),nt=n(e),p(x.$$.fragment,e),it=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-7v4tto"&&($.innerHTML=Ns),rt=n(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-x4m7f1"&&(T.innerHTML=qs),ot=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-18jgjs2"&&(v.innerHTML=zs),dt=n(e),J=r(e,"UL",{"data-svelte-h":!0}),o(J)!=="svelte-1a1fu53"&&(J.innerHTML=Qs),pt=n(e),p(_.$$.fragment,e),ut=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1fl5lu0"&&(j.innerHTML=Es),mt=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1umjcr0"&&(C.innerHTML=Ds),ct=n(e),p(U.$$.fragment,e),bt=n(e),p(W.$$.fragment,e),ht=n(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1846b64"&&(k.innerHTML=Ps),ft=n(e),p(Z.$$.fragment,e),yt=n(e),p(G.$$.fragment,e),wt=n(e),p(I.$$.fragment,e),Mt=n(e),p(F.$$.fragment,e),gt=n(e),p(B.$$.fragment,e),xt=n(e),p(H.$$.fragment,e),$t=n(e),V=r(e,"PRE",{"data-svelte-h":!0}),o(V)!=="svelte-1baoe44"&&(V.textContent=As),Tt=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1u95mgp"&&(R.textContent=Ss),vt=n(e),p(L.$$.fragment,e),Jt=n(e),Y=r(e,"PRE",{"data-svelte-h":!0}),o(Y)!=="svelte-17yipnq"&&(Y.textContent=Ks),_t=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1l25yub"&&(X.textContent=Os),jt=n(e),N=r(e,"OL",{"data-svelte-h":!0}),o(N)!=="svelte-1k1141k"&&(N.innerHTML=el),Ct=n(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-ulpodh"&&(w.innerHTML=tl),Ut=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-8ylgjr"&&(q.textContent=sl),Wt=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1m7xux2"&&(z.innerHTML=ll),kt=n(e),p(Q.$$.fragment,e),Zt=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-j0bn03"&&(E.innerHTML=al),Gt=n(e),p(D.$$.fragment,e),It=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-b7zzz7"&&(P.textContent=nl),Ft=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1dj10dn"&&(A.innerHTML=il),Bt=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-9of5yp"&&(S.innerHTML=rl),Ht=n(e),p(K.$$.fragment,e),Vt=n(e),p(O.$$.fragment,e),Rt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-47pi87"&&(ee.textContent=ol),Lt=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-dexquy"&&(te.innerHTML=dl),Yt=n(e),p(se.$$.fragment,e),Xt=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-tev5gw"&&(le.innerHTML=pl),Nt=n(e),p(ae.$$.fragment,e),qt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1pktn7f"&&(ne.textContent=ul),zt=n(e),p(ie.$$.fragment,e),Qt=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-gfwcwf"&&(re.innerHTML=ml),Et=n(e),p(oe.$$.fragment,e),Dt=n(e),de=r(e,"PRE",{"data-svelte-h":!0}),o(de)!=="svelte-1uushu"&&(de.textContent=cl),Pt=n(e),p(pe.$$.fragment,e),At=n(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-15v82np"&&(ue.innerHTML=bl),St=n(e),p(me.$$.fragment,e),Kt=n(e),ce=r(e,"TABLE",{"data-svelte-h":!0}),o(ce)!=="svelte-1xd6s59"&&(ce.innerHTML=hl),Ot=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-19ub1nr"&&(be.textContent=fl),es=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-15fxxfj"&&(he.textContent=yl),ts=n(e),p(fe.$$.fragment,e),ss=n(e),ye=r(e,"PRE",{"data-svelte-h":!0}),o(ye)!=="svelte-ku705s"&&(ye.textContent=wl),ls=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-xz6a83"&&(we.textContent=Ml),as=n(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1q9yf95"&&(Me.textContent=gl),ns=n(e),p(ge.$$.fragment,e),is=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1ralv53"&&(xe.textContent=xl),rs=n(e),$e=r(e,"TABLE",{"data-svelte-h":!0}),o($e)!=="svelte-15w938v"&&($e.innerHTML=$l),os=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-19y4mu3"&&(Te.innerHTML=Tl),ds=n(e),p(ve.$$.fragment,e),ps=n(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1a5t0qg"&&(Je.innerHTML=vl),us=n(e),p(_e.$$.fragment,e),ms=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-f5s9jr"&&(je.textContent=Jl),cs=n(e),Ce=r(e,"TABLE",{"data-svelte-h":!0}),o(Ce)!=="svelte-1u55nqa"&&(Ce.innerHTML=_l),bs=n(e),p(Ue.$$.fragment,e),hs=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1plac8s"&&(We.textContent=jl),fs=n(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-1n860xg"&&(ke.innerHTML=Cl),ys=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-warb6v"&&(Ze.textContent=Ul),ws=n(e),p(Ge.$$.fragment,e),Ms=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-ihtnsz"&&(Ie.innerHTML=Wl),gs=n(e),p(Fe.$$.fragment,e),xs=n(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-vk8ovs"&&(Be.innerHTML=kl),$s=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-zg7wj1"&&(He.textContent=Zl),Ts=n(e),p(Ve.$$.fragment,e),vs=n(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-yqv5wp"&&(Re.textContent=Gl),Js=n(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),o(Le)!=="svelte-1hzopql"&&(Le.innerHTML=Il),_s=n(e),p(Ye.$$.fragment,e),js=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-yqv5wp"&&(Xe.textContent=Fl),Cs=n(e),Ne=r(e,"TABLE",{"data-svelte-h":!0}),o(Ne)!=="svelte-6cycax"&&(Ne.innerHTML=Bl),Us=n(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1tr6twj"&&(qe.innerHTML=Hl),Ws=n(e),p(ze.$$.fragment,e),ks=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1sy4tkb"&&(Qe.innerHTML=Vl),Zs=n(e),p(Ee.$$.fragment,e),Gs=n(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1kc3doc"&&(De.textContent=Rl),Is=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-gmdkyh"&&(Pe.innerHTML=Ll),Fs=n(e),p(Ae.$$.fragment,e),Bs=n(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-b286nf"&&(Se.innerHTML=Yl),Hs=n(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-ima2ho"&&(Ke.innerHTML=Xl),Vs=n(e),p(Oe.$$.fragment,e),Rs=n(e),tt=r(e,"P",{}),Nl(tt).forEach(s),this.h()},h(){Ys(y,"name","hf:doc:metadata"),Ys(y,"content",ta),Ys(w,"class","alert alert-info")},m(e,t){Al(document.head,y),l(e,st,t),l(e,et,t),l(e,lt,t),u(M,e,t),l(e,at,t),u(g,e,t),l(e,nt,t),u(x,e,t),l(e,it,t),l(e,$,t),l(e,rt,t),l(e,T,t),l(e,ot,t),l(e,v,t),l(e,dt,t),l(e,J,t),l(e,pt,t),u(_,e,t),l(e,ut,t),l(e,j,t),l(e,mt,t),l(e,C,t),l(e,ct,t),u(U,e,t),l(e,bt,t),u(W,e,t),l(e,ht,t),l(e,k,t),l(e,ft,t),u(Z,e,t),l(e,yt,t),u(G,e,t),l(e,wt,t),u(I,e,t),l(e,Mt,t),u(F,e,t),l(e,gt,t),u(B,e,t),l(e,xt,t),u(H,e,t),l(e,$t,t),l(e,V,t),l(e,Tt,t),l(e,R,t),l(e,vt,t),u(L,e,t),l(e,Jt,t),l(e,Y,t),l(e,_t,t),l(e,X,t),l(e,jt,t),l(e,N,t),l(e,Ct,t),l(e,w,t),l(e,Ut,t),l(e,q,t),l(e,Wt,t),l(e,z,t),l(e,kt,t),u(Q,e,t),l(e,Zt,t),l(e,E,t),l(e,Gt,t),u(D,e,t),l(e,It,t),l(e,P,t),l(e,Ft,t),l(e,A,t),l(e,Bt,t),l(e,S,t),l(e,Ht,t),u(K,e,t),l(e,Vt,t),u(O,e,t),l(e,Rt,t),l(e,ee,t),l(e,Lt,t),l(e,te,t),l(e,Yt,t),u(se,e,t),l(e,Xt,t),l(e,le,t),l(e,Nt,t),u(ae,e,t),l(e,qt,t),l(e,ne,t),l(e,zt,t),u(ie,e,t),l(e,Qt,t),l(e,re,t),l(e,Et,t),u(oe,e,t),l(e,Dt,t),l(e,de,t),l(e,Pt,t),u(pe,e,t),l(e,At,t),l(e,ue,t),l(e,St,t),u(me,e,t),l(e,Kt,t),l(e,ce,t),l(e,Ot,t),l(e,be,t),l(e,es,t),l(e,he,t),l(e,ts,t),u(fe,e,t),l(e,ss,t),l(e,ye,t),l(e,ls,t),l(e,we,t),l(e,as,t),l(e,Me,t),l(e,ns,t),u(ge,e,t),l(e,is,t),l(e,xe,t),l(e,rs,t),l(e,$e,t),l(e,os,t),l(e,Te,t),l(e,ds,t),u(ve,e,t),l(e,ps,t),l(e,Je,t),l(e,us,t),u(_e,e,t),l(e,ms,t),l(e,je,t),l(e,cs,t),l(e,Ce,t),l(e,bs,t),u(Ue,e,t),l(e,hs,t),l(e,We,t),l(e,fs,t),l(e,ke,t),l(e,ys,t),l(e,Ze,t),l(e,ws,t),u(Ge,e,t),l(e,Ms,t),l(e,Ie,t),l(e,gs,t),u(Fe,e,t),l(e,xs,t),l(e,Be,t),l(e,$s,t),l(e,He,t),l(e,Ts,t),u(Ve,e,t),l(e,vs,t),l(e,Re,t),l(e,Js,t),l(e,Le,t),l(e,_s,t),u(Ye,e,t),l(e,js,t),l(e,Xe,t),l(e,Cs,t),l(e,Ne,t),l(e,Us,t),l(e,qe,t),l(e,Ws,t),u(ze,e,t),l(e,ks,t),l(e,Qe,t),l(e,Zs,t),u(Ee,e,t),l(e,Gs,t),l(e,De,t),l(e,Is,t),l(e,Pe,t),l(e,Fs,t),u(Ae,e,t),l(e,Bs,t),l(e,Se,t),l(e,Hs,t),l(e,Ke,t),l(e,Vs,t),u(Oe,e,t),l(e,Rs,t),l(e,tt,t),Ls=!0},p:zl,i(e){Ls||(m(M.$$.fragment,e),m(g.$$.fragment,e),m(x.$$.fragment,e),m(_.$$.fragment,e),m(U.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(I.$$.fragment,e),m(F.$$.fragment,e),m(B.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(Q.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(_e.$$.fragment,e),m(Ue.$$.fragment,e),m(Ge.$$.fragment,e),m(Fe.$$.fragment,e),m(Ve.$$.fragment,e),m(Ye.$$.fragment,e),m(ze.$$.fragment,e),m(Ee.$$.fragment,e),m(Ae.$$.fragment,e),m(Oe.$$.fragment,e),Ls=!0)},o(e){c(M.$$.fragment,e),c(g.$$.fragment,e),c(x.$$.fragment,e),c(_.$$.fragment,e),c(U.$$.fragment,e),c(W.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(I.$$.fragment,e),c(F.$$.fragment,e),c(B.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(Q.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(Ue.$$.fragment,e),c(Ge.$$.fragment,e),c(Fe.$$.fragment,e),c(Ve.$$.fragment,e),c(Ye.$$.fragment,e),c(ze.$$.fragment,e),c(Ee.$$.fragment,e),c(Ae.$$.fragment,e),c(Oe.$$.fragment,e),Ls=!1},d(e){e&&(s(st),s(et),s(lt),s(at),s(nt),s(it),s($),s(rt),s(T),s(ot),s(v),s(dt),s(J),s(pt),s(ut),s(j),s(mt),s(C),s(ct),s(bt),s(ht),s(k),s(ft),s(yt),s(wt),s(Mt),s(gt),s(xt),s($t),s(V),s(Tt),s(R),s(vt),s(Jt),s(Y),s(_t),s(X),s(jt),s(N),s(Ct),s(w),s(Ut),s(q),s(Wt),s(z),s(kt),s(Zt),s(E),s(Gt),s(It),s(P),s(Ft),s(A),s(Bt),s(S),s(Ht),s(Vt),s(Rt),s(ee),s(Lt),s(te),s(Yt),s(Xt),s(le),s(Nt),s(qt),s(ne),s(zt),s(Qt),s(re),s(Et),s(Dt),s(de),s(Pt),s(At),s(ue),s(St),s(Kt),s(ce),s(Ot),s(be),s(es),s(he),s(ts),s(ss),s(ye),s(ls),s(we),s(as),s(Me),s(ns),s(is),s(xe),s(rs),s($e),s(os),s(Te),s(ds),s(ps),s(Je),s(us),s(ms),s(je),s(cs),s(Ce),s(bs),s(hs),s(We),s(fs),s(ke),s(ys),s(Ze),s(ws),s(Ms),s(Ie),s(gs),s(xs),s(Be),s($s),s(He),s(Ts),s(vs),s(Re),s(Js),s(Le),s(_s),s(js),s(Xe),s(Cs),s(Ne),s(Us),s(qe),s(Ws),s(ks),s(Qe),s(Zs),s(Gs),s(De),s(Is),s(Pe),s(Fs),s(Bs),s(Se),s(Hs),s(Ke),s(Vs),s(Rs),s(tt)),s(y),b(M,e),b(g,e),b(x,e),b(_,e),b(U,e),b(W,e),b(Z,e),b(G,e),b(I,e),b(F,e),b(B,e),b(H,e),b(L,e),b(Q,e),b(D,e),b(K,e),b(O,e),b(se,e),b(ae,e),b(ie,e),b(oe,e),b(pe,e),b(me,e),b(fe,e),b(ge,e),b(ve,e),b(_e,e),b(Ue,e),b(Ge,e),b(Fe,e),b(Ve,e),b(Ye,e),b(ze,e),b(Ee,e),b(Ae,e),b(Oe,e)}}}const ta='{"title":"Detecting Issues in a Text Dataset with Cleanlab","local":"detecting-issues-in-a-text-dataset-with-cleanlab","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Install required dependencies","local":"install-required-dependencies","sections":[],"depth":2},{"title":"Load and format the text dataset","local":"load-and-format-the-text-dataset","sections":[],"depth":2},{"title":"Define a classification model and compute out-of-sample predicted probabilities","local":"define-a-classification-model-and-compute-out-of-sample-predicted-probabilities","sections":[],"depth":2},{"title":"Use Cleanlab to find issues in your dataset","local":"use-cleanlab-to-find-issues-in-your-dataset","sections":[{"title":"Label issues","local":"label-issues","sections":[],"depth":3},{"title":"Outlier issues","local":"outlier-issues","sections":[],"depth":3},{"title":"Near-duplicate issues","local":"near-duplicate-issues","sections":[],"depth":3},{"title":"Non-IID issues (data drift)","local":"non-iid-issues-data-drift","sections":[],"depth":3},{"title":"Cleanlab Opensource Project","local":"cleanlab-opensource-project","sections":[],"depth":3}],"depth":2}],"depth":1}';function sa(Xs){return Ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends El{constructor(y){super(),Dl(this,y,sa,ea,ql,{})}}export{oa as component};
