import{s as _s,n as xs,o as Hs}from"../chunks/scheduler.1f027d5a.js";import{S as Xs,i as zs,e as a,s as n,c as J,h as Fs,a as i,d as s,b as M,f as qs,g as p,j as y,k as $s,l as Ds,m as e,n as o,t as T,o as j,p as w}from"../chunks/index.5cb6ce42.js";import{C as Ys}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Ps,C as d}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as r,E as Os}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function Ks(Pl){let U,kt,Et,Qt,I,Gt,c,Wt,u,Nt,m,Ol="This notebook implements a multi-agent system for managing product orders, inventory, and deliveries using:",Vt,C,Kl='<li><a href="https://github.com/huggingface/smolagents/tree/main" rel="nofollow">smolagents</a> for agent management</li> <li>MongoDB for data persistence</li> <li>DeepSeek Chat as the LLM model</li>',Rt,A,qt,h,ts='<li>Create a free MongoDB Atlas account at <a href="https://www.mongodb.com/cloud/atlas/register" rel="nofollow">https://www.mongodb.com/cloud/atlas/register</a></li> <li><a href="https://www.mongodb.com/docs/atlas/tutorial/create-new-cluster/" rel="nofollow">Create a new cluster</a> (free tier is sufficient)</li> <li>Configure network access by adding your IP address</li> <li>Create a database user with read/write permissions</li> <li>Get your connection string from Atlas UI (Click “Connect” &gt; “Connect your application”)</li> <li>Replace <code>&lt;password&gt;</code> in the connection string with your database user’s password</li> <li>Enable network access from your IP address in the Network Access settings</li>',$t,S,_t,g,ls="When working with MongoDB Atlas:",xt,b,ss="<li>Never commit connection strings with credentials to version control</li> <li>Use environment variables or secure secret management</li> <li>Restrict database user permissions to only what’s needed</li> <li>Enable IP allowlist in Atlas Network Access settings</li>",Ht,f,Xt,B,es="First, let’s install required dependencies:",zt,Z,Ft,v,Dt,E,ns='Set in your secrets the <code>MONGODB_URI</code> and <code>DEEPSEEK_API_KEY</code> from <a href="https://www.deepseek.com/" rel="nofollow">https://www.deepseek.com/</a> (or any other LLM provider)',Yt,L,Ms="Import all required libraries and setup the LLM model:",Pt,k,Ot,Q,Kt,G,as="Create a MongoDB connection manager:",tl,W,ll,N,sl,V,is="Our system implements three core tools for warehouse management:",el,R,ys="Workflow:",nl,q,Ml,$,Js="Define tools for each agent type:",al,_,il,x,yl,H,Jl,X,pl,z,ps="This class implements a multi-agent architecture for order processing with the following components:",ol,F,os="<li>Inventory Agent: Handles stock checking and updates</li> <li>Order Agent: Manages order creation and documentation</li> <li>Delivery Agent: Controls order delivery status changes</li> <li>Manager Agent: Orchestrates workflow between other agents</li>",Tl,D,Ts="The system follows this process flow:",jl,Y,js="<li>Create order documents for customer requests</li> <li>Verify and update product inventory levels</li> <li>Initialize delivery tracking status</li> <li>Coordinate agent interactions through the manager</li>",wl,P,ws="Key Features:",rl,O,rs="<li>Asynchronous multi-agent coordination</li> <li>Automated inventory management</li> <li>Order status tracking</li> <li>Delivery pipeline integration</li>",dl,K,ds="Define the main system class that orchestrates all agents:",Ul,tt,Il,lt,cl,st,Us="To test our order management system, we need to populate the MongoDB database with sample product data. The following section shows how to add test products with their prices and quantities. You can modify the product details or add more items by following the same structure. Each product has a unique ID, name, price, and initial stock quantity.",ul,et,Is="The sample data provides a representative mix of electronics products with varying price points and stock levels to demonstrate inventory tracking.",ml,nt,cs="To test the system, you might want to add some sample products to MongoDB:",Cl,Mt,Al,at,us=`Sample products added successfully!
`,hl,it,Sl,yt,ms="Here’s a markdown description of the test data approach:",gl,Jt,Cs="Testing Strategy Overview:",bl,pt,As="<li>We test with two different order scenarios:<ul><li>Multi-product order (laptop + smartphone)</li> <li>Single product order (headphones)</li></ul></li>",fl,ot,hs="Test Data Design:",Bl,Tt,Ss="<li>Products represent common electronics at different price points</li> <li>Order quantities are intentionally small to avoid depleting stock</li> <li>Multiple delivery addresses to simulate real-world scenarios</li>",Zl,jt,gs="Alternative Test Examples:",vl,wt,bs="<li>Bulk order: Multiple units of same product</li> <li>Mixed category order: Combination of high/low value items</li> <li>Edge cases: Orders near stock limits</li> <li>Invalid scenarios: Products with insufficient stock</li>",El,rt,fs="The test demonstrates:",Ll,dt,Bs="<li>Multi-product order processing</li> <li>Stock level management</li> <li>Delivery status updates</li> <li>Address handling for different locations</li>",kl,Ut,Zs="Let’s test our system with a sample order:",Ql,It,Gl,ct,vs=`Orders processing result: Here’s the response to your request:

---

### **Processed Orders and Inventory Update**

1. **Orders Created**:
   - **Order 1**:
     - **Products**:
       - \`prod1\`: 2 units
       - \`prod2\`: 1 unit
     - **Delivery Address**: \`123 Main St\`
     - **Order ID**: \`677b8a9ff033af3a53c9a75a\`
   - **Order 2**:
     - **Products**:
       - \`prod3\`: 3 units
     - **Delivery Address**: \`456 Elm St\`
     - **Order ID**: \`677b8aa3f033af3a53c9a75c\`

2. **Inventory Updated**:
   - **\`prod1\` (Laptop)**:
     - Initial stock: 6 units
     - Subtracted: 2 units
     - New stock: 4 units
   - **\`prod2\` (Smartphone)**:
     - Initial stock: 13 units
     - Subtracted: 1 unit
     - New stock: 12 units
   - **\`prod3\` (Headphones)**:
     - Initial stock: 24 units
     - Subtracted: 3 units
     - New stock: 21 units

3. **Delivery Status**:
   - Both orders have been marked as **"in_transit"** and are ready for delivery.

---

### **Summary**:
- The orders have been successfully processed.
- The inventory has been updated to reflect the subtracted quantities.
- The delivery status for both orders is now **"in_transit"**.

Let me know if you need further assistance! 😊
`,Wl,ut,Nl,mt,Es="The system successfully completes these key actions:",Vl,Ct,Ls="<li><p>Order Creation:</p> <ul><li>Multiple orders processed in parallel</li> <li>Order IDs generated and stored in MongoDB</li> <li>Products and delivery addresses properly linked</li></ul></li> <li><p>Inventory Management:</p> <ul><li>Stock levels checked before order processing</li> <li>Quantities decremented after order confirmation</li> <li>Inventory updates reflected in MongoDB</li></ul></li> <li><p>Delivery Status:</p> <ul><li>Initial status set to “pending”</li> <li>Updated to “in_transit” after processing</li> <li>Status changes tracked in order documents</li></ul></li> <li><p>Data Consistency:</p> <ul><li>All MongoDB operations completed atomically</li> <li>Order details preserved accurately</li> <li>Stock levels maintained correctly</li></ul></li>",Rl,At,ks="When running the system, you might notice the agent attempting to interpret text output as Python code. This is an expected behavior of the CodeAgent as it tries to understand and process responses. After several attempts (max_iterations=10), it will stop if unsuccessful.",ql,ht,Qs="Example agent behavior:",$l,St,Gs="<li>Receives text output from order creation</li> <li>Attempts to parse it as code</li> <li>Retries with different interpretations</li> <li>Eventually completes the workflow</li>",_l,gt,Ws=`The multi-agent system demonstrates resilient operation through its error handling
and self-correction mechanisms. While initial attempts may produce error logs,
the agent successfully adapts through iterations. Most importantly, the final
state shows both successful order processing and accurate stock level updates,
maintaining data consistency despite any intermediate errors.`,xl,bt,Ns="This behavior is by design and doesn’t affect the system’s core functionality. The actual order processing, inventory updates, and delivery status changes are completed successfully through the MongoDB operations.",Hl,ft,Xl,Bt,Vs="In this notebook, we have successfully implemented a multi-agent order management system using smolagents and MongoDB. We defined various tools for managing inventory, creating orders, and updating delivery statuses. We also created a main system class to orchestrate these agents and tested the system with sample data and orders.",zl,Zt,Rs="This approach demonstrates the power of combining agent-based systems with robust data persistence solutions like MongoDB to create scalable and efficient order management systems.",Fl,vt,Dl,Lt,Yl;return I=new Ps({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/mongodb_smolagents_multi_micro_agents.ipynb"}]}}),c=new Ys({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new r({props:{title:"Multi-Agent Order Management System with MongoDB",local:"multi-agent-order-management-system-with-mongodb",headingTag:"h1"}}),A=new r({props:{title:"Setting Up MongoDB Atlas",local:"setting-up-mongodb-atlas",headingTag:"h2"}}),S=new r({props:{title:"Security Considerations",local:"security-considerations",headingTag:"h3"}}),f=new r({props:{title:"Setup",local:"setup",headingTag:"h2"}}),Z=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHltb25nbyUyMGxpdGVsbG0=",highlighted:"!pip install smolagents pymongo litellm",wrap:!1}}),v=new r({props:{title:"Import Dependencies",local:"import-dependencies",headingTag:"h2"}}),k=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMuYWdlbnRzJTIwaW1wb3J0JTIwVG9vbENhbGxpbmdBZ2VudCUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwdG9vbCUyQyUyMExpdGVMTE1Nb2RlbCUyQyUyME1hbmFnZWRBZ2VudCUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBweW1vbmdvJTIwaW1wb3J0JTIwTW9uZ29DbGllbnQlMEFmcm9tJTIwZGF0ZXRpbWUlMjBpbXBvcnQlMjBkYXRldGltZSUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBMaXN0JTJDJTIwRGljdCUyQyUyME9wdGlvbmFsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMExMTSUyMG1vZGVsJTBBTU9ERUxfSUQlMjAlM0QlMjAlMjJkZWVwc2VlayUyRmRlZXBzZWVrLWNoYXQlMjIlMEFNT05HT0RCX1VSSSUyMCUzRCUyMHVzZXJkYXRhLmdldCgnTU9OR09fVVJJJyklMEFERUVQU0VFS19BUElfS0VZJTIwJTNEJTIwdXNlcmRhdGEuZ2V0KCdERUVQU0VFS19BUElfS0VZJyk=",highlighted:`<span class="hljs-keyword">from</span> smolagents.agents <span class="hljs-keyword">import</span> ToolCallingAgent
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool, LiteLLMModel, ManagedAgent, CodeAgent
<span class="hljs-keyword">from</span> pymongo <span class="hljs-keyword">import</span> MongoClient
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>

<span class="hljs-comment"># Initialize LLM model</span>
MODEL_ID = <span class="hljs-string">&quot;deepseek/deepseek-chat&quot;</span>
MONGODB_URI = userdata.get(<span class="hljs-string">&#x27;MONGO_URI&#x27;</span>)
DEEPSEEK_API_KEY = userdata.get(<span class="hljs-string">&#x27;DEEPSEEK_API_KEY&#x27;</span>)`,wrap:!1}}),Q=new r({props:{title:"Database Connection Class",local:"database-connection-class",headingTag:"h2"}}),W=new d({props:{code:"bW9uZ29jbGllbnQlMjAlM0QlMjBNb25nb0NsaWVudChNT05HT0RCX1VSSSUyQyUyMGFwcG5hbWUlM0QlMjJkZXZyZWwuc2hvd2Nhc2UubXVsdGktc21vbGFnZW50cyUyMiklMEFkYiUyMCUzRCUyMG1vbmdvY2xpZW50LndhcmVob3VzZQ==",highlighted:`mongoclient = MongoClient(MONGODB_URI, appname=<span class="hljs-string">&quot;devrel.showcase.multi-smolagents&quot;</span>)
db = mongoclient.warehouse`,wrap:!1}}),N=new r({props:{title:"Agent Tools Defenitions",local:"agent-tools-defenitions",headingTag:"h2"}}),q=new d({props:{code:"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",highlighted:`<span class="hljs-section">Inventory Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| check<span class="hljs-emphasis">_stock       | Queries stock     |
|                   | levels            |
+-------------------+-------------------+
| update_</span>stock      | Adjusts inventory |
<span class="hljs-section">|                   | quantities        |
+-------------------+-------------------+</span>

<span class="hljs-section">Order Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| create_order      | Creates new order |
<span class="hljs-section">|                   | document          |
+-------------------+-------------------+</span>

<span class="hljs-section">Delivery Management Tools:
+-------------------+-------------------+</span>
<span class="hljs-section">| Tool              | Description       |
+-------------------+-------------------+</span>
| update<span class="hljs-emphasis">_delivery   | Updates delivery  |
| _</span>status           | status            |
<span class="hljs-code">+-------------------+</span>-------------------+

<span class="hljs-section">Decision Flow:
+-------------------+-------------------+</span>
<span class="hljs-section">| Step              | Action            |
+-------------------+-------------------+</span>
| 1. Create Order   | Uses <span class="hljs-code">\`create_order\`</span>|
|                   | tool to create    |
<span class="hljs-section">|                   | order document    |
+-------------------+-------------------+</span>
| 2. Update Stock   | Uses <span class="hljs-code">\`update_stock\`</span>|
|                   | tool to adjust    |
<span class="hljs-section">|                   | inventory         |
+-------------------+-------------------+</span>
| 3. Update Delivery| Uses <span class="hljs-code">\`update_delivery\`</span>|
| Status            | <span class="hljs-emphasis">_status tool to   |
|                   | set delivery      |
|                   | status to         |
|                   | \`in_</span>transit\`      |
<span class="hljs-code">+-------------------+</span>-------------------+`,wrap:!1}}),_=new d({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNoZWNrX3N0b2NrKHByb2R1Y3RfaWQlM0ElMjBzdHIpJTIwLSUzRSUyMERpY3QlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJRdWVyeSUyMHByb2R1Y3QlMjBzdG9jayUyMGxldmVsLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9kdWN0X2lkJTNBJTIwUHJvZHVjdCUyMGlkZW50aWZpZXIlMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGljdCUyMGNvbnRhaW5pbmclMjBwcm9kdWN0JTIwZGV0YWlscyUyMGFuZCUyMHF1YW50aXR5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGIucHJvZHVjdHMuZmluZF9vbmUoJTdCJTIyX2lkJTIyJTNBJTIwcHJvZHVjdF9pZCU3RCklMEElMEElNDB0b29sJTBBZGVmJTIwdXBkYXRlX3N0b2NrKHByb2R1Y3RfaWQlM0ElMjBzdHIlMkMlMjBxdWFudGl0eSUzQSUyMGludCklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlVwZGF0ZSUyMHByb2R1Y3QlMjBzdG9jayUyMHF1YW50aXR5LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9kdWN0X2lkJTNBJTIwUHJvZHVjdCUyMGlkZW50aWZpZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWFudGl0eSUzQSUyMEFtb3VudCUyMHRvJTIwZGVjcmVhc2UlMjBmcm9tJTIwc3RvY2slMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm9vbCUzQSUyMFN1Y2Nlc3MlMjBzdGF0dXMlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBkYi5wcm9kdWN0cy51cGRhdGVfb25lKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMl9pZCUyMiUzQSUyMHByb2R1Y3RfaWQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjIlMjRpbmMlMjIlM0ElMjAlN0IlMjJxdWFudGl0eSUyMiUzQSUyMC1xdWFudGl0eSU3RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQubW9kaWZpZWRfY291bnQlMjAlM0UlMjAw",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_stock</span>(<span class="hljs-params">product_id: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
    <span class="hljs-string">&quot;&quot;&quot;Query product stock level.

    Args:
        product_id: Product identifier

    Returns:
        Dict containing product details and quantity
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> db.products.find_one({<span class="hljs-string">&quot;_id&quot;</span>: product_id})

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_stock</span>(<span class="hljs-params">product_id: <span class="hljs-built_in">str</span>, quantity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-string">&quot;&quot;&quot;Update product stock quantity.

    Args:
        product_id: Product identifier
        quantity: Amount to decrease from stock

    Returns:
        bool: Success status
    &quot;&quot;&quot;</span>
    result = db.products.update_one(
        {<span class="hljs-string">&quot;_id&quot;</span>: product_id},
        {<span class="hljs-string">&quot;$inc&quot;</span>: {<span class="hljs-string">&quot;quantity&quot;</span>: -quantity}}
    )
    <span class="hljs-keyword">return</span> result.modified_count &gt; <span class="hljs-number">0</span>`,wrap:!1}}),x=new d({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNyZWF0ZV9vcmRlciglMjBwcm9kdWN0cyUzQSUyMGFueSUyQyUyMGFkZHJlc3MlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNyZWF0ZSUyMG5ldyUyMG9yZGVyJTIwZm9yJTIwYWxsJTIwcHJvdmlkZWQlMjBwcm9kdWN0cy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvZHVjdHMlM0ElMjBMaXN0JTIwb2YlMjBwcm9kdWN0cyUyMHdpdGglMjBxdWFudGl0aWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWRkcmVzcyUzQSUyMERlbGl2ZXJ5JTIwYWRkcmVzcyUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHIlM0ElMjBPcmRlciUyMElEJTIwbWVzc2FnZSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG9yZGVyJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvZHVjdHMlMjIlM0ElMjBwcm9kdWN0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMnBlbmRpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZWxpdmVyeV9hZGRyZXNzJTIyJTNBJTIwYWRkcmVzcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNyZWF0ZWRfYXQlMjIlM0ElMjBkYXRldGltZS5ub3coKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGRiLm9yZGVycy5pbnNlcnRfb25lKG9yZGVyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJTdWNjZXNzZnVsbHklMjBvcmRlcmVkJTIwJTNBJTIwJTdCc3RyKHJlc3VsdC5pbnNlcnRlZF9pZCklN0QlMjI=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_order</span>(<span class="hljs-params"> products: <span class="hljs-built_in">any</span>, address: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Create new order for all provided products.

    Args:
        products: List of products with quantities
        address: Delivery address

    Returns:
        str: Order ID message
    &quot;&quot;&quot;</span>
    order = {
        <span class="hljs-string">&quot;products&quot;</span>: products,
        <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;pending&quot;</span>,
        <span class="hljs-string">&quot;delivery_address&quot;</span>: address,
        <span class="hljs-string">&quot;created_at&quot;</span>: datetime.now()
    }
    result = db.orders.insert_one(order)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Successfully ordered : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(result.inserted_id)}</span>&quot;</span>`,wrap:!1}}),H=new d({props:{code:"ZnJvbSUyMGJzb24ub2JqZWN0aWQlMjBpbXBvcnQlMjBPYmplY3RJZCUwQSU0MHRvb2wlMEFkZWYlMjB1cGRhdGVfZGVsaXZlcnlfc3RhdHVzKG9yZGVyX2lkJTNBJTIwc3RyJTJDJTIwc3RhdHVzJTNBJTIwc3RyKSUyMC0lM0UlMjBib29sJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVXBkYXRlJTIwb3JkZXIlMjBkZWxpdmVyeSUyMHN0YXR1cyUyMHRvJTIwaW5fdHJhbnNpdCUyMG9uY2UlMjBhJTIwcGVuZGluZyUyMG9yZGVyJTIwaXMlMjBwcm92aWRlZCUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcmRlcl9pZCUzQSUyME9yZGVyJTIwaWRlbnRpZmllciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXR1cyUzQSUyME5ldyUyMGRlbGl2ZXJ5JTIwc3RhdHVzJTIwaXMlMjBiZWluZyUyMHNldCUyMHRvJTIwaW5fdHJhbnNpdCUyMG9yJTIwZGVsaXZlcmVkJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJvb2wlM0ElMjBTdWNjZXNzJTIwc3RhdHVzJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBzdGF0dXMlMjBub3QlMjBpbiUyMCU1QiUyMnBlbmRpbmclMjIlMkMlMjAlMjJpbl90cmFuc2l0JTIyJTJDJTIwJTIyZGVsaXZlcmVkJTIyJTJDJTIwJTIyY2FuY2VsbGVkJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKCUyMkludmFsaWQlMjBkZWxpdmVyeSUyMHN0YXR1cyUyMiklMEElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBkYi5vcmRlcnMudXBkYXRlX29uZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJfaWQlMjIlM0ElMjAlMjBPYmplY3RJZChvcmRlcl9pZCklMkMlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJwZW5kaW5nJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIyJTI0c2V0JTIyJTNBJTIwJTdCJTIyc3RhdHVzJTIyJTNBJTIwc3RhdHVzJTdEJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdC5tb2RpZmllZF9jb3VudCUyMCUzRSUyMDA=",highlighted:`<span class="hljs-keyword">from</span> bson.objectid <span class="hljs-keyword">import</span> ObjectId
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_delivery_status</span>(<span class="hljs-params">order_id: <span class="hljs-built_in">str</span>, status: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-string">&quot;&quot;&quot;Update order delivery status to in_transit once a pending order is provided

    Args:
        order_id: Order identifier
        status: New delivery status is being set to in_transit or delivered

    Returns:
        bool: Success status
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> status <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;pending&quot;</span>, <span class="hljs-string">&quot;in_transit&quot;</span>, <span class="hljs-string">&quot;delivered&quot;</span>, <span class="hljs-string">&quot;cancelled&quot;</span>]:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Invalid delivery status&quot;</span>)

    result = db.orders.update_one(
        {<span class="hljs-string">&quot;_id&quot;</span>:  ObjectId(order_id), <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;pending&quot;</span>},
        {<span class="hljs-string">&quot;$set&quot;</span>: {<span class="hljs-string">&quot;status&quot;</span>: status}}
    )
    <span class="hljs-keyword">return</span> result.modified_count &gt; <span class="hljs-number">0</span>`,wrap:!1}}),X=new r({props:{title:"Main Order Management System",local:"main-order-management-system",headingTag:"h2"}}),tt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">OrderManagementSystem</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multi-agent order management system&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_id: <span class="hljs-built_in">str</span> = MODEL_ID</span>):
        self.model = LiteLLMModel(model_id=model_id, api_key=DEEPSEEK_API_KEY)



        <span class="hljs-comment"># Create agents</span>
        self.inventory_agent = ToolCallingAgent(
            tools=[check_stock, update_stock],
            model=self.model,
            max_iterations=<span class="hljs-number">10</span>
        )

        self.order_agent = ToolCallingAgent(
            tools=[create_order],
            model=self.model,
            max_iterations=<span class="hljs-number">10</span>
        )

        self.delivery_agent = ToolCallingAgent(
            tools=[update_delivery_status],
            model=self.model,
            max_iterations=<span class="hljs-number">10</span>
        )

        <span class="hljs-comment"># Create managed agents</span>
        self.managed_agents = [
            ManagedAgent(self.inventory_agent, <span class="hljs-string">&quot;inventory&quot;</span>, <span class="hljs-string">&quot;Manages product inventory&quot;</span>),
            ManagedAgent(self.order_agent, <span class="hljs-string">&quot;orders&quot;</span>, <span class="hljs-string">&quot;Handles order creation&quot;</span>),
            ManagedAgent(self.delivery_agent, <span class="hljs-string">&quot;delivery&quot;</span>, <span class="hljs-string">&quot;Manages delivery status&quot;</span>)
        ]

        <span class="hljs-comment"># Create manager agent</span>
        self.manager = CodeAgent(
            tools=[],
            system_prompt=<span class="hljs-string">&quot;&quot;&quot;For each order:
            1. Create the order document
            2. Update the inventory
            3. Set deliviery status to in_transit

            Use relevant agents:  {{managed_agents_descriptions}}  and you can use {{authorized_imports}}
            &quot;&quot;&quot;</span>,
            model=self.model,
            managed_agents=self.managed_agents,
            additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;json&quot;</span>]
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_order</span>(<span class="hljs-params">self, orders: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Process a set of orders.

        Args:
            orders: List of orders each has address and products

        Returns:
            str: Processing result
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.manager.run(
            <span class="hljs-string">f&quot;Process the following  <span class="hljs-subst">{orders}</span> as well as substract the ordered items from inventory.&quot;</span>
            <span class="hljs-string">f&quot;to be delivered to relevant addresses&quot;</span>
        )`,wrap:!1}}),lt=new r({props:{title:"Adding Sample Data",local:"adding-sample-data",headingTag:"h2"}}),Mt=new d({props:{code:"ZGVmJTIwYWRkX3NhbXBsZV9wcm9kdWN0cygpJTNBJTBBJTIwJTIwJTIwJTIwZGIucHJvZHVjdHMuZGVsZXRlX21hbnkoJTdCJTdEKSUwQSUyMCUyMCUyMCUyMHNhbXBsZV9wcm9kdWN0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMl9pZCUyMiUzQSUyMCUyMnByb2QxJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMkxhcHRvcCUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwOTk5Ljk5JTJDJTIwJTIycXVhbnRpdHklMjIlM0ElMjAxMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMl9pZCUyMiUzQSUyMCUyMnByb2QyJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMlNtYXJ0cGhvbmUlMjIlMkMlMjAlMjJwcmljZSUyMiUzQSUyMDU5OS45OSUyQyUyMCUyMnF1YW50aXR5JTIyJTNBJTIwMTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJfaWQlMjIlM0ElMjAlMjJwcm9kMyUyMiUyQyUyMCUyMm5hbWUlMjIlM0ElMjAlMjJIZWFkcGhvbmVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA5OS45OSUyQyUyMCUyMnF1YW50aXR5JTIyJTNBJTIwMzAlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjBkYi5wcm9kdWN0cy5pbnNlcnRfbWFueShzYW1wbGVfcHJvZHVjdHMpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyU2FtcGxlJTIwcHJvZHVjdHMlMjBhZGRlZCUyMHN1Y2Nlc3NmdWxseSElMjIpJTBBJTBBJTIzJTIwVW5jb21tZW50JTIwdG8lMjBhZGQlMjBzYW1wbGUlMjBwcm9kdWN0cyUwQWFkZF9zYW1wbGVfcHJvZHVjdHMoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_sample_products</span>():
<span class="hljs-meta">... </span>    db.products.delete_many({})
<span class="hljs-meta">... </span>    sample_products = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod1&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Laptop&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">999.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">10</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod2&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Smartphone&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">599.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">15</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-string">&quot;prod3&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Headphones&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">99.99</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">30</span>}
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    db.products.insert_many(sample_products)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample products added successfully!&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Uncomment to add sample products</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>add_sample_products()`,wrap:!1}}),it=new r({props:{title:"Testing the System",local:"testing-the-system",headingTag:"h2"}}),It=new d({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHN5c3RlbSUwQXN5c3RlbSUyMCUzRCUyME9yZGVyTWFuYWdlbWVudFN5c3RlbSgpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGVzdCUyMG9yZGVycyUwQXRlc3Rfb3JkZXJzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvZHVjdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDElMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDIlMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDElN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRyZXNzJTIyJTNBJTIwJTIyMTIzJTIwTWFpbiUyMFN0JTIyJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvZHVjdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJwcm9kdWN0X2lkJTIyJTNBJTIwJTIycHJvZDMlMjIlMkMlMjAlMjJxdWFudGl0eSUyMiUzQSUyMDMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhZGRyZXNzJTIyJTNBJTIwJTIyNDU2JTIwRWxtJTIwU3QlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwb3JkZXIlMEFyZXN1bHQlMjAlM0QlMjBzeXN0ZW0ucHJvY2Vzc19vcmRlciglMEElMjAlMjAlMjAlMjBvcmRlcnMlM0R0ZXN0X29yZGVycyUwQSklMEElMEFwcmludCglMjJPcmRlcnMlMjBwcm9jZXNzaW5nJTIwcmVzdWx0JTNBJTIyJTJDJTIwcmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>system = OrderManagementSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create test orders</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_orders = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;products&quot;</span>: [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod1&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">2</span>},
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod2&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">1</span>}
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;address&quot;</span>: <span class="hljs-string">&quot;123 Main St&quot;</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;products&quot;</span>: [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;product_id&quot;</span>: <span class="hljs-string">&quot;prod3&quot;</span>, <span class="hljs-string">&quot;quantity&quot;</span>: <span class="hljs-number">3</span>}
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;address&quot;</span>: <span class="hljs-string">&quot;456 Elm St&quot;</span>
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Process order</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = system.process_order(
<span class="hljs-meta">... </span>    orders=test_orders
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Orders processing result:&quot;</span>, result)`,wrap:!1}}),ut=new r({props:{title:"System Output Analysis",local:"system-output-analysis",headingTag:"h2"}}),ft=new r({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),vt=new Os({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/mongodb_smolagents_multi_micro_agents.md"}}),{c(){U=a("meta"),kt=n(),Et=a("p"),Qt=n(),J(I.$$.fragment),Gt=n(),J(c.$$.fragment),Wt=n(),J(u.$$.fragment),Nt=n(),m=a("p"),m.textContent=Ol,Vt=n(),C=a("ul"),C.innerHTML=Kl,Rt=n(),J(A.$$.fragment),qt=n(),h=a("ol"),h.innerHTML=ts,$t=n(),J(S.$$.fragment),_t=n(),g=a("p"),g.textContent=ls,xt=n(),b=a("ul"),b.innerHTML=ss,Ht=n(),J(f.$$.fragment),Xt=n(),B=a("p"),B.textContent=es,zt=n(),J(Z.$$.fragment),Ft=n(),J(v.$$.fragment),Dt=n(),E=a("p"),E.innerHTML=ns,Yt=n(),L=a("p"),L.textContent=Ms,Pt=n(),J(k.$$.fragment),Ot=n(),J(Q.$$.fragment),Kt=n(),G=a("p"),G.textContent=as,tl=n(),J(W.$$.fragment),ll=n(),J(N.$$.fragment),sl=n(),V=a("p"),V.textContent=is,el=n(),R=a("p"),R.textContent=ys,nl=n(),J(q.$$.fragment),Ml=n(),$=a("p"),$.textContent=Js,al=n(),J(_.$$.fragment),il=n(),J(x.$$.fragment),yl=n(),J(H.$$.fragment),Jl=n(),J(X.$$.fragment),pl=n(),z=a("p"),z.textContent=ps,ol=n(),F=a("ul"),F.innerHTML=os,Tl=n(),D=a("p"),D.textContent=Ts,jl=n(),Y=a("ol"),Y.innerHTML=js,wl=n(),P=a("p"),P.textContent=ws,rl=n(),O=a("ul"),O.innerHTML=rs,dl=n(),K=a("p"),K.textContent=ds,Ul=n(),J(tt.$$.fragment),Il=n(),J(lt.$$.fragment),cl=n(),st=a("p"),st.textContent=Us,ul=n(),et=a("p"),et.textContent=Is,ml=n(),nt=a("p"),nt.textContent=cs,Cl=n(),J(Mt.$$.fragment),Al=n(),at=a("pre"),at.textContent=us,hl=n(),J(it.$$.fragment),Sl=n(),yt=a("p"),yt.textContent=ms,gl=n(),Jt=a("p"),Jt.textContent=Cs,bl=n(),pt=a("ol"),pt.innerHTML=As,fl=n(),ot=a("p"),ot.textContent=hs,Bl=n(),Tt=a("ul"),Tt.innerHTML=Ss,Zl=n(),jt=a("p"),jt.textContent=gs,vl=n(),wt=a("ul"),wt.innerHTML=bs,El=n(),rt=a("p"),rt.textContent=fs,Ll=n(),dt=a("ul"),dt.innerHTML=Bs,kl=n(),Ut=a("p"),Ut.textContent=Zs,Ql=n(),J(It.$$.fragment),Gl=n(),ct=a("pre"),ct.textContent=vs,Wl=n(),J(ut.$$.fragment),Nl=n(),mt=a("p"),mt.textContent=Es,Vl=n(),Ct=a("ol"),Ct.innerHTML=Ls,Rl=n(),At=a("p"),At.textContent=ks,ql=n(),ht=a("p"),ht.textContent=Qs,$l=n(),St=a("ol"),St.innerHTML=Gs,_l=n(),gt=a("p"),gt.textContent=Ws,xl=n(),bt=a("p"),bt.textContent=Ns,Hl=n(),J(ft.$$.fragment),Xl=n(),Bt=a("p"),Bt.textContent=Vs,zl=n(),Zt=a("p"),Zt.textContent=Rs,Fl=n(),J(vt.$$.fragment),Dl=n(),Lt=a("p"),this.h()},l(t){const l=Fs("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(s),kt=M(t),Et=i(t,"P",{}),qs(Et).forEach(s),Qt=M(t),p(I.$$.fragment,t),Gt=M(t),p(c.$$.fragment,t),Wt=M(t),p(u.$$.fragment,t),Nt=M(t),m=i(t,"P",{"data-svelte-h":!0}),y(m)!=="svelte-pv9nv4"&&(m.textContent=Ol),Vt=M(t),C=i(t,"UL",{"data-svelte-h":!0}),y(C)!=="svelte-1108i8y"&&(C.innerHTML=Kl),Rt=M(t),p(A.$$.fragment,t),qt=M(t),h=i(t,"OL",{"data-svelte-h":!0}),y(h)!=="svelte-1t9sx1r"&&(h.innerHTML=ts),$t=M(t),p(S.$$.fragment,t),_t=M(t),g=i(t,"P",{"data-svelte-h":!0}),y(g)!=="svelte-kw8y8a"&&(g.textContent=ls),xt=M(t),b=i(t,"UL",{"data-svelte-h":!0}),y(b)!=="svelte-1xl8b3t"&&(b.innerHTML=ss),Ht=M(t),p(f.$$.fragment,t),Xt=M(t),B=i(t,"P",{"data-svelte-h":!0}),y(B)!=="svelte-nwwhg"&&(B.textContent=es),zt=M(t),p(Z.$$.fragment,t),Ft=M(t),p(v.$$.fragment,t),Dt=M(t),E=i(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1kg1686"&&(E.innerHTML=ns),Yt=M(t),L=i(t,"P",{"data-svelte-h":!0}),y(L)!=="svelte-nkgjxn"&&(L.textContent=Ms),Pt=M(t),p(k.$$.fragment,t),Ot=M(t),p(Q.$$.fragment,t),Kt=M(t),G=i(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-13trwya"&&(G.textContent=as),tl=M(t),p(W.$$.fragment,t),ll=M(t),p(N.$$.fragment,t),sl=M(t),V=i(t,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1ksfafa"&&(V.textContent=is),el=M(t),R=i(t,"P",{"data-svelte-h":!0}),y(R)!=="svelte-tpm4jt"&&(R.textContent=ys),nl=M(t),p(q.$$.fragment,t),Ml=M(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-m415tj"&&($.textContent=Js),al=M(t),p(_.$$.fragment,t),il=M(t),p(x.$$.fragment,t),yl=M(t),p(H.$$.fragment,t),Jl=M(t),p(X.$$.fragment,t),pl=M(t),z=i(t,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1b4otdh"&&(z.textContent=ps),ol=M(t),F=i(t,"UL",{"data-svelte-h":!0}),y(F)!=="svelte-10ywi02"&&(F.innerHTML=os),Tl=M(t),D=i(t,"P",{"data-svelte-h":!0}),y(D)!=="svelte-87kfe1"&&(D.textContent=Ts),jl=M(t),Y=i(t,"OL",{"data-svelte-h":!0}),y(Y)!=="svelte-bspmzg"&&(Y.innerHTML=js),wl=M(t),P=i(t,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1adc5s0"&&(P.textContent=ws),rl=M(t),O=i(t,"UL",{"data-svelte-h":!0}),y(O)!=="svelte-pu7ouq"&&(O.innerHTML=rs),dl=M(t),K=i(t,"P",{"data-svelte-h":!0}),y(K)!=="svelte-gzjqwh"&&(K.textContent=ds),Ul=M(t),p(tt.$$.fragment,t),Il=M(t),p(lt.$$.fragment,t),cl=M(t),st=i(t,"P",{"data-svelte-h":!0}),y(st)!=="svelte-skvvoh"&&(st.textContent=Us),ul=M(t),et=i(t,"P",{"data-svelte-h":!0}),y(et)!=="svelte-308bd7"&&(et.textContent=Is),ml=M(t),nt=i(t,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-10gr0a8"&&(nt.textContent=cs),Cl=M(t),p(Mt.$$.fragment,t),Al=M(t),at=i(t,"PRE",{"data-svelte-h":!0}),y(at)!=="svelte-reill2"&&(at.textContent=us),hl=M(t),p(it.$$.fragment,t),Sl=M(t),yt=i(t,"P",{"data-svelte-h":!0}),y(yt)!=="svelte-kd1hkk"&&(yt.textContent=ms),gl=M(t),Jt=i(t,"P",{"data-svelte-h":!0}),y(Jt)!=="svelte-108fun2"&&(Jt.textContent=Cs),bl=M(t),pt=i(t,"OL",{"data-svelte-h":!0}),y(pt)!=="svelte-9s5awp"&&(pt.innerHTML=As),fl=M(t),ot=i(t,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-1sxzyao"&&(ot.textContent=hs),Bl=M(t),Tt=i(t,"UL",{"data-svelte-h":!0}),y(Tt)!=="svelte-1ktquui"&&(Tt.innerHTML=Ss),Zl=M(t),jt=i(t,"P",{"data-svelte-h":!0}),y(jt)!=="svelte-ic4hd6"&&(jt.textContent=gs),vl=M(t),wt=i(t,"UL",{"data-svelte-h":!0}),y(wt)!=="svelte-16hw8nq"&&(wt.innerHTML=bs),El=M(t),rt=i(t,"P",{"data-svelte-h":!0}),y(rt)!=="svelte-1gjdgnm"&&(rt.textContent=fs),Ll=M(t),dt=i(t,"UL",{"data-svelte-h":!0}),y(dt)!=="svelte-1vmat7s"&&(dt.innerHTML=Bs),kl=M(t),Ut=i(t,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-dyhdx3"&&(Ut.textContent=Zs),Ql=M(t),p(It.$$.fragment,t),Gl=M(t),ct=i(t,"PRE",{"data-svelte-h":!0}),y(ct)!=="svelte-do4fzt"&&(ct.textContent=vs),Wl=M(t),p(ut.$$.fragment,t),Nl=M(t),mt=i(t,"P",{"data-svelte-h":!0}),y(mt)!=="svelte-63ycws"&&(mt.textContent=Es),Vl=M(t),Ct=i(t,"OL",{"data-svelte-h":!0}),y(Ct)!=="svelte-bbxga9"&&(Ct.innerHTML=Ls),Rl=M(t),At=i(t,"P",{"data-svelte-h":!0}),y(At)!=="svelte-1isw8dg"&&(At.textContent=ks),ql=M(t),ht=i(t,"P",{"data-svelte-h":!0}),y(ht)!=="svelte-1ym17yf"&&(ht.textContent=Qs),$l=M(t),St=i(t,"OL",{"data-svelte-h":!0}),y(St)!=="svelte-pmcruk"&&(St.innerHTML=Gs),_l=M(t),gt=i(t,"P",{"data-svelte-h":!0}),y(gt)!=="svelte-g047f8"&&(gt.textContent=Ws),xl=M(t),bt=i(t,"P",{"data-svelte-h":!0}),y(bt)!=="svelte-29mbrr"&&(bt.textContent=Ns),Hl=M(t),p(ft.$$.fragment,t),Xl=M(t),Bt=i(t,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-lwihmm"&&(Bt.textContent=Vs),zl=M(t),Zt=i(t,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-lfcqpz"&&(Zt.textContent=Rs),Fl=M(t),p(vt.$$.fragment,t),Dl=M(t),Lt=i(t,"P",{}),qs(Lt).forEach(s),this.h()},h(){$s(U,"name","hf:doc:metadata"),$s(U,"content",te)},m(t,l){Ds(document.head,U),e(t,kt,l),e(t,Et,l),e(t,Qt,l),o(I,t,l),e(t,Gt,l),o(c,t,l),e(t,Wt,l),o(u,t,l),e(t,Nt,l),e(t,m,l),e(t,Vt,l),e(t,C,l),e(t,Rt,l),o(A,t,l),e(t,qt,l),e(t,h,l),e(t,$t,l),o(S,t,l),e(t,_t,l),e(t,g,l),e(t,xt,l),e(t,b,l),e(t,Ht,l),o(f,t,l),e(t,Xt,l),e(t,B,l),e(t,zt,l),o(Z,t,l),e(t,Ft,l),o(v,t,l),e(t,Dt,l),e(t,E,l),e(t,Yt,l),e(t,L,l),e(t,Pt,l),o(k,t,l),e(t,Ot,l),o(Q,t,l),e(t,Kt,l),e(t,G,l),e(t,tl,l),o(W,t,l),e(t,ll,l),o(N,t,l),e(t,sl,l),e(t,V,l),e(t,el,l),e(t,R,l),e(t,nl,l),o(q,t,l),e(t,Ml,l),e(t,$,l),e(t,al,l),o(_,t,l),e(t,il,l),o(x,t,l),e(t,yl,l),o(H,t,l),e(t,Jl,l),o(X,t,l),e(t,pl,l),e(t,z,l),e(t,ol,l),e(t,F,l),e(t,Tl,l),e(t,D,l),e(t,jl,l),e(t,Y,l),e(t,wl,l),e(t,P,l),e(t,rl,l),e(t,O,l),e(t,dl,l),e(t,K,l),e(t,Ul,l),o(tt,t,l),e(t,Il,l),o(lt,t,l),e(t,cl,l),e(t,st,l),e(t,ul,l),e(t,et,l),e(t,ml,l),e(t,nt,l),e(t,Cl,l),o(Mt,t,l),e(t,Al,l),e(t,at,l),e(t,hl,l),o(it,t,l),e(t,Sl,l),e(t,yt,l),e(t,gl,l),e(t,Jt,l),e(t,bl,l),e(t,pt,l),e(t,fl,l),e(t,ot,l),e(t,Bl,l),e(t,Tt,l),e(t,Zl,l),e(t,jt,l),e(t,vl,l),e(t,wt,l),e(t,El,l),e(t,rt,l),e(t,Ll,l),e(t,dt,l),e(t,kl,l),e(t,Ut,l),e(t,Ql,l),o(It,t,l),e(t,Gl,l),e(t,ct,l),e(t,Wl,l),o(ut,t,l),e(t,Nl,l),e(t,mt,l),e(t,Vl,l),e(t,Ct,l),e(t,Rl,l),e(t,At,l),e(t,ql,l),e(t,ht,l),e(t,$l,l),e(t,St,l),e(t,_l,l),e(t,gt,l),e(t,xl,l),e(t,bt,l),e(t,Hl,l),o(ft,t,l),e(t,Xl,l),e(t,Bt,l),e(t,zl,l),e(t,Zt,l),e(t,Fl,l),o(vt,t,l),e(t,Dl,l),e(t,Lt,l),Yl=!0},p:xs,i(t){Yl||(T(I.$$.fragment,t),T(c.$$.fragment,t),T(u.$$.fragment,t),T(A.$$.fragment,t),T(S.$$.fragment,t),T(f.$$.fragment,t),T(Z.$$.fragment,t),T(v.$$.fragment,t),T(k.$$.fragment,t),T(Q.$$.fragment,t),T(W.$$.fragment,t),T(N.$$.fragment,t),T(q.$$.fragment,t),T(_.$$.fragment,t),T(x.$$.fragment,t),T(H.$$.fragment,t),T(X.$$.fragment,t),T(tt.$$.fragment,t),T(lt.$$.fragment,t),T(Mt.$$.fragment,t),T(it.$$.fragment,t),T(It.$$.fragment,t),T(ut.$$.fragment,t),T(ft.$$.fragment,t),T(vt.$$.fragment,t),Yl=!0)},o(t){j(I.$$.fragment,t),j(c.$$.fragment,t),j(u.$$.fragment,t),j(A.$$.fragment,t),j(S.$$.fragment,t),j(f.$$.fragment,t),j(Z.$$.fragment,t),j(v.$$.fragment,t),j(k.$$.fragment,t),j(Q.$$.fragment,t),j(W.$$.fragment,t),j(N.$$.fragment,t),j(q.$$.fragment,t),j(_.$$.fragment,t),j(x.$$.fragment,t),j(H.$$.fragment,t),j(X.$$.fragment,t),j(tt.$$.fragment,t),j(lt.$$.fragment,t),j(Mt.$$.fragment,t),j(it.$$.fragment,t),j(It.$$.fragment,t),j(ut.$$.fragment,t),j(ft.$$.fragment,t),j(vt.$$.fragment,t),Yl=!1},d(t){t&&(s(kt),s(Et),s(Qt),s(Gt),s(Wt),s(Nt),s(m),s(Vt),s(C),s(Rt),s(qt),s(h),s($t),s(_t),s(g),s(xt),s(b),s(Ht),s(Xt),s(B),s(zt),s(Ft),s(Dt),s(E),s(Yt),s(L),s(Pt),s(Ot),s(Kt),s(G),s(tl),s(ll),s(sl),s(V),s(el),s(R),s(nl),s(Ml),s($),s(al),s(il),s(yl),s(Jl),s(pl),s(z),s(ol),s(F),s(Tl),s(D),s(jl),s(Y),s(wl),s(P),s(rl),s(O),s(dl),s(K),s(Ul),s(Il),s(cl),s(st),s(ul),s(et),s(ml),s(nt),s(Cl),s(Al),s(at),s(hl),s(Sl),s(yt),s(gl),s(Jt),s(bl),s(pt),s(fl),s(ot),s(Bl),s(Tt),s(Zl),s(jt),s(vl),s(wt),s(El),s(rt),s(Ll),s(dt),s(kl),s(Ut),s(Ql),s(Gl),s(ct),s(Wl),s(Nl),s(mt),s(Vl),s(Ct),s(Rl),s(At),s(ql),s(ht),s($l),s(St),s(_l),s(gt),s(xl),s(bt),s(Hl),s(Xl),s(Bt),s(zl),s(Zt),s(Fl),s(Dl),s(Lt)),s(U),w(I,t),w(c,t),w(u,t),w(A,t),w(S,t),w(f,t),w(Z,t),w(v,t),w(k,t),w(Q,t),w(W,t),w(N,t),w(q,t),w(_,t),w(x,t),w(H,t),w(X,t),w(tt,t),w(lt,t),w(Mt,t),w(it,t),w(It,t),w(ut,t),w(ft,t),w(vt,t)}}}const te='{"title":"Multi-Agent Order Management System with MongoDB","local":"multi-agent-order-management-system-with-mongodb","sections":[{"title":"Setting Up MongoDB Atlas","local":"setting-up-mongodb-atlas","sections":[{"title":"Security Considerations","local":"security-considerations","sections":[],"depth":3}],"depth":2},{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Import Dependencies","local":"import-dependencies","sections":[],"depth":2},{"title":"Database Connection Class","local":"database-connection-class","sections":[],"depth":2},{"title":"Agent Tools Defenitions","local":"agent-tools-defenitions","sections":[],"depth":2},{"title":"Main Order Management System","local":"main-order-management-system","sections":[],"depth":2},{"title":"Adding Sample Data","local":"adding-sample-data","sections":[],"depth":2},{"title":"Testing the System","local":"testing-the-system","sections":[],"depth":2},{"title":"System Output Analysis","local":"system-output-analysis","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function le(Pl){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ie extends Xs{constructor(U){super(),zs(this,U,le,Ks,_s,{})}}export{ie as component};
