import{s as _t,n as $t,o as Nt}from"../chunks/scheduler.1f027d5a.js";import{S as At,i as qt,e as i,s as l,c as p,h as Pt,a as o,d as a,b as n,f as Ft,g as c,j as r,k as ce,q as ct,l as Dt,m as s,n as h,t as m,o as y,p as M}from"../chunks/index.5cb6ce42.js";import{C as Ot}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Kt,C as pe}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as ye,E as ea}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function ta(ht){let u,Me,he,ge,f,ue,U,de,T,be,J,mt='<em>Authored by: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',we,v,yt='<a href="https://docs.arize.com/phoenix" rel="nofollow">Phoenix</a> is an open-source observability library by <a href="https://arize.com/" rel="nofollow">Arize AI</a> designed for experimentation, evaluation, and troubleshooting. It allows AI Engineers and Data Scientists to quickly visualize their data, evaluate performance, track down issues, and export data to improve.',je,g,Mt='<div style="width: 32%; text-align: center; display: flex; flex-direction: column; align-items: center; justify-content: flex-start;"><img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/phoenix-tracing.png" style="width: 100%; height: 200px; object-fit: contain;"/> <p style="margin-top: 10px; margin-bottom: 0;">Tracing</p></div> <div style="width: 32%; text-align: center; display: flex; flex-direction: column; align-items: center; justify-content: flex-start;"><img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/phoenix-datasets.png" style="width: 100%; height: 200px; object-fit: contain;"/> <p style="margin-top: 10px; margin-bottom: 0;">Datasets</p></div> <div style="width: 32%; text-align: center; display: flex; flex-direction: column; align-items: center; justify-content: flex-start;"><img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/phoenix-experiments.png" style="width: 100%; height: 200px; object-fit: contain;"/> <p style="margin-top: 10px; margin-bottom: 0;">Experiments</p></div>',fe,I,gt='In this notebook, we’ll see how to deploy a Phoenix observability dashboard on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> and configure it to automatically trace LLM calls, providing a comprehensive view into the inner workings of your LLM applications.',Ue,B,Te,k,ut='While Phoenix offers a <a href="https://docs.arize.com/phoenix/deployment/environments#notebooks" rel="nofollow">notebook-first option</a> for local development, it can also be deployed as a <a href="https://docs.arize.com/phoenix/deployment/environments#container" rel="nofollow">standalone dashboard via Docker</a>. A long-running, hosted dashboard is a great way to provide a centralized view into your LLM application behavior, and to collaborate with your team. Hugging Face Spaces offers a simple way to host ML applications with optional, persistent storage, and it’s support for custom Docker images makes it a great platform for hosting Phoenix - lets see how it works!',Je,Z,dt='First, we’ll <a href="https://huggingface.co/spaces/andrewrreed/phoenix-arize-observability-demo?duplicate=true" rel="nofollow">duplicate the demo space</a>',ve,C,bt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/duplicate.png"/>',Ie,x,wt="We can configure the space to be private or public, and it can live in our user namespace, or in an organization namespace. We can use the default, free-tier CPU, and importantly, specify that we want to attach a persistent disk to the space.",Be,d,jt="<p>In order for the tracing data to persist across Space restarts, we <em>must</em> configure a persistent disk, otherwise all data will be lost when the space is restarted. Configuring a persistent disk is a paid feature, and will incur a cost for the lifetime of the Space. In this case, we’ll use the Small - 20GB disk option for $0.01 per hour.</p>",ke,W,ft="After clicking “Duplicate Space”, the Docker image will begin building. This will take a few minutes to complete, and then we’ll see an empty Phoenix dashboard.",Ze,L,Ut='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/empty-dashboard.png"/>',Ce,S,xe,G,Tt='Now that we have a running Phoenix dashboard, we can configure our application to automatically trace LLM calls using an <a href="https://docs.arize.com/phoenix/quickstart#connect-your-app-to-phoenix" rel="nofollow">OpenTelemetry TracerProvider</a>. In this example, we’ll instrument our application using the OpenAI client library, and trace LLM calls made from the <code>openai</code> Python package to open LLMs running on <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Hugging Face’s Serverless Inference API</a>.',We,b,Jt='<p>Phoenix supports tracing for <a href="https://docs.arize.com/phoenix/tracing/integrations-tracing" rel="nofollow">a wide variety of LLM frameworks</a>, including LangChain, LlamaIndex, AWS Bedrock, and more.</p>',Le,R,vt="First, we need to install the necessary libraries:",Se,H,Ge,E,It="Then, we’ll login to Hugging Face using the <code>huggingface_hub</code> library. This will allow us to generate the necessary authentication for our Space and the Serverless Inference API. Be sure that the HF token used to authenticate has the correct permissions for the Organization where your Space is located.",Re,X,He,Q,Bt='Now, we can <a href="https://docs.arize.com/phoenix/deployment/configuration#client-configuration" rel="nofollow">configure the Phoenix client</a> to our running Phoenix dashboard:',Ee,V,kt="<li>Register the Phoenix tracer provider by<ul><li>Specifying the <code>project_name</code> of our choice</li> <li>Setting the <code>endpoint</code> value to the Hostname of our Space (found via the dashboard UI under the “Settings” tab - see below)</li> <li>Setting the <code>headers</code> to the Hugging Face headers needed to access the Space</li></ul></li> <li>Instrument our application code to use the OpenAI tracer provider</li>",Xe,Y,Zt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/settings.png"/>',Qe,z,Ve,F,Ct=`🔭 OpenTelemetry Tracing Details 🔭
|  Phoenix Project: test
|  Span Processor: SimpleSpanProcessor
|  Collector Endpoint: https://andrewrreed-phoenix-arize-observability-demo.hf.space/v1/traces
|  Transport: HTTP
|  Transport Headers: &#123;'user-agent': '****', 'authorization': '****'}
|  
|  Using a default SpanProcessor. \`add_span_processor\` will overwrite this default.
|  
|  \`register\` has set this TracerProvider as the global OpenTelemetry default.
|  To disable this behavior, call \`register\` with \`set_global_tracer_provider=False\`.
`,Ye,_,ze,$,xt="Now, we can make a call to an LLM and view the traces in the Phoenix dashboard. We’re using the OpenAI client to make calls to the Hugging Face Serverless Inference API, which is instrumented to work with Phoenix. In this case, we’re using the <code>meta-llama/Llama-3.1-8B-Instruct</code> model.",Fe,N,_e,A,Wt=`Llamas are intelligent and social animals, and they do have ways to entertain themselves and have fun. While we can't directly ask a llama about its personal preferences, we can observe their natural behaviors and make some educated guesses. Here are some things that might bring a llama joy and excitement:

1. **Socializing**: Llamas are herd animals and they love to interact with each other. They'll often engage in play-fighting, neck-wrestling, and other activities to establish dominance and strengthen social bonds. When llamas have a strong social network, it can make them feel happy and content.
2. **Exploring new environments**: Llamas are naturally curious creatures, and they love to explore new surroundings. They'll often investigate their surroundings, sniffing and investigating new sights, sounds, and smells.
3. **Playing with toys**: While llamas don't need expensive toys, they do enjoy playing with objects that stimulate their natural behaviors. For example, a ball or a toy that mimics a target can be an entertaining way to engage them.
4. **Climbing and jumping**: Llamas are agile and athletic animals, and they enjoy using their limbs to climb and jump over obstacles. Providing a safe and stable area for them to exercise their physical abilities can be a fun and engaging experience.
5. **Browsing and foraging**: Llamas have a natural instinct to graze and browse, and they enjoy searching for tasty plants and shrubs. Providing a variety of plants to munch on can keep them engaged and entertained.
6. **Mentally stimulating activities**: Llamas are intelligent animals, and they can benefit from mentally stimulating activities like problem-solving puzzles or learning new behaviors (like agility training or obedience training).

Some fun activities you can try with a llama include:

* Setting up an obstacle course or agility challenge
* Creating a "scavenger hunt" with treats and toys
* Introducing new toys or objects to stimulate their curiosity
* Providing a variety of plants and shrubs to browse and graze on
* Engaging in interactive games like "follow the leader" or "find the treat"

Remember to always prioritize the llama's safety and well-being, and to consult with a veterinarian or a trained llama handler before attempting any new activities or introducing new toys.
`,$e,q,Lt="If we navigate back to the Phoenix dashboard, we can see the trace from our LLM call is captured and displayed! If you configured your space with a persistent disk, all of the trace information will be saved anytime you restart the space.",Ne,P,St='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/test-trace.png"/>',Ae,D,qe,O,Gt='The real power of observability comes from being able to trace and inspect complex LLM workflows. In this example, we’ll install and use <a href="https://www.crewai.com/" rel="nofollow">CrewAI</a> to trace a multi-agent application.',Pe,w,Rt="<p>The <code>openinference-instrumentation-crewai</code> package currently requires Python 3.10 or higher. After installing the <code>crewai</code> library, you may need to restart the notebook kernel to avoid errors.</p>",De,K,Oe,ee,Ht="Like before, we’ll register the Phoenix tracer provider and instrument the application code, but this time we’ll also uninstrument the existing OpenAI tracer provider to avoid conflicts.",Ke,te,et,ae,Et=`🔭 OpenTelemetry Tracing Details 🔭
|  Phoenix Project: crewai
|  Span Processor: SimpleSpanProcessor
|  Collector Endpoint: https://andrewrreed-phoenix-arize-observability-demo.hf.space/v1/traces
|  Transport: HTTP
|  Transport Headers: &#123;'user-agent': '****', 'authorization': '****'}
|  
|  Using a default SpanProcessor. \`add_span_processor\` will overwrite this default.
|  
|  \`register\` has set this TracerProvider as the global OpenTelemetry default.
|  To disable this behavior, call \`register\` with \`set_global_tracer_provider=False\`.
`,tt,se,Xt="Now we’ll define a multi-agent application using CrewAI to research and write a blog post about the importance of observability and tracing in LLM applications.",at,j,Qt='<p>This example is borrowed and modified from <a href="https://docs.arize.com/phoenix/tracing/integrations-tracing/crewai" rel="nofollow">here</a>.</p>',st,le,lt,ne,Vt=`\x1B[1m\x1B[95m# Agent:\x1B[00m \x1B[1m\x1B[92mResearcher\x1B[00m
\x1B[95m## Task:\x1B[00m \x1B[92mConduct comprehensive research and analysis of the importance of observability and tracing in LLM applications.
  Identify key trends, breakthrough technologies, and potential industry impacts.\x1B[00m


\x1B[1m\x1B[95m# Agent:\x1B[00m \x1B[1m\x1B[92mResearcher\x1B[00m
\x1B[95m## Using tool:\x1B[00m \x1B[92mSearch the internet\x1B[00m
\x1B[95m## Tool Input:\x1B[00m \x1B[92m
"&#123;\\"search_query\\": \\"importance of observability and tracing in LLM applications\\"}"\x1B[00m
\x1B[95m## Tool Output:\x1B[00m \x1B[92m

Search results: Title: LLM Observability: The 5 Key Pillars for Monitoring Large Language ...
Link: https://arize.com/blog-course/large-language-model-monitoring-observability/
Snippet: Why leveraging the five pillars of LLM observability is essential for ensuring performance, reliability, and seamless LLM applications.
---
Title: Observability of LLM Applications: Exploration and Practice from the ...
Link: https://www.alibabacloud.com/blog/observability-of-llm-applications-exploration-and-practice-from-the-perspective-of-trace_601604
Snippet: This article clarifies the technical challenges of observability by analyzing LLM application patterns and different concerns.
---
Title: What is LLM Observability? - The Ultimate LLM Monitoring Guide
Link: https://www.confident-ai.com/blog/what-is-llm-observability-the-ultimate-llm-monitoring-guide
Snippet: Observability tools collect and correlate logs, real-time evaluation metrics, and traces to understand the context of unexpected outputs or ...
---
Title: An Introduction to Observability for LLM-based applications using ...
Link: https://opentelemetry.io/blog/2024/llm-observability/
Snippet: Why Observability Matters for LLM Applications · It's vital to keep track of how often LLMs are being used for usage and cost tracking. · Latency ...
---
Title: Understanding LLM Observability - Key Insights, Best Practices ...
Link: https://signoz.io/blog/llm-observability/
Snippet: LLM Observability is essential for maintaining reliable, accurate, and efficient AI applications. Focus on the five pillars: evaluation, tracing ...
---
Title: LLM Observability Tools: 2024 Comparison - lakeFS
Link: https://lakefs.io/blog/llm-observability-tools/
Snippet: LLM observability is the process that enables monitoring by providing full visibility and tracing in an LLM application system, as well as newer ...
---
Title: From Concept to Production with Observability in LLM Applications
Link: https://hadijaveed.me/2024/03/05/tracing-and-observability-in-llm-applications/
Snippet: Traces are essential to understanding the full “path” a request takes in your application, e.g, prompt, query-expansion, RAG retrieved top-k ...
---
Title: The Importance of LLM Observability: A Technical Deep Dive
Link: https://www.linkedin.com/pulse/importance-llm-observability-technical-deep-dive-patrick-carroll-trlqe
Snippet: LLM observability is crucial for any technical team that wants to maintain and improve the reliability, security, and performance of their AI- ...
---
Title: Observability and Monitoring of LLMs - TheBlue.ai
Link: https://theblue.ai/blog/llm-observability-en/
Snippet: LLM-Observability is crucial to maximize the performance and reliability of Large Language Models (LLMs). By systematically capturing and ...
---
\x1B[00m
`,nt,ie,Yt="After navigating back to the Phoenix dashboard, we can see the traces from our multi-agent application in the new project “crewai”!",it,oe,zt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/crew-ai-trace.png"/>',ot,re,rt,me,pt;return f=new Kt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/phoenix_observability_on_hf_spaces.ipynb"}]}}),U=new Ot({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new ye({props:{title:"Setup a Phoenix observability dashboard on Hugging Face Spaces for LLM application tracing",local:"setup-a-phoenix-observability-dashboard-on-hugging-face-spaces-for-llm-application-tracing",headingTag:"h1"}}),B=new ye({props:{title:"Step 1: Deploy Phoenix on Hugging Face Spaces",local:"step-1-deploy-phoenix-on-hugging-face-spaces",headingTag:"h2"}}),S=new ye({props:{title:"Step 2: Configure application tracing",local:"step-2-configure-application-tracing",headingTag:"h2"}}),H=new pe({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFyaXplLXBob2VuaXglMjBhcml6ZS1waG9lbml4LW90ZWwlMjBvcGVuaW5mZXJlbmNlLWluc3RydW1lbnRhdGlvbi1vcGVuYWklMjBvcGVuYWklMjBodWdnaW5nZmFjZS1odWI=",highlighted:"!pip install -q arize-phoenix arize-phoenix-otel openinference-instrumentation-openai openai huggingface-hub",wrap:!1}}),X=new pe({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),z=new pe({props:{code:"ZnJvbSUyMHBob2VuaXgub3RlbCUyMGltcG9ydCUyMHJlZ2lzdGVyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi51dGlscyUyMGltcG9ydCUyMGJ1aWxkX2hmX2hlYWRlcnMlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24ub3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJSW5zdHJ1bWVudG9yJTBBJTBBJTIzJTIwMS4lMjBSZWdpc3RlciUyMHRoZSUyMFBob2VuaXglMjB0cmFjZXIlMjBwcm92aWRlciUwQXRyYWNlcl9wcm92aWRlciUyMCUzRCUyMHJlZ2lzdGVyKCUwQSUyMCUyMCUyMCUyMHByb2plY3RfbmFtZSUzRCUyMnRlc3QlMjIlMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludCUzRCUyMmh0dHBzJTNBJTJGJTJGYW5kcmV3cnJlZWQtcGhvZW5peC1hcml6ZS1vYnNlcnZhYmlsaXR5LWRlbW8uaGYuc3BhY2UlMjIlMEElMjAlMjAlMjAlMjAlMkIlMjAlMjIlMkZ2MSUyRnRyYWNlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0RidWlsZF9oZl9oZWFkZXJzKCklMkMlMEEpJTBBJTBBJTIzJTIwMi4lMjBJbnN0cnVtZW50JTIwb3VyJTIwYXBwbGljYXRpb24lMjBjb2RlJTIwdG8lMjB1c2UlMjB0aGUlMjBPcGVuQUklMjB0cmFjZXIlMjBwcm92aWRlciUwQU9wZW5BSUluc3RydW1lbnRvcigpLmluc3RydW1lbnQodHJhY2VyX3Byb3ZpZGVyJTNEdHJhY2VyX3Byb3ZpZGVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> phoenix.otel <span class="hljs-keyword">import</span> register
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> build_hf_headers
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openinference.instrumentation.openai <span class="hljs-keyword">import</span> OpenAIInstrumentor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 1. Register the Phoenix tracer provider</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tracer_provider = register(
<span class="hljs-meta">... </span>    project_name=<span class="hljs-string">&quot;test&quot;</span>,
<span class="hljs-meta">... </span>    endpoint=<span class="hljs-string">&quot;https://andrewrreed-phoenix-arize-observability-demo.hf.space&quot;</span>
<span class="hljs-meta">... </span>    + <span class="hljs-string">&quot;/v1/traces&quot;</span>,
<span class="hljs-meta">... </span>    headers=build_hf_headers(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 2. Instrument our application code to use the OpenAI tracer provider</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>OpenAIInstrumentor().instrument(tracer_provider=tracer_provider)`,wrap:!1}}),_=new ye({props:{title:"Step 3: Make calls and view traces in the Phoenix dashboard",local:"step-3-make-calls-and-view-traces-in-the-phoenix-dashboard",headingTag:"h2"}}),N=new pe({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfdG9rZW4lMEElMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmFwaS1pbmZlcmVuY2UuaHVnZ2luZ2ZhY2UuY28lMkZ2MSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RnZXRfdG9rZW4oKSUyQyUwQSklMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBkb2VzJTIwYSUyMGxsYW1hJTIwZG8lMjBmb3IlMjBmdW4lM0YlMjIlN0QlNUQlMEElMEFyZXNwb25zZSUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRG1lc3NhZ2VzJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMCUyQyUwQSklMEElMEFwcmludChyZXNwb25zZS5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

<span class="hljs-meta">&gt;&gt;&gt; </span>client = OpenAI(
<span class="hljs-meta">... </span>    base_url=<span class="hljs-string">&quot;https://api-inference.huggingface.co/v1/&quot;</span>,
<span class="hljs-meta">... </span>    api_key=get_token(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What does a llama do for fun?&quot;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat.completions.create(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),D=new ye({props:{title:"Bonus: Tracing a multi-agent application with CrewAI",local:"bonus-tracing-a-multi-agent-application-with-crewai",headingTag:"h2"}}),K=new pe({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLWNyZXdhaSUyMGNyZXdhaSUyMGNyZXdhaS10b29scw==",highlighted:"!pip install -q openinference-instrumentation-crewai crewai crewai-tools",wrap:!1}}),te=new pe({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnklMjBpbXBvcnQlMjB0cmFjZSUwQWZyb20lMjBvcGVuaW5mZXJlbmNlLmluc3RydW1lbnRhdGlvbi5jcmV3YWklMjBpbXBvcnQlMjBDcmV3QUlJbnN0cnVtZW50b3IlMEElMEElMjMlMjAwLiUyMFVuaW5zdHJ1bWVudCUyMGV4aXN0aW5nJTIwdHJhY2VyJTIwcHJvdmlkZXIlMjBhbmQlMjBjbGVhciUyMHRoZSUyMGdsb2JhbCUyMHRyYWNlciUyMHByb3ZpZGVyJTBBT3BlbkFJSW5zdHJ1bWVudG9yKCkudW5pbnN0cnVtZW50KCklMEFpZiUyMHRyYWNlLmdldF90cmFjZXJfcHJvdmlkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYWNlLmdldF90cmFjZXJfcHJvdmlkZXIoKS5zaHV0ZG93bigpJTBBJTIwJTIwJTIwJTIwdHJhY2UuX1RSQUNFUl9QUk9WSURFUiUyMCUzRCUyME5vbmUlMjAlMjAlMjMlMjBSZXNldCUyMHRoZSUyMGdsb2JhbCUyMHRyYWNlciUyMHByb3ZpZGVyJTBBJTBBJTIzJTIwMS4lMjBSZWdpc3RlciUyMHRoZSUyMFBob2VuaXglMjB0cmFjZXIlMjBwcm92aWRlciUwQXRyYWNlcl9wcm92aWRlciUyMCUzRCUyMHJlZ2lzdGVyKCUwQSUyMCUyMCUyMCUyMHByb2plY3RfbmFtZSUzRCUyMmNyZXdhaSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZhbmRyZXdycmVlZC1waG9lbml4LWFyaXplLW9ic2VydmFiaWxpdHktZGVtby5oZi5zcGFjZSUyMiUwQSUyMCUyMCUyMCUyMCUyQiUyMCUyMiUyRnYxJTJGdHJhY2VzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaGVhZGVycyUzRGJ1aWxkX2hmX2hlYWRlcnMoKSUyQyUwQSklMEElMEElMjMlMjAyLiUyMEluc3RydW1lbnQlMjBvdXIlMjBhcHBsaWNhdGlvbiUyMGNvZGUlMjB0byUyMHVzZSUyMHRoZSUyME9wZW5BSSUyMHRyYWNlciUyMHByb3ZpZGVyJTBBQ3Jld0FJSW5zdHJ1bWVudG9yKCkuaW5zdHJ1bWVudCh0cmFjZXJfcHJvdmlkZXIlM0R0cmFjZXJfcHJvdmlkZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openinference.instrumentation.crewai <span class="hljs-keyword">import</span> CrewAIInstrumentor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 0. Uninstrument existing tracer provider and clear the global tracer provider</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>OpenAIInstrumentor().uninstrument()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> trace.get_tracer_provider():
<span class="hljs-meta">... </span>    trace.get_tracer_provider().shutdown()
<span class="hljs-meta">... </span>    trace._TRACER_PROVIDER = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Reset the global tracer provider</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 1. Register the Phoenix tracer provider</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tracer_provider = register(
<span class="hljs-meta">... </span>    project_name=<span class="hljs-string">&quot;crewai&quot;</span>,
<span class="hljs-meta">... </span>    endpoint=<span class="hljs-string">&quot;https://andrewrreed-phoenix-arize-observability-demo.hf.space&quot;</span>
<span class="hljs-meta">... </span>    + <span class="hljs-string">&quot;/v1/traces&quot;</span>,
<span class="hljs-meta">... </span>    headers=build_hf_headers(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 2. Instrument our application code to use the OpenAI tracer provider</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>CrewAIInstrumentor().instrument(tracer_provider=tracer_provider)`,wrap:!1}}),le=new pe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> crewai_tools <span class="hljs-keyword">import</span> SerperDevTool
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> crewai <span class="hljs-keyword">import</span> LLM, Agent, Task, Crew, Process

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define our LLM using HF&#x27;s Serverless Inference API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>llm = LLM(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;huggingface/meta-llama/Llama-3.1-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    api_key=get_token(),
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define a tool for searching the web</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>os.environ[<span class="hljs-string">&quot;SERPER_API_KEY&quot;</span>] = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;YOUR_SERPER_API_KEY&quot;</span>  <span class="hljs-comment"># must set this value in your environment</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>search_tool = SerperDevTool()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define your agents with roles and goals</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>researcher = Agent(
<span class="hljs-meta">... </span>    role=<span class="hljs-string">&quot;Researcher&quot;</span>,
<span class="hljs-meta">... </span>    goal=<span class="hljs-string">&quot;Conduct thorough research on up to date trends around a given topic.&quot;</span>,
<span class="hljs-meta">... </span>    backstory=<span class="hljs-string">&quot;&quot;&quot;You work at a leading tech think tank. You have a knack for dissecting complex data and presenting actionable insights.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_delegation=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tools=[search_tool],
<span class="hljs-meta">... </span>    llm=llm,
<span class="hljs-meta">... </span>    max_iter=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">... </span>writer = Agent(
<span class="hljs-meta">... </span>    role=<span class="hljs-string">&quot;Technical Writer&quot;</span>,
<span class="hljs-meta">... </span>    goal=<span class="hljs-string">&quot;Craft compelling content on a given topic.&quot;</span>,
<span class="hljs-meta">... </span>    backstory=<span class="hljs-string">&quot;&quot;&quot;You are a technical writer with a knack for crafting engaging and informative content.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    llm=llm,
<span class="hljs-meta">... </span>    verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    allow_delegation=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    max_iter=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create tasks for your agents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task1 = Task(
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;&quot;&quot;Conduct comprehensive research and analysis of the importance of observability and tracing in LLM applications.
<span class="hljs-meta">... </span>  Identify key trends, breakthrough technologies, and potential industry impacts.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    expected_output=<span class="hljs-string">&quot;Full analysis report in bullet points&quot;</span>,
<span class="hljs-meta">... </span>    agent=researcher,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>task2 = Task(
<span class="hljs-meta">... </span>    description=<span class="hljs-string">&quot;&quot;&quot;Using the insights provided, develop an engaging blog
<span class="hljs-meta">... </span>  post that highlights the importance of observability and tracing in LLM applications.
<span class="hljs-meta">... </span>  Your post should be informative yet accessible, catering to a tech-savvy audience.
<span class="hljs-meta">... </span>  Make it sound cool, avoid complex words so it doesn&#x27;t sound like AI.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    expected_output=<span class="hljs-string">&quot;Blog post of at least 3 paragraphs&quot;</span>,
<span class="hljs-meta">... </span>    agent=writer,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instantiate your crew with a sequential process</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>crew = Crew(
<span class="hljs-meta">... </span>    agents=[researcher, writer],
<span class="hljs-meta">... </span>    tasks=[task1, task2],
<span class="hljs-meta">... </span>    verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    process=Process.sequential,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get your crew to work!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = crew.kickoff()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;------------ FINAL RESULT ------------&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)`,wrap:!1}}),re=new ea({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/phoenix_observability_on_hf_spaces.md"}}),{c(){u=i("meta"),Me=l(),he=i("p"),ge=l(),p(f.$$.fragment),ue=l(),p(U.$$.fragment),de=l(),p(T.$$.fragment),be=l(),J=i("p"),J.innerHTML=mt,we=l(),v=i("p"),v.innerHTML=yt,je=l(),g=i("div"),g.innerHTML=Mt,fe=l(),I=i("p"),I.innerHTML=gt,Ue=l(),p(B.$$.fragment),Te=l(),k=i("p"),k.innerHTML=ut,Je=l(),Z=i("p"),Z.innerHTML=dt,ve=l(),C=i("p"),C.innerHTML=bt,Ie=l(),x=i("p"),x.textContent=wt,Be=l(),d=i("blockquote"),d.innerHTML=jt,ke=l(),W=i("p"),W.textContent=ft,Ze=l(),L=i("p"),L.innerHTML=Ut,Ce=l(),p(S.$$.fragment),xe=l(),G=i("p"),G.innerHTML=Tt,We=l(),b=i("blockquote"),b.innerHTML=Jt,Le=l(),R=i("p"),R.textContent=vt,Se=l(),p(H.$$.fragment),Ge=l(),E=i("p"),E.innerHTML=It,Re=l(),p(X.$$.fragment),He=l(),Q=i("p"),Q.innerHTML=Bt,Ee=l(),V=i("ol"),V.innerHTML=kt,Xe=l(),Y=i("p"),Y.innerHTML=Zt,Qe=l(),p(z.$$.fragment),Ve=l(),F=i("pre"),F.textContent=Ct,Ye=l(),p(_.$$.fragment),ze=l(),$=i("p"),$.innerHTML=xt,Fe=l(),p(N.$$.fragment),_e=l(),A=i("pre"),A.textContent=Wt,$e=l(),q=i("p"),q.textContent=Lt,Ne=l(),P=i("p"),P.innerHTML=St,Ae=l(),p(D.$$.fragment),qe=l(),O=i("p"),O.innerHTML=Gt,Pe=l(),w=i("blockquote"),w.innerHTML=Rt,De=l(),p(K.$$.fragment),Oe=l(),ee=i("p"),ee.textContent=Ht,Ke=l(),p(te.$$.fragment),et=l(),ae=i("pre"),ae.textContent=Et,tt=l(),se=i("p"),se.textContent=Xt,at=l(),j=i("blockquote"),j.innerHTML=Qt,st=l(),p(le.$$.fragment),lt=l(),ne=i("pre"),ne.textContent=Vt,nt=l(),ie=i("p"),ie.textContent=Yt,it=l(),oe=i("p"),oe.innerHTML=zt,ot=l(),p(re.$$.fragment),rt=l(),me=i("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),Me=n(e),he=o(e,"P",{}),Ft(he).forEach(a),ge=n(e),c(f.$$.fragment,e),ue=n(e),c(U.$$.fragment,e),de=n(e),c(T.$$.fragment,e),be=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-15bmh6z"&&(J.innerHTML=mt),we=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1k297h5"&&(v.innerHTML=yt),je=n(e),g=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(g)!=="svelte-12j44f9"&&(g.innerHTML=Mt),fe=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1xbiwg7"&&(I.innerHTML=gt),Ue=n(e),c(B.$$.fragment,e),Te=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-cuq7fx"&&(k.innerHTML=ut),Je=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-isgc6x"&&(Z.innerHTML=dt),ve=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-10elq7v"&&(C.innerHTML=bt),Ie=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1rh3ww3"&&(x.textContent=wt),Be=n(e),d=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-18ud0t0"&&(d.innerHTML=jt),ke=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vpmvm9"&&(W.textContent=ft),Ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1omzjh4"&&(L.innerHTML=Ut),Ce=n(e),c(S.$$.fragment,e),xe=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1nmeice"&&(G.innerHTML=Tt),We=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1l81aqp"&&(b.innerHTML=Jt),Le=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-8bs8op"&&(R.textContent=vt),Se=n(e),c(H.$$.fragment,e),Ge=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ko361g"&&(E.innerHTML=It),Re=n(e),c(X.$$.fragment,e),He=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1hdapmj"&&(Q.innerHTML=Bt),Ee=n(e),V=o(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-4qosl7"&&(V.innerHTML=kt),Xe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1adj09n"&&(Y.innerHTML=Zt),Qe=n(e),c(z.$$.fragment,e),Ve=n(e),F=o(e,"PRE",{"data-svelte-h":!0}),r(F)!=="svelte-bamujo"&&(F.textContent=Ct),Ye=n(e),c(_.$$.fragment,e),ze=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-a0s0yj"&&($.innerHTML=xt),Fe=n(e),c(N.$$.fragment,e),_e=n(e),A=o(e,"PRE",{"data-svelte-h":!0}),r(A)!=="svelte-1ykvnx2"&&(A.textContent=Wt),$e=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-11qu0yf"&&(q.textContent=Lt),Ne=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-19mnv1a"&&(P.innerHTML=St),Ae=n(e),c(D.$$.fragment,e),qe=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1589ztu"&&(O.innerHTML=Gt),Pe=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1nqam52"&&(w.innerHTML=Rt),De=n(e),c(K.$$.fragment,e),Oe=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-hyw94f"&&(ee.textContent=Ht),Ke=n(e),c(te.$$.fragment,e),et=n(e),ae=o(e,"PRE",{"data-svelte-h":!0}),r(ae)!=="svelte-k9ui0t"&&(ae.textContent=Et),tt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-105vb7m"&&(se.textContent=Xt),at=n(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-bv6976"&&(j.innerHTML=Qt),st=n(e),c(le.$$.fragment,e),lt=n(e),ne=o(e,"PRE",{"data-svelte-h":!0}),r(ne)!=="svelte-1953h3t"&&(ne.textContent=Vt),nt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-vaf3bj"&&(ie.textContent=Yt),it=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1qqdzdu"&&(oe.innerHTML=zt),ot=n(e),c(re.$$.fragment,e),rt=n(e),me=o(e,"P",{}),Ft(me).forEach(a),this.h()},h(){ce(u,"name","hf:doc:metadata"),ce(u,"content",aa),ct(g,"display","flex"),ct(g,"justify-content","space-between"),ct(g,"gap","20px"),ct(g,"margin","20px 0"),ce(d,"class","tip"),ce(b,"class","tip"),ce(w,"class","tip"),ce(j,"class","tip")},m(e,t){Dt(document.head,u),s(e,Me,t),s(e,he,t),s(e,ge,t),h(f,e,t),s(e,ue,t),h(U,e,t),s(e,de,t),h(T,e,t),s(e,be,t),s(e,J,t),s(e,we,t),s(e,v,t),s(e,je,t),s(e,g,t),s(e,fe,t),s(e,I,t),s(e,Ue,t),h(B,e,t),s(e,Te,t),s(e,k,t),s(e,Je,t),s(e,Z,t),s(e,ve,t),s(e,C,t),s(e,Ie,t),s(e,x,t),s(e,Be,t),s(e,d,t),s(e,ke,t),s(e,W,t),s(e,Ze,t),s(e,L,t),s(e,Ce,t),h(S,e,t),s(e,xe,t),s(e,G,t),s(e,We,t),s(e,b,t),s(e,Le,t),s(e,R,t),s(e,Se,t),h(H,e,t),s(e,Ge,t),s(e,E,t),s(e,Re,t),h(X,e,t),s(e,He,t),s(e,Q,t),s(e,Ee,t),s(e,V,t),s(e,Xe,t),s(e,Y,t),s(e,Qe,t),h(z,e,t),s(e,Ve,t),s(e,F,t),s(e,Ye,t),h(_,e,t),s(e,ze,t),s(e,$,t),s(e,Fe,t),h(N,e,t),s(e,_e,t),s(e,A,t),s(e,$e,t),s(e,q,t),s(e,Ne,t),s(e,P,t),s(e,Ae,t),h(D,e,t),s(e,qe,t),s(e,O,t),s(e,Pe,t),s(e,w,t),s(e,De,t),h(K,e,t),s(e,Oe,t),s(e,ee,t),s(e,Ke,t),h(te,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,se,t),s(e,at,t),s(e,j,t),s(e,st,t),h(le,e,t),s(e,lt,t),s(e,ne,t),s(e,nt,t),s(e,ie,t),s(e,it,t),s(e,oe,t),s(e,ot,t),h(re,e,t),s(e,rt,t),s(e,me,t),pt=!0},p:$t,i(e){pt||(m(f.$$.fragment,e),m(U.$$.fragment,e),m(T.$$.fragment,e),m(B.$$.fragment,e),m(S.$$.fragment,e),m(H.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(_.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(re.$$.fragment,e),pt=!0)},o(e){y(f.$$.fragment,e),y(U.$$.fragment,e),y(T.$$.fragment,e),y(B.$$.fragment,e),y(S.$$.fragment,e),y(H.$$.fragment,e),y(X.$$.fragment,e),y(z.$$.fragment,e),y(_.$$.fragment,e),y(N.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(re.$$.fragment,e),pt=!1},d(e){e&&(a(Me),a(he),a(ge),a(ue),a(de),a(be),a(J),a(we),a(v),a(je),a(g),a(fe),a(I),a(Ue),a(Te),a(k),a(Je),a(Z),a(ve),a(C),a(Ie),a(x),a(Be),a(d),a(ke),a(W),a(Ze),a(L),a(Ce),a(xe),a(G),a(We),a(b),a(Le),a(R),a(Se),a(Ge),a(E),a(Re),a(He),a(Q),a(Ee),a(V),a(Xe),a(Y),a(Qe),a(Ve),a(F),a(Ye),a(ze),a($),a(Fe),a(_e),a(A),a($e),a(q),a(Ne),a(P),a(Ae),a(qe),a(O),a(Pe),a(w),a(De),a(Oe),a(ee),a(Ke),a(et),a(ae),a(tt),a(se),a(at),a(j),a(st),a(lt),a(ne),a(nt),a(ie),a(it),a(oe),a(ot),a(rt),a(me)),a(u),M(f,e),M(U,e),M(T,e),M(B,e),M(S,e),M(H,e),M(X,e),M(z,e),M(_,e),M(N,e),M(D,e),M(K,e),M(te,e),M(le,e),M(re,e)}}}const aa='{"title":"Setup a Phoenix observability dashboard on Hugging Face Spaces for LLM application tracing","local":"setup-a-phoenix-observability-dashboard-on-hugging-face-spaces-for-llm-application-tracing","sections":[{"title":"Step 1: Deploy Phoenix on Hugging Face Spaces","local":"step-1-deploy-phoenix-on-hugging-face-spaces","sections":[],"depth":2},{"title":"Step 2: Configure application tracing","local":"step-2-configure-application-tracing","sections":[],"depth":2},{"title":"Step 3: Make calls and view traces in the Phoenix dashboard","local":"step-3-make-calls-and-view-traces-in-the-phoenix-dashboard","sections":[],"depth":2},{"title":"Bonus: Tracing a multi-agent application with CrewAI","local":"bonus-tracing-a-multi-agent-application-with-crewai","sections":[],"depth":2}],"depth":1}';function sa(ht){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pa extends At{constructor(u){super(),qt(this,u,sa,ta,_t,{})}}export{pa as component};
