import{s as hl,n as ul,o as fl}from"../chunks/scheduler.1f027d5a.js";import{S as Ml,i as bl,e as c,s as n,c as i,h as gl,a as h,d as l,b as a,f as dl,g as o,j as u,k as cl,l as wl,m as s,n as p,t as r,o as m,p as d}from"../chunks/index.5cb6ce42.js";import{C as yl}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as jl,C as f}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as M,E as Jl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function $l(Vt){let b,Ie,Ue,Ce,g,Ge,w,ke,y,Ze,j,Nt='<em>Authored by: <a href="https://github.com/zc277584121" rel="nofollow">Chen Zhang</a></em>',xe,J,At='<a href="https://milvus.io/" rel="nofollow">Milvus</a> is a popular open-source vector database that powers AI applications with highly performant and scalable vector similarity search. In this tutorial, we will show you how to build a RAG (Retrieval-Augmented Generation) pipeline with Hugging Face and Milvus.',We,$,Et="The RAG system combines a retrieval system with an LLM. The system first retrieves relevant documents from a corpus using Milvus vector database, then uses an LLM hosted in Hugging Face to generate answers based on the retrieved documents.",_e,T,Re,U,Be,v,Ve,I,qt="<p>If you are using Google Colab, to enable the dependencies, you may need to <strong>restart the runtime</strong> (click on the “Runtime” menu at the top of the screen, and select “Restart session” from the dropdown menu).</p>",Ne,C,Ht='In addition, we recommend that you configure your <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">Hugging Face User Access Token</a>, and set it in your environment variables because we will use a LLM from the Hugging Face Hub. You may get a low limit of requests if you don’t set the token environment variable.',Ae,G,Ee,k,qe,Z,Xt='We use the <a href="https://artificialintelligenceact.eu/wp-content/uploads/2021/08/The-AI-Act.pdf" rel="nofollow">AI Act PDF</a>, a regulatory framework for AI with different risk levels corresponding to more or less regulation, as the private knowledge in our RAG.',He,x,Xe,W,zt='We use the <a href="https://python.langchain.com/v0.1/docs/modules/data_connection/document_loaders/pdf/" rel="nofollow"><code>PyPDFLoader</code></a> from LangChain to extract the text from the PDF, and then split the text into smaller chunks. By default, we set the chunk size as 1000 and the overlap as 200, which means each chunk will nearly have 1000 characters and the overlap between two chunks will be 200 characters.',ze,_,Qe,R,Qt=`108
`,Fe,B,Ye,V,Le,N,Se,A,Ft='Define a function to generate text embeddings. We use <a href="https://huggingface.co/BAAI/bge-small-en-v1.5" rel="nofollow">BGE embedding model</a> as an example, but you can use any embedding models, such as those found on the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB leaderboard</a>.',Pe,E,De,q,Yt="Generate a test embedding and print its dimension and first few elements.",Ke,H,Oe,X,Lt=`384
[-0.07660683244466782, 0.025316666811704636, 0.012505513615906239, 0.004595153499394655, 0.025780051946640015, 0.03816710412502289, 0.08050819486379623, 0.003035430097952485, 0.02439221926033497, 0.0048803347162902355]
`,et,z,tt,Q,lt,F,st,Y,St='<p>As for the argument of <code>MilvusClient</code>:</p> <ul><li>Setting the <code>uri</code> as a local file, e.g.<code>./hf_milvus_demo.db</code>, is the most convenient method, as it automatically utilizes <a href="https://milvus.io/docs/milvus_lite.md" rel="nofollow">Milvus Lite</a> to store all data in this file.</li> <li>If you have a large amount of data, say more than a million vectors, you can set up a more performant Milvus server on <a href="https://milvus.io/docs/quickstart.md" rel="nofollow">Docker or Kubernetes</a>. In this setup, please use the server uri, e.g.<code>http://localhost:19530</code>, as your <code>uri</code>.</li> <li>If you want to use <a href="https://zilliz.com/cloud" rel="nofollow">Zilliz Cloud</a>, the fully managed cloud service for Milvus, adjust the <code>uri</code> and <code>token</code>, which correspond to the <a href="https://docs.zilliz.com/docs/on-zilliz-cloud-console#cluster-details" rel="nofollow">Public Endpoint and Api key</a> in Zilliz Cloud.</li></ul>',nt,L,Pt="Check if the collection already exists and drop it if it does.",at,S,it,P,Dt="Create a new collection with specified parameters.",ot,D,Kt="If we don’t specify any field information, Milvus will automatically create a default <code>id</code> field for primary key, and a <code>vector</code> field to store the vector data. A reserved JSON field is used to store non-schema-defined fields and their values.",pt,K,rt,O,mt,ee,Ot="Iterate through the text lines, create embeddings, and then insert the data into Milvus.",dt,te,el="Here is a new field <code>text</code>, which is a non-defined field in the collection schema. It will be automatically added to the reserved JSON dynamic field, which can be treated as a normal field at a high level.",ct,le,ht,se,ut,ne,ft,ae,tl="Let’s specify a question to ask about the corpus.",Mt,ie,bt,oe,ll="Search for the question in the collection and retrieve the top 3 semantic matches.",gt,pe,wt,re,sl="Let’s take a look at the search results of the query",yt,me,jt,de,nl=`[
    [
        "EN 6  EN 2. LEGAL  BASIS,  SUBSIDIARITY  AND  PROPORTIONALITY  \\n2.1. Legal  basis  \\nThe legal basis for the proposal is in the first place Article 114 of the Treaty on the \\nFunctioning of the European Union (TFEU), which provides for the adoption of measures to \\nensure the establishment and f unctioning of the internal market.  \\nThis proposal constitutes a core part of the EU digital single market strategy. The primary \\nobjective of this proposal is to ensure the proper functioning of the internal market by setting \\nharmonised rules in particular on the development, placing on the Union market and the use \\nof products and services making use of AI technologies or provided as stand -alone AI \\nsystems. Some Member States are already considering national rules to ensure that AI is safe \\nand is developed a nd used in compliance with fundamental rights obligations. This will likely \\nlead to two main problems: i) a fragmentation of the internal market on essential elements",
        0.7412998080253601
    ],
    [
        "applications and prevent market fragmentation.  \\nTo achieve those objectives, this proposal presents a balanced and proportionate horizontal \\nregulatory approach to AI that is limited to the minimum necessary requirements to address \\nthe risks and problems linked to AI, withou t unduly constraining or hindering technological \\ndevelopment or otherwise disproportionately increasing the cost of placing AI solutions on \\nthe market.  The proposal sets a robust and flexible legal framework. On the one hand, it is \\ncomprehensive and future -proof in its fundamental regulatory choices, including the \\nprinciple -based requirements that AI systems should comply with. On the other hand, it puts \\nin place a proportionate regulatory system centred on a well -defined risk -based regulatory \\napproach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such",
        0.696428656578064
    ],
    [
        "approach that  does not create unnecessary restrictions to trade, whereby legal intervention is \\ntailored to those concrete situations where there is a justified cause for concern or where such \\nconcern can reasonably be anticipated in the near future. At the same time, t he legal \\nframework includes flexible mechanisms that enable it to be dynamically adapted as the \\ntechnology evolves and new concerning situations emerge.  \\nThe proposal sets harmonised rules for the development, placement on the market and use of \\nAI systems i n the Union following a proportionate risk -based approach. It proposes a single \\nfuture -proof definition of AI. Certain particularly harmful AI practices are prohibited as \\ncontravening Union values, while specific restrictions and safeguards are proposed in  relation \\nto certain uses of remote biometric identification systems for the purpose of law enforcement. \\nThe proposal lays down a solid risk methodology to define \\u201chigh -risk\\u201d AI systems that pose",
        0.6891457438468933
    ]
]
`,Jt,ce,$t,he,al="Before composing the prompt for LLM, let’s first flatten the retrieved document list into a plain string.",Tt,ue,Ut,fe,il="Define prompts for the Language Model. This prompt is assembled with the retrieved documents from Milvus.",vt,Me,It,be,ol='We use the <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B-Instruct-v0.1</a> hosted on Hugging Face inference server to generate a response based on the prompt.',Ct,ge,Gt,we,pl="Finally, we can format the prompt and generate the answer.",kt,ye,Zt,je,xt,Je,rl=`The legal basis for the proposal is Article 114 of the Treaty on the Functioning of the European Union (TFEU), which provides for the adoption of measures to ensure the establishment and functioning of the internal market. The proposal aims to establish harmonized rules for the development, placing on the market, and use of AI systems in the Union following a proportionate risk-based approach.
`,Wt,$e,ml="Congratulations! You have built an RAG pipeline with Hugging Face and Milvus.",_t,Te,Rt,ve,Bt;return g=new jl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_hf_and_milvus.ipynb"}]}}),w=new yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new M({props:{title:"Build RAG with Hugging Face and Milvus",local:"build-rag-with-hugging-face-and-milvus",headingTag:"h1"}}),T=new M({props:{title:"Preparation",local:"preparation",headingTag:"h2"}}),U=new M({props:{title:"Dependencies and Environment",local:"dependencies-and-environment",headingTag:"h3"}}),v=new f({props:{code:"ISUyMHBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjBweW1pbHZ1cyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGh1Z2dpbmdmYWNlLWh1YiUyMGxhbmdjaGFpbl9jb21tdW5pdHklMjBsYW5nY2hhaW4tdGV4dC1zcGxpdHRlcnMlMjBweXBkZiUyMHRxZG0=",highlighted:"! pip install --upgrade pymilvus sentence-transformers huggingface-hub langchain_community langchain-text-splitters pypdf tqdm",wrap:!1}}),G=new f({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjAlMjJoZl8uLi4lMjI=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),k=new M({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h3"}}),x=new f({props:{code:"JTI1JTI1YmFzaCUwQSUwQWlmJTIwJTVCJTIwISUyMC1mJTIwJTIyVGhlLUFJLUFjdC5wZGYlMjIlMjAlNUQlM0IlMjB0aGVuJTBBJTIwJTIwJTIwJTIwd2dldCUyMC1xJTIwaHR0cHMlM0ElMkYlMkZhcnRpZmljaWFsaW50ZWxsaWdlbmNlYWN0LmV1JTJGd3AtY29udGVudCUyRnVwbG9hZHMlMkYyMDIxJTJGMDglMkZUaGUtQUktQWN0LnBkZiUwQWZp",highlighted:`%%bash

<span class="hljs-keyword">if</span> [ ! -f <span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span> ]; then
    wget -q https://artificialintelligenceact.eu/wp-content/uploads/<span class="hljs-number">2021</span>/08/The-AI-Act.pdf
fi`,wrap:!1}}),_=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkuZG9jdW1lbnRfbG9hZGVycyUyMGltcG9ydCUyMFB5UERGTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwUHlQREZMb2FkZXIoJTIyVGhlLUFJLUFjdC5wZGYlMjIpJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCklMEFwcmludChsZW4oZG9jcykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> PyPDFLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>loader = PyPDFLoader(<span class="hljs-string">&quot;The-AI-Act.pdf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs = loader.load()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(docs))`,wrap:!1}}),B=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl90ZXh0X3NwbGl0dGVycyUyMGltcG9ydCUyMFJlY3Vyc2l2ZUNoYXJhY3RlclRleHRTcGxpdHRlciUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDEwMDAlMkMlMjBjaHVua19vdmVybGFwJTNEMjAwKSUwQWNodW5rcyUyMCUzRCUyMHRleHRfc3BsaXR0ZXIuc3BsaXRfZG9jdW1lbnRzKGRvY3Mp",highlighted:`<span class="hljs-keyword">from</span> langchain_text_splitters <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">1000</span>, chunk_overlap=<span class="hljs-number">200</span>)
chunks = text_splitter.split_documents(docs)`,wrap:!1}}),V=new f({props:{code:"dGV4dF9saW5lcyUyMCUzRCUyMCU1QmNodW5rLnBhZ2VfY29udGVudCUyMGZvciUyMGNodW5rJTIwaW4lMjBjaHVua3MlNUQ=",highlighted:'text_lines = [chunk.page_content <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> chunks]',wrap:!1}}),N=new M({props:{title:"Prepare the Embedding Model",local:"prepare-the-embedding-model",headingTag:"h3"}}),E=new f({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEElMEFkZWYlMjBlbWJfdGV4dCh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZ19tb2RlbC5lbmNvZGUoJTVCdGV4dCU1RCUyQyUyMG5vcm1hbGl6ZV9lbWJlZGRpbmdzJTNEVHJ1ZSkudG9saXN0KCklNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

embedding_model = SentenceTransformer(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">emb_text</span>(<span class="hljs-params">text</span>):
    <span class="hljs-keyword">return</span> embedding_model.encode([text], normalize_embeddings=<span class="hljs-literal">True</span>).tolist()[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new f({props:{code:"dGVzdF9lbWJlZGRpbmclMjAlM0QlMjBlbWJfdGV4dCglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiklMEFlbWJlZGRpbmdfZGltJTIwJTNEJTIwbGVuKHRlc3RfZW1iZWRkaW5nKSUwQXByaW50KGVtYmVkZGluZ19kaW0pJTBBcHJpbnQodGVzdF9lbWJlZGRpbmclNUIlM0ExMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>test_embedding = emb_text(<span class="hljs-string">&quot;This is a test&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_dim = <span class="hljs-built_in">len</span>(test_embedding)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(embedding_dim)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(test_embedding[:<span class="hljs-number">10</span>])`,wrap:!1}}),z=new M({props:{title:"Load data into Milvus",local:"load-data-into-milvus",headingTag:"h2"}}),Q=new M({props:{title:"Create the Collection",local:"create-the-collection",headingTag:"h3"}}),F=new f({props:{code:"ZnJvbSUyMHB5bWlsdnVzJTIwaW1wb3J0JTIwTWlsdnVzQ2xpZW50JTBBJTBBbWlsdnVzX2NsaWVudCUyMCUzRCUyME1pbHZ1c0NsaWVudCh1cmklM0QlMjIuJTJGaGZfbWlsdnVzX2RlbW8uZGIlMjIpJTBBJTBBY29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIycmFnX2NvbGxlY3Rpb24lMjI=",highlighted:`<span class="hljs-keyword">from</span> pymilvus <span class="hljs-keyword">import</span> MilvusClient

milvus_client = MilvusClient(uri=<span class="hljs-string">&quot;./hf_milvus_demo.db&quot;</span>)

collection_name = <span class="hljs-string">&quot;rag_collection&quot;</span>`,wrap:!1}}),S=new f({props:{code:"aWYlMjBtaWx2dXNfY2xpZW50Lmhhc19jb2xsZWN0aW9uKGNvbGxlY3Rpb25fbmFtZSklM0ElMEElMjAlMjAlMjAlMjBtaWx2dXNfY2xpZW50LmRyb3BfY29sbGVjdGlvbihjb2xsZWN0aW9uX25hbWUp",highlighted:`<span class="hljs-keyword">if</span> milvus_client.has_collection(collection_name):
    milvus_client.drop_collection(collection_name)`,wrap:!1}}),K=new f({props:{code:"bWlsdnVzX2NsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0Rjb2xsZWN0aW9uX25hbWUlMkMlMEElMjAlMjAlMjAlMjBkaW1lbnNpb24lM0RlbWJlZGRpbmdfZGltJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX3R5cGUlM0QlMjJJUCUyMiUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwY29uc2lzdGVuY3lfbGV2ZWwlM0QlMjJTdHJvbmclMjIlMkMlMjAlMjAlMjMlMjBTdHJvbmclMjBjb25zaXN0ZW5jeSUyMGxldmVsJTBBKQ==",highlighted:`milvus_client.create_collection(
    collection_name=collection_name,
    dimension=embedding_dim,
    metric_type=<span class="hljs-string">&quot;IP&quot;</span>,  <span class="hljs-comment"># Inner product distance</span>
    consistency_level=<span class="hljs-string">&quot;Strong&quot;</span>,  <span class="hljs-comment"># Strong consistency level</span>
)`,wrap:!1}}),O=new M({props:{title:"Insert data",local:"insert-data",headingTag:"h3"}}),le=new f({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBZGF0YSUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGklMkMlMjBsaW5lJTIwaW4lMjBlbnVtZXJhdGUodHFkbSh0ZXh0X2xpbmVzJTJDJTIwZGVzYyUzRCUyMkNyZWF0aW5nJTIwZW1iZWRkaW5ncyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YS5hcHBlbmQoJTdCJTIyaWQlMjIlM0ElMjBpJTJDJTIwJTIydmVjdG9yJTIyJTNBJTIwZW1iX3RleHQobGluZSklMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwbGluZSU3RCklMEElMEFpbnNlcnRfcmVzJTIwJTNEJTIwbWlsdnVzX2NsaWVudC5pbnNlcnQoY29sbGVjdGlvbl9uYW1lJTNEY29sbGVjdGlvbl9uYW1lJTJDJTIwZGF0YSUzRGRhdGEpJTBBaW5zZXJ0X3JlcyU1QiUyMmluc2VydF9jb3VudCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

data = []

<span class="hljs-keyword">for</span> i, line <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(text_lines, desc=<span class="hljs-string">&quot;Creating embeddings&quot;</span>)):
    data.append({<span class="hljs-string">&quot;id&quot;</span>: i, <span class="hljs-string">&quot;vector&quot;</span>: emb_text(line), <span class="hljs-string">&quot;text&quot;</span>: line})

insert_res = milvus_client.insert(collection_name=collection_name, data=data)
insert_res[<span class="hljs-string">&quot;insert_count&quot;</span>]`,wrap:!1}}),se=new M({props:{title:"Build RAG",local:"build-rag",headingTag:"h2"}}),ne=new M({props:{title:"Retrieve data for a query",local:"retrieve-data-for-a-query",headingTag:"h3"}}),ie=new f({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBsZWdhbCUyMGJhc2lzJTIwZm9yJTIwdGhlJTIwcHJvcG9zYWwlM0YlMjI=",highlighted:'question = <span class="hljs-string">&quot;What is the legal basis for the proposal?&quot;</span>',wrap:!1}}),pe=new f({props:{code:"c2VhcmNoX3JlcyUyMCUzRCUyMG1pbHZ1c19jbGllbnQuc2VhcmNoKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fbmFtZSUzRGNvbGxlY3Rpb25fbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbWJfdGV4dChxdWVzdGlvbiklMEElMjAlMjAlMjAlMjAlNUQlMkMlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjAlNjBlbWJfdGV4dCU2MCUyMGZ1bmN0aW9uJTIwdG8lMjBjb252ZXJ0JTIwdGhlJTIwcXVlc3Rpb24lMjB0byUyMGFuJTIwZW1iZWRkaW5nJTIwdmVjdG9yJTBBJTIwJTIwJTIwJTIwbGltaXQlM0QzJTJDJTIwJTIwJTIzJTIwUmV0dXJuJTIwdG9wJTIwMyUyMHJlc3VsdHMlMEElMjAlMjAlMjAlMjBzZWFyY2hfcGFyYW1zJTNEJTdCJTIybWV0cmljX3R5cGUlMjIlM0ElMjAlMjJJUCUyMiUyQyUyMCUyMnBhcmFtcyUyMiUzQSUyMCU3QiU3RCU3RCUyQyUyMCUyMCUyMyUyMElubmVyJTIwcHJvZHVjdCUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2ZpZWxkcyUzRCU1QiUyMnRleHQlMjIlNUQlMkMlMjAlMjAlMjMlMjBSZXR1cm4lMjB0aGUlMjB0ZXh0JTIwZmllbGQlMEEp",highlighted:`search_res = milvus_client.search(
    collection_name=collection_name,
    data=[
        emb_text(question)
    ],  <span class="hljs-comment"># Use the \`emb_text\` function to convert the question to an embedding vector</span>
    limit=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Return top 3 results</span>
    search_params={<span class="hljs-string">&quot;metric_type&quot;</span>: <span class="hljs-string">&quot;IP&quot;</span>, <span class="hljs-string">&quot;params&quot;</span>: {}},  <span class="hljs-comment"># Inner product distance</span>
    output_fields=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># Return the text field</span>
)`,wrap:!1}}),me=new f({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJldHJpZXZlZF9saW5lc193aXRoX2Rpc3RhbmNlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMChyZXMlNUIlMjJlbnRpdHklMjIlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcmVzJTVCJTIyZGlzdGFuY2UlMjIlNUQpJTIwZm9yJTIwcmVzJTIwaW4lMjBzZWFyY2hfcmVzJTVCMCU1RCUwQSU1RCUwQXByaW50KGpzb24uZHVtcHMocmV0cmlldmVkX2xpbmVzX3dpdGhfZGlzdGFuY2VzJTJDJTIwaW5kZW50JTNENCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json

<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_lines_with_distances = [
<span class="hljs-meta">... </span>    (res[<span class="hljs-string">&quot;entity&quot;</span>][<span class="hljs-string">&quot;text&quot;</span>], res[<span class="hljs-string">&quot;distance&quot;</span>]) <span class="hljs-keyword">for</span> res <span class="hljs-keyword">in</span> search_res[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(json.dumps(retrieved_lines_with_distances, indent=<span class="hljs-number">4</span>))`,wrap:!1}}),ce=new M({props:{title:"Use LLM to get an RAG response",local:"use-llm-to-get-an-rag-response",headingTag:"h3"}}),ue=new f({props:{code:"Y29udGV4dCUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbiglMEElMjAlMjAlMjAlMjAlNUJsaW5lX3dpdGhfZGlzdGFuY2UlNUIwJTVEJTIwZm9yJTIwbGluZV93aXRoX2Rpc3RhbmNlJTIwaW4lMjByZXRyaWV2ZWRfbGluZXNfd2l0aF9kaXN0YW5jZXMlNUQlMEEp",highlighted:`context = <span class="hljs-string">&quot;\\n&quot;</span>.join(
    [line_with_distance[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> line_with_distance <span class="hljs-keyword">in</span> retrieved_lines_with_distances]
)`,wrap:!1}}),Me=new f({props:{code:"UFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBVXNlJTIwdGhlJTIwZm9sbG93aW5nJTIwcGllY2VzJTIwb2YlMjBpbmZvcm1hdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0Njb250ZXh0JTNFJTIwdGFncyUyMHRvJTIwcHJvdmlkZSUyMGFuJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbiUyMGVuY2xvc2VkJTIwaW4lMjAlM0NxdWVzdGlvbiUzRSUyMHRhZ3MuJTBBJTNDY29udGV4dCUzRSUwQSU3QmNvbnRleHQlN0QlMEElM0MlMkZjb250ZXh0JTNFJTBBJTNDcXVlc3Rpb24lM0UlMEElN0JxdWVzdGlvbiU3RCUwQSUzQyUyRnF1ZXN0aW9uJTNFJTBBJTIyJTIyJTIy",highlighted:`PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Use the following pieces of information enclosed in &lt;context&gt; tags to provide an answer to the question enclosed in &lt;question&gt; tags.
&lt;context&gt;
{context}
&lt;/context&gt;
&lt;question&gt;
{question}
&lt;/question&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),ge=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXh0cmFsLTh4N0ItSW5zdHJ1Y3QtdjAuMSUyMiUwQSUwQWxsbV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQobW9kZWwlM0RyZXBvX2lkJTJDJTIwdGltZW91dCUzRDEyMCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(model=repo_id, timeout=<span class="hljs-number">120</span>)`,wrap:!1}}),ye=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwUFJPTVBULmZvcm1hdChjb250ZXh0JTNEY29udGV4dCUyQyUyMHF1ZXN0aW9uJTNEcXVlc3Rpb24p",highlighted:'prompt = PROMPT.<span class="hljs-built_in">format</span>(context=context, question=question)',wrap:!1}}),je=new f({props:{code:"YW5zd2VyJTIwJTNEJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBKS5zdHJpcCgpJTBBcHJpbnQoYW5zd2VyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>answer = llm_client.text_generation(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>).strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),Te=new Jl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_hf_and_milvus.md"}}),{c(){b=c("meta"),Ie=n(),Ue=c("p"),Ce=n(),i(g.$$.fragment),Ge=n(),i(w.$$.fragment),ke=n(),i(y.$$.fragment),Ze=n(),j=c("p"),j.innerHTML=Nt,xe=n(),J=c("p"),J.innerHTML=At,We=n(),$=c("p"),$.textContent=Et,_e=n(),i(T.$$.fragment),Re=n(),i(U.$$.fragment),Be=n(),i(v.$$.fragment),Ve=n(),I=c("blockquote"),I.innerHTML=qt,Ne=n(),C=c("p"),C.innerHTML=Ht,Ae=n(),i(G.$$.fragment),Ee=n(),i(k.$$.fragment),qe=n(),Z=c("p"),Z.innerHTML=Xt,He=n(),i(x.$$.fragment),Xe=n(),W=c("p"),W.innerHTML=zt,ze=n(),i(_.$$.fragment),Qe=n(),R=c("pre"),R.textContent=Qt,Fe=n(),i(B.$$.fragment),Ye=n(),i(V.$$.fragment),Le=n(),i(N.$$.fragment),Se=n(),A=c("p"),A.innerHTML=Ft,Pe=n(),i(E.$$.fragment),De=n(),q=c("p"),q.textContent=Yt,Ke=n(),i(H.$$.fragment),Oe=n(),X=c("pre"),X.textContent=Lt,et=n(),i(z.$$.fragment),tt=n(),i(Q.$$.fragment),lt=n(),i(F.$$.fragment),st=n(),Y=c("blockquote"),Y.innerHTML=St,nt=n(),L=c("p"),L.textContent=Pt,at=n(),i(S.$$.fragment),it=n(),P=c("p"),P.textContent=Dt,ot=n(),D=c("p"),D.innerHTML=Kt,pt=n(),i(K.$$.fragment),rt=n(),i(O.$$.fragment),mt=n(),ee=c("p"),ee.textContent=Ot,dt=n(),te=c("p"),te.innerHTML=el,ct=n(),i(le.$$.fragment),ht=n(),i(se.$$.fragment),ut=n(),i(ne.$$.fragment),ft=n(),ae=c("p"),ae.textContent=tl,Mt=n(),i(ie.$$.fragment),bt=n(),oe=c("p"),oe.textContent=ll,gt=n(),i(pe.$$.fragment),wt=n(),re=c("p"),re.textContent=sl,yt=n(),i(me.$$.fragment),jt=n(),de=c("pre"),de.textContent=nl,Jt=n(),i(ce.$$.fragment),$t=n(),he=c("p"),he.textContent=al,Tt=n(),i(ue.$$.fragment),Ut=n(),fe=c("p"),fe.textContent=il,vt=n(),i(Me.$$.fragment),It=n(),be=c("p"),be.innerHTML=ol,Ct=n(),i(ge.$$.fragment),Gt=n(),we=c("p"),we.textContent=pl,kt=n(),i(ye.$$.fragment),Zt=n(),i(je.$$.fragment),xt=n(),Je=c("pre"),Je.textContent=rl,Wt=n(),$e=c("p"),$e.textContent=ml,_t=n(),i(Te.$$.fragment),Rt=n(),ve=c("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);b=h(t,"META",{name:!0,content:!0}),t.forEach(l),Ie=a(e),Ue=h(e,"P",{}),dl(Ue).forEach(l),Ce=a(e),o(g.$$.fragment,e),Ge=a(e),o(w.$$.fragment,e),ke=a(e),o(y.$$.fragment,e),Ze=a(e),j=h(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1a5wzqz"&&(j.innerHTML=Nt),xe=a(e),J=h(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-142uvcg"&&(J.innerHTML=At),We=a(e),$=h(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-jfjp6k"&&($.textContent=Et),_e=a(e),o(T.$$.fragment,e),Re=a(e),o(U.$$.fragment,e),Be=a(e),o(v.$$.fragment,e),Ve=a(e),I=h(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(I)!=="svelte-114m81z"&&(I.innerHTML=qt),Ne=a(e),C=h(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1pes3tr"&&(C.innerHTML=Ht),Ae=a(e),o(G.$$.fragment,e),Ee=a(e),o(k.$$.fragment,e),qe=a(e),Z=h(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-10vdpvs"&&(Z.innerHTML=Xt),He=a(e),o(x.$$.fragment,e),Xe=a(e),W=h(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-ok4onc"&&(W.innerHTML=zt),ze=a(e),o(_.$$.fragment,e),Qe=a(e),R=h(e,"PRE",{"data-svelte-h":!0}),u(R)!=="svelte-q6t6yp"&&(R.textContent=Qt),Fe=a(e),o(B.$$.fragment,e),Ye=a(e),o(V.$$.fragment,e),Le=a(e),o(N.$$.fragment,e),Se=a(e),A=h(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-3itqrj"&&(A.innerHTML=Ft),Pe=a(e),o(E.$$.fragment,e),De=a(e),q=h(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1k4nam5"&&(q.textContent=Yt),Ke=a(e),o(H.$$.fragment,e),Oe=a(e),X=h(e,"PRE",{"data-svelte-h":!0}),u(X)!=="svelte-citxyn"&&(X.textContent=Lt),et=a(e),o(z.$$.fragment,e),tt=a(e),o(Q.$$.fragment,e),lt=a(e),o(F.$$.fragment,e),st=a(e),Y=h(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(Y)!=="svelte-1s1ch14"&&(Y.innerHTML=St),nt=a(e),L=h(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1gg40t6"&&(L.textContent=Pt),at=a(e),o(S.$$.fragment,e),it=a(e),P=h(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-hrnx97"&&(P.textContent=Dt),ot=a(e),D=h(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1t69aou"&&(D.innerHTML=Kt),pt=a(e),o(K.$$.fragment,e),rt=a(e),o(O.$$.fragment,e),mt=a(e),ee=h(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-tgjhxg"&&(ee.textContent=Ot),dt=a(e),te=h(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-acj9x6"&&(te.innerHTML=el),ct=a(e),o(le.$$.fragment,e),ht=a(e),o(se.$$.fragment,e),ut=a(e),o(ne.$$.fragment,e),ft=a(e),ae=h(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-16ohks1"&&(ae.textContent=tl),Mt=a(e),o(ie.$$.fragment,e),bt=a(e),oe=h(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-we6yp5"&&(oe.textContent=ll),gt=a(e),o(pe.$$.fragment,e),wt=a(e),re=h(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1az8z3k"&&(re.textContent=sl),yt=a(e),o(me.$$.fragment,e),jt=a(e),de=h(e,"PRE",{"data-svelte-h":!0}),u(de)!=="svelte-sx7p7m"&&(de.textContent=nl),Jt=a(e),o(ce.$$.fragment,e),$t=a(e),he=h(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-qfyl3s"&&(he.textContent=al),Tt=a(e),o(ue.$$.fragment,e),Ut=a(e),fe=h(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-108tlj2"&&(fe.textContent=il),vt=a(e),o(Me.$$.fragment,e),It=a(e),be=h(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1eeh79j"&&(be.innerHTML=ol),Ct=a(e),o(ge.$$.fragment,e),Gt=a(e),we=h(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-i2qxha"&&(we.textContent=pl),kt=a(e),o(ye.$$.fragment,e),Zt=a(e),o(je.$$.fragment,e),xt=a(e),Je=h(e,"PRE",{"data-svelte-h":!0}),u(Je)!=="svelte-18i7g4t"&&(Je.textContent=rl),Wt=a(e),$e=h(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-6dbn83"&&($e.textContent=ml),_t=a(e),o(Te.$$.fragment,e),Rt=a(e),ve=h(e,"P",{}),dl(ve).forEach(l),this.h()},h(){cl(b,"name","hf:doc:metadata"),cl(b,"content",Tl)},m(e,t){wl(document.head,b),s(e,Ie,t),s(e,Ue,t),s(e,Ce,t),p(g,e,t),s(e,Ge,t),p(w,e,t),s(e,ke,t),p(y,e,t),s(e,Ze,t),s(e,j,t),s(e,xe,t),s(e,J,t),s(e,We,t),s(e,$,t),s(e,_e,t),p(T,e,t),s(e,Re,t),p(U,e,t),s(e,Be,t),p(v,e,t),s(e,Ve,t),s(e,I,t),s(e,Ne,t),s(e,C,t),s(e,Ae,t),p(G,e,t),s(e,Ee,t),p(k,e,t),s(e,qe,t),s(e,Z,t),s(e,He,t),p(x,e,t),s(e,Xe,t),s(e,W,t),s(e,ze,t),p(_,e,t),s(e,Qe,t),s(e,R,t),s(e,Fe,t),p(B,e,t),s(e,Ye,t),p(V,e,t),s(e,Le,t),p(N,e,t),s(e,Se,t),s(e,A,t),s(e,Pe,t),p(E,e,t),s(e,De,t),s(e,q,t),s(e,Ke,t),p(H,e,t),s(e,Oe,t),s(e,X,t),s(e,et,t),p(z,e,t),s(e,tt,t),p(Q,e,t),s(e,lt,t),p(F,e,t),s(e,st,t),s(e,Y,t),s(e,nt,t),s(e,L,t),s(e,at,t),p(S,e,t),s(e,it,t),s(e,P,t),s(e,ot,t),s(e,D,t),s(e,pt,t),p(K,e,t),s(e,rt,t),p(O,e,t),s(e,mt,t),s(e,ee,t),s(e,dt,t),s(e,te,t),s(e,ct,t),p(le,e,t),s(e,ht,t),p(se,e,t),s(e,ut,t),p(ne,e,t),s(e,ft,t),s(e,ae,t),s(e,Mt,t),p(ie,e,t),s(e,bt,t),s(e,oe,t),s(e,gt,t),p(pe,e,t),s(e,wt,t),s(e,re,t),s(e,yt,t),p(me,e,t),s(e,jt,t),s(e,de,t),s(e,Jt,t),p(ce,e,t),s(e,$t,t),s(e,he,t),s(e,Tt,t),p(ue,e,t),s(e,Ut,t),s(e,fe,t),s(e,vt,t),p(Me,e,t),s(e,It,t),s(e,be,t),s(e,Ct,t),p(ge,e,t),s(e,Gt,t),s(e,we,t),s(e,kt,t),p(ye,e,t),s(e,Zt,t),p(je,e,t),s(e,xt,t),s(e,Je,t),s(e,Wt,t),s(e,$e,t),s(e,_t,t),p(Te,e,t),s(e,Rt,t),s(e,ve,t),Bt=!0},p:ul,i(e){Bt||(r(g.$$.fragment,e),r(w.$$.fragment,e),r(y.$$.fragment,e),r(T.$$.fragment,e),r(U.$$.fragment,e),r(v.$$.fragment,e),r(G.$$.fragment,e),r(k.$$.fragment,e),r(x.$$.fragment,e),r(_.$$.fragment,e),r(B.$$.fragment,e),r(V.$$.fragment,e),r(N.$$.fragment,e),r(E.$$.fragment,e),r(H.$$.fragment,e),r(z.$$.fragment,e),r(Q.$$.fragment,e),r(F.$$.fragment,e),r(S.$$.fragment,e),r(K.$$.fragment,e),r(O.$$.fragment,e),r(le.$$.fragment,e),r(se.$$.fragment,e),r(ne.$$.fragment,e),r(ie.$$.fragment,e),r(pe.$$.fragment,e),r(me.$$.fragment,e),r(ce.$$.fragment,e),r(ue.$$.fragment,e),r(Me.$$.fragment,e),r(ge.$$.fragment,e),r(ye.$$.fragment,e),r(je.$$.fragment,e),r(Te.$$.fragment,e),Bt=!0)},o(e){m(g.$$.fragment,e),m(w.$$.fragment,e),m(y.$$.fragment,e),m(T.$$.fragment,e),m(U.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(k.$$.fragment,e),m(x.$$.fragment,e),m(_.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(S.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(ge.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),Bt=!1},d(e){e&&(l(Ie),l(Ue),l(Ce),l(Ge),l(ke),l(Ze),l(j),l(xe),l(J),l(We),l($),l(_e),l(Re),l(Be),l(Ve),l(I),l(Ne),l(C),l(Ae),l(Ee),l(qe),l(Z),l(He),l(Xe),l(W),l(ze),l(Qe),l(R),l(Fe),l(Ye),l(Le),l(Se),l(A),l(Pe),l(De),l(q),l(Ke),l(Oe),l(X),l(et),l(tt),l(lt),l(st),l(Y),l(nt),l(L),l(at),l(it),l(P),l(ot),l(D),l(pt),l(rt),l(mt),l(ee),l(dt),l(te),l(ct),l(ht),l(ut),l(ft),l(ae),l(Mt),l(bt),l(oe),l(gt),l(wt),l(re),l(yt),l(jt),l(de),l(Jt),l($t),l(he),l(Tt),l(Ut),l(fe),l(vt),l(It),l(be),l(Ct),l(Gt),l(we),l(kt),l(Zt),l(xt),l(Je),l(Wt),l($e),l(_t),l(Rt),l(ve)),l(b),d(g,e),d(w,e),d(y,e),d(T,e),d(U,e),d(v,e),d(G,e),d(k,e),d(x,e),d(_,e),d(B,e),d(V,e),d(N,e),d(E,e),d(H,e),d(z,e),d(Q,e),d(F,e),d(S,e),d(K,e),d(O,e),d(le,e),d(se,e),d(ne,e),d(ie,e),d(pe,e),d(me,e),d(ce,e),d(ue,e),d(Me,e),d(ge,e),d(ye,e),d(je,e),d(Te,e)}}}const Tl='{"title":"Build RAG with Hugging Face and Milvus","local":"build-rag-with-hugging-face-and-milvus","sections":[{"title":"Preparation","local":"preparation","sections":[{"title":"Dependencies and Environment","local":"dependencies-and-environment","sections":[],"depth":3},{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":3},{"title":"Prepare the Embedding Model","local":"prepare-the-embedding-model","sections":[],"depth":3}],"depth":2},{"title":"Load data into Milvus","local":"load-data-into-milvus","sections":[{"title":"Create the Collection","local":"create-the-collection","sections":[],"depth":3},{"title":"Insert data","local":"insert-data","sections":[],"depth":3}],"depth":2},{"title":"Build RAG","local":"build-rag","sections":[{"title":"Retrieve data for a query","local":"retrieve-data-for-a-query","sections":[],"depth":3},{"title":"Use LLM to get an RAG response","local":"use-llm-to-get-an-rag-response","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ul(Vt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Ml{constructor(b){super(),bl(this,b,Ul,$l,hl,{})}}export{Zl as component};
