import{s as ol,n as il,o as rl}from"../chunks/scheduler.1f027d5a.js";import{S as cl,i as pl,e as o,s as n,c,h as dl,a as i,d as l,b as a,f as nl,g as p,j as r,k as al,l as ul,m as s,n as d,t as u,o as m,p as M}from"../chunks/index.5cb6ce42.js";import{C as ml}from"../chunks/CopyLLMTxtMenu.f7108191.js";import{D as Ml,C as y}from"../chunks/DocNotebookDropdown.adbd98a5.js";import{H as Je,E as yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.903c2670.js";function hl(gt){let h,Ue,Te,je,w,fe,J,Ie,T,ge,b,Ct='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Ce,U,Zt='If you’re new to RAG, please explore the basics of RAG first in <a href="https://huggingface.co/learn/cookbook/rag_zephyr_langchain" rel="nofollow">this other notebook</a>, and then come back here to learn about building RAG with custom data.',Ze,j,Bt="Whether you’re building your own RAG-based personal assistant, a pet project, or an enterprise RAG system, you will quickly discover that a lot of important knowledge is stored in various formats like PDFs, emails, Markdown files, PowerPoint presentations, HTML pages, Word documents, and so on.",Be,f,Gt=`How do you preprocess all of this data in a way that you can use it for RAG?
In this quick tutorial, you’ll learn how to build a RAG system that will incorporate data from multiple data types. You’ll use <a href="https://github.com/Unstructured-IO/unstructured" rel="nofollow">Unstructured</a> for data preprocessing, open-source models from Hugging Face Hub for embeddings and text generation, ChromaDB as a vector store, and LangChain for bringing everything together.`,Ge,I,Wt="Let’s go! We’ll begin by installing the required dependencies:",We,g,ve,C,vt="Next, let’s get a mix of documents. Suppose, I want to build a RAG system that’ll help me manage pests in my garden. For this purpose, I’ll use diverse documents that cover the topic of IPM (integrated pest management):",Re,Z,Rt="<li>PDF: <code>https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf</code></li> <li>Powerpoint: <code>https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx</code></li> <li>EPUB: <code>https://www.gutenberg.org/ebooks/45957</code></li> <li>HTML: <code>https://blog.fifthroom.com/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html</code></li>",ke,B,kt="Feel free to use your own documents for your topic of choice from the list of document types supported by Unstructured: <code>.eml</code>, <code>.html</code>, <code>.md</code>, <code>.msg</code>, <code>.rst</code>, <code>.rtf</code>, <code>.txt</code>, <code>.xml</code>, <code>.png</code>, <code>.jpg</code>, <code>.jpeg</code>, <code>.tiff</code>, <code>.bmp</code>, <code>.heic</code>, <code>.csv</code>, <code>.doc</code>, <code>.docx</code>, <code>.epub</code>, <code>.odt</code>, <code>.pdf</code>, <code>.ppt</code>, <code>.pptx</code>, <code>.tsv</code>, <code>.xlsx</code>.",Xe,G,xe,W,Ve,v,Xt=`You can use the Unstructured library to preprocess documents one by one, and write your own script to walk through a directory, but it’s easier to use a Local source connector to ingest all documents in a given directory. Unstructured can ingest documents from local directories, S3 buckets, blob storage, SFTP, and many other places your documents might be stored in. The ingestion from those sources will be very similar differing mostly in authentication options.
Here you’ll use Local source connector, but feel free to explore other options in the <a href="https://docs.unstructured.io/open-source/ingest/source-connectors/overview" rel="nofollow">Unstructured documentation</a>.`,$e,R,xt='Optionally, you can also choose a <a href="https://docs.unstructured.io/open-source/ingest/destination-connectors/overview" rel="nofollow">destination</a> for the processed documents - this could be MongoDB, Pinecone, Weaviate, etc. In this notebook, we’ll keep everything local.',_e,k,Ye,X,Ae,x,Vt=`INFO: NumExpr defaulting to 2 threads.
`,He,V,$t="Let’s take a closer look at the configs that we have here.",Ne,$,_t="<code>ProcessorConfig</code> controls various aspects of the processing pipeline, including output locations, number of workers, error handling behavior, logging verbosity and more. The only mandatory parameter here is the <code>output_dir</code> - the local directory where you want to store the outputs.",Qe,_,Yt="<code>ReadConfig</code> can be used to customize the data reading process for different scenarios, such as re-downloading data, preserving downloaded files, or limiting the number of documents processed. In most cases the default <code>ReadConfig</code> will work.",ze,Y,At=`In the <code>PartitionConfig</code> you can choose whether to partition the documents locally or via API. This example uses API, and for this reason requires Unstructured API key. You can get yours <a href="https://unstructured.io/api-key-free" rel="nofollow">here</a>.  The free Unstructured API is capped at 1000 pages, and offers better OCR models for image-based documents than a local installation of Unstructured.
If you remove these two parameters, the documents will be processed locally, but you may need to install additional dependencies if the documents require OCR and/or document understanding models. Namely, you may need to install poppler and tesseract in this case, which you can get with brew:`,Fe,A,Ee,H,Ht='If you’re on Windows, you can find alternative installation instructions in the <a href="https://docs.unstructured.io/open-source/installation/full-installation" rel="nofollow">Unstructured docs</a>.',Se,N,Nt="Finally, in the <code>SimpleLocalConfig</code> you need to specify where your original documents reside, and whether you want to walk through the directory recursively.",Le,Q,Qt=`Once the documents are processed you’ll find 4 json files in the <code>local-ingest-output</code> directory, one per document that was processed.
Unstructured partitions all types of documents in a uniform manner, and returns json with document elements.`,qe,z,zt='<a href="https://docs.unstructured.io/api-reference/api-services/document-elements" rel="nofollow">Document elements</a> have a type, e.g. <code>NarrativeText</code>, <code>Title</code>, or <code>Table</code>, they contain the extracted text, and metadata that Unstructured was able to obtain. Some metadata is common for all elements, such as filename of the document the element is from. Other metadata depends on file type or element type. For example, a <code>Table</code> element will contain table’s representation as html in the metadata, and metadata for emails will contain information about senders and recipients.',Pe,F,Ft="Let’s import element objects from these json files.",De,E,Ke,S,Et="Now that that you have extracted the elements from the documents, you can chunk them to fit the context window of the embeddings model.",Oe,L,et,q,St="If you are familiar with chunking methods that split long text documents into smaller chunks, you’ll notice that Unstructured’s chunking methods slightly differ, since the partitioning step already divides an entire document into its structural elements: titles, list items, tables, text, etc. By partitioning documents this way, you can avoid a situation where unrelated pieces of text end up in the same element, and then same chunk.",tt,P,Lt="Now, when you chunk the document elements with Unstructured, individual elements are already small so they will only be split if they exceed the desired maximum chunk size. Otherwise, they will remain as is. You can also optionally choose to combine consecutive text elements such as list items, for instance, that will together fit within chunk size limit.",lt,D,st,K,qt="The chunks are ready for RAG. To use them with LangChain, you can easily convert Unstructured elements to LangChain documents.",nt,O,at,ee,ot,te,Pt='This example uses ChromaDB as a vector store and <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model, feel free to use any other vector store.',it,le,rt,se,Dt="If you plan to use a gated model from the Hugging Face Hub, be it an embeddings or text generation model, you’ll need to authenticate yourself with your Hugging Face token, which you can get in your Hugging Face profile’s settings.",ct,ne,pt,ae,dt,oe,Kt=`Let’s bring everything together and build RAG with LangChain.
In this example we’ll be using <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow"><code>Llama-3-8B-Instruct</code></a> from Meta. To make sure it can run smoothly in the free T4 runtime from Google Colab, you’ll need to quantize it.`,ut,ie,mt,re,Mt,ce,yt,pe,Ot="Now that you have your RAG chain, let’s ask it about aphids. Are they a pest in my garden?",ht,de,wt,ue,el="Output:",Jt,me,Tt,Me,tl="This looks like a promising start! Now that you know the basics of preprocessing complex unstructured data for RAG, you can continue improving upon this example. Here are some ideas:",bt,ye,ll='<li>You can connect to a different source to ingest the documents from, for example, an S3 bucket.</li> <li>You can add <code>return_source_documents=True</code> in the <code>qa_chain</code> arguments to make the chain return the documents that were passed to the prompt as context. This can be useful to understand what sources were used to generate the answer.</li> <li>If you want to leverage the elements metadata at the retrieval stage, consider using Hugging Face agents and creating a custom retriever tool as described in <a href="https://huggingface.co/learn/cookbook/agents#2--rag-with-iterative-query-refinement--source-selection" rel="nofollow">this other notebook</a>.</li> <li>There are many things you could do to improve search results. For instance, you could use Hybrid search instead of a single similarity-search retriever. Hybrid search combines multiple search algorithms to improve the accuracy and relevance of search results. Typically it’s a combination of keyword-based search algorithms with vector search methods.</li>',Ut,he,sl="Have fun building RAG applications with Unstructured data!",jt,we,ft,be,It;return w=new Ml({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_unstructured_data.ipynb"}]}}),J=new ml({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new Je({props:{title:"Building RAG with Custom Unstructured Data",local:"building-rag-with-custom-unstructured-data",headingTag:"h1"}}),g=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHVuc3RydWN0dXJlZCU1QmFsbC1kb2NzJTVEJTIwbGFuZ2NoYWluJTIwY2hyb21hZGIlMjBsYW5nY2hhaW5fY29tbXVuaXR5",highlighted:'!pip install -q torch transformers accelerate bitsandbytes sentence-transformers unstructured[<span class="hljs-built_in">all</span>-docs] langchain chromadb langchain_community',wrap:!1}}),G=new y({props:{code:"IW1rZGlyJTIwLXAlMjAlMjIuJTJGZG9jdW1lbnRzJTIyJTBBIXdnZXQlMjBodHRwcyUzQSUyRiUyRnd3dy5nb3YubmwuY2ElMkZlY2MlMkZmaWxlcyUyRmVudi1wcm90ZWN0aW9uLXBlc3RpY2lkZXMtYnVzaW5lc3MtbWFudWFscy1hcHBsaWMtY2hhcHRlcjcucGRmJTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGZW52LXByb3RlY3Rpb24tcGVzdGljaWRlcy1idXNpbmVzcy1tYW51YWxzLWFwcGxpYy1jaGFwdGVyNy5wZGYlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGaXBtLmlmYXMudWZsLmVkdSUyRnBkZnMlMkZDaXRydXNfSVBNXzA5MDkxMy5wcHR4JTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGQ2l0cnVzX0lQTV8wOTA5MTMucHB0eCUyMiUwQSF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZ3d3cuZ3V0ZW5iZXJnLm9yZyUyRmVib29rcyUyRjQ1OTU3LmVwdWIzLmltYWdlcyUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRjQ1OTU3LmVwdWIlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGYmxvZy5maWZ0aHJvb20uY29tJTJGd2hhdC10by1kby1hYm91dC1oYXJtZnVsLWdhcmRlbi1hbmQtcGxhbnQtaW5zZWN0cy1hbmQtcGVzdHMuaHRtbCUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRndoYXQtdG8tZG8tYWJvdXQtaGFybWZ1bC1nYXJkZW4tYW5kLXBsYW50LWluc2VjdHMtYW5kLXBlc3RzLmh0bWwlMjI=",highlighted:`!mkdir -p <span class="hljs-string">&quot;./documents&quot;</span>
!wget https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf -O <span class="hljs-string">&quot;./documents/env-protection-pesticides-business-manuals-applic-chapter7.pdf&quot;</span>
!wget https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx -O <span class="hljs-string">&quot;./documents/Citrus_IPM_090913.pptx&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">45957.</span>epub3.images -O <span class="hljs-string">&quot;./documents/45957.epub&quot;</span>
!wget https://blog.fifthroom.com/what-to-do-about-harmful-garden-<span class="hljs-keyword">and</span>-plant-insects-<span class="hljs-keyword">and</span>-pests.html -O <span class="hljs-string">&quot;./documents/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html&quot;</span>`,wrap:!1}}),W=new Je({props:{title:"Unstructured data preprocessing",local:"unstructured-data-preprocessing",headingTag:"h2"}}),k=new y({props:{code:"JTIzJTIwT3B0aW9uYWwlMjBjZWxsJTIwdG8lMjByZWR1Y2UlMjB0aGUlMjBhbW91bnQlMjBvZiUyMGxvZ3MlMEElMEFpbXBvcnQlMjBsb2dnaW5nJTBBJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoJTIydW5zdHJ1Y3R1cmVkLmluZ2VzdCUyMiklMEFsb2dnZXIucm9vdC5yZW1vdmVIYW5kbGVyKGxvZ2dlci5yb290LmhhbmRsZXJzJTVCMCU1RCk=",highlighted:`<span class="hljs-comment"># Optional cell to reduce the amount of logs</span>

<span class="hljs-keyword">import</span> logging

logger = logging.getLogger(<span class="hljs-string">&quot;unstructured.ingest&quot;</span>)
logger.root.removeHandler(logger.root.handlers[<span class="hljs-number">0</span>])`,wrap:!1}}),X=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwdW5zdHJ1Y3R1cmVkLmluZ2VzdC5jb25uZWN0b3IubG9jYWwlMjBpbXBvcnQlMjBTaW1wbGVMb2NhbENvbmZpZyUwQWZyb20lMjB1bnN0cnVjdHVyZWQuaW5nZXN0LmludGVyZmFjZXMlMjBpbXBvcnQlMjBQYXJ0aXRpb25Db25maWclMkMlMjBQcm9jZXNzb3JDb25maWclMkMlMjBSZWFkQ29uZmlnJTBBZnJvbSUyMHVuc3RydWN0dXJlZC5pbmdlc3QucnVubmVyJTIwaW1wb3J0JTIwTG9jYWxSdW5uZXIlMEElMEFvdXRwdXRfcGF0aCUyMCUzRCUyMCUyMi4lMkZsb2NhbC1pbmdlc3Qtb3V0cHV0JTIyJTBBJTBBcnVubmVyJTIwJTNEJTIwTG9jYWxSdW5uZXIoJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yX2NvbmZpZyUzRFByb2Nlc3NvckNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb2dzJTIwdmVyYm9zaXR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB0aGUlMjBsb2NhbCUyMGRpcmVjdG9yeSUyMHRvJTIwc3RvcmUlMjBvdXRwdXRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRG91dHB1dF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Byb2Nlc3NlcyUzRDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcmVhZF9jb25maWclM0RSZWFkQ29uZmlnKCklMkMlMEElMjAlMjAlMjAlMjBwYXJ0aXRpb25fY29uZmlnJTNEUGFydGl0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnRpdGlvbl9ieV9hcGklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMllPVVJfVU5TVFJVQ1RVUkVEX0FQSV9LRVklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwY29ubmVjdG9yX2NvbmZpZyUzRFNpbXBsZUxvY2FsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X3BhdGglM0QlMjIuJTJGZG9jdW1lbnRzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwd2hldGhlciUyMHRvJTIwZ2V0JTIwdGhlJTIwZG9jdW1lbnRzJTIwcmVjdXJzaXZlbHklMjBmcm9tJTIwZ2l2ZW4lMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWN1cnNpdmUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjApJTBBcnVubmVyLnJ1bigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.connector.local <span class="hljs-keyword">import</span> SimpleLocalConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.interfaces <span class="hljs-keyword">import</span> PartitionConfig, ProcessorConfig, ReadConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.runner <span class="hljs-keyword">import</span> LocalRunner

<span class="hljs-meta">&gt;&gt;&gt; </span>output_path = <span class="hljs-string">&quot;./local-ingest-output&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>runner = LocalRunner(
<span class="hljs-meta">... </span>    processor_config=ProcessorConfig(
<span class="hljs-meta">... </span>        <span class="hljs-comment"># logs verbosity</span>
<span class="hljs-meta">... </span>        verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># the local directory to store outputs</span>
<span class="hljs-meta">... </span>        output_dir=output_path,
<span class="hljs-meta">... </span>        num_processes=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    read_config=ReadConfig(),
<span class="hljs-meta">... </span>    partition_config=PartitionConfig(
<span class="hljs-meta">... </span>        partition_by_api=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        api_key=<span class="hljs-string">&quot;YOUR_UNSTRUCTURED_API_KEY&quot;</span>,
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    connector_config=SimpleLocalConfig(
<span class="hljs-meta">... </span>        input_path=<span class="hljs-string">&quot;./documents&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># whether to get the documents recursively from given directory</span>
<span class="hljs-meta">... </span>        recursive=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">&gt;&gt;&gt; </span>runner.run()`,wrap:!1}}),A=new y({props:{code:"IWJyZXclMjBpbnN0YWxsJTIwcG9wcGxlciUwQSFicmV3JTIwaW5zdGFsbCUyMHRlc3NlcmFjdA==",highlighted:`!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>poppler
!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>tesseract`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5zdGFnaW5nLmJhc2UlMjBpbXBvcnQlMjBlbGVtZW50c19mcm9tX2pzb24lMEElMEFlbGVtZW50cyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGZpbGVuYW1lJTIwaW4lMjBvcy5saXN0ZGlyKG91dHB1dF9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMGZpbGVwYXRoJTIwJTNEJTIwb3MucGF0aC5qb2luKG91dHB1dF9wYXRoJTJDJTIwZmlsZW5hbWUpJTBBJTIwJTIwJTIwJTIwZWxlbWVudHMuZXh0ZW5kKGVsZW1lbnRzX2Zyb21fanNvbihmaWxlcGF0aCkp",highlighted:`<span class="hljs-keyword">from</span> unstructured.staging.base <span class="hljs-keyword">import</span> elements_from_json

elements = []

<span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> os.listdir(output_path):
    filepath = os.path.join(output_path, filename)
    elements.extend(elements_from_json(filepath))`,wrap:!1}}),L=new Je({props:{title:"Chunking",local:"chunking",headingTag:"h2"}}),D=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5jaHVua2luZy50aXRsZSUyMGltcG9ydCUyMGNodW5rX2J5X3RpdGxlJTBBJTBBY2h1bmtlZF9lbGVtZW50cyUyMCUzRCUyMGNodW5rX2J5X3RpdGxlKGVsZW1lbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGZvciUyMGNodW5rJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9jaGFyYWN0ZXJzJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwY2hvb3NlJTIwdG8lMjBjb21iaW5lJTIwY29uc2VjdXRpdmUlMjBlbGVtZW50cyUyMHRoYXQlMjBhcmUlMjB0b28lMjBzbWFsbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGUuZy4lMjBpbmRpdmlkdWFsJTIwbGlzdCUyMGl0ZW1zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tYmluZV90ZXh0X3VuZGVyX25fY2hhcnMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">from</span> unstructured.chunking.title <span class="hljs-keyword">import</span> chunk_by_title

chunked_elements = chunk_by_title(elements,
                                  <span class="hljs-comment"># maximum for chunk size</span>
                                  max_characters=<span class="hljs-number">512</span>,
                                  <span class="hljs-comment"># You can choose to combine consecutive elements that are too small</span>
                                  <span class="hljs-comment"># e.g. individual list items</span>
                                  combine_text_under_n_chars=<span class="hljs-number">200</span>,
                                  )`,wrap:!1}}),O=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLmRvY3VtZW50cyUyMGltcG9ydCUyMERvY3VtZW50JTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwY2h1bmtlZF9lbGVtZW50JTIwaW4lMjBjaHVua2VkX2VsZW1lbnRzJTNBJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElMjAlM0QlMjBjaHVua2VkX2VsZW1lbnQubWV0YWRhdGEudG9fZGljdCgpJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjAlM0QlMjBtZXRhZGF0YSU1QiUyMmZpbGVuYW1lJTIyJTVEJTBBJTIwJTIwJTIwJTIwZGVsJTIwbWV0YWRhdGElNUIlMjJsYW5ndWFnZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBkb2N1bWVudHMuYXBwZW5kKERvY3VtZW50KHBhZ2VfY29udGVudCUzRGNodW5rZWRfZWxlbWVudC50ZXh0JTJDJTIwbWV0YWRhdGElM0RtZXRhZGF0YSkp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

documents = []
<span class="hljs-keyword">for</span> chunked_element <span class="hljs-keyword">in</span> chunked_elements:
    metadata = chunked_element.metadata.to_dict()
    metadata[<span class="hljs-string">&quot;source&quot;</span>] = metadata[<span class="hljs-string">&quot;filename&quot;</span>]
    <span class="hljs-keyword">del</span> metadata[<span class="hljs-string">&quot;languages&quot;</span>]
    documents.append(Document(page_content=chunked_element.text, metadata=metadata))`,wrap:!1}}),ee=new Je({props:{title:"Setting up the retriever",local:"setting-up-the-retriever",headingTag:"h2"}}),le=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwQ2hyb21hJTBBZnJvbSUyMGxhbmdjaGFpbi5lbWJlZGRpbmdzJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzJTBBJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjB1dGlscyUyMGFzJTIwY2hyb21hdXRpbHMlMEElMEElMjMlMjBDaHJvbWFEQiUyMGRvZXNuJ3QlMjBzdXBwb3J0JTIwY29tcGxleCUyMG1ldGFkYXRhJTJDJTIwZS5nLiUyMGxpc3RzJTJDJTIwc28lMjB3ZSUyMGRyb3AlMjBpdCUyMGhlcmUuJTBBJTIzJTIwSWYlMjB5b3UncmUlMjB1c2luZyUyMGElMjBkaWZmZXJlbnQlMjB2ZWN0b3IlMjBzdG9yZSUyQyUyMHlvdSUyMG1heSUyMG5vdCUyMG5lZWQlMjB0byUyMGRvJTIwdGhpcyUwQWRvY3MlMjAlM0QlMjBjaHJvbWF1dGlscy5maWx0ZXJfY29tcGxleF9tZXRhZGF0YShkb2N1bWVudHMpJTBBJTBBZW1iZWRkaW5ncyUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUlMjIpJTBBdmVjdG9yc3RvcmUlMjAlM0QlMjBDaHJvbWEuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTJDJTIwZW1iZWRkaW5ncyklMEFyZXRyaWV2ZXIlMjAlM0QlMjB2ZWN0b3JzdG9yZS5hc19yZXRyaWV2ZXIoc2VhcmNoX3R5cGUlM0QlMjJzaW1pbGFyaXR5JTIyJTJDJTIwc2VhcmNoX2t3YXJncyUzRCU3QiUyMmslMjIlM0ElMjAzJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> utils <span class="hljs-keyword">as</span> chromautils

<span class="hljs-comment"># ChromaDB doesn&#x27;t support complex metadata, e.g. lists, so we drop it here.</span>
<span class="hljs-comment"># If you&#x27;re using a different vector store, you may not need to do this</span>
docs = chromautils.filter_complex_metadata(documents)

embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>)
vectorstore = Chroma.from_documents(documents, embeddings)
retriever = vectorstore.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">3</span>})`,wrap:!1}}),ne=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ae=new Je({props:{title:"RAG with LangChain",local:"rag-with-langchain",headingTag:"h2"}}),ie=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5wcm9tcHRzJTIwaW1wb3J0JTIwUHJvbXB0VGVtcGxhdGUlMEFmcm9tJTIwbGFuZ2NoYWluLmxsbXMlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA`,wrap:!1}}),re=new y({props:{code:"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",highlighted:`model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)

terminators = [
    tokenizer.eos_token_id,
    tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;&lt;|eot_id|&gt;&quot;</span>)
]

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">200</span>,
    eos_token_id=terminators,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
You are an assistant for answering questions using provided context.
You are given the extracted parts of a long document and a question. Provide a conversational answer.
If you don&#x27;t know the answer, just say &quot;I do not know.&quot; Don&#x27;t make up an answer.
Question: {question}
Context: {context}&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)


qa_chain = RetrievalQA.from_chain_type(
    llm,
    retriever=retriever,
    chain_type_kwargs={<span class="hljs-string">&quot;prompt&quot;</span>: prompt}
)`,wrap:!1}}),ce=new Je({props:{title:"Results and next steps",local:"results-and-next-steps",headingTag:"h2"}}),de=new y({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJBcmUlMjBhcGhpZHMlMjBhJTIwcGVzdCUzRiUyMiUwQSUwQXFhX2NoYWluLmludm9rZShxdWVzdGlvbiklNUIncmVzdWx0JyU1RA==",highlighted:`question = <span class="hljs-string">&quot;Are aphids a pest?&quot;</span>

qa_chain.invoke(question)[<span class="hljs-string">&#x27;result&#x27;</span>]`,wrap:!1}}),me=new y({props:{code:"WWVzJTJDJTIwYXBoaWRzJTIwYXJlJTIwY29uc2lkZXJlZCUyMHBlc3RzJTIwYmVjYXVzZSUyMHRoZXklMjBmZWVkJTIwb24lMjB0aGUlMjBudXRyaWVudC1yaWNoJTIwbGlxdWlkcyUyMHdpdGhpbiUyMHBsYW50cyUyQyUyMGNhdXNpbmclMjBkYW1hZ2UlMjBhbmQlMjBwb3RlbnRpYWxseSUyMHNwcmVhZGluZyUyMGRpc2Vhc2UuJTIwSW4lMjBmYWN0JTJDJTIwdGhleSdyZSUyMGtub3duJTIwdG8lMjBtdWx0aXBseSUyMHF1aWNrbHklMkMlMjB3aGljaCUyMGlzJTIwd2h5JTIwaXQncyUyMGVzc2VudGlhbCUyMHRvJTIwY29udHJvbCUyMHRoZW0lMjBwcm9tcHRseS4lMjBBcyUyMG1lbnRpb25lZCUyMGluJTIwdGhlJTIwdGV4dCUyQyUyMGFwaGlkcyUyMGNhbiUyMGFsc28lMjBhdHRyYWN0JTIwYW50cyUyQyUyMHdoaWNoJTIwYXJlJTIwYXR0cmFjdGVkJTIwdG8lMjB0aGUlMjBzd2VldCUyQyUyMHN0aWNreSUyMHN1YnN0YW5jZSUyMHRoZXklMjBwcm9kdWNlJTIwY2FsbGVkJTIwaG9uZXlkZXcuJTIwU28lMkMlMjB5ZXMlMkMlMjBhcGhpZHMlMjBhcmUlMjBpbmRlZWQlMjBhJTIwcGVzdCUyMHRoYXQlMjByZXF1aXJlcyUyMGF0dGVudGlvbiUyMHRvJTIwcHJldmVudCUyMGZ1cnRoZXIlMjBoYXJtJTIwdG8lMjB5b3VyJTIwcGxhbnRzIQ==",highlighted:'Yes, aphids are considered pests because they feed on the nutrient-rich liquids within plants, causing damage and potentially spreading disease. In fact, they<span class="hljs-string">&#x27;re known to multiply quickly, which is why it&#x27;</span>s essential to control them promptly. As mentioned <span class="hljs-keyword">in</span> the text, aphids can also attract ants, <span class="hljs-built_in">which</span> are attracted to the sweet, sticky substance they produce called honeydew. So, <span class="hljs-built_in">yes</span>, aphids are indeed a pest that requires attention to prevent further harm to your plants!',wrap:!1}}),we=new yl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/rag_with_unstructured_data.md"}}),{c(){h=o("meta"),Ue=n(),Te=o("p"),je=n(),c(w.$$.fragment),fe=n(),c(J.$$.fragment),Ie=n(),c(T.$$.fragment),ge=n(),b=o("p"),b.innerHTML=Ct,Ce=n(),U=o("p"),U.innerHTML=Zt,Ze=n(),j=o("p"),j.textContent=Bt,Be=n(),f=o("p"),f.innerHTML=Gt,Ge=n(),I=o("p"),I.textContent=Wt,We=n(),c(g.$$.fragment),ve=n(),C=o("p"),C.textContent=vt,Re=n(),Z=o("ul"),Z.innerHTML=Rt,ke=n(),B=o("p"),B.innerHTML=kt,Xe=n(),c(G.$$.fragment),xe=n(),c(W.$$.fragment),Ve=n(),v=o("p"),v.innerHTML=Xt,$e=n(),R=o("p"),R.innerHTML=xt,_e=n(),c(k.$$.fragment),Ye=n(),c(X.$$.fragment),Ae=n(),x=o("pre"),x.textContent=Vt,He=n(),V=o("p"),V.textContent=$t,Ne=n(),$=o("p"),$.innerHTML=_t,Qe=n(),_=o("p"),_.innerHTML=Yt,ze=n(),Y=o("p"),Y.innerHTML=At,Fe=n(),c(A.$$.fragment),Ee=n(),H=o("p"),H.innerHTML=Ht,Se=n(),N=o("p"),N.innerHTML=Nt,Le=n(),Q=o("p"),Q.innerHTML=Qt,qe=n(),z=o("p"),z.innerHTML=zt,Pe=n(),F=o("p"),F.textContent=Ft,De=n(),c(E.$$.fragment),Ke=n(),S=o("p"),S.textContent=Et,Oe=n(),c(L.$$.fragment),et=n(),q=o("p"),q.textContent=St,tt=n(),P=o("p"),P.textContent=Lt,lt=n(),c(D.$$.fragment),st=n(),K=o("p"),K.textContent=qt,nt=n(),c(O.$$.fragment),at=n(),c(ee.$$.fragment),ot=n(),te=o("p"),te.innerHTML=Pt,it=n(),c(le.$$.fragment),rt=n(),se=o("p"),se.textContent=Dt,ct=n(),c(ne.$$.fragment),pt=n(),c(ae.$$.fragment),dt=n(),oe=o("p"),oe.innerHTML=Kt,ut=n(),c(ie.$$.fragment),mt=n(),c(re.$$.fragment),Mt=n(),c(ce.$$.fragment),yt=n(),pe=o("p"),pe.textContent=Ot,ht=n(),c(de.$$.fragment),wt=n(),ue=o("p"),ue.textContent=el,Jt=n(),c(me.$$.fragment),Tt=n(),Me=o("p"),Me.textContent=tl,bt=n(),ye=o("ul"),ye.innerHTML=ll,Ut=n(),he=o("p"),he.textContent=sl,jt=n(),c(we.$$.fragment),ft=n(),be=o("p"),this.h()},l(e){const t=dl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),Te=i(e,"P",{}),nl(Te).forEach(l),je=a(e),p(w.$$.fragment,e),fe=a(e),p(J.$$.fragment,e),Ie=a(e),p(T.$$.fragment,e),ge=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-26mfp8"&&(b.innerHTML=Ct),Ce=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1634vfe"&&(U.innerHTML=Zt),Ze=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1qci2tz"&&(j.textContent=Bt),Be=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-3xwkhu"&&(f.innerHTML=Gt),Ge=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1w15t57"&&(I.textContent=Wt),We=a(e),p(g.$$.fragment,e),ve=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-hffqba"&&(C.textContent=vt),Re=a(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1g2z5vq"&&(Z.innerHTML=Rt),ke=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1d3ly9c"&&(B.innerHTML=kt),Xe=a(e),p(G.$$.fragment,e),xe=a(e),p(W.$$.fragment,e),Ve=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3uyhm5"&&(v.innerHTML=Xt),$e=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-14xbuq6"&&(R.innerHTML=xt),_e=a(e),p(k.$$.fragment,e),Ye=a(e),p(X.$$.fragment,e),Ae=a(e),x=i(e,"PRE",{"data-svelte-h":!0}),r(x)!=="svelte-v64b1c"&&(x.textContent=Vt),He=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1bdx5k2"&&(V.textContent=$t),Ne=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-9g2j19"&&($.innerHTML=_t),Qe=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1j049ps"&&(_.innerHTML=Yt),ze=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-45jyya"&&(Y.innerHTML=At),Fe=a(e),p(A.$$.fragment,e),Ee=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ewm525"&&(H.innerHTML=Ht),Se=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1wt80e0"&&(N.innerHTML=Nt),Le=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-9x3e13"&&(Q.innerHTML=Qt),qe=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-n92gq9"&&(z.innerHTML=zt),Pe=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-2t53hk"&&(F.textContent=Ft),De=a(e),p(E.$$.fragment,e),Ke=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-x3hyox"&&(S.textContent=Et),Oe=a(e),p(L.$$.fragment,e),et=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1mlxzmt"&&(q.textContent=St),tt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1hwgds0"&&(P.textContent=Lt),lt=a(e),p(D.$$.fragment,e),st=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1j40r14"&&(K.textContent=qt),nt=a(e),p(O.$$.fragment,e),at=a(e),p(ee.$$.fragment,e),ot=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1r2fx9j"&&(te.innerHTML=Pt),it=a(e),p(le.$$.fragment,e),rt=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1cyhdx7"&&(se.textContent=Dt),ct=a(e),p(ne.$$.fragment,e),pt=a(e),p(ae.$$.fragment,e),dt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-3710om"&&(oe.innerHTML=Kt),ut=a(e),p(ie.$$.fragment,e),mt=a(e),p(re.$$.fragment,e),Mt=a(e),p(ce.$$.fragment,e),yt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-u2l4ip"&&(pe.textContent=Ot),ht=a(e),p(de.$$.fragment,e),wt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1wuxk0l"&&(ue.textContent=el),Jt=a(e),p(me.$$.fragment,e),Tt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1rxjghx"&&(Me.textContent=tl),bt=a(e),ye=i(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-112y9e5"&&(ye.innerHTML=ll),Ut=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1g8numv"&&(he.textContent=sl),jt=a(e),p(we.$$.fragment,e),ft=a(e),be=i(e,"P",{}),nl(be).forEach(l),this.h()},h(){al(h,"name","hf:doc:metadata"),al(h,"content",wl)},m(e,t){ul(document.head,h),s(e,Ue,t),s(e,Te,t),s(e,je,t),d(w,e,t),s(e,fe,t),d(J,e,t),s(e,Ie,t),d(T,e,t),s(e,ge,t),s(e,b,t),s(e,Ce,t),s(e,U,t),s(e,Ze,t),s(e,j,t),s(e,Be,t),s(e,f,t),s(e,Ge,t),s(e,I,t),s(e,We,t),d(g,e,t),s(e,ve,t),s(e,C,t),s(e,Re,t),s(e,Z,t),s(e,ke,t),s(e,B,t),s(e,Xe,t),d(G,e,t),s(e,xe,t),d(W,e,t),s(e,Ve,t),s(e,v,t),s(e,$e,t),s(e,R,t),s(e,_e,t),d(k,e,t),s(e,Ye,t),d(X,e,t),s(e,Ae,t),s(e,x,t),s(e,He,t),s(e,V,t),s(e,Ne,t),s(e,$,t),s(e,Qe,t),s(e,_,t),s(e,ze,t),s(e,Y,t),s(e,Fe,t),d(A,e,t),s(e,Ee,t),s(e,H,t),s(e,Se,t),s(e,N,t),s(e,Le,t),s(e,Q,t),s(e,qe,t),s(e,z,t),s(e,Pe,t),s(e,F,t),s(e,De,t),d(E,e,t),s(e,Ke,t),s(e,S,t),s(e,Oe,t),d(L,e,t),s(e,et,t),s(e,q,t),s(e,tt,t),s(e,P,t),s(e,lt,t),d(D,e,t),s(e,st,t),s(e,K,t),s(e,nt,t),d(O,e,t),s(e,at,t),d(ee,e,t),s(e,ot,t),s(e,te,t),s(e,it,t),d(le,e,t),s(e,rt,t),s(e,se,t),s(e,ct,t),d(ne,e,t),s(e,pt,t),d(ae,e,t),s(e,dt,t),s(e,oe,t),s(e,ut,t),d(ie,e,t),s(e,mt,t),d(re,e,t),s(e,Mt,t),d(ce,e,t),s(e,yt,t),s(e,pe,t),s(e,ht,t),d(de,e,t),s(e,wt,t),s(e,ue,t),s(e,Jt,t),d(me,e,t),s(e,Tt,t),s(e,Me,t),s(e,bt,t),s(e,ye,t),s(e,Ut,t),s(e,he,t),s(e,jt,t),d(we,e,t),s(e,ft,t),s(e,be,t),It=!0},p:il,i(e){It||(u(w.$$.fragment,e),u(J.$$.fragment,e),u(T.$$.fragment,e),u(g.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(we.$$.fragment,e),It=!0)},o(e){m(w.$$.fragment,e),m(J.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(k.$$.fragment,e),m(X.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),It=!1},d(e){e&&(l(Ue),l(Te),l(je),l(fe),l(Ie),l(ge),l(b),l(Ce),l(U),l(Ze),l(j),l(Be),l(f),l(Ge),l(I),l(We),l(ve),l(C),l(Re),l(Z),l(ke),l(B),l(Xe),l(xe),l(Ve),l(v),l($e),l(R),l(_e),l(Ye),l(Ae),l(x),l(He),l(V),l(Ne),l($),l(Qe),l(_),l(ze),l(Y),l(Fe),l(Ee),l(H),l(Se),l(N),l(Le),l(Q),l(qe),l(z),l(Pe),l(F),l(De),l(Ke),l(S),l(Oe),l(et),l(q),l(tt),l(P),l(lt),l(st),l(K),l(nt),l(at),l(ot),l(te),l(it),l(rt),l(se),l(ct),l(pt),l(dt),l(oe),l(ut),l(mt),l(Mt),l(yt),l(pe),l(ht),l(wt),l(ue),l(Jt),l(Tt),l(Me),l(bt),l(ye),l(Ut),l(he),l(jt),l(ft),l(be)),l(h),M(w,e),M(J,e),M(T,e),M(g,e),M(G,e),M(W,e),M(k,e),M(X,e),M(A,e),M(E,e),M(L,e),M(D,e),M(O,e),M(ee,e),M(le,e),M(ne,e),M(ae,e),M(ie,e),M(re,e),M(ce,e),M(de,e),M(me,e),M(we,e)}}}const wl='{"title":"Building RAG with Custom Unstructured Data","local":"building-rag-with-custom-unstructured-data","sections":[{"title":"Unstructured data preprocessing","local":"unstructured-data-preprocessing","sections":[],"depth":2},{"title":"Chunking","local":"chunking","sections":[],"depth":2},{"title":"Setting up the retriever","local":"setting-up-the-retriever","sections":[],"depth":2},{"title":"RAG with LangChain","local":"rag-with-langchain","sections":[],"depth":2},{"title":"Results and next steps","local":"results-and-next-steps","sections":[],"depth":2}],"depth":1}';function Jl(gt){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends cl{constructor(h){super(),pl(this,h,Jl,hl,ol,{})}}export{Il as component};
