import{s as ft,n as Zt,o as vt}from"../chunks/scheduler.e0212c12.js";import{S as Bt,i as Gt,e as i,s,c as y,h as At,a as M,d as t,b as n,f as ht,g as o,j as r,k as gt,l as zt,m as a,n as p,t as u,o as m,p as U}from"../chunks/index.a585a37c.js";import{C as Wt,H as j,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.187ef30f.js";import{D as Rt,C as J}from"../chunks/DocNotebookDropdown.84a84327.js";function _t(Ne){let c,Zl,gl,vl,d,Bl,T,Gl,b,Al,w,Ee='<em>Yazar: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em> <em>Çeviren: <a href="https://github.com/alpererdogan8" rel="nofollow">Alper Erdoğan</a></em>',zl,k,Se='Bu notebook, harika <strong>ajanlar</strong> oluşturmak için <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents’ı</strong></a> nasıl kullanabileceğinizi gösterir!',Wl,C,$e="<strong>Ajanlar</strong> nedir? Ajanlar, bir LLM tarafından desteklenen ve spesifik istemler ile çıktıların ayrıştırılması sayesinde belirli <em>araçları</em> kullanarak problemleri çözebilen sistemlerdir.",Vl,I,Ye='Bu araçlar basitçe LLM’nin kendi başına iyi performans sergileyemediği işlevleri kapsar: örneğin <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a> gibi metin üreten bir LLM için görüntü oluşturma aracı, web arama aracı veya hesap makinesi olabilir…',Rl,h,Xe='<strong>Transformers Agents</strong> nedir? Kendi ajanlarınızı oluşturmak için yapı taşları sağlayan <code>transformers</code> kütüphanemizin bir uzantısıdır! <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Dökümantasyondan</a> daha fazla bilgi edinin.',_l,g,xe="Nasıl kullanılacağına ve hangi kullanım senaryolarını çözebileceğine bakalım.",Ql,f,He="Gerekli kütüphaneleri yüklemek için aşağıdaki satırı çalıştırın:",Nl,Z,El,v,Sl,B,qe="Bu kullanım senaryosu için, internette gezinen ve görsel oluşturabilen bir ajan göstermek istiyoruz.",$l,G,Fe="Bunu oluşturmak için basitçe iki aracın hazır olması gerekiyor: görüntü oluşturma ve internet üzerinden arama.",Yl,A,Le="<li>Görsel oluşturmak için, Stable Diffusion kullanarak görseller oluşturmak üzere Hub’dan HF Inference API’yi (Serverless) kullanan bir araç yüklüyoruz.</li> <li>İnternette arama yapmak için yerleşik bir araç kullanıyoruz.</li>",Xl,z,xl,W,Pe='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Hl,V,ql,R,Ke="Kısa tanım: Retrieval-Augmented-Generation (RAG), <strong><em>“bir kullanıcı sorgusunu yanıtlamak için bir büyük dil modeli (LLM) kullanır, ancak yanıtı veri setinden elde edilen verilere dayandırır”</em></strong>.",Fl,_,De="Bu yöntemin yalın ya da fine-tuned bir LLM kullanımına göre birçok avantajı vardır: bunlardan birkaçını saymak gerekirse, cevabı doğru gerçeklere dayandırmaya ve karışıklıkları azaltmaya izin verir, LLM’e özgü bilgileri sağlamaya ve bilgi tabanından veriye erişimin ince taneli kontrolüne izin verir.",Ll,Q,Oe="<li><p>Şöyle bir senaryo düşünelim. RAG yöntemini uygulamak istiyoruz, ancak bazı parametrelerin dinamik olarak belirlenmesi gereken ek bir koşulumuz var. Örneğin, kullanıcı sorgusuna bağlı olarak aramayı bilgi tabanının belirli alt kümeleriyle sınırlamak isteyebiliriz veya alınan belge sayısını ayarlamak isteyebiliriz. Peki, <strong>bu parametreleri kullanıcı sorgusuna göre nasıl dinamik olarak ayarlayabiliriz?</strong></p></li> <li><p>RAG’de sık karşılaşılan bir sorun, kullanıcı sorgusuna verilen cevabın hangi belgeden geldiğinin bulunmamasıdır. <strong>Eğer önceki sonuçlar alakalı değilse, retriever’ı değiştirilmiş bir sorgu ile tekrar çalıştırarak sonuç alma şansımız var mı?</strong></p></li>",Pl,N,lt="🔧 Yukarıdaki noktaları basit bir şekilde çözebiliriz: <strong>ajanımıza retriever’ın parametrelerinin kontrolünü vereceğiz!</strong>",Kl,E,et="➡️ Hadi bunu nasıl yapacağımızı gösterelim. İlk olarak üzerinde RAG uygulamak istediğimiz bir bilgi tabanını yüklüyoruz: bu veri seti, markdown olarak depolanan birçok Hugging Face kütüphanesinin dokümantasyon sayfalarının bir derlemesidir.",Dl,S,Ol,$,tt="Şimdi veri setini işleyerek ve retriever tarafından kullanılacak bir vektör veritabanına depolayarak bilgi tabanını hazırlıyoruz. Vektör veritabanları için mükemmel yardımcı programlara sahip olduğu için LangChain’i kullanacağız:",le,Y,ee,X,at="Artık veritabanımız hazır olduğuna göre, kullanıcı sorgularını buna göre yanıtlayan bir RAG sistemi oluşturalım!",te,x,st="Sistemimizin sorguya bağlı olarak yalnızca en alakalı bilgi kaynaklarından seçim yapmasını istiyoruz.",ae,H,nt="Dökümantasyon sayfalarımız aşağıdaki kaynaklardan gelecek:",se,q,ne,F,it=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,ie,L,Mt="👉 Şimdi ajanlarımızın bilgi tabanından bilgi almak için kullanabileceği bir <code>RetrieverTool</code> oluşturalım.",Me,P,rt='Vectordb’yi aracın bir özelliği olarak eklememiz gerektiği için, <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">basit araç oluşturusunu</a> ve <code>@tool</code> dekoratörünü kullanmak yeterli olmayacak. Bu nedenle, <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">gelişmiş ajanlar dökümantasyonunda</a>  belirtilen gelişmiş yapılandırmayı takip edeceğiz',re,K,ye,D,oe,O,yt="Aracınızı Hub’da paylaşmak için, önce RetrieverTool tanım hücresindeki kodu kopyalayıp, örneğin <code>retriever.py</code> gibi bir adla yeni bir dosyaya yapıştırın.",pe,ll,ot="Araç ayrı bir dosyadan yüklendiğinde, aşağıdaki kodu kullanarak Hub’a gönderebilirsiniz (<code>yazma</code> yetkisine sahip bir token ile giriş yaptığınızdan emin olun).",ue,el,me,tl,Ue,al,Je,sl,pt="Peki burada ne oldu? İlk olarak, ajan belirli kaynaklarla (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>) birlikte retriever’ı başlattı.",ce,nl,ut="Ancak bu arama yeterli sonucu vermedi. Sorun değil! Ajan, önceki sonuçlar üzerinde tekrar çalışabildiği için, daha az kısıtlayıcı arama parametreleriyle yeniden sorgulama yaptı ve sonuç olarak araştırma başarılı oldu!",je,il,mt="Bir LLM ajanının bir retriever aracını kullanarak dinamik olarak sorguyu ve retrieval parametrelerini değiştirebilmesi, RAG’in daha genel bir formülasyonunu oluşturur ve aynı zamanda yinelemeli sorgu iyileştirme gibi birçok RAG geliştirme tekniğini de kapsar.",de,Ml,Ut="<strong>Bir retriever’ı araç olarak kullanıp, sorguyu ve diğer</strong> veri çekme parametrelerini dinamik olarak değiştirebilen <strong>bir LLM ajanı kullanmak</strong>, yinelemeli sorgu iyileştirmesi gibi birçok RAG geliştirme tekniğini de kapsayan <strong>RAG’in daha genel bir formülasyonudur</strong>.",Te,rl,be,yl,Jt="ReactCodeAgent’in yerleşik bir Python kod yorumlayıcısı olduğundan, hatalı Python scriptimizi debug etmek için kullanabiliriz!",we,ol,ke,pl,ct="Gördüğünüz gibi, ajan verilen kodu deniyor, bir hata alıyor, hatayı analiz ediyor, kodu düzeltiyor ve çalıştığını gördükten sonra geri veriyor!",Ce,ul,jt="Sonuç olarak düzeltilen kodun son hali:",Ie,ml,he,Ul,dt=`my_list = [0, 1, 2]

for i in range(4):
    if i < len(my_list):
        print(my_list[i])
    else:
        print("Index out of range")
`,ge,Jl,fe,cl,Tt=`Kendi LLM motorunuzu oluşturmak gerçekten çok kolay:
sadece bu kriterlere sahip bir <code>__call__</code> yöntemine ihtiyaç duyar:`,Ze,jl,bt='<li>Girdi olarak <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML formatında</a> bir mesaj listesi alır ve cevabı çıktı olarak verir.</li> <li><code>stop_sequences</code> argümanını destekleyerek metin üretmeyi durduracak dizileri tanımlar.</li> <li>LLM’inizin desteklediği mesaj rolü (asistan, kullanıcı vb.) türlerine göre bazı mesaj rollerini dönüştürmeniz gerekebilir.</li>',ve,dl,Be,Tl,Ge,bl,wt=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Ae,wl,ze,kl,kt="Yukarıdaki kullanım örnekleri, Agents’ın sunduğu olanaklar hakkında size bir fikir verecektir.",We,Cl,Ct='Daha gelişmiş kullanım için <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">dökümantasyonu</a> ve Llama-3-70B’yi temel alan ve son derece zorlayıcı GAIA Liderlik Tablosunda birçok GPT-4 ajanlarını geride bırakan kendi ajanımızı oluşturmamızı sağlayan <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">bu deneyi</a> okuyun!',Ve,Il,It="Tüm geri bildirimleri bekliyoruz, Agents’ı geliştirmemize yardımcı olacak!",Re,hl,_e,fl,Qe;return d=new Rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/tr/agents.ipynb"}]}}),T=new Wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new j({props:{title:"Transformers Agents kullanarak, tool-calling süper güçleriyle donatılmış bir ajan oluşturun 🦸",local:"transformers-agents-kullanarak-tool-calling-süper-güçleriyle-donatılmış-bir-ajan-oluşturun-",headingTag:"h1"}}),Z=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwb3BlbmFpJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMC0tdXBncmFkZSUyMC1x",highlighted:'!pip install <span class="hljs-string">&quot;transformers[agents]&quot;</span> datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q',wrap:!1}}),v=new j({props:{title:"1. 🏞️ Çok Modlu + 🌐 Web tarayıcı asistanı",local:"1--çok-modlu---web-tarayıcı-asistanı",headingTag:"h2"}}),z=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMFJlYWN0Q29kZUFnZW50JTJDJTIwSGZBcGlFbmdpbmUlMEElMEElMjMlMjBBcmFjJUM0JUIxJTIwSHViJ2RhbiUyMGklQzMlQTdlJTIwYWt0YXIlQzQlQjFuJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUyMGNhY2hlJTNERmFsc2UpJTBBJTBBJTIzJTIwTGFuZ0NoYWluJ2RlbiUyMGFyYWMlQzQlQjElMjBpJUMzJUE3ZSUyMGFrdGFyJUM0JUIxbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzLnNlYXJjaCUyMGltcG9ydCUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMjMlMjBBamFubGFyJUM0JUIxJTIwaGVyJTIwaWtpJTIwYXJhJUMzJUE3bGElMjBiYSVDNSU5RmxhdCVDNCVCMW4uJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMEEpJTBBJTBBJTIzJTIwJUMzJTg3YWwlQzQlQjElQzUlOUZ0JUM0JUIxciElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, ReactCodeAgent, HfApiEngine

<span class="hljs-comment"># Aracı Hub&#x27;dan içe aktarın</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, cache=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># LangChain&#x27;den aracı içe aktarın</span>
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

search_tool = DuckDuckGoSearchTool()

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-comment"># Ajanları her iki araçla başlatın.</span>
agent = ReactCodeAgent(
    tools=[image_generation_tool, search_tool], llm_engine=llm_engine
)

<span class="hljs-comment"># Çalıştır!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),V=new j({props:{title:"2. 📚💬 RAG ile yinelemeli sorgu iyileştirme ve kaynak seçimi",local:"2--rag-ile-yinelemeli-sorgu-iyileştirme-ve-kaynak-seçimi",headingTag:"h2"}}),S=new J({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMEElMjAlMjAlMjAlMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMHNvdXJjZV9kb2NzJTBBKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(
    source_docs
)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),q=new J({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),K=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(
                source
            ):  <span class="hljs-comment"># eğer kaynak bir listeyi temsil etmiyorsa</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join(
            [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs]
        )`,wrap:!1}}),D=new j({props:{title:"Opsiyonel: Retriever aracınızı Hub’da paylaşın",local:"opsiyonel-retriever-aracınızı-hubda-paylaşın",headingTag:"h3"}}),el=new J({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBcmFjJUM0JUIxbiUyMFklQzMlQkNrbGVubWVzaSUwQSUyMCUyMCUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Aracın Yüklenmesi</span>
    <span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(
        <span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources
    )`,wrap:!1}}),tl=new j({props:{title:"Ajanı çalıştırın!",local:"ajanı-çalıştırın",headingTag:"h3"}}),al=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjB2ZXJib3NlJTNEMCklMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwc2hvdyUyMG1lJTIwYSUyMExPUkElMjBmaW5ldHVuaW5nJTIwc2NyaXB0JTIyKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),rl=new j({props:{title:"3. 💻 Python Kodunda Hata Ayıklama",local:"3--python-kodunda-hata-ayıklama",headingTag:"h2"}}),ol=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpKSUwQSUwQWNvZGUlMjAlM0QlMjAlMjIlMjIlMjIlMEFsaXN0JTNEJTVCMCUyQyUyMDElMkMlMjAyJTVEJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsaXN0KGkpKSUwQSUyMiUyMiUyMiUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMHNvbWUlMjBjb2RlJTIwdGhhdCUyMGNyZWF0ZXMlMjBhJTIwYnVnJTNBJTIwcGxlYXNlJTIwZGVidWclMjBpdCUyQyUyMHRoZW4lMjBydW4lMjBpdCUyMHRvJTIwbWFrZSUyMHN1cmUlMjBpdCUyMHdvcmtzJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZmluYWwlMjBjb2RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29kZSUzRGNvZGUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ml=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),Jl=new j({props:{title:"4. Kendi LLM motorunuzu oluşturun (OpenAI)",local:"4-kendi-llm-motorunuzu-oluşturun-openai",headingTag:"h2"}}),dl=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Güvenli mesaj listesini edinin</span>
        messages = get_clean_message_list(
            messages, role_conversions=openai_role_conversions
        )

        <span class="hljs-comment"># LLM çıktısını alın</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Tl=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),wl=new j({props:{title:"➡️ Son olarak",local:"-son-olarak",headingTag:"h2"}}),hl=new Vt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/tr/agents.md"}}),{c(){c=i("meta"),Zl=s(),gl=i("p"),vl=s(),y(d.$$.fragment),Bl=s(),y(T.$$.fragment),Gl=s(),y(b.$$.fragment),Al=s(),w=i("p"),w.innerHTML=Ee,zl=s(),k=i("p"),k.innerHTML=Se,Wl=s(),C=i("p"),C.innerHTML=$e,Vl=s(),I=i("p"),I.innerHTML=Ye,Rl=s(),h=i("p"),h.innerHTML=Xe,_l=s(),g=i("p"),g.textContent=xe,Ql=s(),f=i("p"),f.textContent=He,Nl=s(),y(Z.$$.fragment),El=s(),y(v.$$.fragment),Sl=s(),B=i("p"),B.textContent=qe,$l=s(),G=i("p"),G.textContent=Fe,Yl=s(),A=i("ul"),A.innerHTML=Le,Xl=s(),y(z.$$.fragment),xl=s(),W=i("p"),W.innerHTML=Pe,Hl=s(),y(V.$$.fragment),ql=s(),R=i("p"),R.innerHTML=Ke,Fl=s(),_=i("p"),_.textContent=De,Ll=s(),Q=i("ul"),Q.innerHTML=Oe,Pl=s(),N=i("p"),N.innerHTML=lt,Kl=s(),E=i("p"),E.textContent=et,Dl=s(),y(S.$$.fragment),Ol=s(),$=i("p"),$.textContent=tt,le=s(),y(Y.$$.fragment),ee=s(),X=i("p"),X.textContent=at,te=s(),x=i("p"),x.textContent=st,ae=s(),H=i("p"),H.textContent=nt,se=s(),y(q.$$.fragment),ne=s(),F=i("pre"),F.textContent=it,ie=s(),L=i("p"),L.innerHTML=Mt,Me=s(),P=i("p"),P.innerHTML=rt,re=s(),y(K.$$.fragment),ye=s(),y(D.$$.fragment),oe=s(),O=i("p"),O.innerHTML=yt,pe=s(),ll=i("p"),ll.innerHTML=ot,ue=s(),y(el.$$.fragment),me=s(),y(tl.$$.fragment),Ue=s(),y(al.$$.fragment),Je=s(),sl=i("p"),sl.innerHTML=pt,ce=s(),nl=i("p"),nl.textContent=ut,je=s(),il=i("p"),il.textContent=mt,de=s(),Ml=i("p"),Ml.innerHTML=Ut,Te=s(),y(rl.$$.fragment),be=s(),yl=i("p"),yl.textContent=Jt,we=s(),y(ol.$$.fragment),ke=s(),pl=i("p"),pl.textContent=ct,Ce=s(),ul=i("p"),ul.textContent=jt,Ie=s(),y(ml.$$.fragment),he=s(),Ul=i("pre"),Ul.textContent=dt,ge=s(),y(Jl.$$.fragment),fe=s(),cl=i("p"),cl.innerHTML=Tt,Ze=s(),jl=i("ol"),jl.innerHTML=bt,ve=s(),y(dl.$$.fragment),Be=s(),y(Tl.$$.fragment),Ge=s(),bl=i("pre"),bl.textContent=wt,Ae=s(),y(wl.$$.fragment),ze=s(),kl=i("p"),kl.textContent=kt,We=s(),Cl=i("p"),Cl.innerHTML=Ct,Ve=s(),Il=i("p"),Il.textContent=It,Re=s(),y(hl.$$.fragment),_e=s(),fl=i("p"),this.h()},l(l){const e=At("svelte-u9bgzb",document.head);c=M(e,"META",{name:!0,content:!0}),e.forEach(t),Zl=n(l),gl=M(l,"P",{}),ht(gl).forEach(t),vl=n(l),o(d.$$.fragment,l),Bl=n(l),o(T.$$.fragment,l),Gl=n(l),o(b.$$.fragment,l),Al=n(l),w=M(l,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1itztgb"&&(w.innerHTML=Ee),zl=n(l),k=M(l,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1okp29d"&&(k.innerHTML=Se),Wl=n(l),C=M(l,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1tjoz4w"&&(C.innerHTML=$e),Vl=n(l),I=M(l,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7pnahf"&&(I.innerHTML=Ye),Rl=n(l),h=M(l,"P",{"data-svelte-h":!0}),r(h)!=="svelte-rgwo7j"&&(h.innerHTML=Xe),_l=n(l),g=M(l,"P",{"data-svelte-h":!0}),r(g)!=="svelte-rzyg7y"&&(g.textContent=xe),Ql=n(l),f=M(l,"P",{"data-svelte-h":!0}),r(f)!=="svelte-fxmfh3"&&(f.textContent=He),Nl=n(l),o(Z.$$.fragment,l),El=n(l),o(v.$$.fragment,l),Sl=n(l),B=M(l,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1bseyqm"&&(B.textContent=qe),$l=n(l),G=M(l,"P",{"data-svelte-h":!0}),r(G)!=="svelte-qc6yv8"&&(G.textContent=Fe),Yl=n(l),A=M(l,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1c5qckf"&&(A.innerHTML=Le),Xl=n(l),o(z.$$.fragment,l),xl=n(l),W=M(l,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1hg95q8"&&(W.innerHTML=Pe),Hl=n(l),o(V.$$.fragment,l),ql=n(l),R=M(l,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tp8r29"&&(R.innerHTML=Ke),Fl=n(l),_=M(l,"P",{"data-svelte-h":!0}),r(_)!=="svelte-yh4nih"&&(_.textContent=De),Ll=n(l),Q=M(l,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-cr6vrq"&&(Q.innerHTML=Oe),Pl=n(l),N=M(l,"P",{"data-svelte-h":!0}),r(N)!=="svelte-kaaeqm"&&(N.innerHTML=lt),Kl=n(l),E=M(l,"P",{"data-svelte-h":!0}),r(E)!=="svelte-15opnia"&&(E.textContent=et),Dl=n(l),o(S.$$.fragment,l),Ol=n(l),$=M(l,"P",{"data-svelte-h":!0}),r($)!=="svelte-1gbw2ro"&&($.textContent=tt),le=n(l),o(Y.$$.fragment,l),ee=n(l),X=M(l,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1rfrrmh"&&(X.textContent=at),te=n(l),x=M(l,"P",{"data-svelte-h":!0}),r(x)!=="svelte-jx6hhy"&&(x.textContent=st),ae=n(l),H=M(l,"P",{"data-svelte-h":!0}),r(H)!=="svelte-19521um"&&(H.textContent=nt),se=n(l),o(q.$$.fragment,l),ne=n(l),F=M(l,"PRE",{"data-svelte-h":!0}),r(F)!=="svelte-crsp42"&&(F.textContent=it),ie=n(l),L=M(l,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1jufpu2"&&(L.innerHTML=Mt),Me=n(l),P=M(l,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ua5lte"&&(P.innerHTML=rt),re=n(l),o(K.$$.fragment,l),ye=n(l),o(D.$$.fragment,l),oe=n(l),O=M(l,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1tz4mys"&&(O.innerHTML=yt),pe=n(l),ll=M(l,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-7ac8y3"&&(ll.innerHTML=ot),ue=n(l),o(el.$$.fragment,l),me=n(l),o(tl.$$.fragment,l),Ue=n(l),o(al.$$.fragment,l),Je=n(l),sl=M(l,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-14k588x"&&(sl.innerHTML=pt),ce=n(l),nl=M(l,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-180ga06"&&(nl.textContent=ut),je=n(l),il=M(l,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1mpg88y"&&(il.textContent=mt),de=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-nw2aw8"&&(Ml.innerHTML=Ut),Te=n(l),o(rl.$$.fragment,l),be=n(l),yl=M(l,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1hcmmvc"&&(yl.textContent=Jt),we=n(l),o(ol.$$.fragment,l),ke=n(l),pl=M(l,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1v9l2i5"&&(pl.textContent=ct),Ce=n(l),ul=M(l,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1bcqr6k"&&(ul.textContent=jt),Ie=n(l),o(ml.$$.fragment,l),he=n(l),Ul=M(l,"PRE",{"data-svelte-h":!0}),r(Ul)!=="svelte-eeovy7"&&(Ul.textContent=dt),ge=n(l),o(Jl.$$.fragment,l),fe=n(l),cl=M(l,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-upvu3f"&&(cl.innerHTML=Tt),Ze=n(l),jl=M(l,"OL",{"data-svelte-h":!0}),r(jl)!=="svelte-10i2jt5"&&(jl.innerHTML=bt),ve=n(l),o(dl.$$.fragment,l),Be=n(l),o(Tl.$$.fragment,l),Ge=n(l),bl=M(l,"PRE",{"data-svelte-h":!0}),r(bl)!=="svelte-tgqz6q"&&(bl.textContent=wt),Ae=n(l),o(wl.$$.fragment,l),ze=n(l),kl=M(l,"P",{"data-svelte-h":!0}),r(kl)!=="svelte-1kdjqlp"&&(kl.textContent=kt),We=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-1bmzsyo"&&(Cl.innerHTML=Ct),Ve=n(l),Il=M(l,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-10njswm"&&(Il.textContent=It),Re=n(l),o(hl.$$.fragment,l),_e=n(l),fl=M(l,"P",{}),ht(fl).forEach(t),this.h()},h(){gt(c,"name","hf:doc:metadata"),gt(c,"content",Qt)},m(l,e){zt(document.head,c),a(l,Zl,e),a(l,gl,e),a(l,vl,e),p(d,l,e),a(l,Bl,e),p(T,l,e),a(l,Gl,e),p(b,l,e),a(l,Al,e),a(l,w,e),a(l,zl,e),a(l,k,e),a(l,Wl,e),a(l,C,e),a(l,Vl,e),a(l,I,e),a(l,Rl,e),a(l,h,e),a(l,_l,e),a(l,g,e),a(l,Ql,e),a(l,f,e),a(l,Nl,e),p(Z,l,e),a(l,El,e),p(v,l,e),a(l,Sl,e),a(l,B,e),a(l,$l,e),a(l,G,e),a(l,Yl,e),a(l,A,e),a(l,Xl,e),p(z,l,e),a(l,xl,e),a(l,W,e),a(l,Hl,e),p(V,l,e),a(l,ql,e),a(l,R,e),a(l,Fl,e),a(l,_,e),a(l,Ll,e),a(l,Q,e),a(l,Pl,e),a(l,N,e),a(l,Kl,e),a(l,E,e),a(l,Dl,e),p(S,l,e),a(l,Ol,e),a(l,$,e),a(l,le,e),p(Y,l,e),a(l,ee,e),a(l,X,e),a(l,te,e),a(l,x,e),a(l,ae,e),a(l,H,e),a(l,se,e),p(q,l,e),a(l,ne,e),a(l,F,e),a(l,ie,e),a(l,L,e),a(l,Me,e),a(l,P,e),a(l,re,e),p(K,l,e),a(l,ye,e),p(D,l,e),a(l,oe,e),a(l,O,e),a(l,pe,e),a(l,ll,e),a(l,ue,e),p(el,l,e),a(l,me,e),p(tl,l,e),a(l,Ue,e),p(al,l,e),a(l,Je,e),a(l,sl,e),a(l,ce,e),a(l,nl,e),a(l,je,e),a(l,il,e),a(l,de,e),a(l,Ml,e),a(l,Te,e),p(rl,l,e),a(l,be,e),a(l,yl,e),a(l,we,e),p(ol,l,e),a(l,ke,e),a(l,pl,e),a(l,Ce,e),a(l,ul,e),a(l,Ie,e),p(ml,l,e),a(l,he,e),a(l,Ul,e),a(l,ge,e),p(Jl,l,e),a(l,fe,e),a(l,cl,e),a(l,Ze,e),a(l,jl,e),a(l,ve,e),p(dl,l,e),a(l,Be,e),p(Tl,l,e),a(l,Ge,e),a(l,bl,e),a(l,Ae,e),p(wl,l,e),a(l,ze,e),a(l,kl,e),a(l,We,e),a(l,Cl,e),a(l,Ve,e),a(l,Il,e),a(l,Re,e),p(hl,l,e),a(l,_e,e),a(l,fl,e),Qe=!0},p:Zt,i(l){Qe||(u(d.$$.fragment,l),u(T.$$.fragment,l),u(b.$$.fragment,l),u(Z.$$.fragment,l),u(v.$$.fragment,l),u(z.$$.fragment,l),u(V.$$.fragment,l),u(S.$$.fragment,l),u(Y.$$.fragment,l),u(q.$$.fragment,l),u(K.$$.fragment,l),u(D.$$.fragment,l),u(el.$$.fragment,l),u(tl.$$.fragment,l),u(al.$$.fragment,l),u(rl.$$.fragment,l),u(ol.$$.fragment,l),u(ml.$$.fragment,l),u(Jl.$$.fragment,l),u(dl.$$.fragment,l),u(Tl.$$.fragment,l),u(wl.$$.fragment,l),u(hl.$$.fragment,l),Qe=!0)},o(l){m(d.$$.fragment,l),m(T.$$.fragment,l),m(b.$$.fragment,l),m(Z.$$.fragment,l),m(v.$$.fragment,l),m(z.$$.fragment,l),m(V.$$.fragment,l),m(S.$$.fragment,l),m(Y.$$.fragment,l),m(q.$$.fragment,l),m(K.$$.fragment,l),m(D.$$.fragment,l),m(el.$$.fragment,l),m(tl.$$.fragment,l),m(al.$$.fragment,l),m(rl.$$.fragment,l),m(ol.$$.fragment,l),m(ml.$$.fragment,l),m(Jl.$$.fragment,l),m(dl.$$.fragment,l),m(Tl.$$.fragment,l),m(wl.$$.fragment,l),m(hl.$$.fragment,l),Qe=!1},d(l){l&&(t(Zl),t(gl),t(vl),t(Bl),t(Gl),t(Al),t(w),t(zl),t(k),t(Wl),t(C),t(Vl),t(I),t(Rl),t(h),t(_l),t(g),t(Ql),t(f),t(Nl),t(El),t(Sl),t(B),t($l),t(G),t(Yl),t(A),t(Xl),t(xl),t(W),t(Hl),t(ql),t(R),t(Fl),t(_),t(Ll),t(Q),t(Pl),t(N),t(Kl),t(E),t(Dl),t(Ol),t($),t(le),t(ee),t(X),t(te),t(x),t(ae),t(H),t(se),t(ne),t(F),t(ie),t(L),t(Me),t(P),t(re),t(ye),t(oe),t(O),t(pe),t(ll),t(ue),t(me),t(Ue),t(Je),t(sl),t(ce),t(nl),t(je),t(il),t(de),t(Ml),t(Te),t(be),t(yl),t(we),t(ke),t(pl),t(Ce),t(ul),t(Ie),t(he),t(Ul),t(ge),t(fe),t(cl),t(Ze),t(jl),t(ve),t(Be),t(Ge),t(bl),t(Ae),t(ze),t(kl),t(We),t(Cl),t(Ve),t(Il),t(Re),t(_e),t(fl)),t(c),U(d,l),U(T,l),U(b,l),U(Z,l),U(v,l),U(z,l),U(V,l),U(S,l),U(Y,l),U(q,l),U(K,l),U(D,l),U(el,l),U(tl,l),U(al,l),U(rl,l),U(ol,l),U(ml,l),U(Jl,l),U(dl,l),U(Tl,l),U(wl,l),U(hl,l)}}}const Qt='{"title":"Transformers Agents kullanarak, tool-calling süper güçleriyle donatılmış bir ajan oluşturun 🦸","local":"transformers-agents-kullanarak-tool-calling-süper-güçleriyle-donatılmış-bir-ajan-oluşturun-","sections":[{"title":"1. 🏞️ Çok Modlu + 🌐 Web tarayıcı asistanı","local":"1--çok-modlu---web-tarayıcı-asistanı","sections":[],"depth":2},{"title":"2. 📚💬 RAG ile yinelemeli sorgu iyileştirme ve kaynak seçimi","local":"2--rag-ile-yinelemeli-sorgu-iyileştirme-ve-kaynak-seçimi","sections":[{"title":"Opsiyonel: Retriever aracınızı Hub’da paylaşın","local":"opsiyonel-retriever-aracınızı-hubda-paylaşın","sections":[],"depth":3},{"title":"Ajanı çalıştırın!","local":"ajanı-çalıştırın","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Python Kodunda Hata Ayıklama","local":"3--python-kodunda-hata-ayıklama","sections":[],"depth":2},{"title":"4. Kendi LLM motorunuzu oluşturun (OpenAI)","local":"4-kendi-llm-motorunuzu-oluşturun-openai","sections":[],"depth":2},{"title":"➡️ Son olarak","local":"-son-olarak","sections":[],"depth":2}],"depth":1}';function Nt(Ne){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Bt{constructor(c){super(),Gt(this,c,Nt,_t,ft,{})}}export{Xt as component};
