# Veri Analizi Ajanı: Göz açıp kapayıncaya kadar verilerinizi analiz edin ✨
Yazar: [Aymeric Roucher](https://huggingface.co/m-ric)

Bu eğitim ileri düzey konular içermektedir. Bu eğitim içeriğinden önce Cookbook'ta yer alan [Ajan eğitimine](https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb) bakmanızı öneririz.

Bu notebook ile bir veri analisti ajanı oluşturacağız: Veri analizi kütüphaneleri ile donatılmış ve Dataframelerden sonuçlar çıkartabilen ve bu sonuçları grafiklerle gösterebilen bir ajan.

[Kaggle Titanic yarışmasındaki](https://www.kaggle.com/competitions/titanic) verileri analiz ederek yolcuların hayatta kalma olasılıklarını tahmin etmek istediğimizi düşünelim.

Ama bu konuya başlamadan önce, otomatik bir ajanın trendleri çıkararak ve bazı grafikler çizerek analiz hazırlamasını istiyorum.

Bu sistemi kuralım.

Gerekli kütüphane gereksinimlerini yüklemek için aşağıdaki kodu çalıştıracağız:


```python
!pip install seaborn "transformers[agents]"
```

İlk olarak `ReactCodeAgent` kullanarak bir ajan oluşturacağız. (Ajan türleri hakkında daha fazla bilgi edinmek için bu [dökümantasyonu](https://huggingface.co/docs/transformers/en/agents) okuyabilirsiniz.)

ReactCodeAgent kodu doğrudan çalıştırabilir dolayısı ile herhangi farklı bir araç kullanmamıza gerek yoktur.

Veri bilimiyle ilgili kütüphaneleri kullanmasına izin verdiğimizden emin olmak için `["numpy", "pandas", "matplotlib.pyplot", "seaborn"]` kütüphanelerini `"additional_authorized_imports"` parametresi ile aktarıyoruz.

Python yorumlayıcısı yalnızca çalışma ortamında yüklü kütüphaneleri kullanabilir. Bu sebeple `"additional_authorized_imports"` parametresine aktardığımız kütüphanelerin çalışma ortamınızda kurulu olduğundan emin olun.

⚙ Ajanımızı, `HfEngine` sınıfı aracılığıyla HF'nin Inference API'sini kullanan [meta-llama/Meta-Llama-3.1-70B-Instruct](https://huggingface.co/meta-llama/Llama-3.1-70B-Instruct) modeliyle çalıştıracağız. Inference API, herhangi bir açık kaynak modelini hızlı ve kolay bir şekilde çalıştırmamıza olanak tanır.










```python
from transformers.agents import HfEngine, ReactCodeAgent
from huggingface_hub import login
import os

login(os.getenv("HUGGINGFACEHUB_API_TOKEN"))

llm_engine = HfEngine("meta-llama/Meta-Llama-3.1-70B-Instruct")

agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    additional_authorized_imports=["numpy", "pandas", "matplotlib.pyplot", "seaborn"],
    max_iterations=10,
)
```

## Veri analizi 📊🤔

Yarışmadan alınan notları fonksiyona argüman olarak verelim ve ajanımızı `run` methodu ile çalıştıralım.

```python
import os

os.mkdir("./figures")
```

```python
"""
## Değişken notları
pclass: Sosyo-ekonomik durumu (SES) temsil eden bir gösterge
1.sınıf = Üst
2.sınıf = Orta
3.sınıf = Alt

age: Yaş, 1'den küçükse kesirli bir değerdir. Eğer yaş tahmin ediliyorsa, xx.5 şeklindedir.

sibsp: Veri seti aile ilişkilerini şu şekilde tanımlar...
Kardeş = erkek kardeş, kız kardeş, üvey erkek kardeş, üvey kız kardeş, Eş = koca, karı (nişanlılar göz ardı edilmiştir)

parch: Veri seti aile ilişkilerini şu şekilde tanımlar...
Ebeveyn = anne, baba, Çocuk = kız, oğul, üvey kız, üvey oğul
Bazı çocuklar yalnızca bir bakıcıyla seyahat ettikleri için, bu durumda parch=0'dır.
"""
additional_notes = """
### Variable Notes
pclass: A proxy for socio-economic status (SES)
1st = Upper
2nd = Middle
3rd = Lower
age: Age is fractional if less than 1. If the age is estimated, is it in the form of xx.5
sibsp: The dataset defines family relations in this way...
Sibling = brother, sister, stepbrother, stepsister
Spouse = husband, wife (mistresses and fiancés were ignored)
parch: The dataset defines family relations in this way...
Parent = mother, father
Child = daughter, son, stepdaughter, stepson
Some children travelled only with a nanny, therefore parch=0 for them.
"""

"""
Sen bir veri analizi uzmanısın.
Lütfen kaynak dosyasını yükle ve içeriğini analiz et.
Elindeki değişkenlere göre, bu verilerle ilgili sorulabilecek 3 ilginç soru listele, örneğin hayatta kalma oranlarıyla belirli korelasyonlar hakkında.
Sonra bu soruları, ilgili sayıları bularak teker teker yanıtla.
Bu arada, matplotlib/seaborn kullanarak bazı grafikler çiz ve bunları (zaten mevcut olan) './figures/' klasörüne kaydet: Her grafiği çizmeden önce plt.clf() ile temizlemeyi unutma.

Sonuçlarınızda: bu korelasyonları ve trendleri özetleyin.
Her sayının ardından gerçek dünya içgörüleri çıkarın; örneğin: "is_december ile boredness arasındaki korelasyon 1.3453'tür, bu da insanların kışın daha çok sıkıldığını gösterir."
Sonuçlarınız en az 3 numaralı ve ayrıntılı parça içermelidir.
"""
analysis = agent.run(
    """You are an expert data analyst.
Please load the source file and analyze its content.
According to the variables you have, begin by listing 3 interesting questions that could be asked on this data, for instance about specific correlations with survival rate.
Then answer these questions one by one, by finding the relevant numbers.
Meanwhile, plot some figures using matplotlib/seaborn and save them to the (already existing) folder './figures/': take care to clear each figure with plt.clf() before doing another plot.

In your final answer: summarize these correlations and trends
After each number derive real worlds insights, for instance: "Correlation between is_december and boredness is 1.3453, which suggest people are more bored in winter".
Your final answer should have at least 3 numbered and detailed parts.
""",
    additional_notes=additional_notes,
    source_file="titanic/train.csv",
)
```

```python
print(analysis)
```

Etkileyici, değil mi? Ajanınıza kendi grafiklerini gözden geçirmesi için bir görselleştirme aracı da sağlayabilirsiniz!

## Veri bilimi ajanı: Tahminleri çalıştır 🛠️👉
**Modelimizin veriler üzerinde tahminler yapmasına izin vererek** bir adım daha ilerleyelim.

Bunu yapmak için, `additional_authorized_imports` içinde `sklearn` kullanımına da izin veriyoruz.

```python
agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    additional_authorized_imports=[
        "numpy",
        "pandas",
        "matplotlib.pyplot",
        "seaborn",
        "sklearn",
    ],
    max_iterations=12,
)
"""
Sen bir ML uzmanısın.
Lütfen "titanic/train.csv" dosyası üzerinde hayatta kalmayı tahmin etmek için bir ML modeli eğit.
Sonuçları './output.csv' dosyasına yaz.
Kullanımdan önce fonksiyonları ve modülleri içe aktarmayı unutma!
"""
output = agent.run(
    """You are an expert machine learning engineer.
Please train a ML model on "titanic/train.csv" to predict the survival for rows of "titanic/test.csv".
Output the results under './output.csv'.
Take care to import functions and modules before using them!
""",
    additional_notes=additional_notes + "\n" + analysis,
)
```

Ajanımızın çıkardığı test çıktıları, Kaggle'a gönderildiğinde 0.78229 puan alıyor ve 17,360 sonuç arasından #2824 sıraya yerleşiyor.

Bu sonuç, yazarın yıllar önce bu yarışmaya ilk girdiğinde elde ettiği sonuçtan çok daha iyi bir sonuçtur.

Sonuçlarınız değişebilir, ancak yine de ajanın birkaç saniyede bu sonucu başarması gerçekten etkileyici.

🚀 Veri analisti ajanı ile sadece basit bir deneme yaptık. Kullanım durumunuza daha iyi uyacak şekilde çok daha fazla geliştirebilirsiniz.

<EditOnGithub source="https://github.com/huggingface/cookbook/blob/main/notebooks/tr/agent_data_analyst.md" />