import{s as Mt,n as pt,o as mt}from"../chunks/scheduler.1f027d5a.js";import{S as rt,i as yt,e as o,s as n,c as p,h as ct,a as i,d as t,b as a,f as ot,g as m,j as M,k as it,l as dt,m as s,n as r,t as y,o as c,p as d}from"../chunks/index.6117a65d.js";import{C as wt}from"../chunks/CopyLLMTxtMenu.93325501.js";import{D as Jt,C as w}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as J,E as jt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function ht(Gl){let j,be,Ue,Ie,h,fe,u,Ce,T,Ze,U,vl='作者: <a href="https://huggingface.co/RichmondMongo" rel="nofollow">Richmond Alake</a>',Be,g,Ge,b,Wl="这些命令是用来安装一些软件包的，这些软件包可以帮助你使用和操作 LLMs，处理数据，并且和数据库进行交流。这些库简化了RAG系统的开发，将复杂性减少到少量的代码：",ve,I,$l="<li>PyMongo：一个用于与 MongoDB 交互的 Python 库，它提供了连接到集群和查询存储在集合和文档中的数据的功能。</li> <li>Pandas：提供了一个数据结构，用于使用 Python 进行高效的数据处理和分析。</li> <li>Hugging Face datasets：包含音频、视觉和文本数据集。</li> <li>Hugging Face Accelerate：抽象了编写利用硬件加速器（如GPU）的代码的复杂性。在实现中，利用 Accelerate 在 GPU 资源上利用 Gemma 模型。</li> <li>Hugging Face Transformers：访问大量预训练模型。</li> <li>Hugging Face Sentence Transformers：提供对句子、文本和图像嵌入的访问。</li>",We,f,$e,C,Ae,Z,Al='本教程使用的数据来源于 Hugging Face datasets，具体是 <a href="https://huggingface.co/datasets/AIatMongoDB/embedded_movies" rel="nofollow">AIatMongoDB/embedded_movies 数据集</a>。',Re,B,ke,G,Rl="以下代码片段中的操作侧重于确保数据的完整性和质量。",Ve,v,kl="<li>第一个过程确保每个数据点的 <code>fullplot</code> 属性不为空，因为这是我们嵌入过程中主要使用的数据。</li> <li>这一步还确保我们移除所有数据点的 <code>plot_embedding</code> 属性，因为这将被一个不同的嵌入模型 <code>gte-large</code> 创建的新嵌入所替换。</li>",Qe,W,_e,$,Vl=`Number of missing values in each column after removal:
num_mflix_comments      0
genres                  0
countries               0
directors              12
fullplot                0
writers                13
awards                  0
runtime                14
type                    0
rated                 279
metacritic            893
poster                 78
languages               1
imdb                    0
plot                    0
cast                    1
plot_embedding          1
title                   0
dtype: int64
`,Ne,A,Ee,R,Ql="<strong>代码片段中的步骤如下：</strong>",Se,k,_l="<li>导入 <code>SentenceTransformer</code> 类以访问嵌入模型。</li> <li>使用 <code>SentenceTransformer</code> 构造函数加载嵌入模型，以实例化 <code>gte-large</code> 嵌入模型。</li> <li>定义 <code>get_embedding</code> 函数，该函数接受一个文本字符串作为输入，并返回一个代表嵌入的浮点数列表。该函数首先检查输入文本是否为空（去除空白后）。如果文本为空，则返回一个空列表。否则，它使用加载的模型生成嵌入。</li> <li>通过将 <code>get_embedding</code> 函数应用于 <code>dataset_df</code> DataFrame 的 “fullplot” 列，为每个电影的剧情生成嵌入。生成的嵌入列表被分配到一个名为 embedding 的新列中。</li>",Xe,V,Nl="<em>注意：由于我们可以确保文本长度保持在可管理的范围内，因此不需要对完整剧情文本进行分块处理。</em>",qe,Q,xe,_,Ye,N,El="MongoDB 既是一个操作数据库，也是一个向量数据库。它提供了一个数据库解决方案，有效地存储、查询和检索向量嵌入。其优势在于数据库维护、管理和成本的简单性。",He,E,Sl="<strong>创建新的 MongoDB 数据库，设置数据库集群：</strong>",Fe,S,Xl='<li><p>前往MongoDB官网，注册一个<a href="https://www.mongodb.com/cloud/atlas/register?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alake" rel="nofollow">免费的 MongoDB Atlas 账户</a>，或者对于现有用户，<a href="https://account.mongodb.com/account/login?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alakee" rel="nofollow">登录 MongoDB Atlas</a>。</p></li> <li><p>在左侧窗格中选择 ‘Database’ 选项，这将导航到数据库部署页面，你可以在其中查看任何现有集群的部署规格。点击 “+Create” 按钮，创建一个新的数据库集群。</p></li> <li><p>选择适用于数据库集群的所有配置。选择所有配置选项后，点击 “Create Cluster” 按钮以部署新创建的集群。MongoDB 还在 “Shared Tab” 上启用了免费集群的创建。</p> <p><em>注意：创建概念证明时，不要忘记将 Python 主机的 IP 列入白名单，或设置 0.0.0.0/0 用于任何IP。</em></p></li> <li><p>成功创建和部署集群后，集群将在 ‘Database Deployment’ 页面中变得可访问。</p></li> <li><p>点击集群的 “Connect” 按钮，查看通过各种语言驱动程序设置与集群的连接的选项。</p></li> <li><p>本教程只需要集群的 URI（唯一资源标识符）。获取 URI 并将其复制到 Google Colabs Secrets 环境中的名为 <code>MONGO_URI</code> 的变量中，或者将其放入 .env 文件或等效文件中。</p></li>',ze,X,Pe,q,ql="在继续之前，请确保满足以下先决条件",De,x,xl="<li>在 MongoDB Atlas 上设置数据库集群</li> <li>获取到你的集群的 URI</li>",Le,Y,Yl='有关数据库集群设置和获取 URI 的帮助，请参阅我们的指南：<a href="https://www.mongodb.com/docs/guides/atlas/cluster/" rel="nofollow">设置 MongoDB 集群</a>和<a href="https://www.mongodb.com/docs/guides/atlas/connection-string/" rel="nofollow">获取你的连接字符串</a>',Ke,H,Hl="创建集群后，通过在集群概览页面点击+创建数据库，在 MongoDB Atlas 集群中创建数据库和集合。",Oe,F,Fl=`这里有关于<a href="https://www.mongodb.com/basics/create-database" rel="nofollow">创建数据库和集合</a>的指南
<strong>数据库将被命名为 <code>movies</code>。</strong> <strong>集合将被命名为 <code>movie_collection_2</code>。</strong>`,el,z,ll,P,zl="在这一点上，请确保你的向量索引是通过 MongoDB Atlas 创建的。",tl,D,Pl="接下来，你必须做一个非常重要的步骤，那就是在 <code>movie_collection_2</code> 这个数据库的文档里，为那些用来表示电影特点的向量建立一个特殊的搜索索引。这个索引就像是图书馆里的图书索引卡，它帮助计算机快速准确地找到与你的搜索最相似的电影向量。没有这个索引，计算机就得一篇一篇地翻找，效率会非常低。所以，建立这个索引是为了让搜索变得又快又准。",sl,L,Dl='点击此处了解更多关于<a href="https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/" rel="nofollow">MongoDB 向量搜索索引</a>的信息。',nl,K,al,O,Ll="<code>numDimensions</code> 字段的 <code>1024</code> 值对应于由 gte-large 嵌入模型生成的向量的维度。如果你使用 <code>gte-base</code> 或 <code>gte-small</code> 嵌入模型，向量搜索索引中的 numDimensions 值必须分别设置为 768 和 384。",ol,ee,il,le,Kl="下面的代码片段还使用了 PyMongo 来创建一个 MongoDB 客户端对象，该对象代表与集群的连接，并允许访问其数据库和集合。",Ml,te,pl,se,Ol=`Connection to MongoDB successful
`,ml,ne,rl,ae,et="从 pandas DataFrame 中将数据导入 MongoDB 集合是一个简单的过程，可以通过将 DataFrame 转换为字典，然后在集合上使用 <code>insert_many</code> 方法来传递转换后的数据集记录，从而高效完成。",yl,oe,cl,ie,lt=`Data ingestion into MongoDB completed
`,dl,Me,wl,pe,tt="下一步实现了一个函数，该函数通过生成查询嵌入并定义一个 MongoDB 聚合流水线来返回一个向量搜索结果。",Jl,me,st="该流水线包括 <code>$vectorSearch</code> 和 <code>$project</code> 阶段，它使用生成的向量执行查询，并格式化结果以仅包括所需信息，如剧情、标题和类型，同时为每个结果引入一个搜索分数。",jl,re,hl,ye,ul,ce,Tl,de,Ul,we,nt=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as "Pearl Harbor."
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo & Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.
`,gl,Je,bl,je,Il,he,at=`<bos>Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara&#39;s uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as &quot;Pearl Harbor.&quot;
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship&#39;s maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne&#39;er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo &amp; Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.

Based on the search results, the best romantic movie to watch is **Shut Up and Kiss Me!** because it is a romantic comedy that explores the complexities of love and relationships. The movie is funny, heartwarming, and thought-provoking.<eos>
</eos></bos>`,fl,ue,Cl,Te,Zl,ge,Bl;return h=new Jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hugging_face_gemma_mongodb.ipynb"}]}}),u=new wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new J({props:{title:"用 Gemma, MongoDB 和开源模型构建 RAG 系统",local:"用-gemma-mongodb-和开源模型构建-rag-系统",headingTag:"h1"}}),g=new J({props:{title:"第一步：安装库",local:"第一步安装库",headingTag:"h2"}}),f=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHB5bW9uZ28lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMEEhcGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwSW5zdGFsbCUyMGJlbG93JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:`!pip install datasets pandas pymongo sentence_transformers
!pip install -U transformers
<span class="hljs-comment"># Install below if using GPU</span>
!pip install accelerate`,wrap:!1}}),C=new J({props:{title:"第二步：数据源选择和准备",local:"第二步数据源选择和准备",headingTag:"h2"}}),B=new w({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGQUlhdE1vbmdvREIlMkZlbWJlZGRlZF9tb3ZpZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFJYXRNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0aGUlMjBkYXRhc2V0JTIwdG8lMjBhJTIwcGFuZGFzJTIwZGF0YWZyYW1lJTBBZGF0YXNldF9kZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBZGF0YXNldF9kZi5oZWFkKDUp",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># https://huggingface.co/datasets/AIatMongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;AIatMongoDB/embedded_movies&quot;</span>)

<span class="hljs-comment"># Convert the dataset to a pandas dataframe</span>
dataset_df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),W=new w({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3BuYShzdWJzZXQlM0QlNUIlMjJmdWxscGxvdCUyMiU1RCklMEFwcmludCglMjIlNUNuTnVtYmVyJTIwb2YlMjBtaXNzaW5nJTIwdmFsdWVzJTIwaW4lMjBlYWNoJTIwY29sdW1uJTIwYWZ0ZXIlMjByZW1vdmFsJTNBJTIyKSUwQXByaW50KGRhdGFzZXRfZGYuaXNudWxsKCkuc3VtKCkpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwcGxvdF9lbWJlZGRpbmclMjBmcm9tJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMGluJTIwdGhlJTIwZGF0YXNldCUyMGFzJTIwd2UlMjBhcmUlMjBnb2luZyUyMHRvJTIwY3JlYXRlJTIwbmV3JTIwZW1iZWRkaW5ncyUyMHdpdGglMjBhbiUyMG9wZW4lMjBzb3VyY2UlMjBlbWJlZGRpbmclMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3AoY29sdW1ucyUzRCU1QiUyMnBsb3RfZW1iZWRkaW5nJTIyJTVEKSUwQWRhdGFzZXRfZGYuaGVhZCg1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Data Preparation</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.dropna(subset=[<span class="hljs-string">&quot;fullplot&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nNumber of missing values in each column after removal:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset_df.isnull().<span class="hljs-built_in">sum</span>())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.drop(columns=[<span class="hljs-string">&quot;plot_embedding&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),A=new J({props:{title:"第三步：生成嵌入",local:"第三步生成嵌入",headingTag:"h2"}}),Q=new w({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGhlbmxwZXIlMkZndGUtbGFyZ2UlMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMnRoZW5scGVyJTJGZ3RlLWxhcmdlJTIyKSUwQSUwQSUwQWRlZiUyMGdldF9lbWJlZGRpbmcodGV4dCUzQSUyMHN0ciklMjAtJTNFJTIwbGlzdCU1QmZsb2F0JTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjB0ZXh0LnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJBdHRlbXB0ZWQlMjB0byUyMGdldCUyMGVtYmVkZGluZyUyMGZvciUyMGVtcHR5JTIwdGV4dC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTIwJTNEJTIwZW1iZWRkaW5nX21vZGVsLmVuY29kZSh0ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZy50b2xpc3QoKSUwQSUwQSUwQWRhdGFzZXRfZGYlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjBkYXRhc2V0X2RmJTVCJTIyZnVsbHBsb3QlMjIlNUQuYXBwbHkoZ2V0X2VtYmVkZGluZyklMEElMEFkYXRhc2V0X2RmLmhlYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># https://huggingface.co/thenlper/gte-large</span>
embedding_model = SentenceTransformer(<span class="hljs-string">&quot;thenlper/gte-large&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
        <span class="hljs-keyword">return</span> []

    embedding = embedding_model.encode(text)

    <span class="hljs-keyword">return</span> embedding.tolist()


dataset_df[<span class="hljs-string">&quot;embedding&quot;</span>] = dataset_df[<span class="hljs-string">&quot;fullplot&quot;</span>].apply(get_embedding)

dataset_df.head()`,wrap:!1}}),_=new J({props:{title:"第4步：数据库设置和连接",local:"第4步数据库设置和连接",headingTag:"h2"}}),X=new J({props:{title:"4.1 数据库和集合设置",local:"41-数据库和集合设置",headingTag:"h3"}}),z=new J({props:{title:"第5步：创建向量搜索索引",local:"第5步创建向量搜索索引",headingTag:"h2"}}),K=new w({props:{code:"JTdCJTBBJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIybnVtRGltZW5zaW9ucyUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJwYXRoJTIyJTNBJTIwJTIyZW1iZWRkaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyc2ltaWxhcml0eSUyMiUzQSUyMCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ2ZWN0b3IlMjIlMEElMjAlMjAlMjAlN0QlNUQlMEElN0Q=",highlighted:`{
 <span class="hljs-string">&quot;fields&quot;</span>: [{
     <span class="hljs-string">&quot;numDimensions&quot;</span>: <span class="hljs-number">1024</span>,
     <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
     <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
     <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;vector&quot;</span>
   }]
}`,wrap:!1}}),ee=new J({props:{title:"第6步：建立数据连接",local:"第6步建立数据连接",headingTag:"h2"}}),te=new w({props:{code:"aW1wb3J0JTIwcHltb25nbyUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQSUwQSUwQWRlZiUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkVzdGFibGlzaCUyMGNvbm5lY3Rpb24lMjB0byUyMHRoZSUyME1vbmdvREIuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwcHltb25nby5Nb25nb0NsaWVudChtb25nb191cmkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29ubmVjdGlvbiUyMHRvJTIwTW9uZ29EQiUyMHN1Y2Nlc3NmdWwlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2xpZW50JTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwcHltb25nby5lcnJvcnMuQ29ubmVjdGlvbkZhaWx1cmUlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyQ29ubmVjdGlvbiUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUwQSUwQSUwQW1vbmdvX3VyaSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBaWYlMjBub3QlMjBtb25nb191cmklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJNT05HT19VUkklMjBub3QlMjBzZXQlMjBpbiUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIyKSUwQSUwQW1vbmdvX2NsaWVudCUyMCUzRCUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUwQSUwQSUyMyUyMEluZ2VzdCUyMGRhdGElMjBpbnRvJTIwTW9uZ29EQiUwQWRiJTIwJTNEJTIwbW9uZ29fY2xpZW50JTVCJTIybW92aWVzJTIyJTVEJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRiJTVCJTIybW92aWVfY29sbGVjdGlvbl8yJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pymongo
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_mongo_client</span>(<span class="hljs-params">mongo_uri</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Establish connection to the MongoDB.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        client = pymongo.MongoClient(mongo_uri)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Connection to MongoDB successful&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> pymongo.errors.ConnectionFailure <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Connection failed: <span class="hljs-subst">{e}</span>&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


<span class="hljs-meta">... </span>mongo_uri = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> mongo_uri:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;MONGO_URI not set in environment variables&quot;</span>)

<span class="hljs-meta">... </span>mongo_client = get_mongo_client(mongo_uri)

<span class="hljs-meta">... </span><span class="hljs-comment"># Ingest data into MongoDB</span>
<span class="hljs-meta">... </span>db = mongo_client[<span class="hljs-string">&quot;movies&quot;</span>]
<span class="hljs-meta">... </span>collection = db[<span class="hljs-string">&quot;movie_collection_2&quot;</span>]`,wrap:!1}}),ne=new w({props:{code:"JTIzJTIwRGVsZXRlJTIwYW55JTIwZXhpc3RpbmclMjByZWNvcmRzJTIwaW4lMjB0aGUlMjBjb2xsZWN0aW9uJTBBY29sbGVjdGlvbi5kZWxldGVfbWFueSglN0IlN0Qp",highlighted:`<span class="hljs-comment"># Delete any existing records in the collection</span>
collection.delete_many({})`,wrap:!1}}),oe=new w({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldF9kZi50b19kaWN0KCUyMnJlY29yZHMlMjIpJTBBY29sbGVjdGlvbi5pbnNlcnRfbWFueShkb2N1bWVudHMpJTBBJTBBcHJpbnQoJTIyRGF0YSUyMGluZ2VzdGlvbiUyMGludG8lMjBNb25nb0RCJTIwY29tcGxldGVkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>documents = dataset_df.to_dict(<span class="hljs-string">&quot;records&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.insert_many(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into MongoDB completed&quot;</span>)`,wrap:!1}}),Me=new J({props:{title:"第7步：对用户查询执行向量搜索",local:"第7步对用户查询执行向量搜索",headingTag:"h2"}}),re=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">user_query, collection</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Perform a vector search in the MongoDB collection based on the user query.

    Args:
    user_query (str): The user&#x27;s query string.
    collection (MongoCollection): The MongoDB collection to search.

    Returns:
    list: A list of matching documents.
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate embedding for the user query</span>
    query_embedding = get_embedding(user_query)

    <span class="hljs-keyword">if</span> query_embedding <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Invalid query or embedding generation failed.&quot;</span>

    <span class="hljs-comment"># Define the vector search pipeline</span>
    pipeline = [
        {
            <span class="hljs-string">&quot;$vectorSearch&quot;</span>: {
                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;vector_index&quot;</span>,
                <span class="hljs-string">&quot;queryVector&quot;</span>: query_embedding,
                <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
                <span class="hljs-string">&quot;numCandidates&quot;</span>: <span class="hljs-number">150</span>,  <span class="hljs-comment"># Number of candidate matches to consider</span>
                <span class="hljs-string">&quot;limit&quot;</span>: <span class="hljs-number">4</span>,  <span class="hljs-comment"># Return top 4 matches</span>
            }
        },
        {
            <span class="hljs-string">&quot;$project&quot;</span>: {
                <span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-number">0</span>,  <span class="hljs-comment"># Exclude the _id field</span>
                <span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the plot field</span>
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the title field</span>
                <span class="hljs-string">&quot;genres&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the genres field</span>
                <span class="hljs-string">&quot;score&quot;</span>: {<span class="hljs-string">&quot;$meta&quot;</span>: <span class="hljs-string">&quot;vectorSearchScore&quot;</span>},  <span class="hljs-comment"># Include the search score</span>
            }
        },
    ]

    <span class="hljs-comment"># Execute the search</span>
    results = collection.aggregate(pipeline)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(results)`,wrap:!1}}),ye=new J({props:{title:"第 8 步：处理用户查询和加载 Gemma",local:"第-8-步处理用户查询和加载-gemma",headingTag:"h2"}}),ce=new w({props:{code:"ZGVmJTIwZ2V0X3NlYXJjaF9yZXN1bHQocXVlcnklMkMlMjBjb2xsZWN0aW9uKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGdldF9rbm93bGVkZ2UlMjAlM0QlMjB2ZWN0b3Jfc2VhcmNoKHF1ZXJ5JTJDJTIwY29sbGVjdGlvbiklMEElMEElMjAlMjAlMjAlMjBzZWFyY2hfcmVzdWx0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVzdWx0JTIwaW4lMjBnZXRfa25vd2xlZGdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUyQiUzRCUyMGYlMjJUaXRsZSUzQSUyMCU3QnJlc3VsdC5nZXQoJ3RpdGxlJyUyQyUyMCdOJTJGQScpJTdEJTJDJTIwUGxvdCUzQSUyMCU3QnJlc3VsdC5nZXQoJ2Z1bGxwbG90JyUyQyUyMCdOJTJGQScpJTdEJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlYXJjaF9yZXN1bHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_search_result</span>(<span class="hljs-params">query, collection</span>):

    get_knowledge = vector_search(query, collection)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),de=new w({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFzb3VyY2VfaW5mb3JtYXRpb24lMjAlM0QlMjBnZXRfc2VhcmNoX3Jlc3VsdChxdWVyeSUyQyUyMGNvbGxlY3Rpb24pJTBBY29tYmluZWRfaW5mb3JtYXRpb24lMjAlM0QlMjBmJTIyUXVlcnklM0ElMjAlN0JxdWVyeSU3RCU1Q25Db250aW51ZSUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwcXVlcnklMjBieSUyMHVzaW5nJTIwdGhlJTIwU2VhcmNoJTIwUmVzdWx0cyUzQSU1Q24lN0Jzb3VyY2VfaW5mb3JtYXRpb24lN0QuJTIyJTBBJTBBcHJpbnQoY29tYmluZWRfaW5mb3JtYXRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_information = get_search_result(query, collection)
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_information = <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using the Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_information)`,wrap:!1}}),Je=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;)</span>
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),je=new w({props:{code:"JTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFyZXNwb25zZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MDApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShyZXNwb25zZSU1QjAlNUQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">500</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(response[<span class="hljs-number">0</span>]))`,wrap:!1}}),ue=new w({props:{code:"",highlighted:"",wrap:!1}}),Te=new jt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hugging_face_gemma_mongodb.md"}}),{c(){j=o("meta"),be=n(),Ue=o("p"),Ie=n(),p(h.$$.fragment),fe=n(),p(u.$$.fragment),Ce=n(),p(T.$$.fragment),Ze=n(),U=o("p"),U.innerHTML=vl,Be=n(),p(g.$$.fragment),Ge=n(),b=o("p"),b.textContent=Wl,ve=n(),I=o("ul"),I.innerHTML=$l,We=n(),p(f.$$.fragment),$e=n(),p(C.$$.fragment),Ae=n(),Z=o("p"),Z.innerHTML=Al,Re=n(),p(B.$$.fragment),ke=n(),G=o("p"),G.textContent=Rl,Ve=n(),v=o("ol"),v.innerHTML=kl,Qe=n(),p(W.$$.fragment),_e=n(),$=o("pre"),$.textContent=Vl,Ne=n(),p(A.$$.fragment),Ee=n(),R=o("p"),R.innerHTML=Ql,Se=n(),k=o("ol"),k.innerHTML=_l,Xe=n(),V=o("p"),V.innerHTML=Nl,qe=n(),p(Q.$$.fragment),xe=n(),p(_.$$.fragment),Ye=n(),N=o("p"),N.textContent=El,He=n(),E=o("p"),E.innerHTML=Sl,Fe=n(),S=o("ol"),S.innerHTML=Xl,ze=n(),p(X.$$.fragment),Pe=n(),q=o("p"),q.textContent=ql,De=n(),x=o("ul"),x.innerHTML=xl,Le=n(),Y=o("p"),Y.innerHTML=Yl,Ke=n(),H=o("p"),H.textContent=Hl,Oe=n(),F=o("p"),F.innerHTML=Fl,el=n(),p(z.$$.fragment),ll=n(),P=o("p"),P.textContent=zl,tl=n(),D=o("p"),D.innerHTML=Pl,sl=n(),L=o("p"),L.innerHTML=Dl,nl=n(),p(K.$$.fragment),al=n(),O=o("p"),O.innerHTML=Ll,ol=n(),p(ee.$$.fragment),il=n(),le=o("p"),le.textContent=Kl,Ml=n(),p(te.$$.fragment),pl=n(),se=o("pre"),se.textContent=Ol,ml=n(),p(ne.$$.fragment),rl=n(),ae=o("p"),ae.innerHTML=et,yl=n(),p(oe.$$.fragment),cl=n(),ie=o("pre"),ie.textContent=lt,dl=n(),p(Me.$$.fragment),wl=n(),pe=o("p"),pe.textContent=tt,Jl=n(),me=o("p"),me.innerHTML=st,jl=n(),p(re.$$.fragment),hl=n(),p(ye.$$.fragment),ul=n(),p(ce.$$.fragment),Tl=n(),p(de.$$.fragment),Ul=n(),we=o("pre"),we.textContent=nt,gl=n(),p(Je.$$.fragment),bl=n(),p(je.$$.fragment),Il=n(),he=o("pre"),he.innerHTML=at,fl=n(),p(ue.$$.fragment),Cl=n(),p(Te.$$.fragment),Zl=n(),ge=o("p"),this.h()},l(e){const l=ct("svelte-u9bgzb",document.head);j=i(l,"META",{name:!0,content:!0}),l.forEach(t),be=a(e),Ue=i(e,"P",{}),ot(Ue).forEach(t),Ie=a(e),m(h.$$.fragment,e),fe=a(e),m(u.$$.fragment,e),Ce=a(e),m(T.$$.fragment,e),Ze=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1vszw9g"&&(U.innerHTML=vl),Be=a(e),m(g.$$.fragment,e),Ge=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-u6la52"&&(b.textContent=Wl),ve=a(e),I=i(e,"UL",{"data-svelte-h":!0}),M(I)!=="svelte-iqfcsi"&&(I.innerHTML=$l),We=a(e),m(f.$$.fragment,e),$e=a(e),m(C.$$.fragment,e),Ae=a(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1gfpttb"&&(Z.innerHTML=Al),Re=a(e),m(B.$$.fragment,e),ke=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-ngtyyl"&&(G.textContent=Rl),Ve=a(e),v=i(e,"OL",{"data-svelte-h":!0}),M(v)!=="svelte-10co0v6"&&(v.innerHTML=kl),Qe=a(e),m(W.$$.fragment,e),_e=a(e),$=i(e,"PRE",{"data-svelte-h":!0}),M($)!=="svelte-kp0u3c"&&($.textContent=Vl),Ne=a(e),m(A.$$.fragment,e),Ee=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-12iz6l2"&&(R.innerHTML=Ql),Se=a(e),k=i(e,"OL",{"data-svelte-h":!0}),M(k)!=="svelte-1faddxl"&&(k.innerHTML=_l),Xe=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-uxqg8f"&&(V.innerHTML=Nl),qe=a(e),m(Q.$$.fragment,e),xe=a(e),m(_.$$.fragment,e),Ye=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-8l9pnm"&&(N.textContent=El),He=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-6ptxn4"&&(E.innerHTML=Sl),Fe=a(e),S=i(e,"OL",{"data-svelte-h":!0}),M(S)!=="svelte-1mveug4"&&(S.innerHTML=Xl),ze=a(e),m(X.$$.fragment,e),Pe=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-gtitnq"&&(q.textContent=ql),De=a(e),x=i(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-1ppslbn"&&(x.innerHTML=xl),Le=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-2mkqud"&&(Y.innerHTML=Yl),Ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-u5d956"&&(H.textContent=Hl),Oe=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-otqthu"&&(F.innerHTML=Fl),el=a(e),m(z.$$.fragment,e),ll=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-uj2n3d"&&(P.textContent=zl),tl=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1cjc449"&&(D.innerHTML=Pl),sl=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1h6byj8"&&(L.innerHTML=Dl),nl=a(e),m(K.$$.fragment,e),al=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1wb5wve"&&(O.innerHTML=Ll),ol=a(e),m(ee.$$.fragment,e),il=a(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-450yot"&&(le.textContent=Kl),Ml=a(e),m(te.$$.fragment,e),pl=a(e),se=i(e,"PRE",{"data-svelte-h":!0}),M(se)!=="svelte-1im4pel"&&(se.textContent=Ol),ml=a(e),m(ne.$$.fragment,e),rl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-18w6gf8"&&(ae.innerHTML=et),yl=a(e),m(oe.$$.fragment,e),cl=a(e),ie=i(e,"PRE",{"data-svelte-h":!0}),M(ie)!=="svelte-48vgel"&&(ie.textContent=lt),dl=a(e),m(Me.$$.fragment,e),wl=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1aayevm"&&(pe.textContent=tt),Jl=a(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-eogwiv"&&(me.innerHTML=st),jl=a(e),m(re.$$.fragment,e),hl=a(e),m(ye.$$.fragment,e),ul=a(e),m(ce.$$.fragment,e),Tl=a(e),m(de.$$.fragment,e),Ul=a(e),we=i(e,"PRE",{"data-svelte-h":!0}),M(we)!=="svelte-kam1j9"&&(we.textContent=nt),gl=a(e),m(Je.$$.fragment,e),bl=a(e),m(je.$$.fragment,e),Il=a(e),he=i(e,"PRE",{"data-svelte-h":!0}),M(he)!=="svelte-146jypo"&&(he.innerHTML=at),fl=a(e),m(ue.$$.fragment,e),Cl=a(e),m(Te.$$.fragment,e),Zl=a(e),ge=i(e,"P",{}),ot(ge).forEach(t),this.h()},h(){it(j,"name","hf:doc:metadata"),it(j,"content",ut)},m(e,l){dt(document.head,j),s(e,be,l),s(e,Ue,l),s(e,Ie,l),r(h,e,l),s(e,fe,l),r(u,e,l),s(e,Ce,l),r(T,e,l),s(e,Ze,l),s(e,U,l),s(e,Be,l),r(g,e,l),s(e,Ge,l),s(e,b,l),s(e,ve,l),s(e,I,l),s(e,We,l),r(f,e,l),s(e,$e,l),r(C,e,l),s(e,Ae,l),s(e,Z,l),s(e,Re,l),r(B,e,l),s(e,ke,l),s(e,G,l),s(e,Ve,l),s(e,v,l),s(e,Qe,l),r(W,e,l),s(e,_e,l),s(e,$,l),s(e,Ne,l),r(A,e,l),s(e,Ee,l),s(e,R,l),s(e,Se,l),s(e,k,l),s(e,Xe,l),s(e,V,l),s(e,qe,l),r(Q,e,l),s(e,xe,l),r(_,e,l),s(e,Ye,l),s(e,N,l),s(e,He,l),s(e,E,l),s(e,Fe,l),s(e,S,l),s(e,ze,l),r(X,e,l),s(e,Pe,l),s(e,q,l),s(e,De,l),s(e,x,l),s(e,Le,l),s(e,Y,l),s(e,Ke,l),s(e,H,l),s(e,Oe,l),s(e,F,l),s(e,el,l),r(z,e,l),s(e,ll,l),s(e,P,l),s(e,tl,l),s(e,D,l),s(e,sl,l),s(e,L,l),s(e,nl,l),r(K,e,l),s(e,al,l),s(e,O,l),s(e,ol,l),r(ee,e,l),s(e,il,l),s(e,le,l),s(e,Ml,l),r(te,e,l),s(e,pl,l),s(e,se,l),s(e,ml,l),r(ne,e,l),s(e,rl,l),s(e,ae,l),s(e,yl,l),r(oe,e,l),s(e,cl,l),s(e,ie,l),s(e,dl,l),r(Me,e,l),s(e,wl,l),s(e,pe,l),s(e,Jl,l),s(e,me,l),s(e,jl,l),r(re,e,l),s(e,hl,l),r(ye,e,l),s(e,ul,l),r(ce,e,l),s(e,Tl,l),r(de,e,l),s(e,Ul,l),s(e,we,l),s(e,gl,l),r(Je,e,l),s(e,bl,l),r(je,e,l),s(e,Il,l),s(e,he,l),s(e,fl,l),r(ue,e,l),s(e,Cl,l),r(Te,e,l),s(e,Zl,l),s(e,ge,l),Bl=!0},p:pt,i(e){Bl||(y(h.$$.fragment,e),y(u.$$.fragment,e),y(T.$$.fragment,e),y(g.$$.fragment,e),y(f.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(A.$$.fragment,e),y(Q.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y(z.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(ye.$$.fragment,e),y(ce.$$.fragment,e),y(de.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(ue.$$.fragment,e),y(Te.$$.fragment,e),Bl=!0)},o(e){c(h.$$.fragment,e),c(u.$$.fragment,e),c(T.$$.fragment,e),c(g.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(A.$$.fragment,e),c(Q.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(ye.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(Je.$$.fragment,e),c(je.$$.fragment,e),c(ue.$$.fragment,e),c(Te.$$.fragment,e),Bl=!1},d(e){e&&(t(be),t(Ue),t(Ie),t(fe),t(Ce),t(Ze),t(U),t(Be),t(Ge),t(b),t(ve),t(I),t(We),t($e),t(Ae),t(Z),t(Re),t(ke),t(G),t(Ve),t(v),t(Qe),t(_e),t($),t(Ne),t(Ee),t(R),t(Se),t(k),t(Xe),t(V),t(qe),t(xe),t(Ye),t(N),t(He),t(E),t(Fe),t(S),t(ze),t(Pe),t(q),t(De),t(x),t(Le),t(Y),t(Ke),t(H),t(Oe),t(F),t(el),t(ll),t(P),t(tl),t(D),t(sl),t(L),t(nl),t(al),t(O),t(ol),t(il),t(le),t(Ml),t(pl),t(se),t(ml),t(rl),t(ae),t(yl),t(cl),t(ie),t(dl),t(wl),t(pe),t(Jl),t(me),t(jl),t(hl),t(ul),t(Tl),t(Ul),t(we),t(gl),t(bl),t(Il),t(he),t(fl),t(Cl),t(Zl),t(ge)),t(j),d(h,e),d(u,e),d(T,e),d(g,e),d(f,e),d(C,e),d(B,e),d(W,e),d(A,e),d(Q,e),d(_,e),d(X,e),d(z,e),d(K,e),d(ee,e),d(te,e),d(ne,e),d(oe,e),d(Me,e),d(re,e),d(ye,e),d(ce,e),d(de,e),d(Je,e),d(je,e),d(ue,e),d(Te,e)}}}const ut='{"title":"用 Gemma, MongoDB 和开源模型构建 RAG 系统","local":"用-gemma-mongodb-和开源模型构建-rag-系统","sections":[{"title":"第一步：安装库","local":"第一步安装库","sections":[],"depth":2},{"title":"第二步：数据源选择和准备","local":"第二步数据源选择和准备","sections":[],"depth":2},{"title":"第三步：生成嵌入","local":"第三步生成嵌入","sections":[],"depth":2},{"title":"第4步：数据库设置和连接","local":"第4步数据库设置和连接","sections":[{"title":"4.1 数据库和集合设置","local":"41-数据库和集合设置","sections":[],"depth":3}],"depth":2},{"title":"第5步：创建向量搜索索引","local":"第5步创建向量搜索索引","sections":[],"depth":2},{"title":"第6步：建立数据连接","local":"第6步建立数据连接","sections":[],"depth":2},{"title":"第7步：对用户查询执行向量搜索","local":"第7步对用户查询执行向量搜索","sections":[],"depth":2},{"title":"第 8 步：处理用户查询和加载 Gemma","local":"第-8-步处理用户查询和加载-gemma","sections":[],"depth":2}],"depth":1}';function Tt(Gl){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends rt{constructor(j){super(),yt(this,j,Tt,ht,Mt,{})}}export{Ct as component};
