import{s as $s,n as Rs,o as Bs}from"../chunks/scheduler.1f027d5a.js";import{S as _s,i as Ns,e as M,s as n,c as i,h as Es,a as p,d as e,b as a,f as Vs,g as U,j as m,k as Ze,l as Fs,m as s,n as y,t as J,o as T,p as r}from"../chunks/index.6117a65d.js";import{C as gs}from"../chunks/CopyLLMTxtMenu.93325501.js";import{D as Zs,C as w}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as j,E as ks}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function Gs(ke){let b,Ol,Dl,lt,I,tt,u,et,o,st,f,Ge='<em>作者：<a href="https://github.com/scott-martens" rel="nofollow">Scott Martens</a> @ <a href="https://jina.ai" rel="nofollow">Jina AI</a></em>',nt,C,xe="本教程将展示如何构建一个简单的检索增强生成（RAG）系统，该系统从 SQL 数据库中提取信息，而不是从文档存储中提取。",at,d,Mt,h,Ae='<li>给定一个 SQL 数据库，我们提取 SQL 表的定义（SQL 导出文件中的 <code>CREATE</code> 语句），并将其存储。在本教程中，我们已经为您完成了这部分操作，表定义被存储在内存中，作为一个列表。根据此示例扩展可能需要更复杂的存储方案。</li> <li>用户输入一个自然语言查询。</li> <li><a href="https://jina.ai/reranker/" rel="nofollow">Jina Reranker v2</a>（<a href="https://huggingface.co/jinaai/jina-reranker-v2-base-multilingual" rel="nofollow"><code>jinaai/jina-reranker-v2-base-multilingual</code></a>），一个由 <a href="https://jina.ai" rel="nofollow">Jina AI</a> 提供的 SQL 感知排序模型，会根据查询的相关性对表定义进行排序。</li> <li>我们将用户的查询和排名前三的表定义作为提示，传递给 <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.1" rel="nofollow">Mistral 7B Instruct v0.1 (<code>mistralai/Mistral-7B-Instruct-v0.1</code>)</a>，并请求生成一个 SQL 查询来完成任务。</li> <li>Mistral Instruct 生成一个 SQL 查询，我们将其在数据库上执行并检索结果。</li> <li>SQL 查询结果被转换为 JSON 格式，并作为新提示传递给 Mistral Instruct，包含用户的原始查询、SQL 查询及请求，要求生成自然语言形式的答案。</li> <li>Mistral Instruct 的自然语言文本响应返回给用户。</li>',pt,V,it,$,Qe='本教程使用一个小型的开放访问视频游戏销售记录数据库，存储在 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> 上。我们将使用 <a href="https://www.sqlite.org/index.html" rel="nofollow">SQLite</a> 版本，因为 SQLite 非常紧凑，跨平台，并且内置对 Python 的支持。',Ut,R,yt,B,Se="我们将在本地运行 Jina Reranker v2 模型。如果您使用 Google Colab 运行此笔记本，请确保使用支持 GPU 的运行时。如果您在本地运行，您需要 Python 3（本教程使用 Python 3.11 编写），并且在启用了 CUDA 的 GPU 上运行将会 <em>大大</em> 提升速度。",Jt,_,Xe='本教程还将广泛使用开源的 <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex RAG 框架</a>，以及 <a href="https://huggingface.co/inference-api/serverless" rel="nofollow">Hugging Face Inference API</a> 来访问 Mistral 7B Instruct v0.1。您需要一个 <a href="https://huggingface.co/login" rel="nofollow">Hugging Face 账户</a> 和一个至少具有 <code>READ</code> 权限的 <a href="https://huggingface.co/settings/tokens" rel="nofollow">访问令牌</a>。',Tt,c,We='<p>如果你使用 Google Colab，SQLite 已经安装。它可能没有安装在您的本地计算机上。如果未安装，请按照 <a href="https://www.sqlite.org/download.html" rel="nofollow">SQLite 网站</a> 上的说明进行安装。Python 接口代码已经集成在 Python 中，无需额外安装任何 Python 模块。</p>',rt,N,mt,E,wt,F,ve="首先，安装需要的 python 模块：",jt,g,bt,Z,ct,k,He='接下来，从 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> 下载 SQLite 数据库 <code>videogames.db</code> 到本地文件系统。如果你的系统上没有 <code>wget</code> 命令，可以通过 <a href="https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db" rel="nofollow">这个链接</a> 下载数据库，并将其放置在你运行本 Notebook 的相同目录中。',It,G,ut,x,ot,A,Ye="以下代码将下载模型 <code>jina-reranker-v2-base-multilingual</code> 并在本地运行：",ft,Q,Ct,S,dt,X,qe="我们将使用 LlamaIndex 创建一个持有对象，用于连接 Hugging Face 推理 API 和运行在那里的 <code>mistralai/Mistral-7B-Instruct-v0.1</code> 模型。",ht,W,Le='首先，从你的 <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face 账户设置页面</a> 获取一个 Hugging Face 访问令牌。',Vt,v,ze="在下面的提示中输入该令牌：",$t,H,Rt,Y,Pe="接下来，初始化 LlamaIndex 中 <code>HuggingFaceInferenceAPI</code> 类的实例，并将其存储为 <code>mistral_llm</code>：",Bt,q,_t,L,Nt,z,De='我们从 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub 上的数据库导入文件</a> 中提取了八个表的定义。运行以下命令，将它们放入名为 <code>table_declarations</code> 的 Python 列表中：',Et,P,Ft,D,Ke="现在，我们定义一个函数，该函数接受一个自然语言查询和表定义列表，使用 Jina Reranker v2 对所有表进行评分，并按得分从高到低返回它们：",gt,K,Zt,O,Oe="Jina Reranker v2 会对我们提供的每个表定义进行评分，默认情况下，这个函数将返回所有表及其得分。可选参数 <code>top_n</code> 限制返回的结果数量，按得分从高到低，直到用户定义的数量。",kt,ll,ls="试试这个。首先，定义一个查询：",Gt,tl,xt,el,ts="运行 <code>rank_tables</code> 来获取表定义的列表。我们将 <code>top_n</code> 设置为 3，以限制返回列表的大小，并将结果赋值给变量 <code>ranked_tables</code>，然后检查结果：",At,sl,Qt,nl,es="输出应该包括 <code>region_sales</code>、<code>platform</code> 和 <code>game_platform</code> 这三个表，它们似乎都是查找查询答案的合理地方。",St,al,Xt,Ml,ss="我们将使用 Mistral Instruct v0.1 编写一个 SQL 查询，满足用户的查询需求，基于根据重新排序器得出的前三个表的声明。",Wt,pl,ns="首先，我们使用 LlamaIndex 的 <code>PromptTemplate</code> 类为此目的创建一个提示：",vt,il,Ht,Ul,as="我们使用 <code>format</code> 方法将用户查询和来自 Jina Reranker v2 的前三个表定义填充到模板字段中：",Yt,yl,qt,Jl,Ms="你可以看到我们将传递给 Mistral Instruct 的实际文本：",Lt,Tl,zt,rl,ps="现在，让我们将提示发送给 Mistral Instruct 并获取其响应：",Pt,ml,Dt,wl,Kt,jl,is="使用内置的 Python SQLite 接口，针对数据库 <code>videogames.db</code> 运行上面的 SQL 查询：",Ot,bl,le,cl,Us='有关 SQLite 接口的详细信息，请参阅 <a href="https://docs.python.org/3/library/sqlite3.html" rel="nofollow">Python3 文档</a>。',te,Il,ys="检查结果：",ee,ul,se,ol,Js="你可以通过运行您自己的 SQL 查询来检查结果是否正确。该数据库中存储的销售数据是浮动点数，可能是以千或百万为单位的销售数量。",ne,fl,ae,Cl,Ts="现在，我们将用户的查询、SQL 查询和结果通过一个新的提示模板传递回 Mistral Instruct。",Me,dl,rs="首先，使用 LlamaIndex 创建新的提示模板，和之前一样：",pe,hl,ie,Vl,ms="我们将把 SQL 输出转换为 JSON 格式，这是 Mistral Instruct v0.1 理解的格式。",Ue,$l,ws="填充模板字段：",ye,Rl,Je,Bl,js="现在从 Mistral Instruct 请求自然语言回答：",Te,_l,re,Nl,me,El,bs="让我们将所有步骤组织成一个函数，并加入异常处理：",we,Fl,je,gl,cs="尝试:",be,Zl,ce,kl,Is="试一试其他的问题:",Ie,Gl,ue,xl,oe,Al,fe,Ql,Ce,Sl,de,Xl,us="试一试你自己的问题:",he,Wl,Ve,vl,$e,Hl,os="我们向你展示了如何构建一个非常基础的 RAG（检索增强生成）系统，用于自然语言问答，并将 SQL 数据库作为信息来源。在这个实现中，我们使用相同的大型语言模型（Mistral Instruct v0.1）来生成 SQL 查询和构造自然语言回答。",Re,Yl,fs="这里的数据库是一个非常小的示例，扩展到更大规模可能需要比仅仅对表定义进行排序更复杂的方法。你可能需要使用一个双阶段的过程，其中嵌入模型和向量存储首先检索更多的结果，但重排序模型会将结果修剪到你能够放入生成语言模型提示中的数量。",Be,ql,Cs="本 Notebook 假设没有任何请求需要超过三个表来满足，显然，在实际应用中，这种假设并不总是成立。Mistral 7B Instruct v0.1 并不保证生成正确（甚至是可执行的）SQL 输出。在生产环境中，类似的实现需要更深入的错误处理。",_e,Ll,ds="更复杂的错误处理、更长的输入上下文窗口以及专门用于 SQL 任务的生成模型，可能在实际应用中带来显著的改进。",Ne,zl,hs="尽管如此，你可以看到 RAG 概念如何扩展到结构化数据库，极大地扩展了其应用范围。",Ee,Pl,Fe,Kl,ge;return I=new Zs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_sql_reranker.ipynb"}]}}),u=new gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),o=new j({props:{title:"基于 SQL 和 Jina Reranker v2 的 RAG",local:"基于-sql-和-jina-reranker-v2-的-rag",headingTag:"h1"}}),d=new j({props:{title:"工作原理",local:"工作原理",headingTag:"h3"}}),V=new j({props:{title:"数据库",local:"数据库",headingTag:"h3"}}),R=new j({props:{title:"软件和硬件要求",local:"软件和硬件要求",headingTag:"h3"}}),N=new j({props:{title:"开始",local:"开始",headingTag:"h2"}}),E=new j({props:{title:"安装环境",local:"安装环境",headingTag:"h3"}}),g=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjB0cmFuc2Zvcm1lcnMlMjBlaW5vcHMlMjBsbGFtYS1pbmRleCUyMGxsYW1hLWluZGV4LXBvc3Rwcm9jZXNzb3ItamluYWFpLXJlcmFuayUyMCUyMGxsYW1hLWluZGV4LWxsbXMtaHVnZ2luZ2ZhY2UlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJpbmZlcmVuY2UlNUQlMjI=",highlighted:'!pip install -qU transformers einops llama-index llama-index-postprocessor-jinaai-rerank  llama-index-llms-huggingface <span class="hljs-string">&quot;huggingface_hub[inference]&quot;</span>',wrap:!1}}),Z=new j({props:{title:"下载数据库",local:"下载数据库",headingTag:"h3"}}),G=new w({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZiYnJ1bW0lMkZkYXRhYmFzZXN0YXIlMkZyYXclMkZtYWluJTJGc2FtcGxlX2RhdGFiYXNlcyUyRnNhbXBsZV9kYl92aWRlb2dhbWVzJTJGc3FsaXRlJTJGdmlkZW9nYW1lcy5kYg==",highlighted:"!wget https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db",wrap:!1}}),x=new j({props:{title:"下载并运行 Jina Reranker v2",local:"下载并运行-jina-reranker-v2",headingTag:"h3"}}),Q=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFyZXJhbmtlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCdqaW5hYWklMkZqaW5hLXJlcmFua2VyLXYyLWJhc2UtbXVsdGlsaW5ndWFsJyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUwQSklMEElMEFyZXJhbmtlcl9tb2RlbC50bygnY3VkYScpJTIwJTIzJTIwb3IlMjAnY3B1JyUyMGlmJTIwbm8lMjBHUFUlMjBpcyUyMGF2YWlsYWJsZSUwQXJlcmFua2VyX21vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

reranker_model = AutoModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&#x27;jinaai/jina-reranker-v2-base-multilingual&#x27;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
)

reranker_model.to(<span class="hljs-string">&#x27;cuda&#x27;</span>) <span class="hljs-comment"># or &#x27;cpu&#x27; if no GPU is available</span>
reranker_model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),S=new j({props:{title:"设置 Mistral Instruct 的接口",local:"设置-mistral-instruct-的接口",headingTag:"h3"}}),H=new w({props:{code:"aW1wb3J0JTIwZ2V0cGFzcyUwQSUwQXByaW50KCUyMlBhc3RlJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNBJTIwJTIyKSUwQWhmX3Rva2VuJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> getpass

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Paste your Hugging Face access token here: &quot;</span>)
hf_token = getpass.getpass()`,wrap:!1}}),q=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQSUwQW1pc3RyYWxfbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwdG9rZW4lM0RoZl90b2tlbiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

mistral_llm = HuggingFaceInferenceAPI(
    model_name=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, token=hf_token
)`,wrap:!1}}),L=new j({props:{title:"使用 SQL 感知的 Jina Reranker v2",local:"使用-sql-感知的-jina-reranker-v2",headingTag:"h2"}}),P=new w({props:{code:"dGFibGVfZGVjbGFyYXRpb25zJTIwJTNEJTIwJTVCJ0NSRUFURSUyMFRBQkxFJTIwcGxhdGZvcm0lMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RwbGF0Zm9ybV9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwZ2VucmUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9uYW1lJTIwVEVYVCUyMERFRkFVTFQlMjBOVUxMJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwcHVibGlzaGVyJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0cHVibGlzaGVyX25hbWUlMjBURVhUJTIwREVGQVVMVCUyME5VTEwlNUNuKSUzQiclMkMlMEElMjAnQ1JFQVRFJTIwVEFCTEUlMjByZWdpb24lMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RyZWdpb25fbmFtZSUyMFRFWFQlMjBERUZBVUxUJTIwTlVMTCU1Q24pJTNCJyUyQyUwQSUyMCdDUkVBVEUlMjBUQUJMRSUyMGdhbWUlMjAoJTVDbiU1Q3RpZCUyMElOVEVHRVIlMjBQUklNQVJZJTIwS0VZJTJDJTVDbiU1Q3RnZW5yZV9pZCUyMElOVEVHRVIlMkMlNUNuJTVDdGdhbWVfbmFtZSUyMFRFWFQlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0Q09OU1RSQUlOVCUyMGZrX2dtX2dlbiUyMEZPUkVJR04lMjBLRVklMjAoZ2VucmVfaWQpJTIwUkVGRVJFTkNFUyUyMGdlbnJlKGlkKSU1Q24pJTNCJyUyQyUwQSUyMCdDUkVBVEUlMjBUQUJMRSUyMGdhbWVfcHVibGlzaGVyJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0Z2FtZV9pZCUyMElOVEVHRVIlMjBERUZBVUxUJTIwTlVMTCUyQyU1Q24lNUN0cHVibGlzaGVyX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RDT05TVFJBSU5UJTIwZmtfZ3B1X2dhbSUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9pZCklMjBSRUZFUkVOQ0VTJTIwZ2FtZShpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncHVfcHViJTIwRk9SRUlHTiUyMEtFWSUyMChwdWJsaXNoZXJfaWQpJTIwUkVGRVJFTkNFUyUyMHB1Ymxpc2hlcihpZCklNUNuKSUzQiclMkMlMEElMjAnQ1JFQVRFJTIwVEFCTEUlMjBnYW1lX3BsYXRmb3JtJTIwKCU1Q24lNUN0aWQlMjBJTlRFR0VSJTIwUFJJTUFSWSUyMEtFWSUyQyU1Q24lNUN0Z2FtZV9wdWJsaXNoZXJfaWQlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdHBsYXRmb3JtX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RyZWxlYXNlX3llYXIlMjBJTlRFR0VSJTIwREVGQVVMVCUyME5VTEwlMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncGxfZ3AlMjBGT1JFSUdOJTIwS0VZJTIwKGdhbWVfcHVibGlzaGVyX2lkKSUyMFJFRkVSRU5DRVMlMjBnYW1lX3B1Ymxpc2hlcihpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19ncGxfcGxhJTIwRk9SRUlHTiUyMEtFWSUyMChwbGF0Zm9ybV9pZCklMjBSRUZFUkVOQ0VTJTIwcGxhdGZvcm0oaWQpJTVDbiklM0InJTJDJTBBJTIwJ0NSRUFURSUyMFRBQkxFJTIwcmVnaW9uX3NhbGVzJTIwKCU1Q24lNUN0cmVnaW9uX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RnYW1lX3BsYXRmb3JtX2lkJTIwSU5URUdFUiUyMERFRkFVTFQlMjBOVUxMJTJDJTVDbiU1Q3RudW1fc2FsZXMlMjBSRUFMJTJDJTVDbiUyMCUyMCUyMENPTlNUUkFJTlQlMjBma19yc19ncCUyMEZPUkVJR04lMjBLRVklMjAoZ2FtZV9wbGF0Zm9ybV9pZCklMjBSRUZFUkVOQ0VTJTIwZ2FtZV9wbGF0Zm9ybShpZCklMkMlNUNuJTVDdENPTlNUUkFJTlQlMjBma19yc19yZWclMjBGT1JFSUdOJTIwS0VZJTIwKHJlZ2lvbl9pZCklMjBSRUZFUkVOQ0VTJTIwcmVnaW9uKGlkKSU1Q24pJTNCJyU1RA==",highlighted:`table_declarations = [<span class="hljs-string">&#x27;CREATE TABLE platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tplatform_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE genre (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tpublisher_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE region (\\n\\tid INTEGER PRIMARY KEY,\\n\\tregion_name TEXT DEFAULT NULL\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_id INTEGER,\\n\\tgame_name TEXT DEFAULT NULL,\\n\\tCONSTRAINT fk_gm_gen FOREIGN KEY (genre_id) REFERENCES genre(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game_publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_id INTEGER DEFAULT NULL,\\n\\tpublisher_id INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpu_gam FOREIGN KEY (game_id) REFERENCES game(id),\\n\\tCONSTRAINT fk_gpu_pub FOREIGN KEY (publisher_id) REFERENCES publisher(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE game_platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_publisher_id INTEGER DEFAULT NULL,\\n\\tplatform_id INTEGER DEFAULT NULL,\\n\\trelease_year INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpl_gp FOREIGN KEY (game_publisher_id) REFERENCES game_publisher(id),\\n\\tCONSTRAINT fk_gpl_pla FOREIGN KEY (platform_id) REFERENCES platform(id)\\n);&#x27;</span>,
 <span class="hljs-string">&#x27;CREATE TABLE region_sales (\\n\\tregion_id INTEGER DEFAULT NULL,\\n\\tgame_platform_id INTEGER DEFAULT NULL,\\n\\tnum_sales REAL,\\n   CONSTRAINT fk_rs_gp FOREIGN KEY (game_platform_id) REFERENCES game_platform(id),\\n\\tCONSTRAINT fk_rs_reg FOREIGN KEY (region_id) REFERENCES region(id)\\n);&#x27;</span>]`,wrap:!1}}),K=new w({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUdXBsZSUwQSUwQWRlZiUyMHJhbmtfdGFibGVzKHF1ZXJ5JTNBJTIwc3RyJTJDJTIwdGFibGVfc3BlY3MlM0ElMjBMaXN0JTVCc3RyJTVEJTJDJTIwdG9wX24lM0FpbnQlM0QwKSUyMC0lM0UlMjBMaXN0JTVCVHVwbGUlNUJmbG9hdCUyQyUyMHN0ciU1RCU1RCUzQSUwQSUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMEdldCUyMHNvcnRlZCUyMHBhaXJzJTIwb2YlMjBzY29yZXMlMjBhbmQlMjB0YWJsZSUyMHNwZWNpZmljYXRpb25zJTJDJTIwdGhlbiUyMHJldHVybiUyMHRoZSUyMHRvcCUyME4lMkMlMEElMjAlMjBvciUyMGFsbCUyMGlmJTIwdG9wX24lMjBpcyUyMDAlMjBvciUyMGRlZmF1bHQuJTBBJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwcGFpcnMlMjAlM0QlMjAlNUIlNUJxdWVyeSUyQyUyMHRhYmxlX3NwZWMlNUQlMjBmb3IlMjB0YWJsZV9zcGVjJTIwaW4lMjB0YWJsZV9zcGVjcyU1RCUwQSUyMCUyMHNjb3JlcyUyMCUzRCUyMHJlcmFua2VyX21vZGVsLmNvbXB1dGVfc2NvcmUocGFpcnMpJTBBJTIwJTIwc2NvcmVkX3RhYmxlcyUyMCUzRCUyMCU1QihzY29yZSUyQyUyMHRhYmxlX3NwZWMpJTIwZm9yJTIwc2NvcmUlMkMlMjB0YWJsZV9zcGVjJTIwaW4lMjB6aXAoc2NvcmVzJTJDJTIwdGFibGVfc3BlY3MpJTVEJTBBJTIwJTIwc2NvcmVkX3RhYmxlcy5zb3J0KGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMCU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUwQSUyMCUyMGlmJTIwdG9wX24lMjBhbmQlMjB0b3BfbiUyMCUzQyUyMGxlbihzY29yZWRfdGFibGVzKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlZF90YWJsZXMlNUIwJTNBdG9wX24lNUQlMEElMjAlMjByZXR1cm4lMjBzY29yZWRfdGFibGVz",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">rank_tables</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, table_specs: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>], top_n:<span class="hljs-built_in">int</span>=<span class="hljs-number">0</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">str</span>]]:
  <span class="hljs-string">&quot;&quot;&quot;
  Get sorted pairs of scores and table specifications, then return the top N,
  or all if top_n is 0 or default.
  &quot;&quot;&quot;</span>
  pairs = [[query, table_spec] <span class="hljs-keyword">for</span> table_spec <span class="hljs-keyword">in</span> table_specs]
  scores = reranker_model.compute_score(pairs)
  scored_tables = [(score, table_spec) <span class="hljs-keyword">for</span> score, table_spec <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, table_specs)]
  scored_tables.sort(key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>], reverse=<span class="hljs-literal">True</span>)
  <span class="hljs-keyword">if</span> top_n <span class="hljs-keyword">and</span> top_n &lt; <span class="hljs-built_in">len</span>(scored_tables):
    <span class="hljs-keyword">return</span> scored_tables[<span class="hljs-number">0</span>:top_n]
  <span class="hljs-keyword">return</span> scored_tables`,wrap:!1}}),tl=new w({props:{code:"dXNlcl9xdWVyeSUyMCUzRCUyMCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMuJTIy",highlighted:'user_query = <span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>',wrap:!1}}),sl=new w({props:{code:"cmFua2VkX3RhYmxlcyUyMCUzRCUyMHJhbmtfdGFibGVzKHVzZXJfcXVlcnklMkMlMjB0YWJsZV9kZWNsYXJhdGlvbnMlMkMlMjB0b3BfbiUzRDMpJTBBcmFua2VkX3RhYmxlcw==",highlighted:`ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
ranked_tables`,wrap:!1}}),al=new j({props:{title:"使用 Mistral Instruct 生成 SQL 查询",local:"使用-mistral-instruct-生成-sql-查询",headingTag:"h2"}}),il=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBQcm9tcHRUZW1wbGF0ZSUwQSUwQW1ha2Vfc3FsX3Byb21wdF90bXBsX3RleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBR2VuZXJhdGUlMjBhJTIwU1FMJTIwcXVlcnklMjB0byUyMGFuc3dlciUyMHRoZSUyMGZvbGxvd2luZyUyMHF1ZXN0aW9uJTIwZnJvbSUyMHRoZSUyMHVzZXIlM0ElMEElNUMlMjIlN0JxdWVyeV9zdHIlN0QlNUMlMjIlMEElMEFUaGUlMjBTUUwlMjBxdWVyeSUyMHNob3VsZCUyMHVzZSUyMG9ubHklMjB0YWJsZXMlMjB3aXRoJTIwdGhlJTIwZm9sbG93aW5nJTIwU1FMJTIwZGVmaW5pdGlvbnMlM0ElMEElMEFUYWJsZSUyMDElM0ElMEElN0J0YWJsZV8xJTdEJTBBJTBBVGFibGUlMjAyJTNBJTBBJTdCdGFibGVfMiU3RCUwQSUwQVRhYmxlJTIwMyUzQSUwQSU3QnRhYmxlXzMlN0QlMEElMEFNYWtlJTIwc3VyZSUyMHlvdSUyME9OTFklMjBvdXRwdXQlMjBhbiUyMFNRTCUyMHF1ZXJ5JTIwYW5kJTIwbm8lMjBleHBsYW5hdGlvbi4lMEElMjIlMjIlMjIlMEEpJTBBbWFrZV9zcWxfcHJvbXB0X3RtcGwlMjAlM0QlMjBQcm9tcHRUZW1wbGF0ZShtYWtlX3NxbF9wcm9tcHRfdG1wbF90ZXh0KQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> PromptTemplate

make_sql_prompt_tmpl_text = (
    <span class="hljs-string">&quot;&quot;&quot;
Generate a SQL query to answer the following question from the user:
\\&quot;{query_str}\\&quot;

The SQL query should use only tables with the following SQL definitions:

Table 1:
{table_1}

Table 2:
{table_2}

Table 3:
{table_3}

Make sure you ONLY output an SQL query and no explanation.
&quot;&quot;&quot;</span>
)
make_sql_prompt_tmpl = PromptTemplate(make_sql_prompt_tmpl_text)`,wrap:!1}}),yl=new w({props:{code:"bWFrZV9zcWxfcHJvbXB0JTIwJTNEJTIwbWFrZV9zcWxfcHJvbXB0X3RtcGwuZm9ybWF0KHF1ZXJ5X3N0ciUzRHVzZXJfcXVlcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWJsZV8xJTNEcmFua2VkX3RhYmxlcyU1QjAlNUQlNUIxJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFibGVfMiUzRHJhbmtlZF90YWJsZXMlNUIxJTVEJTVCMSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhYmxlXzMlM0RyYW5rZWRfdGFibGVzJTVCMiU1RCU1QjElNUQp",highlighted:`make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                              table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>],
                                              table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>],
                                              table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>])`,wrap:!1}}),Tl=new w({props:{code:"cHJpbnQobWFrZV9zcWxfcHJvbXB0KQ==",highlighted:'<span class="hljs-built_in">print</span>(make_sql_prompt)',wrap:!1}}),ml=new w({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBtaXN0cmFsX2xsbS5jb21wbGV0ZShtYWtlX3NxbF9wcm9tcHQpJTBBc3FsX3F1ZXJ5JTIwJTNEJTIwc3RyKHJlc3BvbnNlKSUwQXByaW50KHNxbF9xdWVyeSk=",highlighted:`response = mistral_llm.complete(make_sql_prompt)
sql_query = <span class="hljs-built_in">str</span>(response)
<span class="hljs-built_in">print</span>(sql_query)`,wrap:!1}}),wl=new j({props:{title:"运行 SQL 查询",local:"运行-sql-查询",headingTag:"h2"}}),bl=new w({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQSUwQWNvbiUyMCUzRCUyMHNxbGl0ZTMuY29ubmVjdCglMjJ2aWRlb2dhbWVzLmRiJTIyKSUwQWN1ciUyMCUzRCUyMGNvbi5jdXJzb3IoKSUwQXNxbF9yZXNwb25zZSUyMCUzRCUyMGN1ci5leGVjdXRlKHNxbF9xdWVyeSkuZmV0Y2hhbGwoKQ==",highlighted:`<span class="hljs-keyword">import</span> sqlite3

con = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>)
cur = con.cursor()
sql_response = cur.execute(sql_query).fetchall()`,wrap:!1}}),ul=new w({props:{code:"c3FsX3Jlc3BvbnNl",highlighted:"sql_response",wrap:!1}}),fl=new j({props:{title:"获取自然语言回答",local:"获取自然语言回答",headingTag:"h2"}}),hl=new w({props:{code:"cmFnX3Byb21wdF90bXBsX3N0ciUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEFVc2UlMjB0aGUlMjBpbmZvcm1hdGlvbiUyMGluJTIwdGhlJTIwSlNPTiUyMHRhYmxlJTIwdG8lMjBhbnN3ZXIlMjB0aGUlMjBmb2xsb3dpbmclMjB1c2VyJTIwcXVlcnkuJTBBRG8lMjBub3QlMjBleHBsYWluJTIwYW55dGhpbmclMkMlMjBqdXN0JTIwYW5zd2VyJTIwY29uY2lzZWx5LiUyMFVzZSUyMG5hdHVyYWwlMjBsYW5ndWFnZSUyMGluJTIweW91ciUwQWFuc3dlciUyQyUyMG5vdCUyMGNvbXB1dGVyJTIwZm9ybWF0dGluZy4lMEElMEFVU0VSJTIwUVVFUlklM0ElMjAlN0JxdWVyeV9zdHIlN0QlMEElMEFKU09OJTIwdGFibGUlM0ElMEElN0Jqc29uX3RhYmxlJTdEJTBBJTBBVGhpcyUyMHRhYmxlJTIwd2FzJTIwZ2VuZXJhdGVkJTIwYnklMjB0aGUlMjBmb2xsb3dpbmclMjBTUUwlMjBxdWVyeSUzQSUwQSU3QnNxbF9xdWVyeSU3RCUwQSUwQUFuc3dlciUyME9OTFklMjB1c2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwaW4lMjB0aGUlMjB0YWJsZSUyMGFuZCUyMHRoZSUyMFNRTCUyMHF1ZXJ5JTJDJTIwYW5kJTIwaWYlMjB0aGUlMEF0YWJsZSUyMGRvZXMlMjBub3QlMjBwcm92aWRlJTIwdGhlJTIwaW5mb3JtYXRpb24lMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXN0aW9uJTJDJTIwYW5zd2VyJTBBJTIyTm8lMjBJbmZvcm1hdGlvbiUyMi4lMEElMjIlMjIlMjIlMEEpJTBBcmFnX3Byb21wdF90bXBsJTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUocmFnX3Byb21wdF90bXBsX3N0cik=",highlighted:`rag_prompt_tmpl_str = (
    <span class="hljs-string">&quot;&quot;&quot;
Use the information in the JSON table to answer the following user query.
Do not explain anything, just answer concisely. Use natural language in your
answer, not computer formatting.

USER QUERY: {query_str}

JSON table:
{json_table}

This table was generated by the following SQL query:
{sql_query}

Answer ONLY using the information in the table and the SQL query, and if the
table does not provide the information to answer the question, answer
&quot;No Information&quot;.
&quot;&quot;&quot;</span>
)
rag_prompt_tmpl = PromptTemplate(rag_prompt_tmpl_str)`,wrap:!1}}),Rl=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJhZ19wcm9tcHQlMjAlM0QlMjByYWdfcHJvbXB0X3RtcGwuZm9ybWF0KHF1ZXJ5X3N0ciUzRCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uX3RhYmxlJTNEanNvbi5kdW1wcyhzcWxfcmVzcG9uc2UpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3FsX3F1ZXJ5JTNEc3FsX3F1ZXJ5KQ==",highlighted:`<span class="hljs-keyword">import</span> json

rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=<span class="hljs-string">&quot;Identify the top 10 platforms by total sales&quot;</span>,
                                    json_table=json.dumps(sql_response),
                                    sql_query=sql_query)`,wrap:!1}}),_l=new w({props:{code:"cmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEFwcmludChzdHIocmFnX3Jlc3BvbnNlKSk=",highlighted:`rag_response = mistral_llm.complete(rag_prompt)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">str</span>(rag_response))`,wrap:!1}}),Nl=new j({props:{title:"尝试自己动手",local:"尝试自己动手",headingTag:"h2"}}),Fl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_sql</span>(<span class="hljs-params">user_query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
  <span class="hljs-keyword">try</span>:
    ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Ranking failed.\\nUser query:\\n<span class="hljs-subst">{user_query}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                                table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>],
                                                table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>],
                                                table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>])

  <span class="hljs-keyword">try</span>:
    response = mistral_llm.complete(make_sql_prompt)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL query generation failed\\nPrompt:\\n<span class="hljs-subst">{make_sql_prompt}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  <span class="hljs-comment"># Backslash removal is a necessary hack because sometimes Mistral puts them</span>
  <span class="hljs-comment"># in its generated code.</span>
  sql_query = <span class="hljs-built_in">str</span>(response).replace(<span class="hljs-string">&quot;\\\\&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)

  <span class="hljs-keyword">try</span>:
    sql_response = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>).cursor().execute(sql_query).fetchall()
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL querying failed. Query:\\n<span class="hljs-subst">{sql_query}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)

  rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query,
                                      json_table=json.dumps(sql_response),
                                      sql_query=sql_query)
  <span class="hljs-keyword">try</span>:
    rag_response = mistral_llm.complete(rag_prompt)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(rag_response)
  <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer generation failed. Prompt:\\n<span class="hljs-subst">{rag_prompt}</span>\\n\\n&quot;</span>)
    <span class="hljs-keyword">raise</span>(e)`,wrap:!1}}),Zl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJJZGVudGlmeSUyMHRoZSUyMHRvcCUyMDEwJTIwcGxhdGZvcm1zJTIwYnklMjB0b3RhbCUyMHNhbGVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>))',wrap:!1}}),Gl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJTdW1tYXJpemUlMjBzYWxlcyUyMGJ5JTIwcmVnaW9uLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Summarize sales by region.&quot;</span>))',wrap:!1}}),xl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJMaXN0JTIwdGhlJTIwcHVibGlzaGVyJTIwd2l0aCUyMHRoZSUyMGxhcmdlc3QlMjBudW1iZXIlMjBvZiUyMHB1Ymxpc2hlZCUyMGdhbWVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;List the publisher with the largest number of published games.&quot;</span>))',wrap:!1}}),Al=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJEaXNwbGF5JTIwdGhlJTIweWVhciUyMHdpdGglMjBtb3N0JTIwZ2FtZXMlMjByZWxlYXNlZC4lMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Display the year with most games released.&quot;</span>))',wrap:!1}}),Ql=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9uJTIwdGhlJTIwV2lpJTIwcGxhdGZvcm0lM0YlMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre on the Wii platform?&quot;</span>))',wrap:!1}}),Sl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9mJTIwMjAxMiUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre of 2012?&quot;</span>))',wrap:!1}}),Wl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjIlM0NJTlNFUlQlMjBRVUVTVElPTiUyME9SJTIwSU5TVFJVQ1RJT04lMjBIRVJFJTNFJTIyKSk=",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;&lt;INSERT QUESTION OR INSTRUCTION HERE&gt;&quot;</span>))',wrap:!1}}),vl=new j({props:{title:"复习与总结",local:"复习与总结",headingTag:"h2"}}),Pl=new ks({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_sql_reranker.md"}}),{c(){b=M("meta"),Ol=n(),Dl=M("p"),lt=n(),i(I.$$.fragment),tt=n(),i(u.$$.fragment),et=n(),i(o.$$.fragment),st=n(),f=M("p"),f.innerHTML=Ge,nt=n(),C=M("p"),C.textContent=xe,at=n(),i(d.$$.fragment),Mt=n(),h=M("ul"),h.innerHTML=Ae,pt=n(),i(V.$$.fragment),it=n(),$=M("p"),$.innerHTML=Qe,Ut=n(),i(R.$$.fragment),yt=n(),B=M("p"),B.innerHTML=Se,Jt=n(),_=M("p"),_.innerHTML=Xe,Tt=n(),c=M("blockquote"),c.innerHTML=We,rt=n(),i(N.$$.fragment),mt=n(),i(E.$$.fragment),wt=n(),F=M("p"),F.textContent=ve,jt=n(),i(g.$$.fragment),bt=n(),i(Z.$$.fragment),ct=n(),k=M("p"),k.innerHTML=He,It=n(),i(G.$$.fragment),ut=n(),i(x.$$.fragment),ot=n(),A=M("p"),A.innerHTML=Ye,ft=n(),i(Q.$$.fragment),Ct=n(),i(S.$$.fragment),dt=n(),X=M("p"),X.innerHTML=qe,ht=n(),W=M("p"),W.innerHTML=Le,Vt=n(),v=M("p"),v.textContent=ze,$t=n(),i(H.$$.fragment),Rt=n(),Y=M("p"),Y.innerHTML=Pe,Bt=n(),i(q.$$.fragment),_t=n(),i(L.$$.fragment),Nt=n(),z=M("p"),z.innerHTML=De,Et=n(),i(P.$$.fragment),Ft=n(),D=M("p"),D.textContent=Ke,gt=n(),i(K.$$.fragment),Zt=n(),O=M("p"),O.innerHTML=Oe,kt=n(),ll=M("p"),ll.textContent=ls,Gt=n(),i(tl.$$.fragment),xt=n(),el=M("p"),el.innerHTML=ts,At=n(),i(sl.$$.fragment),Qt=n(),nl=M("p"),nl.innerHTML=es,St=n(),i(al.$$.fragment),Xt=n(),Ml=M("p"),Ml.textContent=ss,Wt=n(),pl=M("p"),pl.innerHTML=ns,vt=n(),i(il.$$.fragment),Ht=n(),Ul=M("p"),Ul.innerHTML=as,Yt=n(),i(yl.$$.fragment),qt=n(),Jl=M("p"),Jl.textContent=Ms,Lt=n(),i(Tl.$$.fragment),zt=n(),rl=M("p"),rl.textContent=ps,Pt=n(),i(ml.$$.fragment),Dt=n(),i(wl.$$.fragment),Kt=n(),jl=M("p"),jl.innerHTML=is,Ot=n(),i(bl.$$.fragment),le=n(),cl=M("p"),cl.innerHTML=Us,te=n(),Il=M("p"),Il.textContent=ys,ee=n(),i(ul.$$.fragment),se=n(),ol=M("p"),ol.textContent=Js,ne=n(),i(fl.$$.fragment),ae=n(),Cl=M("p"),Cl.textContent=Ts,Me=n(),dl=M("p"),dl.textContent=rs,pe=n(),i(hl.$$.fragment),ie=n(),Vl=M("p"),Vl.textContent=ms,Ue=n(),$l=M("p"),$l.textContent=ws,ye=n(),i(Rl.$$.fragment),Je=n(),Bl=M("p"),Bl.textContent=js,Te=n(),i(_l.$$.fragment),re=n(),i(Nl.$$.fragment),me=n(),El=M("p"),El.textContent=bs,we=n(),i(Fl.$$.fragment),je=n(),gl=M("p"),gl.textContent=cs,be=n(),i(Zl.$$.fragment),ce=n(),kl=M("p"),kl.textContent=Is,Ie=n(),i(Gl.$$.fragment),ue=n(),i(xl.$$.fragment),oe=n(),i(Al.$$.fragment),fe=n(),i(Ql.$$.fragment),Ce=n(),i(Sl.$$.fragment),de=n(),Xl=M("p"),Xl.textContent=us,he=n(),i(Wl.$$.fragment),Ve=n(),i(vl.$$.fragment),$e=n(),Hl=M("p"),Hl.textContent=os,Re=n(),Yl=M("p"),Yl.textContent=fs,Be=n(),ql=M("p"),ql.textContent=Cs,_e=n(),Ll=M("p"),Ll.textContent=ds,Ne=n(),zl=M("p"),zl.textContent=hs,Ee=n(),i(Pl.$$.fragment),Fe=n(),Kl=M("p"),this.h()},l(l){const t=Es("svelte-u9bgzb",document.head);b=p(t,"META",{name:!0,content:!0}),t.forEach(e),Ol=a(l),Dl=p(l,"P",{}),Vs(Dl).forEach(e),lt=a(l),U(I.$$.fragment,l),tt=a(l),U(u.$$.fragment,l),et=a(l),U(o.$$.fragment,l),st=a(l),f=p(l,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1cm10yi"&&(f.innerHTML=Ge),nt=a(l),C=p(l,"P",{"data-svelte-h":!0}),m(C)!=="svelte-d4wr3x"&&(C.textContent=xe),at=a(l),U(d.$$.fragment,l),Mt=a(l),h=p(l,"UL",{"data-svelte-h":!0}),m(h)!=="svelte-173ju6z"&&(h.innerHTML=Ae),pt=a(l),U(V.$$.fragment,l),it=a(l),$=p(l,"P",{"data-svelte-h":!0}),m($)!=="svelte-1mhnsso"&&($.innerHTML=Qe),Ut=a(l),U(R.$$.fragment,l),yt=a(l),B=p(l,"P",{"data-svelte-h":!0}),m(B)!=="svelte-acagts"&&(B.innerHTML=Se),Jt=a(l),_=p(l,"P",{"data-svelte-h":!0}),m(_)!=="svelte-xrjnu7"&&(_.innerHTML=Xe),Tt=a(l),c=p(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(c)!=="svelte-sishrx"&&(c.innerHTML=We),rt=a(l),U(N.$$.fragment,l),mt=a(l),U(E.$$.fragment,l),wt=a(l),F=p(l,"P",{"data-svelte-h":!0}),m(F)!=="svelte-2bhcxb"&&(F.textContent=ve),jt=a(l),U(g.$$.fragment,l),bt=a(l),U(Z.$$.fragment,l),ct=a(l),k=p(l,"P",{"data-svelte-h":!0}),m(k)!=="svelte-vp2yk2"&&(k.innerHTML=He),It=a(l),U(G.$$.fragment,l),ut=a(l),U(x.$$.fragment,l),ot=a(l),A=p(l,"P",{"data-svelte-h":!0}),m(A)!=="svelte-5s2xfp"&&(A.innerHTML=Ye),ft=a(l),U(Q.$$.fragment,l),Ct=a(l),U(S.$$.fragment,l),dt=a(l),X=p(l,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1dfawf"&&(X.innerHTML=qe),ht=a(l),W=p(l,"P",{"data-svelte-h":!0}),m(W)!=="svelte-kuh6vr"&&(W.innerHTML=Le),Vt=a(l),v=p(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1mdyrb7"&&(v.textContent=ze),$t=a(l),U(H.$$.fragment,l),Rt=a(l),Y=p(l,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-gut780"&&(Y.innerHTML=Pe),Bt=a(l),U(q.$$.fragment,l),_t=a(l),U(L.$$.fragment,l),Nt=a(l),z=p(l,"P",{"data-svelte-h":!0}),m(z)!=="svelte-hwgfp8"&&(z.innerHTML=De),Et=a(l),U(P.$$.fragment,l),Ft=a(l),D=p(l,"P",{"data-svelte-h":!0}),m(D)!=="svelte-52ja36"&&(D.textContent=Ke),gt=a(l),U(K.$$.fragment,l),Zt=a(l),O=p(l,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1v32w9l"&&(O.innerHTML=Oe),kt=a(l),ll=p(l,"P",{"data-svelte-h":!0}),m(ll)!=="svelte-w44dxh"&&(ll.textContent=ls),Gt=a(l),U(tl.$$.fragment,l),xt=a(l),el=p(l,"P",{"data-svelte-h":!0}),m(el)!=="svelte-r8jqr4"&&(el.innerHTML=ts),At=a(l),U(sl.$$.fragment,l),Qt=a(l),nl=p(l,"P",{"data-svelte-h":!0}),m(nl)!=="svelte-1h4047d"&&(nl.innerHTML=es),St=a(l),U(al.$$.fragment,l),Xt=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),m(Ml)!=="svelte-4d0pet"&&(Ml.textContent=ss),Wt=a(l),pl=p(l,"P",{"data-svelte-h":!0}),m(pl)!=="svelte-nyadiw"&&(pl.innerHTML=ns),vt=a(l),U(il.$$.fragment,l),Ht=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),m(Ul)!=="svelte-19mo587"&&(Ul.innerHTML=as),Yt=a(l),U(yl.$$.fragment,l),qt=a(l),Jl=p(l,"P",{"data-svelte-h":!0}),m(Jl)!=="svelte-2f1d0z"&&(Jl.textContent=Ms),Lt=a(l),U(Tl.$$.fragment,l),zt=a(l),rl=p(l,"P",{"data-svelte-h":!0}),m(rl)!=="svelte-yd2kef"&&(rl.textContent=ps),Pt=a(l),U(ml.$$.fragment,l),Dt=a(l),U(wl.$$.fragment,l),Kt=a(l),jl=p(l,"P",{"data-svelte-h":!0}),m(jl)!=="svelte-1gwivqm"&&(jl.innerHTML=is),Ot=a(l),U(bl.$$.fragment,l),le=a(l),cl=p(l,"P",{"data-svelte-h":!0}),m(cl)!=="svelte-w89ofp"&&(cl.innerHTML=Us),te=a(l),Il=p(l,"P",{"data-svelte-h":!0}),m(Il)!=="svelte-1hgowlu"&&(Il.textContent=ys),ee=a(l),U(ul.$$.fragment,l),se=a(l),ol=p(l,"P",{"data-svelte-h":!0}),m(ol)!=="svelte-18ax3iq"&&(ol.textContent=Js),ne=a(l),U(fl.$$.fragment,l),ae=a(l),Cl=p(l,"P",{"data-svelte-h":!0}),m(Cl)!=="svelte-8v2irz"&&(Cl.textContent=Ts),Me=a(l),dl=p(l,"P",{"data-svelte-h":!0}),m(dl)!=="svelte-v6t0j4"&&(dl.textContent=rs),pe=a(l),U(hl.$$.fragment,l),ie=a(l),Vl=p(l,"P",{"data-svelte-h":!0}),m(Vl)!=="svelte-fdqrw4"&&(Vl.textContent=ms),Ue=a(l),$l=p(l,"P",{"data-svelte-h":!0}),m($l)!=="svelte-r6x816"&&($l.textContent=ws),ye=a(l),U(Rl.$$.fragment,l),Je=a(l),Bl=p(l,"P",{"data-svelte-h":!0}),m(Bl)!=="svelte-1wjlt84"&&(Bl.textContent=js),Te=a(l),U(_l.$$.fragment,l),re=a(l),U(Nl.$$.fragment,l),me=a(l),El=p(l,"P",{"data-svelte-h":!0}),m(El)!=="svelte-40ibhh"&&(El.textContent=bs),we=a(l),U(Fl.$$.fragment,l),je=a(l),gl=p(l,"P",{"data-svelte-h":!0}),m(gl)!=="svelte-1f4skn0"&&(gl.textContent=cs),be=a(l),U(Zl.$$.fragment,l),ce=a(l),kl=p(l,"P",{"data-svelte-h":!0}),m(kl)!=="svelte-2zvtxo"&&(kl.textContent=Is),Ie=a(l),U(Gl.$$.fragment,l),ue=a(l),U(xl.$$.fragment,l),oe=a(l),U(Al.$$.fragment,l),fe=a(l),U(Ql.$$.fragment,l),Ce=a(l),U(Sl.$$.fragment,l),de=a(l),Xl=p(l,"P",{"data-svelte-h":!0}),m(Xl)!=="svelte-17vlt6v"&&(Xl.textContent=us),he=a(l),U(Wl.$$.fragment,l),Ve=a(l),U(vl.$$.fragment,l),$e=a(l),Hl=p(l,"P",{"data-svelte-h":!0}),m(Hl)!=="svelte-dmjhiw"&&(Hl.textContent=os),Re=a(l),Yl=p(l,"P",{"data-svelte-h":!0}),m(Yl)!=="svelte-1dmhq65"&&(Yl.textContent=fs),Be=a(l),ql=p(l,"P",{"data-svelte-h":!0}),m(ql)!=="svelte-1c1xjkh"&&(ql.textContent=Cs),_e=a(l),Ll=p(l,"P",{"data-svelte-h":!0}),m(Ll)!=="svelte-1k8jjj4"&&(Ll.textContent=ds),Ne=a(l),zl=p(l,"P",{"data-svelte-h":!0}),m(zl)!=="svelte-uim3uu"&&(zl.textContent=hs),Ee=a(l),U(Pl.$$.fragment,l),Fe=a(l),Kl=p(l,"P",{}),Vs(Kl).forEach(e),this.h()},h(){Ze(b,"name","hf:doc:metadata"),Ze(b,"content",xs),Ze(c,"class","warning")},m(l,t){Fs(document.head,b),s(l,Ol,t),s(l,Dl,t),s(l,lt,t),y(I,l,t),s(l,tt,t),y(u,l,t),s(l,et,t),y(o,l,t),s(l,st,t),s(l,f,t),s(l,nt,t),s(l,C,t),s(l,at,t),y(d,l,t),s(l,Mt,t),s(l,h,t),s(l,pt,t),y(V,l,t),s(l,it,t),s(l,$,t),s(l,Ut,t),y(R,l,t),s(l,yt,t),s(l,B,t),s(l,Jt,t),s(l,_,t),s(l,Tt,t),s(l,c,t),s(l,rt,t),y(N,l,t),s(l,mt,t),y(E,l,t),s(l,wt,t),s(l,F,t),s(l,jt,t),y(g,l,t),s(l,bt,t),y(Z,l,t),s(l,ct,t),s(l,k,t),s(l,It,t),y(G,l,t),s(l,ut,t),y(x,l,t),s(l,ot,t),s(l,A,t),s(l,ft,t),y(Q,l,t),s(l,Ct,t),y(S,l,t),s(l,dt,t),s(l,X,t),s(l,ht,t),s(l,W,t),s(l,Vt,t),s(l,v,t),s(l,$t,t),y(H,l,t),s(l,Rt,t),s(l,Y,t),s(l,Bt,t),y(q,l,t),s(l,_t,t),y(L,l,t),s(l,Nt,t),s(l,z,t),s(l,Et,t),y(P,l,t),s(l,Ft,t),s(l,D,t),s(l,gt,t),y(K,l,t),s(l,Zt,t),s(l,O,t),s(l,kt,t),s(l,ll,t),s(l,Gt,t),y(tl,l,t),s(l,xt,t),s(l,el,t),s(l,At,t),y(sl,l,t),s(l,Qt,t),s(l,nl,t),s(l,St,t),y(al,l,t),s(l,Xt,t),s(l,Ml,t),s(l,Wt,t),s(l,pl,t),s(l,vt,t),y(il,l,t),s(l,Ht,t),s(l,Ul,t),s(l,Yt,t),y(yl,l,t),s(l,qt,t),s(l,Jl,t),s(l,Lt,t),y(Tl,l,t),s(l,zt,t),s(l,rl,t),s(l,Pt,t),y(ml,l,t),s(l,Dt,t),y(wl,l,t),s(l,Kt,t),s(l,jl,t),s(l,Ot,t),y(bl,l,t),s(l,le,t),s(l,cl,t),s(l,te,t),s(l,Il,t),s(l,ee,t),y(ul,l,t),s(l,se,t),s(l,ol,t),s(l,ne,t),y(fl,l,t),s(l,ae,t),s(l,Cl,t),s(l,Me,t),s(l,dl,t),s(l,pe,t),y(hl,l,t),s(l,ie,t),s(l,Vl,t),s(l,Ue,t),s(l,$l,t),s(l,ye,t),y(Rl,l,t),s(l,Je,t),s(l,Bl,t),s(l,Te,t),y(_l,l,t),s(l,re,t),y(Nl,l,t),s(l,me,t),s(l,El,t),s(l,we,t),y(Fl,l,t),s(l,je,t),s(l,gl,t),s(l,be,t),y(Zl,l,t),s(l,ce,t),s(l,kl,t),s(l,Ie,t),y(Gl,l,t),s(l,ue,t),y(xl,l,t),s(l,oe,t),y(Al,l,t),s(l,fe,t),y(Ql,l,t),s(l,Ce,t),y(Sl,l,t),s(l,de,t),s(l,Xl,t),s(l,he,t),y(Wl,l,t),s(l,Ve,t),y(vl,l,t),s(l,$e,t),s(l,Hl,t),s(l,Re,t),s(l,Yl,t),s(l,Be,t),s(l,ql,t),s(l,_e,t),s(l,Ll,t),s(l,Ne,t),s(l,zl,t),s(l,Ee,t),y(Pl,l,t),s(l,Fe,t),s(l,Kl,t),ge=!0},p:Rs,i(l){ge||(J(I.$$.fragment,l),J(u.$$.fragment,l),J(o.$$.fragment,l),J(d.$$.fragment,l),J(V.$$.fragment,l),J(R.$$.fragment,l),J(N.$$.fragment,l),J(E.$$.fragment,l),J(g.$$.fragment,l),J(Z.$$.fragment,l),J(G.$$.fragment,l),J(x.$$.fragment,l),J(Q.$$.fragment,l),J(S.$$.fragment,l),J(H.$$.fragment,l),J(q.$$.fragment,l),J(L.$$.fragment,l),J(P.$$.fragment,l),J(K.$$.fragment,l),J(tl.$$.fragment,l),J(sl.$$.fragment,l),J(al.$$.fragment,l),J(il.$$.fragment,l),J(yl.$$.fragment,l),J(Tl.$$.fragment,l),J(ml.$$.fragment,l),J(wl.$$.fragment,l),J(bl.$$.fragment,l),J(ul.$$.fragment,l),J(fl.$$.fragment,l),J(hl.$$.fragment,l),J(Rl.$$.fragment,l),J(_l.$$.fragment,l),J(Nl.$$.fragment,l),J(Fl.$$.fragment,l),J(Zl.$$.fragment,l),J(Gl.$$.fragment,l),J(xl.$$.fragment,l),J(Al.$$.fragment,l),J(Ql.$$.fragment,l),J(Sl.$$.fragment,l),J(Wl.$$.fragment,l),J(vl.$$.fragment,l),J(Pl.$$.fragment,l),ge=!0)},o(l){T(I.$$.fragment,l),T(u.$$.fragment,l),T(o.$$.fragment,l),T(d.$$.fragment,l),T(V.$$.fragment,l),T(R.$$.fragment,l),T(N.$$.fragment,l),T(E.$$.fragment,l),T(g.$$.fragment,l),T(Z.$$.fragment,l),T(G.$$.fragment,l),T(x.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(H.$$.fragment,l),T(q.$$.fragment,l),T(L.$$.fragment,l),T(P.$$.fragment,l),T(K.$$.fragment,l),T(tl.$$.fragment,l),T(sl.$$.fragment,l),T(al.$$.fragment,l),T(il.$$.fragment,l),T(yl.$$.fragment,l),T(Tl.$$.fragment,l),T(ml.$$.fragment,l),T(wl.$$.fragment,l),T(bl.$$.fragment,l),T(ul.$$.fragment,l),T(fl.$$.fragment,l),T(hl.$$.fragment,l),T(Rl.$$.fragment,l),T(_l.$$.fragment,l),T(Nl.$$.fragment,l),T(Fl.$$.fragment,l),T(Zl.$$.fragment,l),T(Gl.$$.fragment,l),T(xl.$$.fragment,l),T(Al.$$.fragment,l),T(Ql.$$.fragment,l),T(Sl.$$.fragment,l),T(Wl.$$.fragment,l),T(vl.$$.fragment,l),T(Pl.$$.fragment,l),ge=!1},d(l){l&&(e(Ol),e(Dl),e(lt),e(tt),e(et),e(st),e(f),e(nt),e(C),e(at),e(Mt),e(h),e(pt),e(it),e($),e(Ut),e(yt),e(B),e(Jt),e(_),e(Tt),e(c),e(rt),e(mt),e(wt),e(F),e(jt),e(bt),e(ct),e(k),e(It),e(ut),e(ot),e(A),e(ft),e(Ct),e(dt),e(X),e(ht),e(W),e(Vt),e(v),e($t),e(Rt),e(Y),e(Bt),e(_t),e(Nt),e(z),e(Et),e(Ft),e(D),e(gt),e(Zt),e(O),e(kt),e(ll),e(Gt),e(xt),e(el),e(At),e(Qt),e(nl),e(St),e(Xt),e(Ml),e(Wt),e(pl),e(vt),e(Ht),e(Ul),e(Yt),e(qt),e(Jl),e(Lt),e(zt),e(rl),e(Pt),e(Dt),e(Kt),e(jl),e(Ot),e(le),e(cl),e(te),e(Il),e(ee),e(se),e(ol),e(ne),e(ae),e(Cl),e(Me),e(dl),e(pe),e(ie),e(Vl),e(Ue),e($l),e(ye),e(Je),e(Bl),e(Te),e(re),e(me),e(El),e(we),e(je),e(gl),e(be),e(ce),e(kl),e(Ie),e(ue),e(oe),e(fe),e(Ce),e(de),e(Xl),e(he),e(Ve),e($e),e(Hl),e(Re),e(Yl),e(Be),e(ql),e(_e),e(Ll),e(Ne),e(zl),e(Ee),e(Fe),e(Kl)),e(b),r(I,l),r(u,l),r(o,l),r(d,l),r(V,l),r(R,l),r(N,l),r(E,l),r(g,l),r(Z,l),r(G,l),r(x,l),r(Q,l),r(S,l),r(H,l),r(q,l),r(L,l),r(P,l),r(K,l),r(tl,l),r(sl,l),r(al,l),r(il,l),r(yl,l),r(Tl,l),r(ml,l),r(wl,l),r(bl,l),r(ul,l),r(fl,l),r(hl,l),r(Rl,l),r(_l,l),r(Nl,l),r(Fl,l),r(Zl,l),r(Gl,l),r(xl,l),r(Al,l),r(Ql,l),r(Sl,l),r(Wl,l),r(vl,l),r(Pl,l)}}}const xs='{"title":"基于 SQL 和 Jina Reranker v2 的 RAG","local":"基于-sql-和-jina-reranker-v2-的-rag","sections":[{"title":"工作原理","local":"工作原理","sections":[],"depth":3},{"title":"数据库","local":"数据库","sections":[],"depth":3},{"title":"软件和硬件要求","local":"软件和硬件要求","sections":[],"depth":3},{"title":"开始","local":"开始","sections":[{"title":"安装环境","local":"安装环境","sections":[],"depth":3},{"title":"下载数据库","local":"下载数据库","sections":[],"depth":3},{"title":"下载并运行 Jina Reranker v2","local":"下载并运行-jina-reranker-v2","sections":[],"depth":3},{"title":"设置 Mistral Instruct 的接口","local":"设置-mistral-instruct-的接口","sections":[],"depth":3}],"depth":2},{"title":"使用 SQL 感知的 Jina Reranker v2","local":"使用-sql-感知的-jina-reranker-v2","sections":[],"depth":2},{"title":"使用 Mistral Instruct 生成 SQL 查询","local":"使用-mistral-instruct-生成-sql-查询","sections":[],"depth":2},{"title":"运行 SQL 查询","local":"运行-sql-查询","sections":[],"depth":2},{"title":"获取自然语言回答","local":"获取自然语言回答","sections":[],"depth":2},{"title":"尝试自己动手","local":"尝试自己动手","sections":[],"depth":2},{"title":"复习与总结","local":"复习与总结","sections":[],"depth":2}],"depth":1}';function As(ke){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends _s{constructor(b){super(),Ns(this,b,As,Gs,$s,{})}}export{Hs as component};
