import{s as me,n as re,o as he}from"../chunks/scheduler.1f027d5a.js";import{S as Je,i as je,e as p,s as a,c as M,h as Te,a as o,d as e,b as n,f as Is,g as c,j as i,k as fs,l as Ue,m as t,n as y,t as m,o as r,p as h}from"../chunks/index.6117a65d.js";import{C as ue}from"../chunks/CopyLLMTxtMenu.93325501.js";import{D as de,C as J}from"../chunks/DocNotebookDropdown.316c3715.js";import{H as j,E as we}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.0eecd2bb.js";function be(Rl){let T,Bs,bs,Cs,U,Zs,u,Gs,d,Ws,w,kl='<em>作者: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',_s,b,Al="这个 notebook 展示了如何轻松地从 OpenAI 模型过渡到 Open LLMs，而无需重构任何现有代码。",vs,g,El='<a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">文本生成推理（TGI）</a>现在提供了一个<a href="https://huggingface.co/blog/tgi-messages-api" rel="nofollow">消息 API</a>，使其与 OpenAI 的聊天完成 API 的直接兼容。这意味着任何使用 OpenAI 的模型（通过 OpenAI 客户端库或像 LangChain 或 LlamaIndex 这样的第三方工具）的现有脚本都可以直接替换为使用运行在 TGI 端点上的任何开源 LLM！',Rs,I,Nl="这允许你快速测试并受益于开源模型提供的众多优势。例如：",ks,f,Vl="<li><p>对模型和数据的完全控制和透明度</p></li> <li><p>不再担心速率限制</p></li> <li><p>能够根据你的具体需求完全定制系统</p></li>",As,B,Xl="在这个 notebook 中，我们将向你展示具体流程：",Es,C,xl='<li><a href="#section_1">使用 TGI 创建推理端点来部署模型</a></li> <li><a href="#section_2">使用 OpenAI 客户端库查询推理端点</a></li> <li><a href="#section_3">将端点与 LangChain 和 LlamaIndex 工作流程集成</a></li>',Ns,Z,$l="<strong>让我们开始吧！</strong>",Vs,G,Xs,W,Ql="首先，我们需要安装依赖项和设置一个 HF API 密钥。",xs,_,$s,v,Qs,us,Ss,R,Fs,k,Sl='一开始，让我们使用 TGI 将<a href="https://huggingface.co/NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO" rel="nofollow">Nous-Hermes-2-Mixtral-8x7B-DPO</a>，一个微调的 Mixtral 模型，部署到推理端点。',Ys,A,Fl='我们只需通过 UI 的<a href="https://ui.endpoints.huggingface.co/new?vendor=aws&amp;repository=NousResearch%2FNous-Hermes-2-Mixtral-8x7B-DPO&amp;tgi_max_total_tokens=32000&amp;tgi=true&amp;tgi_max_input_length=1024&amp;task=text-generation&amp;instance_size=2xlarge&amp;tgi_max_batch_prefill_tokens=2048&amp;tgi_max_batch_total_tokens=1024000&amp;no_suggested_compute=true&amp;accelerator=gpu&amp;region=us-east-1" rel="nofollow">几次点击</a>，就可以部署模型，或者利用 <code>huggingface_hub</code> Python 库以编程方式创建和管理推理端点。',Hs,E,Yl='在这里，我们将使用 Hub 库，通过指定端点名称和模型仓库，以及 <code>text-generation</code> 任务。在这个例子中，我们使用 <code>protected</code> 类型，因此访问部署的模型将需要一个有效的 Hugging Face token。我们还需要配置硬件要求，如供应商、地区、加速器、实例类型和大小。你可以使用<a href="https://api.endpoints.huggingface.cloud/#get-/v2/provider" rel="nofollow">this API call</a>查看可用的资源选项列表，并在目录中<a href="https://ui.endpoints.huggingface.co/catalog" rel="nofollow">这里</a>查看为选定模型推荐配置。',qs,N,Ls,V,Hl=`running
`,zs,X,ql="部署启动需要几分钟时间。我们可以使用 <code>.wait()</code> 工具来阻塞运行线程，直到端点达到最终的“运行”状态。一旦运行，我们可以在 UI 播放器中确认其状态并试用：",Ps,x,Ll='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/messages-api/endpoint-overview.png" alt="IE UI Overview"/>',Os,$,zl="太好了，现在我们有一个可用的端点！",Ds,Q,Pl='<em>注意：使用 <code>huggingface_hub</code> 部署时，默认情况下，在15分钟空闲时间后，你的端点会自动缩放到零，以在非活动期间优化成本。查看<a href="https://huggingface.co/docs/huggingface_hub/guides/inference_endpoints" rel="nofollow">Hub Python 库文档</a>以了解可用于管理端点生命周期的所有功能。</em>',Ks,ds,sl,S,ll,F,Ol="如上所述，由于我们的模型托管在 TGI 上，现在支持消息 API，这意味着我们可以直接使用熟悉的 OpenAI 客户端库来查询它。",el,Y,tl,H,Dl='下面的例子展示了如何使用<a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI Python 库</a>进行这种转换。只需将 <code>&lt;ENDPOINT_URL&gt;</code> 替换为你的端点 URL（确保包含 <code>v1/</code> 后缀），并将 <code>&lt;HF_API_KEY&gt;</code> 字段填充为有效的 Hugging Face 用户 token。<code>&lt;ENDPOINT_URL&gt;</code> 可以从推理端点的 UI 中获取，或者从我们上面使用 <code>endpoint.url</code> 创建的端点对象中获取。',al,q,Kl="然后我们可以像往常一样使用客户端，传递一个消息列表以从我们的推理端点流式传输响应。",nl,L,pl,z,se=`Open-source software is important due to a number of reasons, including:

1. Collaboration: The collaborative nature of open-source software allows developers from around the world to work together, share their ideas and improve the code. This often results in faster progress and better software.

2. Transparency: With open-source software, the code is publicly available, making it easy to see exactly how the software functions, and allowing users to determine if there are any security vulnerabilities.

3. Customization: Being able to access the code also allows users to customize the software to better suit their needs. This makes open-source software incredibly versatile, as users can tweak it to suit their specific use case.

4. Quality: Open-source software is often developed by large communities of dedicated developers, who work together to improve the software. This results in a higher level of quality than might be found in proprietary software.

5. Cost: Open-source software is often provided free of charge, which makes it accessible to a wider range of users. This can be especially important for organizations with limited budgets for software.

6. Shared Benefit: By sharing the code of open-source software, everyone can benefit from the hard work of the developers. This contributes to the overall advancement of technology, as users and developers work together to improve and build upon the software.

In summary, open-source software provides a collaborative platform that leads to high-quality, customizable, and transparent software, all available at little or no cost, benefiting both individuals and the technology community as a whole.<|im_end|>
`,ol,P,le='在幕后，TGI 的消息 API 自动使用其<a href="https://huggingface.co/docs/transformers/chat_templating" rel="nofollow">聊天模板</a>将消息列表转换为模型所需的指令格式。',il,O,ee="<em>注意：某些 OpenAI 功能，如函数调用，与 TGI 不兼容。目前，消息 API 支持以下 chat completion 参数：<code>stream</code>、<code>max_new_tokens</code>、<code>frequency_penalty</code>、<code>logprobs</code>、<code>seed</code>、<code>temperature</code> 和 <code>top_p</code>.</em>",Ml,D,cl,K,te='这里是与上面相同的流式示例，但是使用了<a href="https://github.com/openai/openai-node" rel="nofollow">OpenAI Javascript/Typescript 库</a>。',yl,ss,ml,ws,rl,ls,hl,es,ae="现在，让我们看看如何将这个新创建的端点与像 LangChain 和 LlamaIndex 这样的流行 RAG 框架一起使用。",Jl,ts,jl,as,ne='要在 <a href="https://python.langchain.com/docs/get_started/introduction" rel="nofollow">LangChain</a> 中使用，只需创建一个 <code>ChatOpenAI</code> 的实例，并按如下方式传递你的 <code>&lt;ENDPOINT_URL&gt;</code> 和 <code>&lt;HF_API_TOKEN&gt;</code>：',Tl,ns,Ul,ps,pe="我们能够直接利用与 OpenAI 模型相同的 <code>ChatOpenAI</code> 类。这使得所有之前的代码只需更改一行代码，就能与我们的端点一起工作。",ul,os,oe="现在，让我们在简单的 RAG 流水线中使用我们的 Mixtral 模型，来回答一个关于 HF 博客内容的问题。",dl,is,wl,Ms,bl,cs,ie='类似地，你也可以在 <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex</a> 中使用 TGI 端点。我们将使用 <code>OpenAILike</code> 类，并通过配置一些额外的参数（即 <code>is_local</code>、<code>is_function_calling_model</code>、<code>is_chat_model</code>、<code>context_window</code>）来实例化它。',gl,ys,Me="<em>注意：上下文窗口参数应与之前为端点的 <code>MAX_TOTAL_TOKENS</code> 设置的值相匹配。</em>",Il,ms,fl,rs,ce="现在我们可以使用它在类似的 RAG 流水线中。请记住，之前在推理端点选择的 <code>MAX_INPUT_LENGTH</code> 将直接影响模型可以处理的检索到的数据块（<code>similarity_top_k</code>）的数量。",Bl,hs,Cl,Js,Zl,js,ye="完成端点使用后，你可以暂停或删除它。这一步可以通过 UI 完成，或者像下面这样以编程方式完成。",Gl,Ts,Wl,Us,_l,gs,vl;return U=new de({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/tgi_messages_api_demo.ipynb"}]}}),u=new ue({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new j({props:{title:"使用 TGI 的消息 API 从 OpenAI 迁移到 Open LLMs",local:"使用-tgi-的消息-api-从-openai-迁移到-open-llms",headingTag:"h1"}}),G=new j({props:{title:"初始化设置",local:"初始化设置",headingTag:"h2"}}),_=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtcSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjBsYW5nY2hhaW5odWIlMjBsYW5nY2hhaW4tb3BlbmFpJTIwbGxhbWEtaW5kZXglMjBjaHJvbWFkYiUyMGJzNCUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMHRvcmNo",highlighted:"!pip install --upgrade -q huggingface_hub langchain langchain-community langchainhub langchain-openai llama-index chromadb bs4 sentence_transformers torch",wrap:!1}}),v=new J({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwZW50ZXIlMjBBUEklMjBrZXklMEFvcy5lbnZpcm9uJTVCJTIySFVHR0lOR0ZBQ0VIVUJfQVBJX1RPS0VOJTIyJTVEJTIwJTNEJTIwSEZfQVBJX0tFWSUyMCUzRCUyMGdldHBhc3MuZ2V0cGFzcygp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> getpass

<span class="hljs-comment"># enter API key</span>
os.environ[<span class="hljs-string">&quot;HUGGINGFACEHUB_API_TOKEN&quot;</span>] = HF_API_KEY = getpass.getpass()`,wrap:!1}}),R=new j({props:{title:"1. 创建一个推理端点",local:"1-创建一个推理端点",headingTag:"h2"}}),N=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybm91cy1oZXJtZXMtMi1taXh0cmFsLTh4N2ItZGVtbyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJOb3VzUmVzZWFyY2glMkZOb3VzLUhlcm1lcy0yLU1peHRyYWwtOHg3Qi1EUE8lMjIlMkMlMEElMjAlMjAlMjAlMjBmcmFtZXdvcmslM0QlMjJweXRvcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTNEJTIyZ3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVuZG9yJTNEJTIyYXdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVnaW9uJTNEJTIydXMtZWFzdC0xJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnByb3RlY3RlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QlMjJwNGRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfSU5QVVRfTEVOR1RIJTIyJTNBJTIwJTIyNDA5NiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1BWF9CQVRDSF9QUkVGSUxMX1RPS0VOUyUyMiUzQSUyMCUyMjQwOTYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMzIwMDAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTAyNDAwMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0FzaGEtMTczNDU0MCUyMiUyQyUyMCUyMCUyMyUyMG11c3QlMjBiZSUyMCUzRSUzRCUyMDEuNC4wJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKSUwQSUwQWVuZHBvaW50LndhaXQoKSUwQXByaW50KGVuZHBvaW50LnN0YXR1cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;nous-hermes-2-mixtral-8x7b-demo&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;NousResearch/Nous-Hermes-2-Mixtral-8x7B-DPO&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;p4de&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;2xlarge&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;32000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1024000&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:sha-1734540&quot;</span>,  <span class="hljs-comment"># must be &gt;= 1.4.0</span>
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(endpoint.status)`,wrap:!1}}),S=new j({props:{title:"2. 使用 OpenAI 客户端库查询推理端点",local:"2-使用-openai-客户端库查询推理端点",headingTag:"h2"}}),Y=new j({props:{title:"使用 Python 客户端",local:"使用-python-客户端",headingTag:"h3"}}),L=new J({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQUJBU0VfVVJMJTIwJTNEJTIwZW5kcG9pbnQudXJsJTBBJTBBJTIzJTIwaW5pdCUyMHRoZSUyMGNsaWVudCUyMGJ1dCUyMHBvaW50JTIwaXQlMjB0byUyMFRHSSUwQWNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRG9zLnBhdGguam9pbihCQVNFX1VSTCUyQyUyMCUyMnYxJTJGJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBKSUwQWNoYXRfY29tcGxldGlvbiUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDUwMCUyQyUwQSklMEElMEElMjMlMjBpdGVyYXRlJTIwYW5kJTIwcHJpbnQlMjBzdHJlYW0lMEFmb3IlMjBtZXNzYWdlJTIwaW4lMjBjaGF0X2NvbXBsZXRpb24lM0ElMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMkMlMjBlbmQlM0QlMjIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-meta">&gt;&gt;&gt; </span>BASE_URL = endpoint.url

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># init the client but point it to TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = OpenAI(
<span class="hljs-meta">... </span>    base_url=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
<span class="hljs-meta">... </span>    api_key=HF_API_KEY,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>chat_completion = client.chat.completions.create(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tgi&quot;</span>,
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span>},
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(message.choices[<span class="hljs-number">0</span>].delta.content, end=<span class="hljs-string">&quot;&quot;</span>)`,wrap:!1}}),D=new j({props:{title:"使用 JavaScript 客户端",local:"使用-javascript-客户端",headingTag:"h3"}}),ss=new J({props:{code:"aW1wb3J0JTIwT3BlbkFJJTIwZnJvbSUyMCUyMm9wZW5haSUyMiUzQiUwQSUwQWNvbnN0JTIwb3BlbmFpJTIwJTNEJTIwbmV3JTIwT3BlbkFJKCU3QiUwQSUyMCUyMGJhc2VVUkwlM0ElMjAlMjIlM0NFTkRQT0lOVF9VUkwlM0UlMjIlMjAlMkIlMjAlMjIlMkZ2MSUyRiUyMiUyQyUyMCUyRiUyRiUyMHJlcGxhY2UlMjB3aXRoJTIweW91ciUyMGVuZHBvaW50JTIwdXJsJTBBJTIwJTIwYXBpS2V5JTNBJTIwJTIyJTNDSEZfQVBJX1RPS0VOJTNFJTIyJTJDJTIwJTJGJTJGJTIwcmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwdG9rZW4lMEElN0QpJTNCJTBBJTBBYXN5bmMlMjBmdW5jdGlvbiUyMG1haW4oKSUyMCU3QiUwQSUyMCUyMGNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwYXdhaXQlMjBvcGVuYWkuY2hhdC5jb21wbGV0aW9ucy5jcmVhdGUoJTdCJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0Z2klMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMHJvbGUlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnVzZXIlMjIlMkMlMjBjb250ZW50JTNBJTIwJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0ElMjA1MDAlMkMlMEElMjAlMjAlN0QpJTNCJTBBJTIwJTIwZm9yJTIwYXdhaXQlMjAoY29uc3QlMjBjaHVuayUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKGNodW5rLmNob2ljZXMlNUIwJTVEJTNGLmRlbHRhJTNGLmNvbnRlbnQlMjAlN0MlN0MlMjAlMjIlMjIpJTNCJTBBJTIwJTIwJTdEJTBBJTdEJTBBJTBBbWFpbigpJTNC",highlighted:`<span class="hljs-keyword">import</span> <span class="hljs-title class_">OpenAI</span> <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> openai = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAI</span>({
  <span class="hljs-attr">baseURL</span>: <span class="hljs-string">&quot;&lt;ENDPOINT_URL&gt;&quot;</span> + <span class="hljs-string">&quot;/v1/&quot;</span>, <span class="hljs-comment">// replace with your endpoint url</span>
  <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;&lt;HF_API_TOKEN&gt;&quot;</span>, <span class="hljs-comment">// replace with your token</span>
});

<span class="hljs-keyword">async</span> <span class="hljs-keyword">function</span> <span class="hljs-title function_">main</span>(<span class="hljs-params"></span>) {
  <span class="hljs-keyword">const</span> stream = <span class="hljs-keyword">await</span> openai.<span class="hljs-property">chat</span>.<span class="hljs-property">completions</span>.<span class="hljs-title function_">create</span>({
    <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
    <span class="hljs-attr">messages</span>: [
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
      { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;Why is open-source software important?&quot;</span> },
    ],
    <span class="hljs-attr">stream</span>: <span class="hljs-literal">true</span>,
    <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">500</span>,
  });
  <span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> chunk <span class="hljs-keyword">of</span> stream) {
    process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(chunk.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>]?.<span class="hljs-property">delta</span>?.<span class="hljs-property">content</span> || <span class="hljs-string">&quot;&quot;</span>);
  }
}

<span class="hljs-title function_">main</span>();`,wrap:!1}}),ls=new j({props:{title:"3. 与 LangChain 和 LlamaIndex 集成",local:"3-与-langchain-和-llamaindex-集成",headingTag:"h2"}}),ts=new j({props:{title:"如何与 LangChain 一起使用",local:"如何与-langchain-一起使用",headingTag:"h3"}}),ns=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBJTBBbGxtJTIwJTNEJTIwQ2hhdE9wZW5BSSglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwb3BlbmFpX2FwaV9iYXNlJTNEb3MucGF0aC5qb2luKEJBU0VfVVJMJTJDJTIwJTIydjElMkYlMjIpJTJDJTBBKSUwQWxsbS5pbnZva2UoJTIyV2h5JTIwaXMlMjBvcGVuLXNvdXJjZSUyMHNvZnR3YXJlJTIwaW1wb3J0YW50JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI

llm = ChatOpenAI(
    model_name=<span class="hljs-string">&quot;tgi&quot;</span>,
    openai_api_key=HF_API_KEY,
    openai_api_base=os.path.join(BASE_URL, <span class="hljs-string">&quot;v1/&quot;</span>),
)
llm.invoke(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),is=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain <span class="hljs-keyword">import</span> hub
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.document_loaders <span class="hljs-keyword">import</span> WebBaseLoader
<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough
<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnableParallel
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-comment"># Load, chunk and index the contents of the blog</span>
loader = WebBaseLoader(
    web_paths=(<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>,),
)
docs = loader.load()

<span class="hljs-comment"># declare an HF embedding model</span>
hf_embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

text_splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">200</span>)
splits = text_splitter.split_documents(docs)
vectorstore = Chroma.from_documents(documents=splits, embedding=hf_embeddings)

<span class="hljs-comment"># Retrieve and generate using the relevant snippets of the blog</span>
retriever = vectorstore.as_retriever()
prompt = hub.pull(<span class="hljs-string">&quot;rlm/rag-prompt&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_docs</span>(<span class="hljs-params">docs</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs)


rag_chain_from_docs = (
    RunnablePassthrough.assign(context=(<span class="hljs-keyword">lambda</span> x: format_docs(x[<span class="hljs-string">&quot;context&quot;</span>])))
    | prompt
    | llm
    | StrOutputParser()
)

rag_chain_with_source = RunnableParallel(
    {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()}
).assign(answer=rag_chain_from_docs)

rag_chain_with_source.invoke(
    <span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>
)`,wrap:!1}}),Ms=new j({props:{title:"如何与 LlamaIndex 一起使用",local:"如何与-llamaindex-一起使用",headingTag:"h3"}}),ms=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMlMjBpbXBvcnQlMjBPcGVuQUlMaWtlJTBBJTBBbGxtJTIwJTNEJTIwT3BlbkFJTGlrZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnRnaSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RIRl9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0RCQVNFX1VSTCUyMCUyQiUyMCUyMiUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfY2hhdF9tb2RlbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBpc19sb2NhbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwaXNfZnVuY3Rpb25fY2FsbGluZ19tb2RlbCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF93aW5kb3clM0Q0MDk2JTJDJTBBKSUwQSUwQWxsbS5jb21wbGV0ZSglMjJXaHklMjBpcyUyMG9wZW4tc291cmNlJTIwc29mdHdhcmUlMjBpbXBvcnRhbnQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms <span class="hljs-keyword">import</span> OpenAILike

llm = OpenAILike(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    api_key=HF_API_KEY,
    api_base=BASE_URL + <span class="hljs-string">&quot;/v1/&quot;</span>,
    is_chat_model=<span class="hljs-literal">True</span>,
    is_local=<span class="hljs-literal">False</span>,
    is_function_calling_model=<span class="hljs-literal">False</span>,
    context_window=<span class="hljs-number">4096</span>,
)

llm.complete(<span class="hljs-string">&quot;Why is open-source software important?&quot;</span>)`,wrap:!1}}),hs=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4JTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMFNlcnZpY2VDb250ZXh0JTJDJTBBJTIwJTIwJTIwJTIwVmVjdG9yU3RvcmVJbmRleCUyQyUwQSklMEFmcm9tJTIwbGxhbWFfaW5kZXglMjBpbXBvcnQlMjBkb3dubG9hZF9sb2FkZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nJTBBZnJvbSUyMGxsYW1hX2luZGV4LnF1ZXJ5X2VuZ2luZSUyMGltcG9ydCUyMENpdGF0aW9uUXVlcnlFbmdpbmUlMEElMEElMEFTaW1wbGVXZWJQYWdlUmVhZGVyJTIwJTNEJTIwZG93bmxvYWRfbG9hZGVyKCUyMlNpbXBsZVdlYlBhZ2VSZWFkZXIlMjIpJTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwU2ltcGxlV2ViUGFnZVJlYWRlcihodG1sX3RvX3RleHQlM0RUcnVlKS5sb2FkX2RhdGEoJTBBJTIwJTIwJTIwJTIwJTVCJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmJsb2clMkZvcGVuLXNvdXJjZS1sbG1zLWFzLWFnZW50cyUyMiU1RCUwQSklMEElMEElMjMlMjBMb2FkJTIwZW1iZWRkaW5nJTIwbW9kZWwlMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWxhcmdlLWVuLXYxLjUlMjIpJTBBJTBBJTIzJTIwUGFzcyUyMExMTSUyMHRvJTIwcGlwZWxpbmUlMEFzZXJ2aWNlX2NvbnRleHQlMjAlM0QlMjBTZXJ2aWNlQ29udGV4dC5mcm9tX2RlZmF1bHRzKGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwlMkMlMjBsbG0lM0RsbG0pJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fZG9jdW1lbnRzKCUwQSUyMCUyMCUyMCUyMGRvY3VtZW50cyUyQyUyMHNlcnZpY2VfY29udGV4dCUzRHNlcnZpY2VfY29udGV4dCUyQyUyMHNob3dfcHJvZ3Jlc3MlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMFF1ZXJ5JTIwdGhlJTIwaW5kZXglMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBDaXRhdGlvblF1ZXJ5RW5naW5lLmZyb21fYXJncyglMEElMjAlMjAlMjAlMjBpbmRleCUyQyUwQSUyMCUyMCUyMCUyMHNpbWlsYXJpdHlfdG9wX2slM0QyJTJDJTBBKSUwQXJlc3BvbnNlJTIwJTNEJTIwcXVlcnlfZW5naW5lLnF1ZXJ5KCUwQSUyMCUyMCUyMCUyMCUyMkFjY29yZGluZyUyMHRvJTIwdGhpcyUyMGFydGljbGUlMjB3aGljaCUyMG9wZW4tc291cmNlJTIwbW9kZWwlMjBpcyUyMHRoZSUyMGJlc3QlMjBmb3IlMjBhbiUyMGFnZW50JTIwYmVoYXZpb3VyJTNGJTIyJTBBKSUwQSUwQXJlc3BvbnNlLnJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> llama_index <span class="hljs-keyword">import</span> (
    ServiceContext,
    VectorStoreIndex,
)
<span class="hljs-keyword">from</span> llama_index <span class="hljs-keyword">import</span> download_loader
<span class="hljs-keyword">from</span> llama_index.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.query_engine <span class="hljs-keyword">import</span> CitationQueryEngine


SimpleWebPageReader = download_loader(<span class="hljs-string">&quot;SimpleWebPageReader&quot;</span>)

documents = SimpleWebPageReader(html_to_text=<span class="hljs-literal">True</span>).load_data(
    [<span class="hljs-string">&quot;https://huggingface.co/blog/open-source-llms-as-agents&quot;</span>]
)

<span class="hljs-comment"># Load embedding model</span>
embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-large-en-v1.5&quot;</span>)

<span class="hljs-comment"># Pass LLM to pipeline</span>
service_context = ServiceContext.from_defaults(embed_model=embed_model, llm=llm)
index = VectorStoreIndex.from_documents(
    documents, service_context=service_context, show_progress=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Query the index</span>
query_engine = CitationQueryEngine.from_args(
    index,
    similarity_top_k=<span class="hljs-number">2</span>,
)
response = query_engine.query(
    <span class="hljs-string">&quot;According to this article which open-source model is the best for an agent behaviour?&quot;</span>
)

response.response`,wrap:!1}}),Js=new j({props:{title:"总结",local:"总结",headingTag:"h2"}}),Ts=new J({props:{code:"JTIzJTIwcGF1c2UlMjBvdXIlMjBydW5uaW5nJTIwZW5kcG9pbnQlMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBJTIzJTIwb3B0aW9uYWxseSUyMGRlbGV0ZSUwQSUyMyUyMGVuZHBvaW50LmRlbGV0ZSgp",highlighted:`<span class="hljs-comment"># pause our running endpoint</span>
endpoint.pause()

<span class="hljs-comment"># optionally delete</span>
<span class="hljs-comment"># endpoint.delete()</span>`,wrap:!1}}),Us=new we({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/tgi_messages_api_demo.md"}}),{c(){T=p("meta"),Bs=a(),bs=p("p"),Cs=a(),M(U.$$.fragment),Zs=a(),M(u.$$.fragment),Gs=a(),M(d.$$.fragment),Ws=a(),w=p("p"),w.innerHTML=kl,_s=a(),b=p("p"),b.textContent=Al,vs=a(),g=p("p"),g.innerHTML=El,Rs=a(),I=p("p"),I.textContent=Nl,ks=a(),f=p("ul"),f.innerHTML=Vl,As=a(),B=p("p"),B.textContent=Xl,Es=a(),C=p("ol"),C.innerHTML=xl,Ns=a(),Z=p("p"),Z.innerHTML=$l,Vs=a(),M(G.$$.fragment),Xs=a(),W=p("p"),W.textContent=Ql,xs=a(),M(_.$$.fragment),$s=a(),M(v.$$.fragment),Qs=a(),us=p("a"),Ss=a(),M(R.$$.fragment),Fs=a(),k=p("p"),k.innerHTML=Sl,Ys=a(),A=p("p"),A.innerHTML=Fl,Hs=a(),E=p("p"),E.innerHTML=Yl,qs=a(),M(N.$$.fragment),Ls=a(),V=p("pre"),V.textContent=Hl,zs=a(),X=p("p"),X.innerHTML=ql,Ps=a(),x=p("p"),x.innerHTML=Ll,Os=a(),$=p("p"),$.textContent=zl,Ds=a(),Q=p("p"),Q.innerHTML=Pl,Ks=a(),ds=p("a"),sl=a(),M(S.$$.fragment),ll=a(),F=p("p"),F.textContent=Ol,el=a(),M(Y.$$.fragment),tl=a(),H=p("p"),H.innerHTML=Dl,al=a(),q=p("p"),q.textContent=Kl,nl=a(),M(L.$$.fragment),pl=a(),z=p("pre"),z.textContent=se,ol=a(),P=p("p"),P.innerHTML=le,il=a(),O=p("p"),O.innerHTML=ee,Ml=a(),M(D.$$.fragment),cl=a(),K=p("p"),K.innerHTML=te,yl=a(),M(ss.$$.fragment),ml=a(),ws=p("a"),rl=a(),M(ls.$$.fragment),hl=a(),es=p("p"),es.textContent=ae,Jl=a(),M(ts.$$.fragment),jl=a(),as=p("p"),as.innerHTML=ne,Tl=a(),M(ns.$$.fragment),Ul=a(),ps=p("p"),ps.innerHTML=pe,ul=a(),os=p("p"),os.textContent=oe,dl=a(),M(is.$$.fragment),wl=a(),M(Ms.$$.fragment),bl=a(),cs=p("p"),cs.innerHTML=ie,gl=a(),ys=p("p"),ys.innerHTML=Me,Il=a(),M(ms.$$.fragment),fl=a(),rs=p("p"),rs.innerHTML=ce,Bl=a(),M(hs.$$.fragment),Cl=a(),M(Js.$$.fragment),Zl=a(),js=p("p"),js.textContent=ye,Gl=a(),M(Ts.$$.fragment),Wl=a(),M(Us.$$.fragment),_l=a(),gs=p("p"),this.h()},l(s){const l=Te("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(e),Bs=n(s),bs=o(s,"P",{}),Is(bs).forEach(e),Cs=n(s),c(U.$$.fragment,s),Zs=n(s),c(u.$$.fragment,s),Gs=n(s),c(d.$$.fragment,s),Ws=n(s),w=o(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-gj6lv3"&&(w.innerHTML=kl),_s=n(s),b=o(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-gvqzpn"&&(b.textContent=Al),vs=n(s),g=o(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-tx3r7i"&&(g.innerHTML=El),Rs=n(s),I=o(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1m0fhjl"&&(I.textContent=Nl),ks=n(s),f=o(s,"UL",{"data-svelte-h":!0}),i(f)!=="svelte-9taer4"&&(f.innerHTML=Vl),As=n(s),B=o(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-wrnr8s"&&(B.textContent=Xl),Es=n(s),C=o(s,"OL",{"data-svelte-h":!0}),i(C)!=="svelte-7jcplu"&&(C.innerHTML=xl),Ns=n(s),Z=o(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1g5cpqq"&&(Z.innerHTML=$l),Vs=n(s),c(G.$$.fragment,s),Xs=n(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-dpvmsr"&&(W.textContent=Ql),xs=n(s),c(_.$$.fragment,s),$s=n(s),c(v.$$.fragment,s),Qs=n(s),us=o(s,"A",{id:!0}),Is(us).forEach(e),Ss=n(s),c(R.$$.fragment,s),Fs=n(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-hqnmm4"&&(k.innerHTML=Sl),Ys=n(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-11y3s3v"&&(A.innerHTML=Fl),Hs=n(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-11oqr2t"&&(E.innerHTML=Yl),qs=n(s),c(N.$$.fragment,s),Ls=n(s),V=o(s,"PRE",{"data-svelte-h":!0}),i(V)!=="svelte-105t8kl"&&(V.textContent=Hl),zs=n(s),X=o(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-btosjl"&&(X.innerHTML=ql),Ps=n(s),x=o(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-8mpmx4"&&(x.innerHTML=Ll),Os=n(s),$=o(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-wekg0z"&&($.textContent=zl),Ds=n(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-8b7wws"&&(Q.innerHTML=Pl),Ks=n(s),ds=o(s,"A",{id:!0}),Is(ds).forEach(e),sl=n(s),c(S.$$.fragment,s),ll=n(s),F=o(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1b0mawc"&&(F.textContent=Ol),el=n(s),c(Y.$$.fragment,s),tl=n(s),H=o(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-jfegsc"&&(H.innerHTML=Dl),al=n(s),q=o(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-fn3u1g"&&(q.textContent=Kl),nl=n(s),c(L.$$.fragment,s),pl=n(s),z=o(s,"PRE",{"data-svelte-h":!0}),i(z)!=="svelte-1gevisn"&&(z.textContent=se),ol=n(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-10twgq8"&&(P.innerHTML=le),il=n(s),O=o(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-14nrlto"&&(O.innerHTML=ee),Ml=n(s),c(D.$$.fragment,s),cl=n(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1if4f8u"&&(K.innerHTML=te),yl=n(s),c(ss.$$.fragment,s),ml=n(s),ws=o(s,"A",{id:!0}),Is(ws).forEach(e),rl=n(s),c(ls.$$.fragment,s),hl=n(s),es=o(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-15wg5yj"&&(es.textContent=ae),Jl=n(s),c(ts.$$.fragment,s),jl=n(s),as=o(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1pjk2if"&&(as.innerHTML=ne),Tl=n(s),c(ns.$$.fragment,s),Ul=n(s),ps=o(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-1mgsk2v"&&(ps.innerHTML=pe),ul=n(s),os=o(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1u6vict"&&(os.textContent=oe),dl=n(s),c(is.$$.fragment,s),wl=n(s),c(Ms.$$.fragment,s),bl=n(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-1s6qa1c"&&(cs.innerHTML=ie),gl=n(s),ys=o(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1auj9mh"&&(ys.innerHTML=Me),Il=n(s),c(ms.$$.fragment,s),fl=n(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-e01zk6"&&(rs.innerHTML=ce),Bl=n(s),c(hs.$$.fragment,s),Cl=n(s),c(Js.$$.fragment,s),Zl=n(s),js=o(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-exd6y8"&&(js.textContent=ye),Gl=n(s),c(Ts.$$.fragment,s),Wl=n(s),c(Us.$$.fragment,s),_l=n(s),gs=o(s,"P",{}),Is(gs).forEach(e),this.h()},h(){fs(T,"name","hf:doc:metadata"),fs(T,"content",ge),fs(us,"id","section_1"),fs(ds,"id","section_2"),fs(ws,"id","section_3")},m(s,l){Ue(document.head,T),t(s,Bs,l),t(s,bs,l),t(s,Cs,l),y(U,s,l),t(s,Zs,l),y(u,s,l),t(s,Gs,l),y(d,s,l),t(s,Ws,l),t(s,w,l),t(s,_s,l),t(s,b,l),t(s,vs,l),t(s,g,l),t(s,Rs,l),t(s,I,l),t(s,ks,l),t(s,f,l),t(s,As,l),t(s,B,l),t(s,Es,l),t(s,C,l),t(s,Ns,l),t(s,Z,l),t(s,Vs,l),y(G,s,l),t(s,Xs,l),t(s,W,l),t(s,xs,l),y(_,s,l),t(s,$s,l),y(v,s,l),t(s,Qs,l),t(s,us,l),t(s,Ss,l),y(R,s,l),t(s,Fs,l),t(s,k,l),t(s,Ys,l),t(s,A,l),t(s,Hs,l),t(s,E,l),t(s,qs,l),y(N,s,l),t(s,Ls,l),t(s,V,l),t(s,zs,l),t(s,X,l),t(s,Ps,l),t(s,x,l),t(s,Os,l),t(s,$,l),t(s,Ds,l),t(s,Q,l),t(s,Ks,l),t(s,ds,l),t(s,sl,l),y(S,s,l),t(s,ll,l),t(s,F,l),t(s,el,l),y(Y,s,l),t(s,tl,l),t(s,H,l),t(s,al,l),t(s,q,l),t(s,nl,l),y(L,s,l),t(s,pl,l),t(s,z,l),t(s,ol,l),t(s,P,l),t(s,il,l),t(s,O,l),t(s,Ml,l),y(D,s,l),t(s,cl,l),t(s,K,l),t(s,yl,l),y(ss,s,l),t(s,ml,l),t(s,ws,l),t(s,rl,l),y(ls,s,l),t(s,hl,l),t(s,es,l),t(s,Jl,l),y(ts,s,l),t(s,jl,l),t(s,as,l),t(s,Tl,l),y(ns,s,l),t(s,Ul,l),t(s,ps,l),t(s,ul,l),t(s,os,l),t(s,dl,l),y(is,s,l),t(s,wl,l),y(Ms,s,l),t(s,bl,l),t(s,cs,l),t(s,gl,l),t(s,ys,l),t(s,Il,l),y(ms,s,l),t(s,fl,l),t(s,rs,l),t(s,Bl,l),y(hs,s,l),t(s,Cl,l),y(Js,s,l),t(s,Zl,l),t(s,js,l),t(s,Gl,l),y(Ts,s,l),t(s,Wl,l),y(Us,s,l),t(s,_l,l),t(s,gs,l),vl=!0},p:re,i(s){vl||(m(U.$$.fragment,s),m(u.$$.fragment,s),m(d.$$.fragment,s),m(G.$$.fragment,s),m(_.$$.fragment,s),m(v.$$.fragment,s),m(R.$$.fragment,s),m(N.$$.fragment,s),m(S.$$.fragment,s),m(Y.$$.fragment,s),m(L.$$.fragment,s),m(D.$$.fragment,s),m(ss.$$.fragment,s),m(ls.$$.fragment,s),m(ts.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(Ms.$$.fragment,s),m(ms.$$.fragment,s),m(hs.$$.fragment,s),m(Js.$$.fragment,s),m(Ts.$$.fragment,s),m(Us.$$.fragment,s),vl=!0)},o(s){r(U.$$.fragment,s),r(u.$$.fragment,s),r(d.$$.fragment,s),r(G.$$.fragment,s),r(_.$$.fragment,s),r(v.$$.fragment,s),r(R.$$.fragment,s),r(N.$$.fragment,s),r(S.$$.fragment,s),r(Y.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(ts.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(Js.$$.fragment,s),r(Ts.$$.fragment,s),r(Us.$$.fragment,s),vl=!1},d(s){s&&(e(Bs),e(bs),e(Cs),e(Zs),e(Gs),e(Ws),e(w),e(_s),e(b),e(vs),e(g),e(Rs),e(I),e(ks),e(f),e(As),e(B),e(Es),e(C),e(Ns),e(Z),e(Vs),e(Xs),e(W),e(xs),e($s),e(Qs),e(us),e(Ss),e(Fs),e(k),e(Ys),e(A),e(Hs),e(E),e(qs),e(Ls),e(V),e(zs),e(X),e(Ps),e(x),e(Os),e($),e(Ds),e(Q),e(Ks),e(ds),e(sl),e(ll),e(F),e(el),e(tl),e(H),e(al),e(q),e(nl),e(pl),e(z),e(ol),e(P),e(il),e(O),e(Ml),e(cl),e(K),e(yl),e(ml),e(ws),e(rl),e(hl),e(es),e(Jl),e(jl),e(as),e(Tl),e(Ul),e(ps),e(ul),e(os),e(dl),e(wl),e(bl),e(cs),e(gl),e(ys),e(Il),e(fl),e(rs),e(Bl),e(Cl),e(Zl),e(js),e(Gl),e(Wl),e(_l),e(gs)),e(T),h(U,s),h(u,s),h(d,s),h(G,s),h(_,s),h(v,s),h(R,s),h(N,s),h(S,s),h(Y,s),h(L,s),h(D,s),h(ss,s),h(ls,s),h(ts,s),h(ns,s),h(is,s),h(Ms,s),h(ms,s),h(hs,s),h(Js,s),h(Ts,s),h(Us,s)}}}const ge='{"title":"使用 TGI 的消息 API 从 OpenAI 迁移到 Open LLMs","local":"使用-tgi-的消息-api-从-openai-迁移到-open-llms","sections":[{"title":"初始化设置","local":"初始化设置","sections":[],"depth":2},{"title":"1. 创建一个推理端点","local":"1-创建一个推理端点","sections":[],"depth":2},{"title":"2. 使用 OpenAI 客户端库查询推理端点","local":"2-使用-openai-客户端库查询推理端点","sections":[{"title":"使用 Python 客户端","local":"使用-python-客户端","sections":[],"depth":3},{"title":"使用 JavaScript 客户端","local":"使用-javascript-客户端","sections":[],"depth":3}],"depth":2},{"title":"3. 与 LangChain 和 LlamaIndex 集成","local":"3-与-langchain-和-llamaindex-集成","sections":[{"title":"如何与 LangChain 一起使用","local":"如何与-langchain-一起使用","sections":[],"depth":3},{"title":"如何与 LlamaIndex 一起使用","local":"如何与-llamaindex-一起使用","sections":[],"depth":3}],"depth":2},{"title":"总结","local":"总结","sections":[],"depth":2}],"depth":1}';function Ie(Rl){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Je{constructor(T){super(),je(this,T,Ie,be,me,{})}}export{We as component};
