# 开源 AI 指南 (Cookbook)

开源 AI 指南 (Cookbook) 是一系列 Notebook 的合集，里面展示了如何利用开源工具和模型来开发 AI 应用和解决各种机器学习问题的实际技巧和方法。

## 最新 Notebook

查看最近添加的 Notebook：

- [使用 LLM 作为评判者🧑‍⚖️进行自动化和多方面的评估](llm_judge)
- [创建一个合法偏好数据集](pipeline_notus_instructions_preferences_legal)
- [使用 SetFit 进行零样本文本分类的数据标注建议](labelling_feedback_setfit)
- [通过引入语义缓存到 FAISS 中以增强 RAG 系统的性能](semantic_cache_chroma_vector_database)
- [用 LlamaIndex 构建一个 RAG 电子书库智能助手](rag_llamaindex_librarian)
- [使用 Stable Diffusion 进行图像插值](stable_diffusion_interpolation)
- [用 Gemma, MongoDB 和开源模型构建 RAG 系统](rag_with_hugging_face_gemma_mongodb)
- [使用 PEFT 进行提示微调](prompt_tuning_peft)
- [使用 TGI 的消息 API 从 OpenAI 迁移到 Open LLMs](tgi_messages_api_demo)
- [通过推理端点使用 TEI 自动嵌入](automatic_embedding_tei_inference_endpoints)
- [用 Hugging Face Zephyr 和 LangChain 针对 Github issues 构建简单的 RAG](rag_zephyr_langchain)
- [用 🤗 transformers, 🤗 datasets 和 FAISS 嵌入多模态数据进行相似度搜索](faiss_with_hf_datasets_and_clip)
- [在单个 GPU 上针对自定义代码微调代码 LLM](fine_tuning_code_llm_on_single_gpu)
- [使用合成数据和 LLM 作为裁判评估 RAG](rag_evaluation)
- [使用 LangChain 在 HuggingFace 文档上构建高级 RAG](advanced_rag)
- [使用 Cleanlab 检测文本数据集中的问题](issues_in_text_dataset)

你还可以在指南 (Cookbook) 的[Github 仓库](https://github.com/huggingface/cookbook)中查看 Notebook。

## 贡献

开源 AI 指南 (Cookbook) 是社区和大家共同努力的成果，我们非常欢迎每个人都来参与贡献！


查看指南 (Cookbook) 的[贡献指引](https://github.com/huggingface/cookbook/blob/main/README.md)了解如何添加你的“食谱(教程)”。


<EditOnGithub source="https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/index.md" />