import{s as Sl,n as _l,o as xl}from"../chunks/scheduler.3d32dc09.js";import{S as Rl,i as El,e as M,s as n,c as i,h as Hl,a as o,d as t,b as a,f as Ql,g as p,j as y,k as jl,l as Yl,m as e,n as c,t as w,o as m,p as U}from"../chunks/index.f9718211.js";import{C as Fl,H as Al,E as zl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as u}from"../chunks/CodeBlock.a5391745.js";import{D as $l}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function ql(Tl){let r,A,Y,z,b,$,d,q,j,L,T,hl="In this notebook, we’ll create an <strong>agent-powered web browser automation system</strong>! This system can navigate websites, interact with elements, and extract information automatically.",K,h,Il="The agent will be able to:",D,J,Cl='<li class="task-list-item"><input type="checkbox" checked="" disabled=""/> Navigate to web pages</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> Click on elements</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> Search within pages</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> Handle popups and modals</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> Extract information</li>',P,I,Zl="Let’s set up this system step by step!",O,C,Bl="First, run these lines to install the required dependencies:",ll,Z,sl,B,Wl="Let’s import our required libraries and set up environment variables:",tl,W,el,G,Gl="Now let’s create our core browser interaction tools that will allow our agent to navigate and interact with web pages:",nl,f,al,v,fl="Let’s set up our browser with Chrome and configure screenshot capabilities:",Ml,g,ol,V,vl="Now let’s create our web automation agent:",yl,k,il,X,gl="The agent needs instructions on how to use Helium for web automation. Here are the instructions we’ll provide:",pl,N,cl,Q,Vl="Now we can run our agent with a task! Let’s try finding information on Wikipedia:",wl,S,ml,_,kl="You can run different tasks by modifying the request. For example, here’s for me to know if I should work harder:",Ul,x,rl,R,Xl="The system is particularly effective for tasks like:",Jl,E,Nl="<li>Data extraction from websites</li> <li>Web research automation</li> <li>UI testing and verification</li> <li>Content monitoring</li>",ul,H,bl,F,dl;return b=new Fl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new $l({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/web_browser.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/web_browser.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/web_browser.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/web_browser.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/web_browser.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/web_browser.ipynb"}]}}),j=new Al({props:{title:"Web Browser Automation with Agents 🤖🌐",local:"web-browser-automation-with-agents-",headingTag:"h1"}}),Z=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBzZWxlbml1bSUyMGhlbGl1bSUyMHBpbGxvdyUyMC1x",highlighted:"pip install smolagents selenium helium pillow -q",wrap:!1}}),W=new u({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFpbXBvcnQlMjBoZWxpdW0lMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc2VsZW5pdW0lMjBpbXBvcnQlMjB3ZWJkcml2ZXIlMEFmcm9tJTIwc2VsZW5pdW0ud2ViZHJpdmVyLmNvbW1vbi5ieSUyMGltcG9ydCUyMEJ5JTBBZnJvbSUyMHNlbGVuaXVtLndlYmRyaXZlci5jb21tb24ua2V5cyUyMGltcG9ydCUyMEtleXMlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMHRvb2wlMEFmcm9tJTIwc21vbGFnZW50cy5hZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBJTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> selenium <span class="hljs-keyword">import</span> webdriver
<span class="hljs-keyword">from</span> selenium.webdriver.common.by <span class="hljs-keyword">import</span> By
<span class="hljs-keyword">from</span> selenium.webdriver.common.keys <span class="hljs-keyword">import</span> Keys

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool
<span class="hljs-keyword">from</span> smolagents.agents <span class="hljs-keyword">import</span> ActionStep

<span class="hljs-comment"># Load environment variables</span>
load_dotenv()`,wrap:!1}}),f=new u({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Searches for text on the current page via Ctrl + F and jumps to the nth occurrence.
    Args:
        text: The text to search for
        nth_result: Which occurrence to jump to (default: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Match n°<span class="hljs-subst">{nth_result}</span> not found (only <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches found)&quot;</span>)
    result = <span class="hljs-string">f&quot;Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches for &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focused on element <span class="hljs-subst">{nth_result}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Goes back to previous page.&quot;&quot;&quot;</span>
    driver.back()

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Closes any visible modal or pop-up on the page. Use this to dismiss pop-up windows!
    This does not work on cookie consent banners.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),g=new u({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure Chrome options</span>
chrome_options = webdriver.ChromeOptions()
chrome_options.add_argument(<span class="hljs-string">&quot;--force-device-scale-factor=1&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--window-size=1000,1350&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--disable-pdf-viewer&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--window-position=0,0&quot;</span>)

<span class="hljs-comment"># Initialize the browser</span>
driver = helium.start_chrome(headless=<span class="hljs-literal">False</span>, options=chrome_options)

<span class="hljs-comment"># Set up screenshot callback</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    current_step = memory_step.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots for lean processing</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                previous_memory_step.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Captured a browser screenshot: <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        memory_step.observations_images = [image.copy()]  <span class="hljs-comment"># Create a copy to ensure it persists</span>

    <span class="hljs-comment"># Update observations with current URL</span>
    url_info = <span class="hljs-string">f&quot;Current url: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    memory_step.observations = (
        url_info <span class="hljs-keyword">if</span> memory_step.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> memory_step.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    )`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyUXdlbiUyRlF3ZW4yLVZMLTcyQi1JbnN0cnVjdCUyMiUyMCUyMCUyMyUyMFlvdSUyMGNhbiUyMGNoYW5nZSUyMHRoaXMlMjB0byUyMHlvdXIlMjBwcmVmZXJyZWQlMjBWTE0lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBhZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZ29fYmFjayUyQyUyMGNsb3NlX3BvcHVwcyUyQyUyMHNlYXJjaF9pdGVtX2N0cmxfZiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMmhlbGl1bSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBfY2FsbGJhY2tzJTNEJTVCc2F2ZV9zY3JlZW5zaG90JTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTBBKSUwQSUwQSUyMyUyMEltcG9ydCUyMGhlbGl1bSUyMGZvciUyMHRoZSUyMGFnZW50JTBBYWdlbnQucHl0aG9uX2V4ZWN1dG9yKCUyMmZyb20lMjBoZWxpdW0lMjBpbXBvcnQlMjAqJTIyJTJDJTIwYWdlbnQuc3RhdGUp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

<span class="hljs-comment"># Initialize the model</span>
model_id = <span class="hljs-string">&quot;Qwen/Qwen2-VL-72B-Instruct&quot;</span>  <span class="hljs-comment"># You can change this to your preferred VLM model</span>
model = InferenceClientModel(model_id=model_id)

<span class="hljs-comment"># Create the agent</span>
agent = CodeAgent(
    tools=[go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)

<span class="hljs-comment"># Import helium for the agent</span>
agent.python_executor(<span class="hljs-string">&quot;from helium import *&quot;</span>, agent.state)`,wrap:!1}}),N=new u({props:{code:"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",highlighted:`helium_instructions = <span class="hljs-string">&quot;&quot;&quot;
You can use helium to access websites. Don&#x27;t bother about the helium driver, it&#x27;s already managed.
We&#x27;ve already ran &quot;from helium import *&quot;
Then you can go to pages!
Code:
\`\`\`py
go_to(&#x27;github.com/trending&#x27;)
\`\`\`&lt;end_code&gt;

You can directly click clickable elements by inputting the text that appears on them.
Code:
\`\`\`py
click(&quot;Top products&quot;)
\`\`\`&lt;end_code&gt;

If it&#x27;s a link:
Code:
\`\`\`py
click(Link(&quot;Top products&quot;))
\`\`\`&lt;end_code&gt;

If you try to interact with an element and it&#x27;s not found, you&#x27;ll get a LookupError.
In general stop your action after each button click to see what happens on your screenshot.
Never try to login in a page.

To scroll up or down, use scroll_down or scroll_up with as an argument the number of pixels to scroll from.
Code:
\`\`\`py
scroll_down(num_pixels=1200) # This will scroll one viewport down
\`\`\`&lt;end_code&gt;

When you have pop-ups with a cross icon to close, don&#x27;t try to click the close icon by finding its element or targeting an &#x27;X&#x27; element (this most often fails).
Just use your built-in tool \`close_popups\` to close them:
Code:
\`\`\`py
close_popups()
\`\`\`&lt;end_code&gt;

You can use .exists() to check for the existence of an element. For example:
Code:
\`\`\`py
if Text(&#x27;Accept cookies?&#x27;).exists():
    click(&#x27;I accept&#x27;)
\`\`\`&lt;end_code&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),S=new u({props:{code:"c2VhcmNoX3JlcXVlc3QlMjAlM0QlMjAlMjIlMjIlMjIlMEFQbGVhc2UlMjBuYXZpZ2F0ZSUyMHRvJTIwaHR0cHMlM0ElMkYlMkZlbi53aWtpcGVkaWEub3JnJTJGd2lraSUyRkNoaWNhZ28lMjBhbmQlMjBnaXZlJTIwbWUlMjBhJTIwc2VudGVuY2UlMjBjb250YWluaW5nJTIwdGhlJTIwd29yZCUyMCUyMjE5OTIlMjIlMjB0aGF0JTIwbWVudGlvbnMlMjBhJTIwY29uc3RydWN0aW9uJTIwYWNjaWRlbnQuJTBBJTIyJTIyJTIyJTBBJTBBYWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHNlYXJjaF9yZXF1ZXN0JTIwJTJCJTIwaGVsaXVtX2luc3RydWN0aW9ucyklMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`search_request = <span class="hljs-string">&quot;&quot;&quot;
Please navigate to https://en.wikipedia.org/wiki/Chicago and give me a sentence containing the word &quot;1992&quot; that mentions a construction accident.
&quot;&quot;&quot;</span>

agent_output = agent.run(search_request + helium_instructions)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),x=new u({props:{code:"Z2l0aHViX3JlcXVlc3QlMjAlM0QlMjAlMjIlMjIlMjIlMEFJJ20lMjB0cnlpbmclMjB0byUyMGZpbmQlMjBob3clMjBoYXJkJTIwSSUyMGhhdmUlMjB0byUyMHdvcmslMjB0byUyMGdldCUyMGElMjByZXBvJTIwaW4lMjBnaXRodWIuY29tJTJGdHJlbmRpbmcuJTBBQ2FuJTIweW91JTIwbmF2aWdhdGUlMjB0byUyMHRoZSUyMHByb2ZpbGUlMjBmb3IlMjB0aGUlMjB0b3AlMjBhdXRob3IlMjBvZiUyMHRoZSUyMHRvcCUyMHRyZW5kaW5nJTIwcmVwbyUyQyUyMGFuZCUyMGdpdmUlMjBtZSUyMHRoZWlyJTIwdG90YWwlMjBudW1iZXIlMjBvZiUyMGNvbW1pdHMlMjBvdmVyJTIwdGhlJTIwbGFzdCUyMHllYXIlM0YlMEElMjIlMjIlMjIlMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oZ2l0aHViX3JlcXVlc3QlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`github_request = <span class="hljs-string">&quot;&quot;&quot;
I&#x27;m trying to find how hard I have to work to get a repo in github.com/trending.
Can you navigate to the profile for the top author of the top trending repo, and give me their total number of commits over the last year?
&quot;&quot;&quot;</span>

agent_output = agent.run(github_request + helium_instructions)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),H=new zl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/web_browser.md"}}),{c(){r=M("meta"),A=n(),Y=M("p"),z=n(),i(b.$$.fragment),$=n(),i(d.$$.fragment),q=n(),i(j.$$.fragment),L=n(),T=M("p"),T.innerHTML=hl,K=n(),h=M("p"),h.textContent=Il,D=n(),J=M("ul"),J.innerHTML=Cl,P=n(),I=M("p"),I.textContent=Zl,O=n(),C=M("p"),C.textContent=Bl,ll=n(),i(Z.$$.fragment),sl=n(),B=M("p"),B.textContent=Wl,tl=n(),i(W.$$.fragment),el=n(),G=M("p"),G.textContent=Gl,nl=n(),i(f.$$.fragment),al=n(),v=M("p"),v.textContent=fl,Ml=n(),i(g.$$.fragment),ol=n(),V=M("p"),V.textContent=vl,yl=n(),i(k.$$.fragment),il=n(),X=M("p"),X.textContent=gl,pl=n(),i(N.$$.fragment),cl=n(),Q=M("p"),Q.textContent=Vl,wl=n(),i(S.$$.fragment),ml=n(),_=M("p"),_.textContent=kl,Ul=n(),i(x.$$.fragment),rl=n(),R=M("p"),R.textContent=Xl,Jl=n(),E=M("ul"),E.innerHTML=Nl,ul=n(),i(H.$$.fragment),bl=n(),F=M("p"),this.h()},l(l){const s=Hl("svelte-u9bgzb",document.head);r=o(s,"META",{name:!0,content:!0}),s.forEach(t),A=a(l),Y=o(l,"P",{}),Ql(Y).forEach(t),z=a(l),p(b.$$.fragment,l),$=a(l),p(d.$$.fragment,l),q=a(l),p(j.$$.fragment,l),L=a(l),T=o(l,"P",{"data-svelte-h":!0}),y(T)!=="svelte-tdeogy"&&(T.innerHTML=hl),K=a(l),h=o(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1mck464"&&(h.textContent=Il),D=a(l),J=o(l,"UL",{class:!0,"data-svelte-h":!0}),y(J)!=="svelte-pjjt70"&&(J.innerHTML=Cl),P=a(l),I=o(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-fgur5z"&&(I.textContent=Zl),O=a(l),C=o(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-rzmehw"&&(C.textContent=Bl),ll=a(l),p(Z.$$.fragment,l),sl=a(l),B=o(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-aatcxm"&&(B.textContent=Wl),tl=a(l),p(W.$$.fragment,l),el=a(l),G=o(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-ew2vad"&&(G.textContent=Gl),nl=a(l),p(f.$$.fragment,l),al=a(l),v=o(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-18q09dl"&&(v.textContent=fl),Ml=a(l),p(g.$$.fragment,l),ol=a(l),V=o(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-l0xgup"&&(V.textContent=vl),yl=a(l),p(k.$$.fragment,l),il=a(l),X=o(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1dguwwp"&&(X.textContent=gl),pl=a(l),p(N.$$.fragment,l),cl=a(l),Q=o(l,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-v05wqk"&&(Q.textContent=Vl),wl=a(l),p(S.$$.fragment,l),ml=a(l),_=o(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-9pd45g"&&(_.textContent=kl),Ul=a(l),p(x.$$.fragment,l),rl=a(l),R=o(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-10i87l9"&&(R.textContent=Xl),Jl=a(l),E=o(l,"UL",{"data-svelte-h":!0}),y(E)!=="svelte-4nt2no"&&(E.innerHTML=Nl),ul=a(l),p(H.$$.fragment,l),bl=a(l),F=o(l,"P",{}),Ql(F).forEach(t),this.h()},h(){jl(r,"name","hf:doc:metadata"),jl(r,"content",Ll),jl(J,"class","contains-task-list")},m(l,s){Yl(document.head,r),e(l,A,s),e(l,Y,s),e(l,z,s),c(b,l,s),e(l,$,s),c(d,l,s),e(l,q,s),c(j,l,s),e(l,L,s),e(l,T,s),e(l,K,s),e(l,h,s),e(l,D,s),e(l,J,s),e(l,P,s),e(l,I,s),e(l,O,s),e(l,C,s),e(l,ll,s),c(Z,l,s),e(l,sl,s),e(l,B,s),e(l,tl,s),c(W,l,s),e(l,el,s),e(l,G,s),e(l,nl,s),c(f,l,s),e(l,al,s),e(l,v,s),e(l,Ml,s),c(g,l,s),e(l,ol,s),e(l,V,s),e(l,yl,s),c(k,l,s),e(l,il,s),e(l,X,s),e(l,pl,s),c(N,l,s),e(l,cl,s),e(l,Q,s),e(l,wl,s),c(S,l,s),e(l,ml,s),e(l,_,s),e(l,Ul,s),c(x,l,s),e(l,rl,s),e(l,R,s),e(l,Jl,s),e(l,E,s),e(l,ul,s),c(H,l,s),e(l,bl,s),e(l,F,s),dl=!0},p:_l,i(l){dl||(w(b.$$.fragment,l),w(d.$$.fragment,l),w(j.$$.fragment,l),w(Z.$$.fragment,l),w(W.$$.fragment,l),w(f.$$.fragment,l),w(g.$$.fragment,l),w(k.$$.fragment,l),w(N.$$.fragment,l),w(S.$$.fragment,l),w(x.$$.fragment,l),w(H.$$.fragment,l),dl=!0)},o(l){m(b.$$.fragment,l),m(d.$$.fragment,l),m(j.$$.fragment,l),m(Z.$$.fragment,l),m(W.$$.fragment,l),m(f.$$.fragment,l),m(g.$$.fragment,l),m(k.$$.fragment,l),m(N.$$.fragment,l),m(S.$$.fragment,l),m(x.$$.fragment,l),m(H.$$.fragment,l),dl=!1},d(l){l&&(t(A),t(Y),t(z),t($),t(q),t(L),t(T),t(K),t(h),t(D),t(J),t(P),t(I),t(O),t(C),t(ll),t(sl),t(B),t(tl),t(el),t(G),t(nl),t(al),t(v),t(Ml),t(ol),t(V),t(yl),t(il),t(X),t(pl),t(cl),t(Q),t(wl),t(ml),t(_),t(Ul),t(rl),t(R),t(Jl),t(E),t(ul),t(bl),t(F)),t(r),U(b,l),U(d,l),U(j,l),U(Z,l),U(W,l),U(f,l),U(g,l),U(k,l),U(N,l),U(S,l),U(x,l),U(H,l)}}}const Ll='{"title":"Web Browser Automation with Agents 🤖🌐","local":"web-browser-automation-with-agents-","sections":[],"depth":1}';function Kl(Tl){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Rl{constructor(r){super(),El(this,r,Kl,ql,Sl,{})}}export{ts as component};
