import{s as Ys,a as qs,n as zs,o as Ls}from"../chunks/scheduler.3d32dc09.js";import{S as Ps,i as Ds,e as a,s as o,c as M,h as Ks,a as i,d as l,b as n,f as Fs,g as p,j as r,k as U,l as Os,m as s,n as u,t as c,o as d,p as y}from"../chunks/index.f9718211.js";import{C as eo,H as h,E as to}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as m}from"../chunks/CodeBlock.a5391745.js";import{D as lo}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function so(Xl){let b,st,tt,ot,f,nt,g,at,C,it,v,Sl="Here, we’re going to see advanced tool usage.",rt,w,Al='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',Mt,I,pt,Z,ql="A tool is mostly a function that an LLM can use in an agentic system.",ut,B,Fl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",ct,W,Yl="So it cannot be only a function. It should be a class.",dt,G,zl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",yt,k,Ll="Here’s how it looks:",mt,Q,ht,H,Pl='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',bt,R,Dl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',wt,_,Kl="And that’s all it needs to be used in an agent!",Tt,$,Ol='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Jt,V,es='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',jt,x,Ut,N,ts='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',ft,E,gt,X,ls="For the push to Hub to work, your tool will need to respect some rules:",Ct,S,ss='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',vt,A,os='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',It,q,ns='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',Zt,F,as=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,Bt,Y,Wt,z,Gt,L,is="Our <code>MCPClient</code> allows you to load tools from an MCP server, and gives you full control over the connection and tool management:",kt,P,rs="For stdio-based MCP servers:",Qt,D,Ht,K,Ms="For Streamable HTTP-based MCP servers:",Rt,O,_t,ee,ps="You can also manually manage the connection lifecycle with the try…finally pattern:",$t,te,Vt,le,us="You can also connect to multiple MCP servers at once by passing a list of server parameters:",xt,se,Nt,T,cs=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,Et,oe,Xt,ne,ds='The latest <a href="https://modelcontextprotocol.io/specification/2025-06-18/server/tools#structured-content" rel="nofollow">MCP specifications (2025-06-18+)</a> include support for <code>outputSchema</code>, which enables tools to return structured data with defined schemas. <code>smolagents</code> takes advantage of these structured output capabilities, allowing agents to work with tools that return complex data structures, JSON objects, and other structured formats. With this feature, the agent’s LLMs can “see” the structure of the tool output before calling a tool, enabling more intelligent and context-aware interactions.',St,ae,ys="To enable structured output support, pass <code>structured_output=True</code> when initializing the <code>MCPClient</code>:",At,ie,qt,re,ms="When <code>structured_output=True</code>, the following features are enabled:",Ft,Me,hs="<li><strong>Output Schema Support</strong>: Tools can define JSON schemas for their outputs</li> <li><strong>Structured Content Handling</strong>: Support for <code>structuredContent</code> in MCP responses</li> <li><strong>JSON Parsing</strong>: Automatic parsing of structured data from tool responses</li>",Yt,pe,bs="Here’s an example using a weather MCP server with structured output:",zt,ue,Lt,ce,ws="Agent using output schema and structured output:",Pt,de,Dt,ye,Ts="When structured output is enabled, the <code>CodeAgent</code> system prompt is enhanced to include JSON schema information for tools, helping the agent understand the expected structure of tool outputs and access the data appropriately.",Kt,me,Js="<strong>Backwards Compatibility</strong>: The <code>structured_output</code> parameter currently defaults to <code>False</code> to maintain backwards compatibility. Existing code will continue to work without changes, receiving simple text outputs as before.",Ot,he,js="<strong>Future Change</strong>: In a future release, the default value of <code>structured_output</code> will change from <code>False</code> to <code>True</code>. It is recommended to explicitly set <code>structured_output=True</code> to opt into the enhanced functionality, which provides better tool output handling and improved agent performance. Use <code>structured_output=False</code> only if you specifically need to maintain the current text-only behavior.",el,be,tl,we,Us='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',ll,Te,fs='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',sl,Je,gs='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',ol,je,nl,Ue,Cs="And voilà, here’s your image! 🏖️",al,Oe,vs,il,fe,Is="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",rl,ge,Ml,Ce,pl,et,Zs,ul,ve,Bs="How cool is this? 🤩",cl,Ie,dl,Ze,Ws=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,yl,Be,Gs=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ml,We,hl,Ge,bl,ke,ks="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",wl,Qe,Qs="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",Tl,He,Jl,Re,Hs="Now we can leverage the new tool:",jl,_e,Ul,J,Rs="<p>Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.</p>",fl,$e,gl,Ve,_s='You can leverage tool collections by using <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Cl,xe,vl,Ne,$s='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Il,Ee,Vs='The MCP servers tools can be loaded with <a href="/docs/smolagents/main/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Zl,j,xs=`<p><strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:</p> <ul><li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li></ul>`,Bl,Xe,Ns="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",Wl,Se,Gl,Ae,Es="To enable structured output support with ToolCollection, add the <code>structured_output=True</code> parameter:",kl,qe,Ql,Fe,Xs="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",Hl,Ye,Rl,ze,_l,Le,Ss=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,$l,Pe,Vl,De,As="To speed up the start, tools are loaded only if called by the agent.",xl,Ke,Nl,lt,El;return f=new eo({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new lo({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),C=new h({props:{title:"Tools",local:"tools",headingTag:"h1"}}),I=new h({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),Q=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),x=new h({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),E=new m({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),Y=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),z=new h({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),D=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),O=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),te=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),se=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),oe=new h({props:{title:"Structured Output and Output Schema Support",local:"structured-output-and-output-schema-support",headingTag:"h4"}}),ie=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBFbmFibGUlMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTIwc3VwcG9ydCUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBQYXJpcyUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Enable structured output support</span>
<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Get weather information for Paris&quot;</span>)`,wrap:!1}}),ue=new m({props:{code:"JTIzJTIwZGVtbyUyRndlYXRoZXIucHklMjAtJTIwRXhhbXBsZSUyME1DUCUyMHNlcnZlciUyMHdpdGglMjBzdHJ1Y3R1cmVkJTIwb3V0cHV0JTBBZnJvbSUyMHB5ZGFudGljJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTJDJTIwRmllbGQlMEFmcm9tJTIwbWNwLnNlcnZlci5mYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQSUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyV2VhdGhlciUyMFNlcnZpY2UlMjIpJTBBJTBBY2xhc3MlMjBXZWF0aGVySW5mbyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMjAlM0QlMjBGaWVsZChkZXNjcmlwdGlvbiUzRCUyMlRoZSUyMGxvY2F0aW9uJTIwbmFtZSUyMiklMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMGZsb2F0JTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJUZW1wZXJhdHVyZSUyMGluJTIwQ2Vsc2l1cyUyMiklMEElMjAlMjAlMjAlMjBjb25kaXRpb25zJTNBJTIwc3RyJTIwJTNEJTIwRmllbGQoZGVzY3JpcHRpb24lM0QlMjJXZWF0aGVyJTIwY29uZGl0aW9ucyUyMiklMEElMjAlMjAlMjAlMjBodW1pZGl0eSUzQSUyMGludCUyMCUzRCUyMEZpZWxkKGRlc2NyaXB0aW9uJTNEJTIySHVtaWRpdHklMjBwZXJjZW50YWdlJTIyJTJDJTIwZ2UlM0QwJTJDJTIwbGUlM0QxMDApJTBBJTBBJTQwbWNwLnRvb2woJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmdldF93ZWF0aGVyX2luZm8lMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdldCUyMHdlYXRoZXIlMjBpbmZvcm1hdGlvbiUyMGZvciUyMGElMjBsb2NhdGlvbiUyMGFzJTIwc3RydWN0dXJlZCUyMGRhdGEuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlJTIwaXMlMjBlbmFibGVkJTIwYnklMjBkZWZhdWx0JTIwaW4lMjBGYXN0TUNQJTBBKSUwQWRlZiUyMGdldF93ZWF0aGVyX2luZm8oY2l0eSUzQSUyMHN0ciklMjAtJTNFJTIwV2VhdGhlckluZm8lM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHZXQlMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBmb3IlMjBhJTIwY2l0eS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBXZWF0aGVySW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzRGNpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDIyLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25zJTNEJTIycGFydGx5JTIwY2xvdWR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHVtaWRpdHklM0Q2NSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-comment"># demo/weather.py - Example MCP server with structured output</span>
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, Field
<span class="hljs-keyword">from</span> mcp.server.fastmcp <span class="hljs-keyword">import</span> FastMCP

mcp = FastMCP(<span class="hljs-string">&quot;Weather Service&quot;</span>)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">WeatherInfo</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;The location name&quot;</span>)
    temperature: <span class="hljs-built_in">float</span> = Field(description=<span class="hljs-string">&quot;Temperature in Celsius&quot;</span>)
    conditions: <span class="hljs-built_in">str</span> = Field(description=<span class="hljs-string">&quot;Weather conditions&quot;</span>)
    humidity: <span class="hljs-built_in">int</span> = Field(description=<span class="hljs-string">&quot;Humidity percentage&quot;</span>, ge=<span class="hljs-number">0</span>, le=<span class="hljs-number">100</span>)

<span class="hljs-meta">@mcp.tool(<span class="hljs-params">
    name=<span class="hljs-string">&quot;get_weather_info&quot;</span>,
    description=<span class="hljs-string">&quot;Get weather information for a location as structured data.&quot;</span>,
    <span class="hljs-comment"># structured_output=True is enabled by default in FastMCP</span>
</span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_info</span>(<span class="hljs-params">city: <span class="hljs-built_in">str</span></span>) -&gt; WeatherInfo:
    <span class="hljs-string">&quot;&quot;&quot;Get weather information for a city.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> WeatherInfo(
        location=city,
        temperature=<span class="hljs-number">22.5</span>,
        conditions=<span class="hljs-string">&quot;partly cloudy&quot;</span>,
        humidity=<span class="hljs-number">65</span>
    )`,wrap:!1}}),de=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEElMjMlMjBVc2luZyUyMHRoZSUyMHdlYXRoZXIlMjBzZXJ2ZXIlMjB3aXRoJTIwc3RydWN0dXJlZCUyMG91dHB1dCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMmRlbW8lMkZ3ZWF0aGVyLnB5JTIyJTVEJTBBKSUwQSUwQXdpdGglMjBNQ1BDbGllbnQoc2VydmVyX3BhcmFtZXRlcnMlMkMlMjBzdHJ1Y3R1cmVkX291dHB1dCUzRFRydWUpJTIwYXMlMjB0b29scyUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjB0ZW1wZXJhdHVyZSUyMGluJTIwVG9reW8lMjBpbiUyMEZhaHJlbmhlaXQlM0YlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-comment"># Using the weather server with structured output</span>
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;python&quot;</span>,
    args=[<span class="hljs-string">&quot;demo/weather.py&quot;</span>]
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model)
    result = agent.run(<span class="hljs-string">&quot;What is the temperature in Tokyo in Fahrenheit?&quot;</span>)
    <span class="hljs-built_in">print</span>(result)`,wrap:!1}}),be=new h({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),je=new m({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ge=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),Ce=new m({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),Ie=new h({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),We=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Ge=new h({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),He=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),_e=new m({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),$e=new h({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),xe=new h({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Se=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),qe=new m({props:{code:"d2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwc3RydWN0dXJlZF9vdXRwdXQlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>, structured_output=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ye=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ze=new h({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Pe=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),Ke=new to({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){b=a("meta"),st=o(),tt=a("p"),ot=o(),M(f.$$.fragment),nt=o(),M(g.$$.fragment),at=o(),M(C.$$.fragment),it=o(),v=a("p"),v.textContent=Sl,rt=o(),w=a("blockquote"),w.innerHTML=Al,Mt=o(),M(I.$$.fragment),pt=o(),Z=a("p"),Z.textContent=ql,ut=o(),B=a("p"),B.textContent=Fl,ct=o(),W=a("p"),W.textContent=Yl,dt=o(),G=a("p"),G.textContent=zl,yt=o(),k=a("p"),k.textContent=Ll,mt=o(),M(Q.$$.fragment),ht=o(),H=a("p"),H.innerHTML=Pl,bt=o(),R=a("ul"),R.innerHTML=Dl,wt=o(),_=a("p"),_.textContent=Kl,Tt=o(),$=a("p"),$.innerHTML=Ol,Jt=o(),V=a("p"),V.innerHTML=es,jt=o(),M(x.$$.fragment),Ut=o(),N=a("p"),N.innerHTML=ts,ft=o(),M(E.$$.fragment),gt=o(),X=a("p"),X.textContent=ls,Ct=o(),S=a("ul"),S.innerHTML=ss,vt=o(),A=a("p"),A.innerHTML=os,It=o(),q=a("p"),q.innerHTML=ns,Zt=o(),F=a("p"),F.innerHTML=as,Bt=o(),M(Y.$$.fragment),Wt=o(),M(z.$$.fragment),Gt=o(),L=a("p"),L.innerHTML=is,kt=o(),P=a("p"),P.textContent=rs,Qt=o(),M(D.$$.fragment),Ht=o(),K=a("p"),K.textContent=Ms,Rt=o(),M(O.$$.fragment),_t=o(),ee=a("p"),ee.textContent=ps,$t=o(),M(te.$$.fragment),Vt=o(),le=a("p"),le.textContent=us,xt=o(),M(se.$$.fragment),Nt=o(),T=a("blockquote"),T.innerHTML=cs,Et=o(),M(oe.$$.fragment),Xt=o(),ne=a("p"),ne.innerHTML=ds,St=o(),ae=a("p"),ae.innerHTML=ys,At=o(),M(ie.$$.fragment),qt=o(),re=a("p"),re.innerHTML=ms,Ft=o(),Me=a("ul"),Me.innerHTML=hs,Yt=o(),pe=a("p"),pe.textContent=bs,zt=o(),M(ue.$$.fragment),Lt=o(),ce=a("p"),ce.textContent=ws,Pt=o(),M(de.$$.fragment),Dt=o(),ye=a("p"),ye.innerHTML=Ts,Kt=o(),me=a("p"),me.innerHTML=Js,Ot=o(),he=a("p"),he.innerHTML=js,el=o(),M(be.$$.fragment),tl=o(),we=a("p"),we.innerHTML=Us,ll=o(),Te=a("p"),Te.innerHTML=fs,sl=o(),Je=a("p"),Je.innerHTML=gs,ol=o(),M(je.$$.fragment),nl=o(),Ue=a("p"),Ue.textContent=Cs,al=o(),Oe=a("img"),il=o(),fe=a("p"),fe.innerHTML=Is,rl=o(),M(ge.$$.fragment),Ml=o(),M(Ce.$$.fragment),pl=o(),et=a("img"),ul=o(),ve=a("p"),ve.textContent=Bs,cl=o(),M(Ie.$$.fragment),dl=o(),Ze=a("p"),Ze.innerHTML=Ws,yl=o(),Be=a("p"),Be.innerHTML=Gs,ml=o(),M(We.$$.fragment),hl=o(),M(Ge.$$.fragment),bl=o(),ke=a("p"),ke.innerHTML=ks,wl=o(),Qe=a("p"),Qe.innerHTML=Qs,Tl=o(),M(He.$$.fragment),Jl=o(),Re=a("p"),Re.textContent=Hs,jl=o(),M(_e.$$.fragment),Ul=o(),J=a("blockquote"),J.innerHTML=Rs,fl=o(),M($e.$$.fragment),gl=o(),Ve=a("p"),Ve.innerHTML=_s,Cl=o(),M(xe.$$.fragment),vl=o(),Ne=a("p"),Ne.innerHTML=$s,Il=o(),Ee=a("p"),Ee.innerHTML=Vs,Zl=o(),j=a("blockquote"),j.innerHTML=xs,Bl=o(),Xe=a("p"),Xe.innerHTML=Ns,Wl=o(),M(Se.$$.fragment),Gl=o(),Ae=a("p"),Ae.innerHTML=Es,kl=o(),M(qe.$$.fragment),Ql=o(),Fe=a("p"),Fe.innerHTML=Xs,Hl=o(),M(Ye.$$.fragment),Rl=o(),M(ze.$$.fragment),_l=o(),Le=a("p"),Le.textContent=Ss,$l=o(),M(Pe.$$.fragment),Vl=o(),De=a("p"),De.textContent=As,xl=o(),M(Ke.$$.fragment),Nl=o(),lt=a("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),st=n(e),tt=i(e,"P",{}),Fs(tt).forEach(l),ot=n(e),p(f.$$.fragment,e),nt=n(e),p(g.$$.fragment,e),at=n(e),p(C.$$.fragment,e),it=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8951oz"&&(v.textContent=Sl),rt=n(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1eo9frz"&&(w.innerHTML=Al),Mt=n(e),p(I.$$.fragment,e),pt=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-50z9h0"&&(Z.textContent=ql),ut=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1llqfcr"&&(B.textContent=Fl),ct=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-eilpgu"&&(W.textContent=Yl),dt=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-suz7fy"&&(G.textContent=zl),yt=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-x18ywb"&&(k.textContent=Ll),mt=n(e),p(Q.$$.fragment,e),ht=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-prn7f3"&&(H.innerHTML=Pl),bt=n(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-xqgwuf"&&(R.innerHTML=Dl),wt=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-220ayw"&&(_.textContent=Kl),Tt=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-13idprj"&&($.innerHTML=Ol),Jt=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1lot62h"&&(V.innerHTML=es),jt=n(e),p(x.$$.fragment,e),Ut=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4kwync"&&(N.innerHTML=ts),ft=n(e),p(E.$$.fragment,e),gt=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hoocvd"&&(X.textContent=ls),Ct=n(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-cqj6gr"&&(S.innerHTML=ss),vt=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-4n5s3c"&&(A.innerHTML=os),It=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1knl8v8"&&(q.innerHTML=ns),Zt=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1skw0cc"&&(F.innerHTML=as),Bt=n(e),p(Y.$$.fragment,e),Wt=n(e),p(z.$$.fragment,e),Gt=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-eofyyc"&&(L.innerHTML=is),kt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1en3ihe"&&(P.textContent=rs),Qt=n(e),p(D.$$.fragment,e),Ht=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ro6hjz"&&(K.textContent=Ms),Rt=n(e),p(O.$$.fragment,e),_t=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1and4a8"&&(ee.textContent=ps),$t=n(e),p(te.$$.fragment,e),Vt=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-7q6kbi"&&(le.textContent=us),xt=n(e),p(se.$$.fragment,e),Nt=n(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-kwg2aw"&&(T.innerHTML=cs),Et=n(e),p(oe.$$.fragment,e),Xt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ku5522"&&(ne.innerHTML=ds),St=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-10wjig9"&&(ae.innerHTML=ys),At=n(e),p(ie.$$.fragment,e),qt=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-rntkgd"&&(re.innerHTML=ms),Ft=n(e),Me=i(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-745dbc"&&(Me.innerHTML=hs),Yt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1e0rvyj"&&(pe.textContent=bs),zt=n(e),p(ue.$$.fragment,e),Lt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-xhsky2"&&(ce.textContent=ws),Pt=n(e),p(de.$$.fragment,e),Dt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1dbhry6"&&(ye.innerHTML=Ts),Kt=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-shyg20"&&(me.innerHTML=Js),Ot=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-g6qlg5"&&(he.innerHTML=js),el=n(e),p(be.$$.fragment,e),tl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1p3gfeb"&&(we.innerHTML=Us),ll=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-17wa58l"&&(Te.innerHTML=fs),sl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1gucs20"&&(Je.innerHTML=gs),ol=n(e),p(je.$$.fragment,e),nl=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-sgspwr"&&(Ue.textContent=Cs),al=n(e),Oe=i(e,"IMG",{src:!0}),il=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1y8rl57"&&(fe.innerHTML=Is),rl=n(e),p(ge.$$.fragment,e),Ml=n(e),p(Ce.$$.fragment,e),pl=n(e),et=i(e,"IMG",{src:!0}),ul=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-i5dtbz"&&(ve.textContent=Bs),cl=n(e),p(Ie.$$.fragment,e),dl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1rq40pf"&&(Ze.innerHTML=Ws),yl=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1g7jkvd"&&(Be.innerHTML=Gs),ml=n(e),p(We.$$.fragment,e),hl=n(e),p(Ge.$$.fragment,e),bl=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-69p3x"&&(ke.innerHTML=ks),wl=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-ocb8u2"&&(Qe.innerHTML=Qs),Tl=n(e),p(He.$$.fragment,e),Jl=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-o3ledg"&&(Re.textContent=Hs),jl=n(e),p(_e.$$.fragment,e),Ul=n(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1xyjnip"&&(J.innerHTML=Rs),fl=n(e),p($e.$$.fragment,e),gl=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-w4ihv0"&&(Ve.innerHTML=_s),Cl=n(e),p(xe.$$.fragment,e),vl=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1q39vf"&&(Ne.innerHTML=$s),Il=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-v7rocy"&&(Ee.innerHTML=Vs),Zl=n(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-kwg2aw"&&(j.innerHTML=xs),Bl=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-s0gh2b"&&(Xe.innerHTML=Ns),Wl=n(e),p(Se.$$.fragment,e),Gl=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-17z5hjh"&&(Ae.innerHTML=Es),kl=n(e),p(qe.$$.fragment,e),Ql=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-j0i0xh"&&(Fe.innerHTML=Xs),Hl=n(e),p(Ye.$$.fragment,e),Rl=n(e),p(ze.$$.fragment,e),_l=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-qubpc6"&&(Le.textContent=Ss),$l=n(e),p(Pe.$$.fragment,e),Vl=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-6r1jgt"&&(De.textContent=As),xl=n(e),p(Ke.$$.fragment,e),Nl=n(e),lt=i(e,"P",{}),Fs(lt).forEach(l),this.h()},h(){U(b,"name","hf:doc:metadata"),U(b,"content",oo),U(w,"class","tip"),U(T,"class","warning"),qs(Oe.src,vs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||U(Oe,"src",vs),qs(et.src,Zs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||U(et,"src",Zs),U(J,"class","tip"),U(j,"class","warning")},m(e,t){Os(document.head,b),s(e,st,t),s(e,tt,t),s(e,ot,t),u(f,e,t),s(e,nt,t),u(g,e,t),s(e,at,t),u(C,e,t),s(e,it,t),s(e,v,t),s(e,rt,t),s(e,w,t),s(e,Mt,t),u(I,e,t),s(e,pt,t),s(e,Z,t),s(e,ut,t),s(e,B,t),s(e,ct,t),s(e,W,t),s(e,dt,t),s(e,G,t),s(e,yt,t),s(e,k,t),s(e,mt,t),u(Q,e,t),s(e,ht,t),s(e,H,t),s(e,bt,t),s(e,R,t),s(e,wt,t),s(e,_,t),s(e,Tt,t),s(e,$,t),s(e,Jt,t),s(e,V,t),s(e,jt,t),u(x,e,t),s(e,Ut,t),s(e,N,t),s(e,ft,t),u(E,e,t),s(e,gt,t),s(e,X,t),s(e,Ct,t),s(e,S,t),s(e,vt,t),s(e,A,t),s(e,It,t),s(e,q,t),s(e,Zt,t),s(e,F,t),s(e,Bt,t),u(Y,e,t),s(e,Wt,t),u(z,e,t),s(e,Gt,t),s(e,L,t),s(e,kt,t),s(e,P,t),s(e,Qt,t),u(D,e,t),s(e,Ht,t),s(e,K,t),s(e,Rt,t),u(O,e,t),s(e,_t,t),s(e,ee,t),s(e,$t,t),u(te,e,t),s(e,Vt,t),s(e,le,t),s(e,xt,t),u(se,e,t),s(e,Nt,t),s(e,T,t),s(e,Et,t),u(oe,e,t),s(e,Xt,t),s(e,ne,t),s(e,St,t),s(e,ae,t),s(e,At,t),u(ie,e,t),s(e,qt,t),s(e,re,t),s(e,Ft,t),s(e,Me,t),s(e,Yt,t),s(e,pe,t),s(e,zt,t),u(ue,e,t),s(e,Lt,t),s(e,ce,t),s(e,Pt,t),u(de,e,t),s(e,Dt,t),s(e,ye,t),s(e,Kt,t),s(e,me,t),s(e,Ot,t),s(e,he,t),s(e,el,t),u(be,e,t),s(e,tl,t),s(e,we,t),s(e,ll,t),s(e,Te,t),s(e,sl,t),s(e,Je,t),s(e,ol,t),u(je,e,t),s(e,nl,t),s(e,Ue,t),s(e,al,t),s(e,Oe,t),s(e,il,t),s(e,fe,t),s(e,rl,t),u(ge,e,t),s(e,Ml,t),u(Ce,e,t),s(e,pl,t),s(e,et,t),s(e,ul,t),s(e,ve,t),s(e,cl,t),u(Ie,e,t),s(e,dl,t),s(e,Ze,t),s(e,yl,t),s(e,Be,t),s(e,ml,t),u(We,e,t),s(e,hl,t),u(Ge,e,t),s(e,bl,t),s(e,ke,t),s(e,wl,t),s(e,Qe,t),s(e,Tl,t),u(He,e,t),s(e,Jl,t),s(e,Re,t),s(e,jl,t),u(_e,e,t),s(e,Ul,t),s(e,J,t),s(e,fl,t),u($e,e,t),s(e,gl,t),s(e,Ve,t),s(e,Cl,t),u(xe,e,t),s(e,vl,t),s(e,Ne,t),s(e,Il,t),s(e,Ee,t),s(e,Zl,t),s(e,j,t),s(e,Bl,t),s(e,Xe,t),s(e,Wl,t),u(Se,e,t),s(e,Gl,t),s(e,Ae,t),s(e,kl,t),u(qe,e,t),s(e,Ql,t),s(e,Fe,t),s(e,Hl,t),u(Ye,e,t),s(e,Rl,t),u(ze,e,t),s(e,_l,t),s(e,Le,t),s(e,$l,t),u(Pe,e,t),s(e,Vl,t),s(e,De,t),s(e,xl,t),u(Ke,e,t),s(e,Nl,t),s(e,lt,t),El=!0},p:zs,i(e){El||(c(f.$$.fragment,e),c(g.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(Q.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(ie.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(be.$$.fragment,e),c(je.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(Ie.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(He.$$.fragment,e),c(_e.$$.fragment,e),c($e.$$.fragment,e),c(xe.$$.fragment,e),c(Se.$$.fragment,e),c(qe.$$.fragment,e),c(Ye.$$.fragment,e),c(ze.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),El=!0)},o(e){d(f.$$.fragment,e),d(g.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(Q.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(ge.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(He.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(xe.$$.fragment,e),d(Se.$$.fragment,e),d(qe.$$.fragment,e),d(Ye.$$.fragment,e),d(ze.$$.fragment,e),d(Pe.$$.fragment,e),d(Ke.$$.fragment,e),El=!1},d(e){e&&(l(st),l(tt),l(ot),l(nt),l(at),l(it),l(v),l(rt),l(w),l(Mt),l(pt),l(Z),l(ut),l(B),l(ct),l(W),l(dt),l(G),l(yt),l(k),l(mt),l(ht),l(H),l(bt),l(R),l(wt),l(_),l(Tt),l($),l(Jt),l(V),l(jt),l(Ut),l(N),l(ft),l(gt),l(X),l(Ct),l(S),l(vt),l(A),l(It),l(q),l(Zt),l(F),l(Bt),l(Wt),l(Gt),l(L),l(kt),l(P),l(Qt),l(Ht),l(K),l(Rt),l(_t),l(ee),l($t),l(Vt),l(le),l(xt),l(Nt),l(T),l(Et),l(Xt),l(ne),l(St),l(ae),l(At),l(qt),l(re),l(Ft),l(Me),l(Yt),l(pe),l(zt),l(Lt),l(ce),l(Pt),l(Dt),l(ye),l(Kt),l(me),l(Ot),l(he),l(el),l(tl),l(we),l(ll),l(Te),l(sl),l(Je),l(ol),l(nl),l(Ue),l(al),l(Oe),l(il),l(fe),l(rl),l(Ml),l(pl),l(et),l(ul),l(ve),l(cl),l(dl),l(Ze),l(yl),l(Be),l(ml),l(hl),l(bl),l(ke),l(wl),l(Qe),l(Tl),l(Jl),l(Re),l(jl),l(Ul),l(J),l(fl),l(gl),l(Ve),l(Cl),l(vl),l(Ne),l(Il),l(Ee),l(Zl),l(j),l(Bl),l(Xe),l(Wl),l(Gl),l(Ae),l(kl),l(Ql),l(Fe),l(Hl),l(Rl),l(_l),l(Le),l($l),l(Vl),l(De),l(xl),l(Nl),l(lt)),l(b),y(f,e),y(g,e),y(C,e),y(I,e),y(Q,e),y(x,e),y(E,e),y(Y,e),y(z,e),y(D,e),y(O,e),y(te,e),y(se,e),y(oe,e),y(ie,e),y(ue,e),y(de,e),y(be,e),y(je,e),y(ge,e),y(Ce,e),y(Ie,e),y(We,e),y(Ge,e),y(He,e),y(_e,e),y($e,e),y(xe,e),y(Se,e),y(qe,e),y(Ye,e),y(ze,e),y(Pe,e),y(Ke,e)}}}const oo='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[{"title":"Structured Output and Output Schema Support","local":"structured-output-and-output-schema-support","sections":[],"depth":4}],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function no(Xl){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class uo extends Ps{constructor(b){super(),Ds(this,b,no,so,Ys,{})}}export{uo as component};
