import{s as Re,n as Be,o as Ie}from"../chunks/scheduler.3d32dc09.js";import{S as Ze,i as Ae,e as y,s,c as i,h as xe,a as u,d as n,b as a,f as ke,g as p,j as E,k as ve,l as Ge,m as l,n as r,t as o,o as d,p as m}from"../chunks/index.f9718211.js";import{C as He,H as c,E as Se}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as V}from"../chunks/CodeBlock.a5391745.js";function _e($e){let h,X,N,L,g,q,f,F,M,we=`This guide demonstrates how to integrate a synchronous agent from the <code>smolagents</code> library into an asynchronous Python web application using Starlette.
The example is designed to help users new to async Python and agent integration understand best practices for combining synchronous agent logic with async web servers.`,Y,$,z,w,Te="<li><strong>Starlette</strong>: A lightweight ASGI framework for building asynchronous web applications in Python.</li> <li><strong>anyio.to_thread.run_sync</strong>: Utility to run blocking (synchronous) code in a background thread, preventing it from blocking the async event loop.</li> <li><strong>CodeAgent</strong>: An agent from the <code>smolagents</code> library capable of programmatically solving tasks.</li>",P,T,O,U,Ue="<code>CodeAgent.run()</code> executes Python code synchronously. If called directly in an async endpoint, it would block Starlette’s event loop, reducing performance and scalability. By offloading this operation to a background thread with <code>anyio.to_thread.run_sync</code>, you keep the app responsive and efficient, even under high concurrency.",D,b,K,J,be="<li>The Starlette app exposes a <code>/run-agent</code> endpoint that accepts a JSON payload with a <code>task</code> string.</li> <li>When a request is received, the agent is run in a background thread using <code>anyio.to_thread.run_sync</code>.</li> <li>The result is returned as a JSON response.</li>",ee,j,te,C,ne,k,le,v,se,R,ae,B,ie,I,pe,Z,re,A,oe,x,Je="<strong>Expected Response:</strong>",de,G,me,H,ye,S,je='<li><a href="https://www.starlette.io/" rel="nofollow">Starlette Documentation</a></li> <li><a href="https://anyio.readthedocs.io/" rel="nofollow">anyio Documentation</a></li>',ue,ce,he,_,Ce='For the full code, see <a href="https://github.com/huggingface/smolagents/tree/main/examples/async_agent" rel="nofollow"><code>examples/async_agent</code></a>.',ge,W,fe,Q,Me;return g=new He({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new c({props:{title:"Async Applications with Agents",local:"async-applications-with-agents",headingTag:"h1"}}),$=new c({props:{title:"Overview",local:"overview",headingTag:"h2"}}),T=new c({props:{title:"Why Use a Background Thread?",local:"why-use-a-background-thread",headingTag:"h2"}}),b=new c({props:{title:"Example Workflow",local:"example-workflow",headingTag:"h2"}}),j=new c({props:{title:"Building a Starlette App with a CodeAgent",local:"building-a-starlette-app-with-a-codeagent",headingTag:"h2"}}),C=new c({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h3"}}),k=new V({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBzdGFybGV0dGUlMjBhbnlpbyUyMHV2aWNvcm4=",highlighted:"pip install smolagents starlette anyio uvicorn",wrap:!1}}),v=new c({props:{title:"2. Application Code ( main.py )",local:"2-application-code--mainpy-",headingTag:"h3"}}),R=new V({props:{code:"aW1wb3J0JTIwYW55aW8udG9fdGhyZWFkJTBBZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBzdGFybGV0dGUucmVzcG9uc2VzJTIwaW1wb3J0JTIwSlNPTlJlc3BvbnNlJTBBZnJvbSUyMHN0YXJsZXR0ZS5yb3V0aW5nJTIwaW1wb3J0JTIwUm91dGUlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSklMEElMEFhc3luYyUyMGRlZiUyMHJ1bl9hZ2VudChyZXF1ZXN0JTNBJTIwUmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0Lmpzb24oKSUwQSUyMCUyMCUyMCUyMHRhc2slMjAlM0QlMjBkYXRhLmdldCglMjJ0YXNrJTIyJTJDJTIwJTIyJTIyKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMHRoZSUyMGFnZW50JTIwc3luY2hyb25vdXNseSUyMGluJTIwYSUyMGJhY2tncm91bmQlMjB0aHJlYWQlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGFueWlvLnRvX3RocmVhZC5ydW5fc3luYyhhZ2VudC5ydW4lMkMlMjB0YXNrKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEpTT05SZXNwb25zZSglN0IlMjJyZXN1bHQlMjIlM0ElMjByZXN1bHQlN0QpJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRnJ1bi1hZ2VudCUyMiUyQyUyMHJ1bl9hZ2VudCUyQyUyMG1ldGhvZHMlM0QlNUIlMjJQT1NUJTIyJTVEKSUyQyUwQSU1RCk=",highlighted:`<span class="hljs-keyword">import</span> anyio.to_thread
<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.requests <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
    tools=[],
)

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_agent</span>(<span class="hljs-params">request: Request</span>):
    data = <span class="hljs-keyword">await</span> request.json()
    task = data.get(<span class="hljs-string">&quot;task&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)
    <span class="hljs-comment"># Run the agent synchronously in a background thread</span>
    result = <span class="hljs-keyword">await</span> anyio.to_thread.run_sync(agent.run, task)
    <span class="hljs-keyword">return</span> JSONResponse({<span class="hljs-string">&quot;result&quot;</span>: result})

app = Starlette(routes=[
    Route(<span class="hljs-string">&quot;/run-agent&quot;</span>, run_agent, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
])`,wrap:!1}}),B=new c({props:{title:"3. Run the App",local:"3-run-the-app",headingTag:"h3"}}),I=new V({props:{code:"dXZpY29ybiUyMGFzeW5jX2FnZW50Lm1haW4lM0FhcHAlMjAtLXJlbG9hZA==",highlighted:"uvicorn async_agent.main:app --reload",wrap:!1}}),Z=new c({props:{title:"4. Test the Endpoint",local:"4-test-the-endpoint",headingTag:"h3"}}),A=new V({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDAwJTJGcnVuLWFnZW50JTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMC1kJTIwJyU3QiUyMnRhc2slMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjAyJTJCMiUzRiUyMiU3RCc=",highlighted:'curl -X POST http://localhost:8000/run-agent -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> -d <span class="hljs-string">&#x27;{&quot;task&quot;: &quot;What is 2+2?&quot;}&#x27;</span>',wrap:!1}}),G=new V({props:{code:"JTdCJTIycmVzdWx0JTIyJTNBJTIwJTIyNCUyMiU3RA==",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;result&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;4&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),H=new c({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),W=new Se({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/async_agent.md"}}),{c(){h=y("meta"),X=s(),N=y("p"),L=s(),i(g.$$.fragment),q=s(),i(f.$$.fragment),F=s(),M=y("p"),M.innerHTML=we,Y=s(),i($.$$.fragment),z=s(),w=y("ul"),w.innerHTML=Te,P=s(),i(T.$$.fragment),O=s(),U=y("p"),U.innerHTML=Ue,D=s(),i(b.$$.fragment),K=s(),J=y("ul"),J.innerHTML=be,ee=s(),i(j.$$.fragment),te=s(),i(C.$$.fragment),ne=s(),i(k.$$.fragment),le=s(),i(v.$$.fragment),se=s(),i(R.$$.fragment),ae=s(),i(B.$$.fragment),ie=s(),i(I.$$.fragment),pe=s(),i(Z.$$.fragment),re=s(),i(A.$$.fragment),oe=s(),x=y("p"),x.innerHTML=Je,de=s(),i(G.$$.fragment),me=s(),i(H.$$.fragment),ye=s(),S=y("ul"),S.innerHTML=je,ue=s(),ce=y("hr"),he=s(),_=y("p"),_.innerHTML=Ce,ge=s(),i(W.$$.fragment),fe=s(),Q=y("p"),this.h()},l(e){const t=xe("svelte-u9bgzb",document.head);h=u(t,"META",{name:!0,content:!0}),t.forEach(n),X=a(e),N=u(e,"P",{}),ke(N).forEach(n),L=a(e),p(g.$$.fragment,e),q=a(e),p(f.$$.fragment,e),F=a(e),M=u(e,"P",{"data-svelte-h":!0}),E(M)!=="svelte-1sp3xbb"&&(M.innerHTML=we),Y=a(e),p($.$$.fragment,e),z=a(e),w=u(e,"UL",{"data-svelte-h":!0}),E(w)!=="svelte-jb7c4l"&&(w.innerHTML=Te),P=a(e),p(T.$$.fragment,e),O=a(e),U=u(e,"P",{"data-svelte-h":!0}),E(U)!=="svelte-nzal2x"&&(U.innerHTML=Ue),D=a(e),p(b.$$.fragment,e),K=a(e),J=u(e,"UL",{"data-svelte-h":!0}),E(J)!=="svelte-14mqlu7"&&(J.innerHTML=be),ee=a(e),p(j.$$.fragment,e),te=a(e),p(C.$$.fragment,e),ne=a(e),p(k.$$.fragment,e),le=a(e),p(v.$$.fragment,e),se=a(e),p(R.$$.fragment,e),ae=a(e),p(B.$$.fragment,e),ie=a(e),p(I.$$.fragment,e),pe=a(e),p(Z.$$.fragment,e),re=a(e),p(A.$$.fragment,e),oe=a(e),x=u(e,"P",{"data-svelte-h":!0}),E(x)!=="svelte-txxf38"&&(x.innerHTML=Je),de=a(e),p(G.$$.fragment,e),me=a(e),p(H.$$.fragment,e),ye=a(e),S=u(e,"UL",{"data-svelte-h":!0}),E(S)!=="svelte-1ned3mp"&&(S.innerHTML=je),ue=a(e),ce=u(e,"HR",{}),he=a(e),_=u(e,"P",{"data-svelte-h":!0}),E(_)!=="svelte-bfduaj"&&(_.innerHTML=Ce),ge=a(e),p(W.$$.fragment,e),fe=a(e),Q=u(e,"P",{}),ke(Q).forEach(n),this.h()},h(){ve(h,"name","hf:doc:metadata"),ve(h,"content",We)},m(e,t){Ge(document.head,h),l(e,X,t),l(e,N,t),l(e,L,t),r(g,e,t),l(e,q,t),r(f,e,t),l(e,F,t),l(e,M,t),l(e,Y,t),r($,e,t),l(e,z,t),l(e,w,t),l(e,P,t),r(T,e,t),l(e,O,t),l(e,U,t),l(e,D,t),r(b,e,t),l(e,K,t),l(e,J,t),l(e,ee,t),r(j,e,t),l(e,te,t),r(C,e,t),l(e,ne,t),r(k,e,t),l(e,le,t),r(v,e,t),l(e,se,t),r(R,e,t),l(e,ae,t),r(B,e,t),l(e,ie,t),r(I,e,t),l(e,pe,t),r(Z,e,t),l(e,re,t),r(A,e,t),l(e,oe,t),l(e,x,t),l(e,de,t),r(G,e,t),l(e,me,t),r(H,e,t),l(e,ye,t),l(e,S,t),l(e,ue,t),l(e,ce,t),l(e,he,t),l(e,_,t),l(e,ge,t),r(W,e,t),l(e,fe,t),l(e,Q,t),Me=!0},p:Be,i(e){Me||(o(g.$$.fragment,e),o(f.$$.fragment,e),o($.$$.fragment,e),o(T.$$.fragment,e),o(b.$$.fragment,e),o(j.$$.fragment,e),o(C.$$.fragment,e),o(k.$$.fragment,e),o(v.$$.fragment,e),o(R.$$.fragment,e),o(B.$$.fragment,e),o(I.$$.fragment,e),o(Z.$$.fragment,e),o(A.$$.fragment,e),o(G.$$.fragment,e),o(H.$$.fragment,e),o(W.$$.fragment,e),Me=!0)},o(e){d(g.$$.fragment,e),d(f.$$.fragment,e),d($.$$.fragment,e),d(T.$$.fragment,e),d(b.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(R.$$.fragment,e),d(B.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(A.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(W.$$.fragment,e),Me=!1},d(e){e&&(n(X),n(N),n(L),n(q),n(F),n(M),n(Y),n(z),n(w),n(P),n(O),n(U),n(D),n(K),n(J),n(ee),n(te),n(ne),n(le),n(se),n(ae),n(ie),n(pe),n(re),n(oe),n(x),n(de),n(me),n(ye),n(S),n(ue),n(ce),n(he),n(_),n(ge),n(fe),n(Q)),n(h),m(g,e),m(f,e),m($,e),m(T,e),m(b,e),m(j,e),m(C,e),m(k,e),m(v,e),m(R,e),m(B,e),m(I,e),m(Z,e),m(A,e),m(G,e),m(H,e),m(W,e)}}}const We='{"title":"Async Applications with Agents","local":"async-applications-with-agents","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Why Use a Background Thread?","local":"why-use-a-background-thread","sections":[],"depth":2},{"title":"Example Workflow","local":"example-workflow","sections":[],"depth":2},{"title":"Building a Starlette App with a CodeAgent","local":"building-a-starlette-app-with-a-codeagent","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":3},{"title":"2. Application Code ( main.py )","local":"2-application-code--mainpy-","sections":[],"depth":3},{"title":"3. Run the App","local":"3-run-the-app","sections":[],"depth":3},{"title":"4. Test the Endpoint","local":"4-test-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Ee($e){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends Ze{constructor(h){super(),Ae(this,h,Ee,_e,Re,{})}}export{Le as component};
