import{s as mt,n as ot,o as rt}from"../chunks/scheduler.3d32dc09.js";import{S as Tt,i as Jt,e as s,s as i,c as o,h as ut,a as p,d as n,b as a,f as st,g as r,j as m,k as pt,l as ft,m as l,n as T,t as J,o as u,p as f}from"../chunks/index.f9718211.js";import{C as ct,H as c,E as Et}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as Ze}from"../chunks/CodeBlock.a5391745.js";function ht(Pe){let E,ee,K,te,h,ne,N,le,$,Qe=`This page demonstrates advanced usage of the smolagents library, with a special focus on <strong>Human-in-the-Loop (HITL)</strong> approaches for interactive plan creation, user-driven plan modification, and memory preservation in agentic workflows.
The example is based on the code in <code>examples/plan_customization/plan_customization.py</code>.`,ie,C,ae,w,Ve="This example teaches you how to implement Human-in-the-Loop strategies to:",se,d,Se="<li>Interrupt agent execution after a plan is created (using step callbacks)</li> <li>Allow users to review and modify the agent’s plan before execution (Human-in-the-Loop)</li> <li>Resume execution while preserving the agent’s memory</li> <li>Dynamically update plans based on user feedback, keeping the human in control</li>",pe,M,me,g,oe,U,Ae="The agent is configured to pause after creating a plan. This is achieved by registering a step callback for the <code>PlanningStep</code>:",re,y,Te,v,Je,R,Ge="When the agent creates a plan, the callback displays it and prompts the human user to:",ue,b,Ye="<li>Approve the plan</li> <li>Modify the plan</li> <li>Cancel execution</li>",fe,z,Fe="Example interaction:",ce,x,Ee,I,Xe="This Human-in-the-Loop step enables a human to intervene and review or modify the plan before execution continues, and ensures that the agent’s actions align with human intent.",he,j,De="If the user chooses to modify, they can edit the plan directly. The updated plan is then used for subsequent execution steps.",Ne,H,$e,B,qe="By running the agent with <code>reset=False</code>, all previous steps and memory are preserved. This allows you to resume execution after an interruption or plan modification:",Ce,_,we,k,de,L,Ke="You can inspect the agent’s memory to see all steps taken so far:",Me,W,ge,Z,Ue,P,Oe="<li>Agent starts with a complex task</li> <li>Planning step is created and execution pauses for human review</li> <li>Human reviews and optionally modifies the plan (Human-in-the-Loop)</li> <li>Execution resumes with the approved/modified plan</li> <li>All steps are preserved for future runs, maintaining transparency and control</li>",ye,Q,ve,V,et="The example includes error handling for:",Re,S,tt="<li>User cancellation</li> <li>Plan modification errors</li> <li>Resume execution failures</li>",be,A,ze,G,nt="<li>smolagents library</li> <li>DuckDuckGoSearchTool (included with smolagents)</li> <li>InferenceClientModel (requires HuggingFace API token)</li>",xe,Y,Ie,F,lt="This example demonstrates:",je,X,it="<li>Step callback implementation for custom agent behavior</li> <li>Memory management in multi-step agents</li> <li>User interaction patterns in agentic systems</li> <li>Plan modification techniques for dynamic agent control</li> <li>Error handling in interactive agent systems</li>",He,Be,_e,D,at='For the full code, see <a href="https://github.com/huggingface/smolagents/tree/main/examples/plan_customization" rel="nofollow"><code>examples/plan_customization</code></a>.',ke,q,Le,O,We;return h=new ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),N=new c({props:{title:"Human-in-the-Loop: Customize Agent Plan Interactively",local:"human-in-the-loop-customize-agent-plan-interactively",headingTag:"h1"}}),C=new c({props:{title:"Overview",local:"overview",headingTag:"h2"}}),M=new c({props:{title:"Key Concepts",local:"key-concepts",headingTag:"h2"}}),g=new c({props:{title:"Step Callbacks for Plan Interruption",local:"step-callbacks-for-plan-interruption",headingTag:"h3"}}),y=new Ze({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0Q1JTJDJTIwJTIwJTIzJTIwUGxhbiUyMGV2ZXJ5JTIwNSUyMHN0ZXBzJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlN0JQbGFubmluZ1N0ZXAlM0ElMjBpbnRlcnJ1cHRfYWZ0ZXJfcGxhbiU3RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMSUwQSk=",highlighted:`agent = CodeAgent(
    model=InferenceClientModel(),
    tools=[DuckDuckGoSearchTool()],
    planning_interval=<span class="hljs-number">5</span>,  <span class="hljs-comment"># Plan every 5 steps</span>
    step_callbacks={PlanningStep: interrupt_after_plan},
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">1</span>
)`,wrap:!1}}),v=new c({props:{title:"Human-in-the-Loop: Interactive Plan Review and Modification",local:"human-in-the-loop-interactive-plan-review-and-modification",headingTag:"h3"}}),x=new Ze({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJUYwJTlGJUE0JTk2JTIwQUdFTlQlMjBQTEFOJTIwQ1JFQVRFRCUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQTEuJTIwU2VhcmNoJTIwZm9yJTIwcmVjZW50JTIwQUklMjBkZXZlbG9wbWVudHMlMEEyLiUyMEFuYWx5emUlMjB0aGUlMjB0b3AlMjByZXN1bHRzJTBBMy4lMjBTdW1tYXJpemUlMjB0aGUlMjAzJTIwbW9zdCUyMHNpZ25pZmljYW50JTIwYnJlYWt0aHJvdWdocyUwQTQuJTIwSW5jbHVkZSUyMHNvdXJjZXMlMjBmb3IlMjBlYWNoJTIwYnJlYWt0aHJvdWdoJTBBJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTBBQ2hvb3NlJTIwYW4lMjBvcHRpb24lM0ElMEExLiUyMEFwcHJvdmUlMjBwbGFuJTBBMi4lMjBNb2RpZnklMjBwbGFuJTBBMy4lMjBDYW5jZWwlMEFZb3VyJTIwY2hvaWNlJTIwKDEtMyklM0E=",highlighted:`============================================================
🤖 AGENT PLAN CREATED
============================================================
1. Search for recent AI developments
2. Analyze the top results
3. Summarize the 3 most significant breakthroughs
<span class="hljs-section">4. Include sources for each breakthrough
============================================================</span>

Choose an option:
1. Approve plan
2. Modify plan
3. Cancel
Your choice (1-3):`,wrap:!1}}),H=new c({props:{title:"Memory Preservation and Resuming Execution",local:"memory-preservation-and-resuming-execution",headingTag:"h3"}}),_=new Ze({props:{code:"JTIzJTIwRmlyc3QlMjBydW4lMjAobWF5JTIwYmUlMjBpbnRlcnJ1cHRlZCklMEFhZ2VudC5ydW4odGFzayUyQyUyMHJlc2V0JTNEVHJ1ZSklMEElMEElMjMlMjBSZXN1bWUlMjB3aXRoJTIwcHJlc2VydmVkJTIwbWVtb3J5JTBBYWdlbnQucnVuKHRhc2slMkMlMjByZXNldCUzREZhbHNlKQ==",highlighted:`<span class="hljs-comment"># First run (may be interrupted)</span>
agent.run(task, reset=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Resume with preserved memory</span>
agent.run(task, reset=<span class="hljs-literal">False</span>)`,wrap:!1}}),k=new c({props:{title:"Inspecting Agent Memory",local:"inspecting-agent-memory",headingTag:"h3"}}),W=new Ze({props:{code:"cHJpbnQoZiUyMkN1cnJlbnQlMjBtZW1vcnklMjBjb250YWlucyUyMCU3QmxlbihhZ2VudC5tZW1vcnkuc3RlcHMpJTdEJTIwc3RlcHMlM0ElMjIpJTBBZm9yJTIwaSUyQyUyMHN0ZXAlMjBpbiUyMGVudW1lcmF0ZShhZ2VudC5tZW1vcnkuc3RlcHMpJTNBJTBBJTIwJTIwJTIwJTIwc3RlcF90eXBlJTIwJTNEJTIwdHlwZShzdGVwKS5fX25hbWVfXyUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JpJTJCMSU3RC4lMjAlN0JzdGVwX3R5cGUlN0QlMjIp",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Current memory contains <span class="hljs-subst">{<span class="hljs-built_in">len</span>(agent.memory.steps)}</span> steps:&quot;</span>)
<span class="hljs-keyword">for</span> i, step <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(agent.memory.steps):
    step_type = <span class="hljs-built_in">type</span>(step).__name__
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{i+<span class="hljs-number">1</span>}</span>. <span class="hljs-subst">{step_type}</span>&quot;</span>)`,wrap:!1}}),Z=new c({props:{title:"Example Human-in-the-Loop Workflow",local:"example-human-in-the-loop-workflow",headingTag:"h2"}}),Q=new c({props:{title:"Error Handling",local:"error-handling",headingTag:"h2"}}),A=new c({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),Y=new c({props:{title:"Educational Value",local:"educational-value",headingTag:"h2"}}),q=new Et({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/plan_customization.md"}}),{c(){E=s("meta"),ee=i(),K=s("p"),te=i(),o(h.$$.fragment),ne=i(),o(N.$$.fragment),le=i(),$=s("p"),$.innerHTML=Qe,ie=i(),o(C.$$.fragment),ae=i(),w=s("p"),w.textContent=Ve,se=i(),d=s("ul"),d.innerHTML=Se,pe=i(),o(M.$$.fragment),me=i(),o(g.$$.fragment),oe=i(),U=s("p"),U.innerHTML=Ae,re=i(),o(y.$$.fragment),Te=i(),o(v.$$.fragment),Je=i(),R=s("p"),R.textContent=Ge,ue=i(),b=s("ol"),b.innerHTML=Ye,fe=i(),z=s("p"),z.textContent=Fe,ce=i(),o(x.$$.fragment),Ee=i(),I=s("p"),I.textContent=Xe,he=i(),j=s("p"),j.textContent=De,Ne=i(),o(H.$$.fragment),$e=i(),B=s("p"),B.innerHTML=qe,Ce=i(),o(_.$$.fragment),we=i(),o(k.$$.fragment),de=i(),L=s("p"),L.textContent=Ke,Me=i(),o(W.$$.fragment),ge=i(),o(Z.$$.fragment),Ue=i(),P=s("ol"),P.innerHTML=Oe,ye=i(),o(Q.$$.fragment),ve=i(),V=s("p"),V.textContent=et,Re=i(),S=s("ul"),S.innerHTML=tt,be=i(),o(A.$$.fragment),ze=i(),G=s("ul"),G.innerHTML=nt,xe=i(),o(Y.$$.fragment),Ie=i(),F=s("p"),F.textContent=lt,je=i(),X=s("ul"),X.innerHTML=it,He=i(),Be=s("hr"),_e=i(),D=s("p"),D.innerHTML=at,ke=i(),o(q.$$.fragment),Le=i(),O=s("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);E=p(t,"META",{name:!0,content:!0}),t.forEach(n),ee=a(e),K=p(e,"P",{}),st(K).forEach(n),te=a(e),r(h.$$.fragment,e),ne=a(e),r(N.$$.fragment,e),le=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1wti06c"&&($.innerHTML=Qe),ie=a(e),r(C.$$.fragment,e),ae=a(e),w=p(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-kmblxs"&&(w.textContent=Ve),se=a(e),d=p(e,"UL",{"data-svelte-h":!0}),m(d)!=="svelte-n2ijli"&&(d.innerHTML=Se),pe=a(e),r(M.$$.fragment,e),me=a(e),r(g.$$.fragment,e),oe=a(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-azc98v"&&(U.innerHTML=Ae),re=a(e),r(y.$$.fragment,e),Te=a(e),r(v.$$.fragment,e),Je=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-jevtav"&&(R.textContent=Ge),ue=a(e),b=p(e,"OL",{"data-svelte-h":!0}),m(b)!=="svelte-1qdpmfw"&&(b.innerHTML=Ye),fe=a(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-w8vt1w"&&(z.textContent=Fe),ce=a(e),r(x.$$.fragment,e),Ee=a(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-eb1jys"&&(I.textContent=Xe),he=a(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-bn3dhy"&&(j.textContent=De),Ne=a(e),r(H.$$.fragment,e),$e=a(e),B=p(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-r52soi"&&(B.innerHTML=qe),Ce=a(e),r(_.$$.fragment,e),we=a(e),r(k.$$.fragment,e),de=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-poryh8"&&(L.textContent=Ke),Me=a(e),r(W.$$.fragment,e),ge=a(e),r(Z.$$.fragment,e),Ue=a(e),P=p(e,"OL",{"data-svelte-h":!0}),m(P)!=="svelte-zuge37"&&(P.innerHTML=Oe),ye=a(e),r(Q.$$.fragment,e),ve=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-majit4"&&(V.textContent=et),Re=a(e),S=p(e,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-1753xp9"&&(S.innerHTML=tt),be=a(e),r(A.$$.fragment,e),ze=a(e),G=p(e,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-1tasrgg"&&(G.innerHTML=nt),xe=a(e),r(Y.$$.fragment,e),Ie=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-eguazz"&&(F.textContent=lt),je=a(e),X=p(e,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-1hkp5ed"&&(X.innerHTML=it),He=a(e),Be=p(e,"HR",{}),_e=a(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1ru3szn"&&(D.innerHTML=at),ke=a(e),r(q.$$.fragment,e),Le=a(e),O=p(e,"P",{}),st(O).forEach(n),this.h()},h(){pt(E,"name","hf:doc:metadata"),pt(E,"content",Nt)},m(e,t){ft(document.head,E),l(e,ee,t),l(e,K,t),l(e,te,t),T(h,e,t),l(e,ne,t),T(N,e,t),l(e,le,t),l(e,$,t),l(e,ie,t),T(C,e,t),l(e,ae,t),l(e,w,t),l(e,se,t),l(e,d,t),l(e,pe,t),T(M,e,t),l(e,me,t),T(g,e,t),l(e,oe,t),l(e,U,t),l(e,re,t),T(y,e,t),l(e,Te,t),T(v,e,t),l(e,Je,t),l(e,R,t),l(e,ue,t),l(e,b,t),l(e,fe,t),l(e,z,t),l(e,ce,t),T(x,e,t),l(e,Ee,t),l(e,I,t),l(e,he,t),l(e,j,t),l(e,Ne,t),T(H,e,t),l(e,$e,t),l(e,B,t),l(e,Ce,t),T(_,e,t),l(e,we,t),T(k,e,t),l(e,de,t),l(e,L,t),l(e,Me,t),T(W,e,t),l(e,ge,t),T(Z,e,t),l(e,Ue,t),l(e,P,t),l(e,ye,t),T(Q,e,t),l(e,ve,t),l(e,V,t),l(e,Re,t),l(e,S,t),l(e,be,t),T(A,e,t),l(e,ze,t),l(e,G,t),l(e,xe,t),T(Y,e,t),l(e,Ie,t),l(e,F,t),l(e,je,t),l(e,X,t),l(e,He,t),l(e,Be,t),l(e,_e,t),l(e,D,t),l(e,ke,t),T(q,e,t),l(e,Le,t),l(e,O,t),We=!0},p:ot,i(e){We||(J(h.$$.fragment,e),J(N.$$.fragment,e),J(C.$$.fragment,e),J(M.$$.fragment,e),J(g.$$.fragment,e),J(y.$$.fragment,e),J(v.$$.fragment,e),J(x.$$.fragment,e),J(H.$$.fragment,e),J(_.$$.fragment,e),J(k.$$.fragment,e),J(W.$$.fragment,e),J(Z.$$.fragment,e),J(Q.$$.fragment,e),J(A.$$.fragment,e),J(Y.$$.fragment,e),J(q.$$.fragment,e),We=!0)},o(e){u(h.$$.fragment,e),u(N.$$.fragment,e),u(C.$$.fragment,e),u(M.$$.fragment,e),u(g.$$.fragment,e),u(y.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),We=!1},d(e){e&&(n(ee),n(K),n(te),n(ne),n(le),n($),n(ie),n(ae),n(w),n(se),n(d),n(pe),n(me),n(oe),n(U),n(re),n(Te),n(Je),n(R),n(ue),n(b),n(fe),n(z),n(ce),n(Ee),n(I),n(he),n(j),n(Ne),n($e),n(B),n(Ce),n(we),n(de),n(L),n(Me),n(ge),n(Ue),n(P),n(ye),n(ve),n(V),n(Re),n(S),n(be),n(ze),n(G),n(xe),n(Ie),n(F),n(je),n(X),n(He),n(Be),n(_e),n(D),n(ke),n(Le),n(O)),n(E),f(h,e),f(N,e),f(C,e),f(M,e),f(g,e),f(y,e),f(v,e),f(x,e),f(H,e),f(_,e),f(k,e),f(W,e),f(Z,e),f(Q,e),f(A,e),f(Y,e),f(q,e)}}}const Nt='{"title":"Human-in-the-Loop: Customize Agent Plan Interactively","local":"human-in-the-loop-customize-agent-plan-interactively","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Key Concepts","local":"key-concepts","sections":[{"title":"Step Callbacks for Plan Interruption","local":"step-callbacks-for-plan-interruption","sections":[],"depth":3},{"title":"Human-in-the-Loop: Interactive Plan Review and Modification","local":"human-in-the-loop-interactive-plan-review-and-modification","sections":[],"depth":3},{"title":"Memory Preservation and Resuming Execution","local":"memory-preservation-and-resuming-execution","sections":[],"depth":3},{"title":"Inspecting Agent Memory","local":"inspecting-agent-memory","sections":[],"depth":3}],"depth":2},{"title":"Example Human-in-the-Loop Workflow","local":"example-human-in-the-loop-workflow","sections":[],"depth":2},{"title":"Error Handling","local":"error-handling","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Educational Value","local":"educational-value","sections":[],"depth":2}],"depth":1}';function $t(Pe){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends Tt{constructor(E){super(),Jt(this,E,$t,ht,mt,{})}}export{gt as component};
