import{s as mt,n as bt,o as dt}from"../chunks/scheduler.3d32dc09.js";import{S as ht,i as Ct,e as M,s as n,c as p,h as It,a as i,d as e,b as a,f as wt,g as y,j as o,k as jt,l as gt,m as s,n as U,t as u,o as r,p as J}from"../chunks/index.f9718211.js";import{C as ft,H as Yl,E as Bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as c}from"../chunks/CodeBlock.a5391745.js";import{D as Qt}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function qt(Fl){let T,nl,el,al,w,Ml,j,il,m,ol,b,Ll="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",pl,d,zl="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",yl,h,Dl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",Ul,C,Pl="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",ul,I,Kl="Let’s build this agent! 💪",rl,g,Ol="Run the line below to install required dependencies:",Jl,f,cl,B,lt=`To call Inference Providers, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,Tl,Q,wl,q,tt="Then, we setup the SQL environment:",jl,v,ml,Z,bl,W,et="Now let’s make our SQL table retrievable by a tool.",dl,S,st="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",hl,G,Cl,_,Il,k,nt='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',gl,N,at="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",fl,R,Bl,E,Mt="Now let us create an agent that leverages this tool.",Ql,A,it="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",ql,x,ot="The model is the LLM that powers the agent system. <code>InferenceClientModel</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",vl,$,Zl,V,Wl,X,pt="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Sl,H,yt="So let’s make a second table recording the names of waiters for each receipt_id!",Gl,Y,_l,F,Ut="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",kl,L,Nl,z,ut='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',Rl,D,El,P,rt="It directly works! The setup was surprisingly simple, wasn’t it?",Al,K,Jt="This example is done! We’ve touched upon these concepts:",xl,O,ct="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",$l,ll,Tt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Vl,tl,Xl,sl,Hl;return w=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),m=new Yl({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),f=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHl0aG9uLWRvdGVudiUyMHNxbGFsY2hlbXklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents python-dotenv sqlalchemy --upgrade -q",wrap:!1}}),Q=new c({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),v=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">insert_rows_into_table</span>(<span class="hljs-params">rows, table, engine=engine</span>):
    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
        stmt = insert(table).values(**row)
        <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
            connection.execute(stmt)

table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
insert_rows_into_table(rows, receipts)`,wrap:!1}}),Z=new Yl({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),G=new c({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),_=new c({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),R=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),$=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUyQyUwQSklMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2xpZW50JTIwd2hvJTIwZ290JTIwdGhlJTIwbW9zdCUyMGV4cGVuc2l2ZSUyMHJlY2VpcHQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),V=new Yl({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),Y=new c({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEF3YWl0ZXJzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyd2FpdGVyX25hbWUlMjIlMkMlMjBTdHJpbmcoMTYpJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJDb3JleSUyMEpvaG5zb24lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMiUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWljaGFlbCUyMFdhdHRzJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDMlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjA0JTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTdEJTJDJTBBJTVEJTBBaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwd2FpdGVycyk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
waiters = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
insert_rows_into_table(rows, waiters)`,wrap:!1}}),L=new c({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),D=new c({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),tl=new Bt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.md"}}),{c(){T=M("meta"),nl=n(),el=M("p"),al=n(),p(w.$$.fragment),Ml=n(),p(j.$$.fragment),il=n(),p(m.$$.fragment),ol=n(),b=M("p"),b.innerHTML=Ll,pl=n(),d=M("blockquote"),d.innerHTML=zl,yl=n(),h=M("p"),h.textContent=Dl,Ul=n(),C=M("p"),C.textContent=Pl,ul=n(),I=M("p"),I.textContent=Kl,rl=n(),g=M("p"),g.textContent=Ol,Jl=n(),p(f.$$.fragment),cl=n(),B=M("p"),B.innerHTML=lt,Tl=n(),p(Q.$$.fragment),wl=n(),q=M("p"),q.textContent=tt,jl=n(),p(v.$$.fragment),ml=n(),p(Z.$$.fragment),bl=n(),W=M("p"),W.textContent=et,dl=n(),S=M("p"),S.textContent=st,hl=n(),p(G.$$.fragment),Cl=n(),p(_.$$.fragment),Il=n(),k=M("p"),k.innerHTML=nt,gl=n(),N=M("ul"),N.innerHTML=at,fl=n(),p(R.$$.fragment),Bl=n(),E=M("p"),E.textContent=Mt,Ql=n(),A=M("p"),A.innerHTML=it,ql=n(),x=M("p"),x.innerHTML=ot,vl=n(),p($.$$.fragment),Zl=n(),p(V.$$.fragment),Wl=n(),X=M("p"),X.textContent=pt,Sl=n(),H=M("p"),H.textContent=yt,Gl=n(),p(Y.$$.fragment),_l=n(),F=M("p"),F.innerHTML=Ut,kl=n(),p(L.$$.fragment),Nl=n(),z=M("p"),z.innerHTML=ut,Rl=n(),p(D.$$.fragment),El=n(),P=M("p"),P.textContent=rt,Al=n(),K=M("p"),K.textContent=Jt,xl=n(),O=M("ul"),O.innerHTML=ct,$l=n(),ll=M("p"),ll.textContent=Tt,Vl=n(),p(tl.$$.fragment),Xl=n(),sl=M("p"),this.h()},l(l){const t=It("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(e),nl=a(l),el=i(l,"P",{}),wt(el).forEach(e),al=a(l),y(w.$$.fragment,l),Ml=a(l),y(j.$$.fragment,l),il=a(l),y(m.$$.fragment,l),ol=a(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1rrh2b0"&&(b.innerHTML=Ll),pl=a(l),d=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(d)!=="svelte-1yhwgse"&&(d.innerHTML=zl),yl=a(l),h=i(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1hw7g6s"&&(h.textContent=Dl),Ul=a(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-i6rawm"&&(C.textContent=Pl),ul=a(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1tzrwc8"&&(I.textContent=Kl),rl=a(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-16cuoal"&&(g.textContent=Ol),Jl=a(l),y(f.$$.fragment,l),cl=a(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-14ije4u"&&(B.innerHTML=lt),Tl=a(l),y(Q.$$.fragment,l),wl=a(l),q=i(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-64yurm"&&(q.textContent=tt),jl=a(l),y(v.$$.fragment,l),ml=a(l),y(Z.$$.fragment,l),bl=a(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-fdu5cw"&&(W.textContent=et),dl=a(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-groxlc"&&(S.textContent=st),hl=a(l),y(G.$$.fragment,l),Cl=a(l),y(_.$$.fragment,l),Il=a(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1snt6vj"&&(k.innerHTML=nt),gl=a(l),N=i(l,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-idbd3h"&&(N.innerHTML=at),fl=a(l),y(R.$$.fragment,l),Bl=a(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1t4r7cu"&&(E.textContent=Mt),Ql=a(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-sv1k2f"&&(A.innerHTML=it),ql=a(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1kyyn07"&&(x.innerHTML=ot),vl=a(l),y($.$$.fragment,l),Zl=a(l),y(V.$$.fragment,l),Wl=a(l),X=i(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-nr3fl7"&&(X.textContent=pt),Sl=a(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ru0803"&&(H.textContent=yt),Gl=a(l),y(Y.$$.fragment,l),_l=a(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-l5upel"&&(F.innerHTML=Ut),kl=a(l),y(L.$$.fragment,l),Nl=a(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1uns4lf"&&(z.innerHTML=ut),Rl=a(l),y(D.$$.fragment,l),El=a(l),P=i(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1umn140"&&(P.textContent=rt),Al=a(l),K=i(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-13g6phr"&&(K.textContent=Jt),xl=a(l),O=i(l,"UL",{"data-svelte-h":!0}),o(O)!=="svelte-1pz5sot"&&(O.innerHTML=ct),$l=a(l),ll=i(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-bt1f1w"&&(ll.textContent=Tt),Vl=a(l),y(tl.$$.fragment,l),Xl=a(l),sl=i(l,"P",{}),wt(sl).forEach(e),this.h()},h(){jt(T,"name","hf:doc:metadata"),jt(T,"content",vt)},m(l,t){gt(document.head,T),s(l,nl,t),s(l,el,t),s(l,al,t),U(w,l,t),s(l,Ml,t),U(j,l,t),s(l,il,t),U(m,l,t),s(l,ol,t),s(l,b,t),s(l,pl,t),s(l,d,t),s(l,yl,t),s(l,h,t),s(l,Ul,t),s(l,C,t),s(l,ul,t),s(l,I,t),s(l,rl,t),s(l,g,t),s(l,Jl,t),U(f,l,t),s(l,cl,t),s(l,B,t),s(l,Tl,t),U(Q,l,t),s(l,wl,t),s(l,q,t),s(l,jl,t),U(v,l,t),s(l,ml,t),U(Z,l,t),s(l,bl,t),s(l,W,t),s(l,dl,t),s(l,S,t),s(l,hl,t),U(G,l,t),s(l,Cl,t),U(_,l,t),s(l,Il,t),s(l,k,t),s(l,gl,t),s(l,N,t),s(l,fl,t),U(R,l,t),s(l,Bl,t),s(l,E,t),s(l,Ql,t),s(l,A,t),s(l,ql,t),s(l,x,t),s(l,vl,t),U($,l,t),s(l,Zl,t),U(V,l,t),s(l,Wl,t),s(l,X,t),s(l,Sl,t),s(l,H,t),s(l,Gl,t),U(Y,l,t),s(l,_l,t),s(l,F,t),s(l,kl,t),U(L,l,t),s(l,Nl,t),s(l,z,t),s(l,Rl,t),U(D,l,t),s(l,El,t),s(l,P,t),s(l,Al,t),s(l,K,t),s(l,xl,t),s(l,O,t),s(l,$l,t),s(l,ll,t),s(l,Vl,t),U(tl,l,t),s(l,Xl,t),s(l,sl,t),Hl=!0},p:bt,i(l){Hl||(u(w.$$.fragment,l),u(j.$$.fragment,l),u(m.$$.fragment,l),u(f.$$.fragment,l),u(Q.$$.fragment,l),u(v.$$.fragment,l),u(Z.$$.fragment,l),u(G.$$.fragment,l),u(_.$$.fragment,l),u(R.$$.fragment,l),u($.$$.fragment,l),u(V.$$.fragment,l),u(Y.$$.fragment,l),u(L.$$.fragment,l),u(D.$$.fragment,l),u(tl.$$.fragment,l),Hl=!0)},o(l){r(w.$$.fragment,l),r(j.$$.fragment,l),r(m.$$.fragment,l),r(f.$$.fragment,l),r(Q.$$.fragment,l),r(v.$$.fragment,l),r(Z.$$.fragment,l),r(G.$$.fragment,l),r(_.$$.fragment,l),r(R.$$.fragment,l),r($.$$.fragment,l),r(V.$$.fragment,l),r(Y.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(tl.$$.fragment,l),Hl=!1},d(l){l&&(e(nl),e(el),e(al),e(Ml),e(il),e(ol),e(b),e(pl),e(d),e(yl),e(h),e(Ul),e(C),e(ul),e(I),e(rl),e(g),e(Jl),e(cl),e(B),e(Tl),e(wl),e(q),e(jl),e(ml),e(bl),e(W),e(dl),e(S),e(hl),e(Cl),e(Il),e(k),e(gl),e(N),e(fl),e(Bl),e(E),e(Ql),e(A),e(ql),e(x),e(vl),e(Zl),e(Wl),e(X),e(Sl),e(H),e(Gl),e(_l),e(F),e(kl),e(Nl),e(z),e(Rl),e(El),e(P),e(Al),e(K),e(xl),e(O),e($l),e(ll),e(Vl),e(Xl),e(sl)),e(T),J(w,l),J(j,l),J(m,l),J(f,l),J(Q,l),J(v,l),J(Z,l),J(G,l),J(_,l),J(R,l),J($,l),J(V,l),J(Y,l),J(L,l),J(D,l),J(tl,l)}}}const vt='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function Zt(Fl){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends ht{constructor(T){super(),Ct(this,T,Zt,qt,mt,{})}}export{Nt as component};
