import{s as st,n as nt,o as ot}from"../chunks/scheduler.3d32dc09.js";import{S as it,i as at,e as i,s as n,c as m,h as mt,a,d as l,b as o,f as tt,g as p,j as r,k as lt,l as pt,m as s,n as d,t as f,o as M,p as g}from"../chunks/index.f9718211.js";import{C as rt,H as K,E as dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.87517293.js";import{C as u}from"../chunks/CodeBlock.a5391745.js";import{D as ft}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function Mt(Ce){let T,ee,q,te,c,le,w,se,b,ne,J,je=`<code>smolagents</code> provides a flexible framework that allows you to use various language models from different providers.
This guide will show you how to use different model types with your agents.`,oe,y,ie,U,Ge="<code>smolagents</code> supports several model types out of the box:",ae,I,Pe='<li><a href="/docs/smolagents/main/en/reference/models#smolagents.InferenceClientModel">InferenceClientModel</a>: Uses Hugging Face’s Inference API to access models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.TransformersModel">TransformersModel</a>: Runs models locally using the Transformers library</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.VLLMModel">VLLMModel</a>: Uses vLLM for fast inference with optimized serving</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.MLXModel">MLXModel</a>: Optimized for Apple Silicon devices using MLX</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>: Provides access to hundreds of LLMs through LiteLLM</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMRouterModel">LiteLLMRouterModel</a>: Distributes requests among multiple models</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a>: Provides access to any provider that implements an OpenAI-compatible API</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AzureOpenAIServerModel">AzureOpenAIServerModel</a>: Uses Azure’s OpenAI service</li> <li><a href="/docs/smolagents/main/en/reference/models#smolagents.AmazonBedrockServerModel">AmazonBedrockServerModel</a>: Connects to AWS Bedrock’s API</li>',me,h,Fe=`All model classes support passing additional keyword arguments (like <code>temperature</code>, <code>max_tokens</code>, <code>top_p</code>, etc.) directly at instantiation time.
These parameters are automatically forwarded to the underlying model’s completion calls, allowing you to configure model behavior such as creativity, response length, and sampling strategies.`,pe,$,re,v,We=`As explained in the Google Gemini API documentation (<a href="https://ai.google.dev/gemini-api/docs/openai" rel="nofollow">https://ai.google.dev/gemini-api/docs/openai</a>),
Google provides an OpenAI-compatible API for Gemini models, allowing you to use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a>
with Gemini models by setting the appropriate base URL.`,de,R,He="First, install the required dependencies:",fe,k,Me,L,Oe='Then, <a href="https://ai.google.dev/gemini-api/docs/api-key" rel="nofollow">get a Gemini API key</a> and set it in your code:',ge,B,Te,A,Ze=`Now, you can initialize the Gemini model using the <code>OpenAIServerModel</code> class
and setting the <code>api_base</code> parameter to the Gemini API base URL:`,ue,_,ce,V,we,S,ze=`OpenRouter provides access to a wide variety of language models through a unified OpenAI-compatible API.
You can use the <a href="/docs/smolagents/main/en/reference/models#smolagents.OpenAIServerModel">OpenAIServerModel</a> to connect to OpenRouter by setting the appropriate base URL.`,be,E,Qe="First, install the required dependencies:",Je,x,ye,C,Xe='Then, <a href="https://openrouter.ai/keys" rel="nofollow">get an OpenRouter API key</a> and set it in your code:',Ue,j,Ie,G,Ne="Now, you can initialize any model available on OpenRouter using the <code>OpenAIServerModel</code> class:",he,P,$e,F,ve,W,Ye='xAI’s Grok models can be accessed through <a href="/docs/smolagents/main/en/reference/models#smolagents.LiteLLMModel">LiteLLMModel</a>.',Re,H,qe=`Some models (such as “grok-4” and “grok-3-mini”) don’t support the <code>stop</code> parameter, so you’ll need to use
<code>REMOVE_PARAMETER</code> to exclude it from API calls.`,ke,O,De="First, install the required dependencies:",Le,Z,Be,z,Ke='Then, <a href="https://console.x.ai/" rel="nofollow">get an xAI API key</a> and set it in your code:',Ae,Q,_e,X,et="Now, you can initialize Grok models using the <code>LiteLLMModel</code> class and remove the <code>stop</code> parameter if applicable:",Ve,N,Se,Y,Ee,D,xe;return c=new rt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/using_different_models.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/using_different_models.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/using_different_models.ipynb"}]}}),b=new K({props:{title:"Using different models",local:"using-different-models",headingTag:"h1"}}),y=new K({props:{title:"Available model types",local:"available-model-types",headingTag:"h2"}}),$=new K({props:{title:"Using Google Gemini Models",local:"using-google-gemini-models",headingTag:"h2"}}),k=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),B=new u({props:{code:"R0VNSU5JX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLUdFTUlOSS1BUEktS0VZJTNF",highlighted:"GEMINI_API_KEY = &lt;YOUR-GEMINI-API-KEY&gt;",wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlM0QlMjJnZW1pbmktMi4wLWZsYXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwR29vZ2xlJTIwR2VtaW5pJTIwT3BlbkFJLWNvbXBhdGlibGUlMjBBUEklMjBiYXNlJTIwVVJMJTBBJTIwJTIwJTIwJTIwYXBpX2Jhc2UlM0QlMjJodHRwcyUzQSUyRiUyRmdlbmVyYXRpdmVsYW5ndWFnZS5nb29nbGVhcGlzLmNvbSUyRnYxYmV0YSUyRm9wZW5haSUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RHRU1JTklfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    model_id=<span class="hljs-string">&quot;gemini-2.0-flash&quot;</span>,
    <span class="hljs-comment"># Google Gemini OpenAI-compatible API base URL</span>
    api_base=<span class="hljs-string">&quot;https://generativelanguage.googleapis.com/v1beta/openai/&quot;</span>,
    api_key=GEMINI_API_KEY,
)`,wrap:!1}}),V=new K({props:{title:"Using OpenRouter Models",local:"using-openrouter-models",headingTag:"h2"}}),x=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCb3BlbmFpJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[openai]&#x27;</span>',wrap:!1}}),j=new u({props:{code:"T1BFTlJPVVRFUl9BUElfS0VZJTIwJTNEJTIwJTNDWU9VUi1PUEVOUk9VVEVSLUFQSS1LRVklM0U=",highlighted:"OPENROUTER_API_KEY = &lt;YOUR-OPENROUTER-API-KEY&gt;",wrap:!1}}),P=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwdXNlJTIwYW55JTIwbW9kZWwlMjBJRCUyMGF2YWlsYWJsZSUyMG9uJTIwT3BlblJvdXRlciUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJTIyb3BlbmFpJTJGZ3B0LTRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3BlblJvdXRlciUyMEFQSSUyMGJhc2UlMjBVUkwlMEElMjAlMjAlMjAlMjBhcGlfYmFzZSUzRCUyMmh0dHBzJTNBJTJGJTJGb3BlbnJvdXRlci5haSUyRmFwaSUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRE9QRU5ST1VURVJfQVBJX0tFWSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel

model = OpenAIServerModel(
    <span class="hljs-comment"># You can use any model ID available on OpenRouter</span>
    model_id=<span class="hljs-string">&quot;openai/gpt-4o&quot;</span>,
    <span class="hljs-comment"># OpenRouter API base URL</span>
    api_base=<span class="hljs-string">&quot;https://openrouter.ai/api/v1&quot;</span>,
    api_key=OPENROUTER_API_KEY,
)`,wrap:!1}}),F=new K({props:{title:"Using xAI’s Grok Models",local:"using-xais-grok-models",headingTag:"h2"}}),Z=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlNUJsaXRlbGxtJTVE",highlighted:"pip install smolagents[litellm]",wrap:!1}}),Q=new u({props:{code:"WEFJX0FQSV9LRVklMjAlM0QlMjAlM0NZT1VSLVhBSS1BUEktS0VZJTNF",highlighted:"XAI_API_KEY = &lt;YOUR-XAI-API-KEY&gt;",wrap:!1}}),N=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBMaXRlTExNTW9kZWwlMkMlMjBSRU1PVkVfUEFSQU1FVEVSJTBBJTBBJTIzJTIwVXNpbmclMjBHcm9rLTQlMEFtb2RlbCUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RYQUlfQVBJX0tFWSUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0RSRU1PVkVfUEFSQU1FVEVSJTJDJTIwJTIwJTIzJTIwUmVtb3ZlJTIwc3RvcCUyMHBhcmFtZXRlciUyMGFzJTIwZ3Jvay00JTIwbW9kZWwlMjBkb2Vzbid0JTIwc3VwcG9ydCUyMGl0JTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjclMEEpJTBBJTBBJTIzJTIwT3IlMjB1c2luZyUyMEdyb2stMy1taW5pJTBBbW9kZWxfbWluaSUyMCUzRCUyMExpdGVMTE1Nb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMnhhaSUyRmdyb2stMy1taW5pJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRFhBSV9BUElfS0VZJTJDJTBBJTIwJTIwJTIwJTIwc3RvcCUzRFJFTU9WRV9QQVJBTUVURVIlMkMlMjAlMjAlMjMlMjBSZW1vdmUlMjBzdG9wJTIwcGFyYW1ldGVyJTIwYXMlMjBncm9rLTMtbWluaSUyMG1vZGVsJTIwZG9lc24ndCUyMHN1cHBvcnQlMjBpdCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDAwJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> LiteLLMModel, REMOVE_PARAMETER

<span class="hljs-comment"># Using Grok-4</span>
model = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-4&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-4 model doesn&#x27;t support it</span>
    temperature=<span class="hljs-number">0.7</span>
)

<span class="hljs-comment"># Or using Grok-3-mini</span>
model_mini = LiteLLMModel(
    model_id=<span class="hljs-string">&quot;xai/grok-3-mini&quot;</span>,
    api_key=XAI_API_KEY,
    stop=REMOVE_PARAMETER,  <span class="hljs-comment"># Remove stop parameter as grok-3-mini model doesn&#x27;t support it</span>
    max_tokens=<span class="hljs-number">1000</span>
)`,wrap:!1}}),Y=new dt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/using_different_models.md"}}),{c(){T=i("meta"),ee=n(),q=i("p"),te=n(),m(c.$$.fragment),le=n(),m(w.$$.fragment),se=n(),m(b.$$.fragment),ne=n(),J=i("p"),J.innerHTML=je,oe=n(),m(y.$$.fragment),ie=n(),U=i("p"),U.innerHTML=Ge,ae=n(),I=i("ol"),I.innerHTML=Pe,me=n(),h=i("p"),h.innerHTML=Fe,pe=n(),m($.$$.fragment),re=n(),v=i("p"),v.innerHTML=We,de=n(),R=i("p"),R.textContent=He,fe=n(),m(k.$$.fragment),Me=n(),L=i("p"),L.innerHTML=Oe,ge=n(),m(B.$$.fragment),Te=n(),A=i("p"),A.innerHTML=Ze,ue=n(),m(_.$$.fragment),ce=n(),m(V.$$.fragment),we=n(),S=i("p"),S.innerHTML=ze,be=n(),E=i("p"),E.textContent=Qe,Je=n(),m(x.$$.fragment),ye=n(),C=i("p"),C.innerHTML=Xe,Ue=n(),m(j.$$.fragment),Ie=n(),G=i("p"),G.innerHTML=Ne,he=n(),m(P.$$.fragment),$e=n(),m(F.$$.fragment),ve=n(),W=i("p"),W.innerHTML=Ye,Re=n(),H=i("p"),H.innerHTML=qe,ke=n(),O=i("p"),O.textContent=De,Le=n(),m(Z.$$.fragment),Be=n(),z=i("p"),z.innerHTML=Ke,Ae=n(),m(Q.$$.fragment),_e=n(),X=i("p"),X.innerHTML=et,Ve=n(),m(N.$$.fragment),Se=n(),m(Y.$$.fragment),Ee=n(),D=i("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(l),ee=o(e),q=a(e,"P",{}),tt(q).forEach(l),te=o(e),p(c.$$.fragment,e),le=o(e),p(w.$$.fragment,e),se=o(e),p(b.$$.fragment,e),ne=o(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-nqa3ku"&&(J.innerHTML=je),oe=o(e),p(y.$$.fragment,e),ie=o(e),U=a(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-z7j4in"&&(U.innerHTML=Ge),ae=o(e),I=a(e,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-1gtg7ax"&&(I.innerHTML=Pe),me=o(e),h=a(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-zqae9j"&&(h.innerHTML=Fe),pe=o(e),p($.$$.fragment,e),re=o(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ybt1yc"&&(v.innerHTML=We),de=o(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1f3oki6"&&(R.textContent=He),fe=o(e),p(k.$$.fragment,e),Me=o(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1scf5a3"&&(L.innerHTML=Oe),ge=o(e),p(B.$$.fragment,e),Te=o(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1a5n7np"&&(A.innerHTML=Ze),ue=o(e),p(_.$$.fragment,e),ce=o(e),p(V.$$.fragment,e),we=o(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1wgz0x9"&&(S.innerHTML=ze),be=o(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1f3oki6"&&(E.textContent=Qe),Je=o(e),p(x.$$.fragment,e),ye=o(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-co5fkh"&&(C.innerHTML=Xe),Ue=o(e),p(j.$$.fragment,e),Ie=o(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ibsz4t"&&(G.innerHTML=Ne),he=o(e),p(P.$$.fragment,e),$e=o(e),p(F.$$.fragment,e),ve=o(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1qlxq5o"&&(W.innerHTML=Ye),Re=o(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1iunuuy"&&(H.innerHTML=qe),ke=o(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1f3oki6"&&(O.textContent=De),Le=o(e),p(Z.$$.fragment,e),Be=o(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-180jkec"&&(z.innerHTML=Ke),Ae=o(e),p(Q.$$.fragment,e),_e=o(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ffid4g"&&(X.innerHTML=et),Ve=o(e),p(N.$$.fragment,e),Se=o(e),p(Y.$$.fragment,e),Ee=o(e),D=a(e,"P",{}),tt(D).forEach(l),this.h()},h(){lt(T,"name","hf:doc:metadata"),lt(T,"content",gt)},m(e,t){pt(document.head,T),s(e,ee,t),s(e,q,t),s(e,te,t),d(c,e,t),s(e,le,t),d(w,e,t),s(e,se,t),d(b,e,t),s(e,ne,t),s(e,J,t),s(e,oe,t),d(y,e,t),s(e,ie,t),s(e,U,t),s(e,ae,t),s(e,I,t),s(e,me,t),s(e,h,t),s(e,pe,t),d($,e,t),s(e,re,t),s(e,v,t),s(e,de,t),s(e,R,t),s(e,fe,t),d(k,e,t),s(e,Me,t),s(e,L,t),s(e,ge,t),d(B,e,t),s(e,Te,t),s(e,A,t),s(e,ue,t),d(_,e,t),s(e,ce,t),d(V,e,t),s(e,we,t),s(e,S,t),s(e,be,t),s(e,E,t),s(e,Je,t),d(x,e,t),s(e,ye,t),s(e,C,t),s(e,Ue,t),d(j,e,t),s(e,Ie,t),s(e,G,t),s(e,he,t),d(P,e,t),s(e,$e,t),d(F,e,t),s(e,ve,t),s(e,W,t),s(e,Re,t),s(e,H,t),s(e,ke,t),s(e,O,t),s(e,Le,t),d(Z,e,t),s(e,Be,t),s(e,z,t),s(e,Ae,t),d(Q,e,t),s(e,_e,t),s(e,X,t),s(e,Ve,t),d(N,e,t),s(e,Se,t),d(Y,e,t),s(e,Ee,t),s(e,D,t),xe=!0},p:nt,i(e){xe||(f(c.$$.fragment,e),f(w.$$.fragment,e),f(b.$$.fragment,e),f(y.$$.fragment,e),f($.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(_.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(j.$$.fragment,e),f(P.$$.fragment,e),f(F.$$.fragment,e),f(Z.$$.fragment,e),f(Q.$$.fragment,e),f(N.$$.fragment,e),f(Y.$$.fragment,e),xe=!0)},o(e){M(c.$$.fragment,e),M(w.$$.fragment,e),M(b.$$.fragment,e),M(y.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(_.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(j.$$.fragment,e),M(P.$$.fragment,e),M(F.$$.fragment,e),M(Z.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),xe=!1},d(e){e&&(l(ee),l(q),l(te),l(le),l(se),l(ne),l(J),l(oe),l(ie),l(U),l(ae),l(I),l(me),l(h),l(pe),l(re),l(v),l(de),l(R),l(fe),l(Me),l(L),l(ge),l(Te),l(A),l(ue),l(ce),l(we),l(S),l(be),l(E),l(Je),l(ye),l(C),l(Ue),l(Ie),l(G),l(he),l($e),l(ve),l(W),l(Re),l(H),l(ke),l(O),l(Le),l(Be),l(z),l(Ae),l(_e),l(X),l(Ve),l(Se),l(Ee),l(D)),l(T),g(c,e),g(w,e),g(b,e),g(y,e),g($,e),g(k,e),g(B,e),g(_,e),g(V,e),g(x,e),g(j,e),g(P,e),g(F,e),g(Z,e),g(Q,e),g(N,e),g(Y,e)}}}const gt='{"title":"Using different models","local":"using-different-models","sections":[{"title":"Available model types","local":"available-model-types","sections":[],"depth":2},{"title":"Using Google Gemini Models","local":"using-google-gemini-models","sections":[],"depth":2},{"title":"Using OpenRouter Models","local":"using-openrouter-models","sections":[],"depth":2},{"title":"Using xAI’s Grok Models","local":"using-xais-grok-models","sections":[],"depth":2}],"depth":1}';function Tt(Ce){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends it{constructor(T){super(),at(this,T,Tt,Mt,st,{})}}export{yt as component};
