import{s as zT,n as ET,o as HT}from"../chunks/scheduler.f9cad8c1.js";import{S as xT,i as _T,e,s as M,c as a,q as fT,h as $T,a as y,d as T,b as t,f as Zl,g as s,j as i,r as ST,k as KU,l as b,m as J,n as C,t as n,o as w,p as o}from"../chunks/index.6e06ef99.js";import{C as qT,H as p,E as LT}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.94149fd6.js";import{C as d}from"../chunks/CodeBlock.87c6fd31.js";import{D as PT}from"../chunks/DocNotebookDropdown.77f2c2c1.js";function KT(lT){let N,Wl,Ol,Al,g,vl,V,Yl,h,Xl,k,UT=`성공하는 에이전트와 실패하는 에이전트 사이에는 큰 차이가 있습니다.
성공하는 에이전트는 어떻게 만들 수 있을까요?
이 가이드에서 에이전트 구축의 핵심 원칙들을 소개하겠습니다.`,Dl,c,TT='<p>에이전트 구축이 처음이라면 먼저 <a href="../conceptual_guides/intro_agents">에이전트 소개</a>와 <a href="../guided_tour">안내서</a>를 읽어보세요.</p>',fl,R,Sl,F,JT="워크플로우에 LLM에게 어느 정도의 자율성을 부여하는 것은 오류가 발생할 위험이 있습니다.",zl,j,MT="잘 설계된 에이전트 시스템은 오류를 기록하고 다시 시도하는 기능을 통해 LLM이 자신의 실수를 교정할 수 있게 해줍니다. 그렇다고 해도 처음부터 LLM이 실수하지 않도록 워크플로우를 간단하게 만드는 것이 훨씬 효과적입니다.",El,u,tT=`<a href="../conceptual_guides/intro_agents">에이전트 소개</a>의 예시를 다시 살펴보겠습니다: 서핑 여행사 이용자들의 문의에 대응하는 봇입니다.
새로운 서핑 스팟에 대해 질문을 받을 때마다 에이전트가 “여행 거리 API”와 “날씨 API”에 각각 2번의 서로 다른 호출을 하도록 하는 대신, 두 API를 한 번에 호출하고 연결된 출력을 사용자에게 반환하는 함수인 “return_spot_information”이라는 하나의 통합된 도구를 만들 수 있습니다.`,Hl,m,eT="이렇게 하면 비용, 지연 시간, 오류 위험을 줄일 수 있습니다!",xl,B,yT="주요 지침은 다음과 같습니다: LLM 호출 횟수를 최대한 줄이세요.",_l,Q,iT="이것은 몇 가지 결론으로 이어집니다:",$l,G,aT="<li>가능하면 언제든지 두 개의 API 예시처럼 2개의 도구를 하나로 그룹화하세요.</li> <li>가능하면 언제든지 로직은 에이전트의 결정보다는 결정론적 함수로 처리해야 합니다.</li>",ql,O,Ll,r,sT="LLM은 쪽지를 통해서만 소통할 수 있는 밀폐된 방 안의 <em>똑똑한</em> 로봇이라고 생각하면 됩니다.",Pl,Z,CT="프롬프트에 명시하지 않으면 무슨 일이 일어났는지 전혀 알 수 없습니다.",Kl,W,nT=`그러니까 일단 작업을 아주 명확하게 정의하는 것부터 시작하세요!
에이전트는 LLM으로 작동하기 때문에, 작업을 설명하는 방식이 조금만 달라져도 결과가 완전히 바뀔 수 있습니다.`,lU,A,wT="그 다음엔 도구에서 에이전트로 정보가 잘 전달되도록 개선해야 합니다.",UU,v,oT="구체적으로는 이렇게 하세요:",TU,Y,dT=`<li>각 도구는 LLM에게 도움이 될 만한 정보를 모두 기록해야 합니다.(도구의 <code>forward</code> 메서드 안에서 <code>print</code>문을 쓰기만 하면 됩니다.)
<ul><li>특히 도구 실행 오류에 대한 자세한 정보를 기록하면 큰 도움이 됩니다!</li></ul></li>`,JU,X,IT="예를 들어 위치와 날짜-시간을 받아서 날씨 데이터를 가져오는 도구를 보겠습니다:",MU,D,NT="먼저 좋지 않은 버전입니다:",tU,f,eU,S,pT="문제점은 무엇일까요?",yU,z,cT="<li><code>date_time</code>에 사용해야 하는 형식에 대한 정확한 설명이 없습니다.</li> <li>위치를 어떻게 지정해야 하는지에 대한 세부 정보가 없습니다.</li> <li>위치가 적절한 형식이 아니거나 <code>date_time</code>이 제대로 형식화되지 않은 경우와 같은 실패 사례를 명시적으로 기록할 수 있는 로깅 메커니즘이 없습니다.</li> <li>출력 형식을 이해하기 어렵습니다.</li>",iU,E,bT="도구 호출이 실패하면 메모리에 로깅된 오류 추적이 LLM이 도구를 역설계하여 오류를 수정하는 데 도움이 될 수 있습니다. 하지만 왜 그렇게 많은 무거운 작업을 맡겨야 할까요?",aU,H,gT="이 도구를 구축하는 더 나은 방법은 다음과 같습니다:",sU,x,CU,_,VT="LLM의 부담을 덜어주려면 이런 질문을 해보세요: “만약 내가 아무것도 모르는 상태에서 이 도구를 처음 사용한다면, 실수했을 때 스스로 고치기가 얼마나 쉬울까?”",nU,$,wU,q,hT="작업을 설명하는 단순한 문자열 외에 에이전트에 추가 객체를 전달하려면 <code>additional_args</code> 매개변수를 사용하여 모든 유형의 객체를 전달할 수 있습니다:",oU,L,dU,P,kT="예를 들어, <code>additional_args</code> 매개변수를 통해 에이전트가 활용할 수 있도록 원하는 이미지나 문자열을 전달할 수 있습니다.",IU,K,NU,ll,pU,Ul,RT=`에이전트 워크플로우에서 발생하는 오류 중 일부는 실제 오류이고, 다른 일부는 LLM 엔진이 제대로 추론하지 못한 탓입니다.
예를 들어, 자동차 그림을 만들어 달라고 요청한 <code>CodeAgent</code>에 대한 다음 추적을 고려해보세요:`,cU,Tl,bU,Jl,FT=`사용자는 이미지가 반환되는 대신 경로가 반환되는 것을 보게 됩니다.
시스템의 버그처럼 보일 수 있지만, 실제로는 에이전트 시스템이 오류를 일으킨 것이 아닙니다: 단지 LLM이 이미지 출력을 변수에 저장하지 않는 실수를 했을 뿐입니다.
따라서 이미지를 저장하면서 로깅된 경로를 활용하는 것 외에는 이미지에 다시 접근할 수 없으므로 이미지 대신 경로를 반환합니다.`,gU,Ml,jT="따라서 에이전트를 디버깅하는 첫 번째 단계는 “더 강력한 LLM을 사용하는 것”입니다. <code>Qwen2/5-72B-Instruct</code>와 같은 대안은 그런 실수를 하지 않았을 것입니다.",VU,tl,hU,el,uT="더 자세하게 안내해준다면 성능이 낮은 모델도 충분히 사용할 수 있습니다.",kU,yl,mT="모델의 관점에서 생각해보세요: 내가 모델이 되어서 이 작업을 해결해야 한다면, 지금 주어진 정보(시스템 프롬프트 + 작업 설명 + 도구 설명)만으로도 충분할까요?",RU,il,BT="더 구체적인 안내가 필요할까요?",FU,al,QT="<li>지침이 항상 에이전트에게 주어져야 하는 경우(일반적으로 시스템 프롬프트가 작동한다고 이해하는 것처럼): 에이전트 초기화 시 <code>instructions</code> 매개변수 아래에 문자열로 전달할 수 있습니다.</li> <li>해결할 특정 작업에 관한 것이라면: 이 모든 세부 사항을 작업에 추가하세요. 작업은 수십 페이지처럼 매우 길 수 있습니다.</li> <li>특정 도구 사용 방법에 관한 것이라면: 해당 도구의 <code>description</code> 속성에 포함시키세요.</li>",jU,sl,uU,Cl,GT="위의 방법들로도 부족하다면 에이전트의 프롬프트 템플릿을 직접 수정할 수 있습니다.",mU,nl,OT="작동 원리를 살펴보겠습니다. [CodeAgent]의 기본 프롬프트 템플릿을 예로 들어보겠습니다(제로샷 예제는 생략하고 간단히 정리했습니다).",BU,wl,QU,ol,rT="Here is what you get:",GU,dl,OU,Il,ZT="보시다시피 <code>&quot;{{ tool.description }}&quot;</code>와 같은 플레이스홀더들이 있습니다. 이것들은 에이전트를 초기화할 때 도구나 관리 에이전트에 대한 설명을 자동으로 넣어주는 역할을 합니다.",rU,Nl,WT="따라서 <code>system_prompt</code> 매개변수에 커스텀 프롬프트를 넣어서 기본 시스템 프롬프트 템플릿을 덮어쓸 수 있습니다. 새로운 시스템 프롬프트에는 이런 플레이스홀더들을 포함할 수 있습니다:",ZU,I,ml,xU,pl,_U,Bl,$U,cl,qU,Ql,AT="<code>CodeAgent</code>에만 해당하며, 승인된 import 목록을 삽입하려면: <code>&quot;{{authorized_imports}}&quot;</code>",WU,bl,vT="그런 다음 다음과 같이 시스템 프롬프트를 변경할 수 있습니다:",AU,gl,vU,Vl,YT='이는 <a href="/docs/smolagents/main/ko/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>에서도 작동합니다.',YU,hl,XT="하지만 일반적으로 다음과 같이 에이전트 초기화 시 <code>instructions</code> 매개변수를 전달하는 것이 더 간단합니다:",XU,kl,DU,Rl,fU,Fl,DT="일반적인 작업 단계들 중간중간에 에이전트가 추가로 계획을 세우는 단계를 넣을 수 있습니다. 이때는 도구를 사용하지 않고, LLM이 현재까지 파악한 정보를 정리하고 그 정보를 토대로 앞으로의 계획을 다시 점검하게 됩니다.",SU,jl,zU,ul,EU,rl,HU;return g=new qT({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),V=new PT({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/building_good_agents.ipynb"}]}}),h=new p({props:{title:"좋은 에이전트 구축하기",local:"building-good-agents",headingTag:"h1"}}),R=new p({props:{title:"최고의 에이전트 시스템은 가장 단순합니다: 워크플로우를 최대한 단순하게 만드세요",local:"the-best-agentic-systems-are-the-simplest:-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),O=new p({props:{title:"LLM 엔진으로의 정보 흐름을 개선하세요",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),f=new d({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUVCJThEJTk0JUVCJUFGJUI4JTIwJUVEJTk1JUE4JUVDJTg4JTk4JTJDJTIwJTVCJUVDJTg0JUFEJUVDJTk0JUE4JTIwJUVDJTk4JUE4JUVCJThGJTg0JTJDJTIwMC0xJTIwJUVDJUIyJTk5JUVCJThGJTg0JUVDJTlEJTk4JTIwJUVCJUI5JTg0JTIwJUVDJTk4JUFDJTIwJUVEJTk5JTk1JUVCJUE1JUEwJTJDJTIwJUVCJUFGJUI4JUVEJTg0JUIwJTIwJUVCJThCJUE4JUVDJTlDJTg0JTIwJUVEJThDJThDJUVCJThGJTg0JTIwJUVCJTg2JTkyJUVDJTlEJUI0JTVEJTIwJUVCJUE2JUFDJUVDJThBJUE0JUVEJThBJUI4JUVCJUE1JUJDJTIwJUVCJUIwJTk4JUVEJTk5JTk4JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRUIlOEQlOTQlRUIlQUYlQjglMjAlRUMlQTIlOEMlRUQlOTElOUMlRUIlQTUlQkMlMjAlRUIlQjAlOTglRUQlOTklOTglMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIzLjMlMkMlMjAtNDIuMCU1RCUwQSUwQSU0MHRvb2wlMEFkZWYlMjBnZXRfd2VhdGhlcl9hcGkobG9jYXRpb24lM0ElMjBzdHIlMkMlMjBkYXRlX3RpbWUlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFJldHVybnMlMjB0aGUlMjB3ZWF0aGVyJTIwcmVwb3J0LiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHBsYWNlJTIwdGhhdCUyMHlvdSUyMHdhbnQlMjB0aGUlMjB3ZWF0aGVyJTIwZm9yLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGVfdGltZSUzQSUyMHRoZSUyMGRhdGUlMjBhbmQlMjB0aW1lJTIwZm9yJTIwd2hpY2glMjB5b3UlMjB3YW50JTIwdGhlJTIwcmVwb3J0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGxvbiUyQyUyMGxhdCUyMCUzRCUyMGNvbnZlcnRfbG9jYXRpb25fdG9fY29vcmRpbmF0ZXMobG9jYXRpb24pJTBBJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTIwJTNEJTIwZGF0ZXRpbWUuc3RycHRpbWUoZGF0ZV90aW1lKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHN0cihnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoKGxvbiUyQyUyMGxhdCklMkMlMjBkYXRlX3RpbWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># 더미 함수, [섭씨 온도, 0-1 척도의 비 올 확률, 미터 단위 파도 높이] 리스트를 반환</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># 더미 좌표를 반환</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),x=new d({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),$=new p({props:{title:"에이전트에 더 많은 매개변수 제공",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),L=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),K=new p({props:{title:"에이전트 디버깅 방법",local:"how-to-debug-your-agent",headingTag:"h2"}}),ll=new p({props:{title:"1. 더 강력한 LLM 사용",local:"use-a-stronger-llm",headingTag:"h3"}}),Tl=new d({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),tl=new p({props:{title:"2. 더 많은 정보나 구체적인 지침 제공",local:"provide-more-information-or-specific-instructions",headingTag:"h3"}}),sl=new p({props:{title:"3. 프롬프트 템플릿 변경 (일반적으로 권장되지 않음)",local:"change-the-prompt-templates-(generally-not-advised)",headingTag:"h3"}}),wl=new d({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),dl=new d({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of Thought, Code, and Observation sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the Code sequence you should write the code in simple Python. The code sequence must be opened with &#x27;{{code_block_opening_tag}}&#x27;, and closed with &#x27;{{code_block_closing_tag}}&#x27;.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
{{code_block_opening_tag}}
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
{{code_block_closing_tag}}
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
{{code_block_opening_tag}}
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
{{code_block_closing_tag}}

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
{{code_block_opening_tag}}
result = 5 + 3 + 1294.678
final_answer(result)
{{code_block_closing_tag}}

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
{{code_block_opening_tag}}
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
{{code_block_closing_tag}}

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
{{code_block_opening_tag}}
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
{{code_block_closing_tag}}
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
{{code_block_opening_tag}}
final_answer(&quot;diminished&quot;)
{{code_block_closing_tag}}

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`web_search\` to get the population of both cities.
{{code_block_opening_tag}}
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, web_search(f&quot;{city} population&quot;)
{{code_block_closing_tag}}
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
{{code_block_opening_tag}}
final_answer(&quot;Shanghai&quot;)
{{code_block_closing_tag}}

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wikipedia_search\` to get the age of the pope, and confirm that with a web search.
{{code_block_opening_tag}}
pope_age_wiki = wikipedia_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
{{code_block_closing_tag}}
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
{{code_block_opening_tag}}
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
{{code_block_closing_tag}}

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools, behaving like regular python functions:
{{code_block_opening_tag}}
{%- for tool in tools.values() %}
{{ tool.to_code_prompt() }}
{% endfor %}
{{code_block_closing_tag}}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{{code_block_opening_tag}}
{%- for agent in managed_agents.values() %}
def {{ agent.name }}(task: str, additional_args: dict[str, Any]) -&gt; str:
    &quot;&quot;&quot;{{ agent.description }}

    Args:
        task: Long detailed description of the task.
        additional_args: Dictionary of extra inputs to pass to the managed agent, e.g. images, dataframes, or any other contextual data it may need.
    &quot;&quot;&quot;
{% endfor %}
{{code_block_closing_tag}}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;{{code_block_opening_tag}}&#x27; sequence ending with &#x27;{{code_block_closing_tag}}&#x27;, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wikipedia_search({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wikipedia_search(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. For tools WITHOUT JSON output schema: Take care to not chain too many sequential tool calls in the same code block, as their output format is unpredictable. For instance, a call to wikipedia_search without a JSON output schema has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. For tools WITH JSON output schema: You can confidently chain multiple tool calls and directly access structured output fields in the same code block! When a tool has a JSON output schema, you know exactly what fields and data types to expect, allowing you to write robust code that directly accesses the structured response (e.g., result[&#x27;field_name&#x27;]) without needing intermediate print() statements.
6. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
7. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
8. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
9. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
10. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
11. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

{%- if custom_instructions %}
{{custom_instructions}}
{%- endif %}

Now Begin!`,wrap:!1}}),pl=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),cl=new d({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),gl=new d({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),kl=new d({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTJDJTIwaW5zdHJ1Y3Rpb25zJTNEJTIyQWx3YXlzJTIwdGFsayUyMGxpa2UlMjBhJTIwNSUyMHllYXIlMjBvbGQuJTIyKQ==",highlighted:'agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), instructions=<span class="hljs-string">&quot;Always talk like a 5 year old.&quot;</span>)',wrap:!1}}),Rl=new p({props:{title:"4. 추가 계획",local:"extra-planning",headingTag:"h3"}}),jl=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCUyQyUyMGltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool, image_generation_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),ul=new LT({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/ko/tutorials/building_good_agents.md"}}),{c(){N=e("meta"),Wl=M(),Ol=e("p"),Al=M(),a(g.$$.fragment),vl=M(),a(V.$$.fragment),Yl=M(),a(h.$$.fragment),Xl=M(),k=e("p"),k.textContent=UT,Dl=M(),c=e("blockquote"),c.innerHTML=TT,fl=M(),a(R.$$.fragment),Sl=M(),F=e("p"),F.textContent=JT,zl=M(),j=e("p"),j.textContent=MT,El=M(),u=e("p"),u.innerHTML=tT,Hl=M(),m=e("p"),m.textContent=eT,xl=M(),B=e("p"),B.textContent=yT,_l=M(),Q=e("p"),Q.textContent=iT,$l=M(),G=e("ul"),G.innerHTML=aT,ql=M(),a(O.$$.fragment),Ll=M(),r=e("p"),r.innerHTML=sT,Pl=M(),Z=e("p"),Z.textContent=CT,Kl=M(),W=e("p"),W.textContent=nT,lU=M(),A=e("p"),A.textContent=wT,UU=M(),v=e("p"),v.textContent=oT,TU=M(),Y=e("ul"),Y.innerHTML=dT,JU=M(),X=e("p"),X.textContent=IT,MU=M(),D=e("p"),D.textContent=NT,tU=M(),a(f.$$.fragment),eU=M(),S=e("p"),S.textContent=pT,yU=M(),z=e("ul"),z.innerHTML=cT,iU=M(),E=e("p"),E.textContent=bT,aU=M(),H=e("p"),H.textContent=gT,sU=M(),a(x.$$.fragment),CU=M(),_=e("p"),_.textContent=VT,nU=M(),a($.$$.fragment),wU=M(),q=e("p"),q.innerHTML=hT,oU=M(),a(L.$$.fragment),dU=M(),P=e("p"),P.innerHTML=kT,IU=M(),a(K.$$.fragment),NU=M(),a(ll.$$.fragment),pU=M(),Ul=e("p"),Ul.innerHTML=RT,cU=M(),a(Tl.$$.fragment),bU=M(),Jl=e("p"),Jl.textContent=FT,gU=M(),Ml=e("p"),Ml.innerHTML=jT,VU=M(),a(tl.$$.fragment),hU=M(),el=e("p"),el.textContent=uT,kU=M(),yl=e("p"),yl.textContent=mT,RU=M(),il=e("p"),il.textContent=BT,FU=M(),al=e("ul"),al.innerHTML=QT,jU=M(),a(sl.$$.fragment),uU=M(),Cl=e("p"),Cl.textContent=GT,mU=M(),nl=e("p"),nl.textContent=OT,BU=M(),a(wl.$$.fragment),QU=M(),ol=e("p"),ol.textContent=rT,GU=M(),a(dl.$$.fragment),OU=M(),Il=e("p"),Il.innerHTML=ZT,rU=M(),Nl=e("p"),Nl.innerHTML=WT,ZU=M(),I=e("ul"),ml=e("li"),xU=fT(`도구 설명을 삽입하려면:

	`),a(pl.$$.fragment),_U=M(),Bl=e("li"),$U=fT(`관리되는 에이전트가 있는 경우 해당 설명을 삽입하려면:

	`),a(cl.$$.fragment),qU=M(),Ql=e("li"),Ql.innerHTML=AT,WU=M(),bl=e("p"),bl.textContent=vT,AU=M(),a(gl.$$.fragment),vU=M(),Vl=e("p"),Vl.innerHTML=YT,YU=M(),hl=e("p"),hl.innerHTML=XT,XU=M(),a(kl.$$.fragment),DU=M(),a(Rl.$$.fragment),fU=M(),Fl=e("p"),Fl.textContent=DT,SU=M(),a(jl.$$.fragment),zU=M(),a(ul.$$.fragment),EU=M(),rl=e("p"),this.h()},l(l){const U=$T("svelte-u9bgzb",document.head);N=y(U,"META",{name:!0,content:!0}),U.forEach(T),Wl=t(l),Ol=y(l,"P",{}),Zl(Ol).forEach(T),Al=t(l),s(g.$$.fragment,l),vl=t(l),s(V.$$.fragment,l),Yl=t(l),s(h.$$.fragment,l),Xl=t(l),k=y(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-15hjohz"&&(k.textContent=UT),Dl=t(l),c=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(c)!=="svelte-nbyvb0"&&(c.innerHTML=TT),fl=t(l),s(R.$$.fragment,l),Sl=t(l),F=y(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-109u08a"&&(F.textContent=JT),zl=t(l),j=y(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1fryr2e"&&(j.textContent=MT),El=t(l),u=y(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-x0bugw"&&(u.innerHTML=tT),Hl=t(l),m=y(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-4avckm"&&(m.textContent=eT),xl=t(l),B=y(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1uilf4u"&&(B.textContent=yT),_l=t(l),Q=y(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-t6n5xj"&&(Q.textContent=iT),$l=t(l),G=y(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-40glt0"&&(G.innerHTML=aT),ql=t(l),s(O.$$.fragment,l),Ll=t(l),r=y(l,"P",{"data-svelte-h":!0}),i(r)!=="svelte-k1phh6"&&(r.innerHTML=sT),Pl=t(l),Z=y(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1oupjpg"&&(Z.textContent=CT),Kl=t(l),W=y(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1sk7dc3"&&(W.textContent=nT),lU=t(l),A=y(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-f7ao35"&&(A.textContent=wT),UU=t(l),v=y(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1p0puh0"&&(v.textContent=oT),TU=t(l),Y=y(l,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-135pw66"&&(Y.innerHTML=dT),JU=t(l),X=y(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-z7kkzl"&&(X.textContent=IT),MU=t(l),D=y(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1414oxm"&&(D.textContent=NT),tU=t(l),s(f.$$.fragment,l),eU=t(l),S=y(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1oxdypg"&&(S.textContent=pT),yU=t(l),z=y(l,"UL",{"data-svelte-h":!0}),i(z)!=="svelte-h78796"&&(z.innerHTML=cT),iU=t(l),E=y(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-i6b4f"&&(E.textContent=bT),aU=t(l),H=y(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1owhurf"&&(H.textContent=gT),sU=t(l),s(x.$$.fragment,l),CU=t(l),_=y(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1mbzn9z"&&(_.textContent=VT),nU=t(l),s($.$$.fragment,l),wU=t(l),q=y(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1o6f9c"&&(q.innerHTML=hT),oU=t(l),s(L.$$.fragment,l),dU=t(l),P=y(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-zh66ny"&&(P.innerHTML=kT),IU=t(l),s(K.$$.fragment,l),NU=t(l),s(ll.$$.fragment,l),pU=t(l),Ul=y(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-16eywem"&&(Ul.innerHTML=RT),cU=t(l),s(Tl.$$.fragment,l),bU=t(l),Jl=y(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-1qj7c3s"&&(Jl.textContent=FT),gU=t(l),Ml=y(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-njfepl"&&(Ml.innerHTML=jT),VU=t(l),s(tl.$$.fragment,l),hU=t(l),el=y(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1vb1r37"&&(el.textContent=uT),kU=t(l),yl=y(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-7cvb86"&&(yl.textContent=mT),RU=t(l),il=y(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-145agf6"&&(il.textContent=BT),FU=t(l),al=y(l,"UL",{"data-svelte-h":!0}),i(al)!=="svelte-14ox1yu"&&(al.innerHTML=QT),jU=t(l),s(sl.$$.fragment,l),uU=t(l),Cl=y(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-2nsn4w"&&(Cl.textContent=GT),mU=t(l),nl=y(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-f1mu0l"&&(nl.textContent=OT),BU=t(l),s(wl.$$.fragment,l),QU=t(l),ol=y(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-174l3zr"&&(ol.textContent=rT),GU=t(l),s(dl.$$.fragment,l),OU=t(l),Il=y(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-15eney5"&&(Il.innerHTML=ZT),rU=t(l),Nl=y(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1sjap49"&&(Nl.innerHTML=WT),ZU=t(l),I=y(l,"UL",{});var Gl=Zl(I);ml=y(Gl,"LI",{});var LU=Zl(ml);xU=ST(LU,`도구 설명을 삽입하려면:

	`),s(pl.$$.fragment,LU),LU.forEach(T),_U=t(Gl),Bl=y(Gl,"LI",{});var PU=Zl(Bl);$U=ST(PU,`관리되는 에이전트가 있는 경우 해당 설명을 삽입하려면:

	`),s(cl.$$.fragment,PU),PU.forEach(T),qU=t(Gl),Ql=y(Gl,"LI",{"data-svelte-h":!0}),i(Ql)!=="svelte-gt7nt7"&&(Ql.innerHTML=AT),Gl.forEach(T),WU=t(l),bl=y(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1ap4q4p"&&(bl.textContent=vT),AU=t(l),s(gl.$$.fragment,l),vU=t(l),Vl=y(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-7frurq"&&(Vl.innerHTML=YT),YU=t(l),hl=y(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-1nv2b58"&&(hl.innerHTML=XT),XU=t(l),s(kl.$$.fragment,l),DU=t(l),s(Rl.$$.fragment,l),fU=t(l),Fl=y(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-99er4s"&&(Fl.textContent=DT),SU=t(l),s(jl.$$.fragment,l),zU=t(l),s(ul.$$.fragment,l),EU=t(l),rl=y(l,"P",{}),Zl(rl).forEach(T),this.h()},h(){KU(N,"name","hf:doc:metadata"),KU(N,"content",lJ),KU(c,"class","tip")},m(l,U){b(document.head,N),J(l,Wl,U),J(l,Ol,U),J(l,Al,U),C(g,l,U),J(l,vl,U),C(V,l,U),J(l,Yl,U),C(h,l,U),J(l,Xl,U),J(l,k,U),J(l,Dl,U),J(l,c,U),J(l,fl,U),C(R,l,U),J(l,Sl,U),J(l,F,U),J(l,zl,U),J(l,j,U),J(l,El,U),J(l,u,U),J(l,Hl,U),J(l,m,U),J(l,xl,U),J(l,B,U),J(l,_l,U),J(l,Q,U),J(l,$l,U),J(l,G,U),J(l,ql,U),C(O,l,U),J(l,Ll,U),J(l,r,U),J(l,Pl,U),J(l,Z,U),J(l,Kl,U),J(l,W,U),J(l,lU,U),J(l,A,U),J(l,UU,U),J(l,v,U),J(l,TU,U),J(l,Y,U),J(l,JU,U),J(l,X,U),J(l,MU,U),J(l,D,U),J(l,tU,U),C(f,l,U),J(l,eU,U),J(l,S,U),J(l,yU,U),J(l,z,U),J(l,iU,U),J(l,E,U),J(l,aU,U),J(l,H,U),J(l,sU,U),C(x,l,U),J(l,CU,U),J(l,_,U),J(l,nU,U),C($,l,U),J(l,wU,U),J(l,q,U),J(l,oU,U),C(L,l,U),J(l,dU,U),J(l,P,U),J(l,IU,U),C(K,l,U),J(l,NU,U),C(ll,l,U),J(l,pU,U),J(l,Ul,U),J(l,cU,U),C(Tl,l,U),J(l,bU,U),J(l,Jl,U),J(l,gU,U),J(l,Ml,U),J(l,VU,U),C(tl,l,U),J(l,hU,U),J(l,el,U),J(l,kU,U),J(l,yl,U),J(l,RU,U),J(l,il,U),J(l,FU,U),J(l,al,U),J(l,jU,U),C(sl,l,U),J(l,uU,U),J(l,Cl,U),J(l,mU,U),J(l,nl,U),J(l,BU,U),C(wl,l,U),J(l,QU,U),J(l,ol,U),J(l,GU,U),C(dl,l,U),J(l,OU,U),J(l,Il,U),J(l,rU,U),J(l,Nl,U),J(l,ZU,U),J(l,I,U),b(I,ml),b(ml,xU),C(pl,ml,null),b(I,_U),b(I,Bl),b(Bl,$U),C(cl,Bl,null),b(I,qU),b(I,Ql),J(l,WU,U),J(l,bl,U),J(l,AU,U),C(gl,l,U),J(l,vU,U),J(l,Vl,U),J(l,YU,U),J(l,hl,U),J(l,XU,U),C(kl,l,U),J(l,DU,U),C(Rl,l,U),J(l,fU,U),J(l,Fl,U),J(l,SU,U),C(jl,l,U),J(l,zU,U),C(ul,l,U),J(l,EU,U),J(l,rl,U),HU=!0},p:ET,i(l){HU||(n(g.$$.fragment,l),n(V.$$.fragment,l),n(h.$$.fragment,l),n(R.$$.fragment,l),n(O.$$.fragment,l),n(f.$$.fragment,l),n(x.$$.fragment,l),n($.$$.fragment,l),n(L.$$.fragment,l),n(K.$$.fragment,l),n(ll.$$.fragment,l),n(Tl.$$.fragment,l),n(tl.$$.fragment,l),n(sl.$$.fragment,l),n(wl.$$.fragment,l),n(dl.$$.fragment,l),n(pl.$$.fragment,l),n(cl.$$.fragment,l),n(gl.$$.fragment,l),n(kl.$$.fragment,l),n(Rl.$$.fragment,l),n(jl.$$.fragment,l),n(ul.$$.fragment,l),HU=!0)},o(l){w(g.$$.fragment,l),w(V.$$.fragment,l),w(h.$$.fragment,l),w(R.$$.fragment,l),w(O.$$.fragment,l),w(f.$$.fragment,l),w(x.$$.fragment,l),w($.$$.fragment,l),w(L.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(Tl.$$.fragment,l),w(tl.$$.fragment,l),w(sl.$$.fragment,l),w(wl.$$.fragment,l),w(dl.$$.fragment,l),w(pl.$$.fragment,l),w(cl.$$.fragment,l),w(gl.$$.fragment,l),w(kl.$$.fragment,l),w(Rl.$$.fragment,l),w(jl.$$.fragment,l),w(ul.$$.fragment,l),HU=!1},d(l){l&&(T(Wl),T(Ol),T(Al),T(vl),T(Yl),T(Xl),T(k),T(Dl),T(c),T(fl),T(Sl),T(F),T(zl),T(j),T(El),T(u),T(Hl),T(m),T(xl),T(B),T(_l),T(Q),T($l),T(G),T(ql),T(Ll),T(r),T(Pl),T(Z),T(Kl),T(W),T(lU),T(A),T(UU),T(v),T(TU),T(Y),T(JU),T(X),T(MU),T(D),T(tU),T(eU),T(S),T(yU),T(z),T(iU),T(E),T(aU),T(H),T(sU),T(CU),T(_),T(nU),T(wU),T(q),T(oU),T(dU),T(P),T(IU),T(NU),T(pU),T(Ul),T(cU),T(bU),T(Jl),T(gU),T(Ml),T(VU),T(hU),T(el),T(kU),T(yl),T(RU),T(il),T(FU),T(al),T(jU),T(uU),T(Cl),T(mU),T(nl),T(BU),T(QU),T(ol),T(GU),T(OU),T(Il),T(rU),T(Nl),T(ZU),T(I),T(WU),T(bl),T(AU),T(vU),T(Vl),T(YU),T(hl),T(XU),T(DU),T(fU),T(Fl),T(SU),T(zU),T(EU),T(rl)),T(N),o(g,l),o(V,l),o(h,l),o(R,l),o(O,l),o(f,l),o(x,l),o($,l),o(L,l),o(K,l),o(ll,l),o(Tl,l),o(tl,l),o(sl,l),o(wl,l),o(dl,l),o(pl),o(cl),o(gl,l),o(kl,l),o(Rl,l),o(jl,l),o(ul,l)}}}const lJ='{"title":"좋은 에이전트 구축하기","local":"building-good-agents","sections":[{"title":"최고의 에이전트 시스템은 가장 단순합니다: 워크플로우를 최대한 단순하게 만드세요","local":"the-best-agentic-systems-are-the-simplest:-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"LLM 엔진으로의 정보 흐름을 개선하세요","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"에이전트에 더 많은 매개변수 제공","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"에이전트 디버깅 방법","local":"how-to-debug-your-agent","sections":[{"title":"1. 더 강력한 LLM 사용","local":"use-a-stronger-llm","sections":[],"depth":3},{"title":"2. 더 많은 정보나 구체적인 지침 제공","local":"provide-more-information-or-specific-instructions","sections":[],"depth":3},{"title":"3. 프롬프트 템플릿 변경 (일반적으로 권장되지 않음)","local":"change-the-prompt-templates-(generally-not-advised)","sections":[],"depth":3},{"title":"4. 추가 계획","local":"extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function UJ(lT){return HT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yJ extends xT{constructor(N){super(),_T(this,N,UJ,KT,zT,{})}}export{yJ as component};
