import{s as ws,n as Js,o as os}from"../chunks/scheduler.00b97157.js";import{S as is,i as js,e as a,s as M,c as U,h as Ts,a as y,d as e,b as n,f as ps,g as w,j as p,k as Us,l as Cs,m as t,n as J,t as o,o as i,p as j}from"../chunks/index.a7c1a7a1.js";import{C as rs,H as xl,E as cs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f42c21e2.js";import{C as T}from"../chunks/CodeBlock.c713f000.js";import{D as Is}from"../chunks/DocNotebookDropdown.be7b60e3.js";function ms(Hl){let C,sl,O,el,r,tl,c,Ml,I,nl,m,Rl="此notebook将构建一个 <strong>multi-agent 网络浏览器：一个有多个代理协作，使用网络进行搜索解决问题的代理系统</strong>",al,d,Xl="<code>ManagedAgent</code> 对象将封装这些管理网络搜索的agent，形成一个简单的层次结构：",yl,u,pl,h,Ll="我们来一起构建这个系统。运行下列代码以安装依赖包：",Ul,b,wl,g,Nl="我们需要登录Hugging Face Hub以调用HF的Inference API：",Jl,f,ol,B,Yl=`⚡️ HF的Inference API 可以快速轻松地运行任何开源模型，因此我们的agent将使用HF的Inference API
中的<code>InferenceClientModel</code>类来调用
<a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>模型。`,il,A,zl='<em>Note:</em> 基于多参数和部署模型的 Inference API 可能在没有预先通知的情况下更新或替换模型。了解更多信息，请参阅<a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">这里</a>。',jl,Z,Tl,G,Cl,k,Fl=`虽然我们可以使用已经存在的
<code>WebSearchTool</code>
工具作为谷歌搜索的平替进行网页浏览，然后我们也需要能够查看<code>WebSearchTool</code>找到的页面。为此，我
们可以直接导入库的内置
<code>VisitWebpageTool</code>。但是我们将重新构建它以了解其工作原理。`,rl,S,ql="我们将使用<code>markdownify</code> 来从头构建我们的<code>VisitWebpageTool</code>工具。",cl,W,Il,v,Dl="现在我们初始化这个工具并测试它！",ml,V,dl,$,ul,E,Pl="现在我们有了所有工具<code>search</code>和<code>visit_webpage</code>，我们可以使用它们来创建web agent。",hl,Q,Kl="我们该选取什么样的配置来构建这个agent呢？",bl,_,Ol="<li>网页浏览是一个单线程任务，不需要并行工具调用，因此JSON工具调用对于这个任务非常有效。因此我们选择<code>ToolCallingAgent</code>。</li> <li>有时候网页搜索需要探索许多页面才能找到正确答案，所以我们更喜欢将 <code>max_steps</code> 增加到10。</li>",gl,x,fl,H,ls="请注意，我们为这个代理赋予了 name（名称）和 description（描述）属性，这些是必需属性，以便让管理代理能够调用此代理。",Bl,R,ss="然后，我们创建一个管理代理，在初始化时，将受管代理作为 managed_agents 参数传递给它。",Al,X,es="由于这个代理的任务是进行规划和思考，高级推理能力会很有帮助，因此 CodeAgent（代码代理）将是最佳选择。",Zl,L,ts="此外，我们要提出一个涉及当前年份并需要进行额外数据计算的问题：所以让我们添加 additional_authorized_imports=[“time”, “numpy”, “pandas”]，以防代理需要用到这些包。",Gl,N,kl,Y,Ms="可以了！现在让我们运行我们的系统！我们选择一个需要一些计算和研究的问题：",Sl,z,Wl,F,ns="我们用这个report 来回答这个问题：",vl,q,Vl,D,as='如果<a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a>持续成立的话，我们需要一些庞大的动力配置。我们的agent成功地协作解决了这个任务！✅',$l,P,ys="💡 你可以轻松地将这个编排扩展到更多的agent：一个执行代码，一个进行网页搜索，一个处理文件加载⋯⋯",El,K,Ql,ll,_l;return r=new rs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new Is({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/multiagents.ipynb"}]}}),I=new xl({props:{title:"编排 multi-agent 系统 🤖🤝🤖",local:"编排-multi-agent-系统-",headingTag:"h1"}}),u=new T({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),b=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjAnc21vbGFnZW50cyU1QnRvb2xraXQlNUQnJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install <span class="hljs-symbol">&#x27;smolagents</span>[toolkit]&#x27; <span class="hljs-comment">--upgrade -q</span>',wrap:!1}}),f=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> <span class="hljs-keyword">login</span>

<span class="hljs-keyword">login</span>()`,wrap:!1}}),Z=new T({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>',wrap:!1}}),G=new xl({props:{title:"🔍 创建网络搜索工具",local:"-创建网络搜索工具",headingTag:"h2"}}),W=new T({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBtYXJrZG93bmlmeSUyMGltcG9ydCUyMG1hcmtkb3duaWZ5JTBBZnJvbSUyMHJlcXVlc3RzLmV4Y2VwdGlvbnMlMjBpbXBvcnQlMjBSZXF1ZXN0RXhjZXB0aW9uJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHZpc2l0X3dlYnBhZ2UodXJsJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJWaXNpdHMlMjBhJTIwd2VicGFnZSUyMGF0JTIwdGhlJTIwZ2l2ZW4lMjBVUkwlMjBhbmQlMjByZXR1cm5zJTIwaXRzJTIwY29udGVudCUyMGFzJTIwYSUyMG1hcmtkb3duJTIwc3RyaW5nLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0ElMjBUaGUlMjBVUkwlMjBvZiUyMHRoZSUyMHdlYnBhZ2UlMjB0byUyMHZpc2l0LiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBjb250ZW50JTIwb2YlMjB0aGUlMjB3ZWJwYWdlJTIwY29udmVydGVkJTIwdG8lMjBNYXJrZG93biUyQyUyMG9yJTIwYW4lMjBlcnJvciUyMG1lc3NhZ2UlMjBpZiUyMHRoZSUyMHJlcXVlc3QlMjBmYWlscy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTZW5kJTIwYSUyMEdFVCUyMHJlcXVlc3QlMjB0byUyMHRoZSUyMFVSTCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZS5yYWlzZV9mb3Jfc3RhdHVzKCklMjAlMjAlMjMlMjBSYWlzZSUyMGFuJTIwZXhjZXB0aW9uJTIwZm9yJTIwYmFkJTIwc3RhdHVzJTIwY29kZXMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb252ZXJ0JTIwdGhlJTIwSFRNTCUyMGNvbnRlbnQlMjB0byUyME1hcmtkb3duJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFya2Rvd25fY29udGVudCUyMCUzRCUyMG1hcmtkb3duaWZ5KHJlc3BvbnNlLnRleHQpLnN0cmlwKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZW1vdmUlMjBtdWx0aXBsZSUyMGxpbmUlMjBicmVha3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXJrZG93bl9jb250ZW50JTIwJTNEJTIwcmUuc3ViKHIlMjIlNUNuJTdCMyUyQyU3RCUyMiUyQyUyMCUyMiU1Q24lNUNuJTIyJTJDJTIwbWFya2Rvd25fY29udGVudCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBtYXJrZG93bl9jb250ZW50JTBBJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwUmVxdWVzdEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMGZldGNoaW5nJTIwdGhlJTIwd2VicGFnZSUzQSUyMCU3QnN0cihlKSU3RCUyMiUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJBbiUyMHVuZXhwZWN0ZWQlMjBlcnJvciUyMG9jY3VycmVkJTNBJTIwJTdCc3RyKGUpJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),V=new T({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),$=new xl({props:{title:"构建我们的 multi-agent 系统 🤖🤝🤖",local:"构建我们的-multi-agent-系统-",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwTWFuYWdlZEFnZW50JTJDJTBBJTIwJTIwJTIwJTIwV2ViU2VhcmNoVG9vbCUyQyUwQSUyMCUyMCUyMCUyMExpdGVMTE1Nb2RlbCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    InferenceClientModel,
    ManagedAgent,
    WebSearchTool,
    LiteLLMModel,
)

model = InferenceClientModel(model_id=model_id)

web_agent = ToolCallingAgent(
    tools=[WebSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
    name=<span class="hljs-string">&quot;search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),N=new T({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1QndlYl9hZ2VudCU1RCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIydGltZSUyMiUyQyUyMCUyMm51bXB5JTIyJTJDJTIwJTIycGFuZGFzJTIyJTVEJTJDJTBBKQ==",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),z=new T({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),q=new T({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTEuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMi4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span>
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">1.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">2.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>
<span class="hljs-number">2021.</span>`,wrap:!1}}),K=new cs({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/examples/multiagents.md"}}),{c(){C=a("meta"),sl=M(),O=a("p"),el=M(),U(r.$$.fragment),tl=M(),U(c.$$.fragment),Ml=M(),U(I.$$.fragment),nl=M(),m=a("p"),m.innerHTML=Rl,al=M(),d=a("p"),d.innerHTML=Xl,yl=M(),U(u.$$.fragment),pl=M(),h=a("p"),h.textContent=Ll,Ul=M(),U(b.$$.fragment),wl=M(),g=a("p"),g.textContent=Nl,Jl=M(),U(f.$$.fragment),ol=M(),B=a("p"),B.innerHTML=Yl,il=M(),A=a("p"),A.innerHTML=zl,jl=M(),U(Z.$$.fragment),Tl=M(),U(G.$$.fragment),Cl=M(),k=a("p"),k.innerHTML=Fl,rl=M(),S=a("p"),S.innerHTML=ql,cl=M(),U(W.$$.fragment),Il=M(),v=a("p"),v.textContent=Dl,ml=M(),U(V.$$.fragment),dl=M(),U($.$$.fragment),ul=M(),E=a("p"),E.innerHTML=Pl,hl=M(),Q=a("p"),Q.textContent=Kl,bl=M(),_=a("ul"),_.innerHTML=Ol,gl=M(),U(x.$$.fragment),fl=M(),H=a("p"),H.textContent=ls,Bl=M(),R=a("p"),R.textContent=ss,Al=M(),X=a("p"),X.textContent=es,Zl=M(),L=a("p"),L.textContent=ts,Gl=M(),U(N.$$.fragment),kl=M(),Y=a("p"),Y.textContent=Ms,Sl=M(),U(z.$$.fragment),Wl=M(),F=a("p"),F.textContent=ns,vl=M(),U(q.$$.fragment),Vl=M(),D=a("p"),D.innerHTML=as,$l=M(),P=a("p"),P.textContent=ys,El=M(),U(K.$$.fragment),Ql=M(),ll=a("p"),this.h()},l(l){const s=Ts("svelte-u9bgzb",document.head);C=y(s,"META",{name:!0,content:!0}),s.forEach(e),sl=n(l),O=y(l,"P",{}),ps(O).forEach(e),el=n(l),w(r.$$.fragment,l),tl=n(l),w(c.$$.fragment,l),Ml=n(l),w(I.$$.fragment,l),nl=n(l),m=y(l,"P",{"data-svelte-h":!0}),p(m)!=="svelte-amh8hc"&&(m.innerHTML=Rl),al=n(l),d=y(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-3jtog5"&&(d.innerHTML=Xl),yl=n(l),w(u.$$.fragment,l),pl=n(l),h=y(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-158mc1z"&&(h.textContent=Ll),Ul=n(l),w(b.$$.fragment,l),wl=n(l),g=y(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-s0io30"&&(g.textContent=Nl),Jl=n(l),w(f.$$.fragment,l),ol=n(l),B=y(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1o3zzdj"&&(B.innerHTML=Yl),il=n(l),A=y(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1jij1lg"&&(A.innerHTML=zl),jl=n(l),w(Z.$$.fragment,l),Tl=n(l),w(G.$$.fragment,l),Cl=n(l),k=y(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-k6zb4p"&&(k.innerHTML=Fl),rl=n(l),S=y(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-y90h5t"&&(S.innerHTML=ql),cl=n(l),w(W.$$.fragment,l),Il=n(l),v=y(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1n6x7jk"&&(v.textContent=Dl),ml=n(l),w(V.$$.fragment,l),dl=n(l),w($.$$.fragment,l),ul=n(l),E=y(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1rg4l0k"&&(E.innerHTML=Pl),hl=n(l),Q=y(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1jtsocj"&&(Q.textContent=Kl),bl=n(l),_=y(l,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-996ypc"&&(_.innerHTML=Ol),gl=n(l),w(x.$$.fragment,l),fl=n(l),H=y(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-zr8ob4"&&(H.textContent=ls),Bl=n(l),R=y(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-grh88z"&&(R.textContent=ss),Al=n(l),X=y(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-648qpi"&&(X.textContent=es),Zl=n(l),L=y(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-p7yvhi"&&(L.textContent=ts),Gl=n(l),w(N.$$.fragment,l),kl=n(l),Y=y(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1rgnks8"&&(Y.textContent=Ms),Sl=n(l),w(z.$$.fragment,l),Wl=n(l),F=y(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-6e0l98"&&(F.textContent=ns),vl=n(l),w(q.$$.fragment,l),Vl=n(l),D=y(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1nr8ehj"&&(D.innerHTML=as),$l=n(l),P=y(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1g0vlkz"&&(P.textContent=ys),El=n(l),w(K.$$.fragment,l),Ql=n(l),ll=y(l,"P",{}),ps(ll).forEach(e),this.h()},h(){Us(C,"name","hf:doc:metadata"),Us(C,"content",ds)},m(l,s){Cs(document.head,C),t(l,sl,s),t(l,O,s),t(l,el,s),J(r,l,s),t(l,tl,s),J(c,l,s),t(l,Ml,s),J(I,l,s),t(l,nl,s),t(l,m,s),t(l,al,s),t(l,d,s),t(l,yl,s),J(u,l,s),t(l,pl,s),t(l,h,s),t(l,Ul,s),J(b,l,s),t(l,wl,s),t(l,g,s),t(l,Jl,s),J(f,l,s),t(l,ol,s),t(l,B,s),t(l,il,s),t(l,A,s),t(l,jl,s),J(Z,l,s),t(l,Tl,s),J(G,l,s),t(l,Cl,s),t(l,k,s),t(l,rl,s),t(l,S,s),t(l,cl,s),J(W,l,s),t(l,Il,s),t(l,v,s),t(l,ml,s),J(V,l,s),t(l,dl,s),J($,l,s),t(l,ul,s),t(l,E,s),t(l,hl,s),t(l,Q,s),t(l,bl,s),t(l,_,s),t(l,gl,s),J(x,l,s),t(l,fl,s),t(l,H,s),t(l,Bl,s),t(l,R,s),t(l,Al,s),t(l,X,s),t(l,Zl,s),t(l,L,s),t(l,Gl,s),J(N,l,s),t(l,kl,s),t(l,Y,s),t(l,Sl,s),J(z,l,s),t(l,Wl,s),t(l,F,s),t(l,vl,s),J(q,l,s),t(l,Vl,s),t(l,D,s),t(l,$l,s),t(l,P,s),t(l,El,s),J(K,l,s),t(l,Ql,s),t(l,ll,s),_l=!0},p:Js,i(l){_l||(o(r.$$.fragment,l),o(c.$$.fragment,l),o(I.$$.fragment,l),o(u.$$.fragment,l),o(b.$$.fragment,l),o(f.$$.fragment,l),o(Z.$$.fragment,l),o(G.$$.fragment,l),o(W.$$.fragment,l),o(V.$$.fragment,l),o($.$$.fragment,l),o(x.$$.fragment,l),o(N.$$.fragment,l),o(z.$$.fragment,l),o(q.$$.fragment,l),o(K.$$.fragment,l),_l=!0)},o(l){i(r.$$.fragment,l),i(c.$$.fragment,l),i(I.$$.fragment,l),i(u.$$.fragment,l),i(b.$$.fragment,l),i(f.$$.fragment,l),i(Z.$$.fragment,l),i(G.$$.fragment,l),i(W.$$.fragment,l),i(V.$$.fragment,l),i($.$$.fragment,l),i(x.$$.fragment,l),i(N.$$.fragment,l),i(z.$$.fragment,l),i(q.$$.fragment,l),i(K.$$.fragment,l),_l=!1},d(l){l&&(e(sl),e(O),e(el),e(tl),e(Ml),e(nl),e(m),e(al),e(d),e(yl),e(pl),e(h),e(Ul),e(wl),e(g),e(Jl),e(ol),e(B),e(il),e(A),e(jl),e(Tl),e(Cl),e(k),e(rl),e(S),e(cl),e(Il),e(v),e(ml),e(dl),e(ul),e(E),e(hl),e(Q),e(bl),e(_),e(gl),e(fl),e(H),e(Bl),e(R),e(Al),e(X),e(Zl),e(L),e(Gl),e(kl),e(Y),e(Sl),e(Wl),e(F),e(vl),e(Vl),e(D),e($l),e(P),e(El),e(Ql),e(ll)),e(C),j(r,l),j(c,l),j(I,l),j(u,l),j(b,l),j(f,l),j(Z,l),j(G,l),j(W,l),j(V,l),j($,l),j(x,l),j(N,l),j(z,l),j(q,l),j(K,l)}}}const ds='{"title":"编排 multi-agent 系统 🤖🤝🤖","local":"编排-multi-agent-系统-","sections":[{"title":"🔍 创建网络搜索工具","local":"-创建网络搜索工具","sections":[],"depth":2},{"title":"构建我们的 multi-agent 系统 🤖🤝🤖","local":"构建我们的-multi-agent-系统-","sections":[],"depth":2}],"depth":1}';function us(Hl){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends is{constructor(C){super(),js(this,C,us,ms,ws,{})}}export{As as component};
