import{s as Yl,n as Ll,o as Pl}from"../chunks/scheduler.00b97157.js";import{S as Dl,i as Kl,e as M,s as n,c as p,h as Ol,a as o,d as e,b as a,f as Sl,g as r,j as i,k as Fl,l as lt,m as s,n as c,t as y,o as J,p as u}from"../chunks/index.a7c1a7a1.js";import{C as tt,H as et,E as st}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f42c21e2.js";import{C as E}from"../chunks/CodeBlock.c713f000.js";import{D as nt}from"../chunks/DocNotebookDropdown.be7b60e3.js";function at(gl){let T,Y,S,L,m,P,w,D,j,K,U,Zl="Retrieval-Augmented-Generation (RAG) 是“使用大语言模型（LLM）来回答用户查询，但基于从知识库中检索的信息”。它比使用普通或微调的 LLM 具有许多优势：举几个例子，它允许将答案基于真实事实并减少虚构；它允许提供 LLM 领域特定的知识；并允许对知识库中的信息访问进行精细控制。",O,d,vl="但是，普通的 RAG 存在一些局限性，以下两点尤为突出：",ll,b,Bl="<li>它只执行一次检索步骤：如果结果不好，生成的内容也会不好。</li> <li>语义相似性是以用户查询为参考计算的，这可能不是最优的：例如，用户查询通常是一个问题，而包含真实答案的文档通常是肯定语态，因此其相似性得分会比其他以疑问形式呈现的源文档低，从而导致错失相关信息的风险。</li>",tl,I,Al=`我们可以通过制作一个 RAG  agent来缓解这些问题：非常简单，一个配备了检索工具的agent！这个 agent 将
会：✅ 自己构建查询和检索，✅ 如果需要的话会重新检索。`,el,h,Rl=`因此，它将比普通 RAG 更智能，因为它可以自己构建查询，而不是直接使用用户查询作为参考。这样，它可以更
接近目标文档，从而提高检索的准确性， <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a>。此 agent 可以
使用生成的片段，并在需要时重新检索，就像 <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a>。`,sl,f,_l="我们现在开始构建这个系统. 🛠️",nl,C,kl="运行以下代码以安装所需的依赖包：",al,g,Ml,Z,Gl="你需要一个有效的 token 作为环境变量 <code>HF_TOKEN</code> 来调用 Inference Providers。我们使用 python-dotenv 来加载它。",ol,v,il,B,Nl='我们首先加载一个知识库以在其上执行 RAG：此数据集是许多 Hugging Face 库的文档页面的汇编，存储为 markdown 格式。我们将仅保留 <code>transformers</code> 库的文档。然后通过处理数据集并将其存储到向量数据库中，为检索器准备知识库。我们将使用 <a href="https://python.langchain.com/docs/introduction/" rel="nofollow">LangChain</a> 来利用其出色的向量数据库工具。',pl,A,rl,R,Hl=`现在文档已准备好。我们来一起构建我们的 agent RAG 系统！
👉 我们只需要一个 RetrieverTool，我们的 agent 可以利用它从知识库中检索信息。`,cl,_,Vl='由于我们需要将 vectordb 添加为工具的属性，我们不能简单地使用带有 <code>@tool</code> 装饰器的简单工具构造函数：因此我们将遵循 <a href="../tutorials/tools">tools 教程</a> 中突出显示的高级设置。',yl,k,Jl,G,Wl='BM25 检索方法是一个经典的检索方法，因为它的设置速度非常快。为了提高检索准确性，你可以使用语义搜索，使用文档的向量表示替换 BM25：因此你可以前往 <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> 选择一个好的嵌入模型。',ul,N,Ql=`现在我们已经创建了一个可以从知识库中检索信息的工具，现在我们可以很容易地创建一个利用这个
<code>retriever_tool</code> 的 agent！此 agent 将使用如下参数初始化：`,Tl,H,$l="<li><code>tools</code>：代理将能够调用的工具列表。</li> <li><code>model</code>：为代理提供动力的 LLM。</li>",ml,V,Xl="我们的 <code>model</code> 必须是一个可调用对象，它接受一个消息的 list 作为输入，并返回文本。它还需要接受一个 stop_sequences 参数，指示何时停止生成。为了方便起见，我们直接使用包中提供的 <code>HfEngine</code> 类来获取调用 Hugging Face 的 Inference API 的 LLM 引擎。",wl,W,xl=`接着，我们将使用 <a href="meta-llama/Llama-3.3-70B-Instruct">meta-llama/Llama-3.3-70B-Instruct</a> 作为 llm 引
擎，因为：`,jl,Q,zl="<li>它有一个长 128k 上下文，这对处理长源文档很有用。</li> <li>它在 HF 的 Inference API 上始终免费提供！</li>",Ul,$,ql='<em>Note:</em> 此 Inference API 托管基于各种标准的模型，部署的模型可能会在没有事先通知的情况下进行更新或替换。了解更多信息，请点击<a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">这里</a>。',dl,X,bl,x,El="当我们初始化 CodeAgent 时，它已经自动获得了一个默认的系统提示，告诉 LLM 引擎按步骤处理并生成工具调用作为代码片段，但你可以根据需要替换此提示模板。接着，当其 <code>.run()</code> 方法被调用时，代理将负责调用 LLM 引擎，并在循环中执行工具调用，直到工具 <code>final_answer</code> 被调用，而其参数为最终答案。",Il,z,hl,q,fl,F,Cl;return m=new tt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/rag.ipynb"}]}}),j=new et({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),g=new E({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcGFuZGFzJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHJhbmtfYm0yNSUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents pandas langchain langchain-community sentence-transformers rank_bm25 --upgrade -q",wrap:!1}}),v=new E({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),A=new E({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWtub3dsZWRnZV9iYXNlJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGtub3dsZWRnZV9iYXNlLmZpbHRlcihsYW1iZGElMjByb3clM0ElMjByb3clNUIlMjJzb3VyY2UlMjIlNUQuc3RhcnRzd2l0aCglMjJodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyMikpJTBBJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoJTBBJTIwJTIwJTIwJTIwY2h1bmtfc2l6ZSUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcGFyYXRvcnMlM0QlNUIlMjIlNUNuJTVDbiUyMiUyQyUyMCUyMiU1Q24lMjIlMkMlMjAlMjIuJTIyJTJDJTIwJTIyJTIwJTIyJTJDJTIwJTIyJTIyJTVEJTJDJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3Mp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)`,wrap:!1}}),k=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),X=new E({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIpJTJDJTIwbWF4X3N0ZXBzJTNENCUyQyUyMHZlcmJvc2UlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(
    tools=[retriever_tool], model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>), max_steps=<span class="hljs-number">4</span>, verbose=<span class="hljs-literal">True</span>
)`,wrap:!1}}),z=new E({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkZvciUyMGElMjB0cmFuc2Zvcm1lcnMlMjBtb2RlbCUyMHRyYWluaW5nJTJDJTIwd2hpY2glMjBpcyUyMHNsb3dlciUyQyUyMHRoZSUyMGZvcndhcmQlMjBvciUyMHRoZSUyMGJhY2t3YXJkJTIwcGFzcyUzRiUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`agent_output = agent.run(<span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),q=new st({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/examples/rag.md"}}),{c(){T=M("meta"),Y=n(),S=M("p"),L=n(),p(m.$$.fragment),P=n(),p(w.$$.fragment),D=n(),p(j.$$.fragment),K=n(),U=M("p"),U.textContent=Zl,O=n(),d=M("p"),d.textContent=vl,ll=n(),b=M("ul"),b.innerHTML=Bl,tl=n(),I=M("p"),I.textContent=Al,el=n(),h=M("p"),h.innerHTML=Rl,sl=n(),f=M("p"),f.textContent=_l,nl=n(),C=M("p"),C.textContent=kl,al=n(),p(g.$$.fragment),Ml=n(),Z=M("p"),Z.innerHTML=Gl,ol=n(),p(v.$$.fragment),il=n(),B=M("p"),B.innerHTML=Nl,pl=n(),p(A.$$.fragment),rl=n(),R=M("p"),R.textContent=Hl,cl=n(),_=M("p"),_.innerHTML=Vl,yl=n(),p(k.$$.fragment),Jl=n(),G=M("p"),G.innerHTML=Wl,ul=n(),N=M("p"),N.innerHTML=Ql,Tl=n(),H=M("ul"),H.innerHTML=$l,ml=n(),V=M("p"),V.innerHTML=Xl,wl=n(),W=M("p"),W.innerHTML=xl,jl=n(),Q=M("ul"),Q.innerHTML=zl,Ul=n(),$=M("p"),$.innerHTML=ql,dl=n(),p(X.$$.fragment),bl=n(),x=M("p"),x.innerHTML=El,Il=n(),p(z.$$.fragment),hl=n(),p(q.$$.fragment),fl=n(),F=M("p"),this.h()},l(l){const t=Ol("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(e),Y=a(l),S=o(l,"P",{}),Sl(S).forEach(e),L=a(l),r(m.$$.fragment,l),P=a(l),r(w.$$.fragment,l),D=a(l),r(j.$$.fragment,l),K=a(l),U=o(l,"P",{"data-svelte-h":!0}),i(U)!=="svelte-mhdtwz"&&(U.textContent=Zl),O=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-14tubvl"&&(d.textContent=vl),ll=a(l),b=o(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-16mtzo0"&&(b.innerHTML=Bl),tl=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-xmboum"&&(I.textContent=Al),el=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-lrjdxa"&&(h.innerHTML=Rl),sl=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-2ch6nl"&&(f.textContent=_l),nl=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-54uamx"&&(C.textContent=kl),al=a(l),r(g.$$.fragment,l),Ml=a(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1rvxl6s"&&(Z.innerHTML=Gl),ol=a(l),r(v.$$.fragment,l),il=a(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-77u41g"&&(B.innerHTML=Nl),pl=a(l),r(A.$$.fragment,l),rl=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1jt4w61"&&(R.textContent=Hl),cl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-d65l33"&&(_.innerHTML=Vl),yl=a(l),r(k.$$.fragment,l),Jl=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-8u62jq"&&(G.innerHTML=Wl),ul=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-g2qdob"&&(N.innerHTML=Ql),Tl=a(l),H=o(l,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-1bkhezl"&&(H.innerHTML=$l),ml=a(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1i51m6b"&&(V.innerHTML=Xl),wl=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1bx3er4"&&(W.innerHTML=xl),jl=a(l),Q=o(l,"UL",{"data-svelte-h":!0}),i(Q)!=="svelte-1n3y97g"&&(Q.innerHTML=zl),Ul=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1835ngc"&&($.innerHTML=ql),dl=a(l),r(X.$$.fragment,l),bl=a(l),x=o(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-emwerr"&&(x.innerHTML=El),Il=a(l),r(z.$$.fragment,l),hl=a(l),r(q.$$.fragment,l),fl=a(l),F=o(l,"P",{}),Sl(F).forEach(e),this.h()},h(){Fl(T,"name","hf:doc:metadata"),Fl(T,"content",Mt)},m(l,t){lt(document.head,T),s(l,Y,t),s(l,S,t),s(l,L,t),c(m,l,t),s(l,P,t),c(w,l,t),s(l,D,t),c(j,l,t),s(l,K,t),s(l,U,t),s(l,O,t),s(l,d,t),s(l,ll,t),s(l,b,t),s(l,tl,t),s(l,I,t),s(l,el,t),s(l,h,t),s(l,sl,t),s(l,f,t),s(l,nl,t),s(l,C,t),s(l,al,t),c(g,l,t),s(l,Ml,t),s(l,Z,t),s(l,ol,t),c(v,l,t),s(l,il,t),s(l,B,t),s(l,pl,t),c(A,l,t),s(l,rl,t),s(l,R,t),s(l,cl,t),s(l,_,t),s(l,yl,t),c(k,l,t),s(l,Jl,t),s(l,G,t),s(l,ul,t),s(l,N,t),s(l,Tl,t),s(l,H,t),s(l,ml,t),s(l,V,t),s(l,wl,t),s(l,W,t),s(l,jl,t),s(l,Q,t),s(l,Ul,t),s(l,$,t),s(l,dl,t),c(X,l,t),s(l,bl,t),s(l,x,t),s(l,Il,t),c(z,l,t),s(l,hl,t),c(q,l,t),s(l,fl,t),s(l,F,t),Cl=!0},p:Ll,i(l){Cl||(y(m.$$.fragment,l),y(w.$$.fragment,l),y(j.$$.fragment,l),y(g.$$.fragment,l),y(v.$$.fragment,l),y(A.$$.fragment,l),y(k.$$.fragment,l),y(X.$$.fragment,l),y(z.$$.fragment,l),y(q.$$.fragment,l),Cl=!0)},o(l){J(m.$$.fragment,l),J(w.$$.fragment,l),J(j.$$.fragment,l),J(g.$$.fragment,l),J(v.$$.fragment,l),J(A.$$.fragment,l),J(k.$$.fragment,l),J(X.$$.fragment,l),J(z.$$.fragment,l),J(q.$$.fragment,l),Cl=!1},d(l){l&&(e(Y),e(S),e(L),e(P),e(D),e(K),e(U),e(O),e(d),e(ll),e(b),e(tl),e(I),e(el),e(h),e(sl),e(f),e(nl),e(C),e(al),e(Ml),e(Z),e(ol),e(il),e(B),e(pl),e(rl),e(R),e(cl),e(_),e(yl),e(Jl),e(G),e(ul),e(N),e(Tl),e(H),e(ml),e(V),e(wl),e(W),e(jl),e(Q),e(Ul),e($),e(dl),e(bl),e(x),e(Il),e(hl),e(fl),e(F)),e(T),u(m,l),u(w,l),u(j,l),u(g,l),u(v,l),u(A,l),u(k,l),u(X,l),u(z,l),u(q,l)}}}const Mt='{"title":"Agentic RAG","local":"agentic-rag","sections":[],"depth":1}';function ot(gl){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends Dl{constructor(T){super(),Kl(this,T,ot,at,Yl,{})}}export{Jt as component};
